import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

@Injectable()
export class ItemActions {
    static LOAD_ITEMS = '[ITEMS] Load ITEMS';
    loadItems(scatCode): Action {
        return {
            type: ItemActions.LOAD_ITEMS,
            payload: scatCode
        };
    }
    
    static LOAD_ITEM_SUCCESS = '[ITEMS] Load ITEMS Success';
    loadItemsSuccess(items): Action {
        console.log('[ITEM] Load ITEMS Success',items.length);
        
        if(!items.length)
        {
            items = [];
        }
        return {
            type: ItemActions.LOAD_ITEM_SUCCESS,
            payload: items
        };
        
    }
    
    static RESET_ITEM_LIST = '[ITEM LIST] Reset ITEM LIST';
    resetItemList(): Action {
        return {
            type: ItemActions.RESET_ITEM_LIST
        };
    }
    
    static GET_ITEM = '[ITEM] Get ITEM';
    getItem(itemCode): Action {
        return {
            type: ItemActions.GET_ITEM,
            payload: itemCode.toString()
        };
    }

    static GET_ITEM_SUCCESS = '[ITEM] Get ITEM Success';
    getItemSuccess(item): Action {
        return {
            type: ItemActions.GET_ITEM_SUCCESS,
            payload: item
        };
    }
    
    static RESET_BLANK_ITEM = '[ITEM] Reset Blank ITEM';
    resetBlankItem(): Action {
        return {
            type: ItemActions.RESET_BLANK_ITEM
        };
    }
}