import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ElementRef } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Http } from '@angular/http';
import { EcmTemplateInterface } from './ecm-template.component';
import { ItemDetail } from '../../ecm-model/product-detail-model';
import { EcmRecentViewComponent } from '../../ecm-view/ecm-recent-view/ecm-recent-view.component';

import { EcmCartComponent } from '../../ecm-view/ecm-cart/ecm-cart.component';
import { Item } from '../../ecm-model/product-model';

@Component( {
    selector: 'ecm-training',
    templateUrl: './ecm-general.component.html',
    styleUrls: ['./ecm-general.component.css']
})
export class EcmTrainingComponent implements OnInit, EcmTemplateInterface {

    @Input() itemDetail: ItemDetail;
    @Output() scrollToReviews = new EventEmitter();
    @Output() doActivity = new EventEmitter();
    @ViewChild( 'recentView' ) recentView: EcmRecentViewComponent;
    @ViewChild('itemDetails') itemDetails: ElementRef;
    
    counterValue = 1;
    itemPrice = 1000;
    total = this.itemPrice;
    userActionUrl= '/ecm/service/feeds/cart';
    itemCode;
    myCity;
    actionPerformed 
    activityPerformed ;
    transPortFacility;
    thingsToCarry;
    itemDetailpath;
        
    constructor( private route: ActivatedRoute, private router: Router,   private http: Http ) { }
    ngOnInit() {
        console.log( "ngOnInit EcmTrainingComponent Object Keys : " + Object.keys( this.itemDetail ) )
        console.log( this.itemDetail );
                this.route.params.subscribe( params => {
            this.itemCode = params['key'];
        });

        this.myCity = localStorage.getItem('mycity')
    }
    
    ngAfterViewInit(){
        this.recentView.ngOnInit();
    }
    
    ngOnDestroy() {
        if( this.recentView )
          this.recentView.doDestroy( this.itemDetail.itemCode );
    }
    
    createRatings( ratings ) {
        var rating: number[] = [];
        for ( var i = 1; i <= ratings; i++ ) {
            rating.push( i );
        }
        return rating;
    }

    increment() {
        this.counterValue += 1;
        this.total = this.counterValue * this.itemPrice;
    }

    decrement() {
        this.counterValue -= 1;
        this.total = this.total - this.itemPrice;
    }

    disable() {
        console.log( this.counterValue );
        if ( this.counterValue == 1 )
            return true;
        else
            return false;
    }
    
    scrollToItemDetails() {
        let offsetTop = this.itemDetails.nativeElement.offsetTop;
        window.scrollTo(0, offsetTop + 60); 
    }
    
    getCSV(value:string){
        let attributeValue: Array<string> = [];
        attributeValue = value.split(',');
        
        return attributeValue;
    }
}
 
