import { Component, OnInit, Input, Output,  EventEmitter } from '@angular/core';
import { ECMSigninService } from '../ecm-signin/ecm-signin.service';
import { FormGroupDirective, NgControl, NgForm, NgModel } from '@angular/forms';
@Component( {
    selector: 'change-password',
    templateUrl: './change-password.component.html',
    styleUrls: ['./change-password.component.css'],
    providers: [ECMSigninService]
})
export class ChangePasswordComponent implements OnInit {

    _username: string;
    _password: string;
    _npassword: string;
    statusPending: boolean = false;
    statusErrorMsg: string;
    userData: any;
    _current_password: string;
    _new_password: string;
    _confirm_password: string;
    @Output() closePanel = new EventEmitter();

    constructor( public signinService: ECMSigninService, ) { }

    @Input('activeScreen') activeScreen : string = 'userInfoScreen';
    activeNGForm: NgForm;
    ngOnInit() {

    }

    changePassword(chgForm: NgForm) {
        
        this.signinService.changeCurrentPassword( this.userData.jti, this._new_password, this._current_password, this.userData.TOKEN_ID ).subscribe(
                result => {
                    console.log( 'comp result.results.indexOf [' + result.Response.results.indexOf( '{' ) + ']' );
                    if ( result.Response.status == 'success' ) {
                        console.log( 'Logging Out' );
                        alert(result.Response.results);
                        this.activeScreen = 'successForm';
                        this.userData = null;
                        //TODO Load Login Screen
                        this.closePanel.emit();
                    }
                    else if ( result.Response.status == 'error' ) {
                        chgForm.resetForm();
                    }
                },
                error => {
                    let errorMessage = <any>error;
                    console.log( 'comp errorMessage[' + errorMessage + ']' );
                }
          );
    }

}
