import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
export class EmailValidator {
    constructor() {
        this.validation = false;
    }
    validate(c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        const isValidEmail = this.expression.test(c.value);
        const message = {
            'email': {
                'message': this.invalidMessage
            }
        };
        return isValidEmail ? null : message;
    }
}
EmailValidator.decorators = [
    { type: Directive, args: [{
                selector: '[email-validator]',
                providers: [
                    { provide: NG_VALIDATORS, useExisting: EmailValidator, multi: true }
                ]
            },] },
];
/** @nocollapse */
EmailValidator.ctorParameters = () => [];
EmailValidator.propDecorators = {
    'expression': [{ type: Input, args: ['expression',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'validation': [{ type: Input, args: ['validation',] },],
};
//# sourceMappingURL=email-validator.js.map