import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { BaseBlockComponent } from '../base-block.component';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
export class BBEmailComponent extends BaseBlockComponent {
    constructor(validator) {
        super();
        this.validator = validator;
        this.requiredMessage = 'This field is required';
        this.invalidMessage = 'Please enter Valid Email Address (abc@gmail.com)';
        this.bbExpression = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message
        };
        this.bbType = 'email';
    }
    validate(c) {
        console.log("valadation -------->", c.value);
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidEmail = new RegExp(this.bbExpression, 'i').test(c.value);
        const message = {
            'email': {
                'message': this.invalidMessage
            }
        };
        if (!isValidEmail) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidEmail ? null : message;
    }
}
BBEmailComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-email',
                template: `
      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<input mdInput #email="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		    <md-hint>
      		    	<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      			</md-hint>
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<input  #email="ngModel" [(ngModel)]="value" [type]="bbType" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      		<input  #email="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>

      	</span>
      </span>






      <!-- <span [ngSwitch]="uxDesign"> -->
      <!-- 	<span *ngSwitchCase="'UX3'">  -->
      <!-- 		<md-form-field> -->
      <!-- 			<input email-validator [validation]="bbValidation" [invalidMessage]="invalidMessage" #email="ngModel" mdInput [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [expression]="bbExpression" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/> -->
      <!-- 		</md-form-field>	 -->
      <!-- 		<validation [control]="email" [requiredMessage]="requiredMessage"></validation> -->
      <!-- 	</span> -->
	
      <!-- 	<span *ngSwitchCase="'UX2'"> -->
      <!-- 		<div>{{bbPlaceholder}}</div> -->
      <!-- 		<input [type]="bbType" [value]="bbValue"> -->
      <!-- 	</span> -->
	
	
      <!-- 	<span *ngSwitchCase="'UX1'"> -->
      <!-- 		<input email-validator [validation]="bbValidation" [invalidMessage]="invalidMessage" #email="ngModel" mdInput [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [expression]="bbExpression" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/> -->
      <!-- 		<validation [control]="email" [requiredMessage]="requiredMessage"></validation> -->
      <!-- 	</span> -->
      <!-- </span> -->
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBEmailComponent),
                        multi: true
                    },
                    {
                        provide: NG_VALIDATORS,
                        useExisting: BBEmailComponent,
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBEmailComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBEmailComponent.propDecorators = {
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
};
//# sourceMappingURL=bb-email.component.js.map