import { Component, Input } from '@angular/core';
var ValidationComponent = (function () {
    function ValidationComponent() {
    }
    /*
      private readonly defErrorMessages = {
          'required': () => 'Required field',
          'minlength': ( params ) => 'The min number of characters is ' + params.requiredLength,
          'maxlength': ( params ) => 'The max allowed number of characters is ' + params.requiredLength,
          'email': (params) => params.message,
          'password': (params) => params.message,
          'phone': (params) => params.message
      };
    */
    ValidationComponent.prototype.ngDoCheck = function () {
        console.log('Validation Control: ', this.control, this.customErrors);
        if (this.customErrors) {
            this.localErrors = this.customErrors;
        }
        else if (this.control && this.control.errors) {
            this.localErrors = this.control.errors;
        }
        else {
            this.localErrors = null;
        }
        console.log('After Validation Control: ', this.localErrors);
        this.shouldShowErrors();
    };
    ValidationComponent.prototype.shouldShowErrors = function () {
        return this.localErrors && (this.control.dirty || this.control.touched);
    };
    ValidationComponent.prototype.listOfErrors = function () {
        var _this = this;
        return Object.keys(this.localErrors).map(function (field) { return _this.getMessage(field, _this.localErrors[field]); }).splice(0, 1);
    };
    ValidationComponent.prototype.getMessage = function (type, params) {
        console.log('type', type, 'params', params);
        return this.customErrorMessages[type](params);
    };
    ValidationComponent.decorators = [
        { type: Component, args: [{
                    selector: 'validation',
                    template: "\n    <span *ngIf=\"shouldShowErrors()\">\n      <span style=\"color: #f44336;\" *ngFor=\"let error of listOfErrors()\">{{error}}</span>\n    </span>\n  ",
                    styles: []
                },] },
    ];
    /** @nocollapse */
    ValidationComponent.ctorParameters = function () { return []; };
    ValidationComponent.propDecorators = {
        'control': [{ type: Input, args: ['control',] },],
        'customErrors': [{ type: Input, args: ['errors',] },],
        'customErrorMessages': [{ type: Input, args: ['errorMessages',] },],
    };
    return ValidationComponent;
}());
export { ValidationComponent };
//# sourceMappingURL=validation.js.map