var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { BBInputComponent } from '../key-input.component';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
var BBEmailComponent = (function (_super) {
    __extends(BBEmailComponent, _super);
    function BBEmailComponent(validator) {
        var _this = _super.call(this) || this;
        _this.validator = validator;
        _this.requiredMessage = 'This field is required';
        _this.invalidMessage = 'Please enter Valid Email Address (abc@gmail.com)';
        _this.bbExpression = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        _this.customErrorMessages = {
            'required': function () { return _this.requiredMessage; },
            'minlength': function (params) { return 'The min number of characters is ' + params.requiredLength; },
            'maxlength': function (params) { return 'The max allowed number of characters is ' + params.requiredLength; },
            'email': function (params) { return params.message; },
            'password': function (params) { return params.message; },
            'phone': function (params) { return params.message; }
        };
        _this.bbType = 'email';
        return _this;
    }
    BBEmailComponent.prototype.validate = function (c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        var isValidEmail = this.bbExpression.test(c.value);
        var message = {
            'email': {
                'message': this.invalidMessage
            }
        };
        if (!isValidEmail) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidEmail ? null : message;
    };
    BBEmailComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-email',
                    template: "\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX3'\"> \n      \t\t<md-form-field>\n      \t\t\t<input mdInput #email=\"ngModel\" [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxlength]=\"bbMaxlength\" [minlength]=\"bbMinlength\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\"/>\n      \t\t    <md-hint>\n      \t\t    \t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t\t\t</md-hint>\n      \t\t</md-form-field>\t\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX2'\">\n      \t\t<div>{{bbPlaceholder}}</div>\n      \t\t<input [type]=\"bbType\" [value]=\"bbValue\">\n      \t</span>\n\t\n\t\n      \t<span *ngSwitchCase=\"'UX1'\">\n      \t\t<input mdInput #email=\"ngModel\" [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxlength]=\"bbMaxlength\" [minlength]=\"bbMinlength\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\"/>\n      \t\t\t\t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t</span>\n      </span>\n\n\n\n\n\n\n\n\n\n\n\n      <!-- <span [ngSwitch]=\"uxDesign\"> -->\n      <!-- \t<span *ngSwitchCase=\"'UX3'\">  -->\n      <!-- \t\t<md-form-field> -->\n      <!-- \t\t\t<input email-validator [validation]=\"bbValidation\" [invalidMessage]=\"invalidMessage\" #email=\"ngModel\" mdInput [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxlength]=\"bbMaxlength\" [minlength]=\"bbMinlength\" [expression]=\"bbExpression\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\"/> -->\n      <!-- \t\t</md-form-field>\t -->\n      <!-- \t\t<validation [control]=\"email\" [requiredMessage]=\"requiredMessage\"></validation> -->\n      <!-- \t</span> -->\n\t\n      <!-- \t<span *ngSwitchCase=\"'UX2'\"> -->\n      <!-- \t\t<div>{{bbPlaceholder}}</div> -->\n      <!-- \t\t<input [type]=\"bbType\" [value]=\"bbValue\"> -->\n      <!-- \t</span> -->\n\t\n\t\n      <!-- \t<span *ngSwitchCase=\"'UX1'\"> -->\n      <!-- \t\t<input email-validator [validation]=\"bbValidation\" [invalidMessage]=\"invalidMessage\" #email=\"ngModel\" mdInput [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxlength]=\"bbMaxlength\" [minlength]=\"bbMinlength\" [expression]=\"bbExpression\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\"/> -->\n      <!-- \t\t<validation [control]=\"email\" [requiredMessage]=\"requiredMessage\"></validation> -->\n      <!-- \t</span> -->\n      <!-- </span> -->\n    ",
                    styles: ["\n\n    "],
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: forwardRef(function () { return BBEmailComponent; }),
                            multi: true
                        },
                        {
                            provide: NG_VALIDATORS,
                            useExisting: BBEmailComponent,
                            multi: true
                        }
                    ]
                },] },
    ];
    /** @nocollapse */
    BBEmailComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
    ]; };
    BBEmailComponent.propDecorators = {
        'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
        'bbExpression': [{ type: Input, args: ['expression',] },],
        'model': [{ type: ViewChild, args: [NgModel,] },],
    };
    return BBEmailComponent;
}(BBInputComponent));
export { BBEmailComponent };
//# sourceMappingURL=bb-email.component.js.map