/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.ChannelFastInputStream;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MemOutputStream;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLog {
    public static Logger log = LoggerFactory.getLogger(TransactionLog.class);
    final boolean debug = log.isDebugEnabled();
    final boolean trace = log.isTraceEnabled();
    public static final String END_MESSAGE = "SOLR_TLOG_END";
    long id;
    File tlogFile;
    RandomAccessFile raf;
    FileChannel channel;
    OutputStream os;
    FastOutputStream fos;
    int numRecords;
    protected volatile boolean deleteOnClose = true;
    AtomicInteger refcount = new AtomicInteger(1);
    Map<String, Integer> globalStringMap = new HashMap<String, Integer>();
    List<String> globalStringList = new ArrayList<String>();
    long snapshot_size;
    int snapshot_numRecords;
    JavaBinCodec.ObjectResolver resolver = new JavaBinCodec.ObjectResolver(){

        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            if (o instanceof BytesRef) {
                BytesRef br = (BytesRef)o;
                codec.writeByteArray(br.bytes, br.offset, br.length);
                return null;
            }
            return o;
        }
    };
    int lastAddSize;

    TransactionLog(File tlogFile, Collection<String> globalStrings) {
        this(tlogFile, globalStrings, false);
    }

    TransactionLog(File tlogFile, Collection<String> globalStrings, boolean openExisting) {
        boolean success = false;
        try {
            if (this.debug) {
                log.debug("New TransactionLog file=" + tlogFile + ", exists=" + tlogFile.exists() + ", size=" + tlogFile.length() + ", openExisting=" + openExisting);
            }
            this.tlogFile = tlogFile;
            this.raf = new RandomAccessFile(this.tlogFile, "rw");
            long start = this.raf.length();
            this.channel = this.raf.getChannel();
            this.os = Channels.newOutputStream(this.channel);
            this.fos = new FastOutputStream(this.os, new byte[65536], 0);
            if (openExisting) {
                if (start > 0L) {
                    this.readHeader(null);
                    this.raf.seek(start);
                    assert (this.channel.position() == start);
                    this.fos.setWritten(start);
                    assert (this.fos.size() == this.channel.size());
                } else {
                    this.addGlobalStrings(globalStrings);
                }
            } else {
                if (start > 0L) {
                    log.warn("New transaction log already exists:" + tlogFile + " size=" + this.raf.length());
                    return;
                }
                if (start > 0L) {
                    this.raf.setLength(0L);
                }
                this.addGlobalStrings(globalStrings);
            }
            success = true;
            assert (ObjectReleaseTracker.track((Object)this));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            if (!success && this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (Exception e) {
                    log.error("Error closing tlog file (after error opening)", (Throwable)e);
                }
            }
        }
    }

    protected TransactionLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numRecords() {
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            return this.numRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endsWithCommit() throws IOException {
        long size;
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            this.fos.flush();
            size = this.fos.size();
        }
        byte[] buf = new byte[END_MESSAGE.length()];
        long pos = size - (long)END_MESSAGE.length() - 4L;
        if (pos < 0L) {
            return false;
        }
        ChannelFastInputStream is = new ChannelFastInputStream(this.channel, pos);
        is.read(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == END_MESSAGE.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long snapshot() {
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            this.snapshot_size = this.fos.size();
            this.snapshot_numRecords = this.numRecords;
            return this.snapshot_size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(long pos) throws IOException {
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            assert (this.snapshot_size == pos);
            this.fos.flush();
            this.raf.setLength(pos);
            this.fos.setWritten(pos);
            assert (this.fos.size() == pos);
            this.numRecords = this.snapshot_numRecords;
        }
    }

    public long writeData(Object o) {
        LogCodec codec = new LogCodec(this.resolver);
        try {
            long pos = this.fos.size();
            codec.init(this.fos);
            codec.writeVal(o);
            return pos;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader(FastInputStream fis) throws IOException {
        fis = fis != null ? fis : new ChannelFastInputStream(this.channel, 0L);
        LogCodec codec = new LogCodec(this.resolver);
        Map header = (Map)codec.unmarshal((InputStream)fis);
        fis.readInt();
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            this.globalStringList = (List)header.get("strings");
            this.globalStringMap = new HashMap<String, Integer>(this.globalStringList.size());
            for (int i = 0; i < this.globalStringList.size(); ++i) {
                this.globalStringMap.put(this.globalStringList.get(i), i + 1);
            }
        }
    }

    protected void addGlobalStrings(Collection<String> strings) {
        if (strings == null) {
            return;
        }
        int origSize = this.globalStringMap.size();
        for (String s : strings) {
            Integer idx = null;
            if (origSize > 0) {
                idx = this.globalStringMap.get(s);
            }
            if (idx != null) continue;
            this.globalStringList.add(s);
            this.globalStringMap.put(s, this.globalStringList.size());
        }
        assert (this.globalStringMap.size() == this.globalStringList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getGlobalStrings() {
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            return new ArrayList<String>(this.globalStringList);
        }
    }

    protected void writeLogHeader(LogCodec codec) throws IOException {
        long pos = this.fos.size();
        assert (pos == 0L);
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
        header.put("SOLR_TLOG", 1);
        header.put("strings", this.globalStringList);
        codec.marshal(header, (OutputStream)this.fos);
        this.endRecord(pos);
    }

    protected void endRecord(long startRecordPosition) throws IOException {
        this.fos.writeInt((int)(this.fos.size() - startRecordPosition));
        ++this.numRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWriteHeader(LogCodec codec, SolrInputDocument optional) throws IOException {
        if (this.fos.size() != 0L) {
            return;
        }
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            if (this.fos.size() != 0L) {
                return;
            }
            if (optional != null) {
                this.addGlobalStrings(optional.getFieldNames());
            }
            this.writeLogHeader(codec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(AddUpdateCommand cmd, int flags) {
        LogCodec codec = new LogCodec(this.resolver);
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        try {
            this.checkWriteHeader(codec, sdoc);
            int bufSize = this.lastAddSize;
            bufSize = Math.min(0x100000, bufSize + (bufSize >> 3) + 256);
            MemOutputStream out = new MemOutputStream(new byte[bufSize]);
            codec.init(out);
            codec.writeTag((byte)-128, 3);
            codec.writeInt(1 | flags);
            codec.writeLong(cmd.getVersion());
            codec.writeSolrInputDocument(cmd.getSolrInputDocument());
            this.lastAddSize = (int)out.size();
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                long pos = this.fos.size();
                assert (pos != 0L);
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error logging add", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeDelete(DeleteUpdateCommand cmd, int flags) {
        LogCodec codec = new LogCodec(this.resolver);
        try {
            this.checkWriteHeader(codec, null);
            BytesRef br = cmd.getIndexedId();
            MemOutputStream out = new MemOutputStream(new byte[20 + br.length]);
            codec.init(out);
            codec.writeTag((byte)-128, 3);
            codec.writeInt(2 | flags);
            codec.writeLong(cmd.getVersion());
            codec.writeByteArray(br.bytes, br.offset, br.length);
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                long pos = this.fos.size();
                assert (pos != 0L);
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeDeleteByQuery(DeleteUpdateCommand cmd, int flags) {
        LogCodec codec = new LogCodec(this.resolver);
        try {
            this.checkWriteHeader(codec, null);
            MemOutputStream out = new MemOutputStream(new byte[20 + cmd.query.length()]);
            codec.init(out);
            codec.writeTag((byte)-128, 3);
            codec.writeInt(3 | flags);
            codec.writeLong(cmd.getVersion());
            codec.writeStr(cmd.query);
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                long pos = this.fos.size();
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public long writeCommit(CommitUpdateCommand cmd, int flags) {
        LogCodec codec = new LogCodec(this.resolver);
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            try {
                long pos = this.fos.size();
                if (pos == 0L) {
                    this.writeLogHeader(codec);
                    pos = this.fos.size();
                }
                codec.init(this.fos);
                codec.writeTag((byte)-128, 3);
                codec.writeInt(4 | flags);
                codec.writeLong(cmd.getVersion());
                codec.writeStr(END_MESSAGE);
                this.endRecord(pos);
                this.fos.flush();
                assert (this.fos.size() == this.channel.size());
                return pos;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(long pos) {
        if (pos < 0L) {
            return null;
        }
        try {
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                this.fos.flushBuffer();
            }
            ChannelFastInputStream fis = new ChannelFastInputStream(this.channel, pos);
            LogCodec codec = new LogCodec(this.resolver);
            return codec.readVal((DataInputInputStream)fis);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public void incref() {
        int result = this.refcount.incrementAndGet();
        if (result <= 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "incref on a closed log: " + this);
        }
    }

    public boolean try_incref() {
        return this.refcount.incrementAndGet() > 1;
    }

    public void decref() {
        if (this.refcount.decrementAndGet() == 0) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() {
        TransactionLog transactionLog = this;
        synchronized (transactionLog) {
            return this.fos.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(UpdateLog.SyncLevel syncLevel) {
        if (syncLevel == UpdateLog.SyncLevel.NONE) {
            return;
        }
        try {
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                this.fos.flushBuffer();
            }
            if (syncLevel == UpdateLog.SyncLevel.FSYNC) {
                this.raf.getFD().sync();
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        try {
            if (this.debug) {
                log.debug("Closing tlog" + this);
            }
            TransactionLog transactionLog = this;
            synchronized (transactionLog) {
                this.fos.flush();
                this.fos.close();
            }
            if (this.deleteOnClose) {
                try {
                    Files.deleteIfExists(this.tlogFile.toPath());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            assert (ObjectReleaseTracker.release((Object)this));
        }
    }

    public void forceClose() {
        if (this.refcount.get() > 0) {
            log.error("Error: Forcing close of " + this);
            this.refcount.set(0);
            this.close();
        }
    }

    public String toString() {
        return "tlog{file=" + this.tlogFile.toString() + " refcount=" + this.refcount.get() + "}";
    }

    public long getLogSize() {
        if (this.tlogFile != null) {
            return this.tlogFile.length();
        }
        return 0L;
    }

    public LogReader getReader(long startingPos) {
        return new LogReader(startingPos);
    }

    public ReverseReader getReverseReader() throws IOException {
        return new FSReverseReader();
    }

    public class FSReverseReader
    extends ReverseReader {
        ChannelFastInputStream fis;
        private LogCodec codec;
        int nextLength;
        long prevPos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FSReverseReader() throws IOException {
            long sz;
            this.codec = new LogCodec(TransactionLog.this.resolver){

                public SolrInputDocument readSolrInputDocument(DataInputInputStream dis) {
                    return null;
                }
            };
            TransactionLog.this.incref();
            TransactionLog transactionLog2 = TransactionLog.this;
            synchronized (transactionLog2) {
                TransactionLog.this.fos.flushBuffer();
                sz = TransactionLog.this.fos.size();
                assert (sz == TransactionLog.this.channel.size());
            }
            this.fis = new ChannelFastInputStream(TransactionLog.this.channel, 0L);
            if (sz >= 4L) {
                this.prevPos = sz - 4L;
                this.fis.seek(this.prevPos);
                this.nextLength = this.fis.readInt();
            }
        }

        @Override
        public Object next() throws IOException {
            if (this.prevPos <= 0L) {
                return null;
            }
            long endOfThisRecord = this.prevPos;
            int thisLength = this.nextLength;
            long recordStart = this.prevPos - (long)thisLength;
            this.prevPos = recordStart - 4L;
            if (this.prevPos <= 0L) {
                return null;
            }
            long bufferPos = this.fis.getBufferPos();
            if (this.prevPos < bufferPos) {
                long seekPos = endOfThisRecord - (long)this.fis.getBufferSize();
                seekPos = Math.min(seekPos, this.prevPos);
                seekPos = Math.max(seekPos, 0L);
                this.fis.seek(seekPos);
                this.fis.peek();
            }
            this.fis.seek(this.prevPos);
            this.nextLength = this.fis.readInt();
            Object o = this.codec.readVal((DataInputInputStream)this.fis);
            return o;
        }

        @Override
        public long position() {
            return this.prevPos + 4L;
        }

        @Override
        public void close() {
            TransactionLog.this.decref();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            TransactionLog transactionLog = TransactionLog.this;
            synchronized (transactionLog) {
                return "LogReader{file=" + TransactionLog.this.tlogFile + ", position=" + this.fis.position() + ", end=" + TransactionLog.this.fos.size() + "}";
            }
        }
    }

    public abstract class ReverseReader {
        public abstract Object next() throws IOException;

        public abstract long position();

        public abstract void close();

        public abstract String toString();
    }

    public class LogReader {
        private ChannelFastInputStream fis;
        private LogCodec codec;

        public LogReader(long startingPos) {
            this.codec = new LogCodec(TransactionLog.this.resolver);
            TransactionLog.this.incref();
            this.fis = new ChannelFastInputStream(TransactionLog.this.channel, startingPos);
        }

        protected LogReader() {
            this.codec = new LogCodec(TransactionLog.this.resolver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() throws IOException, InterruptedException {
            long pos = this.fis.position();
            TransactionLog transactionLog = TransactionLog.this;
            synchronized (transactionLog) {
                if (TransactionLog.this.trace) {
                    log.trace("Reading log record.  pos=" + pos + " currentSize=" + TransactionLog.this.fos.size());
                }
                if (pos >= TransactionLog.this.fos.size()) {
                    return null;
                }
                TransactionLog.this.fos.flushBuffer();
            }
            if (pos == 0L) {
                TransactionLog.this.readHeader(this.fis);
                transactionLog = TransactionLog.this;
                synchronized (transactionLog) {
                    if (this.fis.position() >= TransactionLog.this.fos.size()) {
                        return null;
                    }
                    pos = this.fis.position();
                }
            }
            Object o = this.codec.readVal((DataInputInputStream)this.fis);
            int size = this.fis.readInt();
            assert ((long)size == this.fis.position() - pos - 4L);
            return o;
        }

        public void close() {
            TransactionLog.this.decref();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            TransactionLog transactionLog = TransactionLog.this;
            synchronized (transactionLog) {
                return "LogReader{file=" + TransactionLog.this.tlogFile + ", position=" + this.fis.position() + ", end=" + TransactionLog.this.fos.size() + "}";
            }
        }

        public long currentPos() {
            return this.fis.position();
        }

        public long currentSize() throws IOException {
            return TransactionLog.this.channel.size();
        }
    }

    public class LogCodec
    extends JavaBinCodec {
        public LogCodec(JavaBinCodec.ObjectResolver resolver) {
            super(resolver);
        }

        public void writeExternString(String s) throws IOException {
            if (s == null) {
                this.writeTag((byte)0);
                return;
            }
            Integer idx = TransactionLog.this.globalStringMap.get(s);
            if (idx == null) {
                this.writeStr(s);
            } else {
                this.writeTag((byte)-32, idx);
            }
        }

        public String readExternString(DataInputInputStream fis) throws IOException {
            int idx = this.readSize(fis);
            if (idx != 0) {
                return TransactionLog.this.globalStringList.get(idx - 1);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Corrupt transaction log");
        }
    }
}

