/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.Collection;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.RangeConditionContext;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.BetweenOperator;
import org.infinispan.query.dsl.impl.ContainsAllOperator;
import org.infinispan.query.dsl.impl.ContainsAnyOperator;
import org.infinispan.query.dsl.impl.ContainsOperator;
import org.infinispan.query.dsl.impl.EqOperator;
import org.infinispan.query.dsl.impl.GtOperator;
import org.infinispan.query.dsl.impl.GteOperator;
import org.infinispan.query.dsl.impl.InOperator;
import org.infinispan.query.dsl.impl.IsNullOperator;
import org.infinispan.query.dsl.impl.LikeOperator;
import org.infinispan.query.dsl.impl.LtOperator;
import org.infinispan.query.dsl.impl.LteOperator;
import org.infinispan.query.dsl.impl.OperatorAndArgument;
import org.infinispan.query.dsl.impl.ValueRange;
import org.infinispan.query.dsl.impl.Visitor;

class AttributeCondition
extends BaseCondition
implements FilterConditionEndContext,
RangeConditionContext {
    private final String attributePath;
    private boolean isNegated;
    private OperatorAndArgument operatorAndArgument;

    public AttributeCondition(QueryFactory queryFactory, String attributePath) {
        super(queryFactory);
        this.attributePath = attributePath;
    }

    OperatorAndArgument getOperatorAndArgument() {
        return this.operatorAndArgument;
    }

    String getAttributePath() {
        return this.attributePath;
    }

    boolean isNegated() {
        return this.isNegated;
    }

    void setNegated(boolean negated) {
        this.isNegated = negated;
    }

    @Override
    public FilterConditionContext in(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("The list of values for 'in(..)' cannot be null or empty");
        }
        this.setOperatorAndArgument(new InOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext in(Collection values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("The list of values for 'in(..)' cannot be null or empty");
        }
        this.setOperatorAndArgument(new InOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext like(String pattern) {
        this.setOperatorAndArgument(new LikeOperator(this, pattern));
        return this;
    }

    @Override
    public FilterConditionContext contains(Object value) {
        this.setOperatorAndArgument(new ContainsOperator(this, value));
        return this;
    }

    @Override
    public FilterConditionContext containsAll(Object ... values) {
        this.setOperatorAndArgument(new ContainsAllOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext containsAll(Collection values) {
        this.setOperatorAndArgument(new ContainsAllOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext containsAny(Object ... values) {
        this.setOperatorAndArgument(new ContainsAnyOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext containsAny(Collection values) {
        this.setOperatorAndArgument(new ContainsAnyOperator(this, values));
        return this;
    }

    @Override
    public FilterConditionContext isNull() {
        this.setOperatorAndArgument(new IsNullOperator(this));
        return this;
    }

    @Override
    public FilterConditionContext eq(Object value) {
        this.setOperatorAndArgument(new EqOperator(this, value));
        return this;
    }

    @Override
    public FilterConditionContext lt(Object value) {
        this.setOperatorAndArgument(new LtOperator(this, value));
        return this;
    }

    @Override
    public FilterConditionContext lte(Object value) {
        this.setOperatorAndArgument(new LteOperator(this, value));
        return this;
    }

    @Override
    public FilterConditionContext gt(Object value) {
        this.setOperatorAndArgument(new GtOperator(this, value));
        return this;
    }

    @Override
    public FilterConditionContext gte(Object value) {
        this.setOperatorAndArgument(new GteOperator(this, value));
        return this;
    }

    @Override
    public RangeConditionContext between(Object from, Object to) {
        this.setOperatorAndArgument(new BetweenOperator(this, new ValueRange(from, to)));
        return this;
    }

    @Override
    public RangeConditionContext includeLower(boolean includeLower) {
        ValueRange valueRange = (ValueRange)this.operatorAndArgument.getArgument();
        valueRange.setIncludeLower(includeLower);
        return this;
    }

    @Override
    public RangeConditionContext includeUpper(boolean includeUpper) {
        ValueRange valueRange = (ValueRange)this.operatorAndArgument.getArgument();
        valueRange.setIncludeUpper(includeUpper);
        return this;
    }

    private void setOperatorAndArgument(OperatorAndArgument operatorAndArgument) {
        operatorAndArgument.validate();
        if (this.operatorAndArgument != null) {
            throw new IllegalStateException("operator was already specified");
        }
        this.operatorAndArgument = operatorAndArgument;
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "AttributeCondition{isNegated=" + this.isNegated + ", attributePath='" + this.attributePath + '\'' + ", operatorAndArgument=" + this.operatorAndArgument + '}';
    }
}

