/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateful;

import java.io.Serializable;
import javax.ejb.EJBObject;
import javax.ejb.RemoteHome;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.proxy.handler.stateful.StatefulRemoteProxyInvocationHandler;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.ejb3.stateful.StatefulHandleRemoteImpl;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStatefulRemoteProxyFactory
extends BaseStatefulProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatefulRemoteProxyFactory.class);
    private RemoteBinding binding;
    private InvokerLocator locator;

    public BaseStatefulRemoteProxyFactory(SessionSpecContainer container, RemoteBinding binding) {
        super(container, ProxyFactoryHelper.getRemoteBusinessJndiName((EJBContainer)container));
        this.binding = binding;
        try {
            String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.getBinding());
            this.locator = new InvokerLocator(clientBindUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ProxyAccessType getProxyAccessType() {
        return ProxyAccessType.REMOTE;
    }

    @Override
    protected void validateEjb21Views() {
        SessionSpecContainer container = this.getContainer();
        RemoteHome remoteHome = container.getAnnotation(RemoteHome.class);
        this.validateEjb21Views(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces((Container)container));
    }

    @Override
    public Object createProxyBusiness() {
        return this.createProxyBusiness(null);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceType) {
        Serializable id = this.getContainer().createSession();
        return this.createProxyBusiness(id, businessInterfaceType);
    }

    public Object createProxyBusiness(Object id, String businessInterfaceType) {
        return this.createProxy(id, SpecificationInterfaceType.EJB30_BUSINESS, businessInterfaceType);
    }

    abstract String getStackNameInterceptors();

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        SessionSpecContainer container = this.getContainer();
        String homeJndiName = ProxyFactoryHelper.getHomeJndiName((EJBContainer)container);
        String remoteBusinessJndiName = ProxyFactoryHelper.getRemoteBusinessJndiName((EJBContainer)container);
        return homeJndiName.equals(remoteBusinessJndiName);
    }

    protected Object createProxy(Object id, SpecificationInterfaceType type, String businessInterfaceType) {
        AdviceStack stack;
        String stackName = this.getStackNameInterceptors();
        RemoteBinding binding = this.getBinding();
        if (binding.interceptorStack() != null && !binding.interceptorStack().trim().equals("")) {
            stackName = binding.interceptorStack();
        }
        if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
            throw new RuntimeException("unable to find interceptor stack: " + stackName);
        }
        StatefulRemoteProxyInvocationHandler proxy = new StatefulRemoteProxyInvocationHandler((Container)this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), this.getLocator(), id, businessInterfaceType);
        if (type.equals((Object)SpecificationInterfaceType.EJB21)) {
            this.getContainer();
            return this.constructEjb21Proxy(proxy);
        }
        return this.constructProxyBusiness(proxy);
    }

    @Override
    protected StatefulHandleRemoteImpl createHandle() {
        EJBObject proxy = this.createProxyEjb21(null);
        return this.createHandle(proxy);
    }

    protected StatefulHandleRemoteImpl createHandle(EJBObject proxy) {
        StatefulHandleRemoteImpl handle = new StatefulHandleRemoteImpl(proxy);
        return handle;
    }

    public EJBObject createProxyEjb21(String businessInterfaceType) {
        Serializable id = this.getContainer().createSession();
        return this.createProxyEjb21(id, businessInterfaceType);
    }

    public <T extends EJBObject> T createProxyEjb21(Object id, String businessInterfaceType) {
        return (T)((EJBObject)this.createProxy(id, SpecificationInterfaceType.EJB21, businessInterfaceType));
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    RemoteBinding getBinding() {
        assert (this.binding != null) : "RemoteBinding has not been initialized";
        return this.binding;
    }

    InvokerLocator getLocator() {
        assert (this.locator != null) : "InvokerLocator has not been initialized";
        return this.locator;
    }
}

