/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Listener(primaryOnly=true)
public class RemoteClusterListener {
    private static final Log log = LogFactory.getLog(RemoteClusterListener.class);
    private final UUID id;
    private final Address origin;
    private final DistributedExecutorService distExecService;
    private final CacheNotifier cacheNotifier;
    private final CacheManagerNotifier cacheManagerNotifier;
    private final ClusterEventManager eventManager;
    private final boolean sync;
    private final ConcurrentMap<GlobalTransaction, Queue<CacheEntryEvent>> transactionChanges = CollectionFactory.makeConcurrentMap();

    public RemoteClusterListener(UUID id, Address origin, DistributedExecutorService distExecService, CacheNotifier cacheNotifier, CacheManagerNotifier cacheManagerNotifier, ClusterEventManager eventManager, boolean sync) {
        this.id = id;
        this.origin = origin;
        this.distExecService = distExecService;
        this.cacheNotifier = cacheNotifier;
        this.cacheManagerNotifier = cacheManagerNotifier;
        this.eventManager = eventManager;
        this.sync = sync;
    }

    public UUID getId() {
        return this.id;
    }

    public Address getOwnerAddress() {
        return this.origin;
    }

    @ViewChanged
    public void viewChange(ViewChangedEvent event) {
        if (!event.getNewMembers().contains(this.origin)) {
            if (log.isTraceEnabled()) {
                log.tracef("Origin %s storing cluster listener is gone, removing local listener", this.origin);
            }
            this.removeListener();
        }
    }

    public void removeListener() {
        this.cacheNotifier.removeListener(this);
        this.cacheManagerNotifier.removeListener(this);
    }

    @CacheEntryCreated
    @CacheEntryModified
    @CacheEntryRemoved
    public void handleClusterEvents(CacheEntryEvent event) throws Exception {
        if (!event.isPre()) {
            GlobalTransaction transaction = event.getGlobalTransaction();
            if (transaction != null) {
                Queue otherQueue;
                Queue events = (ConcurrentLinkedQueue<CacheEntryEvent>)this.transactionChanges.get(transaction);
                if (events == null && (otherQueue = (Queue)this.transactionChanges.putIfAbsent(transaction, events = new ConcurrentLinkedQueue<CacheEntryEvent>())) != null) {
                    events = otherQueue;
                }
                events.add(event);
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Submitting Event %s to cluster listener to %s", event, this.origin);
                }
                this.eventManager.addEvents(this.origin, this.id, Collections.singleton(ClusterEvent.fromEvent(event)), this.sync);
            }
        }
    }

    @TransactionCompleted
    public void transactionCompleted(TransactionCompletedEvent event) throws Exception {
        Queue events = (Queue)this.transactionChanges.remove(event.getGlobalTransaction());
        if (event.isTransactionSuccessful() && events != null) {
            ArrayList eventsToSend = new ArrayList(events.size());
            for (CacheEntryEvent cacheEvent : events) {
                eventsToSend.add(ClusterEvent.fromEvent(cacheEvent));
                if (!log.isTraceEnabled()) continue;
                log.tracef("Submitting Event(s) %s to cluster listener to %s", eventsToSend, this.origin);
            }
            this.eventManager.addEvents(this.origin, this.id, eventsToSend, this.sync);
        }
    }
}

