/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.format;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PropertyFormatter {
    private static final Log log = LogFactory.getLog(PropertyFormatter.class);
    private static Method plainToString = null;
    private String globalConfigPrefix = "";
    private String configPrefix = "";

    public PropertyFormatter() {
        this("", "");
    }

    public PropertyFormatter(String globalConfigPrefix, String configPrefix) {
        this.globalConfigPrefix = globalConfigPrefix;
        this.configPrefix = configPrefix;
    }

    private static List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> r = new ArrayList<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                r.add(m);
            }
        }
        return r;
    }

    private static boolean hasPlainToString(Class<?> cls, Object obj) {
        try {
            if (cls.getMethod("toString", new Class[0]) == plainToString) {
                return true;
            }
            String plainToStringValue = cls.getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
            return plainToStringValue.equals(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void reflect(Object obj, Properties p, String prefix) {
        try {
            if (obj == null) {
                p.put(prefix, "null");
                return;
            }
            Class<?> cls = obj.getClass();
            if (cls.getName().startsWith("org.infinispan.config") && !cls.isEnum()) {
                for (Method m : PropertyFormatter.getMethods(obj.getClass())) {
                    if (m.getParameterTypes().length != 0 || "toString".equals(m.getName()) || "hashCode".equals(m.getName()) || "toProperties".equals(m.getName())) continue;
                    try {
                        String prefixDot = prefix == null || "".equals(prefix) ? "" : prefix + ".";
                        PropertyFormatter.reflect(m.invoke(obj, new Object[0]), p, prefixDot + m.getName());
                    }
                    catch (IllegalAccessException e) {}
                }
            } else if (Collection.class.isAssignableFrom(cls)) {
                Collection collection = (Collection)obj;
                Iterator iter = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    PropertyFormatter.reflect(iter.next(), p, prefix + "[" + i + "]");
                }
            } else if (cls.isArray()) {
                Object[] a = (Object[])obj;
                for (int i = 0; i < a.length; ++i) {
                    PropertyFormatter.reflect(a[i], p, prefix + "[" + i + "]");
                }
            } else if (PropertyFormatter.hasPlainToString(cls, obj)) {
                p.put(prefix, cls.getName());
            } else {
                p.put(prefix, obj.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Properties format(Configuration configuration) {
        Properties properties = new Properties();
        PropertyFormatter.reflect(configuration, properties, this.configPrefix);
        return properties;
    }

    public Properties format(GlobalConfiguration configuration) {
        Properties properties = new Properties();
        PropertyFormatter.reflect(configuration, properties, this.globalConfigPrefix);
        return properties;
    }

    static {
        try {
            plainToString = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            log.error("Error while initializing", e);
        }
    }
}

