package ibase.dashboard.sfa.ejb;

import javax.ejb.Stateless;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import ibase.system.config.ConnDriver;

/**
 * Session Bean implementation class DashboardPortal
 */
@Stateless
public class ExpenseProcessStatus extends ValidatorEJB implements ExpenseProcessStatusRemote, ExpenseProcessStatusLocal
{

	/**
	 * Default constructor.
	 */

	String salePersn = "";

	public String getSalePersn()
	{
		return salePersn;
	}

	public void setSalePersn(String salePersn)
	{
		this.salePersn = salePersn;
	}

	public ExpenseProcessStatus()
	{

		// TODO Auto-generated constructor stub
	}

	public String getData() throws RemoteException, ITMException
	{
		return "";
	}

	/*
	 * private Connection getConn() throws ITMException { Connection conn =
	 * null; ConnDriver connDriver = new ConnDriver(); try { conn =
	 * connDriver.getConnectDB("DriverITM"); connDriver = null;
	 * 
	 * } catch (Exception e) { e.printStackTrace(); throw new ITMException(e); }
	 * connDriver = null; return conn; }
	 */

	public String getData(String loginCode) throws RemoteException, ITMException
	{
		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer xmlData = null;

		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;

			sql = "Select sp_period.sales_pers as sales_code, initcap(sp_period.sp_name) as salesperson_name, to_char(sp_period.fr_date,'YY') as Period1, to_char(sp_period.fr_date,'MM') as Period2, to_char(sp_period.fr_date,'YYYYMM') as Period3, concat(concat((concat('  ',trim(to_char(sp_period.fr_date,'Month')))),' - '),to_char(sp_period.fr_date,'YY')) as Period, Tour.Net_Amt as Amount, to_char(Tour.Chg_Date,'dd/mm/yy') as Submitted_Date, Obj_Sign_Trans_1.Sign_Status as Apporval_Status, to_char(Max(Wf_Prc_Status.Status_Date),'dd/mm/yy') as Status_Date from ( select sales_pers,sp_name,active_yn, fr_date,to_date from sales_pers,period where fr_date >= to_char(last_day(add_months(sysdate,-4))+1) and to_date < = to_char(last_day(add_months(sysdate,-1))) ) sp_period left join Tour on Tour.emp_code = sp_period.sales_pers and Tour.Date_from = sp_period.fr_date and Tour.Date_to = sp_period.to_date left join Wf_Prc_Status on Wf_Prc_Status.ref_id = Tour.Tour_Id left join Obj_Sign_Trans on Obj_Sign_Trans.Ref_Id = Tour.Tour_Id inner join ( select Ref_Id,Sign_Status,line_no from Obj_Sign_Trans ) Obj_Sign_Trans_1 on Obj_Sign_Trans_1.Ref_Id = Obj_Sign_Trans.Ref_Id where sp_period.active_yn = 'Y' and sp_period.sales_pers = ? " + " group by sp_period.sales_pers, sp_period.sp_name, to_char(sp_period.fr_date,'YY'), to_char(sp_period.fr_date,'MM'), to_char(sp_period.fr_date,'YYYYMM'), to_char(sp_period.fr_date,'Month'), Tour.Net_Amt, Obj_Sign_Trans_1.Line_No, to_char(Tour.Chg_Date,'dd/mm/yy'), Obj_Sign_Trans_1.Sign_Status having (Obj_Sign_Trans_1.line_no = max(Obj_Sign_Trans.line_no)) UNION ALL Select sp_period.sales_pers as sales_code, initcap(sp_period.sp_name) as salesperson_name, to_char(sp_period.fr_date,'YY') as Period1, to_char(sp_period.fr_date,'MM') as Period2, to_char(sp_period.fr_date,'YYYYMM') as Period3, concat(concat((concat('  ',trim(to_char(sp_period.fr_date,'Month')))),' - '),to_char(sp_period.fr_date,'YY')) as Period, Tour.Net_Amt as Amount, to_char(Tour.Chg_Date,'dd/mm/yy') as Submitted_Date, 'NOT' as Apporval_Status, to_char(Max(Wf_Prc_Status.Status_Date),'dd/mm/yy') as Status_Date from ( select sales_pers,sp_name,active_yn, fr_date,to_date from sales_pers,period where fr_date >= to_char(last_day(add_months(sysdate,-4))+1) and to_date < = to_char(last_day(add_months(sysdate,-1))) ) sp_period left join Tour on Tour.emp_code = sp_period.sales_pers and Tour.Date_from = sp_period.fr_date and Tour.Date_to = sp_period.to_date left join Wf_Prc_Status on Wf_Prc_Status.ref_id = Tour.Tour_Id left join Obj_Sign_Trans on Obj_Sign_Trans.Ref_Id = Tour.Tour_Id where sp_period.active_yn = 'Y' and sp_period.sales_pers = ? " + " group by sp_period.sales_pers, sp_period.sp_name, to_char(sp_period.fr_date,'YY'), to_char(sp_period.fr_date,'MM'), to_char(sp_period.fr_date,'YYYYMM'), to_char(sp_period.fr_date,'Month'), Tour.Net_Amt, to_char(Tour.Chg_Date,'dd/mm/yy'), 'NOT' having ( max(Obj_Sign_Trans.line_no) IS NULL) ORDER BY Period1, Period2, Period3, Period ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			pstmt.setString(2, loginCode);
			rs = pstmt.executeQuery();
			xmlData = new StringBuffer("<?xml version=\"1.0\"?><Root>");
			while (rs.next())
			{
				this.setSalePersn(rs.getString("salesperson_name"));
				xmlData.append("<Detail>");
				xmlData.append("<period >").append("<![CDATA[" + checkNull(rs.getString("Period")) + "]]>").append("</period>");
				xmlData.append("<amount>").append("<![CDATA[" + rs.getDouble("Amount") + "]]>").append("</amount>");
				
				
				System.out.print("in check Date method =" + rs.getString("Submitted_Date") );

				if (rs.getString("Submitted_Date") != null)
				{
					xmlData.append("<submitted_date>").append("<![CDATA[" + rs.getString("Submitted_Date") + "]]>").append("</submitted_date>");
				} else
				{

					xmlData.append("<submitted_date>").append("<![CDATA[ ]]>").append("</submitted_date>");
				}

				xmlData.append("<apporval_status>").append("<![CDATA[" + checkNull(rs.getString("Apporval_Status")) + "]]>").append("</apporval_status>");
				xmlData.append("</Detail>");
			}

			xmlData.append("</Root>");
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

		} catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception in: ExpenseProcessStatus :"+e.getMessage());
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception : ExpenseProcessStatus:" + d.getMessage());
				throw new ITMException(d);
				
			}
		}
		return xmlData.toString();
	}

	private String checkNull(String input)
	{
		System.out.print("in check null method =" + input);

		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}
}
