<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" />
  <xsl:decimal-format NaN="0" />

  <xsl:template match="/">
    <html>
      <body>
	<link rel="stylesheet" href="/ibase/webitm/css/DD/default.css" type="text/css" />
	<link id="userThemeLink" type="text/css" rel="stylesheet" href="" />
	<link href="/ibase/webitm/css/DD/ProductWizard.css" rel="stylesheet" />
	<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet" />

	<script type="text/javascript" src="/ibase/webitm/js/genTask.js"></script>
	<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
	<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>

	<form METHOD="POST" ACTION="/ibase/ITMWizardHandlerServlet">
	  <div id="header">
	    <div id="headingText">Generate Demo Task</div>
	  </div>
	  <div class="mainPage-Container" style="overflow: auto;">
	    <div style="margin-top: 8px; width:100%; padding: 0px; float: left;">
	      <div style="float: left; width:50%; border: 0px solid; padding: 0px;">
		  <table id="activityTable" border="0" cellSpacing="1" cellPadding="0">
		    <xsl:for-each select="//Detail1">
		      <xsl:variable name="dbID">
			<xsl:value-of select="dbID" />
		      </xsl:variable>
		      <xsl:variable name="site_code">
			<xsl:value-of select="site_code" />
		      </xsl:variable>
		      <xsl:variable name="customer">
			<xsl:value-of select="customer" />
		      </xsl:variable>
		      <xsl:variable name="supplier">
			<xsl:value-of select="supplier" />
		      </xsl:variable>
		      <xsl:variable name="item_code">
			<xsl:value-of select="item_code" />
		      </xsl:variable>
		      <xsl:variable name="quantity">
			<xsl:value-of select="quantity" />
		      </xsl:variable>

			<tr>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>Site Code</strong>
			  </td>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>:</strong>
			  </td>
			  <td colspan="2">
			    <input type="text" name="Detail1.{normalize-space($dbID)}.site_code" id="site_code" value="{$site_code}" class="editInputClass" style="width: 100%" placeholder="DDUK" />
			  </td>
			</tr>
			<tr>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>Customer</strong>
			  </td>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>:</strong>
			  </td>
			  <td colspan="2">
			    <input type="text" name="Detail1.{normalize-space($dbID)}.customer" id="customer" value="{$customer}" class="editInputClass" style="width: 100%" placeholder="CUS0000002" />
			  </td>
			</tr>
			<tr>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>Supplier</strong>
			  </td>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>:</strong>
			  </td>
			  <td colspan="2">
			    <input type="text" name="Detail1.{normalize-space($dbID)}.supplier" id="supplier" value="{$supplier}" class="editInputClass" style="width: 100%" placeholder="SUP0000003" />
			  </td>
			</tr>
			<tr>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>Item Code</strong>
			  </td>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>:</strong>
			  </td>
			  <td colspan="2">
			    <input type="text" name="Detail1.{normalize-space($dbID)}.item_code" id="item_code" value="{$item_code}" class="editInputClass" style="width: 100%" placeholder="260" />
			  </td>
			</tr>
			<tr>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>Quantity</strong>
			  </td>
			  <td class="td_leftAlign" nowrap="true">
			    <strong>:</strong>
			  </td>
			  <td colspan="2">
			    <input type="text" name="Detail1.{normalize-space($dbID)}.quantity" id="quantity" value="{$quantity}" class="editInputClass" style="width: 100%" placeholder="10" />
			  </td>
			</tr>
		    </xsl:for-each>
		  </table>

		  <input type="submit" id="next" style="cursor:hand" value="Next" class="button" title='Next' onclick="javascript:return checkNullvalidation();" />

	      </div>
	    </div>
	    <div style="border: 1px solid transparent; width: 100%;">
	      <input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
	      <input type="hidden" value="gentask" name="OBJ_NAME" id="OBJ_NAME" />
	      <input type="hidden" value="next" name="action" id="action" />

		<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1" width="98%">
		  <xsl:for-each select="//error">
		    <xsl:variable name="message">
		      <xsl:value-of select="message" />
		    </xsl:variable>
		    <xsl:variable name="description">
		      <xsl:value-of select="description" />
		    </xsl:variable>
		    <xsl:variable name="type">
		      <xsl:value-of select="type" />
		    </xsl:variable>
		    <xsl:variable name="dbID">
		      <xsl:value-of select="@dbId" />
		    </xsl:variable>
		    <xsl:variable name="column_name">
		      <xsl:value-of select="@column_name" />
		    </xsl:variable>
		    <tr>
		      <xsl:if test="position()=1">
			<td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">Message No.</td>
			<td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">Description</td>
			<td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">Type</td>
			<td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">Column Name</td>
		      </xsl:if>
		    </tr>
		    <tr>
		      <td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">
			<xsl:value-of select="message" />
		      </td>
		      <td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">
			<xsl:value-of select="description" />
		      </td>
		      <td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">
			<xsl:value-of select="type" />
		      </td>
		      <td class="td_leftAlign" nowrap="true" valign="bottom" width="20%">
			<xsl:value-of select="@column_name" />
		      </td>
		    </tr>
		  </xsl:for-each>
		</table>
		<div id="buttonreplacement" style="margin-left:20px;display:none;">
		  <img src="/ibase/images/preload.gif" alt="Please wait work in progress"> 	Please wait......</img>
		</div>
	    </div>
	  </div>
	</form>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>