/*Developed By : Sana Khan
 * Component : PayrVoucherPos
 * Date : 30/01/2016
*/

package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;

import org.w3c.dom.Document;




import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
@Stateless

public class PayrVoucherPos extends ValidatorEJB implements PayrVoucherPosLocal , PayrVoucherPosRemote{
	
	
	public String postSave() throws RemoteException , ITMException
	{
		return "";
	}
	
	public String postSave(String xmlString1,String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		GenericUtility genericUtility = new GenericUtility();
		Document dom = null;
		String errString = "";
		try
		{
		if(xmlString1 != null && xmlString1.trim().length() >0)
		{
			dom = genericUtility.parseString(xmlString1);
			errString = executePostSave(dom,editFlag,xtraParams,conn);
		}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return errString;
	}
	
	
	private String executePostSave (Document dom ,String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		String empCode = "" , effDateStr = "" , errString = "" ;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Date currDate = new Date();
		boolean errFound = false;
		
		GenericUtility genericUtility = new GenericUtility();
		
		try
		{
				
			conn.setAutoCommit(false);
			
			empCode = genericUtility.getColumnValue("emp_code",dom);
			effDateStr = genericUtility.getColumnValue("eff_date",dom);
			String tranId = genericUtility.getColumnValue("tran_id", dom);
			System.out.println("effective date is"+effDateStr);
			System.out.println("tranId is "+tranId);
			String sql = "" , itProc = "" , relieveDate = "" , workSite = "" , cadre = "" , grade = "";
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdf.format(currDate);
			System.out.println("currDateStr date is"+currDateStr);
			Timestamp currDateT = null;
			currDateT = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			System.out.println("currDate date is"+currDateT);
			
			sql = "SELECT RELIEVE_DATE , WORK_SITE , CADRE , GRADE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				 relieveDate = checkNull(rs.getString("RELIEVE_DATE"));
				 workSite = checkNull(rs.getString("WORK_SITE"));
				 cadre = checkNull(rs.getString("CADRE"));
				 grade = checkNull(rs.getString("GRADE"));
				
			}
			close(pstmt , rs);
			
			AdmCommon admCommon = new AdmCommon() ;
			itProc = admCommon.getAdmEnv(workSite , cadre , grade , "ITREPROC" , currDateT , conn );
			
			Timestamp effDate = null;
			effDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			System.out.println("effDate date is"+effDate);
			
			if(itProc.equalsIgnoreCase("Y"))
			{  
				String  code = "" , confirmed = "" , confirmed1 = "";
				
				if(relieveDate == null || relieveDate.trim().length() == 0)
				{
					sql = "";
					sql = "SELECT CODE FROM ACCTPRD WHERE FR_DATE <= ? AND TO_DATE >= ? ";
					pstmt= conn.prepareStatement(sql);
					pstmt.setTimestamp(1, effDate);
					pstmt.setTimestamp(2, effDate);
					
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						code = checkNull(rs.getString("CODE"));
					}
					
					System.out.println("code field is"+code);
					
					sql = "";
					sql = "SELECT CONFIRMED FROM PAYROLL WHERE EMP_CODE = ? AND PRD_CODE = (SELECT MAX(CODE) FROM PERIOD WHERE ACCT_PRD = ?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					pstmt.setString(2, code);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						confirmed = checkNull(rs.getString("CONFIRMED"));
					}
					close(pstmt , rs);
					System.out.println("confirmed field is"+confirmed);
				}
				else
				{
					sql = "";
					sql = "SELECT CONFIRMED FROM FULLFINAL_HDR WHERE EMP_CODE = ? AND CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END <> 'X'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						confirmed1 = checkNull(rs.getString("CONFIRMED"));
					}
					close(pstmt , rs);	
					System.out.println("confirmed1 field is"+confirmed1);
				}
				 if(confirmed.equalsIgnoreCase("Y") || confirmed1.equalsIgnoreCase("Y"))
				 {
					 sql = "";
					 sql = "UPDATE PAYR_VOUCHER SET IT_FLAG = 'Y' WHERE TRAN_ID = ?";
					 pstmt = conn.prepareStatement(sql);
					 pstmt.setString(1, tranId);
					 pstmt.executeUpdate();
					 System.out.println("Update loop 'Y'");
					 
				 }
				 else
				 {
					 sql = "";
					 sql = "UPDATE PAYR_VOUCHER SET IT_FLAG = 'N' WHERE TRAN_ID = ?";
					 pstmt = conn.prepareStatement(sql);
					 pstmt.setString(1, tranId);
					 pstmt.executeUpdate();
					 System.out.println("Update loop 'N'");
				 }
			}
		}
		catch(Exception e)
		{
			errFound = true;
			e.printStackTrace();
		}
		
		finally
		{
			try
			{
			  if (rs != null)
			  {
				rs.close();
				rs = null;
			  }
			  if (pstmt != null) 
			  {
				pstmt.close();
				pstmt = null;
			  }
			  if(errFound == true)
			  {
				conn.rollback();
				
			  }
			  else
			  {
				  conn.commit();
				  
			  }
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		
		else 
		{
			input = input.trim();
		}
		return input;
	}
	
	private void close(PreparedStatement pstmt,ResultSet rs)
	{
		try
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
}