/**
 *  Purpose: Dashboard for User Acitivity, Reuest ID: W15CSUN005  
 *  Author: Sneha Mestry
 *  Date: 16-06-2015
 */

package ibase.webitm.servlet.wms;


import ibase.system.config.AppConnectParm;
import ibase.webitm.ejb.wms.UserActivityRemote;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;


public class UserActivityServlet extends HttpServlet
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		UserActivityRemote  userActivityRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "",  fromDate = "", toDate = "", empCodeFrom = "", empCodeTo = "";
		String siteCode = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName"); 
			
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			siteCode = userInfo.getSiteCode();
			System.out.println(" siteCode :::::::::: " + siteCode);
			
			// Start by Sneha on 29-07-2015, Request ID: W15DSUN014
			fromDate = request.getParameter("fromDate");
			toDate = request.getParameter("toDate");
			empCodeFrom = request.getParameter("empCodeFrom");
			empCodeTo = request.getParameter("empCodeTo");
			
			System.out.println(" fromDate :::::::::: " + fromDate);
			System.out.println(" toDate :::::::::: " + toDate);
			System.out.println(" empCodeFrom :::::::::: " + empCodeFrom);
			System.out.println(" empCodeTo :::::::::: " + empCodeTo);

			// End by Sneha on 29-07-2015, Request ID: W15DSUN014

			context = new InitialContext(appConnectParm.getProperty());
			userActivityRemote = (UserActivityRemote) context.lookup("ibase/UserActivity/remote");

			//Here invoke EJB define method 
			// Start by Sneha on 29-07-2015, Request ID: W15DSUN014
			JSONObject jsonObjData = (JSONObject)userActivityRemote.getUserActivityDetails(dataSourceName, siteCode, fromDate, toDate, empCodeFrom, empCodeTo);
			// End by Sneha on 29-07-2015, Request ID: W15DSUN014
			
			//JSONObject jsonObjData = (JSONObject)userActivityRemote.getUserActivityDetails(dataSourceName, siteCode);
			OutputStream outputStream = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for UserActivityServlet build to Graph and Grid===" + jsonObjData);	
			
		} 
		catch (Exception e)
		{
			System.out.println("Exception in: UserActivityServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}