package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;



import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * PURPOSE : Validation & ItemChanged for Employee Security Detail
 * 
 * @author Sagar Narvekar
 *<BR> Date 17-JAN-2017
 */
@Stateless
public class EmployeeSecurityIC extends ValidatorEJB implements EmployeeSecurityICRemote , EmployeeSecurityICLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private String checkNull(String input) 
	{
		return input == null ? "" : input.trim();
	}
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()> 0)
			{
				System.out.println ( "currXmlDataStr: " + currXmlDataStr);
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()>0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
				System.out.println ( "hdrXmlDataStr: " + hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()>0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
				System.out.println ( "allXmlDataStr: " + allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: EmployeeSecurityIC" + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: EmployeeSecurityIC: wfValData(String currXmlDataStr): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from EmployeeSecurityIC wfValData" );
		return ( errString ); 
	}
	

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("Inside Validation :::::::");
		String userId = "",errString= "";
		Connection conn = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		NodeList parentList = null,parentList1=null;
		NodeList childList = null,childList1=null;
		Node parentNode = null;
		Node childNode = null,childNode1=null;
		String childNodeName = null,childNodeName1=null;
		String tranId = "" , empCode = "" , relShip="" , relName ="" , panNo = "" , clientId = "" , dpId = "" , folioId = "" , noOfSecStr = "" , shareHoldPercStr ="" ,
				unitsFutStr = "" , unitsOptStr = "" , valueFutStr = "" , valueOptStr = "" , typeOfSec = "" , modeOfSec = "" , panValue = "";
		double unitsFut = 0.0 , unitsOpt = 0.0 , valueFut = 0.0 , valueOpt = 0.0 ,  shareHoldPerc = 0.0 , noOfSecurities = 0.0;
		String sql = "";
		int count = 0 , ctr = 0 , noOfChilds = 0 , currentFormNo = 0,cnt=0,noOfChilds1=0;
		boolean selfFlag=false;
		
		Timestamp sysDate=null,frDate=null,toDate=null;
		//boolean panValue =false;
		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			sysDate=Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())
			+ " 00:00:00.0");
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length() >  0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = allDom.getElementsByTagName("Detail" + currentFormNo);
			switch(currentFormNo)
			{    
			case 1 :
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();
				for(ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if ("tran_date".equalsIgnoreCase(childNodeName))
					{
						empCode= checkNull(genericUtility.getColumnValue("emp_code", allDom ));
						
						sql = "select fr_date,to_date from acctprd where ?  between fr_date and to_date";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, sysDate);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							frDate = rs.getTimestamp("fr_date");
							toDate = rs.getTimestamp("to_date");
						}							
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;	
						
						sql = "select count(1) from EMP_SECURITIES_HDR where tran_date between ? AND ? " +
								" and emp_code=? and status in ('S','O')";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, frDate);
						pstmt.setTimestamp(2, toDate);
						pstmt.setString(3, empCode);
						rs = pstmt.executeQuery();
						
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
						
						System.out.println("@V@ In accounting prd :- ["+cnt+"]");
//						cnt=1;
						if (cnt > 0)
						{
							errString = getErrorString("tran_date","VTEMPACCT",userId);
							break;
						}
					}
					
			}// end for
				break;  // case 1 end
				case 2:
				{
					childList = parentList.item(0).getChildNodes();
					noOfChilds = childList.getLength();
					for(ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						/*if(childNode.getNodeType() !=1)
						{
							continue;
						}*/
						childNodeName = childNode.getNodeName();
						System.out.println("Inside Case 2 Of Validation");
						System.out.println("parentList>>"+parentList);
						System.out.println("childList>>"+childList);
					
						System.out.println("childNodeName::::::" +childNodeName);
						if("relative_name".equalsIgnoreCase(childNodeName))
						{
							relName = checkNull(genericUtility.getColumnValue("relative_name", allDom ));
							if(relName == null || relName.length()==0)				
							{
								errString = getErrorString("relative_name","VTEMPSEC01",userId);
								break;
							}
						}
						else if("relationship".equalsIgnoreCase(childNodeName))
						{						
							relShip = checkNull(genericUtility.getColumnValue("relationship", allDom ));
							if(relShip == null || relShip.length() == 0)				
							{
								errString = getErrorString("relationship","VTEMPSEC02",userId);
								break;
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'W_EMP_SECURITIES' AND FLD_NAME='RELATIONSHIP' AND TRIM(FLD_VALUE)=? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, relShip);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =rs.getInt("COUNT");
								}
								if(cnt==0)
								{
									errString = getErrorString("relationship","VTEMPSEC21",userId);
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
									
								}
								if(rs != null )
								{
									rs.close();
									rs = null;
								}
							}

							selfFlag=checkSelfRecord(currDom,allDom,relShip);
							if(!selfFlag)
							{
								errString = getErrorString("relationship","VTEMPSELF",userId);
								break;
							}
						}
						else if("pan_no".equalsIgnoreCase(childNodeName))
						{
							panNo = checkNull(genericUtility.getColumnValue("pan_no", allDom ));
							if(panNo == null || panNo.length() == 0)				
							{
								errString = getErrorString("pan_no","VTEMPSEC03",userId);
								break;
							}
							else
							{
								panNo = checkNull(genericUtility.getColumnValue("pan_no", allDom ));
								sql = "select VALIDATEPAN(?) as pan_no from dual";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, panNo);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									panValue = checkNull(rs.getString("pan_no"));
								}
								if("false".equalsIgnoreCase(panValue.toLowerCase()))
								{
									errString = getErrorString("pan_no","VTEMPSEC31",userId);
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
									
								}
								if(rs != null )
								{
									rs.close();
									rs = null;
								}
								boolean panFlg=false;
								panFlg=checkDuplicate(currDom,allDom,panNo,"pan_no");
								if(panFlg)
								{
									errString = getErrorString("pan_no","VTDUPLPAN",userId);
									break;
								}
							}
						}
						else if("folio_no".equalsIgnoreCase(childNodeName))
						{
							String folioNo = checkNull(genericUtility.getColumnValue("folio_no", allDom ));
							if(folioNo != null  && folioNo.length() > 0)
							{
								boolean folioNoFlg=false;
								folioNoFlg=checkDuplicate(currDom,allDom,folioNo,"folio_no");
								if(folioNoFlg)
								{
									errString = getErrorString("folio_no","VTDUPLFLO",userId);
									break;
								}
							}
						}
//						else if("dp_id".equalsIgnoreCase(childNodeName))
//						{
//							dpId = checkNull(genericUtility.getColumnValue("dp_id", allDom ));
//							if(dpId != null  && dpId.length() > 0)
//							{
//								boolean dpIdFlg=false;
//								dpIdFlg=checkDuplicate(currDom,allDom,dpId,"dp_id");
//								if(dpIdFlg)
//								{
//									errString = getErrorString("dp_id","VTDUPLDP",userId);
//									break;
//								}
//							}
//						}
						else if("client_id".equalsIgnoreCase(childNodeName))
						{
							clientId = checkNull(genericUtility.getColumnValue("client_id", allDom ));
							if(clientId != null  && clientId.length() > 0)
							{
								boolean clientIdFlg=false;
								clientIdFlg=checkDuplicate(currDom,allDom,clientId,"client_id");
								if(clientIdFlg)
								{
									errString = getErrorString("client_id","VTDUPLCLN",userId);
									break;
								}
							}
						}
						else if("mode_of_security".equalsIgnoreCase(childNodeName))
						{
							modeOfSec = checkNull(genericUtility.getColumnValue("mode_of_security", allDom ));
							if(modeOfSec == null  || modeOfSec.length() == 0)
							{
								errString = getErrorString("mode_of_security", "VTEMPSEC04", userId);
								break;
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'W_EMP_SECURITIES' AND FLD_NAME='MODE_OF_SECURITY' AND TRIM(FLD_VALUE)=? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, modeOfSec);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =rs.getInt("COUNT");
								}
								if(cnt==0)
								{
									errString = getErrorString("mode_of_security","VTEMPSEC41",userId);
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
									
								}
								if(rs != null )
								{
									rs.close();
									rs = null;
								}
							}
						}
						else if("type_of_security".equalsIgnoreCase(childNodeName))
						{
							typeOfSec = checkNull(genericUtility.getColumnValue("type_of_security", allDom ));
							if(typeOfSec == null || typeOfSec.length() == 0)				
							{
								errString = getErrorString("type_of_security","VTEMPSEC05",userId);
								break;
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'W_EMP_SECURITIES' " +
										"AND FLD_NAME='TYPE_OF_SECURITY' AND TRIM(FLD_VALUE)=? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, typeOfSec);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =rs.getInt("COUNT");
								}								
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
									
								}
								if(rs != null )
								{
									rs.close();
									rs = null;
								}
								System.out.println("type_of_security :- ["+cnt+"]");
								if(cnt==0)
								{
									errString = getErrorString("type_of_security","VTEMPSEC51",userId);
									break;
								}
							}
						}
						else if("shareholding_perc".equalsIgnoreCase(childNodeName))
						{
							shareHoldPercStr = checkNull(genericUtility.getColumnValue("shareholding_perc", allDom ));
							shareHoldPerc=shareHoldPercStr.trim().length()==0?0.00:Double.parseDouble(shareHoldPercStr);
							if(shareHoldPerc  > 100)				
							{
								errString = getErrorString("shareholding_perc","VTPRCEXED",userId);
								break;
							}
						}
						else if("no_of_securities".equalsIgnoreCase(childNodeName))
						{
							noOfSecStr = checkNull(genericUtility.getColumnValue("no_of_securities", allDom ));
							System.out.println("@V@ No of security  :- ["+noOfSecStr+"]");
							if(noOfSecStr == null || noOfSecStr.length() == 0)				
							{
								errString = getErrorString("no_of_securities","VTEMPSEC06",userId);
								break;
							}
							else 
							{
								if(noOfSecStr.indexOf(".")>-1)
								{
									errString = getErrorString("no_of_securities","VTEMPSECDC",userId);
									break;
								}
								if(Double.parseDouble(noOfSecStr) < 0)
								{
									errString = getErrorString("no_of_securities","VTEMPSEC06",userId);
									break;
								}
							}
						}
						else if("units_future".equalsIgnoreCase(childNodeName))
						{
							unitsFutStr = checkNull(genericUtility.getColumnValue("units_future", allDom ));
							System.out.println("@V@ units_future  :- ["+unitsFutStr+"]");
							if(unitsFutStr == null || unitsFutStr.length() == 0)				
							{
								errString = getErrorString("units_future","VTEMPSEC07",userId);
								break;
							}
							else 
							{
								if(unitsFutStr.indexOf(".")>-1)
								{
									errString = getErrorString("no_of_securities","VTEMPUFDC",userId);
									break;
								}
								if(Double.parseDouble(unitsFutStr) < 0)
								{
									errString = getErrorString("units_future","VTEMPSEC07",userId);
									break;
								}
							}
						}
						else if("units_option".equalsIgnoreCase(childNodeName))
						{
							unitsOptStr = checkNull(genericUtility.getColumnValue("units_option", allDom ));
							System.out.println("@V@ units_option  :- ["+unitsOptStr+"]");
							if(unitsOptStr == null || unitsOptStr.length() == 0)				
							{
								errString = getErrorString("units_option","VTEMPSEC08",userId);
								break;
							}
							else 
							{
								if(unitsOptStr.indexOf(".")>-1)
								{
									errString = getErrorString("no_of_securities","VTEMPUODC",userId);
									break;
								}

								if(Double.parseDouble(unitsOptStr) < 0)
								{
									errString = getErrorString("units_option","VTEMPSEC08",userId);
									break;
								}
							}
						}						
						else if("value_option".equalsIgnoreCase(childNodeName))
						{
							System.out.println("In value_option validation-------");
							valueOptStr = checkNull(genericUtility.getColumnValue("value_option", allDom ));
							System.out.println("@V@ value_option  :- ["+valueOptStr+"]");
							if(valueOptStr == null || valueOptStr.length() == 0)				
							{
								errString = getErrorString("value_option","VTEMPSEC09",userId);
								break;
							}
							else 
							{
								if(valueOptStr.indexOf(".")>-1)
								{
									errString = getErrorString("no_of_securities","VTEMPVODC",userId);
									break;
								}
								if(Double.parseDouble(valueOptStr)<0)
								{
									errString = getErrorString("value_option","VTEMPSEC09",userId);
									break;
								}
							}
						}
						else if("value_future".equalsIgnoreCase(childNodeName))
						{
							valueFutStr = checkNull(genericUtility.getColumnValue("value_future", allDom ));
							System.out.println("@V@ value_future  :- ["+valueFutStr+"]");
							if(valueFutStr == null || valueFutStr.length() == 0)				
							{
								errString = getErrorString("value_future","VTEMPSEC10",userId);
								break;
							}
							else 
							{
								if(valueFutStr.indexOf(".")>-1)
								{
									errString = getErrorString("no_of_securities","VTEMPVFDC",userId);
									break;
								}
								if(Double.parseDouble(valueFutStr)<0)
								{
									errString = getErrorString("value_future","VTEMPSEC10",userId);
									break;
								}
							}
						}
						
						
						}
					}
					break;
				}
		}
		catch(Exception e)
		{
			System.out.println("Exception: EmployeeSecurityIC: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (pstmt != null)
					{
						if (rs != null)
						{
							rs.close();
						}
						pstmt.close();
					}
					conn.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}// End Finally
		return (errString);
	}
	private boolean checkSelfRecord(Document currDom, Document allDom,String currRelShip) {
		NodeList parentNodeList = null,childList=null;
		Node childNode = null;
		String childNodeName="";
		String updateFlag = "";
		int noOfChilds=0;
		try {
			System.out.println(" EJB ["+this.getClass().getSimpleName() + "] currDom" + genericUtility.serializeDom(currDom));
			parentNodeList = allDom.getElementsByTagName("Detail2");
			
			
			int childNodeListLength = parentNodeList.getLength();
			int count = 0;
			if("SELF".equalsIgnoreCase(currRelShip))
			{
				return true;
			}
			else
			{
				for (int ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childList = parentNodeList.item(0).getChildNodes();
					noOfChilds = childList.getLength();
					for(int ctr1 = 0; ctr1< noOfChilds; ctr1++)
					{
						childNode = childList.item(ctr1);
						childNodeName = childNode.getNodeName();				
						if(childNodeName.equals("attribute"))
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("@V@ updateFlag>>>"+updateFlag);
						
						}
					}
					if(!"D".equalsIgnoreCase(updateFlag))
					{
						System.out.println("@V@ Update flag not D-----");
						String relation1 = genericUtility.getColumnValueFromNode("relationship", allDom.getElementsByTagName("Detail2").item(ctr));
						if("SELF".equalsIgnoreCase(relation1)) 
						{
							count ++ ;
						}
					}
					
				}
				if(count > 0) {
					return true;
				}
			}
			
			System.out.println("EJB ["+this.getClass().getSimpleName() + "] allDom" + genericUtility.serializeDom(allDom));
		} 
		catch (Exception e) {
			e.printStackTrace();
		} finally {
			System.out.println("Finally in EJB ["+this.getClass().getSimpleName() + "]");
		}
		
		return false;
	}
	private boolean checkDuplicate(Document currDom, Document allDom, String currentValue,String fieldName) {
		NodeList parentNodeList = null;
		try {
			System.out.println("@V@ fieldName :- ["+fieldName+"]");
			System.out.println("@V@ currentValue :- ["+currentValue+"]");
			System.out.println(" EJB ["+this.getClass().getSimpleName() + "] currDom" + genericUtility.serializeDom(currDom));
			parentNodeList = allDom.getElementsByTagName("Detail2");
			int childNodeListLength = parentNodeList.getLength();
			int count = 0;
			for (int ctr = 0; ctr < childNodeListLength; ctr++)
			{
//				String itemCodeVal = genericUtility.getColumnValueFromNode("item_code", allDom.getElementsByTagName("Detail2").item(ctr));
				String tempFldVal = checkNull(genericUtility.getColumnValueFromNode(fieldName, allDom.getElementsByTagName("Detail2").item(ctr)));
				System.out.println("@V@ DOM value :- ["+tempFldVal+"]");
				if(currentValue.equalsIgnoreCase(tempFldVal)) 
				{
					count ++ ;
				}
			}
			System.out.println("@V@ duplicate count :- ["+count+"]");
			if(count > 1) {
				return true;
			}
			System.out.println("EJB ["+this.getClass().getSimpleName() + "] allDom" + genericUtility.serializeDom(allDom));
		} 
		catch (Exception e) {
			e.printStackTrace();
		} finally {
			System.out.println("Finally in EJB ["+this.getClass().getSimpleName() + "]");
		}
		
		return false;
	}
	public String itemChanged() throws RemoteException, ITMException {
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			System.out.println("EmployeeSecurityIC:itemChanged value of xmlString ["+ xmlString + "]");
			System.out.println("EmployeeSecurityIC:itemChanged value of xmlString1 ["+ xmlString1 + "]");
			System.out.println("EmployeeSecurityIC:itemChanged value of xmlString2 ["+ xmlString2 + "]");
			System.out.println("objContext ..:: [" + objContext + "]");
			System.out.println("currentColumn ..:: [" + currentColumn + "]");
			System.out.println("editFlag ..:: [" + editFlag + "]");

			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn,editFlag, xtraParams);
			System.out.println("ErrString :" + errString);
		} catch (Exception e) {
			System.out.println("Exception : EmployeeSecurityIC :itemChanged(String,String):"+ e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("returning from contact itemChanged");
		return errString;
	}


	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
			{

		int currentFormNo = 0;
		StringBuffer valueXmlString = null;
		String chgDate = "" , chgUser = "" , chgTerm = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String columnValue = "";
		String childNodeName = null, childNodeValue = null;
		int ctr = 0, childNodeListLength = 0,  remCount = 0; 
		String    lastRemindDate = "" , grade = "" , empSite = "" , deptCode = "" , empCode = "" , tranDate ="" ,modeOfSecStr = "" , folioId = "" , 
				 panNo = "" , clientId = "" , dpId = "" , empName = "" , sql = "" , shareHoldPercStr = "",acntPrd="" , dtJoinStr = "" ;
		char status = 'O' ;
		double shareHoldPerc = 0.0;
		Timestamp dateJoin = null,sysDate=null ;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = null;

		try {
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf1.format(currentDate.getTime());
			sysDate=Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())
			+ " 00:00:00.0");
			
			System.out.println("CURRENT COLUMN:::::" + currentColumn);
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("Employee code :::::::::::" +empCode);
			java.util.Date currDate = new java.util.Date();
			chgDate = sdf.format(currDate);
			System.out.println("chgDate...[" + chgDate + "");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			tranDate = sdf.format(currDate);
			//lastRemindDate = sdf.format(currDate);
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			currentColumn = checkNull(currentColumn).trim();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) {

			case 1:
			{

				System.out.println("Inside Case 1 Of Itemchange");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();

				do {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equals(currentColumn)) {
						if (childNode.getFirstChild() != null) {
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				} while (ctr < childNodeListLength && !childNodeName.equals(currentColumn));
				System.out.println("current form::::::::::::" + currentFormNo);




				if ( "itm_default".equalsIgnoreCase(currentColumn)) 
				{
					valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
					valueXmlString.append("<chg_term>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>");
					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
					//valueXmlString.append("<tranDate>").append("<![CDATA[" + tranDate + "]]>").append("</tran_date>");
					//Updated By Umakanta Das
					valueXmlString.append("<tran_date>").append("<![CDATA[" + tranDate + "]]>").append("</tran_date>");
					valueXmlString.append("<emp_code>").append("<![CDATA[" + empCode + "]]>").append("</emp_code>");
					valueXmlString.append("<last_remind_date>").append("<![CDATA[" + lastRemindDate + "]]>").append("</last_remind_date>");
					
					sql = "select code from acctprd where ?  between fr_date and to_date";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, sysDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						acntPrd = rs.getString("code");
					}							
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;	
					System.out.println("acntPrd :::::::::::::"+acntPrd);
					
					sql = " SELECT GRADE , DATE_JOIN , EMP_SITE , DEPT_CODE, DDF_GET_MASTERS_NAME('EMPLOYEE', EMP_CODE, 'FML') EMP_NAME " +
							" FROM EMPLOYEE WHERE EMP_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						grade = checkNull(rs.getString("GRADE"));
						dateJoin = rs.getTimestamp("DATE_JOIN");
						empSite = checkNull(rs.getString("EMP_SITE"));
						deptCode = checkNull(rs.getString("DEPT_CODE"));
						empName = checkNull(rs.getString("EMP_NAME"));
					}
					
					if(rs != null )
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;

					}
					sql = "SELECT DESCR FROM GRADE WHERE GRADE_CODE = ? " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, grade);
					rs = pstmt.executeQuery();
					String gradeDescr = "";
					if(rs.next())
					{
						gradeDescr = checkNull(rs.getString("DESCR"));
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
						
					}
					if(rs != null )
					{
						rs.close();
						rs = null;
					}

					sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, deptCode);
					rs = pstmt.executeQuery();
					String deptDescr = "";
					if(rs.next())
					{
						deptDescr = checkNull(rs.getString("DESCR"));
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null )
					{
						rs.close();
						rs = null;
					}

					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empSite);
					rs = pstmt.executeQuery();
					String siteDescr = "" ;
					if(rs.next())
					{
						siteDescr = checkNull(rs.getString("DESCR"));
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null )
					{
						rs.close();
						rs = null;
					}
					dtJoinStr=genericUtility.getValidDateString(dateJoin.toString(), genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
					valueXmlString.append("<acct_prd protect=\"1\">").append("<![CDATA[" + acntPrd + "]]>").append("</acct_prd>");
					valueXmlString.append("<emp_name>").append("<![CDATA[" + empName + "]]>").append("</emp_name>");
					valueXmlString.append("<grade>").append("<![CDATA[" + grade + "]]>").append("</grade>");
					valueXmlString.append("<dept_code>").append("<![CDATA[" + deptCode + "]]>").append("</dept_code>");
//					valueXmlString.append("<date_join>").append("<![CDATA[" + dateJoin + "]]>").append("</date_join>");
					valueXmlString.append("<date_join>").append("<![CDATA[" + dtJoinStr + "]]>").append("</date_join>");
					valueXmlString.append("<emp_site>").append("<![CDATA[" + empSite + "]]>").append("</emp_site>");			
					valueXmlString.append("<grade_descr>").append("<![CDATA[" + gradeDescr + "]]>").append("</grade_descr>");
					valueXmlString.append("<department_descr>").append("<![CDATA[" + deptDescr + "]]>").append("</department_descr>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
					valueXmlString.append("<remind_count>").append("<![CDATA[]]>").append("</remind_count>");
					valueXmlString.append("<status>").append("<![CDATA[O]]>").append("</status>");
					valueXmlString.append("<status_date>").append("<![CDATA[" + tranDate + "]]>").append("</status_date>");
				}
				//Added By umakanta Das on 18-JAN-2017[]Start
				if ( "itm_defaultedit".equalsIgnoreCase(currentColumn)) 
				{
//					valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
//					valueXmlString.append("<chg_term>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>");
//					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
////					valueXmlString.append("<tran_date>").append("<![CDATA[" + tranDate + "]]>").append("</tran_date>");
////					valueXmlString.append("<emp_code>").append("<![CDATA[" + empCode + "]]>").append("</emp_code>");
//					valueXmlString.append("<last_remind_date>").append("<![CDATA[" + lastRemindDate + "]]>").append("</last_remind_date>");
//
//					sql = " SELECT GRADE , DATE_JOIN , EMP_SITE , DEPT_CODE, DDF_GET_MASTERS_NAME('EMPLOYEE', EMP_CODE, 'FML') EMP_NAME " +
//							" FROM EMPLOYEE WHERE EMP_CODE = ? ";
//					pstmt = conn.prepareStatement(sql);
//					pstmt.setString(1, empCode);
//					rs = pstmt.executeQuery();
//					while(rs.next())
//					{
//						grade = checkNull(rs.getString("GRADE"));
//						//dateJoin = rs.getDate("DATE_JOIN");
//						dateJoin = rs.getTimestamp("DATE_JOIN");
//						empSite = checkNull(rs.getString("EMP_SITE"));
//						deptCode = checkNull(rs.getString("DEPT_CODE"));
//						empName = checkNull(rs.getString("EMP_NAME"));
//					}
//					if(rs != null )
//					{
//						rs.close();
//						rs = null;
//					}
//					if (pstmt != null) {
//						pstmt.close();
//						pstmt = null;
//
//					}
//
//					sql = "SELECT DESCR FROM GRADE WHERE GRADE_CODE = ? " ;
//					pstmt = conn.prepareStatement(sql);
//					pstmt.setString(1, grade);
//					rs = pstmt.executeQuery();
//					String gradeDescr = "";
//					if(rs.next())
//					{
//						gradeDescr = checkNull(rs.getString("DESCR"));
//					}
//					if(rs != null )
//					{
//						rs.close();
//						rs = null;
//					}
//					if (pstmt != null) {
//						pstmt.close();
//						pstmt = null;
//
//					}
//
//					sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
//					pstmt = conn.prepareStatement(sql);
//					pstmt.setString(1, deptCode);
//					rs = pstmt.executeQuery();
//					String deptDescr = "";
//					if(rs.next())
//					{
//						deptDescr = checkNull(rs.getString("DESCR"));
//					}
//					if(rs != null )
//					{
//						rs.close();
//						rs = null;
//					}
//					if (pstmt != null) {
//						pstmt.close();
//						pstmt = null;
//
//					}
//
//					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
//					pstmt = conn.prepareStatement(sql);
//					pstmt.setString(1, empSite);
//					rs = pstmt.executeQuery();
//					String siteDescr = "" ;
//					if(rs.next())
//					{
//						siteDescr = checkNull(rs.getString("DESCR"));
//					}
//					if(rs != null )
//					{
//						rs.close();
//						rs = null;
//					}
//					if (pstmt != null) {
//						pstmt.close();
//						pstmt = null;
//
//					}
//					dtJoinStr=genericUtility.getValidDateString(dateJoin.toString(), genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
//					valueXmlString.append("<emp_name>").append("<![CDATA[" + empName + "]]>").append("</emp_name>");
//					valueXmlString.append("<grade>").append("<![CDATA[" + grade + "]]>").append("</grade>");
//					valueXmlString.append("<dept_code>").append("<![CDATA[" + deptCode + "]]>").append("</dept_code>");
////					valueXmlString.append("<date_join>").append("<![CDATA[" + dateJoin + "]]>").append("</date_join>");
//					valueXmlString.append("<date_join>").append("<![CDATA[" + dtJoinStr + "]]>").append("</date_join>");
//					valueXmlString.append("<emp_site>").append("<![CDATA[" + empSite + "]]>").append("</emp_site>");			
//					valueXmlString.append("<grade_descr>").append("<![CDATA[" + gradeDescr + "]]>").append("</grade_descr>");
//					valueXmlString.append("<department_descr>").append("<![CDATA[" + deptDescr + "]]>").append("</department_descr>");
//					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
//					valueXmlString.append("<remind_count>").append("<![CDATA[" + remCount + "]]>").append("</remind_count>");
//					valueXmlString.append("<status>").append("<![CDATA[" + status + "]]>").append("</status>");
					
				}
				//Added By umakanta Das on 18-JAN-2017[]End
			}
			valueXmlString.append("</Detail1>");
			break;
			case 2:
			{
				valueXmlString.append("<Detail2>");
				System.out.println("Inside Case 2 Of Itemchange");
				
				if ( "itm_default".equalsIgnoreCase(currentColumn)) 
				{
					String domId=genericUtility.getColumnValue("line_no", dom , "2");
					System.out.println("Inside item default in case 2 :::::::");
					valueXmlString.append("<units_future>").append("<![CDATA[" + "00" + "]]>").append("</units_future>");
					valueXmlString.append("<units_option>").append("<![CDATA[" + "00" + "]]>").append("</units_option>");
					valueXmlString.append("<no_of_securities>").append("<![CDATA[" + "00" + "]]>").append("</no_of_securities>");
					valueXmlString.append("<value_future>").append("<![CDATA[" + "00" + "]]>").append("</value_future>");
					valueXmlString.append("<value_option>").append("<![CDATA[" + "00" + "]]>").append("</value_option>");
					valueXmlString.append("<shareholding_perc>").append("<![CDATA[" + "00" + "]]>").append("</shareholding_perc>");
//					valueXmlString.append("<value_future>").append("<![CDATA[" + "0.0" + "]]>").append("</value_future>");
//					valueXmlString.append("<value_option>").append("<![CDATA[" + "0.0" + "]]>").append("</value_option>");
//					valueXmlString.append("<shareholding_perc>").append("<![CDATA[" + "00.00" + "]]>").append("</shareholding_perc>");
					System.out.println("Dom Id found :- ["+domId+"]");
					if(domId.trim().equalsIgnoreCase("1"))
					{
						valueXmlString.append("<relationship>").append("<![CDATA[" + "SELF" + "]]>").append("</relationship>");
						
						sql = "SELECT IT_NO , DDF_GET_MASTERS_NAME('EMPLOYEE', EMP_CODE, 'FML') AS EMP_NAME FROM EMPLOYEE WHERE EMP_CODE = ? " ;
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						rs = pstmt.executeQuery();
						if(rs.next())
							{
								panNo = checkNull(rs.getString("IT_NO"));
								empName = checkNull(rs.getString("emp_name"));
							}
						valueXmlString.append("<pan_no protect=\"1\"><![CDATA["+ panNo + "]]></pan_no>\r\n");
						valueXmlString.append("<relative_name protect=\"1\"><![CDATA["+ empName + "]]></relative_name>\r\n");
						
						
						
					}
					valueXmlString.append("<folio_no protect=\"0\"><![CDATA[]]></folio_no>\r\n");
					valueXmlString.append("<client_id protect=\"0\"><![CDATA[]]></client_id>\r\n");
					valueXmlString.append("<dp_id protect=\"0\"><![CDATA[]]></dp_id>\r\n");
					valueXmlString.append("<pan_no protect=\"0\"><![CDATA["+ panNo + "]]></pan_no>\r\n");
					valueXmlString.append("<relative_name protect=\"0\"><![CDATA["+ empName + "]]></relative_name>\r\n");
					
				}
				else if ( "itm_defaultedit".equalsIgnoreCase(currentColumn)) 
				{
					System.out.println("Case 2 item default edit :- @@@@");
					String modeOfSecurity = checkNull(genericUtility.getColumnValue( "mode_of_security", dom , "2" ));
					String folioNo = checkNull(genericUtility.getColumnValue( "folio_no", dom , "2" ));
					String dpIdStr = checkNull(genericUtility.getColumnValue( "dp_id", dom , "2" ));
					String clientIdStr = checkNull(genericUtility.getColumnValue( "client_id", dom , "2" ));
					if("E".equalsIgnoreCase(modeOfSecurity))
					{
						valueXmlString.append("<folio_no protect=\"1\"><![CDATA["+folioNo+"]]></folio_no>\r\n");
						valueXmlString.append("<dp_id protect=\"0\"><![CDATA["+dpIdStr+"]]></dp_id>\r\n");
						valueXmlString.append("<client_id protect=\"0\"><![CDATA["+clientIdStr+"]]></client_id>\r\n");
					}
					else if("P".equalsIgnoreCase(modeOfSecurity))
					{
						valueXmlString.append("<folio_no protect=\"0\"><![CDATA["+folioNo+"]]></folio_no>\r\n");
						valueXmlString.append("<dp_id protect=\"1\"><![CDATA["+dpIdStr+"]]></dp_id>\r\n");
						valueXmlString.append("<client_id protect=\"1\"><![CDATA["+clientIdStr+"]]></client_id>\r\n");
					}
				}

				else if("relationship".equalsIgnoreCase(currentColumn))
				{
					String rel = checkNull(genericUtility.getColumnValue( "relationship", dom , "2" ));
					if( rel.length() > 0 )
					{
					if("self".equalsIgnoreCase(rel))
						{
							sql = "SELECT IT_NO , DDF_GET_MASTERS_NAME('EMPLOYEE', EMP_CODE, 'FML') AS EMP_NAME FROM EMPLOYEE WHERE EMP_CODE = ? " ;
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
								{
									panNo = checkNull(rs.getString("IT_NO"));
									empName = checkNull(rs.getString("emp_name"));
								}
							valueXmlString.append("<pan_no protect=\"1\"><![CDATA["+ panNo + "]]></pan_no>\r\n");
							valueXmlString.append("<relative_name protect=\"1\"><![CDATA["+ empName + "]]></relative_name>\r\n");
						}
						else
						{
							valueXmlString.append("<pan_no protect=\"0\"><![CDATA["+ panNo + "]]></pan_no>\r\n");
							valueXmlString.append("<relative_name protect=\"0\"><![CDATA["+ empName + "]]></relative_name>\r\n");
						}
					}
					else
					{
						valueXmlString.append("<pan_no protect=\"0\"><![CDATA["+ panNo + "]]></pan_no>\r\n");
						valueXmlString.append("<relative_name protect=\"0\"><![CDATA["+ empName + "]]></relative_name>\r\n");
						//valueXmlString.append("<pan_no>").append("<![CDATA[]]>").append("</pan_no>");
					}
				}

				else if( "mode_of_security".equalsIgnoreCase(currentColumn) )
				{
					modeOfSecStr = checkNull(genericUtility.getColumnValue("mode_of_security", dom , "2"));
					if( modeOfSecStr.length() > 0 )
					{
					if("E".equalsIgnoreCase(modeOfSecStr))
						{
						valueXmlString.append("<folio_no protect=\"1\"><![CDATA["+ folioId + "]]></folio_no>\r\n");
						valueXmlString.append("<client_id protect=\"0\"><![CDATA[]]></client_id>\r\n");
						valueXmlString.append("<dp_id protect=\"0\"><![CDATA[]]></dp_id>\r\n");
						}
					else if("P".equalsIgnoreCase(modeOfSecStr))
						{
						valueXmlString.append("<client_id protect=\"1\"><![CDATA["+ clientId + "]]></client_id>\r\n");
						valueXmlString.append("<dp_id protect=\"1\"><![CDATA["+ dpId + "]]></dp_id>\r\n");
						valueXmlString.append("<folio_no protect=\"0\"><![CDATA[]]></folio_no>\r\n");
						}
					}
					else
					{
						valueXmlString.append("<folio_no protect=\"0\"><![CDATA[]]></folio_no>\r\n");
						valueXmlString.append("<client_id protect=\"0\"><![CDATA[]]></client_id>\r\n");
						valueXmlString.append("<dp_id protect=\"0\"><![CDATA[]]></dp_id>\r\n");
					}
				}
			}
			valueXmlString.append("</Detail2>");
			break;
			}			
		} catch (Exception e) {
			try {
				e.printStackTrace();
				throw new ITMException(e);
			} catch (Exception ex) {
				ex.printStackTrace();
				throw new ITMException(ex);
			}
		} finally {
			try {

				if (conn != null) {
					conn.close();
					conn = null;
				}
				if(rs != null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
			}
	
	private String getDomID(Document doc) 
	{

		String delDomId = "";
		Document valDoc = null;
		Document delDoc = null;
		XPathFactory xPathfactory = XPathFactory.newInstance();
		XPath xpath = xPathfactory.newXPath();

		try {

			XPathExpression expr = xpath.compile("//ep/source[@type]");
			NodeList nl = (NodeList) expr.evaluate(doc, XPathConstants.NODESET);
			for (int i = 0; i < nl.getLength(); i++) 
			{
				Node currentItem = nl.item(i);
				String upflag = currentItem.getAttributes().getNamedItem("updateFlag").getNodeValue();
				delDomId = currentItem.getAttributes().getNamedItem("domID").getNodeValue();

			}

		} 
		catch (Exception Ex) 
		{
			Ex.printStackTrace();
		}
		return delDomId;

	}
}

