package ibase.webitm.servlet.dis;

import java.util.ArrayList;

import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.w3c.dom.Document;

import ibase.ejb.CommonDBAccessLocal;
import ibase.servlet.Messages;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.dis.SCMWebServiceDao;
import ibase.webitm.utility.ITMException;

@Path("/scm")
public class SCMWebService 
{
	SCMWebServiceDao scmWSDao = new SCMWebServiceDao();
	
	@POST
	@Path("/addTransaction")
	@Produces({"application/xml"})
	public Response addTransaction(@Context HttpServletRequest request, @FormParam("DATA_XML") String dataXML, @FormParam("USERNAME") String userCode, @FormParam("PASSWORD") String password)
	{
		String retString = "";
		ArrayList<String> langAndCountryList = new ArrayList<String>(); 

		CommonDBAccessLocal commonDBAccessLocal = null;
		try
		{
			if(dataXML == null || dataXML.trim().length() == 0 || userCode == null || userCode.trim().length() == 0 || password == null || password.trim().length() == 0)
			{
				System.out.println("IN missing parameters");
				retString = "<Root><tran_id><![CDATA[]]></tran_id><msg_code><![CDATA[]]></msg_code><msg_descr><![CDATA[Missing required paramters]]></msg_descr><result><![CDATA[FAILED]]></result></Root>";
				return Response.status(HttpServletResponse.SC_BAD_REQUEST).entity(retString).build();
			}
			commonDBAccessLocal = (CommonDBAccessLocal)getInitialContext().lookup("ibase/CommonDBAccessEJB/local");
			String siteCode = commonDBAccessLocal.getDBColumnValue( "USERS", "SITE_CODE__DEF","WHERE CODE = "+"'" +userCode+"'" );
			String xmlInfoStr = commonDBAccessLocal.authenticate(userCode, password, siteCode, "I", "true");
			System.out.println("authRetString["+xmlInfoStr+"]");
			
			String userLanguage = commonDBAccessLocal.getDBColumnValue( "USERS", "USER_LANG","WHERE CODE = "+"'" +userCode+"'" );
			String userCountry = commonDBAccessLocal.getDBColumnValue( "USERS", "USER_COUNTRY", "WHERE CODE = "+"'" +userCode+"'" );
			if( userLanguage != null && userCountry != null )
			{
				langAndCountryList.add( userLanguage );
				langAndCountryList.add( userCountry );
			}
			
			retString = generateResponse(xmlInfoStr, langAndCountryList);
			
			if(retString != null && retString.trim().length()>0)
			{
				return Response.status(HttpServletResponse.SC_UNAUTHORIZED).entity(retString).build();
			}
			
			retString = scmWSDao.addTransaction(dataXML, userCode);
		}
		catch(Exception e)
		{
			System.out.println("SCMWebService.addTransaction()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return Response.status(HttpServletResponse.SC_OK).entity( retString ).build();
	}
	
	private String generateResponse( String xmlInfo, ArrayList<String> langAndCountryList )throws BaseException
	{
		StringBuffer responseString = new StringBuffer();
		String errorMessage = "";
		try
		{
			if ( E12GenericUtility.checkNull( xmlInfo ).length() > 0 )
			{
				Document document = new E12GenericUtility().parseString( xmlInfo );
				if ( document.getElementsByTagName( "STATUS_CODE" ).item(0) != null && document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null )
				{
					String statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
					if ( statusCode.equalsIgnoreCase("RESIGNED") )
					{
						errorMessage = Messages.getString( "AuthenticateServlet_employeeHasResigned", langAndCountryList );
					}
					else if ( statusCode.equalsIgnoreCase("LOCKED") )
					{
						errorMessage = Messages.getString( "AuthenticateServlet_accountIsLockedContactAdmin", langAndCountryList );
					}
					else if ( statusCode.indexOf("INVALID") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("INVALID_USR") )
						{
							errorMessage = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", langAndCountryList );
						}
						else if ( statusCode.equalsIgnoreCase("INVALID_PWD") )
						{
							errorMessage = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", langAndCountryList );
						}
					}
					else if( statusCode.indexOf("PASS_EXP") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("PASS_EXP_NOGRACE") )
						{
							errorMessage = Messages.getString( "AuthenticateServlet_passwordExpiredChangeIt", langAndCountryList );
						}
					}
					
					if( !"VALID".equalsIgnoreCase(statusCode) )
					{
						responseString.append("<Root>");
						responseString.append("<tran_id><![CDATA[]]></tran_id>");
						responseString.append("<msg_code><![CDATA[]]></msg_code>");
						responseString.append("<msg_descr><![CDATA["+errorMessage+"]]></msg_descr>");
						responseString.append("<result><![CDATA[FAILED]]></result>");
						responseString.append("</Root>");
					}
				}
			}
			
			
			System.out.println("Final auth retString["+responseString.toString()+"]");
		}
		catch( BaseException be )
		{
			System.out.println("Exception: generateResponse:==>\n"+be);
			throw be;
		}
		catch( Exception e )
		{
			System.out.println("Exception: generateResponse:==>\n"+e);
			throw new BaseException( e );
		}
		return responseString.toString();
	}
	
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "SCMWebService : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "SCMWebService : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
}
