import { Component, OnInit, Output, EventEmitter } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';

import { Store } from '@ngrx/store';
import { AppState } from '../ecm-store/reducers';
import { CategoryActions, SubCategoryActions, ItemActions } from '../ecm-store/actions';

import { Observable } from 'rxjs/Observable';
import { HostUrlService } from '../host-url.service';

@Component({
  selector: 'ecm-nav-menu',
  templateUrl: './ecm-nav-menu.component.html',
  styleUrls: ['./ecm-nav-menu.component.css']
})
export class ECMNavMenuComponent implements OnInit {
 
  @Output() closePanel = new EventEmitter();  
  categoryList;
  subcategoryList;
  subcategories;
  userData;
  hoverIdx = -1;
  menu: Observable<any>;
    hostUrl;

  constructor(public hostUrlService : HostUrlService,private store: Store<AppState> , private router: Router, private route: ActivatedRoute, private itemAction: ItemActions/*, private categoryAction:CategoryActions*/, private subCategoryAction: SubCategoryActions) {
  		this.hostUrl=this.hostUrlService.hostUrl;
   }
  ngOnInit() {
      this.getCategories();
      this.createUserData();
      console.log( 'ECMNavComponent onInit hostUrl' , this.hostUrl);
  }
  
  getCategories() {
      this.menu = this.store.select('menuList');
      this.menu.subscribe( menuList => {
          this.categoryList = menuList.summary;
          console.log('menuList.summary',menuList,  menuList.summary);
      });
  }
  
  viewAllSubCategory(category) {
      console.log('viewAllSubCategory');
      this.closePanel.emit();
      if( category.subcategory )
      {
          this.store.dispatch( this.subCategoryAction.resetSubCategoryList() );
          this.store.dispatch( this.subCategoryAction.loadSubCategories( category.catCode ) );
          //this.store.dispatch(this.categoryAction.getCategorySuccess(category));    
          this.router.navigate([ '/categories', category.catCode]);
      }
      if( !category.subcategory )
      {
          this.store.dispatch( this.itemAction.loadItems( category.catCode ) );
          this.router.navigate([ '/products', category.catCode]);
      }
  }
 
  viewAllCategories() {
      let openRoutePath = this.route.snapshot.url[0].path;
      this.closePanel.emit();
      if ( openRoutePath !== 'home' )
      {
          this.router.navigate( ['/home'] );
      }
      else
      {
          window.scrollTo( 0, 1100 );
      }
  }
  
  viewAllProducts(subcategory, hoverIdx) {
      console.log('viewAllProducts for subcat:',subcategory);
      //this.closePanel.emit();
      //this.store.dispatch( this.subCategoryAction.getSubCategorySuccess(subcategory) );
      
      //let category = this.categoryList.find( category => category.catCode === subcategory.catCode);
      //this.store.dispatch(this.categoryAction.getCategorySuccess(category));
      this.closePanel.emit();
      this.store.dispatch( this.subCategoryAction.resetSubCategoryList() );
      this.store.dispatch( this.subCategoryAction.loadSubCategories( this.categoryList[hoverIdx].catCode ) );
      this.store.dispatch( this.itemAction.resetItemList() );
      this.store.dispatch( this.itemAction.loadItems( subcategory.scatCode ) );
      this.router.navigate( ['/products', subcategory.scatCode] );
  }
  
  viewItem(itemCode) {
      this.closePanel.emit();
      this.store.dispatch( this.itemAction.getItem(itemCode) );
      this.router.navigate( ['/detail', itemCode] );
  }
  
  goToWishlist() {
      this.closePanel.emit();
      this.router.navigate(['/wishlist']);
  }
  
  goToMyProfile() {
      this.closePanel.emit();
      this.router.navigate(['/myprofile']);
  }
  
  goToMyOrders() {
      this.closePanel.emit();
      this.router.navigate(['/myOrder']);
  }
  
  createUserData() {
      var userInfo = localStorage.getItem( 'userInfo' );
      if ( userInfo !== 'undefined' && userInfo !== null && userInfo !== 'null' ) 
      {
          this.userData = JSON.parse( userInfo );
      }
      else 
      {
          this.userData = null;
      }
  }
  
}
