import { Component, OnInit, OnDestroy, AfterViewChecked } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { JwtHelper } from 'angular2-jwt';
import { RESIZE_EVENT } from '../ecm-store/ecm-resize';

@Component({
  selector: 'ecm-home',
  templateUrl: './ecm-home.component.html',
  styleUrls: ['./ecm-home.component.css']
})
export class ECMHomeComponent implements OnInit, OnDestroy, AfterViewChecked {
  jwtHelper: JwtHelper = new JwtHelper();
  clientWidth;
  constructor(private router: Router, private route: ActivatedRoute) { }
  ngOnInit() {
    console.log(' ECMHomeComponent ngOnInit');
    let appstateCahce: string = localStorage.getItem('appstate') ? localStorage.getItem('appstate') : 'no-appstate';
    console.log(' ECMHomeComponent appstateCahce[' + appstateCahce + ']');

    if( appstateCahce !== 'undefined' && appstateCahce !== 'no-appstate' ){
      this.goToLink(appstateCahce);
    }       
    this.clientWidth = document.documentElement.clientWidth;
    RESIZE_EVENT.subscribe(data => {
        this.clientWidth = data;
    });
  }
  ngAfterViewChecked() {
    let appstateCahce: string = localStorage.getItem('appstate') ? localStorage.getItem('appstate') : 'no-appstate';
/*
    if ( appstateCahce === 'no-appstate' ) {
     window.scrollBy(0, 1);
    } else */if ( appstateCahce !== 'undefined' && appstateCahce !== 'no-appstate' ) {
      this.goToLink(appstateCahce);
      localStorage.setItem('appstate', 'undefined');
    }
  }
  goToHome() {
    this.router.navigate([]);
  }
  goToLink( appstate: string ) {
    this.router.navigate(['/link', appstate]);
  }
  ngOnDestroy() {
    console.log(' ECMHomeComponent ngOnDestroy');
  }
}
