/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PathsContext {
    private final Map<String, Boolean> pathsEncounteredState = new HashMap<String, Boolean>();

    public boolean containsPath(String path) {
        return this.pathsEncounteredState.keySet().contains(path);
    }

    public void addPath(String path) {
        this.pathsEncounteredState.put(path, Boolean.FALSE);
    }

    public void markEncounteredPath(String path) {
        this.pathsEncounteredState.put(path, Boolean.TRUE);
    }

    public Set<String> getEncounteredPaths() {
        return this.pathsEncounteredState.keySet();
    }

    public Set<String> getUnEncounteredPaths() {
        HashSet<String> unEncounteredPaths = new HashSet<String>();
        for (String path : this.pathsEncounteredState.keySet()) {
            if (!this.notEncountered(path)) continue;
            unEncounteredPaths.add(path);
        }
        return unEncounteredPaths;
    }

    private boolean notEncountered(String path) {
        return this.pathsEncounteredState.get(path) == false;
    }
}

