

/********************************************************
	Title : 
	Date  :13/10/2011
	Developer: Dipak Chattar

********************************************************/

package ibase.webitm.ejb.wms;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; // added for ejb3


@Stateless // added for ejb3

public class BolVal extends ValidatorEJB implements BolValLocal, BolValRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(DOM)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param xmlString contains the current form data in XML format
	* @param xmlString1 contains all the header information in the XML format
	* @param objContext represents the form number
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/	
	public String wfValData(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
	    Document dom = null;
		Document dom1 = null;
		try
		{
		  System.out.println("Val xmlString :: " + xmlString);
		  System.out.println("Val xmlString1 :: " + xmlString1);
		  dom = parseString(xmlString);
		  dom1 = parseString(xmlString1);
		  errString = wfValData(dom, dom1, objContext, editFlag, xtraParams);
	    }
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param dom contains the current form data as a document object model
	 * @param dom1 contains all the header information
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	
	public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		int cnt = 0;
		int currentFormNo = 0;
		int childNodeListLength;
		String childNodeName = null;
		String errString = "";
		String userId = "";
		String sql = "";
		String custCodeDlv = "";
		String sordNo = "";
		String despId = "";
		String customerCode = "";
		String siteCode = "";
		String tranCode = "";
		String scAc = "";
		String customerOrderNo = "";
		String waveId = "";
		String nmfcCode = "";
		String freightClass = "";
		String shipDate = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
		   
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch(currentFormNo)
			{
				case 1 :
							parentNodeList = dom.getElementsByTagName("Detail1");
							parentNode = parentNodeList.item(0);
							childNodeList = parentNode.getChildNodes();
							childNodeListLength = childNodeList.getLength();
							for(ctr = 0; ctr < childNodeListLength; ctr ++)
							{
								childNode = childNodeList.item(ctr);
								childNodeName = childNode.getNodeName();
								if(childNodeName.equalsIgnoreCase("site_code"))
								{   
									siteCode = genericUtility.getColumnValue("site_code", dom); 
									if(siteCode == null || (siteCode.length() == 0))
									{
										errList.add("VMSITECOD");
										errFields.add(childNodeName.toLowerCase());
									}
									if(siteCode != null && (siteCode.trim().length()!= 0))
									{
										sql = " select count(*) from site where site_code = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,siteCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "site_code", "VMSITE1", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									
									}
                              
							    
								}

								else if(childNodeName.equalsIgnoreCase("cust_code__dlv"))
								{ 
									custCodeDlv = genericUtility.getColumnValue("cust_code__dlv", dom); 
									if(custCodeDlv != null && custCodeDlv.trim().length() > 0)
									{
										sql = " select count(*) from sorder where cust_code__dlv = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,custCodeDlv);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "cust_code__dlv", "VMCCDLV", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
										
									}
                                }                  	 
                  
								else if(childNodeName.equalsIgnoreCase("sord_no"))
								{ 
									sordNo = genericUtility.getColumnValue("sord_no", dom); 
									if(sordNo != null && sordNo.trim().length() > 0)
									{
										sql = " select count(*) from sorder where sale_order = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,sordNo);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "sord_no", "VMSORDN", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
                     	        }
								
								else if(childNodeName.equalsIgnoreCase("desp_id"))
								{ 
									despId = genericUtility.getColumnValue("desp_id", dom); 
									if(despId != null && despId.trim().length() > 0)
									{
										sql = " select count(*) from despatch where desp_id = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,despId);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "desp_id", "VMDSPID", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
                     	 
								}	
                     	
								else if(childNodeName.equalsIgnoreCase("customer_code"))
								{ 
									customerCode = genericUtility.getColumnValue("customer_code", dom); 
									if(customerCode != null && customerCode.trim().length() > 0)
									{
										sql = " select count(*) from sorder where cust_code = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,customerCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "customer_code", "INVLDCUST", userId );
											}									
										}
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									} 
								}
                     	 
								
							else if(childNodeName.equalsIgnoreCase("tran_code"))
								{ 
									tranCode = genericUtility.getColumnValue("tran_code", dom); 
									if(tranCode != null && tranCode.trim().length() > 0)
									{
										sql = " select count(*) from transporter where tran_code = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,tranCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "tran_code", "VTTRANCOD", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									} 
								}
                     	
								else if(childNodeName.equalsIgnoreCase("scac"))
								{ 
									scAc = genericUtility.getColumnValue("scac", dom); 
									if(scAc != null && scAc.trim().length() > 0)
									{
										sql = " select count(*) from transporter where scac = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,scAc);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "scac", "VTSCACC", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									} 
								}
								
								         
							  else if(childNodeName.equalsIgnoreCase("customer_order__no"))
								{ 
									customerOrderNo = genericUtility.getColumnValue("customer_order__no", dom); 
									if(customerOrderNo != null && customerOrderNo.trim().length() > 0)
									{
										sql = " select count(*) from sorder where cust_pord = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,customerOrderNo);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "customer_order__no", "VTCUSTO", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
								}
						
								else if(childNodeName.equalsIgnoreCase("wave_id"))
								{ 
									waveId = genericUtility.getColumnValue("wave_id", dom); 
									if(waveId != null && waveId.trim().length() > 0)
									{
										sql = " select count(*) from despatch where wave_id = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,waveId);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "wave_id", "VMWAVID", userId );
											}									
										}
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
								}
                       	
							   else if(childNodeName.equalsIgnoreCase("nmfc_code"))
								{ 
									nmfcCode = genericUtility.getColumnValue("nmfc_code", dom); 
									if(nmfcCode != null && nmfcCode.trim().length() > 0)
									{
										sql = " select count(*) from item where nmfc_code = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,nmfcCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "nmfc_code", "VTNMFCC", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}			       
									}
              					}

								else if(childNodeName.equalsIgnoreCase("freight_class"))
								{ 
									freightClass = genericUtility.getColumnValue("freight_class", dom); 
									if(freightClass != null && freightClass.trim().length() > 0)
									{
										sql = " select count(*) from item where frt_class = ? ";
										pstmt =  conn.prepareStatement(sql);
										pstmt.setString(1,freightClass);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											if(cnt == 0) 
											{
												errString = getErrorString( "freight_class", "VMFRTCL", userId );
											}									
										}
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
								}
                    	 
								else if(childNodeName.equalsIgnoreCase("ship_date"))
								{ 
									shipDate = genericUtility.getColumnValue("ship_date", dom); 
									if(shipDate != null && shipDate.trim().length() > 0)
									{
										sql = " select count(*) from despatch where desp_date = ? ";
										pstmt =  conn.prepareStatement(sql);
										//pstmt.setTimestamp(1,Timestamp.valueOf(dbDateFormat.format(simpleDateFormat.parse(shipDate)).toString()+ " 00:00:00.0"));
										pstmt.setString(1,shipDate);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cnt =  rs.getInt(1);
											System.out.println("--------------------count-------------------------------" + cnt);
											if(cnt == 0) 
											{
												errString = getErrorString( "ship_date", "VTSHIPIDTE", userId );
											}									
										}
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
									}
								}
                                    		
                            }
							break;
                   
			} //end switch
			
		}//end try
		
 		catch(Exception e)
		{
		  e.printStackTrace();
		  errString = e.getMessage();
		  throw new ITMException(e);
		}
		
	   finally
		{
		  try
		    {
			  if(conn != null)
			   {
				  if(rs != null) 
				  rs.close();
				  rs = null;
				  if(pstmt != null) 
				  pstmt.close();
				  pstmt = null;
				  conn.close();
				}
				 conn = null;
			} 
		  catch(Exception d)
			{
			  d.printStackTrace();
			  throw new ITMException(d);
			}
		}
		
		
		return errString;
	}//end of validation



	/**
	* The public method is used for converting the current form data into a document(dom)
	* The dom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param xmlString contains the current form data in XML format
	* @param xmlString1 contains all the header information in the XML format
	* @param objContext represents the form number
	* @param currentColumn represents the value of current field.
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
   public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
	  Document dom = null;
	  Document dom1 = null;
	  String valueXmlString = "";
	  try
		{   
		  dom = parseString(xmlString);
		  dom1 = parseString(xmlString1);
		  valueXmlString = itemChanged(dom, dom1, objContext, currentColumn, editFlag, xtraParams);
		}
	  catch(Exception e)
		{
		  System.out.println("Exception : [BolVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
        return valueXmlString;
	}

   /**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param dom contains the current form data as a document object model
	 * @param dom1 contains all the header information
	  * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
   public String itemChanged(Document dom, Document dom1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
	  StringBuffer valueXmlString = new StringBuffer();
	  String siteCode = "";
	  String custCode = "";
	  String custCodeDlv = "";
	  String description = "";
	  String tranCode = "";
	  String nmfcCode = "";
	  int currentFormNo = 0;
	  Connection conn = null;
	  PreparedStatement pstmt = null;
	  ResultSet rs = null ;
	  GenericUtility genericUtility = GenericUtility.getInstance();
	  ConnDriver connDriver = new ConnDriver();
	  
	  try
		{   
		  conn = connDriver.getConnectDB("DriverITM");
		  conn.setAutoCommit(false);
		  connDriver = null;
		  if(objContext != null && objContext.trim().length() > 0)
		   {
			 currentFormNo = Integer.parseInt(objContext);
		   }
		  valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
		  valueXmlString.append(editFlag).append("</editFlag> </header>");
		  

		  switch(currentFormNo)
			{
			  case 1 : 
				  		valueXmlString.append("<Detail1>");
					 				   
				       if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					    {
						  siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
						  valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
                          description = findValue(conn, "descr" ,"site", "site_code", siteCode);
                           valueXmlString.append("<descr protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</descr>");
                          description = findValue(conn, "add1" ,"site", "site_code", siteCode);
                          valueXmlString.append("<add1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add1>");
                          description = findValue(conn, "add2" ,"site", "site_code", siteCode);
                          valueXmlString.append("<add2 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add2>");
                          description = findValue(conn, "city" ,"site", "site_code", siteCode);
                          valueXmlString.append("<city protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</city>");
                          description = findValue(conn, "state_code" ,"site", "site_code", siteCode);
                          valueXmlString.append("<state_code protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</state_code>");
                          description = findValue(conn, "pin" ,"site", "site_code", siteCode);
                          valueXmlString.append("<pin protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</pin>");
                          
					    }//end of if

                       else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					    {
                    	   siteCode = genericUtility.getColumnValue("site_code", dom);
 				    	   description = findValue(conn, "descr" ,"site", "site_code", siteCode);
                           valueXmlString.append("<descr protect = \"1\">").append("<![CDATA[" + description + "]]>").append("</descr>");
                           description = findValue(conn, "add1" ,"site", "site_code", siteCode);
                           valueXmlString.append("<add1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add1>");
                           description = findValue(conn, "add2" ,"site", "site_code", siteCode);
                           valueXmlString.append("<add2 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add2>");
                           description = findValue(conn, "city" ,"site", "site_code", siteCode);
                           valueXmlString.append("<city protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</city>");
                           description = findValue(conn, "state_code" ,"site", "site_code", siteCode);
                           valueXmlString.append("<state_code protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</state_code>");
                           description = findValue(conn, "pin" ,"site", "site_code", siteCode);
                           valueXmlString.append("<pin protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</pin>");
                           custCodeDlv = genericUtility.getColumnValue("cust_code__dlv", dom);
                    	   description = findValue(conn, "dlv_add1" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_add1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_add1>");
                           description = findValue(conn, "dlv_add2" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_add2 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_add2>");
                           description = findValue(conn, "dlv_city" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_city protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_city>");
                           description = findValue(conn, "state_code__dlv" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<state_code__dlv protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</state_code__dlv>");
                           description = findValue(conn, "dlv_pin" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_pin protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_pin>");
                           nmfcCode = genericUtility.getColumnValue("nmfc_code", dom);
                    	   description = findValue(conn, "nmfc_descr" ,"item", "nmfc_code", nmfcCode);
 				    	   valueXmlString.append("<nmfc_descr protect = \"1\">").append("<![CDATA[" + description + "]]>").append("</nmfc_descr>");
				          
					    }

                       else if(currentColumn.trim().equalsIgnoreCase("cust_code__dlv"))
					    {
                    	   custCodeDlv = genericUtility.getColumnValue("cust_code__dlv", dom);
                    	   description = findValue(conn, "dlv_add1" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_add1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_add1>");
                           description = findValue(conn, "dlv_add2" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_add2 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_add2>");
                           description = findValue(conn, "dlv_city" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_city protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_city>");
                           description = findValue(conn, "state_code__dlv" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<state_code__dlv protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</state_code__dlv>");
                           description = findValue(conn, "dlv_pin" ,"sorder", "cust_code__dlv", custCodeDlv);
                           valueXmlString.append("<dlv_pin protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</dlv_pin>");
                        } 
				       
                       else if(currentColumn.trim().equalsIgnoreCase("customer_code"))
					   {
                    	   custCode = genericUtility.getColumnValue("customer_code", dom);
                    	   description = findValue(conn, "remarks" ,"sorder", "cust_code", custCode);
                    	   valueXmlString.append("<remarks>").append("<![CDATA[" +  description + "]]>").append("</remarks>");
                       } 
				       
                       else if(currentColumn.trim().equalsIgnoreCase("site_code"))
					    {
				    	  siteCode = genericUtility.getColumnValue("site_code", dom);
				    	  description = findValue(conn, "descr" ,"site", "site_code", siteCode);
                          valueXmlString.append("<descr protect = \"1\">").append("<![CDATA[" + description + "]]>").append("</descr>");
                          description = findValue(conn, "add1" ,"site", "site_code", siteCode);
                          valueXmlString.append("<add1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add1>");
                          description = findValue(conn, "add2" ,"site", "site_code", siteCode);
                          valueXmlString.append("<add2 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</add2>");
                          description = findValue(conn, "city" ,"site", "site_code", siteCode);
                          valueXmlString.append("<city protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</city>");
                          description = findValue(conn, "state_code" ,"site", "site_code", siteCode);
                          valueXmlString.append("<state_code protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</state_code>");
                          description = findValue(conn, "pin" ,"site", "site_code", siteCode);
                          valueXmlString.append("<pin protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</pin>");
						}

				       else if(currentColumn.trim().equalsIgnoreCase("tran_code"))
					    {
				    	   tranCode = genericUtility.getColumnValue("tran_code", dom);
				    	  description = findValue(conn, "frt_term" ,"transporter", "tran_code", tranCode);
                         valueXmlString.append("<frt_term>").append("<![CDATA[" + description + "]]>").append("</frt_term>");
						}
				       
				       else if(currentColumn.trim().equalsIgnoreCase("nmfc_code"))
					    {
				    	   nmfcCode = genericUtility.getColumnValue("nmfc_code", dom);
				    	   description = findValue(conn, "nmfc_descr" ,"item", "nmfc_code", nmfcCode);
				    	   valueXmlString.append("<nmfc_descr protect = \"1\">").append("<![CDATA[" + description + "]]>").append("</nmfc_descr>");
						}
                       				   
                        valueXmlString.append("</Detail1>");
		                break;
						
		     }
			           valueXmlString.append("</Root>");
		}
	  catch(Exception e)
		{
		  e.printStackTrace();
		  System.out.println("ExcML document structures must start and end within the same eneption ::"+ e.getMessage());
		  throw new ITMException(e);
		}
	  finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
					pstmt.close();
					if(rs != null)
					rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
				
			}
		   catch(Exception d)
			{
			    d.printStackTrace();
			}			
		}
		 return valueXmlString.toString();
	}	 


 private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{

	  PreparedStatement pstmt = null ;
	  ResultSet rs = null ; 
	  String sql = "";
	  String findValue = "";

	  try
	   {			
		 sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"  = ?";

	     pstmt = conn.prepareStatement(sql);
		 pstmt.setString(1,value);
	     rs = pstmt.executeQuery();
	    	
	     if(rs.next())
	      {					
	    	findValue = rs.getString(columnName);
		  }
		 rs.close();
		 rs = null;
		 pstmt.close();
		 pstmt = null;	        
	   }
	  catch(Exception e)
		{
		  System.out.println("Exception in findValue ");
		  e.printStackTrace();
		  throw new ITMException(e); 
		}

	  System.out.println("returning String from findValue ");
	  return findValue;
	}

}	
	