/**
 *  PURPOSE  : DefaultItemChanged for shipper label generation process
 *  AUTHOR   : Manish 
 *  Obj_name : shipper_label
 */


package ibase.webitm.ejb.wms;

//changed by sumit on 03/10/12 imported class to find printer in system. start.
import java.awt.print.PrinterJob;
import java.io.File;

import javax.print.PrintService;
//changed by sumit on 03/10/12 imported class to find printer in system. end.
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;



import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.SaleOrdItmGen;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GeneShipLabelsIC extends ValidatorEJB implements GeneShipLabelsICRemote, GeneShipLabelsICLocal{

	/**
	 * The method defined with no parameter and returns nothing
	 */
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}


	/**
	 * The public method is used for itemchange of required fields which return called overloaded method
	 * Returns itemchange string in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr containspoic_wavegen_default_data always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format 
	 * @param objContext represents form no
	 * @param currentColumn represent Current COlumn
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm 
etc
	 */
	public String itemChanged(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if (hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if (allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			errString = defaultItemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :WaveGenerationIC :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from WaveGenerationIC itemChanged" );
		return errString;
	}
	/**
	 * The public overloaded method is used for itemchange of required fields 
	 * Returns itemchange string in XML format
	 * @param currDom contains the current form data 
	 * @param hdrDom contains always header form data
	 * @param allDom contains all forms data 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String defaultItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{

		String siteCode = "";
		String errString = "";
		int currentFormNo = 0;
		String columnValue = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n" );
		E12GenericUtility genericUtility = new E12GenericUtility();
		java.sql.Date dateFrom = null;
		String packCode ="", tranCode = "", descr = "", tranName = "", printer = "";		
		try
		{
			String applDateFmt = genericUtility.getApplDateFormat();
			String dbDateFmt = genericUtility.getDBDateFormat();

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver(); 
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			System.out.println("site code ->["+siteCode+"]");


			String CurDom= genericUtility.serializeDom(currDom);
			System.out.println("currDom ->["+CurDom+"]");

			System.out.println("Current Column> > > > ->["+currentColumn+"]");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			valueXmlString.append("</Header>\r\n" );

			switch ( currentFormNo )
			{
			case 1:
			{

				if ( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					System.out.println("--------------item default --------------");
					valueXmlString.append( "<Detail1>\r\n" );						
					//valueXmlString.append( "<pack_code><![CDATA[" ).append(00).append( "]]></pack_code>\r\n" );
					valueXmlString.append( "</Detail1>\r\n" );
					System.out.println("valueXmlString-------["+valueXmlString+"]");
				}					
				else if ( currentColumn.trim().equalsIgnoreCase( "pack_code" ))
				{
					System.out.println("--------------item Change for pack_code --------------");	
					packCode = genericUtility.getColumnValue("pack_code",currDom);							
					System.out.println("pack_code ["+packCode+"] ");							
					valueXmlString.append( "<Detail1>\r\n" );

					if( (packCode !=null && packCode.trim().length() > 0) )
					{						

						sql = " SELECT DESCR FROM PACKING WHERE PACK_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, packCode);
						rs = pstmt.executeQuery();	

						if(rs.next())
						{
							valueXmlString.append( "<descr><![CDATA[" ).append(rs.getString(1) ).append( "]]></descr>\r\n" );									
						}
						else
						{
							valueXmlString.append( "<descr><![CDATA[" ).append( "" ).append( "]]></descr>\r\n" );
						}

					}
					else
					{
						valueXmlString.append( "<descr><![CDATA[" ).append( "" ).append( "]]></descr>\r\n" );
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					valueXmlString.append( "</Detail1>\r\n" );

				}

				else if ( currentColumn.trim().equalsIgnoreCase( "tran_code" ))
				{
					System.out.println("--------------item Change for tran_code --------------");		
					tranCode = genericUtility.getColumnValue("tran_code",currDom);							
					System.out.println("tran_code ["+tranCode+"] ");							
					valueXmlString.append( "<Detail1>\r\n" );

					if( (tranCode !=null && tranCode.trim().length() > 0) )
					{								
						sql = " SELECT TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE =  ? ";								
						System.out.println("queryString="+sql);
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranCode);
						rs =pstmt.executeQuery();	

						if(rs.next())
						{
							valueXmlString.append( "<tran_name><![CDATA[" ).append( rs.getString(1) ).append( "]]></tran_name>\r\n" );
						}
						else
						{
							valueXmlString.append( "<tran_name><![CDATA[" ).append( "" ).append( "]]></tran_name>\r\n" );
						}				
					}
					else
					{
						valueXmlString.append( "<tran_name><![CDATA[" ).append( "" ).append( "]]></tran_name>\r\n" );
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					valueXmlString.append( "</Detail1>\r\n" );				
				}	
				else if ( currentColumn.trim().equalsIgnoreCase( "PRINTER_NAME" ))
				{
					System.out.println("--------------item Change for printer --------------");		
					printer = genericUtility.getColumnValue("printer_name",currDom);							
					System.out.println("printer_name ["+printer+"] ");							
					valueXmlString.append( "<Detail1>\r\n" );

					if( (printer !=null && printer.trim().length() > 0) )
					{								
						sql = " SELECT PRINTER_DESCR FROM NET_PRINTERS WHERE PRINTER_NAME =  ? ";								
						System.out.println("queryString="+sql);
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,printer);
						rs =pstmt.executeQuery();	

						if(rs.next())
						{
							valueXmlString.append( "<printer_descr><![CDATA[" ).append( rs.getString(1) ).append( "]]></printer_descr>\r\n" );
						}
						else
						{
							valueXmlString.append( "<printer_descr><![CDATA[" ).append( "" ).append( "]]></printer_descr>\r\n" );
						}				
					}
					else
					{
						valueXmlString.append( "<printer_descr><![CDATA[" ).append( "" ).append( "]]></printer_descr>\r\n" );
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					valueXmlString.append( "</Detail1>\r\n" );				
				}	
			}
			break;
			}
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println("Exception: WaveGenerationIC: defaultItemChanged(Document dom): " + e.getMessage() + ":");
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);

		}		
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception es)
			{
				es.printStackTrace();
				errString = genericUtility.createErrorString(es);
			}
		}

		return valueXmlString.toString();		
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}

	/**
	 * The method is defined without any parameter and returns blank string
	 */
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext,editFlag, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{  
		System.out.println("wfValData()");
		String columnValue ="";
		String errString = "";
		String sql ="";
		String packCode ="";
		String ptcn = "";		
		String printer = "";
		String printLabel = "";
		String printStatus = "";
		String tranCode = "";
		String imagePath = "";
		int count = 0, cnt = 0;
		//int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;	

		E12GenericUtility genericUtility = new E12GenericUtility();		

		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		ResultSet rs = null, rs1 = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		Set errSet = null;

		DistCommon discommon = new DistCommon();	

		try
		{	
			int currentFormNo = 0;	
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			boolean packFlag=true;
			boolean tranFlag=true;
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();		

			switch ( currentFormNo )  
			{
			case 1:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");

					if ( "ptcn".equalsIgnoreCase( childNodeName ) )
					{
						if (childNode.getFirstChild() == null)
						{
							errString = getErrorString("PTCN","VTPTCNNN",userId); 
							break ;
						}
						else
						{
							sql = "SELECT COUNT(*) FROM DESPATCH D, WAVE_TASK W, WAVE_TASK_DET WTD WHERE WTD.WAVE_ID = D.WAVE_ID AND D.CONFIRMED = 'N'" +
							" AND WTD.SALE_ORDER = D.SORD_NO AND WTD.REF_ID = D.DESP_ID  AND W.WAVE_ID = WTD.WAVE_ID AND W.CANCEL = 'N' AND W.HOLD_STATUS = 'N' AND WTD.PTCN = ? ";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1, columnValue);
							rs1 = pstmt1.executeQuery();
							if( rs1.next() )
							{
								cnt = rs1.getInt(1);
								if(cnt == 0)
								{
									errString = getErrorString("PTCN","VTPTCNNE",userId); 
									break ;		
								}
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
						}
					}

					else if (( "pack_code".equalsIgnoreCase( childNodeName )) || ( "tran_code".equalsIgnoreCase( childNodeName ) ))
					{
						packCode = genericUtility.getColumnValue("pack_code",currFormDataDom);
						tranCode = genericUtility.getColumnValue("tran_code",currFormDataDom);

						System.out.println("packCode man"+packCode);
						System.out.println("tranCode man"+tranCode);
						if(( packCode == null || packCode.trim().length() == 0 ) && ( tranCode == null || tranCode.trim().length() == 0 ) )
						{
							errString = getErrorString("","VTPACKTRAN",userId); 
							break ;
						}
						else if(packCode != null) 
						{
							System.out.println("packCode manish"+packCode);
							sql = "SELECT COUNT(*) FROM PACKING WHERE PACK_CODE = ?";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1, packCode);
							rs1 = pstmt1.executeQuery();
							if( rs1.next() )
							{
								cnt = rs1.getInt(1);
								if(cnt == 0)
								{
									errString = getErrorString("PACK_CODE","VMPACKCD",userId); 
									break ;		
								}
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;

						}


						else if(tranCode != null )  
						{
							System.out.println("tranCode manish"+tranCode);
							sql = "SELECT COUNT(*) FROM TRANSPORTER WHERE TRAN_CODE = ?";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1, tranCode);
							rs1 = pstmt1.executeQuery();
							if( rs1.next() )
							{
								cnt = rs1.getInt(1);
								if(cnt == 0)
								{
									errString = getErrorString("TRAN_CODE","VMTRAN1",userId); 
									break ;		
								}
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
						}
					}

					else if ( "printer_name".equalsIgnoreCase( childNodeName ) )
					{
						if (childNode.getFirstChild() == null)
						{
							System.out.println(".........no printer........");
						}
						else
						{
							sql = "SELECT COUNT(*) FROM NET_PRINTERS WHERE PRINTER_NAME = ?";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1, columnValue);
							rs1 = pstmt1.executeQuery();
							if( rs1.next() )
							{
								cnt = rs1.getInt(1);
								if(cnt == 0)
								{
									errString = getErrorString("PRINTER_NAME","INVPRINTER",userId); 
									break ;		
								}
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
						}
					}


				}
			} //End of case 1 Validation
			break;				

			}
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: WaveGenerationIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			e.printStackTrace();			
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				

				if( conn != null  )
				{
					conn.close(); conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : WaveGenerationIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}

}
