 package ibase.dashboard.pai.ejb;
 
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;
 
@Stateless
public class CrediteStatusSummary extends ValidatorEJB  implements CrediteStatusSummaryRemote, CrediteStatusSummaryLocal

{
	GenericUtility genericUtility = new GenericUtility();
	
	/********** Start of method getCrediteStatusSummaryServlet()
	* EJB Name           : CrediteStatusSummary.java
	* Method Name        : getCrediteStatusSummaryServlet(String,String)
	* Servlet Name       : CrediteStatusSummaryServlet
	* Metadata xml Name  : creditstatussummary.xml
	* 
	* */
	
	@SuppressWarnings("unchecked")
	public JSONObject getCrediteStatusSummaryServlet(String dataSourceName,String custCode) throws RemoteException, ITMException
	{
		JSONObject pendingOrderJson = new JSONObject();
		JSONObject rowDataPendingQCOrderPurc= new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count=0;
		LinkedHashMap<String, String> catValues = new LinkedHashMap<String, String>();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			SimpleDateFormat appDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat());
			SimpleDateFormat dbDateFormat= new SimpleDateFormat(genericUtility.getDBDateFormat());
			System.out.println(" Inside getCrediteStatusSummaryServlet() Data Soruc Name ="+dataSourceName);
			
			//   -- credit limit
		    sql =    " select credit_lmt,sysdate as curr_date from customer where cust_code = ? ";   
		   
		    pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, custCode);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();	
				catValues = new LinkedHashMap<String, String>();
				rowData.put("product_category",  "Credit Limit");
				String currDate= checkNull(rs.getString("curr_date"));
				if(currDate.trim().length()>0)
				{
					currDate= appDateFormat.format(dbDateFormat.parse(currDate));
				}
				else
				{							
					currDate= checkNull(rs.getString("curr_date"));
				}
				rowData.put("date","0");
				catValues.put(currDate, checkNull(rs.getString("credit_lmt")));
				rowData.put("category_value",catValues);
				pendingOrderJson.put(count, rowData);
				count++;
			 }
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		//   -- over due
		   sql="select sum((case when tot_amt is null then 0 else tot_amt end) - (case when dispute_amt is null then 0 else dispute_amt end)) - sum(case when adj_amt is null then 0 else adj_amt end ) as over_due, sysdate as curr_date " 
			   +" from  receivables "
			   +" where cust_code = ? "
			   +" and due_date < SYSDATE ";
		   
		    pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, custCode);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();	
				catValues = new LinkedHashMap<String, String>();
				rowData.put("product_category",   "Over Due");
				String currDate= checkNull(rs.getString("curr_date"));
				if(currDate.trim().length()>0)
				{
					currDate= appDateFormat.format(dbDateFormat.parse(currDate));
				}
				else
				{							
					currDate= checkNull(rs.getString("curr_date"));
				}
				rowData.put("date","1");
				catValues.put(currDate, checkNull(rs.getString("over_due")));
				rowData.put("category_value",catValues);
				pendingOrderJson.put(count, rowData);
				count++;
			 }
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			   // normal outstanding
			  sql=" select sum((case when tot_amt is null then 0 else tot_amt end) - (case when dispute_amt is null then 0 else dispute_amt end)) - sum(case when adj_amt is null then 0 else adj_amt end ) as out_standing,sysdate as curr_date " 
			   +" from  receivables  where cust_code = ?   and due_date >= SYSDATE " ;
               
			  pstmt = conn.prepareStatement(sql);
			  pstmt.setString(1, custCode);
		       rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();	
				catValues = new LinkedHashMap<String, String>();
				rowData.put("product_category",   "Outstanding");
				String currDate= checkNull(rs.getString("curr_date"));
				if(currDate.trim().length()>0)
				{
					currDate= appDateFormat.format(dbDateFormat.parse(currDate));
				}
				else
				{							
					currDate= checkNull(rs.getString("curr_date"));
				}
				rowData.put("date","2");
				catValues.put(currDate, checkNull(rs.getString("out_standing")));
				rowData.put("category_value",catValues);
				pendingOrderJson.put(count, rowData);
				count++;
			 }
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		 //  --- pending orders value

		   	sql=" SELECT round(sum( sorddet.net_amt * (100 - ( ( case when sorditem.qty_desp is null then 0 else sorditem.qty_desp end ) / sorditem.qty_ord * 100) ) / 100 ),3) as po_value ,sysdate as curr_date"
		   			+" FROM sorddet, sorder, sorditem "  
		   			+" WHERE ( sorddet.sale_order = sorditem.sale_order ) and "  
		   			+" ( sorddet.line_no = sorditem.line_no ) and  "
		   			+" ( sorder.sale_order = sorddet.sale_order ) and "  
		   			+" ( sorder.cust_code__bil = ? ) and  "
		   			+" ( sorder.status = 'P' ) AND  "
		   			+" ( sorditem.qty_ord > 0 ) AND	"														
		   			+" ( sorder.confirmed = 'Y' ) ";	
		   
		    pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, custCode);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();	
				catValues = new LinkedHashMap<String, String>();
				rowData.put("product_category",   "PO Value");
				String currDate= checkNull(rs.getString("curr_date"));
				if(currDate.trim().length()>0)
				{
					currDate= appDateFormat.format(dbDateFormat.parse(currDate));
				}
				else
				{							
					currDate= checkNull(rs.getString("curr_date"));
				}
				rowData.put("date","3");
				catValues.put(currDate, checkNull(rs.getString("po_value")));
				rowData.put("category_value",catValues);
				pendingOrderJson.put(count, rowData);
				count++;
			 }
			
			System.out.println("JSON in getCrediteStatusSummaryServlet() : "+pendingOrderJson);
		 }
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CrediteStatusSummary: getCrediteStatusSummaryServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return pendingOrderJson;
	}
	/********** End of method getCrediteStatusSummaryServlet()  ******/
	

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

 }

