package ibase.dashboard.crm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class PendingCommunicationDashboard implements
PendingCommunicationDashboardLocal, PendingCommunicationDashboardRemote {

	@SuppressWarnings({ "unchecked"})
	public JSONObject getPendingCommunicationDashboard(String dataSourceName,
			String loginCode, String empCode) 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null,pstmtDS = null ;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String sconCode = "", pstmtDSInput = "";
		Date commDate1 = null;
		String dbDataFormat="",applDataFormat ="";
		StringBuffer dataSourceSql = null;
		int count = 0;
		long millis = 0;
		
		StringBuffer xmlString = new StringBuffer();
		millis = System.currentTimeMillis();
		java.sql.Date date = new java.sql.Date(millis);
		System.out.println("Current date :::: "+ date);

		try {
			conn = connection.getConnectDB(dataSourceName);

			dbDataFormat = genericUtility.getDBDateFormat();
			applDataFormat = genericUtility.getApplDateFormat();

			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = loginCode;
			}
			sql = "SELECT cp.scon_code,cp.sales_pers,"+
					"  cp.comm_date,trim(sa.descr) AS activity_descr,"+
					"  CASE CP.CONTACT_TYPE"+
					"    WHEN '1'"+
					"    THEN 'Call'"+
					"    WHEN '2'"+
					"    THEN 'Mail'"+
					"    WHEN '3'"+
					"    THEN 'Meeting'"+
					"    WHEN '4'"+
					"    THEN 'Video Conference Call'"+
					"    WHEN '5'"+
					"    THEN 'Other'  END AS DESCR ,"+
					" (sc.first_name  ||' '   ||   CASE"+
					"    WHEN sc.last_name IS NULL"+
					"    OR LENGTH(trim(sc.last_name)) = 0"+
					"    THEN ''"+
					" ELSE trim(sc.last_name)"+
					"  END) AS contact_name,"+
					"  so.sorg_name,sp.sp_name "+
					" FROM contact_comm_plan cp"+
					" INNER JOIN strg_contact sc"+
					" ON cp.scon_code = sc.scon_code "+
					" LEFT OUTER JOIN strg_org so "+
					" ON so.sorg_code = sc.sorg_code "+
					" INNER JOIN sales_activity sa "+
					" ON sa.activity_code = cp.activity_code "+
					" INNER JOIN SALES_PERS SP " +
					" ON  CP.SALES_PERS = SP.SALES_PERS ";
			
			dataSourceSql = new StringBuffer(sql);
		
			pstmtDSInput = "";
			if(empCode.equalsIgnoreCase("TEAM"))
			{
				dataSourceSql.append(" WHERE SP.EMP_CODE IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO)  AND CP.COMM_ID  IS NULL  AND CP.COMM_DATE <= trunc(SYSDATE)  ORDER BY CP.COMM_DATE desc, CP.START_TIME");
				pstmtDSInput = loginCode;
			}
			else
			{
				dataSourceSql.append(" WHERE SP.EMP_CODE = ?  AND CP.COMM_ID  IS NULL  AND CP.COMM_DATE <= trunc(SYSDATE)  ORDER BY CP.COMM_DATE desc, CP.START_TIME ");
				pstmtDSInput = empCode;
			}
			
			sql = dataSourceSql.toString();
			pstmtDS = conn.prepareStatement(sql);
			pstmtDS.setString(1, pstmtDSInput);
			rs = pstmtDS.executeQuery();
			while (rs.next()) 
			{
				count++;
				if(count == 1)
				{
					if(empCode.equalsIgnoreCase("TEAM"))
					{
						xmlString = new StringBuffer("<table class='mtBackgroundWhite' border='' style='width: 100%;'><tbody><tr>"
								+ "<th class='mtBackgroundWhite' style='width: 2%;'>Sales Person</th>"
								+ "<th class='mtBackgroundWhite' style='width: 1%;'>Date</th>" 
								+"<th class='mtBackgroundWhite' style='width: 3%;'>Contact Person</th>"
								+"<th class='mtBackgroundWhite' style='width: 3%;'>Contact Mode</th>"
								+"<th class='mtBackgroundWhite' style='width: 2%;'>Activity Description</th>"
								+"</tr>");
					}
					else
					{
						xmlString = new StringBuffer("<table class='mtBackgroundWhite' border='' style='width: 100%;'><tbody><tr>"
								+ "<th class='mtBackgroundWhite' style='width: 1%;'>Date</th>" 
								+"<th class='mtBackgroundWhite' style='width: 3%;'>Contact Person</th>"
								+"<th class='mtBackgroundWhite' style='width: 3%;'>Contact Mode</th>"
								+"<th class='mtBackgroundWhite' style='width: 2%;'>Activity Description</th>"
								+"</tr>");
					}
				}
				sconCode = rs.getString("scon_code");
				commDate1 = rs.getDate("comm_date");
				String newdate = (commDate1 != null )? genericUtility.getValidDateString(commDate1.toString(), dbDataFormat, applDataFormat ):null;
				if (commDate1.before(date)) 
				{
					System.out.println("Inside while @@@Pending communication Dashboard");

					if(empCode.equalsIgnoreCase("TEAM")){
						xmlString.append("<tr><td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' style='text-align: center;' >"+checkNull(rs.getString("sp_name"))+"</td>");
						xmlString.append("<td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' s>"+newdate+"</td>");
						xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' >"+(rs.getString("contact_name"))+"</td>");
						xmlString.append("<td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' >"+checkNull(rs.getString("DESCR"))+"</td>");
						xmlString.append("<td rowspan ='2'class= 'cardHtmlTableBodyAlignLft' >"+checkNull(rs.getString("activity_descr"))+"</td></tr>");
						xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;vertical-align:top;'>"+checkNull(rs.getString("sorg_name"))+"</td></tr>");
					}
					else{
						xmlString.append("<tr><td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' >"+newdate+"</td>");
						xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' >"+(rs.getString("contact_name"))+"</td>");
						xmlString.append("<td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' >"+checkNull(rs.getString("DESCR"))+"</td>");
						xmlString.append("<td rowspan ='2'class= 'cardHtmlTableBodyAlignLft' >"+checkNull(rs.getString("activity_descr"))+"</td></tr>");
						xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;vertical-align:top;'>"+checkNull(rs.getString("sorg_name"))+"</td></tr>");
					}

				}
				if(count == 0)
				{
					xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"+
							"align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>No "+
							"Data Found</td></tr>");
				}

			}
			if (rs != null) {
				rs.close();
				rs = null;
			}

			if (pstmtDS != null) {
				pstmtDS.close();
				pstmtDS = null;
			}
			
			System.out.println("xmlString ::::[ "+xmlString+" ]");
			xmlString.append("</tbody></table>");
			rowData =new JSONObject();
			rowData.put("xmlString", xmlString.toString());
			rowDataBasicJsn.put(0,rowData);
			
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Pending Communication Dashboard :::: "+ e.getMessage());
		} finally {
			try {
							
				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;

			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}
		return rowDataBasicJsn;
	}

	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str.trim();
		}
	}
}
