/**
 *  PURPOSE  : DefaultItemChanged for wave generation process
 *  AUTHOR   : Changed By Sumit On 28/11/2012 WM1ESUN006 
 *  Obj_name : w_wavegen
 */


package ibase.webitm.ejb.wms;

//changed by sumit on 03/10/12 imported class to find printer in system. start.
import java.awt.print.PrinterJob;
import javax.print.PrintService;
//changed by sumit on 03/10/12 imported class to find printer in system. end.
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;



import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.SaleOrdItmGen;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class WaveGenerationIC extends ValidatorEJB implements WaveGenerationICRemote, WaveGenerationICLocal{
	
	/**
	* The method defined with no parameter and returns nothing
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	
	/**
	 * The public method is used for itemchange of required fields which return called overloaded method
	 * Returns itemchange string in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr containspoic_wavegen_default_data always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format 
	 * @param objContext represents form no
	 * @param currentColumn represent Current COlumn
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm 
etc
	*/
	public String itemChanged(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if (currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if (hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if (allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			errString = defaultItemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :WaveGenerationIC :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from WaveGenerationIC itemChanged" );
		return errString;
	}// end ItemChanged Method
	
	/**
	 * The public overloaded method is used for itemchange of required fields 
	 * Returns itemchange string in XML format
	 * @param currDom contains the current form data 
	 * @param hdrDom contains always header form data
	 * @param allDom contains all forms data 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
    */
	public String defaultItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		
		String siteCode = "";
		String errString = "";
		int currentFormNo = 0;
		String columnValue = "";
		String sSQL = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n" );
		GenericUtility genericUtility = GenericUtility.getInstance();
		java.sql.Date dateFrom = null;
		String custCodeFrom ="";
		String custCodeTo = "";
		String singleLotSl = "";
		String masterPackAllow = "";
		String activePickAllow = "";
		String stockToDockAllow = "";
		String saleOrderFrom = "";
		String saleOrderTo = "";
		
		try
		{
			String applDateFmt = genericUtility.getApplDateFormat();
			String dbDateFmt = genericUtility.getDBDateFormat();
			
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			System.out.println("site code ->["+siteCode+"]");
			
			System.out.println("Current Column> > > > ->["+currentColumn+"]");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			valueXmlString.append("</Header>\r\n" );
			
			switch ( currentFormNo )
			{
			  	case 1:
				{
								
					if ( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						System.out.println("--------------item default --------------");
						valueXmlString.append( "<Detail1>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<item_ser__from><![CDATA[" ).append( "00" ).append( "]]></item_ser__from>\r\n" );
						valueXmlString.append( "<item_ser__to><![CDATA[" ).append( "ZZ" ).append( "]]></item_ser__to>\r\n" );
						valueXmlString.append( "<item_code__from><![CDATA[" ).append( "00" ).append( "]]></item_code__from>\r\n" );
						valueXmlString.append( "<item_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></item_code__to>\r\n" );
						valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
						valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
						valueXmlString.append( "<sale_order__from><![CDATA[" ).append( "00" ).append( "]]></sale_order__from>\r\n" );
						valueXmlString.append( "<sale_order__to><![CDATA[" ).append( "ZZ" ).append( "]]></sale_order__to>\r\n" );
						//Added by Chandni 30-May-2012
						valueXmlString.append( "<cust_code__dlv__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__dlv__from>\r\n" );
						valueXmlString.append( "<cust_code__dlv__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__dlv__to>\r\n" );
						//Ended by chandni 30-May-2012
						//Changed by sumit on 27/07/12 set PREVIEW in wave_task default 
						valueXmlString.append( "<wave_mode><![CDATA[" ).append( "R" ).append( "]]></wave_mode>\r\n" );
						//Changed by sumit on 18/09/12 for single lot and Packing allow start. 
						valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
						valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
						valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
						valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
						//Changed by sumit on 18/09/12 for single lot and Packing allow end. 
						valueXmlString.append( "</Detail1>\r\n" );
					}
					//Changed By Pragyan 21/06/12 Statrt
					else if ( currentColumn.trim().equalsIgnoreCase( "sale_order__from" ))
					{
							
							columnValue = genericUtility.getColumnValue("sale_order__from",currDom);
							custCodeTo = checkNull(genericUtility.getColumnValue("cust_code__to",currDom));
							saleOrderTo = checkNull(genericUtility.getColumnValue("sale_order__to",currDom));
							System.out.println("sale order from ["+columnValue+"] ");
							System.out.println("Hello sale_order__from");
							valueXmlString.append( "<Detail1>\r\n" );
							if(columnValue != null && !columnValue.equalsIgnoreCase("00"))
							{
								
								System.out.println("Hello sale_order__from2");
								//Changed by sumit 20/09/12 getting cust code start.								
								//sSQL = "SELECT DUE_DATE FROM SORDER WHERE SALE_ORDER = ?";
								sSQL = " SELECT S.DUE_DATE,C.CUST_CODE, C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
										" FROM SORDER S, CUSTOMER C, WAVE_TYPE W  WHERE SALE_ORDER = ? " +
										" AND C.CUST_CODE = S.CUST_CODE " +
										" AND C.WAVE_TYPE = W.WAVE_TYPE ";
								System.out.println("queryString="+sSQL);
								pstmt = conn.prepareStatement(sSQL);
								pstmt.setString(1,columnValue);
								rs=pstmt.executeQuery();
								
								if(rs.next())
								{
									dateFrom = rs.getDate(1);
									custCodeFrom = rs.getString("CUST_CODE").trim();
									singleLotSl = rs.getString("SINGLE_LOT");
									masterPackAllow = rs.getString("MASTER_PACK_ALLOW");
									activePickAllow = rs.getString("ACTIVE_PICK_ALLOW");
									stockToDockAllow = rs.getString("STOCK_TO_DOCK_ALLOW");
								}
								
								if(dateFrom != null)
								{
									String tranDate = genericUtility.getValidDateString( dateFrom.toString() , dbDateFmt, applDateFmt );
									//String dateFromInString=dtFormat.format(dateFrom);
									System.out.println("currDateStr=+++++++++++++"+tranDate);
									System.out.println("Hello sale_order__from3");
									valueXmlString.append( "<due_date__from><![CDATA[" ).append( tranDate ).append( "]]></due_date__from>\r\n" );
									//Changed by sumit on 20/09/12 setting value of cust_code__from.
									
									if( columnValue.trim().equalsIgnoreCase(saleOrderTo.trim()))
									{
										valueXmlString.append( "<cust_code__from><![CDATA[" ).append( custCodeFrom ).append( "]]></cust_code__from>\r\n" );
										valueXmlString.append( "<cust_code__to><![CDATA[" ).append( custCodeFrom ).append( "]]></cust_code__to>\r\n" );
										valueXmlString.append( "<single_lot protect ='0' ><![CDATA[" ).append( checkNull(singleLotSl) ).append( "]]></single_lot>\r\n" );
										valueXmlString.append( "<master_pack_allow protect ='0' ><![CDATA[" ).append( checkNull(masterPackAllow) ).append( "]]></master_pack_allow>\r\n" );
										valueXmlString.append( "<active_pick_allow protect ='0' ><![CDATA[" ).append( checkNull(activePickAllow) ).append( "]]></active_pick_allow>\r\n" );
										valueXmlString.append( "<stock_to_dock_allow protect ='0' ><![CDATA[" ).append( checkNull(stockToDockAllow) ).append( "]]></stock_to_dock_allow>\r\n" );
									}
									else
									{
										valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
										valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
										valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
										valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
										valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
										valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );										
									}
									System.out.println("Hello sale_order__from4");
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt=null;
									}
									if(rs!=null)
									{
										rs.close();
										rs=null;
									}
								}
								else
								{									
									valueXmlString.append( "<due_date__from><![CDATA[" ).append("" ).append( "]]></due_date__from>\r\n" );
									//Changed by sumit on 20/09/12 setting value of cust_code__from in case of no data.
									valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
									valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
									valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
									valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
									valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
									valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
								}
							}
							else
							{
								valueXmlString.append( "<due_date__from><![CDATA[" ).append("" ).append( "]]></due_date__from>\r\n" );
								//Changed by sumit on 20/09/12 setting value of cust_code__from in case of no data.
								valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );	
								valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
								valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
								valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
								valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
								valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
								//Changed by sumit on 20/09/12 setting value of cust_code__to in case of no data.
							}
							valueXmlString.append( "</Detail1>\r\n" );
						
					}
					else if ( currentColumn.trim().equalsIgnoreCase( "sale_order__to" ))
					{
							
							columnValue = genericUtility.getColumnValue("sale_order__to",currDom);
							saleOrderFrom = checkNull(genericUtility.getColumnValue("sale_order__from",currDom));
							//
							custCodeFrom = checkNull(genericUtility.getColumnValue("cust_code__from",currDom));
							//System.out.println("columnValue1="+columnValue);
							//System.out.println("Hello sale_order__from");
							valueXmlString.append( "<Detail1>\r\n" );
							
							if(columnValue != null && !columnValue.equalsIgnoreCase("ZZ"))
							{
								
								System.out.println("Hello sale_order__from2");
								//Changed by sumit 20/09/12 getting cust code start.								
								//sSQL = "SELECT DUE_DATE FROM SORDER WHERE SALE_ORDER = ?";
								sSQL = " SELECT S.DUE_DATE,C.CUST_CODE, C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
										" FROM SORDER S, CUSTOMER C, WAVE_TYPE W  WHERE SALE_ORDER = ? " +
										" AND C.CUST_CODE = S.CUST_CODE " +
										" AND C.WAVE_TYPE = W.WAVE_TYPE ";
								System.out.println("queryString="+sSQL);
								pstmt = conn.prepareStatement(sSQL);
								pstmt.setString(1,columnValue);
								rs=pstmt.executeQuery();
								
								if(rs.next())
								{
									dateFrom = rs.getDate(1);
									custCodeTo = rs.getString("CUST_CODE").trim();
									singleLotSl = rs.getString("SINGLE_LOT");
									masterPackAllow = rs.getString("MASTER_PACK_ALLOW");
									activePickAllow = rs.getString("ACTIVE_PICK_ALLOW");
									stockToDockAllow = rs.getString("STOCK_TO_DOCK_ALLOW");
								}
								if(dateFrom != null)
								{						
									String tranDate = genericUtility.getValidDateString( dateFrom.toString() , dbDateFmt, applDateFmt );
									//System.out.println("currDateStr=+++++++++++++"+tranDate);
									//System.out.println("Hello sale_order__from3");
									valueXmlString.append( "<due_date__to><![CDATA[" ).append( tranDate ).append( "]]></due_date__to>\r\n" );
									//Changed by sumit on 20/09/12 setting value of cust_code__to.
									valueXmlString.append( "<cust_code__to><![CDATA[" ).append( custCodeTo ).append( "]]></cust_code__to>\r\n" );
									if( columnValue.trim().equalsIgnoreCase(saleOrderFrom.trim()))
									{
										valueXmlString.append( "<cust_code__from><![CDATA[" ).append( custCodeTo ).append( "]]></cust_code__from>\r\n" );
										valueXmlString.append( "<cust_code__to><![CDATA[" ).append( custCodeTo ).append( "]]></cust_code__to>\r\n" );
										valueXmlString.append( "<single_lot protect ='0' ><![CDATA[" ).append( checkNull(singleLotSl) ).append( "]]></single_lot>\r\n" );
										valueXmlString.append( "<master_pack_allow protect ='0' ><![CDATA[" ).append( checkNull(masterPackAllow) ).append( "]]></master_pack_allow>\r\n" );
										valueXmlString.append( "<active_pick_allow protect ='0' ><![CDATA[" ).append( checkNull(activePickAllow) ).append( "]]></active_pick_allow>\r\n" );
										valueXmlString.append( "<stock_to_dock_allow protect ='0' ><![CDATA[" ).append( checkNull(stockToDockAllow) ).append( "]]></stock_to_dock_allow>\r\n" );
									}
									else
									{	
										valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
										valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
										valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
										valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
										valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
										valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );										
									}
									//System.out.println("Hello sale_order__from4");
								}
								else
								{
									valueXmlString.append( "<due_date__to><![CDATA[" ).append("").append( "]]></due_date__to>\r\n" );
									//Changed by sumit on 20/09/12 setting value of cust_code__to in case of no data.
									valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
									valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
									valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
									valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
									valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
									valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
									
								}
								
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
								if(rs!=null)
								{
									rs.close();
									rs=null;
								}
								
								
							}
							else
							{
								valueXmlString.append( "<due_date__to><![CDATA[" ).append("").append( "]]></due_date__to>\r\n" );
								//Changed by sumit on 20/09/12 setting value of cust_code__to in case of no data.
								valueXmlString.append( "<cust_code__from><![CDATA[" ).append( "00" ).append( "]]></cust_code__from>\r\n" );
								valueXmlString.append( "<cust_code__to><![CDATA[" ).append( "ZZ" ).append( "]]></cust_code__to>\r\n" );
								valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
								valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
								valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
								valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
							}
							valueXmlString.append( "</Detail1>\r\n" );
						
					}
					//Changed By Pragyan 21/06/12 end
					//Changed sumit on 18/09/12 item_changed for cust_code__from start.
					//else if ( currentColumn.trim().equalsIgnoreCase( "cust_code__from" ))
					/*else if ( "cust_code__from".equalsIgnoreCase( currentColumn ))
					{
						
						System.out.println(" from cust_code__from ");
						valueXmlString.append( "<Detail1>\r\n" );						
						custCodeFrom = checkNull(genericUtility.getColumnValue("cust_code__from",currDom));
						custCodeTo = checkNull(genericUtility.getColumnValue("cust_code__to",currDom));
						System.out.println(" custCodeFrom ["+custCodeFrom+"] custCodeTo ["+custCodeTo+"]");
						sSQL = 	" SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
								" FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
						pstmt = conn.prepareStatement(sSQL);
						if( custCodeFrom.trim().equalsIgnoreCase(custCodeTo.trim()))
						{
							pstmt.setString(1, custCodeFrom);
							rs = pstmt.executeQuery();
							if( rs.next())
							{							
								valueXmlString.append( "<single_lot protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("SINGLE_LOT")) ).append( "]]></single_lot>\r\n" );
								valueXmlString.append( "<master_pack_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("MASTER_PACK_ALLOW")) ).append( "]]></master_pack_allow>\r\n" );
								valueXmlString.append( "<active_pick_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("ACTIVE_PICK_ALLOW")) ).append( "]]></active_pick_allow>\r\n" );
								valueXmlString.append( "<stock_to_dock_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("STOCK_TO_DOCK_ALLOW")) ).append( "]]></stock_to_dock_allow>\r\n" );
							}
							if( pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs != null)
							{
								rs.close();
								rs = null;
							}
						}
						else
						{
							valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
							valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
							valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
							valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
						}
						valueXmlString.append( "</Detail1>\r\n" );
						
					}
					else if ( currentColumn.trim().equalsIgnoreCase( "cust_code__to" ))
					{
						valueXmlString.append( "<Detail1>\r\n" );
																				
						custCodeFrom = checkNull(genericUtility.getColumnValue("cust_code__from",currDom));
						custCodeTo = checkNull(genericUtility.getColumnValue("cust_code__to",currDom));
						System.out.println(" custCodeFrom ["+custCodeFrom+"] custCodeTo ["+custCodeTo+"]");
						sSQL = 	" SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
								" FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
						pstmt = conn.prepareStatement(sSQL);
						if( custCodeFrom.trim().equalsIgnoreCase(custCodeTo.trim()))
						{
							pstmt.setString(1, custCodeFrom);
							rs = pstmt.executeQuery();
							if( rs.next())
							{							
								valueXmlString.append( "<single_lot protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("SINGLE_LOT")) ).append( "]]></single_lot>\r\n" );
								valueXmlString.append( "<master_pack_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("MASTER_PACK_ALLOW")) ).append( "]]></master_pack_allow>\r\n" );
								valueXmlString.append( "<active_pick_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("ACTIVE_PICK_ALLOW")) ).append( "]]></active_pick_allow>\r\n" );
								valueXmlString.append( "<stock_to_dock_allow protect ='0' ><![CDATA[" ).append( checkNull(rs.getString("STOCK_TO_DOCK_ALLOW")) ).append( "]]></stock_to_dock_allow>\r\n" );
							}
							if( pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs != null)
							{
								rs.close();
								rs = null;
							}
						}
						else
						{
							valueXmlString.append( "<single_lot protect ='1' ><![CDATA[" ).append( "" ).append( "]]></single_lot>\r\n" );
							valueXmlString.append( "<master_pack_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></master_pack_allow>\r\n" );
							valueXmlString.append( "<active_pick_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></active_pick_allow>\r\n" );
							valueXmlString.append( "<stock_to_dock_allow protect ='1' ><![CDATA[" ).append( "" ).append( "]]></stock_to_dock_allow>\r\n" );
						}
						valueXmlString.append( "</Detail1>\r\n" );
					}
					*///Changed sumit on 18/09/12 item_changed for cust_code__from end.
				}
				break;
			}
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println("Exception: WaveGenerationIC: defaultItemChanged(Document dom): " + e.getMessage() + ":");
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		
		return valueXmlString.toString();		
	}
	
	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	
	/**
	 * The method is defined without any parameter and returns blank string
	 */
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		String columnValue ="";
		String errString = "";
		String sql ="";
		String singleLot ="";
		String masterPackAllow = "";
		String activePickAllow = "";
		String stockToDockAllow = "";
		String custCode = "";
		//Changed by sumit on 03/10/12 
		String printer = "";
		
		int count = 0, cnt = 0;
		int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;	

		GenericUtility genericUtility = GenericUtility.getInstance();		

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		Set errSet = null;
		try
		{	
			int currentFormNo = 0;				
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );
			connDriver = null;

			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();		

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "single_lot".equalsIgnoreCase( childNodeName ) )
					{
						singleLot = checkNull(genericUtility.getColumnValue( "single_lot", currFormDataDom ));
						custCode = genericUtility.getColumnValue( "cust_code__from", currFormDataDom );
						if(singleLot.trim().length() > 0 )
						{
							sql = 	"SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
									"FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{								
								if( !singleLot.equalsIgnoreCase(rs.getString("SINGLE_LOT")))
								{
									//errList.add( "CHMSTPKALL" );
									errFields.add( childNodeName.toLowerCase() );
									errList.add( "CHSINGLELT" );
									//errFields.add( "" );
								}
							}
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;								
							}
						}
					}
					else if ( "master_pack_allow".equalsIgnoreCase( childNodeName ) )
					{
						masterPackAllow = checkNull(genericUtility.getColumnValue( "master_pack_allow", currFormDataDom ));
						custCode = genericUtility.getColumnValue( "cust_code__from", currFormDataDom );
						if(masterPackAllow.trim().length() > 0 )
						{
							sql = 	"SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
									"FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{								
								if( !masterPackAllow.equalsIgnoreCase(rs.getString("MASTER_PACK_ALLOW")))
								{
									//errList.add( "CHMSTPKALL" );
									errFields.add( childNodeName.toLowerCase() );
									errList.add( "CHSINGLELT" );
									//errFields.add( "" );
								}
							}
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;								
							}
						}
					}
					else if ( "active_pick_allow".equalsIgnoreCase( childNodeName ) )
					{
						activePickAllow = checkNull(genericUtility.getColumnValue( "active_pick_allow", currFormDataDom ));
						custCode = genericUtility.getColumnValue( "cust_code__from", currFormDataDom );
						if(activePickAllow.trim().length() > 0 )
						{
							sql = 	"SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
									"FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{								
								if( !activePickAllow.equalsIgnoreCase(rs.getString("ACTIVE_PICK_ALLOW")))
								{
									//errList.add( "CHACTPKALL" );
									errFields.add( childNodeName.toLowerCase() );
									errList.add( "CHSINGLELT" );
									//errFields.add( "" );
								}
							}
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;								
							}
						}
					}
					else if ( "stock_to_dock_allow".equalsIgnoreCase( childNodeName ) )
					{
						stockToDockAllow = checkNull(genericUtility.getColumnValue( "stock_to_dock_allow", currFormDataDom ));
						custCode = genericUtility.getColumnValue( "cust_code__from", currFormDataDom );
						if(stockToDockAllow.trim().length() > 0 )
						{
							sql = 	"SELECT C.SINGLE_LOT, W.MASTER_PACK_ALLOW, W.ACTIVE_PICK_ALLOW, W.STOCK_TO_DOCK_ALLOW " +
									"FROM CUSTOMER C, WAVE_TYPE W WHERE C.WAVE_TYPE = W.WAVE_TYPE AND C.CUST_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{								
								if( !stockToDockAllow.equalsIgnoreCase(rs.getString("STOCK_TO_DOCK_ALLOW")))
								{
									//errList.add( "STOCK2DOC" );
									errFields.add( childNodeName.toLowerCase() );
									errList.add( "CHSINGLELT" );
									//errFields.add( "" );
								}
							}
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;								
							}
						}
					}
					//Changed by sumit on 03/10/12 validating printer service name with existing printer in system start.
					else if ( "printer".equalsIgnoreCase( childNodeName ) )
					{
						printer = checkNull(genericUtility.getColumnValue( "printer", currFormDataDom ));
						System.out.println(" printer from input parameter ["+printer+"]");
						PrintService[] printServices = PrinterJob.lookupPrintServices();
						ArrayList<String> arry = new ArrayList<String>();
						if(printer.trim().length() == 0)
						{
							errFields.add( childNodeName.toLowerCase() );
							errList.add( "NLLPRINTER" );
						}
						else
						{
							for (PrintService printService : printServices) 
							{
					            String name = printService.getName();
					            System.out.println("printer service name --> "+name);
					            arry.add(name);					            
					        }
							if( !arry.contains(printer.trim()))
				            {
				            	errFields.add( childNodeName.toLowerCase() );
								errList.add( "INVPRINTER" );
				            }							
							arry.clear();				           
						}
					}
					//Changed by sumit on 03/10/12 validating printer service name with existing printer in system end.
						
							
				}
			} //End of case 1 Validation
			break;				
					
			}//End of switch statement
			errSet = new HashSet(errList);
			errList = new ArrayList(errSet);
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: WaveGenerationIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			//throw new ITMException(e);
			e.printStackTrace();			
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				
				
				if( conn != null  )
				{
					conn.close(); conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : WaveGenerationIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
}
