/**
* PURPOSE : To cancle wave task.
* AUTHOR : Changed by Rohan
*/ 

package ibase.webitm.ejb.wms;

import ibase.utility.EMail;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.DistStkUpdLocal;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import java.text.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.ejb.Stateless; 
import org.w3c.dom.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.StreamSource;
import javax.xml.parsers.*;

@Stateless 
public class WaveCancelEJB extends ActionHandlerEJB implements WaveCancelEJBLocal, WaveCancelEJBRemote 
{
    /**
	 * The public method is used for confirming the service complaint transaction
	 * Returns confirmation message on successfull confirm otherwise returns error message
	 * @param tranID is the transaction id to be confirmed
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 * @param forcedFlag (true or false)
	 */
	public String confirm( String waveID, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		String retString = "";
		Connection conn = null;	
		boolean isConn= false;
		
		try
		{
			retString = this.confirm( waveID,xtraParams, forcedFlag ,conn ,isConn);
			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for wave  Id:["+waveID+"]");
			}
		}
		catch( Exception exception )
		{
			System.out.println("Exception in [WaveHoldEJB] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}
	public String confirm(String waveID, String xtraParams, String forcedFlag, Connection conn, boolean connStatus) throws RemoteException, ITMException
	{
		
		String sql = "";		
		String retString = "";
		
		//Changed by Rohan on 21-09-12 for wave generation reversal.start
		String refId = "";
		String pickDet = "";
		String itemCode = "";
		String lineNo = "";
		String locCode= "";
		String lotNo = "";
		String lotSl = "";
		double quantity = 0.0;
		String expLev = "";
		String saleOrder = "";
		String lineNoSord = "";
		//double qtyStduom = 0.0;
		//double qtyAlloc = 0.0;
		PreparedStatement pstmt = null;
		Statement stmt = null,stmt1 = null;
		
		String updateStatus = "";
		String sqlRepl = "";
		String replOrd = "";
		String lineNorepl = "";
		String sqlPick = "";
		String sqlItem = "";
		String sqlPickUpt = "";
		String invStat = "";
		String casePickLoc = "";
		String resrvLoc = "";
		String sqlReplOrd1 = "";
		String sqlSordAlloc = "", sqlSord = "", sqlSordItem = "", line = "";
		DistCommon discommon = new DistCommon();
		double qtyAlloc = 0d, qtyStduom = 0d;
		int updateCnt = 0, retVal = 0, count =0;
		HashMap strAllocate = new HashMap();
		DistStkUpdLocal distStkUpd = null;
		String sqlReplCase = "";
		String itemCodeOrd = "";
		String siteCode = "";
		java.sql.Date tranDate = null;
		double caseSize = 0d;
		String sqlReplUpt = "";
		double domQty = 0.0;
		ResultSet  rs1 = null;
		PreparedStatement pstmtWave = null;
		ResultSet rsWave = null;
		String status = "";

		PreparedStatement pstmtRepl = null;
		ResultSet rsRepl = null;
		String sqlReplOrd = "";
		String replOrder = "";
		String replLineNo = "";
		String waveCancel = "";
		String sqlUpdate = "";
		String pickOrder = "";
		String pickLineNo = "";
		String sqlpickDet = "";
		String locCodeTo = "";
		String locCode1 = "";
		String dockLoc = "";
		String sqlreplDet = "";
		//Changed by Rohan on 21-09-12 for wave generation reversal.end
		//Changed by Rohan 10-04-12 to define variables.start
		String invState = "";
		String pickOrd = "";
		String lineNoPick = "";
		//Changed by Rohan on 10-04-12 to define variables.end
		
		boolean isError = false;
		boolean scanStart = false;
		int updCnt = 0;
		PreparedStatement pstmtUpd = null;
		PreparedStatement pstmtSql = null;
		ResultSet rs = null;
		ResultSet rsPick = null;
		
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		
		try
		{
			
			if ( conn == null )
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
				conn.setAutoCommit(false);
				connStatus = true;
			}
			
			dockLoc = discommon.getDisparams("999999","DOCKLOC_INVSTAT",conn);
			
			System.out.println("dockLoc----->"+dockLoc);
			
			GenericUtility genericUtility = GenericUtility.getInstance();
			java.sql.Timestamp currDate = new java.sql.Timestamp( System.currentTimeMillis() );
			distStkUpd = getComponent("DistStkUpd");
			
			//Changed by Rohan on 21-09-12 for wave generation reversal.start
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			tranDate = new java.sql.Date(System.currentTimeMillis());
			System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
			//sql = "SELECT H.CANCEL,D.STATUS FROM WAVE_TASK H,WAVE_TASK_DET D"
			//	 + " WHERE D.WAVE_ID = ? AND H.WAVE_ID = D.WAVE_ID ";	
			
			sql = "SELECT CANCEL FROM WAVE_TASK "
				+ " WHERE WAVE_ID = ? ";
			pstmtSql = conn.prepareStatement(sql);
			pstmtSql.setString(1, waveID);
			rs = pstmtSql.executeQuery();
			/*
			while( rs.next() )
			{
				status = checkNull( rs.getString("STATUS") );
				waveCancel = checkNull( rs.getString("CANCEL") );
				if(waveCancel.equalsIgnoreCase("Y"))
				{
					retString = itmDBAccess.getErrorString("","WAVECANCEL","");
					break;
				}
				if(status.equalsIgnoreCase("Y"))
				{
					scanStart = true;
					break;
				}
			}
			*/
			if( rs.next() )
			{
				
				waveCancel = checkNull( rs.getString("CANCEL") );
				if(waveCancel.equalsIgnoreCase("Y"))
				{
					retString = itmDBAccess.getErrorString("","WAVECANCEL","");
					return retString;
					
				}
			}
			
			rs.close();
			rs = null;
			pstmtSql.close();
			pstmtSql = null;
			
			System.out.println("Stattuuuu"+status);
			if(!scanStart)
			{	
				sql = "SELECT REF_ID FROM WAVE_TASK_DET WHERE WAVE_ID = ?";
				pstmtWave = conn.prepareStatement(sql);
				pstmtWave.setString(1, waveID);
				rsWave = pstmtWave.executeQuery();
				while( rsWave.next() )
				{
					refId = checkNull( rsWave.getString("REF_ID") );
					System.out.println("REFID===&&&&&&&&&&&&==>"+refId);
					if(refId.startsWith("PT"))
					{
						
						//if(locCode.equalsIgnoreCase(""))
						//{	
						
						pickDet ="SELECT ITEM_CODE,LINE_NO,LOC_CODE,LOT_NO,LOT_SL,QUANTITY," +
								 "EXP_LEV,SALE_ORDER,LINE_NO__SORD,REPL_ORDER,LINE_NO__REPL,PICK_ORDER,LINE_NO FROM PICK_ORD_DET WHERE PICK_ORDER = ? ";
						
						pstmtSql = conn.prepareStatement(pickDet);
						pstmtSql.setString(1, refId);
						rsPick = pstmtSql.executeQuery();
						while( rsPick.next() )
						{
							
							itemCode = checkNull( rsPick.getString("ITEM_CODE") );
							lineNo = checkNull( rsPick.getString("LINE_NO") );
							locCode = checkNull( rsPick.getString("LOC_CODE") );
							
							replOrder = checkNull( rsPick.getString("REPL_ORDER") );
							replLineNo = checkNull( rsPick.getString("LINE_NO__REPL") );
							
							pickOrder = checkNull( rsPick.getString("PICK_ORDER") );
							pickLineNo = checkNull( rsPick.getString("LINE_NO") );
							
							lotNo = checkNull( rsPick.getString("LOT_NO") );
							lotSl = checkNull( rsPick.getString("LOT_SL") );
							quantity = rsPick.getDouble("QUANTITY");
							expLev = checkNull( rsPick.getString("EXP_LEV") );
							saleOrder = checkNull( rsPick.getString("SALE_ORDER") );
							lineNoSord = checkNull( rsPick.getString("LINE_NO__SORD") );
							System.out.println("LOCCode***"+locCode);
							qtyStduom = quantity;
							
							
							//pick sacn complete.start
							sqlpickDet = "SELECT LOC_CODE,LOC_CODE__TO FROM PICK_ISS_DET WHERE PICK_ORDER = ? AND LINE_NO__ORD = ?";
							
							pstmtRepl = conn.prepareStatement(sqlpickDet);
							pstmtRepl.setString(1,pickOrder);
							pstmtRepl.setString(2,pickLineNo);
							rsRepl = pstmtRepl.executeQuery();
							if(rsRepl.next())
							{
								
								locCodeTo = checkNull( rsRepl.getString("LOC_CODE__TO") );
								//locCode1 = checkNull( rsRepl.getString("LOC_CODE") );
								//System.out.println("LOCCode***####*****"+locCode);
								//replOrder = checkNull( rsRepl.getString("REPL_ORDER") );
								//replLineNo = checkNull( rsRepl.getString("LINE_NO") );
								System.out.println("LOCCode***####*****"+locCode+"replOrder"+replOrder+"replLineNo"+replLineNo);
							}
							//if(!locCodeTo.equalsIgnoreCase(dockLoc.trim()) && locCode.equalsIgnoreCase(""))
							if(!locCodeTo.equalsIgnoreCase(""))
							{
								locCode = locCodeTo;
								System.out.println("Pick perfom loc code---->"+locCode);
							}
							/*
							else if(locCodeTo.equalsIgnoreCase(dockLoc.trim()))
							{
								retString = itmDBAccess.getErrorString("","WAVEDOCK","");
							}
							*/
							if(rsRepl != null)
							{
								rsRepl.close();
								rsRepl = null;
							}
							
							if(pstmtRepl != null)
							{
								pstmtRepl.close();
								pstmtRepl = null;
							}
					
							//pick scan complete.end
					
							if(!replOrder.equalsIgnoreCase("") && !locCode.equalsIgnoreCase(locCodeTo))
							{
								//locCode = "";
								//repl sacn complete.start
								String locCodeRepl = "";
								
								sqlreplDet = "SELECT LOC_CODE__TO FROM REPL_ISS_DET WHERE REPL_ORDER = ? AND LINE_NO__ORD = ?";
								pstmtRepl = conn.prepareStatement(sqlreplDet);
								pstmtRepl.setString(1,replOrder);
								pstmtRepl.setString(2,replLineNo);
								rsRepl = pstmtRepl.executeQuery();
								if(rsRepl.next())
								{
									
									//locCodeTo = checkNull( rsRepl.getString("LOC_CODE__TO") );
									locCodeRepl = checkNull( rsRepl.getString("LOC_CODE__TO") );
									//System.out.println("LOCCode***####*****"+locCode);
									//replOrder = checkNull( rsRepl.getString("REPL_ORDER") );
									//replLineNo = checkNull( rsRepl.getString("LINE_NO") );
									System.out.println("locCodeRepl***####*****"+locCodeRepl);
								}
								if(rsRepl != null)
								{
									rsRepl.close();
									rsRepl = null;
								}
								
								if(pstmtRepl != null)
								{
									pstmtRepl.close();
									pstmtRepl = null;
								}
								
								if(!locCodeRepl.equalsIgnoreCase(""))
								{
									locCode = locCodeRepl;
								}
								//repl scan complete.end
								else
								{	
									//sqlReplOrd= "SELECT REPL_ORDER,LINE_NO,LOC_CODE FROM REPL_ORD_DET WHERE REPL_ORDER = ? AND LINE_NO = ?";
									sqlReplOrd= "SELECT PICK_ORDER,LINE_NO__PICK,LOC_CODE FROM REPL_ORD_DET WHERE REPL_ORDER = ? AND LINE_NO = ?";
									pstmtRepl = conn.prepareStatement(sqlReplOrd);
									pstmtRepl.setString(1, replOrder);
									pstmtRepl.setString(2, replLineNo);
									rsRepl = pstmtRepl.executeQuery();
									if(rsRepl.next())
									{
										locCode = checkNull( rsRepl.getString("LOC_CODE") );
										
										replOrder = checkNull( rsRepl.getString("PICK_ORDER") );
										replLineNo = checkNull( rsRepl.getString("LINE_NO__PICK") );
										System.out.println("LOCCode***####**old11"+locCode+"replOrderPick"+replOrder+"replLineNoPickLine"+replLineNo);
									}
									if(rsRepl != null)
									{
										rsRepl.close();
										rsRepl = null;
									}
									
									if(pstmtRepl != null)
									{
										pstmtRepl.close();
										pstmtRepl = null;
									}
									
									//pstmtRepl.clearParameters();
									//sqlReplOrd1= "SELECT LOC_CODE FROM REPL_ORD_DET WHERE PICK_ORDER = ? AND LINE_NO__PICK = ?";
									//checking second task.start
									locCodeRepl = "";
									sqlreplDet = "SELECT LOC_CODE__TO FROM REPL_ISS_DET WHERE REPL_ORDER = ? AND LINE_NO__ORD = ?";
									pstmtRepl = conn.prepareStatement(sqlreplDet);
									pstmtRepl.setString(1,replOrder);
									pstmtRepl.setString(2,replLineNo);
									rsRepl = pstmtRepl.executeQuery();
									if(rsRepl.next())
									{
										
										//locCodeTo = checkNull( rsRepl.getString("LOC_CODE__TO") );
										locCodeRepl = checkNull( rsRepl.getString("LOC_CODE__TO") );
										//System.out.println("LOCCode***####*****"+locCode);
										//replOrder = checkNull( rsRepl.getString("REPL_ORDER") );
										//replLineNo = checkNull( rsRepl.getString("LINE_NO") );
										System.out.println("LOCCode***####****$$$$$$$$$$*"+locCode);
									}
									if(rsRepl != null)
									{
										rsRepl.close();
										rsRepl = null;
									}
									
									if(pstmtRepl != null)
									{
										pstmtRepl.close();
										pstmtRepl = null;
									}
									if(!locCodeRepl.equalsIgnoreCase(""))
									{
										locCode = locCodeRepl;
									}
									else
									{	
									
										//Changed by rohan on 10-04-12 to getstock location
										//sqlReplOrd1= "SELECT LOC_CODE FROM REPL_ORD_DET WHERE REPL_ORDER = ? AND LINE_NO = ?";
										sqlReplOrd1= "SELECT R.LOC_CODE AS LOC_CODE ,I.INV_STAT AS INV_STAT,R.PICK_ORDER AS PICK_ORDER,R.LINE_NO__PICK AS LINE_NO" +
													" FROM REPL_ORD_DET R,LOCATION I"+
													 " WHERE R.REPL_ORDER = ? AND R.LINE_NO = ? AND R.LOC_CODE = I.LOC_CODE";
										
										pstmtRepl = conn.prepareStatement(sqlReplOrd1);
										pstmtRepl.setString(1, replOrder);
										pstmtRepl.setString(2, replLineNo);
										rsRepl = pstmtRepl.executeQuery();
										if(rsRepl.next())
										{
											locCode = checkNull( rsRepl.getString("LOC_CODE") );
											//Changed by Rohan on 13-10-12 to get stock location.start
											invState = checkNull( rsRepl.getString("INV_STAT") );
											pickOrd = checkNull( rsRepl.getString("PICK_ORDER") );
											lineNoPick = checkNull( rsRepl.getString("LINE_NO") );
											//Changed by Rohan on 13-10-12 to get stock location.end
											
											//System.out.println("LOCCode***####*****"+locCode);
											//replOrder = checkNull( rsRepl.getString("REPL_ORDER") );
											//replLineNo = checkNull( rsRepl.getString("LINE_NO") );
											
										}
										if(rsRepl != null)
										{
											rsRepl.close();
											rsRepl = null;
										}
										//Changed by Rohan on 10-04-12 to get loc code.start
										if(invState.startsWith("PND"))
										{
											pstmtRepl.clearParameters();
											pstmtRepl.setString(1, pickOrd);
											pstmtRepl.setString(2, lineNoPick);
											rsRepl = pstmtRepl.executeQuery();
											if(rsRepl.next())
											{
												locCode = checkNull( rsRepl.getString("LOC_CODE") );
											}
										}
										if(rsRepl != null)
										{
											rsRepl.close();
											rsRepl = null;
										}
										
										//Changed by Rohan on 10-04-12 to get loc code.end
										if(pstmtRepl != null)
										{
											pstmtRepl.close();
											pstmtRepl = null;
										}
									}	
								}//repl Scan else
									
										
							}
						
							lineNoSord = "  " + lineNoSord; 
							
							sql = "SELECT QTY_ALLOC AS COUNT FROM SORDALLOC "
								  +"WHERE SALE_ORDER = ? "
								  +"AND LINE_NO = ? "
								  +"AND EXP_LEV = ? "
								  +"AND ITEM_CODE__ORD = ? "
								  +"AND ITEM_CODE = ? "
								  +"AND LOT_NO = ? "
								  +"AND LOT_SL = ? "
								  +"AND LOC_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,saleOrder);
							pstmt.setString(2,  lineNoSord);
							pstmt.setString(3,expLev);
							pstmt.setString(4,itemCode);
							pstmt.setString(5,itemCode);
							pstmt.setString(6,lotNo);
							pstmt.setString(7,lotSl);
							pstmt.setString(8,locCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								
								qtyAlloc = rs.getDouble(1);
								System.out.println("Quantity Alloactes"+qtyAlloc);
							}
							else
							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
		
							// 22/02/10 manoharan if allocation found in sordalloc then deallocate
							//if (count > 0 ) // 04/04/12 manoharan
							if (qtyAlloc > 0) // 04/04/12 manoharan
							{
								if (qtyAlloc - qtyStduom <= 0)
								{
									sqlSord = "DELETE FROM SORDALLOC WHERE SALE_ORDER = ? "
										 +"AND LINE_NO = ? "
										 +"AND EXP_LEV = ? " 
										 +"AND ITEM_CODE__ORD = ? " 
										 +"AND ITEM_CODE = ? " 
										 +"AND LOT_NO = ? " 
										 +"AND LOT_SL = ? "
										 +"AND LOC_CODE = ? ";
									System.out.println("Delete sql sqlSord :"+sqlSord);
									pstmt = conn.prepareStatement(sqlSord);
									pstmt.setString(1,saleOrder);
									pstmt.setString(2,lineNoSord);
									pstmt.setString(3,expLev);
									pstmt.setString(4,itemCode);
									pstmt.setString(5,itemCode);
									pstmt.setString(6,lotNo);
									pstmt.setString(7,lotSl);
									pstmt.setString(8,locCode);
									updateCnt = pstmt.executeUpdate();
									pstmt.close();
									pstmt = null;
									System.out.println("Deleted the no of records are : updateCnt :"+updateCnt);
								}
								else
								{
									sqlSord = "UPDATE SORDALLOC SET QTY_ALLOC = QTY_ALLOC - ? "
										  +"WHERE SALE_ORDER = ? "
										  +"AND LINE_NO = ? "
										  +"AND EXP_LEV = ? "
										  +"AND ITEM_CODE__ORD = ? "
										  +"AND ITEM_CODE = ? "
										  +"AND LOT_NO = ? "
										  +"AND LOT_SL = ? "
										  +"AND LOC_CODE = ? ";
									System.out.println("Update sql sqlSord :"+sqlSord);
									pstmt = conn.prepareStatement(sqlSord);
									pstmt.setDouble(1,qtyStduom);
									pstmt.setString(2,saleOrder);
									pstmt.setString(3,lineNoSord);
									pstmt.setString(4,expLev);
									pstmt.setString(5,itemCode);
									pstmt.setString(6,itemCode);
									pstmt.setString(7,lotNo);
									pstmt.setString(8,lotSl);
									pstmt.setString(9,locCode);
									updateCnt = pstmt.executeUpdate();
									pstmt.close();
									pstmt = null;
									System.out.println("Updated the no of records are : updateCnt :"+updateCnt);
								}
								sqlSordItem = "UPDATE SORDITEM SET QTY_ALLOC = QTY_ALLOC - ? "
											 +"WHERE SALE_ORDER = ? "
											 +"AND LINE_NO = ? "
											 +"AND EXP_LEV = ? ";
								System.out.println("Update sql sqlSordItem :"+sqlSordItem);
								pstmt = conn.prepareStatement(sqlSordItem);
								pstmt.setDouble(1,qtyStduom);
								pstmt.setString(2,saleOrder);
								pstmt.setString(3,lineNoSord);
								pstmt.setString(4,expLev);
								updateCnt = pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;
								System.out.println("Updated the no of records : updateCnt :"+updateCnt);
		
								line = "   " + lineNo;
								System.out.println("line :"+line);
								
								//Changed by Rohan on 10/8/12 to give proper loc code.start
		
								
								//Changed by Rohan on 10/8/12 to give proper loc code.end
								strAllocate.put("tran_date",tranDate);
								strAllocate.put("ref_ser","P-TASK");
								//strAllocate.put("ref_id",tranId);
								strAllocate.put("ref_id",refId);
								strAllocate.put("ref_line",line.substring(line.length()-3));
								strAllocate.put("site_code",siteCode);
								strAllocate.put("item_code",itemCode);
								System.out.println("Updated loc code*********************************************"+locCode);
								strAllocate.put("loc_code",locCode);
								strAllocate.put("lot_no",lotNo);
								strAllocate.put("lot_sl",lotSl);
								strAllocate.put("alloc_qty",new Double(-1*qtyStduom)); 
								strAllocate.put("chg_user",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
								strAllocate.put("chg_term",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
								strAllocate.put("chg_win","W_PICK_ORD");
								//Calling DistStkUpdEJB
								System.out.println("Calling DistStkUpdEJB.....");
								if (distStkUpd.updAllocTrace(strAllocate, conn) > 0)
								{
									System.out.println("distStkUpd.UpdAllocTrace(hashMap) : Sucessuful!");
								}
								
								sqlUpdate = "UPDATE WAVE_TASK SET CANCEL ='Y' WHERE WAVE_ID = ?" ;						
								pstmtUpd = conn.prepareStatement(sqlUpdate);
								pstmtUpd.setString(1, waveID);
								updCnt = pstmtUpd.executeUpdate();
								
								if( updCnt > 0 )
								{					
									retString = itmDBAccess.getErrorString("","WAVEREV","");
								}
								else
								{
									retString = itmDBAccess.getErrorString("","NTWAVEREV","");
								}
								
								if(pstmtUpd != null)
								{
									pstmtUpd.close();
									pstmtUpd = null;
								}
								
									
							}//qty allocate > 0
						
						}//while close
					
					}
				
				}
			}
		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( !isError && connStatus )
				{
					conn.commit(); 
					
					if("Y".equalsIgnoreCase(status))
					{
						retString = itmDBAccess.getErrorString("","WAVENTREV","");
					}
					
				}
				else if (isError && connStatus)
				{
					conn.rollback();
				}
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}
				if( conn != null && ! conn.isClosed() && connStatus)
				{
					conn.close();
					conn = null;
				}
				if(pstmtWave != null)
				{
					pstmtWave.close();
					pstmtWave = null;
				}
				if(rsWave != null)
				{
					rsWave.close();
					rsWave = null;
				}
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
	}
	private String checkNull( String input )
	{
		if( input == null )
		{
			input = "";
		}
		return input;
	}
	private DistStkUpdLocal getComponent(String componentName)throws Exception
    {
		DistStkUpdLocal comp = null;
        try
        {
			System.out.println("Looking For Component.... :: " + componentName);
			AppConnectParm appConnect = new AppConnectParm();
			java.util.Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			 comp = (DistStkUpdLocal)ctx.lookup("ibase/DistStkUpd/local"); // for ejb3
			//comp = distStkUpdHome.create();
			System.out.println(componentName+" Found.....");			
        }
        catch(Exception e)
        {
			throw e;
        }
		return comp;
	}
}
