/**
 * PURPOSE : Validation and Itemchange for Picking Issue
 * AUTHOR : Gulzar
 * DATE : 13/09/11
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PickIssIC extends ValidatorEJB implements PickIssICLocal, PickIssICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		String pickOrder = "";
		String columnValue = "";			
		String errString = "";
		String lpnNo = "";
		String itemCode = "";
		String siteCode = "";		
		String lotNo = "";
		String lotSl = "";
		String locCodeTo = "";
		String confirmed = "";
		String singleLotSl = "";
		String itemLotOpt = "";
		String rowCountStr = "";
		String pickType = "";
		String sql = "",sql1= "";
		String lineNoPick = "";
		String locCodeSys = "";
		String sugLocInvstat = "";
		String objName = "";
		String cartonNo = "";
		String caseLabel = "";
		String tranID =  "";//Gulzar - 12/13/2011
		String intrLocInvstat =  "";//Gulzar - 12/28/2011
		String replOrder =  "",ptcn = "";//Gulzar - 1/12/2012
		String palletStatus = "";
		//changed by sankara on 10-08-12[start]
		String waveId="";
		String holdStatus="";
		//changed by sankara on 10-08-12[end]
		int count = 0, cnt = 0;
		int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;
		int lineNoOrd = 0;

		double quantity = 0.0;

		GenericUtility genericUtility = GenericUtility.getInstance();
		DistCommon distCommon = new DistCommon();

		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		PreparedStatement pstmtPickLotNo = null;
		PreparedStatement pstmtPickLotSl = null;
		PreparedStatement pstmtLoc = null;
		PreparedStatement pstmtStock = null;
		PreparedStatement pstmtLoc1 = null;
		PreparedStatement pstmtStock1 = null;
		PreparedStatement pstmtStock2 = null;
		PreparedStatement pstmtStock3 = null;

		ResultSet rs = null, rs1 = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "", docLocCode = "" ,statusPkord= "", status = "O",locCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		try
		{	
			int currentFormNo = 0;				
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );
			connDriver = null;

			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();
			

			//changes added to get the obj_name and to distinguish betwwen active pick and case pick
			//Gulzar - 28/11/11
			objName = checkNullAndTrim(getObjNameFromDom( currFormDataDom, "objName", objContext ));
			System.out.println(" objName =[" + objName + "]");

			//Changes by gulzar on 12/28/2011
			intrLocInvstat = distCommon.getDisparams( "999999", "INTR_LOCATION", conn );
			//End changes by gulzar on 12/28/2011

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "pick_order".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "pick_order", "NULPICKORD", userId );
							//break;
							errList.add( "NULPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						pickOrder = genericUtility.getColumnValue( "pick_order", currFormDataDom );

						// added by cpatil on 11-sept-12 start for pick_id validate
						sql = "SELECT count(1) FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if( cnt == 0)
						{
							errList.add( "VMPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						//Changed by sumit on 28/09/12 validating in case of wave canceled start.
						else
						{
							sql = " SELECT WAVE_TASK.CANCEL FROM WAVE_TASK, PICK_ORD_HDR " +
									" WHERE PICK_ORD_HDR.WAVE_ID = WAVE_TASK.WAVE_ID " +
									" AND PICK_ORD_HDR.PICK_ORDER = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, pickOrder);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								if( "Y".equalsIgnoreCase(rs.getString("CANCEL")))
								{
									errList.add( "PICKCANCEL" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
						//Changed by sumit on 28/09/12 validating in case of wave canceled end.
						// cpatil end
						// 13/09/12 manoharan status checking added
						status = "O";
						sql = "SELECT PICK_TYPE, CASE WHEN STATUS IS NULL THEN 'O' ELSE STATUS END AS STATUS FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							pickType = checkNull(rs.getString("PICK_TYPE"));
							status  = checkNull(rs.getString("STATUS"));
						}
						else
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "repl_order", "INVPICKORD", userId );
							//break;
							errList.add( "INVPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if("C".equals(status))
						{
							errList.add( "VTPKORDC" );
							errFields.add( childNodeName.toLowerCase() );
							
						}

						//Changed by sankara on 10-08-2012 for proces hold[start]
						sql=" SELECT WAVE_ID FROM PICK_ORD_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							waveId = rs.getString("WAVE_ID");
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if(waveId != null && waveId.trim().length() > 0)
						{
							sql= "SELECT HOLD_STATUS FROM WAVE_TASK WHERE WAVE_ID = ? ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, waveId );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								holdStatus = rs.getString("HOLD_STATUS");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						
						if("Y".equalsIgnoreCase(holdStatus))
						{
							errList.add( "PRCESHLD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						
						//Changed by sankara on 10-08-2012 for proces hold[end]

						if ( pickType.trim().length() == 0  )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "pick_type", "NULPICKTYP", userId );
							//break;
							errList.add( "NULPICKTYP" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						/*--commented by chaitali on 30/11/11
							else if ( pickType.trim().equalsIgnoreCase("M") )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "pick_type", "INVPICKTYP", userId );
								//break;
								errList.add( "MASTERPICK" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						 */
						//changes added to get the obj_name and to distinguish betwwen active pick and case pick
						//Gulzar - 28/11/11
						if ( "active_pick".equalsIgnoreCase(objName) && ! pickType.trim().equalsIgnoreCase("A") )
						{
							errList.add( "ACTIVEPICK" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else if ( "case_pick".equalsIgnoreCase(objName) && (! pickType.trim().equalsIgnoreCase("C") &&  ! pickType.trim().equalsIgnoreCase("M")) )
						{
							errList.add( "CASEPICK" );
							errFields.add( childNodeName.toLowerCase() );
						}
						/*else if ( "master_pick".equalsIgnoreCase(objName) && ! pickType.trim().equalsIgnoreCase("M") )
							{
								errList.add( "MASTERPICK" );
								errFields.add( childNodeName.toLowerCase() );
							}*/
						//sql = "SELECT CONFIRMED FROM PICK_ISS_HDR WHERE PICK_ORDER = ? ";
						sql = "SELECT STATUS FROM PICK_ORD_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							statusPkord = checkNull(rs.getString("STATUS"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if ( "C".equalsIgnoreCase(statusPkord.trim()) )
						{
							errList.add( "CLSPCKORD" ); //commented by Ashish Sonawane on 11-sep-12 
							errFields.add( childNodeName.toLowerCase() ); //commented by Ashish Sonawane on 11-sep-12 
						}
						//End changes by gulzar - 28/11/11

						//Changes made by gulzar to check if any unconfirmed replenishment is present or not on 1/12/2012
						//							sql = "SELECT HDR.REPL_ORDER AS REPL_ORDER FROM REPL_ORD_HDR HDR, REPL_ORD_DET DET, PICK_ORD_DET DET1  "
						//								+ "WHERE HDR.REPL_ORDER = DET.REPL_ORDER AND DET.PICK_ORDER= ? ";
						//changes done by cpandey pick order from pick_iss_det repl_iss_det 
						sql = "SELECT HDR.REPL_ORDER AS REPL_ORDER FROM REPL_ORD_HDR HDR, REPL_ORD_DET DET, PICK_ORD_DET DET1 WHERE" +
								" HDR.REPL_ORDER = DET.REPL_ORDER AND DET1.REPL_ORDER = HDR.REPL_ORDER AND DET.PICK_ORDER= ? ";

						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1,pickOrder);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							replOrder = checkNull(rs.getString("REPL_ORDER"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if ( replOrder.trim().length() > 0 )
						{
							sql = "SELECT CONFIRMED FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";

							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								confirmed = checkNull(rs.getString("CONFIRMED"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							if ( confirmed.trim().length() == 0 || "N".equalsIgnoreCase(confirmed.trim()) )
							{
								//Replenishment task is not performed or un-confirmed task is present , please complete the replenishment task first
								errList.add( "VTREPLISS1" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}

						//End changes by gulzar on 1/12/2012
						sql = "SELECT DISTINCT REPL_ORDER FROM PICK_ORD_DET "
								+ "WHERE  PICK_ORDER= ? AND REPL_ORDER IS NOT NULL";

						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						while( rs.next() )
						{
							replOrder = checkNull(rs.getString(1));
							if ( replOrder.trim().length() > 0 )
							{
								sql1 = "SELECT CONFIRMED FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";
								confirmed = "N";
								pstmt1 = conn.prepareStatement( sql1 );
								pstmt1.setString( 1, replOrder );
								rs1 = pstmt1.executeQuery();

								if( rs1.next() )
								{
									confirmed = checkNull(rs1.getString("CONFIRMED"));
								}
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;

								if ( confirmed.trim().length() == 0 || "N".equalsIgnoreCase(confirmed.trim()) )
								{
									//Replenishment task is not performed or un-confirmed task is present , please complete the replenishment task first
									errList.add( "VTREPLISS1" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}


						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						
						// cpatil start on 23-AUG-12 [WM1FSUN002]
						
						System.out.println("@@@@@ item validation in pick_order executed.......");
						pickOrder = checkNull(genericUtility.getColumnValue( "pick_order", currFormDataDom  ));
						// 14/09/12 manoharan commented as not required in header
						/*
						sql = " select count (*) from stock where (item_code, site_code, loc_code, lot_no, lot_sl ) in  " +
							  " ( select item_code, site_code, loc_code, lot_no, lot_sl from pick_ord_det where pick_order = ? ) and ( hold_qty > 0 ) ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,pickOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if( cnt > 0 )
						{
							errList.add( "INVITMQTST" );
							errFields.add( childNodeName.toLowerCase() );
						}
						// cpatil end on 23-AUG-12
						*/
						
					}
					else if ( "pallet_no".equalsIgnoreCase( childNodeName ) )   // && ! "master_pick".equalsIgnoreCase(objName) )
					{
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "pick_order", "NULPICKORD", userId );
							//break;
							errList.add( "NULLPLTNO" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						else //Added by gulzar - 30/11/11
						{
							String palletNoDom = "";
							String palletNoDb = "";
							palletNoDom = checkNull(genericUtility.getColumnValue( "pallet_no", currFormDataDom ));
							pickOrder = checkNull(genericUtility.getColumnValue( "pick_order", currFormDataDom ));

							sql = "SELECT PICK_TYPE FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								pickType = checkNull(rs.getString("PICK_TYPE"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							sql = "SELECT PTCN FROM WAVE_TASK_DET WHERE REF_ID = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								ptcn = checkNull(rs.getString("PTCN"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;



							// added by cpatil for validate pallet_no from pallet_no on 10-Jun-12  start
							//if (!"M".equals(pickType))
							//{
							sql="select count(1) from pallet_no where pallet_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, palletNoDom.trim());
							//}
							//else
							//{
							//	sql="select count(1) from carton_master where carton_no = ? and ptcn = ? ";
							//	pstmt = conn.prepareStatement(sql);
							//	pstmt.setString(1, palletNoDom.trim());
							//	pstmt.setString(2, ptcn.trim());
							//}								
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt=rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errList.add( "INVPLTNOM" );
								errFields.add( childNodeName.toLowerCase() );
							}
							//added by cpatil for validate pallet_no from pallet_no on 10-Jun-12  end

							//if ( pickOrder.trim().length() > 0 )
							//{
								//sql = "SELECT PALLET_NO FROM PICK_ISS_HDR WHERE PICK_ORDER = ?";       // commented by cpatil on 11-sept-12
								//pstmt = conn.prepareStatement( sql );
								//pstmt.setString( 1, pickOrder );
								//rs = pstmt.executeQuery();

								//if( rs.next() )
								//{
									//palletNoDb = checkNull(rs.getString("PALLET_NO"));
									//System.out.println("pallet no db ="+palletNoDb);
									//if(palletNoDb.trim().length() > 0)
									if( palletNoDom != null )
									{
										sql1="select status from pallet_no where pallet_no =  ? ";//change by Kunal M on 30/07/12 as per S Manoharan Sir intruction
										pstmt1 = conn.prepareStatement(sql1);
										pstmt1.setString(1, palletNoDom.trim());
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											palletStatus = checkNull(rs1.getString(1));
										}
										rs1.close();
										rs1 = null;
										pstmt1.close();
										pstmt1 = null;
									}
									//System.out.println("pallet no db status = "+palletStatus);
									if ( palletNoDom.trim().length() > 0 &&  !"A".equalsIgnoreCase(palletStatus.trim()))
									//( (palletNoDom.trim().length() > 0 && !palletNoDom.trim().equalsIgnoreCase(palletNoDb) && !"A".equalsIgnoreCase(palletStatus.trim())))
									{
										System.out.println("USED PALLET NO ");
										errList.add( "INVPLTNOU" );
										errFields.add( childNodeName.toLowerCase() );
									}
									/*else if ( (palletNoDom.trim().length() > 0 &&  ! palletNoDom.trim().equalsIgnoreCase(palletNoDb))  )
									{
										System.out.println("Unmatch PALLET NO ");
										errList.add( "INVPLTNO" );
										errFields.add( childNodeName.toLowerCase() );
									}*/
								//}
								//rs.close();
								//rs = null;
								//pstmt.close();
								//pstmt = null;

							//}
						}

					}//palet_no case
					/*-- not required
						else if ( "outer_carton_no".equalsIgnoreCase( childNodeName ) && "master_pick".equalsIgnoreCase(objName) )
						{
							if ( childNode.getFirstChild() == null)
							{
								errList.add( "NULLCARTNO" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else 
							{
								cartonNo = checkNull(genericUtility.getColumnValue( "outer_carton_no", currFormDataDom ));

								sql = "SELECT COUNT(*) AS COUNT FROM CARTON_MASTER WHERE STATUS = 'Y' AND CARTON_NO = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, cartonNo );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if ( count == 0 )
								{
									errList.add( "INVCARTNO" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}//outer_carton_no case
					 */
				}
			} //End of case 1 Validation
			break;
			case 2:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "tran_date".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "tran_date", "NULLTRANDT", userId );
							//break;
							errList.add( "NULLTRANDT" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}

					}//End of tran_date validation
					else if( "site_code".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "site_code", "NULLSITECD", userId );
							//break;
							errList.add( "NULLSITECD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						siteCode = genericUtility.getColumnValue( "site_code", currFormDataDom );
						sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if( count == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "site_code", "INVDSITECD", userId );
							//break;
							errList.add( "INVDSITECD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
					}//End of site_code validation
					else if ( "pick_order".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "pick_order", "NULPICKORD", userId );
							//break;
							errList.add( "NULPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						pickOrder = genericUtility.getColumnValue( "pick_order", currFormDataDom );

						sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if( count == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "repl_order", "INVPICKORD", userId );
							//break;
							errList.add( "INVPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
					}//End pick_order validation
					else if ( "pick_type".equalsIgnoreCase( childNodeName ) )
					{
						pickType = checkNull(genericUtility.getColumnValue( "pick_type", currFormDataDom ));
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "pick_type", "NULPICKTYP", userId );
							//break;
							errList.add( "NULPICKTYP" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						//
						else 
						{
							sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_HDR WHERE pick_type = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickType.trim() );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if( count == 0 )
							{
								errList.add( "INVPICKTYP" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}

						//
						/* -- Commented by Gulzar - on 30/11/11
							else if ( pickType.trim().equalsIgnoreCase("M") )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "pick_type", "INVPICKTYP", userId );
								//break;
								errList.add( "INVPICKTYP" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						 */
					}//End pick_type validation
					/*--Not required
						else if ( "outer_carton_no".equalsIgnoreCase( childNodeName ) && "master_pick".equalsIgnoreCase(objName) )
						{
							if ( childNode.getFirstChild() == null)
							{
								errList.add( "NULLCARTNO" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else 
							{
								cartonNo = checkNull(genericUtility.getColumnValue( "outer_carton_no", currFormDataDom ));

								sql = "SELECT COUNT(*) AS COUNT FROM CARTON_MASTER WHERE STATUS = 'Y' AND CARTON_NO = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, cartonNo );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if ( count == 0 )
								{
									errList.add( "INVCARTNO" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}//outer_carton_no validation
					 */
				}
			} //End of case 2 Validation
			break;
			case 3:
			{
				sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_DET WHERE PICK_ORDER = ? AND LINE_NO = ? AND LOT_NO = ? ";
				pstmtPickLotNo = conn.prepareStatement( sql );

				sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_DET WHERE PICK_ORDER = ? AND LINE_NO = ? AND LOT_SL = ? ";
				pstmtPickLotSl = conn.prepareStatement( sql );

				sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
				pstmtLoc = conn.prepareStatement( sql );

				sql = "SELECT QUANTITY FROM STOCK WHERE  SITE_CODE = ? AND LOC_CODE = ? ";
				pstmtStock = conn.prepareStatement( sql );

				//for single item_code and single lot_no
				//changed by sankara on 13/09/2012 add quantity.
				//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
				sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE (ITEM_CODE <> ? OR LOT_NO <> ?) AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
				pstmtStock1 = conn.prepareStatement( sql );

				//for single item_code and single lot_no
				//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
				//pstmtStock2 = conn.prepareStatement( sql );

				//for single item_code and multiple lot_no
				//changed by sankara on 13/09/2012 add quantity.
				//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
				sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
				pstmtStock3 = conn.prepareStatement( sql );

				//checking for correct picking location
				sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
						"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
						"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
				pstmtLoc1 = conn.prepareStatement( sql );

				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = checkNull(childNode.getFirstChild().getNodeValue());
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if( "lot_no".equalsIgnoreCase( childNodeName ) )
					{
						pickOrder =  genericUtility.getColumnValue("pick_order", allFormDataDom, objContext );
						lineNoPick = genericUtility.getColumnValue("line_no__ord", allFormDataDom, objContext );
						lotNo = genericUtility.getColumnValue("lot_no", allFormDataDom, objContext );

						pstmtPickLotNo.setString( 1, pickOrder );
						pstmtPickLotNo.setInt( 2, Integer.parseInt(lineNoPick) );
						pstmtPickLotNo.setString( 3, lotNo );

						rs = pstmtPickLotNo.executeQuery();
						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						pstmtPickLotNo.clearParameters();
						if ( count == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "lot_no", "INVLOTNO", userId );
							//break;
							errList.add( "INVLOTNO" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						rs.close(); rs = null;
					}
					else if( "lot_sl".equalsIgnoreCase( childNodeName ) )
					{
						pickOrder =  genericUtility.getColumnValue("pick_order", allFormDataDom, objContext );
						lineNoPick = genericUtility.getColumnValue("line_no__ord", allFormDataDom, objContext );
						lpnNo = genericUtility.getColumnValue("lot_sl", allFormDataDom, objContext );

						pstmtPickLotSl.setString( 1, pickOrder );
						pstmtPickLotSl.setInt( 2, Integer.parseInt(lineNoPick) );
						pstmtPickLotSl.setString( 3, lpnNo );

						rs = pstmtPickLotSl.executeQuery();
						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						pstmtPickLotSl.clearParameters();

						if ( count == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "lot_no", "INVLPNNO", userId );
							//break;
							errList.add( "INVLPNNO" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						rs.close(); rs = null;
						//////////////////////////////////////////////
						// 14/09/12 manoharan validate hold status
						itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, objContext ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, objContext ));
						locCode = checkNull(genericUtility.getColumnValue("loc_code", allFormDataDom, objContext ));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, objContext ));
						lotSl = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, objContext ));
						sql = " select count (*) from stock "
						+ " where item_code = ? "
						+ " and site_code = ? "
						+ " and loc_code = ? "
						+ " and lot_no = ? "
						+ " and lot_sl = ? "
						+ " and case when hold_qty is null then 0 else hold_qty end > 0  ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,itemCode);
						pstmt.setString(2,siteCode);
						pstmt.setString(3,locCode);
						pstmt.setString(4,lotNo);
						pstmt.setString(5,lotSl);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if( cnt > 0 )
						{
							errList.add( "INVITMQTST" );
							errFields.add( childNodeName.toLowerCase() );
						}
						// end 14/09/12 manoharan
						//////////////////////////////////////////////
					}
					else if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
					{								
						itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, objContext ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, objContext ));
						locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, objContext ));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, objContext ));
						lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, objContext ));
						pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, objContext ));

						pstmtLoc.setString( 1, locCodeTo );
						rs = pstmtLoc.executeQuery();
						if( rs.next() )
						{
							singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
							itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
						}
						else
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
							//break;
							errList.add( "INVLOCCODE" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						pstmtLoc.clearParameters();
						rs.close(); rs = null;

						pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2" ));
						String varName = "";
						if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
						{
							varName = "ACTIVE_PICK_INVSTAT";
						}
						else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick
						{
							varName = "CASE_PICK_INVSTAT";
						}
						DistCommon distComm = new DistCommon();

						String disparmVal = distComm.getDisparams( "999999", varName, conn );
						System.out.println(" disparmVal =[" + disparmVal + "]");

						count = 0;

						//if ( "NULLFOUND".equalsIgnoreCase(disparmVal) )//Commented by gulzar on 12/28/2011
						// 12/06/12 manoharan commented as loc_code__to to be be taken from transporter
						//if ( "NULLFOUND".equalsIgnoreCase(intrLocInvstat) )//Changes added by gulzar on 12/28/2011
						//{
						//	// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						//	//errString = getErrorString( "loc_code__to", "INVDISPARM", userId );
						//	//break;
						//	//errList.add( "PICKDPARM" );//Commented by gulzar on 12/28/2011
						//	errList.add( "DOCKDPARM" );//Changes added by gulzar on 12/28/2011
						//	errFields.add( childNodeName.toLowerCase() );
						//	// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						//}
						// 12/06/12 maanoharan commentd as loc_code__to wil be loc_code__dock from transporter
						//pstmtLoc1.setString( 1, locCodeTo );//Commented by gulzar on 12/28/2011
						//pstmtLoc1.setString( 2, disparmVal );
						//pstmtLoc1.setString( 2, intrLocInvstat );//Changes added by gulzar on 12/28/2011
						//rs = pstmtLoc1.executeQuery();	
						//if( rs.next() )
						//{
						//	count = rs.getInt("COUNT");
						//}
						/*
							sql="select t.loc_code__dock from transporter t, despatch d "
								+ " where t.tran_code = d.tran_code "
								+ " and d.desp_id in ( "
								+ " select wt.ref_id from wave_task_det wt where wt.ref_ser = 'S-DSP' and wt.ptcn in (select i.ptcn from wave_task_det i "
								+ " where i.ref_id = ? ) )  ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								docLocCode = rs.getString(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println(" locCodeTo [" + locCodeTo + "] docLocCode [" + docLocCode + "]");
							//if ( count == 0 )
							if (!docLocCode.trim().equals(locCodeTo.trim()))
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "loc_code__to", "VTLOCCODE5", userId );
								//break;
								errList.add( "VTLOCCODE5" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						 */
						if( singleLotSl.trim().equalsIgnoreCase("Y") )
						{
							pstmtStock.setString( 1, siteCode );
							pstmtStock.setString( 2, locCodeTo );
							rs = pstmtStock.executeQuery();	
							if( rs.next() )
							{
								quantity = rs.getDouble("QUANTITY");
							}
							pstmtStock.clearParameters();
							rs.close(); rs = null;

							if( quantity != 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "loc_code__to", "VTLOCCODE1", userId );
								//break;
								errList.add( "VTLOCCODE1" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						}
						else
						{
							if( itemLotOpt.trim().equals("0") )  // Validation for single item_code and single lot_no
							{
								//changed by sankara on 13/09/2012 to set string in a row based on sql [Start]
								/*	pstmtStock1.setString( 1, itemCode );
									pstmtStock1.setString( 2, siteCode );
									pstmtStock1.setString( 3, locCodeTo );
									pstmtStock1.setString( 4, lotNo );  */
									pstmtStock1.setString( 1, itemCode );
									pstmtStock1.setString( 2, lotNo ); 
									pstmtStock1.setString( 3, siteCode );
									pstmtStock1.setString( 4, locCodeTo );
									//changed by sankara on 13/09/2012 to set string in a row based on sql [End]
								rs = pstmtStock1.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtStock1.clearParameters();
								rs.close(); rs = null;

								if( count > 0 )
								{
									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									//errString = getErrorString("loc_code__to", "VTLOCCODE2", userId );
									//break;
									errList.add( "VTLOCCODE2" );
									errFields.add( childNodeName.toLowerCase() );
									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								}
								/* -- Commented by gulzar - 29/11/11 - for single item and single lot it is not required
									pstmtStock2.setString( 1, itemCode );
									pstmtStock2.setString( 2, siteCode );
									pstmtStock2.setString( 3, locCodeTo );
									pstmtStock2.setString( 4, lotNo );
									rs = pstmtStock2.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									pstmtStock2.clearParameters();
									rs.close(); rs = null;

									if( count > 0 )
									{
										// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
										//errString = getErrorString("loc_code__to", "VTLOCCODE3", userId );
										//break;
										errList.add( "VTLOCCODE3" );
										errFields.add( childNodeName.toLowerCase() );
										// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									}
								 */
							}
							else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code and multiple lot_no
							{
								//changed by sankara on 13/09/2012 to set string in a row based on sql [Start]	
								/*	pstmtStock3.setString( 1, itemCode );
									pstmtStock3.setString( 2, siteCode );
									pstmtStock3.setString( 3, locCodeTo );
									pstmtStock3.setString( 4, lotNo ); */
									pstmtStock3.setString( 1, itemCode );
									pstmtStock3.setString( 2, siteCode );
									pstmtStock3.setString( 3, locCodeTo );
								//changed by sankara on 13/09/2012 to set string in a row based on sql [Start]	
								rs = pstmtStock3.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtStock3.clearParameters();
								rs.close(); rs = null;

								if( count > 0 )
								{
									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									//errString = getErrorString("loc_code__to", "VTLOCCODE4", userId );
									//break;
									errList.add( "VTLOCCODE4" );
									errFields.add( childNodeName.toLowerCase() );
									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								}
							}//itemLotOpt = '1'
						}//singleLotSl != 'Y'
					}//loc_code__to case
					//case added by gulzar - 30/11/11 - to case should not assigned to same case label

					else if( "case_label".equalsIgnoreCase( childNodeName ) )
					{

						if ( childNode.getFirstChild() == null)
						{
							//errList.add( "VTCASELBL1" );  //change done by C Pandey on 08/08/12 
							//errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							//caseLabel =  genericUtility.getColumnValue("case_label", allFormDataDom, objContext );
							caseLabel =  genericUtility.getColumnValue("case_label", currFormDataDom, objContext );

							//changes added by gulzar on 12/13/2011
							tranID =  genericUtility.getColumnValue("tran_id", currFormDataDom, objContext );
							//End changes by gulzar on 12/13/2011

							//changes by gulzar - 08/12/11
							String caseLabelPrev = "";
							NodeList caseLabelList = null;
							int caseLblCntDb = 0;
							int recCnt = 0;
							caseLabelList = allFormDataDom.getElementsByTagName("case_label");
							int noOfLabel = caseLabelList.getLength();

							/*
								for( int idx = 0; idx < noOfLabel; idx++ )
								{
									if ( caseLabelList.item( idx ).getFirstChild() != null )
									{
										caseLabelPrev = ( caseLabelList.item( idx ).getFirstChild() ).getNodeValue();
									}
									System.out.println( "caseLabelPrev =[ " + caseLabelPrev + "] AND CURR caseLabel =[" + caseLabel + " ]" );
									if( caseLabelPrev.equals( caseLabel ) )
									{
										recCnt++;
									}
								}
							 */
							ArrayList caseList = new ArrayList();
							for( int idx = 0; idx < noOfLabel; idx++ )
							{
								if ( caseLabelList.item( idx ).getFirstChild() != null )
								{
									caseList.add(( caseLabelList.item( idx ).getFirstChild() ).getNodeValue());
								}
							}
							int listLen = caseList.size();
							if ( listLen > 0 )
							{
								recCnt = 1;
								for( int i = 0; i < listLen - 1; i++ )
								{
									for ( int j = i+1; j < listLen; j++ )
									{
										if ( ((String)caseList.get(i)).equalsIgnoreCase((String)caseList.get(j)) )
										{
											recCnt++;
											break;
										}
									}
									if( recCnt > 1 )
									{
										break;
									}
								}
							}
							System.out.println("recCnt = ["+recCnt+"]");

							if( recCnt > 1 )
							{
								errList.add( "DUPCASELBL" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else if ( tranID != null && tranID.trim().length() > 0 )
							{
								sql = "SELECT count(*) AS COUNT FROM PICK_ISS_DET WHERE TRAN_ID <> ? AND CASE_LABEL = ? ";
								pstmt = conn.prepareStatement(sql);

								for( int idx = 0; idx < noOfLabel; idx++ )
								{
									if ( caseLabelList.item( idx ).getFirstChild() != null )
									{
										caseLabelPrev = ( caseLabelList.item( idx ).getFirstChild() ).getNodeValue();

										pstmt.setString( 1, tranID );
										pstmt.setString( 2, caseLabelPrev );
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											caseLblCntDb = rs.getInt("COUNT");
										}
										rs.close(); rs = null;
										pstmt.clearParameters();
										System.out.println( "caseLblCntDb =[" +caseLblCntDb+ "]" );
										if ( caseLblCntDb > 0 )
										{
											errList.add( "VTCASELBL2" );
											errFields.add( childNodeName.toLowerCase() );
											break;
										}
									}
								}
								pstmt.close(); pstmt = null;
							}
							else if ( tranID == null || tranID.trim().length() == 0 )
							{
								sql = "SELECT count(*) AS COUNT FROM PICK_ISS_DET WHERE CASE_LABEL = ? ";
								pstmt = conn.prepareStatement(sql);

								for( int idx = 0; idx < noOfLabel; idx++ )
								{
									if ( caseLabelList.item( idx ).getFirstChild() != null )
									{
										caseLabelPrev = ( caseLabelList.item( idx ).getFirstChild() ).getNodeValue();

										pstmt.setString( 1, caseLabelPrev );
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											caseLblCntDb = rs.getInt("COUNT");
										}
										rs.close(); rs = null;
										pstmt.clearParameters();
										System.out.println( "caseLblCntDb =[" +caseLblCntDb+ "]" );
										if ( caseLblCntDb > 0 )
										{
											errList.add( "VTCASELBL2" );
											errFields.add( childNodeName.toLowerCase() );
											break;
										}
									}
								}
								pstmt.close(); pstmt = null;
							}
							//End changes by gulzar - 08/12/11
						}
					}
					else if ( "carton_no".equalsIgnoreCase( childNodeName ) && "master_pick".equalsIgnoreCase(objName) )
					{
						if ( childNode.getFirstChild() == null)
						{
							errList.add( "NULLCARTNO" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else 
						{
							//String status = "";
							String lineNo = "";
							String cartonNoDb = "";
							int lineNoIss = 0;

							tranID =  checkNull(genericUtility.getColumnValue("tran_id", currFormDataDom, objContext ));
							lineNo =  checkNull(genericUtility.getColumnValue("line_no", currFormDataDom, objContext ));
							if ( lineNo.trim().length() > 0 )
							{
								//lineNoIss = Integer.parseInt(lineNo);
							}

							cartonNo = checkNull(genericUtility.getColumnValue( "carton_no", currFormDataDom, objContext ));

							if ( tranID.trim().length() > 0 )
							{
								/*
									sql = "SELECT CARTON_NO FROM PICK_ISS_DET WHERE TRAN_ID = ? AND LINE_NO = ? ";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, tranID );
									pstmt.setInt( 2, lineNoIss );
									rs = pstmt.executeQuery();	
									if( rs.next() )
									{
										cartonNoDb = checkNull(rs.getString("CARTON_NO"));
									}
									if ( ! cartonNoDb.trim().equalsIgnoreCase(cartonNo.trim()) )
									{
										sql = "SELECT STATUS FROM CARTON_MASTER WHERE CARTON_NO = ? ";
										pstmt = conn.prepareStatement( sql );
										pstmt.setString( 1, cartonNo );
										rs = pstmt.executeQuery();	
										if( rs.next() )
										{
											status = checkNull(rs.getString("STATUS"));
										}
										else
										{
											errList.add( "VTCARTNO4" );
											errFields.add( childNodeName.toLowerCase() );
										}
										rs.close(); rs = null;
										pstmt.close(); pstmt = null;
										if ( ! "A".equalsIgnoreCase(status.trim()) )
										{
											errList.add( "VTCARTNO2" );
											errFields.add( childNodeName.toLowerCase() );
										}
									}
								 */
								int ctnCount = 0;

								sql = "SELECT COUNT(*) AS COUNT FROM PICK_ISS_DET WHERE TRAN_ID = ? AND CARTON_NO = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, tranID );
								pstmt.setString( 2, cartonNo );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									ctnCount = rs.getInt("COUNT");
								}
								if ( ctnCount == 0 )
								{
									sql = "SELECT STATUS FROM CARTON_MASTER WHERE CARTON_NO = ? ";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, cartonNo );
									rs = pstmt.executeQuery();	
									if( rs.next() )
									{
										status = checkNull(rs.getString("STATUS"));
									}
									else
									{
										errList.add( "VTCARTNO4" );
										errFields.add( childNodeName.toLowerCase() );
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if ( ! "A".equalsIgnoreCase(status.trim()) )
									{
										errList.add( "VTCARTNO2" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
							}
							else if ( tranID.trim().length() == 0 )
							{
								sql = "SELECT STATUS FROM CARTON_MASTER WHERE CARTON_NO = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, cartonNo );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									status = checkNull(rs.getString("STATUS"));
								}
								else
								{
									errList.add( "VTCARTNO4" );
									errFields.add( childNodeName.toLowerCase() );
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if ( ! "A".equalsIgnoreCase(status.trim()) )
								{
									errList.add( "VTCARTNO2" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}//carton_no case
					//End changes made by gulzar on 30/11/11
					// added by cpatil for validate quantity on 10-Jun-12  start
					else if ( "quantity".equalsIgnoreCase( childNodeName ) )
					{
						pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2" ));
						String quantity2 =  genericUtility.getColumnValue("quantity", currFormDataDom, objContext );
						double ordQty = 0;
						if (quantity2 == null || "null".equals(quantity2) || quantity2.trim().length() == 0)
						{
							quantity2 = "0";
						}
						quantity  = Double.parseDouble(quantity2);
						if(quantity2 == null || quantity2.trim().length() == 0)
						{
							errList.add( "VTQUNT2" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							// 12/06/12 manoharan validate quantity for active
							pickOrder =  genericUtility.getColumnValue("pick_order", currFormDataDom, objContext );
							String lineNo = genericUtility.getColumnValue("line_no__ord", currFormDataDom, objContext );
							sql = "SELECT quantity,no_art FROM PICK_ORD_DET WHERE PICK_ORDER = ? AND LINE_NO = " + lineNo;
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, pickOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ordQty = rs.getDouble(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if ("A".equals(pickType) && ordQty != quantity)
							{
								errList.add( "VQUANTI" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					else if ( "no_art".equalsIgnoreCase( childNodeName ) )
					{
						pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2" ));
						String noArtStr =  genericUtility.getColumnValue("no_art", currFormDataDom, objContext );
						int ordNoArt = 0, noArt = 0;
						if (noArtStr == null || "null".equals(noArtStr) || noArtStr.trim().length() == 0)
						{
							noArtStr = "0";
						}
						//noArt  = Integer.parseInt(noArtStr);
						noArt  =  (int)Double.parseDouble(noArtStr); //change done by Kunal on 13/09/12 
						
						if(noArt == 0)
						{
							errList.add( "VTQUNT2" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							// 12/06/12 manoharan validate quantity for active
							pickOrder =  genericUtility.getColumnValue("pick_order", currFormDataDom, objContext );
							String lineNo = genericUtility.getColumnValue("line_no__ord", currFormDataDom, objContext );
							sql = "SELECT quantity,no_art FROM PICK_ORD_DET WHERE PICK_ORDER = ? AND LINE_NO = " + lineNo;
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, pickOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ordNoArt = rs.getInt(2);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (!"A".equals(pickType) && ordNoArt != noArt)
							{
								errList.add( "VQUANTI" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}

					// added by cpatil for validate quantity on 10-Jun-12  end	
				}
				////////////////////////////////////////////////////
				/*----------
					for( int prnt = 0; prnt < noOfParent; prnt++ )  // Loop for multiple details in allFormDataDom
					{
						childList = parentList.item(prnt).getChildNodes();
						noOfChilds = childList.getLength();

						rowCountStr = ""+(prnt+1);
						System.out.println("rowCountStr=["+rowCountStr+"]");

						for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
						{	
							Node childNode = childList.item( ctr );
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							String childNodeName = childNode.getNodeName();
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
							if( "lot_no".equalsIgnoreCase( childNodeName ) )
							{
								pickOrder =  genericUtility.getColumnValue("pick_order", allFormDataDom, "3", rowCountStr );
								lineNoPick = genericUtility.getColumnValue("line_no__ord", allFormDataDom, "3", rowCountStr );
								lotNo = genericUtility.getColumnValue("lot_no", allFormDataDom, "3", rowCountStr );

								pstmtPickLotNo.setString( 1, pickOrder );
								pstmtPickLotNo.setInt( 2, Integer.parseInt(lineNoPick) );
								pstmtPickLotNo.setString( 3, lotNo );

								rs = pstmtPickLotNo.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtPickLotNo.clearParameters();
								if ( count == 0 )
								{
									errString = getErrorString( "lot_no", "INVLOTNO", userId );
									break;
								}
								rs.close(); rs = null;
							}
							else if( "lot_sl".equalsIgnoreCase( childNodeName ) )
							{
								pickOrder =  genericUtility.getColumnValue("pick_order", allFormDataDom, "3", rowCountStr );
								lineNoPick = genericUtility.getColumnValue("line_no__ord", allFormDataDom, "3", rowCountStr );
								lpnNo = genericUtility.getColumnValue("lot_sl", allFormDataDom, "3", rowCountStr );

								pstmtPickLotSl.setString( 1, pickOrder );
								pstmtPickLotSl.setInt( 2, Integer.parseInt(lineNoPick) );
								pstmtPickLotSl.setString( 3, lpnNo );

								rs = pstmtPickLotSl.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtPickLotSl.clearParameters();

								if ( count == 0 )
								{
									errString = getErrorString( "lot_no", "INVLPNNO", userId );
									break;
								}
								rs.close(); rs = null;
							}
							else if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
							{								
								itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3", rowCountStr ));
								siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "3", rowCountStr ));
								locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "3", rowCountStr ));
								lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "3", rowCountStr ));
								lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "3", rowCountStr ));
								pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3", rowCountStr ));

								pstmtLoc.setString( 1, locCodeTo );
								rs = pstmtLoc.executeQuery();
								if( rs.next() )
								{
									singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
									itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
								}
								else
								{
									errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
									break;
								}
								pstmtLoc.clearParameters();
								rs.close(); rs = null;

								if( singleLotSl.trim().equalsIgnoreCase("Y") )
								{
									pstmtStock.setString( 1, itemCode );
									pstmtStock.setString( 2, siteCode );
									pstmtStock.setString( 3, locCodeTo );
									pstmtStock.setString( 4, lotNo );
									pstmtStock.setString( 5, lpnNo );
									rs = pstmtStock.executeQuery();	
									if( rs.next() )
									{
										quantity = rs.getDouble("QUANTITY");
									}
									pstmtStock.clearParameters();
									rs.close(); rs = null;

									if( quantity != 0 )
									{
										errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
										break;
									}
								}
								else
								{
									if( itemLotOpt.trim().equals("0") )  // Validation for single item_code and single lot_no
									{
										pstmtStock1.setString( 1, itemCode );
										pstmtStock1.setString( 2, siteCode );
										pstmtStock1.setString( 3, locCodeTo );
										pstmtStock1.setString( 4, lotNo );
										rs = pstmtStock1.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										pstmtStock1.clearParameters();
										rs.close(); rs = null;

										if( count > 0 )
										{
											errString = getErrorString("loc_code__to", "INVLOCCODE", userId );
											break;
										}
										pstmtStock2.setString( 1, itemCode );
										pstmtStock2.setString( 2, siteCode );
										pstmtStock2.setString( 3, locCodeTo );
										pstmtStock2.setString( 4, lotNo );
										rs = pstmtStock2.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										pstmtStock2.clearParameters();
										rs.close(); rs = null;

										if( count > 0 )
										{
											errString = getErrorString("loc_code__to", "INVLOCCODE", userId );
											break;
										}
									}
									else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code and multiple lot_no
									{
										pstmtStock3.setString( 1, itemCode );
										pstmtStock3.setString( 2, siteCode );
										pstmtStock3.setString( 3, locCodeTo );
										pstmtStock3.setString( 4, lotNo );
										rs = pstmtStock3.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										pstmtStock3.clearParameters();
										rs.close(); rs = null;

										if( count > 0 )
										{
											errString = getErrorString("loc_code__to", "INVLOCCODE", userId );
											break;
										}
									}
								}

								pstmt.setString( 1, itemCode );
								pstmt.setString( 2, siteCode );
								pstmt.setString( 3, locCodeTo );
								pstmt.setString( 4, lotNo );
								pstmt.setString( 5, lpnNo );
								rs = pstmt.executeQuery();	

								if( rs.next() )
								{
									confirmed = checkNull(rs.getString("CONFIRMED"));
								}
								pstmt.clearParameters();
								rs.close(); rs = null;

								if( confirmed.trim().equalsIgnoreCase("N") )
								{
									errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
									break;
								}									
							}
						}
						if ( errString != null && errString.trim().length() > 0 )
						{
							break;
						}
					}
				 */
				////////////////////////////////////
			} //End of Case 3 Validation		
			case 4:
				//				{
				//					//for single item_code and multiple lot_no
				//					//checking for correct picking location
				//					sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
				//							"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
				//							"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
				//					pstmtLoc1 = conn.prepareStatement( sql );
				//
				//					childList = parentList.item(0).getChildNodes();
				//					noOfChilds = childList.getLength();
				//					
				//					for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				//					{	
				//						Node childNode = childList.item( ctr );
				//						if( childNode.getNodeType() != Node.ELEMENT_NODE )
				//						{
				//							continue;
				//						}
				//						String childNodeName = childNode.getNodeName();
				//						if ( childNode != null && childNode.getFirstChild() != null )
				//						{
				//							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
				//						}
				//						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
				//						if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
				//						{								
				//							itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3" ));
				//							siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "3" ));
				//							locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, objContext ));
				//							lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "3" ));
				//							lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "3" ));
				//							pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));
				//							docLocCode = checkNull(genericUtility.getColumnValue("loc_code__sys", allFormDataDom, objContext ));
				//							sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
				//							pstmtLoc = conn.prepareStatement( sql );
				//							pstmtLoc.setString( 1, locCodeTo );
				//							rs = pstmtLoc.executeQuery();
				//							if( rs.next() )
				//							{
				//								singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
				//								itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
				//							}
				//							else
				//							{
				//								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//								//errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
				//								//break;
				//								errList.add( "INVLOCCODE" );
				//								errFields.add( childNodeName.toLowerCase() );
				//								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//							}
				//							pstmtLoc.clearParameters();
				//							rs.close(); rs = null;
				//
				//							pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2" ));
				//							String varName = "";
				//							if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
				//							{
				//								varName = "ACTIVE_PICK_INVSTAT";
				//							}
				//							else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick
				//							{
				//								varName = "CASE_PICK_INVSTAT";
				//							}
				//							DistCommon distComm = new DistCommon();
				//
				//							String disparmVal = distComm.getDisparams( "999999", varName, conn );
				//							System.out.println(" disparmVal =[" + disparmVal + "]");
				//							
				//							count = 0;
				//
				//							
				//							/*sql="select t.loc_code__dock from transporter t, despatch d "
				//								+ " where t.tran_code = d.tran_code "
				//								+ " and d.desp_id in ( "
				//								+ " select wt.ref_id from wave_task_det wt where wt.ref_ser = 'S-DSP' and wt.ptcn in (select i.ptcn from wave_task_det i "
				//								+ " where i.ref_id = ? ) )  ";
				//							pstmt = conn.prepareStatement( sql );
				//							pstmt.setString( 1, pickOrder );
				//							rs = pstmt.executeQuery();
				//							if ( rs.next() )
				//							{
				//								docLocCode = rs.getString(1);
				//							}
				//							rs.close();
				//							rs = null;
				//							pstmt.close();
				//							pstmt = null;
				//							System.out.println(" locCodeTo [" + locCodeTo + "] docLocCode [" + docLocCode + "]");
				//							//if ( count == 0 )
				//							if (!docLocCode.trim().equals(locCodeTo.trim()))
				//							{
				//								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//								//errString = getErrorString( "loc_code__to", "VTLOCCODE5", userId );
				//								//break;
				//								errList.add( "VTLOCCODE5" );
				//								errFields.add( childNodeName.toLowerCase() );
				//								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//							}*/
				//							if( singleLotSl.trim().equalsIgnoreCase("Y") )
				//							{
				//								sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
				//								pstmtStock = conn.prepareStatement( sql );
				//								pstmtStock.setString( 1, itemCode );
				//								pstmtStock.setString( 2, siteCode );
				//								pstmtStock.setString( 3, locCodeTo );
				//								pstmtStock.setString( 4, lotNo );
				//								pstmtStock.setString( 5, lpnNo );
				//								rs = pstmtStock.executeQuery();	
				//								if( rs.next() )
				//								{
				//									quantity = rs.getDouble("QUANTITY");
				//								}
				//								pstmtStock.clearParameters();
				//								rs.close(); rs = null;
				//								
				//								if( quantity != 0 )
				//								{
				//									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//									//errString = getErrorString( "loc_code__to", "VTLOCCODE1", userId );
				//									//break;
				//									errList.add( "VTLOCCODE1" );
				//									errFields.add( childNodeName.toLowerCase() );
				//									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//								}
				//							}
				//							else
				//							{
				//								if( itemLotOpt.trim().equals("0") )  // Validation for single item_code and single lot_no
				//								{
				//									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
				//									pstmtStock1 = conn.prepareStatement( sql );
				//									pstmtStock1.setString( 1, itemCode );
				//									pstmtStock1.setString( 2, siteCode );
				//									pstmtStock1.setString( 3, locCodeTo );
				//									pstmtStock1.setString( 4, lotNo );
				//									rs = pstmtStock1.executeQuery();
				//									if( rs.next() )
				//									{
				//										count = rs.getInt("COUNT");
				//									}
				//									pstmtStock1.clearParameters();
				//									rs.close(); rs = null;
				//
				//									if( count > 0 )
				//									{
				//										// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//										//errString = getErrorString("loc_code__to", "VTLOCCODE2", userId );
				//										//break;
				//										errList.add( "VTLOCCODE2" );
				//										errFields.add( childNodeName.toLowerCase() );
				//										// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//									}
				//								}
				//								else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code and multiple lot_no
				//								{
				//									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
				//									pstmtStock3 = conn.prepareStatement( sql );
				//
				//									pstmtStock3.setString( 1, itemCode );
				//									pstmtStock3.setString( 2, siteCode );
				//									pstmtStock3.setString( 3, locCodeTo );
				//									pstmtStock3.setString( 4, lotNo );
				//									rs = pstmtStock3.executeQuery();
				//									if( rs.next() )
				//									{
				//										count = rs.getInt("COUNT");
				//									}
				//									pstmtStock3.clearParameters();
				//									rs.close(); rs = null;
				//
				//									if( count > 0 )
				//									{
				//										// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//										//errString = getErrorString("loc_code__to", "VTLOCCODE4", userId );
				//										//break;
				//										errList.add( "VTLOCCODE4" );
				//										errFields.add( childNodeName.toLowerCase() );
				//										// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
				//									}
				//								}//itemLotOpt = '1'
				//							}//singleLotSl != 'Y'
				//						}//loc_code__to case
				//						// added by cpatil for validate quantity on 10-Jun-12  end	
				//					}
				//				} //End of Case 4 Validation		
			}//End of switch statement
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: PickIssIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			//throw new ITMException(e);
			e.printStackTrace();
			errString = generateErrorString( genericUtility.createErrorString( e ) ) ;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				
				if (pstmt!=null)
				{
					pstmt.close(); pstmt = null;
				}
				if (pstmtPickLotNo!=null)
				{
					pstmtPickLotNo.close(); pstmtPickLotNo = null;
				}
				if (pstmtPickLotSl!=null)
				{
					pstmtPickLotSl.close(); pstmtPickLotSl = null;
				}
				if (pstmtLoc!=null)
				{
					pstmtLoc.close(); pstmtLoc = null;
				}
				if (pstmtLoc1!=null)
				{
					pstmtLoc1.close(); pstmtLoc1 = null;
				}
				if (pstmtStock!=null)
				{
					pstmtStock.close(); pstmtStock = null;
				}
				if (pstmtStock1!=null)
				{
					pstmtStock1.close(); pstmtStock1 = null;
				}
				if (pstmtStock2!=null)
				{
					pstmtStock2.close(); pstmtStock2 = null;
				}
				if( pstmtStock3 != null  )
				{
					pstmtStock3.close(); pstmtStock3 = null;
				}
				if( conn != null  )
				{
					conn.close(); conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PickIssIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}


	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :PickIssIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PickIssIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{		
		String retString = "";		
		String siteCode = "";
		String itemCode = "";
		String locCode = "";
		String lotNo = "";
		String lpnNo = "";
		String pickOrder = "";
		String siteDescr = "";
		String tranID = "";
		String tranDate = "";
		String sql = "";
		String locCodeTo = "";
		String itemDescr = "";
		String unit = "";
		String pickType = "";
		String palletNo = "";
		String pickLocInvstat = "";
		String cartonNo = "";
		String pickLocCode = "";
		String stockSql = "",docLocCode = "";
		String userId = "";

		int currentFormNo = 0;
		int lineNoOrd = 0;
		int lineNoIss = 0;
		int domID = 0;
		int locListSize = 0;
		int count = 0;

		double quantity = 0;
		double noArt = 0;
		double qtyPerArt = 0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtOrd = null;
		PreparedStatement pstmtIss = null;
		PreparedStatement pstmtStock = null;

		ResultSet rs = null ;
		ResultSet rsOrd = null ;
		ResultSet rsIss = null ;
		ResultSet rsStock = null ;
		ArrayList pickLocList = null;

		StringBuffer valueXmlString;

		System.out.println("xtraParams=["+xtraParams+"]");
		DistCommon distCommon = new DistCommon();

		GenericUtility genericUtility = GenericUtility.getInstance();
		genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

		String objName = checkNullAndTrim(getObjNameFromDom( currFormDataDom, "objName", objContext ));

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );

		try
		{
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );	
			connDriver = null;

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//valueXmlString.append( "<trans_mode><![CDATA[" ).append( "E" ).append( "]]></trans_mode>\r\n" );
				}
				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:
			{
				System.out.println("inside case 2 itemchange");
				//valueXmlString.append( "<Detail2 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					pickOrder = genericUtility.getColumnValue( "pick_order", hdrDataDom );

					java.sql.Date tranDateDb = null;

					java.util.Date currDate = new java.util.Date();
					tranDate = dtFormat.format( currDate );

					String loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
					String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					palletNo = genericUtility.getColumnValue( "pallet_no", hdrDataDom );
					if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
					{
						siteCode = getSiteCode( xtraParams, conn );
					}
					System.out.println("siteCode = ["+siteCode+"]");

					sql = "SELECT TRAN_ID, TRAN_DATE, PICK_ORDER, SITE_CODE, PICK_TYPE, PALLET_NO FROM PICK_ISS_HDR WHERE PICK_ORDER = ? AND PALLET_NO = ? AND CHG_USER = ? AND case when confirmed is null then 'N' else confirmed end = 'N'";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, pickOrder );
					pstmt.setString( 2, palletNo );
					pstmt.setString( 3, loginCode );
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						tranID = rs.getString("TRAN_ID");
						tranDateDb = rs.getDate("TRAN_DATE");
						siteCode = rs.getString("SITE_CODE");
						pickType = checkNull(rs.getString("PICK_TYPE"));
						palletNo = rs.getString("PALLET_NO");
						//valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );
						valueXmlString.append("<Detail2 domID='1' selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );  //commented by Ashish Sonawane on 11-sep-12 for generating pick_issue for each time 
					}
					else
					{
						tranID = genericUtility.getColumnValue( "tran_id", currFormDataDom );
						palletNo = genericUtility.getColumnValue( "pallet_no", hdrDataDom );
						valueXmlString.append("<Detail2 domID='1' selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					/*	
					if ( tranID == null || tranID.trim().length() == 0 ) //commented by Ashish Sonawane on 11-sep-12
					{ */

						//

						sql = "SELECT SITE_CODE, PICK_TYPE FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							pickType = checkNull(rs.getString("PICK_TYPE"));
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;
					//}
					if ( tranDateDb != null )
					{
					//	tranDate = genericUtility.getValidDateString( tranDateDb.toString() , dbDateFormat, applDateFormat ); //commented by Ashish Sonawane on 11-sep-12 
					}
					valueXmlString.append( "<tran_date protect ='1'><![CDATA[" ).append( checkNull( tranDate )).append( "]]></tran_date>\r\n" );
					valueXmlString.append( "<pick_type protect ='1'><![CDATA[" ).append( checkNull( pickType )).append( "]]></pick_type>\r\n" );
					valueXmlString.append( "<pallet_no><![CDATA[" ).append( checkNull( palletNo )).append( "]]></pallet_no>\r\n" );
					valueXmlString.append( "<pick_order><![CDATA[" ).append( checkNull( pickOrder )).append( "]]></pick_order>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );

					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, siteCode );						
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						siteDescr = rs.getString("DESCR");
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					valueXmlString.append( "<site_descr><![CDATA[").append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
					valueXmlString.append( "<confirmed><![CDATA[").append("N").append( "]]></confirmed>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[").append( loginCode ).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[").append( tranDate ).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[").append( chgTerm ).append( "]]></chg_term>\r\n" );
				}
				valueXmlString.append("</Detail2>\r\n");
			} //Case 2. End
			break;
			case 3://Case 3. Start
			{
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					HashMap pickIssMap = new HashMap();
					double noArtPickIss = 0d;
					String lineNoPickIss = "";
					String caseLabel = "";
					String transMode = "";
					String varName = "";
					String locCodeSys = "";
					String intrLocInvstat = "";//Gulzar on 5/13/2012
					String CasePickOption=""; //cpatil on 15/06/2012

					pickOrder = checkNull(genericUtility.getColumnValue( "pick_order", hdrDataDom ));
					//transMode = checkNull(genericUtility.getColumnValue( "trans_mode", hdrDataDom ));
					tranID = checkNull(genericUtility.getColumnValue("tran_id", allFormDataDom, "2"));
					pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2"));
					String quantity2 = checkNull(genericUtility.getColumnValue("quantity", allFormDataDom, "3"));
					System.out.println("@@@@@@@ quantity : "+quantity2);
					//changes made by deepak - 25/11/11
					pickLocList = new ArrayList();
					if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
					{
						varName = "ACTIVE_PICK_INVSTAT";
					}
					else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick
					{
						varName = "CASE_PICK_INVSTAT";
					}
					pickLocInvstat = distCommon.getDisparams( "999999", varName, conn );

					//Changes made for INTR Locationby Gulzar on 5/13/2012
					intrLocInvstat = distCommon.getDisparams( "999999", "INTR_LOCATION", conn );


					CasePickOption = distCommon.getDisparams( "999999", "CASE_PICK_OPTION", conn );  //cpatil on 15/06/2012
					System.out.println("@@@@@@ CasePickOption:["+CasePickOption+"]");
					//Changes by gulzar on 12/28/2011
					String intrLocCode = "";
					//intrLocInvstat = distCommon.getDisparams( "999999", "DOCKLOC_INVSTAT", conn );
					//End changes by gulzar on 12/28/2011

					//Commented and changes below by gulzar on 12/23/2011
					/*
						sql = "SELECT A.LOC_CODE FROM STOCK A , INVSTAT B, LOCATION C "
								+ " WHERE A.LOC_CODE = C.LOC_CODE AND C.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
								+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
								+ " AND A.QUANTITY = 0 AND C.INV_STAT = ?  ORDER BY LOC_CODE ";

					 */

					sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
							+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
							+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
					//
					//pstmt =  conn.prepareStatement(sql);
					//pstmt.setString(1, intrLocInvstat);
					//rs = pstmt.executeQuery();
					//if ( rs.next() )
					//{
					//	intrLocCode = checkNull(rs.getString("LOC_CODE") );
					//}
					//pstmt.clearParameters();
					//rs.close(); rs = null;
					//pstmt.close(); pstmt = null;

					double stockQty = 0d;
					//stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
					//		+  " FROM STOCK WHERE LOC_CODE = ? ";

					//pstmtStock =  conn.prepareStatement(stockSql);

					//pstmt =  conn.prepareStatement(sql);
					//pstmt.setString(1, pickLocInvstat);//Commented  added by gulzar on 12/28/2011
					//pstmt.setString(1, intrLocInvstat);//Changes added by gulzar on 12/28/2011
					//rs = pstmt.executeQuery();
					//while (rs.next())
					//{
					//	pickLocCode = checkNull(rs.getString("LOC_CODE") );
					//
					//	pstmtStock.setString( 1, pickLocCode );
					//	rsStock = pstmtStock.executeQuery();
					//	if ( rsStock.next() )
					//	{
					//		stockQty = rsStock.getDouble("STOCK_QTY");/
					//
					//		if ( stockQty == 0 )
					//		{
					//			pickLocList.add(pickLocCode);
					//		}
					//	}
					//	else
					//	{
					//		pickLocList.add(pickLocCode);
					//	}
					//	pstmtStock.clearParameters();
					//	rsStock.close(); rsStock = null;
					//}
					//rs.close(); rs = null;						
					//pstmt.close(); pstmt = null;
					//pstmtStock.close(); pstmtStock = null;

					//End changes by gulzar on 12/23/2011

					System.out.println("pickLocList...>>>> "+pickLocList);
					locListSize = pickLocList.size();
					System.out.println("locListSize...>>>> "+locListSize);
					//End changes by deepak - 25/11/11

					if ( tranID.trim().length() > 0 )
					{
						sql = "SELECT PICK_ORDER, LINE_NO__ORD, SUM( CASE WHEN NO_ART IS NULL THEN 0 ELSE NO_ART END ) NO_ART  "//loc_code__to " +
								+" FROM PICK_ISS_DET WHERE TRAN_ID = ? GROUP BY PICK_ORDER, LINE_NO__ORD " ;
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, tranID );
						rs = pstmt.executeQuery();

						while ( rs.next() )
						{
							lineNoPickIss = rs.getString("LINE_NO__ORD");
							noArtPickIss = rs.getDouble("NO_ART");
							pickIssMap.put( lineNoPickIss, noArtPickIss );
							//locCodeTo = rs.getString("LOC_CODE__TO");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						System.out.println("pickIssMap = ::"+pickIssMap);
						
					sql = "SELECT MAX(LINE_NO)  FROM PICK_ISS_DET WHERE TRAN_ID = ?";
					
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, tranID );
					rs = pstmt.executeQuery();

					if ( rs.next() )
					{
						domID = rs.getInt(1);
						//locCodeTo = rs.getString("LOC_CODE__TO");
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					}
					
					


					////  added by cpatil for loaction on 12-Jun-12 start
					//sql="select t.loc_code__dock from transporter t, despatch d "
					//	+ " where t.tran_code = d.tran_code "
					//	+ " and d.desp_id in ( "
					//	+ " select wt.ref_id from wave_task_det wt where wt.ref_ser = 'S-DSP' and wt.ptcn in (select i.ptcn from wave_task_det i "
					//	+ " where i.ref_id = ? ) )  ";
					//pstmt = conn.prepareStatement( sql );
					//pstmt.setString( 1, pickOrder );
					//rs = pstmt.executeQuery();
					//while ( rs.next() )
					//{
					//	locCodeTo = rs.getString(1);
					//}
					//rs.close();
					//rs = null;
					//pstmt.close();
					//pstmt = null;
					System.out.println("@@@@@@@@ locCodeTo : (loc_code_dock) = ::"+locCodeTo);						
					//    added by cpatil for loaction on 12-Jun-12 end


					sql = "SELECT QTY_PER_ART FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? ";
					pstmtStock = conn.prepareStatement( sql );

					sql = "SELECT LINE_NO, PICK_ORDER, LINE_NO__ORD,NO_ART, LOC_CODE, LOT_NO, LOT_SL, CASE_LABEL, LOC_CODE__TO, LOC_CODE__SYS, CARTON_NO, QUANTITY " +
							"FROM PICK_ISS_DET WHERE TRAN_ID = ? AND PICK_ORDER = ? AND LINE_NO__ORD = ? "+
							"ORDER BY TRAN_ID, LINE_NO ";
					pstmtIss = conn.prepareStatement( sql );

					sql = "SELECT PODET.PICK_ORDER,PODET.LINE_NO,PODET.ITEM_CODE,PODET.SITE_CODE,PODET.LOC_CODE, " +
							"PODET.LOT_NO, PODET.LOT_SL, PODET.NO_ART, PODET.QUANTITY, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT, LOC_CODE__TO "+              //,PODET.LOC_CODE__TO 
							"FROM PICK_ORD_DET PODET, ITEM ITEM WHERE PODET.PICK_ORDER = ? AND PODET.ITEM_CODE = ITEM.ITEM_CODE " +
							"ORDER BY PODET.LOC_CODE ";
					pstmtOrd = conn.prepareStatement( sql );
					pstmtOrd.setString( 1, pickOrder );
					rsOrd = pstmtOrd.executeQuery();

					int noArtCnt = 0;
					double pendNoArt = 0d;
					double perCaseQty = 0d;
					double issQty = 0d;//Gulzar on 12/26/2011
					int noOfArt = 0;
					String lineOrdStr = "";

					count = 0; //change added by deepak - 25/11/11
					ArrayList issDetSelList = new ArrayList();//Gulzar on 12/14/2011
					String keyStr = "";

					while ( rsOrd.next() )
					{
						pendNoArt = 0d;
						noArtPickIss = 0d;
						lineNoOrd = rsOrd.getInt("LINE_NO");
						itemCode = checkNullAndTrim(rsOrd.getString("ITEM_CODE"));
						itemDescr = checkNull(rsOrd.getString("ITEM_DESCR"));
						siteCode = checkNullAndTrim(rsOrd.getString("SITE_CODE"));
						quantity = rsOrd.getDouble("QUANTITY");  // commented by cpatil
						unit = rsOrd.getString("UNIT");
						noArt = rsOrd.getDouble("NO_ART");  // commented by cpatil
						locCodeTo = rsOrd.getString("LOC_CODE__TO");
						
						qtyPerArt = Math.floor(quantity / noArt);

						//noArtCnt = (int)noArt;
						lineOrdStr = ""+lineNoOrd;

						if ( pickIssMap.get(lineOrdStr) != null )
						{
							noArtPickIss = ((Double)pickIssMap.get(lineOrdStr)).doubleValue();
							System.out.println("noArtPickIss = ["+noArtPickIss+"]");
						}

						pendNoArt = (noArt - noArtPickIss);
						System.out.println("pendNoArt = ["+pendNoArt+"]");

						//if ( tranID.trim().length() > 0 && transMode.trim().equalsIgnoreCase("E") )
						if ( tranID.trim().length() > 0 )
						{
							pstmtIss.setString( 1, tranID );
							pstmtIss.setString( 2, pickOrder );
							pstmtIss.setInt( 3, lineNoOrd );
							rsIss = pstmtIss.executeQuery();
							while ( rsIss.next() )
							{
								//domID++;//Gulzar on  12/13/2011
								lotNo = checkNullAndTrim(rsIss.getString("LOT_NO"));
								lpnNo = checkNullAndTrim(rsIss.getString("LOT_SL"));
								locCode = checkNullAndTrim(rsIss.getString("LOC_CODE"));
								caseLabel = checkNull(rsIss.getString("CASE_LABEL"));
								locCodeTo = checkNullAndTrim(rsIss.getString("LOC_CODE__TO"));
								locCodeSys = checkNull(rsIss.getString("LOC_CODE__SYS"));//changes added by deepak - 25/11/11
								cartonNo = checkNull(rsIss.getString("CARTON_NO"));//changes added by gulzar for master picking - 25/11/11
								lineNoIss = rsIss.getInt("LINE_NO");//Gulzar on 12/13/2011
								issQty = rsIss.getDouble("QUANTITY");
								noOfArt = rsIss.getInt("NO_ART");
								//domID = lineNoIss;
								//changes added by gulzar on 12/15/2011
								keyStr = domID + ":" + lineNoOrd + ":" + itemCode + ":" + siteCode + ":" + locCodeTo + ":" + lotNo + ":" + lpnNo ;
								issDetSelList.add(keyStr);
								//End changes by gulzar on 12/15/2011
								valueXmlString.append( "<Detail3 domID='"+ lineNoIss +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
								//valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
								valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12

								//valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
								//valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<line_no><![CDATA[" ).append( lineNoIss ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<pick_order><![CDATA[" ).append( pickOrder ).append( "]]></pick_order>\r\n" );
								valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( lpnNo ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<quantity><![CDATA[" ).append( issQty).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
								//valueXmlString.append( "<no_art><![CDATA[" ).append( "1" ).append( "]]></no_art>\r\n" );
								valueXmlString.append( "<no_art><![CDATA[" ).append( noOfArt).append( "]]></no_art>\r\n" );
								//valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );//change added by deepak - 25/11/11
								valueXmlString.append( "<case_label><![CDATA[" ).append( caseLabel ).append( "]]></case_label>\r\n" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
								//changes done by cpandey on 07/08/12
								valueXmlString.append( "<user_id><![CDATA[" ).append(userId).append( "]]></user_id>\r\n" );
								//end of changes cpandey on 07/08/12
								if ( "M".equalsIgnoreCase(pickType.trim()) )
								{
									valueXmlString.append( "<carton_no><![CDATA[" ).append( cartonNo ).append( "]]></carton_no>\r\n" );
								}
								valueXmlString.append("</Detail3>\r\n");

								lotNo = ""; lpnNo = ""; locCode = ""; locCodeTo = ""; locCodeSys = ""; cartonNo = ""; issQty = 0d;
							}
							rsIss.close(); rsIss = null;
						}
					}
					rsOrd.close(); rsOrd = null;
					pstmtOrd.close(); pstmtOrd = null;
					pstmtIss.close(); pstmtIss = null;

					sql = "SELECT PODET.PICK_ORDER,PODET.LINE_NO,PODET.ITEM_CODE,PODET.SITE_CODE,PODET.LOC_CODE,"+
							" PODET.LOT_NO, PODET.LOT_SL, PODET.NO_ART, PODET.QUANTITY, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT, LOC_CODE__TO "+ 
							" FROM PICK_ORD_DET PODET, ITEM ITEM WHERE PODET.PICK_ORDER = ? AND PODET.ITEM_CODE = ITEM.ITEM_CODE "+
							" AND PODET.LINE_NO NOT IN (SELECT PICK_ISS_DET.LINE_NO__ORD FROM PICK_ISS_DET WHERE PICK_ISS_DET.PICK_ORDER =  ? ) "+
							"	ORDER BY PODET.LOC_CODE ";
					pstmtOrd = conn.prepareStatement( sql );
					pstmtOrd.setString( 1, pickOrder );
					pstmtOrd.setString(2 , pickOrder );
					rsOrd = pstmtOrd.executeQuery();
					while ( rsOrd.next() )
					{
						pendNoArt = 0d;
						noArtPickIss = 0d;
						lineNoOrd = rsOrd.getInt("LINE_NO");
						itemCode = checkNullAndTrim(rsOrd.getString("ITEM_CODE"));
						itemDescr = checkNull(rsOrd.getString("ITEM_DESCR"));
						siteCode = checkNullAndTrim(rsOrd.getString("SITE_CODE"));
						quantity = rsOrd.getDouble("QUANTITY");  // commented by cpatil
						unit = rsOrd.getString("UNIT");
						noArt = rsOrd.getDouble("NO_ART");  // commented by cpatil
						locCodeTo = rsOrd.getString("LOC_CODE__TO");

						qtyPerArt = Math.floor(quantity / noArt);

						//noArtCnt = (int)noArt;
						lineOrdStr = ""+lineNoOrd;

						if ( pickIssMap.get(lineOrdStr) != null )
						{
							noArtPickIss = ((Double)pickIssMap.get(lineOrdStr)).doubleValue();
							System.out.println("noArtPickIss = ["+noArtPickIss+"]");
						}

						pendNoArt = (noArt - noArtPickIss);
						System.out.println("pendNoArt = ["+pendNoArt+"]");


						//	if ( ("C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) ) && pendNoArt > 0 )//Spliting in case of "Case" pick        // commented by cpatil
						if ( "M".equalsIgnoreCase(CasePickOption.trim()))       // added by cpatil 15/jun/12 start
						{
							perCaseQty = ( quantity / noArt );
							//String selectedDomStr = getSelectedDom( allFormDataDom, keyStr, domID );
							// commented by cpatil
							for ( int i = 1; i <= pendNoArt; i++ )
							{
								domID++;
								locCode = checkNullAndTrim(rsOrd.getString("LOC_CODE"));
								lotNo = checkNullAndTrim(rsOrd.getString("LOT_NO"));
								lpnNo = checkNullAndTrim(rsOrd.getString("LOT_SL"));

								//changed by gulzar on 21/12/11
								if ( qtyPerArt == 0 )
								{
									pstmtStock.setString( 1, itemCode );
									pstmtStock.setString( 2, siteCode );
									pstmtStock.setString( 3, locCode );
									pstmtStock.setString( 4, lotNo );
									pstmtStock.setString( 5, lpnNo );
									rsStock = pstmtStock.executeQuery();
									if ( rsStock.next() )
									{
										qtyPerArt = rsStock.getDouble("QTY_PER_ART");
									}
									rsStock.close();rsStock = null;
									pstmtStock.clearParameters();
								}
								//End changes by gulzar on 21/12/11
								valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
								valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12

								//valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<line_no><![CDATA[" ).append( domID ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<pick_order><![CDATA[" ).append( pickOrder ).append( "]]></pick_order>\r\n" );
								valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( lpnNo ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<quantity><![CDATA[" ).append( qtyPerArt ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
								valueXmlString.append( "<no_art><![CDATA[" ).append( "1" ).append( "]]></no_art>\r\n" );
								//Changes added by deepak - 25/11/11
								///--Commented by Gulzar on 5/13/2012
								//if ( locListSize > 0 && count < locListSize)
								//{
								//	valueXmlString.append("<loc_code__sys><![CDATA[").append( pickLocList.get(count) ).append("]]></loc_code__sys>\r\n");
								//}
								//else
								////	{
								///		valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( "" ).append( "]]></loc_code__sys>\r\n" );
								///		}
								///
								if ( "M".equalsIgnoreCase(pickType.trim()) )//for master picking
								{
									valueXmlString.append( "<carton_no><![CDATA[" ).append( "" ).append( "]]></carton_no>\r\n" );
								}
								//End changes made by deepak - 25/11/11
								valueXmlString.append( "<case_label><![CDATA[" ).append( "" ).append( "]]></case_label>\r\n" );
								//valueXmlString.append( "<loc_code__to><![CDATA[" ).append( "" ).append( "]]></loc_code__to>\r\n" );//Gulzar on 5/13/2012
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
								valueXmlString.append("</Detail3>\r\n");
							}
							count++;//change added by deepak - 25/11/11

						}              // commented by cpatil
						else if ( "S".equalsIgnoreCase(CasePickOption.trim()) )     // added by cpatil
						{       // commented by cpatil   15/jun/12 END
							domID++;
							locCode = checkNullAndTrim(rsOrd.getString("LOC_CODE"));
							lotNo = checkNullAndTrim(rsOrd.getString("LOT_NO"));
							lpnNo = checkNullAndTrim(rsOrd.getString("LOT_SL"));
							valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12

							//valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
							valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
							valueXmlString.append( "<line_no><![CDATA[" ).append( domID ).append( "]]></line_no>\r\n" );
							valueXmlString.append( "<pick_order><![CDATA[" ).append( pickOrder ).append( "]]></pick_order>\r\n" );
							valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
							valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
							valueXmlString.append( "<lot_sl><![CDATA[" ).append( lpnNo ).append( "]]></lot_sl>\r\n" );
							valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
							valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
							valueXmlString.append( "<loc_code__to><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
							if (!"A".equalsIgnoreCase(pickType.trim()))
							{
								valueXmlString.append( "<quantity><![CDATA[" ).append( quantity).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );	

							}
							else //if ("C".equalsIgnoreCase(pickType.trim()))
							{
								valueXmlString.append( "<no_art><![CDATA[1]]></no_art>\r\n" );	
								valueXmlString.append( "<quantity><![CDATA[" + quantity + "]]></quantity>\r\n" );
							}
							//Changes added by deepak - 25/11/11
							/*
								if ( locListSize > 0 )
								{
									valueXmlString.append("<loc_code__sys><![CDATA[").append( pickLocList.get(0) ).append("]]></loc_code__sys>\r\n");
								}
							 */
							//End changes made by deepak - 25/11/11
							valueXmlString.append( "<case_label><![CDATA[" ).append( "" ).append( "]]></case_label>\r\n" );
							//valueXmlString.append( "<loc_code__to><![CDATA[" ).append( "" ).append( "]]></loc_code__to>\r\n" );//Gulzar on 5/13/2012
							//valueXmlString.append( "<loc_code__to protect = '1'><![CDATA[" ).append( intrLocCode ).append( "]]></loc_code__to>\r\n" );//Gulzar on 5/13/2012

							//valueXmlString.append( "<loc_code__to protect = '1'><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
							valueXmlString.append("</Detail3>\r\n");
						}
						//pstmtIss.clearParameters();
					}
					rsOrd.close(); rsOrd = null;
					pstmtOrd.close(); pstmtOrd = null;
					//pstmtIss.close(); pstmtIss = null;
					if ( pstmtStock != null )
					{
						pstmtStock.close();
						pstmtStock = null;
					}
					///////////
					String updatedDetailDomStr = setSelectedToDom( allFormDataDom, valueXmlString.toString(), issDetSelList );

					valueXmlString = null;
					valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
					valueXmlString.append("</editFlag>\r\n</Header>\r\n");
					updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
					valueXmlString.append(updatedDetailDomStr);

					System.out.println("\n**************************\n");
					System.out.println("updatedDetailDomStr[1]:>>>>>>>>>>> "+updatedDetailDomStr);

					///////////
				}

			} //Case 3. End
			break;
			case 4:
			{
				//changes done by cpandey on 27/08/12
				pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2"));
				System.out.println(" pickType--:["+pickType+"]");
				//				pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));
				//				sql = "SELECT PICK_TYPE FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
				//				pstmt = conn.prepareStatement( sql );
				//				pstmt.setString( 1, pickOrder );
				//				rs = pstmt.executeQuery();	
				//				if( rs.next() )
				//				{
				//					pickType = checkNull(rs.getString("PICK_TYPE"));
				//				}
				//				rs.close();rs = null;
				//				pstmt.close();pstmt = null;
				if (!("A".equalsIgnoreCase(pickType.trim()) ))//Active pick
				{

					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
					{
						locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "3" ));
						pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));

						sql="select t.loc_code__dock from transporter t, despatch d "
								+ " where t.tran_code = d.tran_code "
								+ " and d.desp_id in ( "
								+ " select wt.ref_id from wave_task_det wt where wt.ref_ser = 'S-DSP' and wt.ptcn in (select i.ptcn from wave_task_det i "
								+ " where i.ref_id = ? ) )  ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							docLocCode = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println(" locCodeTo [" + locCodeTo + "] docLocCode [" + docLocCode + "]");

						valueXmlString.append( "<Detail4 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
						//valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
						valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
						valueXmlString.append( "<loc_code__to><![CDATA[]]></loc_code__to>\r\n" );
						valueXmlString.append("</Detail4>\r\n");

					}
				} //end of changes by cpandey 27/08/12				
			}//Case 4. End
			}//End of switch block
			valueXmlString.append( "</Root>\r\n" );	 // 28/08/12 manoharan taken from above end of case 4
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			//throw new ITMException(e);//Gulzar on 09/12/11
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{	
			try
			{
				if ( rsOrd != null )
				{
					rsOrd.close();
					rsOrd = null;
				}
				if ( rsIss != null )
				{
					rsIss.close();
					rsIss = null;
				}
				if ( pstmtOrd != null )
				{
					pstmtOrd.close();
					pstmtOrd = null;
				}
				if ( pstmtIss != null )
				{
					pstmtIss.close();
					pstmtIss = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private String getSiteCode( String xtraParams, Connection conn ) throws ITMException
	{
		String defaultSite = "";
		String empSite = "";
		String workSite = "";
		String sql = "";
		String loginCode = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			sql = "SELECT USERS.EMP_CODE, USERS.ENTITY_CODE, USERS.SITE_CODE__DEF, EMP.EMP_SITE, EMP.WORK_SITE "+
					"FROM USERS USERS, EMPLOYEE EMP WHERE USERS.EMP_CODE = EMP.EMP_CODE AND USERS.CODE = ? ";
			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, loginCode );						
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				defaultSite = checkNull(rs.getString("SITE_CODE__DEF"));
				empSite = checkNull(rs.getString("EMP_SITE"));
				workSite = checkNull(rs.getString("WORK_SITE"));
			}
			if ( defaultSite.trim().length() == 0 && empSite.trim().length() > 0 )
			{
				defaultSite = empSite;
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("defaultSite = ["+defaultSite+"]");
		return defaultSite;
	}
	//Method written to get the obj_name from the dom - Gulzar - 28/11/11
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	//End changes by gulzar - 28/11/11
	//method added by gulzar on 09/12/11 to get the error string
	public String generateErrorString( String errorString )
	{
		return ("<Errors><error id = \"xxxx\" type=\"E\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect><type>E</type></error></Errors>");
	}
	//changed by gulzar on 09/12/11 to get the seleted attribute value
	private String setSelectedToDom( Document allFormDataDom, String detailString, ArrayList issDetSelList ) throws Exception
	{
		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String caseLabel = "";
		String locCodeTo = "";
		String cartonNo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;

		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail3");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();

				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("case_label"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							caseLabel = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 0, childNode );
							dataMap.put("case_label", childNode);
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_code__to"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							locCodeTo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 1, childNode );
							dataMap.put("loc_code__to", childNode);
						}
					}
					else if (nodeName.equalsIgnoreCase("carton_no"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							cartonNo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 2, childNode );
							dataMap.put("carton_no", childNode);
						}
					}
				}//End of inner for loop
				if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				{
					if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
					{
						domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
						System.out.println("domIDVal =["+domIDVal+"]");
					}
					toUpdateMap.put( domIDVal, dataMap );
				}
			}//End of for loop

			System.out.println("toUpdateMap:>>>>>>>>>>>: "+toUpdateMap);

			detailList = null;

			detailString = detailString + "</Root>\r\n" ;	
			System.out.println("detailString:>>>>>>>>>>> "+detailString);
			Document detailDom = genericUtility.parseString(detailString); 

			Element elementAttr = null;

			detailList = detailDom.getElementsByTagName("Detail3");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);

				if ( currDetail.getAttributes().getNamedItem( "selected" ) != null )
				{
					selectedVal = checkNull(currDetail.getAttributes().getNamedItem( "selected" ).getNodeValue());
					System.out.println("selectedVal =["+selectedVal+"]");
					if ( "N".equalsIgnoreCase(selectedVal.trim()) )
					{
						if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
						{
							//ArrayList aList = null;

							HashMap dataMap = new HashMap();

							domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
							System.out.println("domIDVal =["+domIDVal+"]");
							System.out.println("toUpdateMap.containsKey(domIDVal) =["+toUpdateMap.containsKey(domIDVal)+"]");
							if ( toUpdateMap.containsKey(domIDVal) )
							{
								elementAttr = (Element)currDetail;
								elementAttr.setAttribute( "selected" , "Y" );

								Node caseLabelNode = null;
								Node locCodeToNode = null;
								Node cartonNoNode = null;

								dataMap = (HashMap)toUpdateMap.get(domIDVal);

								if ( dataMap.get("case_label") != null )
								{
									caseLabelNode = (Node)dataMap.get("case_label");
								}
								if ( dataMap.get("loc_code__to") != null )
								{
									locCodeToNode = (Node)dataMap.get("loc_code__to");
								}
								if ( dataMap.get("carton_no") != null )
								{
									cartonNoNode = (Node)dataMap.get("carton_no");
								}

								Node updatedNode = null;

								currDetailList = currDetail.getChildNodes();
								currDetailListLength = currDetailList.getLength();

								for ( int i = 0; i < currDetailListLength; i++ )
								{
									elementName = currDetailList.item(i);
									nodeName = elementName.getNodeName();
									if( elementName.getNodeType() != Node.ELEMENT_NODE || nodeName.equalsIgnoreCase("#text") )
									{
										continue;
									}
									System.out.println("nodeName =["+nodeName+"]");
									if (nodeName.equalsIgnoreCase("case_label"))
									{
										//System.out.println("caseLabelNode =["+genericUtility.serializeDom( caseLabelNode )+"]");
										updatedNode = detailDom.importNode(caseLabelNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
									}
									else if ( nodeName.equalsIgnoreCase("loc_code__to") )
									{
										//System.out.println("LocCodeToNode =["+genericUtility.serializeDom( LocCodeToNode )+"]");
										updatedNode = detailDom.importNode(locCodeToNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
									}
									else if ( nodeName.equalsIgnoreCase("carton_no") )
									{
										//System.out.println("cartonNoNode =["+genericUtility.serializeDom( cartonNoNode )+"]");
										updatedNode = detailDom.importNode(cartonNoNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
									}
								}//inner for loop
							}//if ( toUpdateMap.containsKey(domIDVal) )
						}//if ( currDetail.getAttributes().getNamedItem( "domID" )
					}//if ( "N".equalsIgnoreCase(selectedVal.trim()) )
				}//if ( currDetail.getAttributes().getNamedItem( "selected" )
			}//outer for loop
			updatedDetailDomStr = genericUtility.serializeDom( detailDom );
			System.out.println("updatedDetailDomStr:>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw e;
		}

		return updatedDetailDomStr;
	}
}