/**
 * PURPOSE : Validation For Pallat Number and locatin 
 * AUTHOR : chitranjan pandey 
 * DATE : 01/08/12
 */
package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@javax.ejb.Stateless
public class PalletNoIC extends ValidatorEJB implements PalletNoICLocal, PalletNoICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		String pickOrder = "";
		String columnValue = "";			
		String errString = "";
		String lpnNo = "";
		String itemCode = "";
		String siteCode = "";		
		String lotNo = "";
		String locCodeTo = "";
		String confirmed = "";
		String singleLotSl = "";
		String itemLotOpt = "";
		String pickType = "";
		String sql = "";
		String replOrder =  "",ptcn = "";//Gulzar - 1/12/2012
		String childNodeName = "";
		String palletNoDom = "";
		String palletNoDb = "",trfStatus = "N"	;


		int count = 0, cnt = 0;
		int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;
		int lineNoOrd = 0;

		double quantity = 0.0;

		GenericUtility genericUtility = GenericUtility.getInstance();

		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtLoc = null;
		PreparedStatement pstmtStock = null;
		PreparedStatement pstmtLoc1 = null;
		PreparedStatement pstmtStock1 = null;
		PreparedStatement pstmtStock3 = null;

		ResultSet rs = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "", docLocCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		try
		{	
			int currentFormNo = 0;				
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );
			connDriver = null;

			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();
			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");

					if ( "pallet_no".equalsIgnoreCase( childNodeName ) )   // && ! "master_pick".equalsIgnoreCase(objName) )
					{
						if ( childNode.getFirstChild() == null)
						{
							errList.add( "NULLPLTNO1" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else 
						{

							palletNoDom = checkNull(genericUtility.getColumnValue( "pallet_no", currFormDataDom ));
							//pickOrder = checkNull(genericUtility.getColumnValue( "pick_order", currFormDataDom ));
							//VALIDATIN FOR PALLET_NO FROM PALLET NO TABLE WITH ACTIVE STATUS   
							sql="SELECT COUNT(1) FROM PALLET_NO WHERE PALLET_NO = ? AND STATUS = 'A'";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, palletNoDom.trim());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt=rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errList.add( "INVPLTNO1" );
								errFields.add( childNodeName.toLowerCase() );
							}
							//validation of pallat_no from PICK_ISS_HDR 
							// 14/09/12 manoharan new trf_status to be maintained
							//sql = "SELECT COUNT(1) FROM PICK_ISS_HDR WHERE PALLET_NO = ? AND PICK_TYPE = 'A'";
							sql = "SELECT CASE WHEN TRF_STATUS IS NULL THEN 'N' ELSE TRF_STATUS END AS TRF_STATUS FROM PICK_ISS_HDR WHERE PALLET_NO = ? AND PICK_TYPE = 'A'";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, palletNoDom.trim());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								//cnt=rs.getInt(1);
								trfStatus = rs.getString("TRF_STATUS");
							}
							//if(cnt == 0)
							else
							{
								errList.add( "INVPLTNO2" );
								errFields.add( childNodeName.toLowerCase() );
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if ("Y".equals(trfStatus))
							{
								errList.add( "VTPLTTRF" );
								errFields.add( childNodeName.toLowerCase() );
							}

						}
					}

				}//end of for loop of child node
			} //End of case 1 Validation
			break;
			case 2:
			{
				//for single item_code and multiple lot_no
				//checking for correct picking location
				sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
						"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
						"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
				pstmtLoc1 = conn.prepareStatement( sql );

				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = checkNull(childNode.getFirstChild().getNodeValue());
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
					{								
						itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3" ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "3" ));
						locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, objContext ));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "3" ));
						lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "3" ));
						pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));
						docLocCode = checkNull(genericUtility.getColumnValue("loc_code__sys", allFormDataDom, objContext ));
						sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
						pstmtLoc = conn.prepareStatement( sql );
						pstmtLoc.setString( 1, locCodeTo );
						rs = pstmtLoc.executeQuery();
						if( rs.next() )
						{
							singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
							itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
						}
						else
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
							//break;
							errList.add( "INVLOCCODE" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						pstmtLoc.clearParameters();
						rs.close(); rs = null;

						pickType = checkNull(genericUtility.getColumnValue("pick_type", allFormDataDom, "2" ));
						String varName = "";
						if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
						{
							varName = "ACTIVE_PICK_INVSTAT";
						}
//						else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick
//						{
//							varName = "CASE_PICK_INVSTAT";
//						}
						DistCommon distComm = new DistCommon();

						String disparmVal = distComm.getDisparams( "999999", varName, conn );
						System.out.println(" disparmVal =[" + disparmVal + "]");

						count = 0;

						if(singleLotSl.trim().equalsIgnoreCase("Y") )
						{
							sql = "SELECT QUANTITY FROM STOCK WHERE  SITE_CODE = ? AND LOC_CODE = ? ";
							pstmtStock = conn.prepareStatement( sql );
							pstmtStock.setString( 1, siteCode );
							pstmtStock.setString( 2, locCodeTo );
							rs = pstmtStock.executeQuery();	
							if( rs.next() )
							{
								quantity = rs.getDouble("QUANTITY");
							}
							pstmtStock.clearParameters();
							rs.close(); rs = null;

							if( quantity != 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "loc_code__to", "VTLOCCODE1", userId );
								//break;
								errList.add( "VTLOCCODE1" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						}
						else
						{
							if( itemLotOpt.trim().equals("0") )  // Validation for single item_code and single lot_no
							{
								sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
								pstmtStock1 = conn.prepareStatement( sql );
								pstmtStock1.setString( 1, itemCode );
								pstmtStock1.setString( 2, siteCode );
								pstmtStock1.setString( 3, locCodeTo );
								pstmtStock1.setString( 4, lotNo );
								rs = pstmtStock1.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtStock1.clearParameters();
								rs.close(); rs = null;

								if( count > 0 )
								{
									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									//errString = getErrorString("loc_code__to", "VTLOCCODE2", userId );
									//break;
									errList.add( "VTLOCCODE2" );
									errFields.add( childNodeName.toLowerCase() );
									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								}
							}
							else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code and multiple lot_no
							{
								sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
								pstmtStock3 = conn.prepareStatement( sql );

								pstmtStock3.setString( 1, itemCode );
								pstmtStock3.setString( 2, siteCode );
								pstmtStock3.setString( 3, locCodeTo );
								pstmtStock3.setString( 4, lotNo );
								rs = pstmtStock3.executeQuery();
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								pstmtStock3.clearParameters();
								rs.close(); rs = null;

								if( count > 0 )
								{
									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									//errString = getErrorString("loc_code__to", "VTLOCCODE4", userId );
									//break;
									errList.add( "VTLOCCODE4" );
									errFields.add( childNodeName.toLowerCase() );
									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								}
							}//itemLotOpt = '1'
						}//singleLotSl != 'Y'
					}//loc_code__to case
					// added by cpatil for validate quantity on 10-Jun-12  end	
				}			

			}

			}//End of switch statement
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: PickIssIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			//throw new ITMException(e);
			e.printStackTrace();
			errString = generateErrorString( genericUtility.createErrorString( e ) ) ;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				
				if (pstmt!=null)
				{
					pstmt.close(); 
					pstmt = null;
				}
				if( conn != null  )
				{
					conn.close(); 
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PickIssIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	//if required item change methode for 
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :PickIssIC :itemChanged(String,String):" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println ( "returning from PickIssIC itemChanged \n[" + errString + "]" );

		return errString;
	}
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{		
		String retString = "";		
		String pickOrder = "";
		String sql = "";
		String locCodeTo = "";
		String objName = "";
		String stockSql = "",docLocCode = "";
		String stagingLoc="";
		String columnValue = "";

		int currentFormNo = 0;
		int domID = 0;
		int noOfParent = 0;

		double quantity = 0;
		double noArt = 0;
		double qtyPerArt = 0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtOrd = null;
		PreparedStatement pstmtIss = null;
		PreparedStatement pstmtStock = null;

		ResultSet rs = null ;
		ResultSet rsOrd = null ;
		ResultSet rsIss = null ;
		ResultSet rsStock = null ;
		ArrayList pickLocList = null;
		String childNodeName = "";

		StringBuffer valueXmlString;

		System.out.println("xtraParams=["+xtraParams+"]");
		DistCommon distCommon = new DistCommon();

		GenericUtility genericUtility = GenericUtility.getInstance();

		//String objName = checkNullAndTrim(getObjNameFromDom( currFormDataDom, "objName", objContext ));
		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );

		try
		{

			String palletNo = "";
			//			stagingLoc = distCommon.getDisparams( "999999", "STAGING_LOC", conn );

			//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );


			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );	
			connDriver = null;


			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//valueXmlString.append( "<trans_mode><![CDATA[" ).append( "E" ).append( "]]></trans_mode>\r\n" );
				}
				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:
			{

				//ADDITION FOR ITEMCHANGE
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "3" ));
					//pickOrder =  checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));

					locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "1" ));
					palletNo =  checkNull(genericUtility.getColumnValue("pallet_no", allFormDataDom, "1" ));
					System.out.println("pallet no  -----["+palletNo+"]");
					System.out.println("location to "+locCodeTo);

					sql = "SELECT PICK_ORDER FROM PICK_ISS_HDR HDR WHERE HDR.PALLET_NO = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, palletNo );
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						pickOrder = rs.getString("PICK_ORDER");
						System.out.println("PICK_ORDER -----["+pickOrder+"]");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					sql = "SELECT LOC_CODE__TO FROM PICK_ISS_DET DET,PICK_ISS_HDR HDR WHERE HDR.PICK_ORDER = DET.PICK_ORDER AND HDR.PICK_ORDER = ?";

					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, pickOrder );
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						docLocCode = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println(" locCodeTo [" + locCodeTo + "] docLocCode [" + docLocCode + "]");

					valueXmlString.append( "<Detail2 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
					//valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
					valueXmlString.append( "<loc_code__sys protect = '1'><![CDATA[" ).append(docLocCode).append( "]]></loc_code__sys>\r\n" );
					valueXmlString.append( "<loc_code__to><![CDATA[]]></loc_code__to>\r\n" );
					valueXmlString.append("</Detail2>\r\n");
				}


			}//End of case 2

			}
			valueXmlString.append( "</Root>\r\n" );	
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);//Gulzar on 09/12/11
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{	
			try
			{
				if ( rsOrd != null )
				{
					rsOrd.close();
					rsOrd = null;
				}
				if ( rsIss != null )
				{
					rsIss.close();
					rsIss = null;
				}
				if ( pstmtOrd != null )
				{
					pstmtOrd.close();
					pstmtOrd = null;
				}
				if ( pstmtIss != null )
				{
					pstmtIss.close();
					pstmtIss = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}




	/**
	 * The public method is defined without any parameters and returns blank string
	 */

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	//End changes by gulzar - 28/11/11
	//method added by gulzar on 09/12/11 to get the error string
	public String generateErrorString( String errorString )
	{
		return ("<Errors><error id = \"xxxx\" type=\"E\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect><type>E</type></error></Errors>");
	}

}
