/*
 * PalletMergePos.java
 * Developer - Mahesh Patidar
 * Date - 21/08/12 
 */

package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.w3c.dom.Document;

@javax.ejb.Stateless
public class PalletMergePos extends ValidatorEJB implements PalletMergePosLocal, PalletMergePosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String domString, String tranId,String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String errString = "";
		String  sSQL="";
		String palletNo = "";
		String palletNoNew = "";
		Document dom = null;
		PreparedStatement pstmt = null;		
        ResultSet rs = null;
		
        try
		{
			conn.setAutoCommit(false);
			GenericUtility genericUtility = GenericUtility.getInstance();
			System.out.println("STRING{"+domString+"}");
			dom = genericUtility.parseString(domString); 
			palletNo = genericUtility.getColumnValueFromNode("pallet_no", dom.getElementsByTagName("Detail1").item(0));
			palletNoNew = genericUtility.getColumnValueFromNode("pallet_no__new", dom.getElementsByTagName("Detail2").item(0));
			System.out.println("PALLET NO["+palletNo+"] NEW PALLET NO["+palletNoNew+"]");
			
			sSQL = "UPDATE DESPATCHDET SET PALLET_NO = ?  WHERE PALLET_NO = ? ";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1, palletNoNew);
			pstmt.setString(2, palletNo);
			pstmt.executeUpdate();	
			pstmt.close();
			pstmt = null;
			
			sSQL = "UPDATE PICK_ISS_HDR SET PALLET_NO = ?  WHERE PALLET_NO = ? ";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1, palletNoNew);
			pstmt.setString(2, palletNo);
			pstmt.executeUpdate();	
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			try
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{				
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	
	
}


