/**
* PURPOSE : EJB component CartonNoGenIC for carton no generation
* AUTHOR : Changed By Chaitali On 25/11/2011 
*/

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;

@javax.ejb.Stateless
public class CartonNoGenIC extends ValidatorEJB implements CartonNoGenICLocal, CartonNoGenICRemote
{
	/**
	* The method defined with no paramter and returns nothing
	*/
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}//end of wfVAlData

	/**
	 * The public method is used for validation of required fields which inturn called overloded method
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr contains always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}//end of try
		catch(Exception e)
		{
			System.out.println ( "Exception:CartonNoGenIC: wfValData(): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch
		
		System.out.println ( "Returning from EJB wfValData" );
		return ( errString );
	}//end of wfvalData() of xml string

	/**
	* The public overloded method is used for validation of required fields
	* Returns validation string if exist otherwise returns null in XML format
	* @param currDom contains the current form data
	* @param hdrDom contains always header form data
	* @param allDom contains all forms data
	* @param objContext represents form no
	* @param editFlag the mode of the transaction(A-Add or E-Edit)
	* @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	*/

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		ResultSet rSet = null;
		Connection connObject = null;
		PreparedStatement pstmt = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connObject = connDriver.getConnectDB("DriverValidator");

			NodeList parentList = null;
			NodeList childList = null;
			int noOfChilds = 0;
			String childNodeName = "";
			Node childNode =null;

			boolean isNumber = true;

			String userID = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "LoginCode" );
	
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				if ( "no_of_cartons".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)//checking for null no_of_cartons
					{
					   errString = getErrorString("no_of_cartons","INVCRTN",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("no_of_cartons","NOTANUMBR1",userID);
							break;
						}
					}

				}
				//ADDED BY MAHESH PATIDAR ON 05/06/12
				if ( "no_of_pallet".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)//checking for null no_of_cartons
					{
					   errString = getErrorString("no_of_pallet","VTPNOEMPTY",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("no_of_pallet","NOTANUMBR1",userID);
							break;
						}
					}

				}
				//ENDED BY MAHESH PATIDAR
			}
		}

		catch(Exception e)
		{
			System.out.println("Exception in CartonNoGenIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();
					connObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :CartonNoGenIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}//end of catch
		} //end of finally
		return (errString);
	}

	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++) 
		{
			if( !Character.isDigit(cArray[i]) ) 
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}
