/**
	* @author : Chandni Shah 
	* @Version : 1.0
	* Date : 30/06/11
*/

package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import javax.ejb.Stateless;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.text.SimpleDateFormat;
import java.util.*;
import ibase.webitm.ejb.sys.UtilMethods;
@Stateless

public class JvConfirm  extends ActionHandlerEJB implements JvConfirmLocal,JvConfirmRemote //SessionBean
{
	public String confirm(String tranId,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        ConnDriver connDriver = null;
		
		String confirm = "";
		String errString = "" ; 
		
		ITMDBAccessEJB itmDBAccessEJB = null;
		try
		{
            itmDBAccessEJB = new ITMDBAccessEJB();
			connDriver = new ConnDriver();
            conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
            conn.setAutoCommit(false);
			
			sql = "select confirmed,site_code from journal where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
            rs = pstmt.executeQuery();
            if(rs.next())
			{
                confirm = rs.getString("confirmed");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(confirm != null  && "Y".equalsIgnoreCase(confirm))
			{
                System.out.println("The Selected transaction is already confirmed");
                errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
                return errString;
            }
			else
			{
				errString = this.gbfRetrieveJournal(tranId,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
		} //end of try
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("CONFSUCCES") > -1)
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	} //end of confirm method
	// gbf_retrieve_journal start
	private	String gbfRetrieveJournal(String tranId,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		ConnDriver connDriver = null;
		String errString = "" ; 
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		HashMap journalMap = null,jourdetMap = null;
		ArrayList jourdetList = new ArrayList();
		double amountDetDr = 0 , amountDetCr = 0 ;
		String tranType = "",siteCode= "",finEntity = "",refSer="",refNo="",reversible="";
		String autoRev="",drAmt="",crAmt="",currCode= "",status = "",remarks = "",confirmed = "";
		String empCodeAprv="",siteCodeRev="",projCode="",refLineNo="";
		String linkType ="",siteCodeFor="",loginEmpCode = "";
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp effDate = null;
		java.sql.Timestamp revDate = null;
		java.sql.Timestamp revDateAct = null;
		java.sql.Timestamp confDate = null;
		double amt = 0,exchRate=0;
		String lineNo = "" ,acctCode = "",cctrCode ="",drcrFlag ="",remarksDet = "";
		String amount = "" ,empCode="" , analCode = "",sundryType = "",sundryCode = "",projCodeDet = "";
		int cnt = 0;
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			UtilMethods utilMethods=UtilMethods.getInstance();
			loginEmpCode = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("loginEmpCode :: ::: "+loginEmpCode);
			
			if(loginEmpCode == null || loginEmpCode.trim().length() == 0)
			{
				System.out.println("loginEmpCode is null");		
				//populateerror(9999,'populateerror')	
				errString = itmDBAccessEJB.getErrorString("","EMPAPRV","","",conn);
				return errString;
			}
			//edit-start
			sql = " select j.tran_type, j.tran_date,j.eff_date,j.site_code, "
				+" j.fin_entity,j.ref_ser,j.ref_no,j.reversible,j.rev_date,j.auto_rev, " 
				+" j.rev_date__act ,j.dr_amt ,j.cr_amt ,j.curr_code ,j.status ,j.remarks ,"
				+" j.confirmed ,j.conf_date ,j.emp_code__aprv ,j.exch_rate ,j.site_code__rev ,"
				+" j.proj_code , j.ref_line_no ,j.link_type , j.site_code__for"
				+" from journal j  "
				+" where j.tran_id =? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranType = rs.getString("tran_type");
				tranDate = rs.getTimestamp("tran_date");
				effDate = rs.getTimestamp("eff_date");
				siteCode = rs.getString("site_code");
				finEntity = rs.getString("fin_entity");
				refSer = rs.getString("ref_ser");
				refNo = rs.getString("ref_no");
				reversible = rs.getString("reversible");
				revDate = rs.getTimestamp("rev_date");
				autoRev = rs.getString("auto_rev");
				revDateAct = rs.getTimestamp("rev_date__act");
				drAmt = rs.getString("dr_amt");
				crAmt = rs.getString("cr_amt");
				currCode = rs.getString("curr_code");
				status = rs.getString("status");
				remarks = rs.getString("remarks");
				confirmed = rs.getString("confirmed");
				confDate = rs.getTimestamp("conf_date");
				empCodeAprv = rs.getString("emp_code__aprv");
				//exchRate = rs.getString("exch_rate");
				exchRate = rs.getDouble("exch_rate");
				siteCodeRev = rs.getString("site_code__rev");
				projCode = rs.getString("proj_code");
				refLineNo = rs.getString("ref_line_no");
				linkType = rs.getString("link_type");
				siteCodeFor = rs.getString("site_code__for");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			journalMap = new HashMap();
			journalMap.put("tran_type",tranType);
			journalMap.put("tran_date",tranDate);
			journalMap.put("eff_date",effDate);
			journalMap.put("site_code",siteCode);
			journalMap.put("fin_entity",finEntity);
			journalMap.put("ref_ser",refSer);
			journalMap.put("ref_no",refNo);
			journalMap.put("reversible",reversible);
			journalMap.put("rev_date",revDate);
			journalMap.put("auto_rev",autoRev);
			journalMap.put("rev_date__act",revDateAct);
			journalMap.put("dr_amt",drAmt);
			journalMap.put("cr_amt",crAmt);
			journalMap.put("curr_code",currCode);
			journalMap.put("status",status);
			journalMap.put("remarks",remarks);
			journalMap.put("confirmed",confirmed);
			journalMap.put("conf_date",confDate);
			journalMap.put("emp_code__aprv",empCodeAprv);
			journalMap.put("exch_rate",exchRate);
			journalMap.put("site_code__rev",siteCodeRev);
			journalMap.put("proj_code",projCode);
			journalMap.put("ref_line_no",refLineNo);
			journalMap.put("link_type",linkType);
			journalMap.put("site_code__for",siteCodeFor);
			//edit-end
			
			//brow-start
			sql = "select  j.line_no ,j.acct_code ,j.cctr_code ,j.drcr_flag , "
				+" j.amount ,j.emp_code ,j.anal_code ,j.sundry_type ,j.sundry_code,j.remarks, " 
				+" j.proj_code,j.site_code__jv "
				+" from  jourdet j "
				+" where j.tran_id = ?  "
				+" order by  line_no  asc   "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
				
			while (rs.next())
			{
				lineNo = rs.getString("line_no"); 
				acctCode = rs.getString("acct_code");
				cctrCode = rs.getString("cctr_code");
				drcrFlag = rs.getString("drcr_flag");
				amount = rs.getString("amount");
				empCode = rs.getString("emp_code");
				analCode = rs.getString("anal_code");
				sundryType = rs.getString("sundry_type");
				sundryCode = rs.getString("sundry_code");
				remarksDet = rs.getString("remarks");
				projCodeDet = rs.getString("proj_code");
				
				String siteCodeJv = ""; 
				siteCodeJv = rs.getString("site_code__jv");

				amt = Double.parseDouble (amount);
				System.out.println("amount :::"+amt);
				
				if ("D".equalsIgnoreCase (drcrFlag))
				{
					amountDetDr = amountDetDr + amt ;
				}
				else
				{
					amountDetCr = amountDetCr + amt ;
				}
				jourdetMap = new HashMap();
				jourdetMap.put("line_no",lineNo);
				jourdetMap.put("acct_code",acctCode);
				jourdetMap.put("cctr_code",cctrCode);
				jourdetMap.put("drcr_flag",drcrFlag);
				jourdetMap.put("amount",amount);
				jourdetMap.put("emp_code",empCode);
				jourdetMap.put("anal_code",analCode);
				jourdetMap.put("sundry_type",sundryType);
				jourdetMap.put("sundry_code",sundryCode);
				jourdetMap.put("remarks",remarksDet);
				jourdetMap.put("proj_code",projCodeDet);
				//
				jourdetMap.put("site_code__jv",siteCodeJv);
				//
				jourdetList.add(jourdetMap);
				
			}	
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//Commented By Manoj dtd 30042012 for Rounding Values Req Id FI2AALL001
			amountDetDr=Double.parseDouble(utilMethods.getReqDecString(amountDetDr,3));
			amountDetCr=Double.parseDouble(utilMethods.getReqDecString(amountDetCr,3));
			System.out.println("amountDetDr :::"+amountDetDr);
			System.out.println("amountDetCr :::"+amountDetCr);
			//brow-end
			
			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " select tran_id  from journal where tran_id = ? for update ";
			}
			
			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " select tran_id from journal (updlock) where tran_id = ? " ;
			}
			else
			{
				sql = " select tran_id from journal where tran_id = ? for update nowait " ;
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//if (amountDetDr.equalsIgnoreCase(amountDetCr))
			if (Math.abs(amountDetDr - amountDetCr) == 0 )
			{
				sql =" select Count(1) from jourdet "
					+" where tran_id =  ?  and site_code__jv is not null";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt =  rs.getInt(1);
					if(cnt == 0) 
					{
						System.out.println("call for normal site");
						errString = this.gbfPostJournal(tranId,journalMap, jourdetList, xtraParams, conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}	
					else
					{
						System.out.println("call for other site");
						errString = this.otherSitePostJournal( tranId,journalMap, jourdetList, xtraParams, conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTVCONF1","","",conn);
				return errString;
			}
			journalMap.clear();
			jourdetMap.clear();
			return errString ;
		}//end of try
		catch(ITMException ie)
		{
			errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
			System.out.println("Returnng String From gbfRetrieveJournal :"+errString);
			throw new ITMException(ie);
		}
		catch(Exception e)
		{
			System.out.println("Exception in Confirm [gbfRetrieveJournal]"+e);
			try
			{
				conn.rollback();
			}
			catch(Exception t){}
			e.printStackTrace();
			errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				journalMap.clear();
				jourdetMap.clear();
				if(rs != null){rs.close();rs = null;}
				if(pstmt != null){pstmt.close();pstmt = null;}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
			}
		}
	}// end of gbf_retrieve_journal
	//gbf_post_journal - start - Normal Posting
	String gbfPostJournal(String tranId,HashMap journalMap,ArrayList jourdetList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtInsert = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String errString = "" ; 
		String sql ="",sql1 = "",sqlInsert = "";
		String xmlString ="";
		ConnDriver connDriver = null;
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ArrayList glTraceList = new ArrayList();	
		HashMap glTraceMap = null,sundryBalMap = null,detListMap = null; 
		String tranIDSer  = "";
		genericUtility = new GenericUtility();
		SimpleDateFormat sdf = null;
		FinCommon Fcommon = new FinCommon(); //FinCommon Fcommon = null;
		String thisWin = "" ,keyStr = "",refId = "",link = "",siteFr = "",siteTo = "",siteCodeRev = "";
		String revRefId = "",revRefSer = "",tranType = "",confirm = "",empCodeAprv="",siteCode="";
		String status = "",acPay = "",ccPay = "",acRcp = "",ccRcp = "",acctCode = "";
		String acct = "",IBCAAConf = "",FinEnt ="",FinEntto="",val="",siteCodeJv = "";
		String	detSundryType = "",	detSundryCode = "",detAcctCode="",detCctrCode = "",detEmpCode = "";
		String detAnalCode = "",detAmount = "",detDrcrFlag= "",detRemarks= "",detProjCode = "";
		int ctr = 0 ,ctrLine = 0, ediOption = 0;
		double amt = 0,amtDbl=0;
		java.sql.Timestamp toDay = null;
		java.sql.Timestamp revDt = null;
		StringBuffer xmlBuff = null;
		try
		{
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			itmDBAccessEJB = new ITMDBAccessEJB();
			empCodeAprv  = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("empCodeAprv : "+empCodeAprv);
			glTraceMap = new HashMap();
			for (ctr =0; ctr < jourdetList.size(); ctr++)
			{
				detListMap = new HashMap();
				detListMap = (HashMap) jourdetList.get(ctr);
				
				detSundryType = (String) detListMap.get("sundry_type");
				detSundryCode = (String) detListMap.get("sundry_code");
				detAcctCode = (String) detListMap.get("acct_code");
				detCctrCode = (String) detListMap.get("cctr_code");
				detEmpCode = (String) detListMap.get("emp_code");
				detAnalCode = (String) detListMap.get("anal_code"); 
				detAmount = (String) detListMap.get("amount"); 
				detDrcrFlag = (String) detListMap.get("drcr_flag"); 
				detRemarks = (String) detListMap.get("remarks"); 
				detProjCode = (String) detListMap.get("proj_code"); 
				amtDbl = Double.parseDouble(detAmount);
				
				glTraceMap.put("tran_date",(journalMap.get("tran_date") == null ? "":journalMap.get("tran_date")));
				glTraceMap.put("eff_date",(journalMap.get("eff_date") == null ? "":journalMap.get("eff_date")));
				glTraceMap.put("fin_entity",(journalMap.get("fin_entity") == null ? "":journalMap.get("fin_entity")));
				glTraceMap.put("site_code",(journalMap.get("site_code") == null ? "":journalMap.get("site_code")));
				glTraceMap.put("sundry_type",detSundryType == null ? "":detSundryType);
				glTraceMap.put("sundry_code",detSundryCode == null ? "":detSundryCode);
				glTraceMap.put("acct_code",detAcctCode == null ? "":detAcctCode);
				glTraceMap.put("cctr_code",detCctrCode == null ? "":detCctrCode);
				glTraceMap.put("emp_code",detEmpCode);
				glTraceMap.put("anal_code",detAnalCode == null ? "":detAnalCode);
				glTraceMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
				glTraceMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
				if ("D".equalsIgnoreCase (detDrcrFlag))
				{
					glTraceMap.put("dr_amt",Math.abs(Double.parseDouble(detAmount)));
					glTraceMap.put("cr_amt","0");
				}
				else
				{
					glTraceMap.put("cr_amt",Math.abs(Double.parseDouble(detAmount)));
					glTraceMap.put("dr_amt","0");
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","JOUR");
				glTraceMap.put("ref_id",tranId);
				
				if (detRemarks == null || detRemarks.trim().length() == 0)
				{
					glTraceMap.put("remarks",journalMap.get("remarks"));
				}
				else
				{
					glTraceMap.put("remarks",detRemarks);
				}
				glTraceMap.put("proj_code",detProjCode);
				
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
                }
				System.out.println("sundry type = "+"["+detSundryType+"]");				
				System.out.println("sundry code = "+"["+detSundryCode+"]");				
				//if ((!("O".equalsIgnoreCase (detSundryType))) && (detSundryCode.trim().length() > 0 ))
				if ((!("O".equalsIgnoreCase (detSundryType))) && (detSundryType != null ))//changes done by chandni 2-feb-2012
				{
					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",journalMap.get("tran_date"));
					sundryBalMap.put("eff_date",journalMap.get("eff_date"));
					sundryBalMap.put("fin_entity",journalMap.get("fin_entity"));
					sundryBalMap.put("site_code",journalMap.get("site_code"));
					sundryBalMap.put("sundry_type",detSundryType == null ? "":detSundryType);
					sundryBalMap.put("sundry_code",detSundryCode == null ? "":detSundryCode);
					sundryBalMap.put("acct_code",detAcctCode == null ? "":detAcctCode);
					sundryBalMap.put("cctr_code",detCctrCode == null ? "":detCctrCode);
					sundryBalMap.put("curr_code",journalMap.get("curr_code"));
					sundryBalMap.put("exch_rate",journalMap.get("exch_rate"));
					if ("D".equalsIgnoreCase(detDrcrFlag))
					{
						sundryBalMap.put("dr_amt",amtDbl);
						sundryBalMap.put("cr_amt",0.0);
					}
					else
					{
						sundryBalMap.put("cr_amt",amtDbl);
						sundryBalMap.put("dr_amt",0.0);
					}
					sundryBalMap.put("adv_amt",0.0);
				
					sundryBalMap.put("contact_code",Fcommon.getContactCode(detSundryType,detSundryCode,conn));
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}	
				}
				
			}// end of for loop	
			if (jourdetList.size() > 0 )
			{
				if (errString != null && errString.indexOf("Error") != -1  )
				{
					errString = Fcommon.checkGlTranDrCr("JOUR",tranId,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}	
				}
			}
			if (errString != null && errString.indexOf("Error") != -1  )
			{
				System.out.println("Returning Result "+errString);
				return errString;
			}
			else
			{
				confirm = (String)journalMap.get("confirmed");
				if (!("Y".equalsIgnoreCase(confirm)))
				{
					System.out.println("inside Y is equal :");
					sql = " update journal set confirmed = 'Y' , "
						+" conf_date = ?, "
						+" emp_code__aprv = ? "
						+" where tran_id = ? " ;
					System.out.println("SQL : "+sql);
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
					pstmt.setString(2,empCodeAprv);
					pstmt.setString(3,tranId);
					int upd = pstmt.executeUpdate();
					/*
					System.out.println(" journal Confirmed:: "+upd);
					errString = itmDBAccessEJB.getErrorString("","VTCONF","");	*/
					pstmt.close();
					pstmt = null;
				}
				if(("Y".equalsIgnoreCase (journalMap.get("reversible").toString())) && ("Y".equalsIgnoreCase (journalMap.get("auto_rev").toString())) && ("N".equalsIgnoreCase (journalMap.get("status").toString())))
				{
					siteFr =(String)journalMap.get("site_code");
					siteTo = (String)journalMap.get("site_code__rev"); 
									
					if (siteFr.equalsIgnoreCase(siteTo))
					{
						link = "A";
					}
					else
					{
						sql =" select link_type from ibca_pay_ctrl  "
							+" where site_code__from = ? and site_code__to = ?" ;
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,siteFr);
						pstmt.setString(2,siteTo);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							link = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt =null;
					}
					if ("P".equalsIgnoreCase (link) || "A".equalsIgnoreCase(link))
					{
						thisWin ="W_JOURNAL" ;
						sql =" select key_string from transetup where upper(tran_window) = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,thisWin);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							keyStr = rs.getString(1);
						}
						else
						{
							thisWin ="GENERAL" ;
							sql1 =" select key_string from transetup where upper(tran_window) = ? ";
							pstmt1 =  conn.prepareStatement(sql1);
							pstmt1.setString(1,thisWin);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								keyStr = rs1.getString(1);
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 =null;
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt =null;
						
						sql =" select sum(amount) as debit from jourdet "
							+" where tran_id = ? and drcr_flag = 'D' ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							amt = rs.getDouble(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt =null;
						
						FinEnt  =(String)journalMap.get("fin_entity");
						revDt = (Timestamp)journalMap.get("rev_date");
						System.out.println("revDt is equal ::"+revDt+"OR   :::"+(Timestamp)journalMap.get("rev_date"));
						// Added by Dipak 22Oct - start
						glTraceMap.put("tran_date",(journalMap.get("rev_date") == null ? "":journalMap.get("rev_date")));
						glTraceMap.put("eff_date",(journalMap.get("rev_date") == null ? "":journalMap.get("rev_date")));
						glTraceMap.put("fin_entity",(journalMap.get("fin_entity") == null ? "":journalMap.get("fin_entity")));
						glTraceMap.put("site_code",(journalMap.get("site_code") == null ? "":journalMap.get("site_code__rev")));
						glTraceMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
						glTraceMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
						// Ended by Dipak

						
						//amt = Double.parseDouble((String)journalMap.get("dr_amt")); //Added By Dipak On 22 Oct 2011
						tranType = (String)journalMap.get("tran_type");
						siteCodeRev = (String)journalMap.get("site_code__rev");
						detRemarks = "Through reversal of JV :" +glTraceMap.get("ref_id");
						detAnalCode = "" + glTraceMap.get("anal_code");//added by dipak on 3 nov 2011
						revRefSer = "JOUR";
						revRefId  = tranId;
						glTraceMap.put("proj_code",(journalMap.get("proj_code") == null ? "":journalMap.get("proj_code")));//Added By Dipak On 22 Oct 2011
						
						if (amt > 0 )
						{
							String revS = "N";
							
							xmlString ="<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
							"\r\n</header><Detail1><item_ser></item_ser>"+
							"\r\n<site_code>"+siteCodeRev+"</site_code>\r\n<tran_date>"+sdf.format(new java.util.Date(revDt.getTime()))+"</tran_date>"+
							"\r\n<eff_date>"+sdf.format(new java.util.Date(revDt.getTime()))+"</eff_date>"+
							"\r\n<tran_type>"+tranType+"</tran_type>\r\n<reversible>"+revS+"</reversible>+</Detail1></Root>";
								
							System.out.println("xmlString is equal:: :: :: "+xmlString);
								
							TransIDGenerator  tg = new TransIDGenerator(xmlString,"Base","oracle");
							tranIDSer = tg.generateTranSeqID("JOUR","tran_id",keyStr,conn);
							System.out.println("Generated Key :: "+tranIDSer);
							if (tranIDSer.indexOf("ERROR") > -1 )
							{
								errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
								 return errString;
							}
							sql =" insert into journal "
							+" ( tran_id, tran_date, eff_date, fin_entity, site_code, dr_amt, cr_amt , "
							+" remarks, reversible, status, confirmed, ref_ser, ref_no, curr_code, "
							+" tran_type,exch_rate, chg_date, chg_user, proj_code ) "
							+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranIDSer);
							pstmt.setTimestamp(2,revDt);
							pstmt.setTimestamp(3,revDt);
							pstmt.setString(4,(String)journalMap.get("fin_entity"));
							pstmt.setString(5,(String)journalMap.get("site_code"));
							pstmt.setDouble(6,amt);
							pstmt.setDouble(7,amt);
							pstmt.setString(8,detRemarks);
							pstmt.setString(9,"N");
							pstmt.setString(10,"V");
							pstmt.setString(11,"Y");
							pstmt.setString(12,revRefSer);
							pstmt.setString(13,revRefId);
							pstmt.setString(14,(String)journalMap.get("curr_code"));
							pstmt.setString(15,tranType);
							//pstmt.setString(16,(String)journalMap.get("exch_rate"));
							pstmt.setDouble(16,Double.parseDouble(journalMap.get("exch_rate").toString()));
							pstmt.setTimestamp(17,toDay);
							pstmt.setString(18,empCodeAprv);
							pstmt.setString(19,(String)journalMap.get("proj_code"));
							pstmt.executeUpdate();
							pstmt.close();
							
							sqlInsert =" insert into jourdet "
								+" ( tran_id, line_no, sundry_type,sundry_code, acct_code,cctr_code, "
								+" drcr_flag, amount, emp_code, anal_code,remarks,proj_code ) "
								+" values (?,?,?,?,?,?,?,?,?,?,?,?)";
							pstmtInsert = conn.prepareStatement(sqlInsert);
							
							for (ctr =0, ctrLine = 0; ctr < jourdetList.size(); ctr++)
							{
								detListMap = new HashMap();
								detListMap = (HashMap)jourdetList.get(ctr);
								
								detSundryType =(String)detListMap.get("sundry_type");
								detSundryCode =(String)detListMap.get("sundry_code");
								detAcctCode =(String)detListMap.get("acct_code");
								detCctrCode =(String)detListMap.get("cctr_code");
								detEmpCode =(String)detListMap.get("emp_code "); 
								detAnalCode =(String)detListMap.get("anal_code");
								detDrcrFlag =(String)detListMap.get("drcr_flag"); 
								amt = Double.parseDouble(detListMap.get("amount").toString());
								detProjCode =(String)detListMap.get("proj_code "); 
								/* commented by dipak acctCode =(String)detListMap.get("acct_code "); */
								//Added by dipak 22-Oct -start
								glTraceMap.put("sundry_type",detSundryType == null ? "":detSundryType);
								glTraceMap.put("sundry_code",detSundryCode == null ? "":detSundryCode);
								glTraceMap.put("acct_code",detAcctCode == null ? "":detAcctCode);
								glTraceMap.put("cctr_code",detCctrCode == null ? "":detCctrCode);
								glTraceMap.put("emp_code",detEmpCode);
								glTraceMap.put("anal_code",detAnalCode == null ? "":detAnalCode);
								glTraceMap.put("proj_code",detProjCode == null ? "":detProjCode);
								//glTraceMap.put("anal_code",detAnalCode);//added by dipak on 3 Nov 2011
								glTraceMap.put("remarks",detRemarks);
								
								if ("C".equalsIgnoreCase(detDrcrFlag))
								{
									detDrcrFlag = "D";
								}
								else
								{	
									detDrcrFlag = "C";
								}	
								/*
								if ("D".equalsIgnoreCase (detDrcrFlag))
								{
									glTraceMap.put("dr_amt",amt);
									glTraceMap.put("cr_amt","0");
								}
								else
								{
									glTraceMap.put("cr_amt",amt);
									glTraceMap.put("dr_amt","0");
								}
								
								glTraceMap.put("ref_id",tranIDSer);
								errString = Fcommon.glTraceUpdate(glTraceMap,conn);
								if(errString != null && errString.trim().length() > 0)
								{
									return errString;
								}
								// Endded by dipak
							*/
								if (!(siteFr).equalsIgnoreCase(siteTo))
								{
									sql =" select acct_code__pay, cctr_code__pay, acct_code__rcp,cctr_code__rcp  "
										+" from ibca_pay_ctrl "
										+" where site_code__from 	= ? "
										+" and	site_code__to  = ? " ; 
								
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString (1,siteFr);
									pstmt.setString (2,siteTo);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										acPay = rs.getString(1);
										ccPay = rs.getString(2);
										acRcp = rs.getString(3);
										ccRcp = rs.getString(4);
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt =null;
									if ( detAcctCode.equalsIgnoreCase(acPay) )
									{
										detAcctCode = acRcp;
										detCctrCode = ccRcp ;
									}
								} // end if (siteFr != siteTo)
								ctrLine = ctr + 1;
								System.out.println(" SQL for journal insert :: "+sql);
								pstmtInsert.setString(1,tranIDSer);
								pstmtInsert.setInt(2,ctrLine);
								pstmtInsert.setString(3,detSundryType);
								pstmtInsert.setString(4,detSundryCode);
								pstmtInsert.setString(5,detAcctCode);
								pstmtInsert.setString(6,detCctrCode);
								pstmtInsert.setString(7,detDrcrFlag);
								pstmtInsert.setDouble(8,amt);
								pstmtInsert.setString(9,detEmpCode);
								pstmtInsert.setString(10,detAnalCode);
								pstmtInsert.setString(11,detRemarks);
								pstmtInsert.setString(12,detProjCode);
								pstmtInsert.addBatch();
								//pstmtInsert.executeUpdate();
								//pstmtInsert.close();
								
								if(errString != null && errString.indexOf("Error") != -1  )
								{
									break;
								}
							}// END FOR
							pstmtInsert.executeBatch();
							pstmtInsert.close();
							
							if ("P".equalsIgnoreCase(link))
							{
								sql ="select fin_entity from site where site_code = ? " ;
								pstmt = conn.prepareStatement(sql);
								pstmt.setString (1,siteTo);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									FinEntto = rs.getString(1);
								}
								rs.close();
								rs = null; 
								pstmt.close();
								pstmt =null;
								   
								sql = " select auto_confirm from ibca_pay_ctrl "
									+" where  site_code__from   = ? "
									+" and    fin_entity__from  = ? "
									+" and    site_code__to     = ? "
									+" and    fin_entity__to    = ? "
									+" and    link_type         = 'P' ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString (1,siteFr);
								pstmt.setString (2,FinEnt);
								pstmt.setString (3,siteTo);
								pstmt.setString (4,FinEntto);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									IBCAAConf = rs.getString(1);
								}
								else
								{
									IBCAAConf = "N";
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt =null;
								
								if ("Y".equalsIgnoreCase(IBCAAConf))
								{
									errString = gbfRetrieveJournal(tranIDSer,xtraParams,conn);
									if(errString != null && errString.trim().length() > 0)
									{
										return errString;
									}
								}
							
							}
							else if (siteFr.equalsIgnoreCase(siteTo))
							{
								IBCAAConf = "Y";
								errString= gbfRetrieveJournal (tranIDSer,xtraParams,conn);
								if(errString != null && errString.trim().length() > 0)
								{
									return errString;
								}
								IBCAAConf = "N";
								System.out.println("IBCAAConf : : ::" +IBCAAConf);						
							}
							
							
						
						}// amount
					}// link type
					sql =" update journal "
						+" set status = 'R', "
						+" rev_date__act = ? "
						+" where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,revDt);
					pstmt.setString(2,tranId);
					int updCnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
						
				} // end of if for reversible jv	
				
				//conn.commit();
				errString = itmDBAccessEJB.getErrorString("","CONFSUCCES","");
				System.out.println("JV Confirmed .."+errString);
			} // end of else
			return errString;
		}// end ofTry - gbfPostJournal
		catch(SQLException e)
		{
			System.out.println("Exception :JvConf :gbfPostJournal :SQLException :==>\n"+e.getMessage());
			errString = GenericUtility.getInstance().createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :JvConf :gbfPostJournal :==>"+e.getMessage());
			errString = GenericUtility.getInstance().createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null){rs.close();rs = null;}
				if(rs1 != null){rs1.close();rs1 = null;}
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
	}//method end //gbf_post_journal - end
	
	String otherSitePostJournal(String tranId,HashMap journalMap,ArrayList jourdetList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String errString = "" ; 
		String sql = "",sql1 = "";
		String xmlString = "";
		ConnDriver connDriver = null;
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ArrayList glTraceList = new ArrayList();	
		HashMap glTraceMap = null,sundryBalMap = null,detListMap = null,jMap = null,jdetMap=null; 
		ArrayList jdList = new ArrayList();
		String tranIDSer  = "";
		genericUtility = new GenericUtility();
		String thisWin = "" ,keyStr = "",refId = "",link = "",amountStr = "",FinEntitySite="";
		String revRefSer = "",tranType = "",confirm = "",empCodeAprv="";
		String FinEnt ="",siteCode = "",siteCodeJv = "",siteCodeFor = "";
		String	detSundryType = "",	detSundryCode = "",detAcctCode="",detCctrCode = "",detEmpCode = "";
		String detAnalCode = "",detDrcrFlag= "",detRemarks= "",detProjCode = "",reversible="",autoRev="";
		int ctr = 1,cnt1 = 0 ;
		double drAmt = 0,crAmt = 0,drAmtFor = 0,crAmtFor = 0,detAmount = 0,totAmount = 0,amount = 0;
		java.sql.Timestamp toDay = null;
		java.sql.Timestamp revDt = null;
		SimpleDateFormat sdf = null;
		StringBuffer xmlBuff = null;
		String finEntityFr = "",acctCodeRcp = "",acctCodePay = "",autoConf="",siteCodeRev="";
		String acctCode = "",finEntity = "";
		FinCommon Fcommon = new FinCommon();
		try
		{
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			itmDBAccessEJB = new ITMDBAccessEJB();
			empCodeAprv  = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			siteCode = journalMap.get("site_code").toString().trim();
			siteCodeFor = journalMap.get("site_code__for").toString().trim();
			
			if("Y".equalsIgnoreCase (journalMap.get("reversible").toString()))
			{
				errString = itmDBAccessEJB.getErrorString("","not allow","","",conn);
				return errString;
			}
			//changes at 12/08/11 by chandni
			// header site_code validation
			sql =" select sum(case when drcr_flag = 'D' then amount else 0 end) debit, "
				+" sum(case when drcr_flag = 'C' then amount else 0 end) credit from jourdet "
				+" where tran_id = ?  "
				+" and site_code__jv = ? " ;
			System.out.println (sql);
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,siteCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				drAmt = rs.getDouble(1);
				crAmt = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
					
			//header site_code__for validation
			sql = "select sum(case when drcr_flag = 'D' then amount else 0 end) debit, "
				+" sum(case when drcr_flag = 'C' then amount else 0 end) credit from jourdet "
				+" where tran_id = ?  "
				+" and site_code__jv = ? ";
			System.out.println (sql);
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,siteCodeFor);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				drAmtFor = rs.getDouble(1);
				crAmtFor = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(drAmt != crAmtFor && crAmt != drAmtFor)
			{
				errString = itmDBAccessEJB.getErrorString("","VTVCONF3","","",conn);
				return errString;
			}
			
			/*collecting data from ibca_pay_ctrl*/
			sql =" select count(1) from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,siteCodeFor);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				int cnt = rs.getInt(1);
				if(cnt == 0)
				{
					errString = itmDBAccessEJB.getErrorString("","VTIBCA5","","",conn);
					return errString;
				}
			}
			rs.close();	rs = null;
			pstmt.close(); pstmt = null;
			
			sql =" select fin_entity__from,acct_code__rcp,acct_code__pay,auto_confirm,link_type"
				+" from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,siteCodeFor);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				finEntityFr = rs.getString(1);
				acctCodeRcp = rs.getString(2);
				acctCodePay = rs.getString(3);
				autoConf = rs.getString(4);
				link = rs.getString(5);
			}
			rs.close();	rs = null;
			pstmt.close(); pstmt = null;
			
			/* accounting effect for site code - start */
			glTraceMap = new HashMap();	
			sql = "select count(1) from jourdet where site_code__jv = ? and tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt1 = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			sql =" select acct_code,drcr_flag,amount,sundry_type,sundry_code,cctr_code,emp_code,anal_code,remarks,proj_code "
				+" from jourdet where site_code__jv = ? and tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				System.out.println(sql);
				acctCode = rs.getString(1);
				detDrcrFlag = rs.getString(2);
				amount = rs.getDouble(3);
				detSundryType =rs.getString(4);
				detSundryCode =rs.getString(5);
				detCctrCode =rs.getString(6);
				detEmpCode =rs.getString(7);
				detAnalCode =rs.getString(8);
				detRemarks =rs.getString(9);
				detProjCode = rs.getString(10);
				
				/* calculating total amount*/
				detAmount = detAmount + amount ; 
				System.out.println ("detAmount is : : :  "+ detAmount);
				
				glTraceMap.put("tran_date",(journalMap.get("tran_date") == null ? "":journalMap.get("tran_date")));
				glTraceMap.put("eff_date",(journalMap.get("eff_date") == null ? "":journalMap.get("eff_date")));
				glTraceMap.put("fin_entity",(journalMap.get("fin_entity") == null ? "":journalMap.get("fin_entity")));
				glTraceMap.put("site_code",siteCode); // from header : siteCode
				glTraceMap.put("sundry_type",detSundryType);
				glTraceMap.put("sundry_code",detSundryCode);
				glTraceMap.put("acct_code",acctCode); 
				glTraceMap.put("cctr_code",detCctrCode);
				glTraceMap.put("emp_code",detEmpCode);
				glTraceMap.put("anal_code",detAnalCode);
				glTraceMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
				glTraceMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
							
				if ("D".equalsIgnoreCase (detDrcrFlag))
				{
					glTraceMap.put("dr_amt",amount);
					glTraceMap.put("cr_amt","0");
				}
				else
				{
					glTraceMap.put("cr_amt",amount);
					glTraceMap.put("dr_amt","0");
				}
				glTraceMap.put("fin_entity",(journalMap.get("fin_entity") == null ? "":journalMap.get("fin_entity")));
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","JOUR");
				glTraceMap.put("ref_id",tranId);
			
				if (detRemarks == null || detRemarks.trim().length() == 0)
				{
					glTraceMap.put("remarks",journalMap.get("remarks"));
				}
				else
				{
					glTraceMap.put("remarks",detRemarks);
				}
				glTraceMap.put("proj_code",detProjCode);
				
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
                }
						
				//if(!("O".equalsIgnoreCase (detSundryType)))
				if ((!("O".equalsIgnoreCase (detSundryType))) && (detSundryType != null ))//changes done by chandni 2-feb-2012
				{
					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",journalMap.get("tran_date"));
					sundryBalMap.put("eff_date ",journalMap.get("eff_date"));
					sundryBalMap.put("fin_entity",journalMap.get("fin_entity"));
					sundryBalMap.put("site_code",siteCode); // from header : siteCode
					sundryBalMap.put("sundry_type",detSundryType);
					sundryBalMap.put("sundry_code",detSundryCode);
					sundryBalMap.put("acct_code",acctCode);
					sundryBalMap.put("cctr_code",detCctrCode);
					sundryBalMap.put("curr_code ",journalMap.get("curr_code"));
					sundryBalMap.put("exch_rate",journalMap.get("exch_rate"));
					if ("D".equalsIgnoreCase(detDrcrFlag))
					{
						sundryBalMap.put("dr_amt",amount);
						sundryBalMap.put("cr_amt",0.0);
					}
					else
					{
						sundryBalMap.put("cr_amt",amount);
						sundryBalMap.put("dr_amt",0.0);
					}
					sundryBalMap.put("adv_amt",0.0);
				
					sundryBalMap.put("contact_code",Fcommon.getContactCode(detSundryType,detSundryCode,conn));
					
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);
					if(errString != null && errString.indexOf("Error") != -1  )
					{
						return errString;
					}
				}
				
				if(errString != null && errString.indexOf("Error") != -1  )
				{
					break;
				}
			} // end of while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(cnt1 > 0 )
			{
				glTraceMap.put("tran_date",(journalMap.get("tran_date") == null ? "":journalMap.get("tran_date")));
				glTraceMap.put("eff_date",(journalMap.get("eff_date") == null ? "":journalMap.get("eff_date")));
				glTraceMap.put("fin_entity",(journalMap.get("fin_entity") == null ? "":journalMap.get("fin_entity")));
				glTraceMap.put("site_code",siteCode); // from header : siteCode
				glTraceMap.put("sundry_type",detSundryType);
				glTraceMap.put("sundry_code",detSundryCode);
				glTraceMap.put("acct_code",acctCodePay); //ibca-pay acctcode
				glTraceMap.put("cctr_code",detCctrCode);
				glTraceMap.put("emp_code",detEmpCode);
				//glTraceMap.put("anal_code",detAnalCode);
				glTraceMap.put("anal_code","");
				glTraceMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
				glTraceMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
				if("D".equalsIgnoreCase(detDrcrFlag))
				{
					glTraceMap.put("dr_amt","0");
					glTraceMap.put("cr_amt",detAmount);
				}
				else
				{
					glTraceMap.put("dr_amt",detAmount);
					glTraceMap.put("cr_amt","0");
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","JOUR");
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("remarks","");
				glTraceMap.put("proj_code",detProjCode);

				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
                if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				//if(!("O".equalsIgnoreCase (detSundryType)))
				if ((!("O".equalsIgnoreCase (detSundryType))) && (detSundryType != null ))//changes done by chandni 2-feb-2012
				{
					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",journalMap.get("tran_date"));
					sundryBalMap.put("eff_date ",journalMap.get("eff_date"));
					sundryBalMap.put("fin_entity",journalMap.get("fin_entity"));
					sundryBalMap.put("site_code",siteCode); // from header : siteCode
					sundryBalMap.put("sundry_type",detSundryType);
					sundryBalMap.put("sundry_code",detSundryCode);
					sundryBalMap.put("acct_code",acctCodePay);//ibca-pay acctcode
					sundryBalMap.put("cctr_code",detCctrCode);
					sundryBalMap.put("curr_code ",journalMap.get("curr_code"));
					sundryBalMap.put("exch_rate",journalMap.get("exch_rate"));
					if ("D".equalsIgnoreCase(detDrcrFlag))
					{
						sundryBalMap.put("dr_amt","0");
						sundryBalMap.put("cr_amt",detAmount);
					}
					else
					{
						sundryBalMap.put("cr_amt","0");
						sundryBalMap.put("dr_amt",detAmount);
					}
					sundryBalMap.put("adv_amt","0");
					sundryBalMap.put("contact_code",Fcommon.getContactCode(detSundryType,detSundryCode,conn));
					
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			}
			/* accounting effect for site code - end */
			if (jourdetList.size() > 0 )
			{
				if (errString != null && errString.indexOf("Error") != -1  )
				{
					errString = Fcommon.checkGlTranDrCr("JOUR",tranId,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			}
			confirm = journalMap.get("confirmed").toString().trim();
			if (!("Y".equalsIgnoreCase(confirm)))
			{
				sql =" update journal set confirmed = 'Y' , "
				+" conf_date = ?, "
				+" emp_code__aprv = ? "
				+" where tran_id = ? " ;
				System.out.println("SQL : "+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
				pstmt.setString(2,empCodeAprv);
				pstmt.setString(3,tranId);
				int upd = pstmt.executeUpdate();
				System.out.println("journal Confirmed:: "+upd);
				errString = itmDBAccessEJB.getErrorString("","VTCONF","");
				pstmt.close();
				pstmt = null;
				//return errString;
				
			}
			if ("P".equalsIgnoreCase (link) || "A".equalsIgnoreCase(link)) // link is link_type from ibca_pay_ctrl
			{
				//code to find key_string for calling TransIDGenerator - generateTranSeqID.
				thisWin ="W_JOURNAL" ;
				sql =" select key_string from transetup where upper(tran_window) = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,thisWin);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyStr = rs.getString(1);					
				}
				else
				{
					thisWin ="GENERAL" ;
					sql1 =" select key_string from transetup where upper(tran_window) = ? ";
					pstmt1 =  conn.prepareStatement(sql1);
					pstmt1.setString(1,thisWin);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						keyStr = rs1.getString(1);
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 =null;
				}
				rs.close();	rs = null;
				pstmt.close();pstmt =null;
				System.out.println("keyStr :::"+keyStr);
				
				FinEnt  =(String)journalMap.get("fin_entity");
				revDt = (Timestamp)journalMap.get("tran_date");
				tranType = (String)journalMap.get("tran_type");
				revRefSer = "JOUR"; 
				reversible = (String)journalMap.get("reversible");
				autoRev = (String)journalMap.get("auto_rev");
				siteCodeRev =(String)journalMap.get("site_code__rev");
				xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
                    "\r\n</header><Detail1><item_ser></item_ser>"+
                    "\r\n<site_code>"+siteCodeFor+"</site_code>\r\n<tran_date>"+sdf.format(new java.util.Date(revDt.getTime()))+"</tran_date></Detail1></Root>";
					
				System.out.println("xmlBuff : : : : :"+xmlString);
				// generating new tranId TransIDGenerator
				CommonConstants.setIBASEHOME();
				TransIDGenerator  tg = new TransIDGenerator(xmlString,"Base",CommonConstants.DB_NAME);
				tranIDSer = tg.generateTranSeqID("JOUR","tran_id",keyStr,conn);
				System.out.println("Generated Key :: "+tranIDSer);
				if (tranIDSer.indexOf("ERROR") > -1 )
				{
					errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
				}
				sql =" select fin_entity from site where site_code = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,siteCodeFor);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					FinEntitySite = rs.getString("fin_entity");					
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				
				sql =" insert into journal "
				+" (tran_id, tran_date, eff_date, fin_entity, site_code, dr_amt, cr_amt , "
				+"  remarks, reversible, status,confirmed, ref_ser, ref_no, curr_code, "
				+" tran_type,exch_rate, chg_date, chg_user, proj_code ) "
				+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
				System.out.println("SQL for journal insert :: "+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDSer); //new generated tranId
				pstmt.setTimestamp(2,revDt);
				pstmt.setTimestamp(3,revDt);
				pstmt.setString(4,FinEntitySite);
				//changed at 12/08/11 by chandni 
				pstmt.setString(5,siteCodeFor);
				pstmt.setDouble(6,detAmount); // set total amount of detail.
				pstmt.setDouble(7,detAmount);
				pstmt.setString(8,detRemarks);
				pstmt.setString(9,"N");
				pstmt.setString(10,"V");
				pstmt.setString(11,"N");
				pstmt.setString(12,revRefSer);
				pstmt.setString(13,tranId); // ref_no as a original tran_id
				pstmt.setString(14,(String)journalMap.get("curr_code"));
				pstmt.setString(15,tranType);
				//pstmt.setString(16,(String)journalMap.get("exch_rate"));
				pstmt.setDouble(16,Double.parseDouble(journalMap.get("exch_rate").toString()));
				pstmt.setTimestamp(17,toDay);
				pstmt.setString(18,empCodeAprv);
				pstmt.setString(19,detProjCode);
				pstmt.executeUpdate();
				pstmt.close();
				//added at 12/08/11 by chandni 
				jMap = new HashMap();
				jMap.put("tran_type",tranType);
				jMap.put("tran_date",revDt);
				jMap.put("eff_date",revDt);
				jMap.put("site_code",siteCodeFor);
				jMap.put("fin_entity",FinEntitySite);
				jMap.put("ref_ser",revRefSer);
				jMap.put("ref_no",tranId);
				jMap.put("reversible","N");
				jMap.put("dr_amt",detAmount);
				jMap.put("cr_amt",detAmount);
				jMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
				jMap.put("status","V");
				jMap.put("remarks",detRemarks);
				jMap.put("confirmed","N");
				jMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
								
				sql1 = "select count(1) from jourdet where site_code__jv = ? and tran_id = ? " ;
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1,siteCodeFor);
				pstmt1.setString(2,tranId);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					cnt1 = rs1.getInt(1);
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				/* accounting effect for site code for - auto generation site - start */
				
				sql =" insert into jourdet "
					+" ( tran_id, line_no, sundry_type,sundry_code, acct_code,cctr_code, "
					+" drcr_flag, amount, emp_code, anal_code,	remarks,proj_code ) "
					+" values (?,?,?,?,?,?,?,?,?,?,?,?)";
				
				System.out.println(" SQL for jourdet insert for acct effect :: "+sql);
				pstmt = conn.prepareStatement(sql);
				
				sql1 =" select acct_code,drcr_flag,amount,sundry_type,sundry_code,cctr_code,emp_code,anal_code,remarks,proj_code "
				+" from jourdet where site_code__jv = ? and tran_id = ?" ;
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1,siteCodeFor);
				pstmt1.setString(2,tranId);
				rs = pstmt1.executeQuery();
				while (rs.next())
				{
					detAcctCode = rs.getString(1);
					detDrcrFlag = rs.getString(2);
					amountStr = rs.getString(3);
					detSundryType =rs.getString(4);
					detSundryCode =rs.getString(5);
					detCctrCode =rs.getString(6);
					detEmpCode =rs.getString(7);
					detAnalCode =rs.getString(8);
					detRemarks =rs.getString(9);
					detProjCode = rs.getString(10);
							
					/* calculating total amount*/
					amount = Double.parseDouble (amountStr);
					totAmount = totAmount + amount ; 
									
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDSer); // new generated tran_id
					pstmt.setInt(2,ctr);
					pstmt.setString(3,detSundryType);
					pstmt.setString(4,detSundryCode);
					pstmt.setString(5,detAcctCode);
					pstmt.setString(6,detCctrCode);
					pstmt.setString(7,detDrcrFlag);
					pstmt.setDouble(8,amount);
					pstmt.setString(9,detEmpCode);
					//pstmt.setString(10,(String)journalMap.get("anal_code"));
					pstmt.setString(10,detAnalCode);
					pstmt.setString(11,detRemarks);
					pstmt.setString(12,detProjCode);
					pstmt.addBatch();
					pstmt.executeBatch();pstmt.close();
					
					//added at 12/08/11 by chandni 
					jdetMap = new HashMap();
					jdetMap.put("line_no",ctr);
					jdetMap.put("acct_code",detAcctCode);
					jdetMap.put("cctr_code",detCctrCode);
					jdetMap.put("drcr_flag",detDrcrFlag);
					jdetMap.put("amount",amountStr);
					jdetMap.put("emp_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
					jdetMap.put("emp_code",detEmpCode);
					//jdetMap.put("anal_code",(journalMap.get("anal_code") == null ? "":journalMap.get("anal_code")));
					jdetMap.put("anal_code",detAnalCode);
					jdetMap.put("sundry_type",detSundryType);
					jdetMap.put("sundry_code",detSundryCode);
					jdetMap.put("remarks",detRemarks);
					jdetMap.put("proj_code",(journalMap.get("proj_code") == null ? "":journalMap.get("proj_code")));
					
					jdList.add(jdetMap);
					ctr++;
									
				} //end of while
				//pstmt.executeBatch();pstmt.close();
				rs.close();rs = null;
				pstmt1.close();pstmt1 = null;
				
				/* A/C effect for ibca-rcp acctcode with total amount */
			
				if(cnt1 > 0)
				{
					if("C".equalsIgnoreCase(detDrcrFlag))
					{
						detDrcrFlag = "D";
					}
					else
					{
						detDrcrFlag = "C";
					}
					System.out.println("detDrcrFlag AFTER SWAP insert:: "+detDrcrFlag);
					cnt1++;
					sql = "insert into jourdet "
						+" ( tran_id, line_no, sundry_type,sundry_code, acct_code,cctr_code, "
						+" drcr_flag, amount, emp_code, anal_code,remarks,proj_code ) "
						+" values (?,?,?,?,?,?,?,?,?,?,?,?)";
					System.out.println(" SQL for jourdet insert with total amount:: "+sql);
									
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDSer); // new generated tran_id
					pstmt.setInt(2,cnt1);
					pstmt.setString(3,detSundryType);
					pstmt.setString(4,detSundryCode);
					pstmt.setString(5,acctCodeRcp); // IBCA-RCP ACCTCODE
					pstmt.setString(6,detCctrCode);
					pstmt.setString(7,detDrcrFlag);
					pstmt.setDouble(8,totAmount);
					pstmt.setString(9,(String)glTraceMap.get("emp_code"));
					pstmt.setString(10,(String)glTraceMap.get("anal_code"));
					pstmt.setString(11,detRemarks);
					pstmt.setString(12,(String)glTraceMap.get("proj_code"));
					pstmt.executeUpdate();
					pstmt.close();
					//added at 12/08/11 by chandni 
					glTraceMap.put("tran_date",(journalMap.get("tran_date") == null ? "":journalMap.get("tran_date")));
					glTraceMap.put("eff_date",(journalMap.get("eff_date") == null ? "":journalMap.get("eff_date")));
					glTraceMap.put("fin_entity",FinEntitySite);
					//glTraceMap.put("site_code",siteCode); // from header : siteCode
					//changed at 12/08/11 by chandni 
					glTraceMap.put("site_code",siteCodeFor); // from header : siteCode
					glTraceMap.put("sundry_type",detSundryType);
					glTraceMap.put("sundry_code",detSundryCode);
					glTraceMap.put("acct_code",acctCodeRcp); //ibca-pay acctcode
					glTraceMap.put("cctr_code",detCctrCode);
					glTraceMap.put("emp_code",detEmpCode);
					//glTraceMap.put("anal_code",detAnalCode);
					glTraceMap.put("anal_code","");
					glTraceMap.put("curr_code",(journalMap.get("curr_code") == null ? "":journalMap.get("curr_code")));
					glTraceMap.put("exch_rate",(journalMap.get("exch_rate") == null ? "":journalMap.get("exch_rate")));
					if ("D".equalsIgnoreCase (detDrcrFlag))
					{
						glTraceMap.put("dr_amt",totAmount);
						glTraceMap.put("cr_amt","0");
					}
					else
					{
						glTraceMap.put("dr_amt","0");
						glTraceMap.put("cr_amt",totAmount);
					}
					glTraceMap.put("ref_type","F");
					glTraceMap.put("ref_ser","JOUR");
					glTraceMap.put("ref_id",tranIDSer);
					glTraceMap.put("remarks","");
						
					glTraceMap.put("proj_code",detProjCode);
					errString = Fcommon.glTraceUpdate(glTraceMap,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}				
					if(!("O".equalsIgnoreCase (detSundryType)))
					{
						sundryBalMap = new HashMap();
						sundryBalMap.put("tran_date",journalMap.get("tran_date"));
						sundryBalMap.put("eff_date ",journalMap.get("eff_date"));
						sundryBalMap.put("fin_entity",FinEntitySite);
						sundryBalMap.put("site_code",siteCodeFor); // from header : siteCode
						sundryBalMap.put("sundry_type",detSundryType);
						sundryBalMap.put("sundry_code",detSundryCode);
						sundryBalMap.put("acct_code",acctCodePay);//ibca-pay acctcode
						sundryBalMap.put("cctr_code",detCctrCode);
						sundryBalMap.put("curr_code ",journalMap.get("curr_code"));
						sundryBalMap.put("exch_rate",journalMap.get("exch_rate"));
						if ("D".equalsIgnoreCase(detDrcrFlag))
						{
							sundryBalMap.put("dr_amt",0.0);
							sundryBalMap.put("cr_amt",totAmount);
						}
						else
						{
							sundryBalMap.put("cr_amt",0.0);
							sundryBalMap.put("dr_amt",totAmount);
						}
						sundryBalMap.put("adv_amt",0.0);
						sundryBalMap.put("contact_code",Fcommon.getContactCode(detSundryType,detSundryCode,conn));
						
						errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}
				}
				/* accounting effect for site code for - auto generation site - end */
				/* in original tran id journal set ref_no = new created tran_id  */
				sql =" update journal "
					+" set ref_no = ? "
					+" where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDSer);
					pstmt.setString(2,tranId);
					int updCnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
			
				/*calling gbfPostJournal - (Normal Posting) by passing tranIDSer - (new generated tran_id)*/
				//changed at 12/08/11 by chandni 			
				errString = this.gbfPostJournal(tranIDSer,jMap,jdList,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}// A or P
		}// end ofTry - otherSitePostJournal
		catch(SQLException e)
		{
			System.out.println("Exception :JvConf :otherSitePostJournal :SQLException :==>\n"+e.getMessage());
			errString = GenericUtility.getInstance().createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :JvConf :otherSitePostJournal :==>"+e.getMessage());
			errString = GenericUtility.getInstance().createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null){rs.close();rs = null;}
				if(rs1 != null){rs1.close();rs1 = null;}
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}	
		return errString;
	}//method end
} //end of class
