package ibase.webitm.ejb.fin;
import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;

import java.text.SimpleDateFormat;
import javax.ejb.Stateless; // added for ejb3

import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.adv.*;

@Stateless
public class InvoiceDownloadPrc extends ProcessEJB implements InvoiceDownloadPrcLocal, InvoiceDownloadPrcRemote
{

	DistCommon distCommonObj = new DistCommon();
	GenericUtility genericUtility = GenericUtility.getInstance();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	
	@Override
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	//getData Method
	
	@Override
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;	
		
		try
		{
				
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			
			System.out.println("Exception :InvoiceDownloadEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
			throw new ITMException(e);
		
		}
		return rtrStr; 
	}//END OF GETDATA(1)
	
	public String blanknull(String s)
	{
		if( s==null )
			return " ";
		else
			return s;
	}
	
	
	@Override
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		String errCode = "";
		String errString = "";
		String getDataSql= "" ;

		String resultString = "";
		ResultSet rs1 = null;
		PreparedStatement pstmt = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		int cnt=0,count=0,i=5;
		String sql="",siteCodeFrom = "",siteCodeTo = "",custCodeFrom = "",custCodeTo = "";
		String invoiceIdFrom = "",invoiceIdTo = "",invoiceDateFromStr = "",invoiceDateToStr = "";
		
		Timestamp invoiceDateFrom = null,invoiceDateTo = null;
				
			
		ConnDriver connDriver = new ConnDriver();
		Connection conn= null;
		try
		{
			if(conn==null)
			{
				conn = connDriver.getConnectDB("DriverITM");
				 
				conn.setAutoCommit(false);	
			}
			DatabaseMetaData dbmd = conn.getMetaData();
			System.out.println("DriverName["+dbmd.getDriverName() + "]");
			System.out.println("DriverURI["+dbmd.getURL()  + "]");
			System.out.println("DriverUSER["+dbmd.getUserName() +"]");
					
			System.out.println("InvoiceDownload : getData() Method Called");
			
			siteCodeFrom = genericUtility.getColumnValue("site_code_from",headerDom);
			siteCodeTo = genericUtility.getColumnValue("site_code_to",headerDom);
			custCodeFrom = genericUtility.getColumnValue("cust_code_from",headerDom);
			custCodeTo = genericUtility.getColumnValue("cust_code_to",headerDom);
			invoiceIdFrom = genericUtility.getColumnValue("invoice_id_from",headerDom);
			invoiceIdTo = genericUtility.getColumnValue("invoice_id_to",headerDom);
			invoiceDateFromStr = genericUtility.getColumnValue("invoice_date_from",headerDom);
			invoiceDateToStr = genericUtility.getColumnValue("invoice_date_to",headerDom);
			
			System.out.println("invoiceDateFromStr : ["+invoiceDateFromStr+"]:::invoiceDateToStr:["+invoiceDateToStr+"]");
			
			if(invoiceDateFromStr != null)
			{
				System.out.println("invoiceDateFromStr : ["+invoiceDateFromStr);
				invoiceDateFrom= Timestamp.valueOf(genericUtility.getValidDateString(invoiceDateFromStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			}
			if(invoiceDateToStr != null)
			{
				System.out.println(" :::invoiceDateToStr:["+invoiceDateToStr+"]");
				invoiceDateTo= Timestamp.valueOf(genericUtility.getValidDateString(invoiceDateToStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			}
			
			System.out.println("siteCodeFrom : ["+siteCodeFrom+"]:::siteCodeTo:["+siteCodeTo+"]");
			System.out.println("custCodeFrom : ["+custCodeFrom+"]:::custCodeTo:["+custCodeTo+"]");
			System.out.println("invoiceIdFrom : ["+invoiceIdFrom+"]:::invoiceIdTo:["+invoiceIdTo+"]");
			System.out.println("invoiceDateFrom : ["+invoiceDateFrom+"]:::invoiceDateTo:["+invoiceDateTo+"]");
			
			if ( siteCodeFrom == null || siteCodeFrom.trim().length() == 0 )
			{
				siteCodeFrom="00";
			}
			
			if ( siteCodeTo == null || siteCodeTo.trim().length() == 0 )
			{
				siteCodeTo="ZZ";
			}
			
			if ( custCodeFrom == null || custCodeFrom.trim().length() == 0 )
			{
				custCodeFrom="00";
			}
			
			if ( custCodeTo == null || custCodeTo.trim().length() == 0 )
			{
				custCodeTo="ZZ";
			}
			
			if ( invoiceIdFrom == null || invoiceIdFrom.trim().length() == 0 )
			{
				invoiceIdFrom="00";
			}
			
			if ( invoiceIdTo == null || invoiceIdTo.trim().length() == 0 )
			{
				invoiceIdTo="ZZ";
			}
			
			if ( invoiceDateFrom == null )
			{
				errString = itmDBAccessEJB.getErrorString("","VMINVDFNUL","","",conn);
				return errString;
			}
			else
			{
				if(invoiceDateTo != null)
				{
					if(invoiceDateFrom.after(invoiceDateTo))
					{
						errString = itmDBAccessEJB.getErrorString("","VMINVDFINV","","",conn);
			    		return errString;
					}
				}
			}
			
			if ( invoiceDateTo == null )
			{
				errString = itmDBAccessEJB.getErrorString("","VMINVDTNUL","","",conn);
				return errString;
			}
			else
			{
				if(invoiceDateFrom != null)
				{
					if(invoiceDateTo.before(invoiceDateFrom))       
					{
						errString = itmDBAccessEJB.getErrorString("","VMINVDTINV","","",conn);
			    		return errString;
					}
				}
			}
			
			
			getDataSql= " SELECT INVOICE.INVOICE_ID,INVOICE.TRAN_DATE,INVOICE.FIN_ENTITY,INVOICE.EFF_DATE,INVOICE.TRAN_MODE,INVOICE.SALE_ORDER," +
						" INVOICE.DESP_ID,INVOICE.DESP_DATE,INVOICE.SITE_CODE,INVOICE.CUST_CODE,INVOICE.CONFIRMED,INVOICE.CHG_DATE,INVOICE.CHG_USER, " +   
						" INVOICE.CHG_TERM,INVOICE.CONF_DATE,INVOICE.CURR_CODE,INVOICE.EXCH_RATE,INVOICE.CURR_CODE__INS,INVOICE.EXCH_RATE__INS," +
						" INVOICE.STAN_CODE__INIT,CUSTOMER.CUST_NAME,INVOICE.GP_NO,INVOICE.GP_DATE  FROM INVOICE,SORDER,CUSTOMER " +  
						" where ( INVOICE.invoice_id >= ?  and  INVOICE.invoice_id <= ?  ) " +
						" and ( invoice.cust_code >= ?  and  invoice.cust_code <= ?  ) " +
						" and ( invoice.site_code >= ?  and  invoice.site_code <= ?  ) " +
						" and ( invoice.tran_date >= ?  and  invoice.tran_date <= ?  ) " +
						" and ( invoice.sale_order = sorder.sale_order (+)) " +
						" and ( CUSTOMER.CUST_CODE = INVOICE.CUST_CODE ) " +
						" and ( sorder.order_mode <> 'B' or sorder.order_mode is null)  "; 
			
			
			System.out.println("Sql Fired :::::"+getDataSql.trim().length());
			if (getDataSql.trim().length()>0)
			{
				System.out.println("Sql Fired :::::"+getDataSql);					
				pstmt = conn.prepareStatement(getDataSql);
				pstmt.setString(1,invoiceIdFrom);
				pstmt.setString(2,invoiceIdTo);
				pstmt.setString(3,custCodeFrom);
				pstmt.setString(4,custCodeTo);
				pstmt.setString(5,siteCodeFrom);
				pstmt.setString(6,siteCodeTo);
				pstmt.setTimestamp(7,invoiceDateFrom); 
				pstmt.setTimestamp(8,invoiceDateTo);					
				
				System.out.println("QUERY IS IN PROCESS..........");
				rs1 = pstmt.executeQuery();
				System.out.println("QUERY  PROCESS FINISED.......");
				while(rs1.next()) 
				{
					//INVOICE_ID
					retTabSepStrBuff.append((rs1.getString("INVOICE_ID")==null?" ":rs1.getString("INVOICE_ID"))).append("\t");
					//TRAN_DATE
					retTabSepStrBuff.append((rs1.getString("TRAN_DATE")==null?" ":rs1.getString("TRAN_DATE"))).append("\t");
					//FIN_ENTITY
					retTabSepStrBuff.append((rs1.getString("FIN_ENTITY")==null?" ":rs1.getString("FIN_ENTITY"))).append("\t");
					//EFF_DATE
					if(rs1.getTimestamp("EFF_DATE")!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp("EFF_DATE").toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					//TRAN_MODE
					retTabSepStrBuff.append((rs1.getString("TRAN_MODE")==null?" ":rs1.getString("TRAN_MODE"))).append("\t");
					//SALE_ORDER
					retTabSepStrBuff.append((rs1.getString("SALE_ORDER")==null?" ":rs1.getString("SALE_ORDER"))).append("\t");
					//DESP_ID
					retTabSepStrBuff.append((rs1.getString("DESP_ID")==null?" ":rs1.getString("DESP_ID"))).append("\t");
					//DESP_DATE
					if(rs1.getTimestamp("DESP_DATE")!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp("DESP_DATE").toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					//SITE_CODE
					retTabSepStrBuff.append((rs1.getString("SITE_CODE")==null?" ":rs1.getString("SITE_CODE"))).append("\t");
					//CUST_CODE
					retTabSepStrBuff.append((rs1.getString("CUST_CODE")==null?" ":rs1.getString("CUST_CODE"))).append("\t");
					//CONFIRMED
					retTabSepStrBuff.append((rs1.getString("CONFIRMED")==null?" ":rs1.getString("CONFIRMED"))).append("\t");
					//CHG_DATE
					if(rs1.getTimestamp("CHG_DATE")!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp("CHG_DATE").toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					//CHG_USER
					retTabSepStrBuff.append((rs1.getString("CHG_USER")==null?" ":rs1.getString("CHG_USER"))).append("\t");
					//CHG_TERM
					retTabSepStrBuff.append((rs1.getString("CHG_TERM")==null?" ":rs1.getString("CHG_TERM"))).append("\t");
					//CURR_CODE
					retTabSepStrBuff.append((rs1.getString("CURR_CODE")==null?" ":rs1.getString("CURR_CODE"))).append("\t");
					//EXCH_RATE
					retTabSepStrBuff.append((rs1.getString("EXCH_RATE")==null?" ":rs1.getString("EXCH_RATE"))).append("\t");
					//CURR_CODE__INS
					retTabSepStrBuff.append((rs1.getString("CURR_CODE__INS")==null?" ":rs1.getString("CURR_CODE__INS"))).append("\t");
					//EXCH_RATE__INS
					retTabSepStrBuff.append((rs1.getString("EXCH_RATE__INS")==null?" ":rs1.getString("EXCH_RATE__INS"))).append("\t");
					//STAN_CODE__INIT
					retTabSepStrBuff.append((rs1.getString("STAN_CODE__INIT")==null?" ":rs1.getString("STAN_CODE__INIT"))).append("\t");
					//CUST_NAME
					retTabSepStrBuff.append((rs1.getString("CUST_NAME")==null?" ":rs1.getString("CUST_NAME"))).append("\t");
					//GP_NO
					retTabSepStrBuff.append((rs1.getString("GP_NO")==null?" ":rs1.getString("GP_NO"))).append("\t");
					//GP_DATE
					if(rs1.getTimestamp("GP_DATE")!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp("GP_DATE").toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					
					retTabSepStrBuff.append("\n");				
					count++;
					System.out.println("#####Counter:["+count+"]");
				}//END WHILE
				rs1.close();
				pstmt.close();
				rs1=null;
				pstmt=null;
				if (count == 0 )
				{
					errString = itmDBAccessEJB.getErrorString("","VTNOREC","","",conn);    
				}
			}
			else
			{
				System.out.println("Sql:::::is Null ::::::::::::::");
				errString = itmDBAccessEJB.getErrorString("","VTNOREC","","",conn);
			}
			
			System.out.println("retTabSepStrBuff:::["+retTabSepStrBuff.toString()+"]");
			
	
		
		}	//end of try	
		catch (SQLException e)
		{ 
			e.printStackTrace();
			System.out.println("SQLException :InvoiceDownload EJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :InvoiceDownload EJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{		
			try
			{		
				conn.close();
				conn = null;
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		if (getDataSql.trim().length()>0 && count > 0)
		{
			return retTabSepStrBuff.toString();	
		}
		else 
		{
			errString = itmDBAccessEJB.getErrorString("","VTNOREC","","",conn);
			return errString;
		}
	}	
	
	
}
