package ibase.webitm.ejb.dis;
/*
** Purpose : To calculate various type of taxes
*/
import java.rmi.RemoteException;
import java.util.*;
import java.sql.*;
import java.sql.Date;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.ejb.*;
import java.text.*;

import javax.naming.InitialContext;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.ejb.*;
import ibase.ejb.*;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3



//public class TaxCalculateEJB extends ProcessEJB implements SessionBean
@Stateless // added for ejb3
public class TaxCalculate extends ProcessEJB implements TaxCalculateLocal, TaxCalculateRemote
{
	String errString = "";
	String chgUser = "";
	String chgTerm = "";
	String dbName = "";
	String nextBalprd = "";
	String currBalprd = "";
	String batchNo="";
	transient GenericUtility genericUtility = null;
	transient ArrayList colNameList = null;
	transient ArrayList colTypeList = null;
	transient ArrayList currRecordList = null;
	transient java.sql.Timestamp currDate = null;
	transient java.sql.Timestamp nextYearCapitalDate = null;
	transient java.sql.Timestamp prevYearTranDate = null;
	ValidatorEJB validator = new ValidatorEJB();
	//Changed by rohan on 10-01-12 to create object of DistComman
	DistCommon discommon = new DistCommon();
	/*public void ejbCreate() throws RemoteException, CreateException
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
	}*/

	private void initialize()throws Exception
	{
		dbName = ProcessEJB.DB_NAME;
		System.out.println("dbName :["+dbName+"]");
		this.genericUtility = GenericUtility.getInstance();
		colNameList = new ArrayList();
		colTypeList = new ArrayList();
		currRecordList = new ArrayList();
		currDate = new java.sql.Timestamp(System.currentTimeMillis());
	}

	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String process(String tabSepFilterString, String tabSepDataString, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Called process(string, string).....");
		boolean isError = false;
		String resultString = null;
		//ITMDBAccess itmDBAccess = null; for ejb3
		ConnDriver connDriver = new ConnDriver();
		//ITMDBAccessLocal itmDBAccess = null ;
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		Connection conn = null;
		System.out.println("tabSepDataString :"+tabSepDataString);
		
		System.out.println("tabSepFilterString :"+tabSepFilterString);
		//System.out.println("windowName :"+windowName);
		//System.out.println("xtraParams :"+xtraParams);
		double adjAmtFrFlt =0;
		try
		{
			initialize();
			//itmDBAccess = getITMAccess();
			chgUser = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			// 16/03/10 manoharan
			//conn = itmDBAccess.getConnection();//This function is to connect with oracle....
			//conn.setAutoCommit(false);
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			// end 16/03/10 manoharan
			// 08-11-2006 manoharan read the metadata from file
			//populateMetadata(tabSepFilterString);
			//System.out.println("windowName :"+windowName);
			setMetaData(windowName);
			if (tabSepDataString.indexOf("\n") == -1 && tabSepDataString.length() > 0)
			{
				tabSepDataString =  tabSepDataString + "\n";
			}
			//  end 08-11-2006 manoharan
			//substring tabSepDataString from 0 to first occurence of "\n"
			//iterate till last record is reached
			//for each iteration call the foll.

			//System.out.println("tabSepDataString.indexOf :"+ tabSepDataString.indexOf("\n"));
			double totAdj=0;
			String tabSepRowDataStr = "";
			//**********************Code For Adj Amount Validation
			String FltStr[] = tabSepFilterString.split("\t");
			//String dataStr[] = tabSepDataString.split("\t");
			
			//Chandni to validate procDate
			String procDateStr = FltStr[8] ;
			System.out.println("procDateStr:::"+procDateStr);
			
			DateFormat formatter ;
            java.util.Date  procDate ;
            formatter = new SimpleDateFormat("dd/MM/yy");
            procDate = (java.util.Date)formatter.parse(procDateStr);
           	java.sql.Date pDate = new java.sql.Date(procDate.getTime());
			System.out.println("pDate::" +pDate );
			 //Chandni
			if(FltStr[5].equalsIgnoreCase("D"))
			{
					//15012007
					batchNo = FltStr[10];
					//System.out.println("Batch Number::::::::::::::::["+batchNo+"]");
					String tabSepDataStringForVal =null;
					String tabSepRowDataStrVal="";
					tabSepDataStringForVal =tabSepDataString;
					while(tabSepDataStringForVal.trim().length() > 0 && tabSepDataStringForVal.indexOf("\n") != -1 ) 
					{
						tabSepRowDataStrVal = tabSepDataStringForVal.substring(0, tabSepDataStringForVal.indexOf("\n"));
						populateCurrRecordList(tabSepRowDataStrVal + "\t");
						totAdj = totAdj+((Double)currRecordList.get(colNameList.indexOf("BAL_AMT"))).doubleValue();
						
						this.currRecordList.clear();
						//System.out.println("row val String 1 ["+ tabSepRowDataStrVal + "]");
						//System.out.println("before length 1["+ tabSepDataStringForVal.trim().length() + "]");
						//System.out.println("before String 1 ["+ tabSepDataStringForVal + "]");
						//System.out.println("Index of  1 ["+ tabSepDataStringForVal.indexOf("\n") + "]");
						tabSepDataStringForVal = tabSepDataStringForVal.substring(tabSepDataStringForVal.indexOf("\n") +1);
						//System.out.println("after String 1["+ tabSepDataStringForVal + "]");
						//System.out.println("after length 1["+ tabSepDataStringForVal.trim().length() + "]");
						//System.out.println("After Index of  2 ["+ tabSepDataStringForVal.indexOf("\n") + "]");
						tabSepRowDataStrVal = null;
						//if (tabSepDataStringForVal.trim().length() > 0 && tabSepDataStringForVal.indexOf("\n") != -1)
						//{
						//	System.out.println("after String 2 ["+ tabSepDataStringForVal + "]");
						//	
						//}
						//else
						//{
						//	System.out.println("Breaking loop ");
						//   break;
						//}
					

					}
					tabSepDataStringForVal=null;
					if(FltStr[8].equals(""))FltStr[8]="0";
					adjAmtFrFlt = Double.parseDouble(FltStr[8]);
					System.out.println("Total Adjusted Amount of Brow:::["+totAdj+"]");
					System.out.println("Total Adjusted Amount From Filter:::["+adjAmtFrFlt+"]");
			}
			//CHEAK TO BE DONE AT DEBIT TIME
			if(FltStr[5].equalsIgnoreCase("D") && Math.abs(totAdj)>Math.abs(adjAmtFrFlt)  )
			{

				resultString = itmDBAccess.getErrorString("TaxProcess","VTTAXADJ1","",errString,conn);
			}
			else
			{
				initialize();
				setMetaData(windowName);
				//***End of Validation***
				tabSepRowDataStr = "";
				int recCtr = 0;
				while(tabSepDataString.indexOf("\n") != -1)
				{
					
					tabSepRowDataStr = tabSepDataString.substring(0, tabSepDataString.indexOf("\n"));
					recCtr++;
					System.out.println("Processing Row [" + recCtr + "]");
					//System.out.println("tabSepRowDataStr :"+tabSepRowDataStr+":");
					populateCurrRecordList(tabSepRowDataStr + "\t");
					//added on 07012007
					setDates(conn);
					//setDates();
					//Chandni To show errors--
					//updateTaxProcessed(conn);
					resultString = updateTaxProcessed(pDate,conn);
					System.out.println("resultString eulas:"+resultString);
					//if(resultString != null && resultString.length() > 0)
					if ((resultString.contains("VTEXCDATE")) || (resultString.contains("VXCDATE")))
					{
						System.out.println("inside resultString eulas sssss"+resultString);
						return resultString ;
						
					}
					else
					{
						updateTaxProcessTrace(conn);
						updateTaxProcessBal(conn);
					}
					this.currRecordList.clear();
					//remove the row that has already been processed
					tabSepDataString = tabSepDataString.substring(tabSepDataString.indexOf("\n") +1);
					
				}
				if(!(resultString.contains("VTEXCDATE") ||(resultString.contains("VXCDATE"))))
				{
					String userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
					resultString = itmDBAccess.getErrorString("TaxProcess","DSTAXPROC",userId,errString,conn);
				}
				//Chandni
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :TaxCalculateEJB :process(String xmlString,String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			resultString = this.genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception sqle)
			{
				throw new ITMException(sqle);
			}
		}
		System.out.println("resultString (empty string signifies valid processing):["+resultString+"]");
		return resultString;
	}
	
	public String chkDateVal(java.sql.Date refDate,java.sql.Date procDate,Connection conn)  throws ITMException
	{
		SimpleDateFormat simpleDateformat=new SimpleDateFormat("yyyy");
		SimpleDateFormat simpleformat= new SimpleDateFormat("dd/MM/yy");
		Timestamp sysDate = new Timestamp(System.currentTimeMillis());
		String resultString ="",varValue="";
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		try
		{
			// CHECKING WHETHER TRAN_DATE FOR REF_ID HAS TO BE CHECKED at the time of process
			//IF VAR VALUE IN DISPARM IS Y CHECK IN DATE AND IF 'N'
			// THEN BYPASS CHECKING.
			varValue  = validator.getEnvDis("999999", "TAX_CALC_DATE", conn);
			
			if(refDate.after(procDate))
			{
				System.out.println("inside refDate.after(procDate)");
				resultString = itmDBAccess.getErrorString("TaxProcess","VXCDATE","",errString,conn);
			}
			if(!(resultString.contains("VXCDATE")))
			{
				if (varValue.equalsIgnoreCase("N"))
				{
					int month = (refDate.getMonth()+1);
					String yearStr = simpleDateformat.format(refDate);
					int year = Integer.parseInt(yearStr);
					if (month == 12 ) 
					{
						year = year + 1 ;
						month = 00 ;
					}
					month = month + 1 ;
					String strDate = (month + "/07/" + year) ;
					java.util.Date date = new java.util.Date(strDate);
					java.util.Date utilDate = new java.util.Date();
					if (utilDate.after(date))
					 {
						 resultString = itmDBAccess.getErrorString("TaxProcess","VTEXCDATE","",errString,conn);
						 return resultString;
					 }
				}
			}
		} // end of try
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return resultString;
	}
	public String process(Document dom, Document dom2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		try
		{
		}
		catch (Exception e)
		{
			System.out.println("Exception :TaxCalculateEJB :process(Document dom, Document dom2, String windowName, String xtraParams):" + e.getMessage() + ":");
			this.errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return null;
	}
	//private void updateTaxProcessed(Connection conn)throws ITMException //commented by Chandni
	private String updateTaxProcessed(java.sql.Date procDate,Connection conn)throws ITMException
	{
		//common logic
		//if debit
		//else credit
		//final execution of update/insert

		ResultSet rsSelectTaxProcessed = null;
		ResultSet rsSelectSrNo = null; // 14/03/08 manoharan
		PreparedStatement pstmtSelectSrNo = null;
		PreparedStatement pstmtSelectTaxProcessed = null;
		PreparedStatement pstmtInsertTaxProcessed = null;
		PreparedStatement pstmtInsertCenvatCrCapital = null;
		PreparedStatement pstmtUpdateTaxProcessed = null;
		int cntTaxProcessed = 0;
		String itemCode = "";
		String refSer = "";
		String refId = "";
		String refLine = "";
		String tranType = "";
		String tranIdProc = "";
		String srNo = "";
		
		//Changed by Rohan on 10/01/12 to define variable.start
		String balGroup = "";
		boolean isCapitalItem = false;
		//Changed by Rohan on 10/01/12 to define variable.end
			    
		double adjAmt = 0.0;
		double addlExcise = 0.0; // 06-01-2007 manoharan new column added to be updated
		
		String balType = (String)this.currRecordList.get(colNameList.indexOf("BAL_TYPE"));
		String drcrType = (String)this.currRecordList.get(colNameList.indexOf("DRCR_TYPE"));
		adjAmt = ((Double)this.currRecordList.get(colNameList.indexOf("BAL_AMT"))).doubleValue();
		
		//Chandni
		java.sql.Date refDate = (Date) this.currRecordList.get(colNameList.indexOf("REF_DATE"));
		String resultString ="";
		//End of chandni
		
		String sqlAcctprd = "",	ProccYear = "" ;
		PreparedStatement pstmtAcctprd = null;
		ResultSet rsAcctprd = null;
		
		try
		{
			System.out.println("refDate:::["+refDate+"]");
			System.out.println("procDate::"+procDate);
			resultString = chkDateVal(refDate,procDate,conn);
			//if stmt added by chandni -- if there is an error then bypass the below conditions
			if (!((resultString.contains("VTEXCDATE")) || (resultString.contains("VXCDATE"))))
			{
			
			// 06-01-2007 manoharan addl_excise to be updated
			addlExcise = ((Double)this.currRecordList.get(colNameList.indexOf("ADDL_EXCISE"))).doubleValue();
			/*if (addlExcise == null )
			{
				addlExcise = 0.00;
			}*/
			// end 06-01-2007 manoharan addl_excise to be updated
			StringBuffer sqlSelectTaxProcessed = new StringBuffer("SELECT COUNT(1) FROM TAX_PROCESSED WHERE BAL_GROUP = ? AND BAL_TYPE = ? AND BAL_PRD = ? AND TRAN_DATE = ?");
			if(drcrType.trim().equals("D"))
			{
				sqlSelectTaxProcessed.append("AND BAL_GROUP__ADJ = ?");
			}
			if(balType.trim().equals("D"))
			{
				sqlSelectTaxProcessed.append("AND REF_SER = ? AND REF_ID = ?");
			}
			else if(balType.trim().equals("I"))
			{
				sqlSelectTaxProcessed.append("AND ITEM_CODE = ?");
				sqlSelectTaxProcessed.append("AND REF_SER = ? AND REF_ID = ?");
				sqlSelectTaxProcessed.append("AND REF_LINE = '"+(String)currRecordList.get(colNameList.indexOf("REF_LINE"))+"'");
			}

			pstmtSelectTaxProcessed = conn.prepareStatement(sqlSelectTaxProcessed.toString());

			// 06-01-2007 manoharan addl_excise to be updated
			//StringBuffer sqlInsertTaxProcessed = new StringBuffer("INSERT INTO TAX_PROCESSED (TRAN_ID, TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, DRCR_FLAG, NET_AMT, DR_AMT, CR_AMT, TAX_CHAP, ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, TAX_AMT, INVOICE_NO, TAX_CODE, CHG_DATE, CHG_USER, CHG_TERM, REF_DOC_NO, REF_DOC_DATE, LOT_SL, MATERIAL_CATEGORY, REF_ID,REF_DATE,REF_LINE,TRAN_TYPE, SR_NO,BAL_GROUP__ADJ, ADJ_AMT ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			//ADDED ON 15012007(BATCH_NO)
			StringBuffer sqlInsertTaxProcessed =null;
			if(drcrType.trim().equalsIgnoreCase("D"))
			{
				System.out.println("Enter in insert1");
			 	sqlInsertTaxProcessed = new StringBuffer("INSERT INTO TAX_PROCESSED (TRAN_ID, TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, DRCR_FLAG, NET_AMT, DR_AMT, CR_AMT, TAX_CHAP, ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, TAX_AMT, INVOICE_NO, TAX_CODE, CHG_DATE, CHG_USER, CHG_TERM, REF_DOC_NO, REF_DOC_DATE, LOT_SL, MATERIAL_CATEGORY, REF_ID,REF_DATE,REF_LINE,TRAN_TYPE, SR_NO,BAL_GROUP__ADJ, ADJ_AMT, ADDL_EXCISE,BATCH_NO ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			}
			else
			{
				System.out.println("Enter in insert");
				sqlInsertTaxProcessed = new StringBuffer("INSERT INTO TAX_PROCESSED (TRAN_ID, TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, DRCR_FLAG, NET_AMT, DR_AMT, CR_AMT, TAX_CHAP, ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, TAX_AMT, INVOICE_NO, TAX_CODE, CHG_DATE, CHG_USER, CHG_TERM, REF_DOC_NO, REF_DOC_DATE, LOT_SL, MATERIAL_CATEGORY, REF_ID,REF_DATE,REF_LINE,TRAN_TYPE, SR_NO,BAL_GROUP__ADJ, ADJ_AMT, ADDL_EXCISE ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			}
			// end 06-01-2007 manoharan addl_excise to be updated
			pstmtInsertTaxProcessed = conn.prepareStatement(sqlInsertTaxProcessed.toString());

			//chandni -start
			StringBuffer sqlInsertCenCrCapital = null;
			if(drcrType.trim().equalsIgnoreCase("D"))
			{
			 	sqlInsertCenCrCapital = new StringBuffer("INSERT INTO CENVAT_CR_CAPITAL (TRAN_ID, TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, DRCR_FLAG, NET_AMT, DR_AMT, CR_AMT, TAX_CHAP, ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, TAX_AMT, INVOICE_NO, TAX_CODE, CHG_DATE, CHG_USER, CHG_TERM, REF_DOC_NO, REF_DOC_DATE, LOT_SL, MATERIAL_CATEGORY, REF_ID,REF_DATE,REF_LINE,TRAN_TYPE, SR_NO,BAL_GROUP__ADJ, ADJ_AMT, ADDL_EXCISE,PROCESS_YEAR,CONFIRMED,BATCH_NO ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			}
			else
			{
				sqlInsertCenCrCapital = new StringBuffer("INSERT INTO CENVAT_CR_CAPITAL (TRAN_ID, TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, DRCR_FLAG, NET_AMT, DR_AMT, CR_AMT, TAX_CHAP, ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, TAX_AMT, INVOICE_NO, TAX_CODE, CHG_DATE, CHG_USER, CHG_TERM, REF_DOC_NO, REF_DOC_DATE, LOT_SL, MATERIAL_CATEGORY, REF_ID,REF_DATE,REF_LINE,TRAN_TYPE, SR_NO,BAL_GROUP__ADJ, ADJ_AMT, ADDL_EXCISE,PROCESS_YEAR,CONFIRMED ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			}
			pstmtInsertCenvatCrCapital = conn.prepareStatement(sqlInsertCenCrCapital.toString());
           //Chandni - end
			
			
			
			// 06-01-2007 manoharan addl_excise to be updated
			//StringBuffer sqlUpdateTaxProcessed = new StringBuffer("UPDATE TAX_PROCESSED SET ADJ_AMT = ADJ_AMT + ? WHERE BAL_GROUP = ? AND BAL_TYPE = ? AND BAL_PRD = ? AND TRAN_DATE = ?");
			//ADDED ON 15012007(BATCH_NO)
			StringBuffer sqlUpdateTaxProcessed =null;
			if(drcrType.trim().equalsIgnoreCase("D"))
			{
			 	sqlUpdateTaxProcessed = new StringBuffer("UPDATE TAX_PROCESSED SET ADJ_AMT = ADJ_AMT + ?,ADDL_EXCISE = ADDL_EXCISE + ?,TAX_AMT = ? WHERE BAL_GROUP = ? AND BAL_TYPE = ? AND BAL_PRD = ? AND TRAN_DATE = ? AND BATCH_NO =?");//UPDATED BY NISAR ON 04/02/08
			}
			else
			{
				sqlUpdateTaxProcessed = new StringBuffer("UPDATE TAX_PROCESSED SET ADJ_AMT = ADJ_AMT + ?,ADDL_EXCISE = ADDL_EXCISE + ?,TAX_AMT = ? WHERE BAL_GROUP = ? AND BAL_TYPE = ? AND BAL_PRD = ? AND TRAN_DATE = ? ");

			}

			// end 06-01-2007 manoharan addl_excise to be updated
			if(drcrType.trim().equals("D"))
			{
				sqlUpdateTaxProcessed.append("AND BAL_GROUP__ADJ = ?");
			}
			if(balType.trim().equals("D"))
			{
				sqlUpdateTaxProcessed.append("AND REF_SER = ? AND REF_ID = ?");
			}
			else if(balType.trim().equals("I"))
			{
				sqlUpdateTaxProcessed.append("AND ITEM_CODE = ?");
				sqlUpdateTaxProcessed.append("AND REF_SER = ? AND REF_ID = ?");
				sqlUpdateTaxProcessed.append("AND REF_LINE = '"+(String)currRecordList.get(colNameList.indexOf("REF_LINE"))+"'");
			}
			pstmtUpdateTaxProcessed = conn.prepareStatement(sqlUpdateTaxProcessed.toString());
			
			//ADDED 30082006
			// 03-11-2006 manohar in case of debit bal_group__adj to be considered
			// as can be partially adjusted against different bal_group
			//PreparedStatement pstmtSelectSrNo = conn.prepareStatement("SELECT SR_NO FROM TAX_PROCESSED WHERE REF_SER = ? AND REF_ID = ? AND TRAN_DATE = ?");
			// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
			// in case of nor mal cases

			//if(drcrType.trim().equals("D"))
			//{
			//	pstmtSelectSrNo = conn.prepareStatement("SELECT SR_NO FROM TAX_PROCESSED WHERE REF_SER = ? AND REF_ID = ? AND TRAN_DATE = ? AND BAL_GROUP__ADJ = ?");
			//}
			//else
			//{
				pstmtSelectSrNo = conn.prepareStatement("SELECT SR_NO FROM TAX_PROCESSED WHERE REF_SER = ? AND REF_ID = ? AND TRAN_DATE = ?");
			//}
			// end 27-02-2007 manoharan

			if (balType.trim().equals("D")) //Document entry
			{
				refSer = (String)currRecordList.get(colNameList.indexOf("REF_SER"));
				refId = (String)currRecordList.get(colNameList.indexOf("REF_ID"));
				refLine = "  1";
			}
			else if (balType.trim().equals("I"))//Item entry
			{
				itemCode = (String)currRecordList.get(colNameList.indexOf("ITEM_CODE"));
				refLine = (String)currRecordList.get(colNameList.indexOf("REF_LINE"));
				refSer = (String)currRecordList.get(colNameList.indexOf("REF_SER"));
				refId = (String)currRecordList.get(colNameList.indexOf("REF_ID"));
			}
			
			//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
			balGroup = (String) currRecordList.get(colNameList.indexOf("BAL_GROUP"));  
		    isCapitalItem = isCapitalItem(balGroup, conn);
		    //Changed by Rohan on 1-10-12 to set half amount in case of capital items.end   
		   
		    
			/***************************** capital items ****************************/
			tranType = (String)currRecordList.get(colNameList.indexOf("TRAN_TYPE"));
			
			if(tranType.trim().equals("C"))
			{
				//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
				//adjAmt = adjAmt/2;
				if(isCapitalItem)
				{
					adjAmt = adjAmt/2;	
				}
				
				pstmtSelectTaxProcessed.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtSelectTaxProcessed.setString(2, balType);			//balance type
				pstmtSelectTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
				pstmtSelectTaxProcessed.setObject(4, nextYearCapitalDate);			//next year capital date
				if(drcrType.trim().equals("D"))
				{
					pstmtSelectTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
					if(balType.trim().equals("D"))
					{
						pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(7, refId);				//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtSelectTaxProcessed.setString(6, itemCode);
						pstmtSelectTaxProcessed.setString(7, refSer);//reference series
						pstmtSelectTaxProcessed.setString(8, refId);//item code
					}
				}
				else
				{
					if(balType.trim().equals("D"))
					{
						pstmtSelectTaxProcessed.setString(5, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(6, refId);			//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtSelectTaxProcessed.setString(5, itemCode);		//item code
						pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(7, refId);			//reference id
					}
				}
				rsSelectTaxProcessed = pstmtSelectTaxProcessed.executeQuery();
				if (rsSelectTaxProcessed.next())
				{
						cntTaxProcessed = rsSelectTaxProcessed.getInt(1);
				}
				rsSelectTaxProcessed.close();	// 14/03/08 manoharan
				rsSelectTaxProcessed = null;	// 14/03/08 manoharan
				if (cntTaxProcessed==0)
				{
					//***tranIdProc = getUniqueKey(conn, "T_tax_processed", nextYearCapitalDate.toString());
					//********added latter
					//tranIdProc = getUniqueKey(conn, "T_tax_processed", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
					/*  Commented by Chandni 23-jun-2012
					tranIdProc = getUniqueKey(conn, "T_tax_processed", currRecordList.get(colNameList.indexOf("PROC_DATE//")).toString());
								
					//System.out.println("1st tran id/srno " + tranIdProc);
					pstmtInsertTaxProcessed.setString(1, tranIdProc);																		//transaction id
					pstmtInsertTaxProcessed.setTimestamp(2, nextYearCapitalDate);
				//	***********added later												//transaction date
					//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
					//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));													//transaction date

					pstmtInsertTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
					pstmtInsertTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("DOC_TYPE")));		//document type
					pstmtInsertTaxProcessed.setString(5, balType);																			//balance type
					pstmtInsertTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
					pstmtInsertTaxProcessed.setString(7, refSer);																				//reference series
					pstmtInsertTaxProcessed.setObject(8, currRecordList.get(colNameList.indexOf("DRCR_FLAG")));		//dr / cr flag
					pstmtInsertTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("NET_AMT")));			//net amount
					pstmtInsertTaxProcessed.setObject(10, currRecordList.get(colNameList.indexOf("DR_AMT")));			//debit amount
					pstmtInsertTaxProcessed.setObject(11, currRecordList.get(colNameList.indexOf("CR_AMT")));			//credit amount
					pstmtInsertTaxProcessed.setObject(12, currRecordList.get(colNameList.indexOf("TAX_CHAP")));		//tax chapter
					pstmtInsertTaxProcessed.setString(13, itemCode);																		//item code
					pstmtInsertTaxProcessed.setObject(14, currRecordList.get(colNameList.indexOf("SITE_CODE")));		//site code
					pstmtInsertTaxProcessed.setObject(15, currRecordList.get(colNameList.indexOf("QTY_RECD")));		//quantity received
					pstmtInsertTaxProcessed.setObject(16, currRecordList.get(colNameList.indexOf("SUPP_CODE")));	//supplier code
					pstmtInsertTaxProcessed.setObject(17, currRecordList.get(colNameList.indexOf("EXC_REF")));			//exc referance
					pstmtInsertTaxProcessed.setObject(18, currRecordList.get(colNameList.indexOf("CLOSING_STOCK")));	//closing stock
					pstmtInsertTaxProcessed.setObject(19, currRecordList.get(colNameList.indexOf("SITE_CODE__SUPP")));	//site code supplier
					pstmtInsertTaxProcessed.setObject(20, currRecordList.get(colNameList.indexOf("SITE_CODE__TRAN")));	//site code transaction
					pstmtInsertTaxProcessed.setObject(21, currRecordList.get(colNameList.indexOf("TRAN_TYPE_TRANSACTION")));	//tran type transaction
					pstmtInsertTaxProcessed.setString(22, "Y");	//confirmation flag
					pstmtInsertTaxProcessed.setObject(23, currRecordList.get(colNameList.indexOf("CHAP_HEADING")));	//chapter heading
					pstmtInsertTaxProcessed.setObject(24, currRecordList.get(colNameList.indexOf("LOT_NO")));				//lot number
					pstmtInsertTaxProcessed.setObject(25, currRecordList.get(colNameList.indexOf("TAX_AMT")));			//tax amount
					pstmtInsertTaxProcessed.setObject(26, currRecordList.get(colNameList.indexOf("INVOICE_NO")));		//invoice number
					pstmtInsertTaxProcessed.setObject(27, currRecordList.get(colNameList.indexOf("TAX_CODE")));			//tax code
					pstmtInsertTaxProcessed.setTimestamp(28, this.currDate);									//change date
					pstmtInsertTaxProcessed.setString(29, chgUser);																					//change user
					pstmtInsertTaxProcessed.setString(30, chgTerm);																					//change terminal number
					pstmtInsertTaxProcessed.setObject(31, currRecordList.get(colNameList.indexOf("REF_DOC_NO")));		//referance document number
					pstmtInsertTaxProcessed.setObject(32, currRecordList.get(colNameList.indexOf("REF_DOC_DATE")));	//referance document date
					pstmtInsertTaxProcessed.setObject(33, currRecordList.get(colNameList.indexOf("LOT_SL")));				//lot sl
					pstmtInsertTaxProcessed.setObject(34, currRecordList.get(colNameList.indexOf("MATERIAL_CATEGORY")));				//material category
					pstmtInsertTaxProcessed.setString(35, refId);									//Ref Id
					pstmtInsertTaxProcessed.setObject(36, currRecordList.get(colNameList.indexOf("REF_DATE")));				//Ref Date
					pstmtInsertTaxProcessed.setString(37, refLine);																			//referance line number
					pstmtInsertTaxProcessed.setObject(38, currRecordList.get(colNameList.indexOf("TRAN_TYPE")));			//Tran Type
					
					pstmtSelectSrNo.setString(1,refSer);
					pstmtSelectSrNo.setString(2,refId);
					//ADDED 30082006
					pstmtSelectSrNo.setTimestamp(3, nextYearCapitalDate);
					// 03-11-2006 manohar in case of debit bal_group__adj to be considered
					// as can be partially adjusted against different bal_group
					// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
					// in case of nor mal cases
					//if(drcrType.trim().equals("D"))
					//{
					//	pstmtSelectSrNo.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
					//}
					// end 27-02-2007 manoharan
					// end 03-11-2006 manoharan
					rsSelectSrNo = pstmtSelectSrNo.executeQuery();
					if(rsSelectSrNo.next())
					{
						srNo = rsSelectSrNo.getString("SR_NO");
					}
					else
					{
						srNo = getUniqueKey(conn,"t_tax_process_sr_no", nextYearCapitalDate.toString());
						//**********Added latter
						//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
						//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
						//System.out.println("2 tran id/srno " + srNo);
					}
					rsSelectSrNo.close(); // 14/03/08 manoharan
					rsSelectSrNo = null; // 14/03/08 manoharan
					pstmtInsertTaxProcessed.setString(39, srNo);
					pstmtInsertTaxProcessed.setObject(40, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
					pstmtInsertTaxProcessed.setDouble(41, adjAmt);			//adj amt
					pstmtInsertTaxProcessed.setDouble(42, addlExcise);	// 06-01-2006 manoharan new column
						//	ADDED ON 15012007(BATCH_NO)
					if (drcrType.trim().equals("D"))
					{
						pstmtInsertTaxProcessed.setString(43, batchNo); //BATCH_NO
					}
					pstmtInsertTaxProcessed.executeUpdate();
					*/
					//Comment end Chandni
					//Added by chandni 23-jun-2012 -- Change win_name 
										
					sqlAcctprd = "SELECT CODE FROM ACCTPRD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
					pstmtAcctprd = conn.prepareStatement(sqlAcctprd.toString());
					pstmtAcctprd.setTimestamp(1, nextYearCapitalDate);
					rsAcctprd = pstmtAcctprd.executeQuery();
					if (rsAcctprd.next())
					{
						ProccYear = rsAcctprd.getString(1);
					}
					rsAcctprd.close();
					rsAcctprd = null; 
					
					tranIdProc = getUniqueKey(conn, "w_cenvat_cr_capital", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
					
					//System.out.println("1st tran id/srno " + tranIdProc);
					//Changed by Rohan on 2-10-12 to insert in case of capital item only.start
					
					if(isCapitalItem)
					{
						pstmtInsertCenvatCrCapital.setString(1, tranIdProc);																		//transaction id
						pstmtInsertCenvatCrCapital.setTimestamp(2, nextYearCapitalDate);
					//	***********added later												//transaction date
						//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
						//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));													//transaction date
	
						pstmtInsertCenvatCrCapital.setObject(3, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
						pstmtInsertCenvatCrCapital.setObject(4, currRecordList.get(colNameList.indexOf("DOC_TYPE")));		//document type
						pstmtInsertCenvatCrCapital.setString(5, balType);																			//balance type
						pstmtInsertCenvatCrCapital.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
						pstmtInsertCenvatCrCapital.setString(7, refSer);																				//reference series
						pstmtInsertCenvatCrCapital.setObject(8, currRecordList.get(colNameList.indexOf("DRCR_FLAG")));		//dr / cr flag
						pstmtInsertCenvatCrCapital.setObject(9, currRecordList.get(colNameList.indexOf("NET_AMT")));			//net amount
						pstmtInsertCenvatCrCapital.setObject(10, currRecordList.get(colNameList.indexOf("DR_AMT")));			//debit amount
						pstmtInsertCenvatCrCapital.setObject(11, currRecordList.get(colNameList.indexOf("CR_AMT")));			//credit amount
						pstmtInsertCenvatCrCapital.setObject(12, currRecordList.get(colNameList.indexOf("TAX_CHAP")));		//tax chapter
						pstmtInsertCenvatCrCapital.setString(13, itemCode);																		//item code
						pstmtInsertCenvatCrCapital.setObject(14, currRecordList.get(colNameList.indexOf("SITE_CODE")));		//site code
						pstmtInsertCenvatCrCapital.setObject(15, currRecordList.get(colNameList.indexOf("QTY_RECD")));		//quantity received
						pstmtInsertCenvatCrCapital.setObject(16, currRecordList.get(colNameList.indexOf("SUPP_CODE")));	//supplier code
						pstmtInsertCenvatCrCapital.setObject(17, currRecordList.get(colNameList.indexOf("EXC_REF")));			//exc referance
						pstmtInsertCenvatCrCapital.setObject(18, currRecordList.get(colNameList.indexOf("CLOSING_STOCK")));	//closing stock
						pstmtInsertCenvatCrCapital.setObject(19, currRecordList.get(colNameList.indexOf("SITE_CODE__SUPP")));	//site code supplier
						pstmtInsertCenvatCrCapital.setObject(20, currRecordList.get(colNameList.indexOf("SITE_CODE__TRAN")));	//site code transaction
						pstmtInsertCenvatCrCapital.setObject(21, currRecordList.get(colNameList.indexOf("TRAN_TYPE_TRANSACTION")));	//tran type transaction
						pstmtInsertCenvatCrCapital.setString(22, "Y");	//confirmation flag
						pstmtInsertCenvatCrCapital.setObject(23, currRecordList.get(colNameList.indexOf("CHAP_HEADING")));	//chapter heading
						pstmtInsertCenvatCrCapital.setObject(24, currRecordList.get(colNameList.indexOf("LOT_NO")));				//lot number
						pstmtInsertCenvatCrCapital.setObject(25, currRecordList.get(colNameList.indexOf("TAX_AMT")));			//tax amount
						pstmtInsertCenvatCrCapital.setObject(26, currRecordList.get(colNameList.indexOf("INVOICE_NO")));		//invoice number
						pstmtInsertCenvatCrCapital.setObject(27, currRecordList.get(colNameList.indexOf("TAX_CODE")));			//tax code
						pstmtInsertCenvatCrCapital.setTimestamp(28, this.currDate);									//change date
						pstmtInsertCenvatCrCapital.setString(29, chgUser);																					//change user
						pstmtInsertCenvatCrCapital.setString(30, chgTerm);																					//change terminal number
						pstmtInsertCenvatCrCapital.setObject(31, currRecordList.get(colNameList.indexOf("REF_DOC_NO")));		//referance document number
						pstmtInsertCenvatCrCapital.setObject(32, currRecordList.get(colNameList.indexOf("REF_DOC_DATE")));	//referance document date
						pstmtInsertCenvatCrCapital.setObject(33, currRecordList.get(colNameList.indexOf("LOT_SL")));				//lot sl
						pstmtInsertCenvatCrCapital.setObject(34, currRecordList.get(colNameList.indexOf("MATERIAL_CATEGORY")));				//material category
						pstmtInsertCenvatCrCapital.setString(35, refId);									//Ref Id
						pstmtInsertCenvatCrCapital.setObject(36, currRecordList.get(colNameList.indexOf("REF_DATE")));				//Ref Date
						pstmtInsertCenvatCrCapital.setString(37, refLine);																			//referance line number
						pstmtInsertCenvatCrCapital.setObject(38, currRecordList.get(colNameList.indexOf("TRAN_TYPE")));			//Tran Type
						
						
						pstmtSelectSrNo.setString(1,refSer);
						pstmtSelectSrNo.setString(2,refId);
						//ADDED 30082006
						pstmtSelectSrNo.setTimestamp(3, nextYearCapitalDate);
						// 03-11-2006 manohar in case of debit bal_group__adj to be considered
						// as can be partially adjusted against different bal_group
						// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
						// in case of nor mal cases
						//if(drcrType.trim().equals("D"))
						//{
						//	pstmtSelectSrNo.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
						//}
						// end 27-02-2007 manoharan
						// end 03-11-2006 manoharan
						rsSelectSrNo = pstmtSelectSrNo.executeQuery();
						if(rsSelectSrNo.next())
						{
							srNo = rsSelectSrNo.getString("SR_NO");
						}
						else
						{
							srNo = getUniqueKey(conn,"t_tax_process_sr_no", nextYearCapitalDate.toString());
							//**********Added latter
							//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
							//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
							//System.out.println("2 tran id/srno " + srNo);
						}
						rsSelectSrNo.close(); // 14/03/08 manoharan
						rsSelectSrNo = null; // 14/03/08 manoharan
						pstmtInsertCenvatCrCapital.setString(39, srNo);
						pstmtInsertCenvatCrCapital.setObject(40, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
						pstmtInsertCenvatCrCapital.setDouble(41, adjAmt);			//adj amt
						pstmtInsertCenvatCrCapital.setDouble(42, addlExcise);	// 06-01-2006 manoharan new column
						pstmtInsertCenvatCrCapital.setString(43,ProccYear);
						//pstmtInsertCenvatCrCapital.setDate
						pstmtInsertCenvatCrCapital.setString(44,"N");
						//	ADDED ON 15012007(BATCH_NO)
						if (drcrType.trim().equals("D"))
						{
							pstmtInsertCenvatCrCapital.setString(45, batchNo); //BATCH_NO
						}				
						pstmtInsertCenvatCrCapital.executeUpdate();
					}
					//Changed by Rohan on 2-10-12 to insert in case of capital item only.end
					//ended by chandni
				}//if (cntTaxProcessed==0)
				else
				{
					pstmtUpdateTaxProcessed.setDouble(1, adjAmt);//adj amt
					pstmtUpdateTaxProcessed.setDouble(2, addlExcise);	// 06-01-2006 manoharan new column
					pstmtUpdateTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("TAX_AMT")));//ADDED BY NISAR ON 04/02/08
					pstmtUpdateTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
					pstmtUpdateTaxProcessed.setString(5, balType);			//balance type
					pstmtUpdateTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
					pstmtUpdateTaxProcessed.setObject(7, nextYearCapitalDate);			//next year capital date
					if(drcrType.trim().equals("D"))
					{
						pstmtUpdateTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
						if(balType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(10, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(11, refId);
							if(drcrType.trim().equals("D"))
							{
							pstmtUpdateTaxProcessed.setString(8, batchNo);
							}				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtUpdateTaxProcessed.setString(10, itemCode);			//item code
							pstmtUpdateTaxProcessed.setString(11, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(12, refId);
							if(drcrType.trim().equals("D"))
							{
							pstmtUpdateTaxProcessed.setString(8, batchNo);
							}
						}
					}
					else
					{
						if(balType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(8, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(9, refId);				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtUpdateTaxProcessed.setString(8, itemCode);			//item code
							pstmtUpdateTaxProcessed.setString(9, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(10, refId);
						}
					}
					//ADDED ON 15012007

					pstmtUpdateTaxProcessed.executeUpdate();
				}
			}
			/***************************** end capital items ****************************/
			/***************************** common logic ****************************/
			pstmtSelectTaxProcessed.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
			pstmtSelectTaxProcessed.setString(2, balType);			//balance type
			pstmtSelectTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
			//***********added latter
			//pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
			pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("PROC_DATE")));			//tran date
			if(drcrType.trim().equals("D"))
			{
				pstmtSelectTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
				if(balType.trim().equals("D"))
				{
					pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
					pstmtSelectTaxProcessed.setString(7, refId);				//reference id
				}
				else if(balType.trim().equals("I"))
				{
					pstmtSelectTaxProcessed.setString(6, itemCode);			//item code
					pstmtSelectTaxProcessed.setString(7, refSer);			//reference series
					pstmtSelectTaxProcessed.setString(8, refId);				//reference id
				}
			}
			else
			{
				if(balType.trim().equals("D"))
				{
					pstmtSelectTaxProcessed.setString(5, refSer);			//reference series
					pstmtSelectTaxProcessed.setString(6, refId);				//reference id
				}
				else if(balType.trim().equals("I"))
				{
					pstmtSelectTaxProcessed.setString(5, itemCode);			//item code
					pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
					pstmtSelectTaxProcessed.setString(7, refId);				//reference id
				}
			}
			rsSelectTaxProcessed = pstmtSelectTaxProcessed.executeQuery();
			if (rsSelectTaxProcessed.next())
			{
				cntTaxProcessed = rsSelectTaxProcessed.getInt(1);
			}
			rsSelectTaxProcessed.close();	// 14/03/08 manoharan
			rsSelectTaxProcessed = null;	// 14/03/08 manoharan
			if (cntTaxProcessed == 0)
			{
				//**********added latter
				//tranIdProc = getUniqueKey(conn,"T_tax_processed", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
				tranIdProc = getUniqueKey(conn,"T_tax_processed", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
				//System.out.println("3 tran id/srno " + tranIdProc);
				pstmtInsertTaxProcessed.setString(1, tranIdProc);//transaction id
				//**************added latter
				//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));//transaction date
			//	pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));
				pstmtInsertTaxProcessed.setDate(2,procDate);
				pstmtInsertTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtInsertTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("DOC_TYPE")));		//document type
				pstmtInsertTaxProcessed.setString(5, balType);			//balance type
				pstmtInsertTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
				pstmtInsertTaxProcessed.setString(7, refSer);			//referance series
				pstmtInsertTaxProcessed.setObject(8, currRecordList.get(colNameList.indexOf("DRCR_FLAG")));		//dr / cr flag
				pstmtInsertTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("NET_AMT")));			//net amount
				pstmtInsertTaxProcessed.setObject(10, currRecordList.get(colNameList.indexOf("DR_AMT")));			//debit amount
				pstmtInsertTaxProcessed.setObject(11, currRecordList.get(colNameList.indexOf("CR_AMT")));			//credit amount
				pstmtInsertTaxProcessed.setObject(12, currRecordList.get(colNameList.indexOf("TAX_CHAP")));		//tax chapter
				pstmtInsertTaxProcessed.setString(13, itemCode);	//item code
				pstmtInsertTaxProcessed.setObject(14, currRecordList.get(colNameList.indexOf("SITE_CODE")));		//site code
				pstmtInsertTaxProcessed.setObject(15, currRecordList.get(colNameList.indexOf("QTY_RECD")));		//quantity received
				pstmtInsertTaxProcessed.setObject(16, currRecordList.get(colNameList.indexOf("SUPP_CODE")));	//supplier code
				pstmtInsertTaxProcessed.setObject(17, currRecordList.get(colNameList.indexOf("EXC_REF")));			//exc referance
				pstmtInsertTaxProcessed.setObject(18, currRecordList.get(colNameList.indexOf("CLOSING_STOCK")));	//closing stock
				pstmtInsertTaxProcessed.setObject(19, currRecordList.get(colNameList.indexOf("SITE_CODE__SUPP")));	//site code supplier
				pstmtInsertTaxProcessed.setObject(20, currRecordList.get(colNameList.indexOf("SITE_CODE__TRAN")));	//site code transaction
				pstmtInsertTaxProcessed.setObject(21, currRecordList.get(colNameList.indexOf("TRAN_TYPE_TRANSACTION")));	//tran type transaction
				pstmtInsertTaxProcessed.setString(22, "Y");	//confirmation flag
				pstmtInsertTaxProcessed.setObject(23, currRecordList.get(colNameList.indexOf("CHAP_HEADING")));	//chapter heading
				pstmtInsertTaxProcessed.setObject(24, currRecordList.get(colNameList.indexOf("LOT_NO")));				//lot number
				pstmtInsertTaxProcessed.setObject(25, currRecordList.get(colNameList.indexOf("TAX_AMT")));			//tax amount
				pstmtInsertTaxProcessed.setObject(26, currRecordList.get(colNameList.indexOf("INVOICE_NO")));		//invoice number
				pstmtInsertTaxProcessed.setObject(27, currRecordList.get(colNameList.indexOf("TAX_CODE")));			//tax code
				pstmtInsertTaxProcessed.setTimestamp(28, this.currDate);									//change date
				pstmtInsertTaxProcessed.setString(29, chgUser);																					//change user
				pstmtInsertTaxProcessed.setString(30, chgTerm);																					//change terminal number
				pstmtInsertTaxProcessed.setObject(31, currRecordList.get(colNameList.indexOf("REF_DOC_NO")));		//referance document number
				//System.out.println("Index Of REF_DOC_DATE["+colNameList.indexOf("REF_DOC_DATE")+"]");
				//System.out.println("Index Of ["+currRecordList.get(colNameList.indexOf("REF_DOC_DATE")));
				pstmtInsertTaxProcessed.setObject(32, currRecordList.get(colNameList.indexOf("REF_DOC_DATE")));	//referance document date
				pstmtInsertTaxProcessed.setObject(33, currRecordList.get(colNameList.indexOf("LOT_SL")));				//lot sl
				pstmtInsertTaxProcessed.setObject(34, currRecordList.get(colNameList.indexOf("MATERIAL_CATEGORY")));				//material category
				pstmtInsertTaxProcessed.setString(35, refId);									//Ref Id
				pstmtInsertTaxProcessed.setObject(36, currRecordList.get(colNameList.indexOf("REF_DATE")));				//Ref Date
				pstmtInsertTaxProcessed.setString(37, refLine);																			//referance line number
				pstmtInsertTaxProcessed.setObject(38, currRecordList.get(colNameList.indexOf("TRAN_TYPE")));			//Tran Type
				pstmtSelectSrNo.setString(1,refSer);
				pstmtSelectSrNo.setString(2,refId);
				//ADDED 30082006
				pstmtSelectSrNo.setObject(3, currRecordList.get(colNameList.indexOf("PROC_DATE")));

				// 03-11-2006 manohar in case of debit bal_group__adj to be considered
				// as can be partially adjusted against different bal_group
				// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
				// in case of nor mal cases
				//if(drcrType.trim().equals("D"))
				//{
				//	pstmtSelectSrNo.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
				//}
				// end 27-02-2007 manoharan
				// end 03-11-2006 manoharan

				rsSelectSrNo = pstmtSelectSrNo.executeQuery();
				if(rsSelectSrNo.next())
				{
					srNo = rsSelectSrNo.getString("SR_NO");
				}
				else
				{
					//**********added latter
					//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
					srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());

					//System.out.println("4 tran id/srno " + srNo);
				}
				rsSelectSrNo.close(); // 14/03/08 manoharan
				rsSelectSrNo = null; // 14/03/08 manoharan
				pstmtInsertTaxProcessed.setString(39, srNo);
				pstmtInsertTaxProcessed.setObject(40, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
				pstmtInsertTaxProcessed.setDouble(41, adjAmt);			//adj amt
				pstmtInsertTaxProcessed.setDouble(42, addlExcise);	// 06-01-2006 manoharan new column
				if (drcrType.trim().equals("D"))
				{
					pstmtInsertTaxProcessed.setString(43, batchNo); //BATCH_NO
				}
				pstmtInsertTaxProcessed.executeUpdate();
			}
			else
			{
				pstmtUpdateTaxProcessed.setDouble(1, adjAmt);		//adj amt
				System.out.println("update tax process1"+adjAmt);
				pstmtUpdateTaxProcessed.setDouble(2, addlExcise);	// 06-01-2006 manoharan new column
				pstmtUpdateTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("TAX_AMT")));//ADDED BY NISAR ON 04/02/08
				pstmtUpdateTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtUpdateTaxProcessed.setString(5, balType);			//balance type
				pstmtUpdateTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));
				//********added latter			//balance period
				//pstmtUpdateTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
				pstmtUpdateTaxProcessed.setObject(7, currRecordList.get(colNameList.indexOf("PROC_DATE")));			//tran date

				if(drcrType.trim().equals("D"))
				{
					pstmtUpdateTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
					if(balType.trim().equals("D"))
					{
						pstmtUpdateTaxProcessed.setString(10, refSer);			//reference series
						pstmtUpdateTaxProcessed.setString(11, refId);
						if(drcrType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(8, batchNo);
						}				//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtUpdateTaxProcessed.setString(10, itemCode);			//item code
						pstmtUpdateTaxProcessed.setString(11, refSer);			//reference series
						pstmtUpdateTaxProcessed.setString(12, refId);
						if(drcrType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(8, batchNo);
						}				//reference id
					}
				}
				else
				{
					if(balType.trim().equals("D"))
					{
						pstmtUpdateTaxProcessed.setString(8, refSer);			//reference series
						pstmtUpdateTaxProcessed.setString(9, refId);				//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtUpdateTaxProcessed.setString(8, itemCode);			//item code
						pstmtUpdateTaxProcessed.setString(9, refSer);			//reference series
						pstmtUpdateTaxProcessed.setString(10, refId);				//reference id
					}
				}
				if(drcrType.trim().equals("D"))
				{
					pstmtUpdateTaxProcessed.setString(8, batchNo);
				}
				pstmtUpdateTaxProcessed.executeUpdate();
			}
			/***************************** end common logic ****************************/
			/****************** entry for credit if drcrtype = "D" ********************/
			if(drcrType.trim().equals("D"))
			{

				refSer = "      ";
				refId = "          ";
				refLine = "  1";
				itemCode = "          ";
				//adjAmt = adjAmt * -1;
				if(tranType.trim().equals("C"))
				{
					pstmtSelectTaxProcessed.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
					pstmtSelectTaxProcessed.setString(2, balType);			//balance type
					pstmtSelectTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
					//***pstmtSelectTaxProcessed.setObject(4, nextYearCapitalDate);			//next year capital date
					//*********added latter
					//pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("TRAN_DATE")));			//next year capital date
					pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("PROC_DATE")));
					if(drcrType.trim().equals("D"))
					{
						pstmtSelectTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
						if(balType.trim().equals("D"))
						{
							pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
							pstmtSelectTaxProcessed.setString(7, refId);				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtSelectTaxProcessed.setString(6, itemCode);			//item code
							pstmtSelectTaxProcessed.setString(7, refSer);			//reference series
							pstmtSelectTaxProcessed.setString(8, refId);				//reference id
						}
					}
					else
					{
						if(balType.trim().equals("D"))
						{
							pstmtSelectTaxProcessed.setString(5, refSer);			//reference series
							pstmtSelectTaxProcessed.setString(6, refId);				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtSelectTaxProcessed.setString(5, itemCode);			//item code
							pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
							pstmtSelectTaxProcessed.setString(7, refId);				//reference id
						}
					}
					rsSelectTaxProcessed = pstmtSelectTaxProcessed.executeQuery();
					if (rsSelectTaxProcessed.next())
					{
							cntTaxProcessed = rsSelectTaxProcessed.getInt(1);
					}
					rsSelectTaxProcessed.close();	// 14/03/08 manoharan
					rsSelectTaxProcessed = null;	// 14/03/08 manoharan
					if (cntTaxProcessed==0)
					{
						//***** capital date tranIdProc = getUniqueKey(conn,"T_tax_processed", nextYearCapitalDate.toString());
						//*********added latter
						//tranIdProc = getUniqueKey(conn,"T_tax_processed", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
						tranIdProc = getUniqueKey(conn,"T_tax_processed", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
						//System.out.println("5 tran id/srno " + tranIdProc);
						pstmtInsertTaxProcessed.setString(1, tranIdProc);//transaction id
						//******pstmtInsertTaxProcessed.setObject(2, nextYearCapitalDate);//next year capital date
					//	***********added latter
						//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
					//	pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));			//next year capital date
						pstmtInsertTaxProcessed.setDate(2,procDate);		
						//DD 2/4/2006
						pstmtInsertTaxProcessed.setObject(3, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
						pstmtInsertTaxProcessed.setString(4, "");		//document type
						pstmtInsertTaxProcessed.setString(5, balType);			//balance type
						pstmtInsertTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
						pstmtInsertTaxProcessed.setString(7, refSer);			//referance series
						pstmtInsertTaxProcessed.setString(8, "D");		//dr / cr flag
						pstmtInsertTaxProcessed.setDouble(9, 0);			//net amount
						pstmtInsertTaxProcessed.setDouble(10, 0);			//debit amount
						pstmtInsertTaxProcessed.setDouble(11, 0);			//credit amount
						pstmtInsertTaxProcessed.setString(12, "");		//tax chapter
						pstmtInsertTaxProcessed.setString(13, itemCode);	//item code
						pstmtInsertTaxProcessed.setObject(14, currRecordList.get(colNameList.indexOf("SITE_CODE")));		//site code
						pstmtInsertTaxProcessed.setDouble(15, 0);		//quantity received
						pstmtInsertTaxProcessed.setString(16, "");	//supplier code
						pstmtInsertTaxProcessed.setString(17, "");			//exc referance
						pstmtInsertTaxProcessed.setString(18, "");	//closing stock
						pstmtInsertTaxProcessed.setString(19, "");	//site code supplier
						pstmtInsertTaxProcessed.setString(20, "");	//site code transaction
						pstmtInsertTaxProcessed.setString(21, "");	//tran type transaction
						pstmtInsertTaxProcessed.setString(22, "Y");	//confirmation flag
						pstmtInsertTaxProcessed.setString(23, "");	//chapter heading
						pstmtInsertTaxProcessed.setString(24, "");				//lot number
						pstmtInsertTaxProcessed.setDouble(25, 0);			//tax amount
						pstmtInsertTaxProcessed.setString(26, "");		//invoice number
						pstmtInsertTaxProcessed.setString(27, "");			//tax code
						pstmtInsertTaxProcessed.setTimestamp(28, this.currDate);									//change date
						pstmtInsertTaxProcessed.setString(29, chgUser);																					//change user
						pstmtInsertTaxProcessed.setString(30, chgTerm);																					//change terminal number
						pstmtInsertTaxProcessed.setString(31, "");		//referance document number
						pstmtInsertTaxProcessed.setString(32, "");	//referance document date
						pstmtInsertTaxProcessed.setString(33, "");				//lot sl
						pstmtInsertTaxProcessed.setString(34, "");				//material category
						pstmtInsertTaxProcessed.setString(35, refId);									//Ref Id
						pstmtInsertTaxProcessed.setString(36, "");				//Ref Date
						pstmtInsertTaxProcessed.setString(37, refLine);																			//referance line number
						pstmtInsertTaxProcessed.setObject(38, currRecordList.get(colNameList.indexOf("TRAN_TYPE")));			//Tran Type
						pstmtSelectSrNo.setString(1,refSer);
						pstmtSelectSrNo.setString(2,refId);
						//ADDED 30082006
						pstmtSelectSrNo.setObject(3, currRecordList.get(colNameList.indexOf("PROC_DATE")));

						// 03-11-2006 manohar in case of debit bal_group__adj to be considered
						// as can be partially adjusted against different bal_group
						// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
						// in case of nor mal cases
						//if(drcrType.trim().equals("D"))
						//{
						//	pstmtSelectSrNo.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
						//}
						// end 27-02-2007 manoharan
						// end 03-11-2006 manoharan

						rsSelectSrNo = pstmtSelectSrNo.executeQuery();
						if(rsSelectSrNo.next())
						{
							srNo = rsSelectSrNo.getString("SR_NO");
						}
						else
						{
							//srNo = getUniqueKey(conn,"t_tax_process_sr_no", nextYearCapitalDate.toString());
							//**************Added latter
							//srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
							srNo = getUniqueKey(conn,"t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
							//System.out.println("6 tran id/srno " + srNo);
						}
						rsSelectSrNo.close(); // 14/03/08 manoharan
						rsSelectSrNo = null; // 14/03/08 manoharan
						pstmtInsertTaxProcessed.setString(39, srNo);
						pstmtInsertTaxProcessed.setObject(40, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
						pstmtInsertTaxProcessed.setDouble(41, adjAmt);			//adj amt
						pstmtInsertTaxProcessed.setDouble(42, addlExcise);	// 06-01-2006 manoharan new column
						if (drcrType.trim().equals("D"))
						{
							pstmtInsertTaxProcessed.setString(43, batchNo); //BATCH_NO
						}
						pstmtInsertTaxProcessed.executeUpdate();
					}
					else
					{
						pstmtUpdateTaxProcessed.setDouble(1, adjAmt);		//adj amt
						System.out.println("update tax process2"+adjAmt);
						pstmtUpdateTaxProcessed.setDouble(2, addlExcise);	// 06-01-2006 manoharan new column
						pstmtUpdateTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("TAX_AMT")));//ADDED BY NISAR ON 04/02/08
						pstmtUpdateTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
						pstmtUpdateTaxProcessed.setString(5, balType);			//balance type
						pstmtUpdateTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
						pstmtUpdateTaxProcessed.setObject(7, nextYearCapitalDate);			//next year capital date
						if(drcrType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
							if(balType.trim().equals("D"))
							{
								pstmtUpdateTaxProcessed.setString(10, refSer);			//reference series
								pstmtUpdateTaxProcessed.setString(11, refId);
								if(drcrType.trim().equals("D"))
								{
									pstmtUpdateTaxProcessed.setString(8, batchNo);
								}				//reference id
							}
							else if(balType.trim().equals("I"))
							{
								pstmtUpdateTaxProcessed.setString(10, itemCode);			//item code
								pstmtUpdateTaxProcessed.setString(11, refSer);			//reference series
								pstmtUpdateTaxProcessed.setString(12, refId);
								if(drcrType.trim().equals("D"))
								{
									pstmtUpdateTaxProcessed.setString(8, batchNo);
								}				//reference id
							}
						}
						else
						{
							if(balType.trim().equals("D"))
							{
								pstmtUpdateTaxProcessed.setString(8, refSer);			//reference series
								pstmtUpdateTaxProcessed.setString(9, refId);				//reference id
							}
							else if(balType.trim().equals("I"))
							{
								pstmtUpdateTaxProcessed.setString(8, itemCode);			//item code
								pstmtUpdateTaxProcessed.setString(9, refSer);			//reference series
								pstmtUpdateTaxProcessed.setString(10, refId);				//reference id
							}
						}

							pstmtUpdateTaxProcessed.executeUpdate();
					}
				}//end capital items
				pstmtSelectTaxProcessed.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
				pstmtSelectTaxProcessed.setString(2, balType);			//balance type
				pstmtSelectTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("BAL_PRD")));
				//******added latter			//balance period
				//pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
				pstmtSelectTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("PROC_DATE")));		//tran date
				if(drcrType.trim().equals("D"))
				{
					pstmtSelectTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
					if(balType.trim().equals("D"))
					{
						pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(7, refId);				//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtSelectTaxProcessed.setString(6, itemCode);			//item code
						pstmtSelectTaxProcessed.setString(7, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(8, refId);				//reference id
					}
				}
				else
				{
					if(balType.trim().equals("D"))
					{
						pstmtSelectTaxProcessed.setString(5, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(6, refId);				//reference id
					}
					else if(balType.trim().equals("I"))
					{
						pstmtSelectTaxProcessed.setString(5, itemCode);			//item code
						pstmtSelectTaxProcessed.setString(6, refSer);			//reference series
						pstmtSelectTaxProcessed.setString(7, refId);				//reference id
					}
				}
				rsSelectTaxProcessed = pstmtSelectTaxProcessed.executeQuery();
				if (rsSelectTaxProcessed.next())
				{
						cntTaxProcessed = rsSelectTaxProcessed.getInt(1);
				}
				rsSelectTaxProcessed.close();	// 14/03/08 manoharan
				rsSelectTaxProcessed = null;	// 14/03/08 manoharan
				//* manoharan 28-06-2006 commented the extra entry as per Mahesh Pandey
				if (cntTaxProcessed==0)
				{
					//*************added latter
					//tranIdProc = getUniqueKeyExtra(conn, "T_tax_processed", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
					tranIdProc = getUniqueKeyExtra(conn, "T_tax_processed", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
					//System.out.println("7 tran id/srno " + tranIdProc);
					pstmtInsertTaxProcessed.setString(1, tranIdProc);//transaction id
					//*************added latter
					//pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));			//transaction date
				//	pstmtInsertTaxProcessed.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));			//transaction date
					pstmtInsertTaxProcessed.setDate(2,procDate);
					//DD 2/4/2006
					pstmtInsertTaxProcessed.setObject(3, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
					pstmtInsertTaxProcessed.setString(4, "");		//document type
					pstmtInsertTaxProcessed.setString(5, balType);//balance type
					pstmtInsertTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
					pstmtInsertTaxProcessed.setString(7, refSer);	//referance series
					pstmtInsertTaxProcessed.setString(8, "D");		//dr / cr flag
					pstmtInsertTaxProcessed.setDouble(9, 0.0d);	//net amount
					pstmtInsertTaxProcessed.setDouble(10, 0.0d);	//debit amount
					pstmtInsertTaxProcessed.setDouble(11, 0.0d);		//credit amount
					pstmtInsertTaxProcessed.setString(12, "");		//tax chapter
					pstmtInsertTaxProcessed.setString(13, itemCode);	//item code
					pstmtInsertTaxProcessed.setObject(14, currRecordList.get(colNameList.indexOf("SITE_CODE")));		//site code
					pstmtInsertTaxProcessed.setDouble(15, 0);	//quantity received
					pstmtInsertTaxProcessed.setString(16, "");	//supplier code
					pstmtInsertTaxProcessed.setString(17, "");	//exc referance
					pstmtInsertTaxProcessed.setDouble(18, 0.0d);	//closing stock
					pstmtInsertTaxProcessed.setString(19, "");	//site code supplier
					pstmtInsertTaxProcessed.setString(20, "");	//site code transaction
					pstmtInsertTaxProcessed.setString(21, "");	//tran type transaction
					pstmtInsertTaxProcessed.setString(22, "Y");	//confirmation flag
					pstmtInsertTaxProcessed.setString(23, "");	//chapter heading
					pstmtInsertTaxProcessed.setString(24, "");	//lot number
					pstmtInsertTaxProcessed.setDouble(25, 0.0d);	//tax amount
					pstmtInsertTaxProcessed.setString(26, "");	//invoice number
					pstmtInsertTaxProcessed.setString(27, "");	//tax code
					pstmtInsertTaxProcessed.setTimestamp(28, this.currDate);	//change date
					pstmtInsertTaxProcessed.setString(29, chgUser);	//change user
					pstmtInsertTaxProcessed.setString(30, chgTerm);	//change terminal number
					pstmtInsertTaxProcessed.setString(31, "");			//referance document number
					pstmtInsertTaxProcessed.setTimestamp(32, this.currDate);			//reference document date
					pstmtInsertTaxProcessed.setString(33, "");			//lot sl
					pstmtInsertTaxProcessed.setString(34, "");			//material category
					pstmtInsertTaxProcessed.setString(35, refId);		//Ref Id
					//pstmtInsertTaxProcessed.setTimestamp(36, "");	//Ref Date
					pstmtInsertTaxProcessed.setObject(36, currRecordList.get(colNameList.indexOf("REF_DATE")));	//referance document date
					pstmtInsertTaxProcessed.setString(37, refLine);	//reference line number
					pstmtInsertTaxProcessed.setObject(38, currRecordList.get(colNameList.indexOf("TRAN_TYPE")));			//Tran Type
					pstmtSelectSrNo.setString(1,refSer);
					pstmtSelectSrNo.setString(2,refId);
					//ADDED 30082006
					pstmtSelectSrNo.setObject(3, currRecordList.get(colNameList.indexOf("PROC_DATE")));

					// 03-11-2006 manohar in case of debit bal_group__adj to be considered
					// as can be partially adjusted against different bal_group
					// 27-02-2007 consideration of bal_group__adj reverted as was creating problem
					// in case of nor mal cases
					//if(drcrType.trim().equals("D"))
					//{
					//	pstmtSelectSrNo.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
					//}
					// end 27-02-2007 manoharan
					// end 03-11-2006 manoharan
					rsSelectSrNo = pstmtSelectSrNo.executeQuery();
					if(rsSelectSrNo.next())
					{
						srNo = rsSelectSrNo.getString("SR_NO");
					}
					else
					{
						//*************added latter
						//srNo = getUniqueKeyExtra(conn, "t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
					  srNo = getUniqueKeyExtra(conn, "t_tax_process_sr_no", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
						//System.out.println("8 tran id/srno " + srNo);
					}
					rsSelectSrNo.close(); // 14/03/08 manoharan
					rsSelectSrNo = null; // 14/03/08 manoharan
					pstmtInsertTaxProcessed.setString(39, srNo);
					pstmtInsertTaxProcessed.setObject(40, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
					pstmtInsertTaxProcessed.setDouble(41, adjAmt);			//adj amt
					pstmtInsertTaxProcessed.setDouble(42, addlExcise);	// 06-01-2006 manoharan new column
					if (drcrType.trim().equals("D"))
					{
						pstmtInsertTaxProcessed.setString(43, batchNo); //BATCH_NO
					}
					pstmtInsertTaxProcessed.executeUpdate();
				}
				else
				{
					pstmtUpdateTaxProcessed.setDouble(1, adjAmt);		//adj amt
					pstmtUpdateTaxProcessed.setDouble(2, addlExcise);	// 06-01-2006 manoharan new column
					pstmtUpdateTaxProcessed.setObject(3, currRecordList.get(colNameList.indexOf("TAX_AMT")));//ADDED BY NISAR ON 04/02/08
					pstmtUpdateTaxProcessed.setObject(4, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
					pstmtUpdateTaxProcessed.setString(5, balType);			//balance type
					pstmtUpdateTaxProcessed.setObject(6, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
					//pstmtUpdateTaxProcessed.setObject(5, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
					pstmtUpdateTaxProcessed.setObject(7, currRecordList.get(colNameList.indexOf("PROC_DATE")));			//tran date
					if(drcrType.trim().equals("D"))
					{
						pstmtUpdateTaxProcessed.setObject(9, currRecordList.get(colNameList.indexOf("BAL_GROUP")));			//bal group
						if(balType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(10, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(11, refId);
							if(drcrType.trim().equals("D"))
							{
								pstmtUpdateTaxProcessed.setString(8, batchNo);
							}				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtUpdateTaxProcessed.setString(10, itemCode);			//item code
							pstmtUpdateTaxProcessed.setString(11, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(12, refId);
							if(drcrType.trim().equals("D"))
							{
								pstmtUpdateTaxProcessed.setString(8, batchNo);
							}			//reference id
						}
					}
					else
					{
						if(balType.trim().equals("D"))
						{
							pstmtUpdateTaxProcessed.setString(8, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(9, refId);				//reference id
						}
						else if(balType.trim().equals("I"))
						{
							pstmtUpdateTaxProcessed.setString(8, itemCode);			//item code
							pstmtUpdateTaxProcessed.setString(9, refSer);			//reference series
							pstmtUpdateTaxProcessed.setString(10, refId);				//reference id
						}
					}
					pstmtUpdateTaxProcessed.executeUpdate();
				}//*/ // manoharan 28-06-2006 commented the extra entry as per Mahesh Pandey
				//pstmtInsertTaxProcessed.close();
				//pstmtUpdateTaxProcessed.close();
			}

			/***************************** end entry for credit if drcrtype = "D" ****************************/
			}
		} // end try 
		catch(Exception e)
		{
			throw new ITMException(e);
		} // 14/03/08 manoharan d\close statements
		finally
		{
			try
			{
				if (pstmtSelectTaxProcessed != null)
				{
					pstmtSelectTaxProcessed.close();
					pstmtSelectTaxProcessed = null;
				}
				if (pstmtInsertTaxProcessed != null)
				{
					pstmtInsertTaxProcessed.close();
					pstmtInsertTaxProcessed = null;
				}
				if (pstmtUpdateTaxProcessed != null)
				{
					pstmtUpdateTaxProcessed.close();
					pstmtUpdateTaxProcessed = null;
				}
				if (pstmtSelectSrNo != null)
				{
					pstmtSelectSrNo.close();
					pstmtSelectSrNo = null;
				}
				if (rsSelectTaxProcessed != null)
				{
					rsSelectTaxProcessed.close();
					rsSelectTaxProcessed = null;
				}
				if (rsSelectSrNo != null)
				{
					rsSelectSrNo.close();
					rsSelectSrNo = null;
				}
			}
			catch(Exception sqle)
			{
				throw new ITMException(sqle);
			}
		}
	return resultString;	
	}

	private void updateTaxProcessTrace(Connection conn)throws ITMException
	{
		//common logic
		//if debit
		//else credit
		//final execution of update/insert
		ResultSet rsSelectTaxProcessTrace = null;
		int cntTaxProcessTrace = 0;
		String drcrType="";
		String tranIdTrace="";
		PreparedStatement pstmtSelectTaxProcessTrace = null;
		PreparedStatement pstmtInsertTaxProcessTrace = null;
		PreparedStatement pstmtUpdateTaxProcessTrace = null;
		try
		{
			StringBuffer sqlSelectTaxProcessTrace = new StringBuffer("SELECT COUNT(1) FROM TAX_PROCESS_TRACE WHERE BAL_GROUP = ? AND BAL_TYPE =  ? AND BAL_PRD = ? AND REF_SER = ? AND REF_ID = ? AND REF_LINE = ? ");
			drcrType = (String)currRecordList.get(colNameList.indexOf("DRCR_TYPE"));
			if(drcrType.trim().equals("D"))
			{
				sqlSelectTaxProcessTrace.append("AND BAL_GROUP__ADJ = ?");
			}
			pstmtSelectTaxProcessTrace = conn.prepareStatement(sqlSelectTaxProcessTrace.toString());

			StringBuffer sqlInsertTaxProcessTrace = new StringBuffer("INSERT INTO TAX_PROCESS_TRACE(TRAN_ID, TRAN_DATE, BAL_GROUP, BAL_TYPE, BAL_PRD, REF_SER, REF_ID, REF_LINE, CHG_DATE, CHG_USER, CHG_TERM, NET_AMT, QTY_RECD, TAX_AMT, ITEM_CODE, SITE_CODE,REF_DATE,TRAN_ID__PROC,BAL_GROUP__ADJ,ADJ_AMT)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			pstmtInsertTaxProcessTrace = conn.prepareStatement(sqlInsertTaxProcessTrace.toString());

			StringBuffer sqlUpdateTaxProcessTrace = new StringBuffer("UPDATE TAX_PROCESS_TRACE SET ADJ_AMT = ADJ_AMT + ? , CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE BAL_GROUP = ? AND BAL_TYPE =  ? AND BAL_PRD = ? AND REF_SER = ? AND REF_ID = ? AND REF_LINE = ? ");
			if(drcrType.trim().equals("D"))
			{
				sqlUpdateTaxProcessTrace.append("AND BAL_GROUP__ADJ = ?");
			}
			pstmtUpdateTaxProcessTrace = conn.prepareStatement(sqlUpdateTaxProcessTrace.toString());
			pstmtSelectTaxProcessTrace.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
			pstmtSelectTaxProcessTrace.setObject(2, currRecordList.get(colNameList.indexOf("BAL_TYPE")));			//balance type
			pstmtSelectTaxProcessTrace.setObject(3, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
			pstmtSelectTaxProcessTrace.setObject(4, currRecordList.get(colNameList.indexOf("REF_SER")));			//reference series
			pstmtSelectTaxProcessTrace.setObject(5, currRecordList.get(colNameList.indexOf("REF_ID")));				//reference id
			pstmtSelectTaxProcessTrace.setObject(6, currRecordList.get(colNameList.indexOf("REF_LINE")));			//reference line number
			if(drcrType.trim().equals("D"))
			{
				pstmtSelectTaxProcessTrace.setObject(7, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
			}
			rsSelectTaxProcessTrace = pstmtSelectTaxProcessTrace.executeQuery();

			if (rsSelectTaxProcessTrace.next())
			{
					cntTaxProcessTrace = rsSelectTaxProcessTrace.getInt(1);
			}
			rsSelectTaxProcessTrace.close();
			rsSelectTaxProcessTrace = null;
			pstmtSelectTaxProcessTrace.close();
			pstmtSelectTaxProcessTrace = null;

			if (cntTaxProcessTrace==0)
			{
				//***********added latter
				//tranIdTrace = getUniqueKey(conn,"T_tax_process_trace", currRecordList.get(colNameList.indexOf("TRAN_DATE")).toString());
				tranIdTrace = getUniqueKey(conn,"T_tax_process_trace", currRecordList.get(colNameList.indexOf("PROC_DATE")).toString());
				//System.out.println("9 tran id/srno " + tranIdTrace);
				pstmtInsertTaxProcessTrace.setString(1, tranIdTrace);												//transaction id
				//*************added latter
				//pstmtInsertTaxProcessTrace.setObject(2, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
				pstmtInsertTaxProcessTrace.setObject(2, currRecordList.get(colNameList.indexOf("PROC_DATE")));		//transaction date

				pstmtInsertTaxProcessTrace.setObject(3, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtInsertTaxProcessTrace.setObject(4, currRecordList.get(colNameList.indexOf("BAL_TYPE")));			//balance type
				pstmtInsertTaxProcessTrace.setObject(5, currRecordList.get(colNameList.indexOf("BAL_PRD")));			//balance period
				pstmtInsertTaxProcessTrace.setObject(6, currRecordList.get(colNameList.indexOf("REF_SER")));			//referance series
				pstmtInsertTaxProcessTrace.setObject(7, currRecordList.get(colNameList.indexOf("REF_ID")));				//referance id
				pstmtInsertTaxProcessTrace.setObject(8, currRecordList.get(colNameList.indexOf("REF_LINE")));			//referance line number
				pstmtInsertTaxProcessTrace.setTimestamp(9, this.currDate);																						//change date
				pstmtInsertTaxProcessTrace.setString(10, chgUser);																										//change user
				pstmtInsertTaxProcessTrace.setString(11, chgTerm);																										//change terminal number
				pstmtInsertTaxProcessTrace.setObject(12, currRecordList.get(colNameList.indexOf("NET_AMT")));					//net amount
				pstmtInsertTaxProcessTrace.setObject(13, currRecordList.get(colNameList.indexOf("QTY_RECD")));					//quantity received
				pstmtInsertTaxProcessTrace.setObject(14, currRecordList.get(colNameList.indexOf("TAX_AMT")));					//tax amount
				pstmtInsertTaxProcessTrace.setObject(15, currRecordList.get(colNameList.indexOf("ITEM_CODE")));				//item code
				pstmtInsertTaxProcessTrace.setObject(16, currRecordList.get(colNameList.indexOf("SITE_CODE")));				//site code
				pstmtInsertTaxProcessTrace.setObject(17, currRecordList.get(colNameList.indexOf("REF_DATE")));					//Refdate
				pstmtInsertTaxProcessTrace.setString(18, "");																													//tran id process
				pstmtInsertTaxProcessTrace.setObject(19, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));	//bal group adj
				pstmtInsertTaxProcessTrace.setObject(20, currRecordList.get(colNameList.indexOf("BAL_AMT")));					//adj amt
				pstmtInsertTaxProcessTrace.executeUpdate();
			}
			else
			{
				pstmtUpdateTaxProcessTrace.setObject(1, currRecordList.get(colNameList.indexOf("BAL_AMT")));			//adj amt
				pstmtUpdateTaxProcessTrace.setTimestamp(2, this.currDate);			//chg date
				pstmtUpdateTaxProcessTrace.setString(3, chgUser);			//chg user
				pstmtUpdateTaxProcessTrace.setString(4, chgTerm);			//chg term
				pstmtUpdateTaxProcessTrace.setObject(5, currRecordList.get(colNameList.indexOf("BAL_GROUP")));	//balance group
				pstmtUpdateTaxProcessTrace.setObject(6, currRecordList.get(colNameList.indexOf("BAL_TYPE")));		//balance type
				pstmtUpdateTaxProcessTrace.setObject(7, currRecordList.get(colNameList.indexOf("BAL_PRD")));		//balance period
				pstmtUpdateTaxProcessTrace.setObject(8, currRecordList.get(colNameList.indexOf("REF_SER")));			//referance series
				pstmtUpdateTaxProcessTrace.setObject(9, currRecordList.get(colNameList.indexOf("REF_ID")));			//referance id
				pstmtUpdateTaxProcessTrace.setObject(10, currRecordList.get(colNameList.indexOf("REF_LINE")));		//referance line number
				if(drcrType.trim().equals("D"))
				{
					pstmtUpdateTaxProcessTrace.setObject(11, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));			//bal group adj
				}
				pstmtUpdateTaxProcessTrace.executeUpdate();
			}
			pstmtInsertTaxProcessTrace.close();
			pstmtUpdateTaxProcessTrace.close();
			pstmtInsertTaxProcessTrace = null;
			pstmtUpdateTaxProcessTrace = null;
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsSelectTaxProcessTrace != null)
				{
					rsSelectTaxProcessTrace.close();
					rsSelectTaxProcessTrace = null;
				}
				if (pstmtSelectTaxProcessTrace != null)
				{
					pstmtSelectTaxProcessTrace.close();
		 			pstmtSelectTaxProcessTrace = null;
				}
				if (pstmtInsertTaxProcessTrace != null)
				{
					pstmtInsertTaxProcessTrace.close();
		 			pstmtInsertTaxProcessTrace = null;
				}
				if (pstmtUpdateTaxProcessTrace != null)
				{
					pstmtUpdateTaxProcessTrace.close();
		 			pstmtUpdateTaxProcessTrace = null;
				}

			}
			catch(Exception sqle)
			{
				throw new ITMException(sqle);
			}

		}
	}

	private void updateTaxProcessBal(Connection conn)throws ITMException
	{
		//common logic
		//if debit
		//else credit
		//final execution of update/insert
		String drcrFlag = "";
		String drcrType = "";
		String finEntity = "";
		String acctPrd = "";
		String prevAcctPrd = "";
		String nextAcctPrd = "";
		String tranType = "";
		//Changed by Rohan on 10/01/12 to define variable.start
		String balGroup = "";
	    boolean isCapitalItem = false;
		//Changed by Rohan on 10/01/12 to define variable.end
		double drAmt = 0.0;
		double crAmt = 0.0;
		double adjAmt = 0.0;
		ResultSet rsSelectFinent = null;
		ResultSet rsSelectAcctprd = null;
		ResultSet rsSelectTaxProcessBal = null;
		ResultSet rsSelectTaxProcessBal_1 = null;
		PreparedStatement pstmtSelectAcctprd = null;
		PreparedStatement pstmtInsertTaxProcessBal = null;
		PreparedStatement pstmtUpdateTaxProcessBal = null;
		PreparedStatement pstmtSelectTaxProcessBal = null;
		PreparedStatement pstmtSelectTaxProcessBal_1 = null;
		PreparedStatement pstmtSelectFinentity = null;

		int calVal = 0;
		try
		{
			//System.out.println("Into Insert/Update of TAX_PROCESS_BAL....");
			StringBuffer sqlSelectFinentity = new StringBuffer("SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? ");
			pstmtSelectFinentity = conn.prepareStatement(sqlSelectFinentity.toString());

			StringBuffer sqlSelectAcctprd = new StringBuffer("SELECT CODE FROM ACCTPRD WHERE ? BETWEEN FR_DATE AND TO_DATE ");
			pstmtSelectAcctprd = conn.prepareStatement(sqlSelectAcctprd.toString());

			StringBuffer sqlSelectTaxProcessBal = new StringBuffer("SELECT CASE WHEN DR_AMT IS NULL THEN 0 ELSE DR_AMT END, CASE WHEN CR_AMT IS NULL THEN 0 ELSE CR_AMT END FROM TAX_PROCESS_BAL WHERE BAL_GROUP = ? AND FIN_ENTITY =  ? AND SITE_CODE = ? AND ACCT_PRD = ? AND BAL_PRD = ?");
			pstmtSelectTaxProcessBal = conn.prepareStatement(sqlSelectTaxProcessBal.toString());
			pstmtSelectTaxProcessBal_1 = conn.prepareStatement(sqlSelectTaxProcessBal.toString());

			StringBuffer sqlInsertTaxProcessBal = new StringBuffer("INSERT INTO TAX_PROCESS_BAL (BAL_GROUP, BAL_PRD, DR_AMT, CR_AMT, CHG_DATE, CHG_USER, CHG_TERM, ACCT_PRD, FIN_ENTITY, SITE_CODE) VALUES (?,?,?,?,?,?,?,?,?,?)");
			pstmtInsertTaxProcessBal = conn.prepareStatement(sqlInsertTaxProcessBal.toString());

			StringBuffer sqlUpdateTaxProcessBal = new StringBuffer("UPDATE TAX_PROCESS_BAL SET DR_AMT = ? , CR_AMT = ? , CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE BAL_GROUP = ? AND FIN_ENTITY =  ? AND SITE_CODE = ? AND ACCT_PRD = ? AND BAL_PRD = ? ");
			pstmtUpdateTaxProcessBal  = conn.prepareStatement(sqlUpdateTaxProcessBal.toString());
			pstmtSelectFinentity.setObject(1, currRecordList.get(colNameList.indexOf("SITE_CODE")));
			rsSelectFinent = pstmtSelectFinentity.executeQuery();
			if (rsSelectFinent.next())
			{
				finEntity = rsSelectFinent.getString(1);
			}
			rsSelectFinent.close(); // 14/03/08 manoharan
			rsSelectFinent = null; // 14/03/08 manoharan
			//System.out.println("finEntity :["+finEntity+"]");
			pstmtSelectFinentity.close();
			pstmtSelectFinentity = null; // 14/03/08 manoharan
			//*********added latter
			//pstmtSelectAcctprd.setObject(1, currRecordList.get(colNameList.indexOf("TRAN_DATE")));
			pstmtSelectAcctprd.setObject(1, currRecordList.get(colNameList.indexOf("PROC_DATE")));
			rsSelectAcctprd = pstmtSelectAcctprd.executeQuery();
			if (rsSelectAcctprd.next())
			{
				acctPrd = rsSelectAcctprd.getString(1);
			}
			rsSelectAcctprd.close(); // 14/03/08 manoharan
			rsSelectAcctprd = null; // 14/03/08 manoharan
			//System.out.println("acctPrd :["+acctPrd+"]");
			adjAmt = ((Double)currRecordList.get(colNameList.indexOf("BAL_AMT"))).doubleValue();
			drcrFlag = (String)currRecordList.get(colNameList.indexOf("DRCR_FLAG"));
			drcrType = (String)currRecordList.get(colNameList.indexOf("DRCR_TYPE"));
			/*****************capital items**************/
			tranType = (String)currRecordList.get(colNameList.indexOf("TRAN_TYPE"));
			
			//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
			balGroup = (String) currRecordList.get(colNameList.indexOf("BAL_GROUP"));  
		    isCapitalItem = isCapitalItem(balGroup, conn);
		    //Changed by Rohan on 1-10-12 to set half amount in case of capital items.end   
		   
			//System.out.println("tranType :["+tranType+"]");
			//Commentd by Chandni for stoping inserting into tax_process_bal table for capital item
			/*
			if(tranType.trim().equals("C"))
			{
				System.out.println("Processing for Capital Items......");
				adjAmt = adjAmt/2;

				pstmtSelectAcctprd.setTimestamp(1, nextYearCapitalDate);
				rsSelectAcctprd = pstmtSelectAcctprd.executeQuery();
				if (rsSelectAcctprd.next())
				{
					nextAcctPrd = rsSelectAcctprd.getString(1);
				}
				rsSelectAcctprd.close(); // 14/03/08 manoharan
				rsSelectAcctprd = null; // 14/03/08 manoharan
				//System.out.println("nextAcctPrd :["+nextAcctPrd+"]");
				pstmtSelectTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
				pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtSelectTaxProcessBal.setString(4, nextAcctPrd);			//acct prd
				pstmtSelectTaxProcessBal.setString(5, nextBalprd);				//balance period
				rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();

				if (rsSelectTaxProcessBal.next())
				{
					if (drcrFlag.trim().equals("D"))
					{
						drAmt = rsSelectTaxProcessBal.getDouble(1) + adjAmt;
					}
					else if (drcrFlag.trim().equals("C"))
					{
						crAmt = rsSelectTaxProcessBal.getDouble(2) + adjAmt;
					}
					System.out.println(":::::::::::::::::::::: 1 ::::::::::::::::::::::::::::::::::::::::::UPDATE");
					pstmtUpdateTaxProcessBal.setDouble(1, drAmt);																					//dr amt
					pstmtUpdateTaxProcessBal.setDouble(2, crAmt);																					//cr amt
					pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
					pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
					pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
					pstmtUpdateTaxProcessBal.setObject(6, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
					pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
					pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
					pstmtUpdateTaxProcessBal.setString(9, nextAcctPrd);			//acct prd
					pstmtUpdateTaxProcessBal.setString(10, nextBalprd);				//balance period
					pstmtUpdateTaxProcessBal.executeUpdate();
				}
				else
				{
					if (drcrFlag.trim().equals("D"))
					{
						drAmt = adjAmt;
					}
					else if (drcrFlag.trim().equals("C"))
					{
						crAmt = adjAmt;
					}
					System.out.println(":::::::::::::::::::::: 1 ::::::::::::::::::::::::::::::::::::::::::");
					pstmtInsertTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));												//balance group
					pstmtInsertTaxProcessBal.setString(2, nextBalprd);												//balance period
					pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
					pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
					pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
					pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
					pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
					pstmtInsertTaxProcessBal.setString(8, nextAcctPrd);												//accounting year
					pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
					pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
					pstmtInsertTaxProcessBal.executeUpdate();
				}
				rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
				rsSelectTaxProcessBal = null ; // 14/03/08 manoharan
				//System.out.println("End of processing for Capital Items......");
			}
			*/
			/*****************end capital items**************/

			/*****************opening balances**************/
			//System.out.println("Processing for Opening balances......");
			pstmtSelectTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
			pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
			pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
			pstmtSelectTaxProcessBal.setString(4, acctPrd);			//prev year acct prd
			pstmtSelectTaxProcessBal.setString(5, "000000  ");				//balance period
			rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();
			if ( ! rsSelectTaxProcessBal.next())
			{
				//System.out.println("Opening balance for Current Period not found, Checking for Previous Period Closing....");
				pstmtSelectAcctprd.setTimestamp(1, prevYearTranDate);
				rsSelectAcctprd = pstmtSelectAcctprd.executeQuery();
				if (rsSelectAcctprd.next())
				{
					prevAcctPrd = rsSelectAcctprd.getString(1);
				}
				rsSelectAcctprd.close(); // 18/03/08 manoharan
				rsSelectAcctprd = null; // 18/03/08 manoharan
				//System.out.println("prevAcctPrd :["+prevAcctPrd+"]");
				pstmtSelectTaxProcessBal_1.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtSelectTaxProcessBal_1.setString(2, finEntity);			//financial entity
				pstmtSelectTaxProcessBal_1.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtSelectTaxProcessBal_1.setString(4, prevAcctPrd);			//prev year acct prd
				pstmtSelectTaxProcessBal_1.setString(5, "ZZZZZZ  ");				//balance period
				rsSelectTaxProcessBal_1 = pstmtSelectTaxProcessBal_1.executeQuery();
				
				if (rsSelectTaxProcessBal_1.next())
				{
					drAmt = rsSelectTaxProcessBal_1.getDouble(1);
					crAmt = rsSelectTaxProcessBal_1.getDouble(2);
				}
				else
				{
					drAmt = 0;
					crAmt = 0;
				}
				
				rsSelectTaxProcessBal_1.close(); // 18/03/08 manoharan
				rsSelectTaxProcessBal_1 = null; // 18/03/08 manoharan
				System.out.println(":::::::::::::::::::::: 2 ::::::::::::::::::::::::::::::::::::::::::");
				pstmtInsertTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));												//balance group
				pstmtInsertTaxProcessBal.setString(2, "000000  ");												//balance period
				pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
				pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
				pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
				pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
				pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
				pstmtInsertTaxProcessBal.setString(8, acctPrd);												//accounting year
				pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
				pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
				pstmtInsertTaxProcessBal.executeUpdate();
			}
			rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
			rsSelectTaxProcessBal = null; // 14/03/08 manoharan
			//System.out.println("End of processing for opening balances......");
			/*****************end opening balances**************/
			/*****************current balances**************/
			//System.out.println("Processing for Current balances......");
			pstmtSelectTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
			pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
			pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
			pstmtSelectTaxProcessBal.setString(4, acctPrd);			//acct prd
			pstmtSelectTaxProcessBal.setObject(5, currBalprd);				//balance period
			rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();
			if (rsSelectTaxProcessBal.next())
			{
				//System.out.println("Current balance for Current Period found, Updating for current Period for DRCR Flag :["+drcrFlag.trim()+"]");
				drAmt = rsSelectTaxProcessBal.getDouble(1);
				crAmt = rsSelectTaxProcessBal.getDouble(2);
				
				if (drcrFlag.trim().equals("D"))
				{
					
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//drAmt += adjAmt;
					if(isCapitalItem)
					{
						drAmt = drAmt + (adjAmt/2);
					}
					else
					{
						drAmt += adjAmt;
					}
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.end
				}
				else if (drcrFlag.trim().equals("C"))
				{
					
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//crAmt += adjAmt;
					if(isCapitalItem)
					{
						crAmt = crAmt + (adjAmt/2);
					}
					else
					{
						crAmt += adjAmt;
					}
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.end
				}
		
				//System.out.println("After adjustment drAmt :["+drAmt+"] crAmt :["+crAmt+"]");
				System.out.println(":::::::::::::::::::::: 2 ::::::::::::::::::::::::::::::::::::::::::UPDATE");
				pstmtUpdateTaxProcessBal.setDouble(1, drAmt);							//dr amt
				pstmtUpdateTaxProcessBal.setDouble(2, crAmt);			//cr amt
				pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
				pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
				pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
				pstmtUpdateTaxProcessBal.setObject(6, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
				pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtUpdateTaxProcessBal.setString(9, acctPrd);			//acct prd
				pstmtUpdateTaxProcessBal.setObject(10, currBalprd);				//balance period
				pstmtUpdateTaxProcessBal.executeUpdate();
			}
			else
			{
				//System.out.println("Current balance for Current Period not found, Inserting for current Period for DRCR Flag :["+drcrFlag.trim()+"]");
				
				//Changed by Rohan on 10/01/12 to divided capital item only.start
				
			    if(isCapitalItem)
			    {
			    	if (drcrFlag.trim().equals("D"))
					{
			    		drAmt = (adjAmt/2);
					}
					else if (drcrFlag.trim().equals("C"))
					{
						crAmt = (adjAmt/2);
					}
			    	
			    }
			   	/*
				if (drcrFlag.trim().equals("D"))
				{
					drAmt = adjAmt;
				}
				else if (drcrFlag.trim().equals("C"))
				{
					//Changed by Rohan on 31-08-12 to calculate cr term half of adjAmount 
					//crAmt = adjAmt
					crAmt = (adjAmt/2);
				}
				*/
			    else
			    {
			    	if (drcrFlag.trim().equals("D"))
			    	{
						drAmt = adjAmt;
					}
					else if (drcrFlag.trim().equals("C"))
					{
						crAmt = adjAmt;
						
					}
			    }
				//Changed by Rohan on 10/01/12 to divided capital item only.end
				System.out.println(":::::::::::::::::::::: 3 ::::::::::::::::::::::::::::::::::::::::::");
				pstmtInsertTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));												//balance group
				pstmtInsertTaxProcessBal.setObject(2, currBalprd);												//balance period
				pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
				pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
				pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
				pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
				pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
				pstmtInsertTaxProcessBal.setString(8, acctPrd);												//accounting year
				pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
				pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
				pstmtInsertTaxProcessBal.executeUpdate();
			}
			rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
			rsSelectTaxProcessBal = null; // 14/03/08 manoharan
			//System.out.println("End of processing for Current balances......");
			/*****************end current balances**************/
			/*****************closing balances**************/
			//System.out.println("Processing for Closing balances......");
			pstmtSelectTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
			pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
			pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
			pstmtSelectTaxProcessBal.setString(4, acctPrd);			//acct prd
			pstmtSelectTaxProcessBal.setString(5, "ZZZZZZ  ");				//balance period
			rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();
			if (rsSelectTaxProcessBal.next())
			{
				//System.out.println("Closing balance for Current Period found, Updating for current Period for DRCR Flag :["+drcrFlag.trim()+"]");
				drAmt = rsSelectTaxProcessBal.getDouble(1);
				crAmt = rsSelectTaxProcessBal.getDouble(2);
				
				if (drcrFlag.trim().equals("D"))
				{
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//drAmt += adjAmt;
					
					if(isCapitalItem)
					{
						drAmt = (drAmt/2);
					}
					else
					{
						drAmt += adjAmt;
					}
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.end
				}
				else if (drcrFlag.trim().equals("C"))
				{
					
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//crAmt += adjAmt
					if(isCapitalItem)
					{
						crAmt = crAmt + (adjAmt/2);
					}
					else
					{
						crAmt += adjAmt;
					}
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.end
					
					
				}
				//
				
				System.out.println(":::::::::::::::::::::: 3 ::::::::::::::::::::::::::::::::::::::::::UPDATE");
				
				pstmtUpdateTaxProcessBal.setDouble(1, drAmt);			//dr amt
				pstmtUpdateTaxProcessBal.setDouble(2, crAmt);			//cr amt
				pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
				pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
				pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
				pstmtUpdateTaxProcessBal.setObject(6, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
				pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtUpdateTaxProcessBal.setString(9, acctPrd);			//acct prd
				pstmtUpdateTaxProcessBal.setString(10, "ZZZZZZ  ");				//balance period
				pstmtUpdateTaxProcessBal.executeUpdate();
			}
			else
			{
				//System.out.println("Closing balance for Current Period not found, Selecting Opening Balance for Current Period...");
				pstmtSelectTaxProcessBal_1.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));		//balance group
				pstmtSelectTaxProcessBal_1.setString(2, finEntity);			//financial entity
				pstmtSelectTaxProcessBal_1.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtSelectTaxProcessBal_1.setString(4, acctPrd);			//acct prd
				pstmtSelectTaxProcessBal_1.setString(5, "000000  ");				//balance period
				rsSelectTaxProcessBal_1 = pstmtSelectTaxProcessBal_1.executeQuery();
				if (rsSelectTaxProcessBal_1.next())
				{
					drAmt = rsSelectTaxProcessBal_1.getDouble(1);
					crAmt = rsSelectTaxProcessBal_1.getDouble(2);
				}
				else
				{
					drAmt = 0;
					crAmt = 0;
				}
				rsSelectTaxProcessBal_1.close(); // 17/03/08 manoharan
				rsSelectTaxProcessBal_1 = null; // 17/03/08 manoharan
				if (drcrFlag.trim().equals("D"))
				{
					
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//drAmt += adjAmt;
					if(isCapitalItem)
					{	
						drAmt = drAmt +(adjAmt/2);

					}
					else
					{
						drAmt += adjAmt;
					}
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.end
			
				}
				else if (drcrFlag.trim().equals("C"))
				{
					
					//Changed by Rohan on 1-10-12 to set half amount in case of capital items.start
					//crAmt += adjAmt;
					if(isCapitalItem)
					{
						crAmt = crAmt +(adjAmt/2);
					}
					else
					{
						crAmt += adjAmt;
					}
				
				}
				//System.out.println("Inserting Closing Balance for Current Period for DRCR Flag :["+drcrFlag.trim()+"]");
				System.out.println(":::::::::::::::::::::: 4 ::::::::ZZZZZZZZZZZZ::::::::::::::::::::::::::::::::::");
				
				pstmtInsertTaxProcessBal.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP")));												//balance group
				pstmtInsertTaxProcessBal.setString(2, "ZZZZZZ  ");												//balance period
				pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
				pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
				pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
				pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
				pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
				pstmtInsertTaxProcessBal.setString(8, acctPrd);												//accounting year
				pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
				pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
				pstmtInsertTaxProcessBal.executeUpdate();
			}
			rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
			rsSelectTaxProcessBal = null; // 14/03/08 manoharan
			//System.out.println("End of processing for Closing balances......");
			/*****************end closing balances**************/

			/*****************debit type**************/
			//System.out.println("Processing for DRCR Type :["+drcrType.trim()+"]");
			if(drcrType.trim().equals("D"))
			{
				/* commented by Chandni to stop inserting into tax_process_bal for the capital item
				if(tranType.trim().equals("C"))
				{
					//System.out.println("Selecting amounts for given Bal Grp for Next Period for Tran Type C....");
					pstmtSelectAcctprd.setTimestamp(1, nextYearCapitalDate);
					rsSelectAcctprd = pstmtSelectAcctprd.executeQuery();
					if (rsSelectAcctprd.next())
					{
						nextAcctPrd = rsSelectAcctprd.getString(1);
					}
					rsSelectAcctprd.close(); // 14/03/08 manoharan
					rsSelectAcctprd = null; // 14/03/08 manoharan
					//DD 2/4/2006
					pstmtSelectTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
					pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
					pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
					pstmtSelectTaxProcessBal.setString(4, nextAcctPrd);			//acct prd
					pstmtSelectTaxProcessBal.setString(5, nextBalprd);				//balance period
					rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();
					if (rsSelectTaxProcessBal.next())
					{
						//System.out.println("Amounts for Next Period found, Updating for Next Period for Tran Type C.....");
						crAmt = rsSelectTaxProcessBal.getDouble(2);
						drAmt = rsSelectTaxProcessBal.getDouble(1) + adjAmt;//only this value will change
						System.out.println(":::::::::::::::::::::: 4 ::::::::::::::::::::::::::::::::::::::::::UPDATE");
						pstmtUpdateTaxProcessBal.setDouble(1, drAmt);			//dr amt
						pstmtUpdateTaxProcessBal.setDouble(2, crAmt);			//cr amt
						pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
						pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
						pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
						pstmtUpdateTaxProcessBal.setObject(6, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group
						pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
						pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
						pstmtUpdateTaxProcessBal.setString(9, nextAcctPrd);			//next acct prd
						pstmtUpdateTaxProcessBal.setString(10, nextBalprd);				//balance period
						pstmtUpdateTaxProcessBal.executeUpdate();
					}
					else
					{
						//System.out.println("Amounts for Next Period not found, Inserting for Next Period for Tran Type C.....");
						drAmt = adjAmt;//only this value will change
						crAmt = 0;
						//DD 2/4/2006
						System.out.println(":::::::::::::::::::::: 5 ::::::::::::::::::::::::::::::::::::::::::");
						pstmtInsertTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));												//balance group adj
						pstmtInsertTaxProcessBal.setString(2, nextBalprd);												//balance period
						pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
						pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
						pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
						pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
						pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
						pstmtInsertTaxProcessBal.setString(8, nextAcctPrd);												//next accounting year
						pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
						pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
						pstmtInsertTaxProcessBal.executeUpdate();
					}
					rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
					rsSelectTaxProcessBal = null; // 14/03/08 manoharan
				}
				*/
				//Ended by Chandni 
				
				//adjAmt = adjAmt * -1;
				//System.out.println("Selecting amounts for given Bal Grp for Current Period.....");
				//DD 2/4/2006
				pstmtSelectTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
				pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
				pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtSelectTaxProcessBal.setString(4, acctPrd);			//acct prd
				pstmtSelectTaxProcessBal.setObject(5, currBalprd);				//balance period
				rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();

				if (rsSelectTaxProcessBal.next())
				{
					//System.out.println("Amounts for Current Period found, Updating for Current Period.....");
					crAmt = rsSelectTaxProcessBal.getDouble(2);
					drAmt = rsSelectTaxProcessBal.getDouble(1) + adjAmt;//only this value will change
					
					pstmtUpdateTaxProcessBal.setDouble(1, drAmt);			//dr amt
					pstmtUpdateTaxProcessBal.setDouble(2, crAmt);			//cr amt
					pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
					pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
					pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
					//DD 2/4/2006
					pstmtUpdateTaxProcessBal.setObject(6, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
					pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
					pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
					pstmtUpdateTaxProcessBal.setString(9, acctPrd);			//acct prd
					pstmtUpdateTaxProcessBal.setObject(10, currBalprd);				//balance period
					pstmtUpdateTaxProcessBal.executeUpdate();
				}
				else
				{
					//System.out.println("Amounts for Current Period not found, Inserting for Current Period.....");
					drAmt = adjAmt;//only this value will change
					crAmt = 0;
					//DD 2/4/2006
					System.out.println(":::::::::::::::::::::: 6 ::::::::::::::::::::::::::::::::::::::::::");
					
					pstmtInsertTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));												//balance group adj
					pstmtInsertTaxProcessBal.setString(2, currBalprd);												//balance period
					pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
					pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
					pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
					pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
					pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
					pstmtInsertTaxProcessBal.setString(8, acctPrd);												//accounting year
					pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
					pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
					pstmtInsertTaxProcessBal.executeUpdate();
				}
				rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
				rsSelectTaxProcessBal = null ; // 14/03/08 manoharan
				//System.out.println("(22222222)Processing for Closing balances......");
				//DD 2/4/2006
				pstmtSelectTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
				pstmtSelectTaxProcessBal.setString(2, finEntity);			//financial entity
				pstmtSelectTaxProcessBal.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
				pstmtSelectTaxProcessBal.setString(4, acctPrd);			//acct prd
				pstmtSelectTaxProcessBal.setString(5, "ZZZZZZ  ");				//balance period
				rsSelectTaxProcessBal = pstmtSelectTaxProcessBal.executeQuery();

				if (rsSelectTaxProcessBal.next())
				{
					//System.out.println("(22222222)Closing balance for Current Period found, Updating for current Period for DRCR Type D....");
					crAmt = rsSelectTaxProcessBal.getDouble(2);
					drAmt = rsSelectTaxProcessBal.getDouble(1) + adjAmt;//only this value will change
					
					pstmtUpdateTaxProcessBal.setDouble(1, drAmt);			//dr amt
					pstmtUpdateTaxProcessBal.setDouble(2, crAmt);			//cr amt
					pstmtUpdateTaxProcessBal.setTimestamp(3, this.currDate);			//chg date
					pstmtUpdateTaxProcessBal.setString(4, chgUser);			//chg user
					pstmtUpdateTaxProcessBal.setString(5, chgTerm);			//chg term
					//DD 2/4/2006
					pstmtUpdateTaxProcessBal.setObject(6, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));
					pstmtUpdateTaxProcessBal.setString(7, finEntity);			//financial entity
					pstmtUpdateTaxProcessBal.setObject(8, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
					pstmtUpdateTaxProcessBal.setString(9, acctPrd);			//acct prd
					pstmtUpdateTaxProcessBal.setString(10, "ZZZZZZ  ");				//balance period
					pstmtUpdateTaxProcessBal.executeUpdate();
				}
				else
				{
					//System.out.println("(22222222)Closing balance for Current Period not found, Selecting Opening Balance for Current Period...");
					pstmtSelectTaxProcessBal_1.setObject(1, currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));		//balance group adj
					pstmtSelectTaxProcessBal_1.setString(2, finEntity);			//financial entity
					pstmtSelectTaxProcessBal_1.setObject(3, currRecordList.get(colNameList.indexOf("SITE_CODE")));			//site code
					pstmtSelectTaxProcessBal_1.setString(4, acctPrd);			//acct prd
					pstmtSelectTaxProcessBal_1.setString(5, "000000  ");				//balance period
					rsSelectTaxProcessBal_1 = pstmtSelectTaxProcessBal_1.executeQuery();
					if (rsSelectTaxProcessBal_1.next())
					{
						
						drAmt = rsSelectTaxProcessBal_1.getDouble(1);
						crAmt = rsSelectTaxProcessBal_1.getDouble(2);
					}
					else
					{
						drAmt = 0;
						crAmt = 0;
					}
					rsSelectTaxProcessBal_1.close(); // 18/03/08 manoharan
					rsSelectTaxProcessBal_1 = null; // 18/03/08 manoharan
					drAmt += adjAmt;//only this value will change
					//System.out.println("(22222222)Inserting Closing Balance for Current Period for DRCR Type D....");
					//DD 2/4/2006
					
					pstmtInsertTaxProcessBal.setObject(1, (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")));												//balance group adj
					pstmtInsertTaxProcessBal.setString(2, "ZZZZZZ  ");												//balance period
					pstmtInsertTaxProcessBal.setDouble(3, drAmt);															//debit amount
					pstmtInsertTaxProcessBal.setDouble(4, crAmt);															//credit amount
					pstmtInsertTaxProcessBal.setTimestamp(5, this.currDate);	//change date
					pstmtInsertTaxProcessBal.setString(6, chgUser);													//change user
					pstmtInsertTaxProcessBal.setString(7, chgTerm);												//change terminal number
					pstmtInsertTaxProcessBal.setString(8, acctPrd);												//accounting year
					pstmtInsertTaxProcessBal.setString(9, finEntity);													//fin entity
					pstmtInsertTaxProcessBal.setObject(10, currRecordList.get(colNameList.indexOf("SITE_CODE")));												//site code
					pstmtInsertTaxProcessBal.executeUpdate();
				}
				rsSelectTaxProcessBal.close(); // 14/03/08 manoharan
				rsSelectTaxProcessBal = null; // 14/03/08 manoharan
				//System.out.println("(22222222)End of processing for Closing balances......");
			}
			/*****************end debit type**************/
			System.out.println("Closing Acctprd ......");
			//pstmtSelectAcctprd.close();//Danish 2/14/2006
			//pstmtInsertTaxProcessBal.close();
			//pstmtUpdateTaxProcessBal.close();
			//pstmtSelectTaxProcessBal.close();
			//pstmtSelectTaxProcessBal_1.close();
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{

			try
			{
				if ( rsSelectFinent != null)
				{
					rsSelectFinent.close();
					rsSelectFinent = null;
				}
				if ( rsSelectAcctprd != null)
				{
					rsSelectAcctprd.close();
					rsSelectAcctprd = null;
				}
				if ( rsSelectTaxProcessBal != null)
				{
					rsSelectTaxProcessBal.close();
					rsSelectTaxProcessBal = null;
				}
				if ( rsSelectTaxProcessBal_1 != null)
				{
					rsSelectTaxProcessBal_1.close();
					rsSelectTaxProcessBal_1 = null;
				}

				if ( pstmtSelectAcctprd != null)
				{
					pstmtSelectAcctprd.close();
					pstmtSelectAcctprd = null;
				}
				if ( pstmtInsertTaxProcessBal != null)
				{
					pstmtInsertTaxProcessBal.close();
					pstmtInsertTaxProcessBal = null;
				}
				if ( pstmtUpdateTaxProcessBal != null)
				{
					pstmtUpdateTaxProcessBal.close();
					pstmtUpdateTaxProcessBal = null;
				}
				if ( pstmtSelectTaxProcessBal != null)
				{
					pstmtSelectTaxProcessBal.close();
					pstmtSelectTaxProcessBal = null;
				}
				if ( pstmtSelectTaxProcessBal_1 != null)
				{
					pstmtSelectTaxProcessBal_1.close();
					pstmtSelectTaxProcessBal_1 = null;
				}
			}

			catch(Exception sqle)
			{
				throw new ITMException(sqle);
			}

		}
	}


	private String getUniqueKey(Connection con, String winName, String tranDate)throws ITMException
	{
		String uniqueKey = null;
		String xmlValues = "";
		String balGroupAdj = null;
		try
		{
			//System.out.println("Generating Primary Key ...........");

			tranDate = this.genericUtility.getValidDateString(tranDate,  this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat());
			// 10-08-2006 manoharan
			//if(tranDate.length() > 10)
			//{
			//	tranDate = tranDate.substring(0,10);
			//}
			if (this.genericUtility.getApplDateFormat().length() == 8)
			{
				tranDate = tranDate.substring(0,8);
			}
			else
			{
				tranDate = tranDate.substring(0,10);
			}
			// end 10-08-2006 manoharan
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<sr_no><![CDATA[]]></sr_no>";
			xmlValues = xmlValues +"<site_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("SITE_CODE")) + "]]></site_code>";
			xmlValues = xmlValues +"<tran_date><![CDATA[" + tranDate + "]]></tran_date>";
			xmlValues = xmlValues +"<tran_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TRAN_TYPE")) + "]]></tran_type>";
						// 20-03-2006 manoharan more column values added to generate sr_no based on any of the value
			xmlValues = xmlValues +"<bal_group><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")) + "]]></bal_group>";
			xmlValues = xmlValues +"<bal_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_TYPE")) + "]]></bal_type>";
			xmlValues = xmlValues +"<bal_prd><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_PRD")) + "]]></bal_prd>";
			xmlValues = xmlValues +"<ref_ser><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("REF_SER")) + "]]></ref_ser>";
			xmlValues = xmlValues +"<drcr_flag><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DRCR_FLAG")) + "]]></drcr_flag>";
			xmlValues = xmlValues +"<drcr_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DRCR_TYPE")) + "]]></drcr_type>";
			balGroupAdj = (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ"));
			//System.out.println("Bal group adj ..........." + balGroupAdj);
			if (balGroupAdj == null || balGroupAdj.trim().length() == 0 )
			{
				//System.out.println("Setting Bal group  as bal group adj..........." + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")));
				xmlValues = xmlValues +"<bal_group__adj><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")) + "]]></bal_group__adj>";
			}
			else
			{
				xmlValues = xmlValues +"<bal_group__adj><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")) + "]]></bal_group__adj>";
			}
			xmlValues = xmlValues +"<doc_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DOC_TYPE")) + "]]></doc_type>";
			xmlValues = xmlValues +"<ref_id><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("REF_ID")) + "]]></ref_id>";
			xmlValues = xmlValues +"<tax_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_REF")) + "]]></tax_ref>";
			xmlValues = xmlValues +"<party_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("PARTY_REF")) + "]]></party_ref>";
			xmlValues = xmlValues +"<item_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("ITEM_CODE")) + "]]></item_code>";
			xmlValues = xmlValues +"<tax_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_CODE")) + "]]></tax_code>";
			xmlValues = xmlValues +"<bank_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BANK_CODE")) + "]]></bank_code>";
			xmlValues = xmlValues +"<supp_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("SUPP_CODE")) + "]]></supp_code>";
			xmlValues = xmlValues +"<tax_chap><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_CHAP")) + "]]></tax_chap>";
			xmlValues = xmlValues +"<material_category><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("MATERIAL_CATEGORY")) + "]]></material_category>";
			xmlValues = xmlValues +"<exc_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("EXC_REF")) + "]]></exc_ref>";
			// end 20-03-2006 manoharan more column values added to generate sr_no based on any of the value
			xmlValues = xmlValues +"<net_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("NET_AMT")).toString() + "]]></net_amt>";
			xmlValues = xmlValues +"<dr_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("DR_AMT")).toString() + "]]></dr_amt>";
			xmlValues = xmlValues +"<cr_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("CR_AMT")).toString() + "]]></cr_amt>";
			xmlValues = xmlValues +"<tax_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("TAX_AMT")).toString() + "]]></tax_amt>";

            xmlValues = xmlValues +"</Detail1></Root>";



			Statement stmt = null;
			ResultSet rSet = null;

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName +"' ";
			stmt = con.createStatement();
			rSet = stmt.executeQuery(keyStringQuery);

			String tranSer = null;
			String keyString = null;
			String keyCol = null;
			if(rSet.next())
			{
				keyString = rSet.getString("KEY_STRING");
				keyCol = rSet.getString("TRAN_ID_COL");
				tranSer = rSet.getString("REF_SER");
			}
			rSet.close(); // 14/03/08 manoharan
			rSet = null; // 14/03/08 manoharan
			stmt.close(); // 14/03/08 manoharan
			stmt = null; // 14/03/08 manoharan
			CommonConstants commonConstants = new CommonConstants();
			//TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", dbName);
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);

			//System.out.println("XML for tran id grnrrator....." + xmlValues);
			uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, con);
			System.out.println("Generated tran_id........" + uniqueKey);
		}
		catch(Exception e)
		{
			System.out.println("Exception : getUniqueKey :==>\n"+e);
			uniqueKey = null;
			throw new ITMException(e);
		}
		//System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	private String getUniqueKeyExtra(Connection con, String winName, String tranDate)throws ITMException
	{
		String uniqueKey = null;
		String xmlValues = "";
		String balGroupAdj = null;
		try
		{
			//System.out.println("Generating Primary Key ...........");

			tranDate = this.genericUtility.getValidDateString(tranDate,  this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat());
			// 10-08-2006 manoharan
			//if(tranDate.length() > 10)
			//{
			//	tranDate = tranDate.substring(0,10);
			//}
			if (this.genericUtility.getApplDateFormat().length() == 8)
			{
				tranDate = tranDate.substring(0,8);
			}
			else
			{
				tranDate = tranDate.substring(0,10);
			}
			// end 10-08-2006 manoharan
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<sr_no><![CDATA[]]></sr_no>";
			xmlValues = xmlValues +"<site_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("SITE_CODE")) + "]]></site_code>";
			xmlValues = xmlValues +"<tran_date><![CDATA[" + tranDate + "]]></tran_date>";
			xmlValues = xmlValues +"<tran_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TRAN_TYPE")) + "]]></tran_type>";
						// 20-03-2006 manoharan more column values added to generate sr_no based on any of the value
			xmlValues = xmlValues +"<bal_group__adj><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")) + "]]></bal_group__adj>";
			xmlValues = xmlValues +"<bal_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_TYPE")) + "]]></bal_type>";
			xmlValues = xmlValues +"<bal_prd><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_PRD")) + "]]></bal_prd>";
			xmlValues = xmlValues +"<ref_ser><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("REF_SER")) + "]]></ref_ser>";
			xmlValues = xmlValues +"<drcr_flag><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DRCR_FLAG")) + "]]></drcr_flag>";
			xmlValues = xmlValues +"<drcr_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DRCR_TYPE")) + "]]></drcr_type>";

			balGroupAdj = (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ"));
			//System.out.println("Bal group adj ..........." + balGroupAdj);

			if (balGroupAdj == null || balGroupAdj.trim().length() == 0 )
			{
				//System.out.println("Setting Bal group  as bal group adj..........." + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")));
				xmlValues = xmlValues +"<bal_group><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP")) + "]]></bal_group>";
			}
			else
			{
				xmlValues = xmlValues +"<bal_group><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BAL_GROUP__ADJ")) + "]]></bal_group>";
			}
			xmlValues = xmlValues +"<doc_type><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("DOC_TYPE")) + "]]></doc_type>";
			xmlValues = xmlValues +"<ref_id><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("REF_ID")) + "]]></ref_id>";
			xmlValues = xmlValues +"<tax_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_REF")) + "]]></tax_ref>";
			xmlValues = xmlValues +"<party_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("PARTY_REF")) + "]]></party_ref>";
			xmlValues = xmlValues +"<item_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("ITEM_CODE")) + "]]></item_code>";
			xmlValues = xmlValues +"<tax_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_CODE")) + "]]></tax_code>";
			xmlValues = xmlValues +"<bank_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("BANK_CODE")) + "]]></bank_code>";
			xmlValues = xmlValues +"<supp_code><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("SUPP_CODE")) + "]]></supp_code>";
			xmlValues = xmlValues +"<tax_chap><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("TAX_CHAP")) + "]]></tax_chap>";
			xmlValues = xmlValues +"<material_category><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("MATERIAL_CATEGORY")) + "]]></material_category>";
			xmlValues = xmlValues +"<exc_ref><![CDATA[" + (String)currRecordList.get(colNameList.indexOf("EXC_REF")) + "]]></exc_ref>";
			// end 20-03-2006 manoharan more column values added to generate sr_no based on any of the value
			xmlValues = xmlValues +"<net_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("NET_AMT")).toString() + "]]></net_amt>";
			xmlValues = xmlValues +"<dr_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("DR_AMT")).toString() + "]]></dr_amt>";
			xmlValues = xmlValues +"<cr_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("CR_AMT")).toString() + "]]></cr_amt>";
			xmlValues = xmlValues +"<tax_amt><![CDATA[" + currRecordList.get(colNameList.indexOf("TAX_AMT")).toString() + "]]></tax_amt>";

            xmlValues = xmlValues +"</Detail1></Root>";
			Statement stmt = null;
			ResultSet rSet = null;

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName +"' ";
			stmt = con.createStatement();
			rSet = stmt.executeQuery(keyStringQuery);
			String tranSer = null;
			String keyString = null;
			String keyCol = null;
			if(rSet.next())
			{
				keyString = rSet.getString("KEY_STRING");
				keyCol = rSet.getString("TRAN_ID_COL");
				tranSer = rSet.getString("REF_SER");
			}
			rSet.close(); // 14/03/08 manoharan
			rSet = null; // 14/03/08 manoharan
			stmt.close(); // 14/03/08 manoharan
			stmt = null; // 14/03/08 manoharan
			// 07/10/09 manoharan
			CommonConstants commonConstants = new CommonConstants();
			//TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", dbName);
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, con);
			//System.out.println("XML for tran id grnrrator....." + xmlValues);
			System.out.println("Generated tran_id........" + uniqueKey);
		}
		catch(Exception e)
		{
			System.out.println("Exception : getUniqueKey :==>\n"+e);
			uniqueKey = null;
			throw new ITMException(e);
		}
		//System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	private void populateCurrRecordList(String dataStr)throws ITMException
	{
		//recieved string shall contain the data with "\t" as the field separator
		//tokenize the input string based on "\t" and poulate this.currRecordList as an instance variable
		//while storing data into this.currRecordList transform data as per their corr. datatypes, store it as any object
		String colType = "";
		String colData = "";
		try
		{
			for(int ctrTabdata = 0; dataStr.indexOf("\t") != -1; ctrTabdata++)
			{
				colType = (String)colTypeList.get(ctrTabdata);
				colData = dataStr.substring(0, dataStr.indexOf("\t"));
				//System.out.println("[colType :"+colType+"] [colData :"+colData+"]");
				if(colData.length() > 0)
				{
					if (colType.indexOf("CHAR") != -1)
					{
						this.currRecordList.add(new String(colData));
					}
					else if (colType.indexOf("NUMBER") != -1 || colType.indexOf("DECIMAL") != -1)
					{
						this.currRecordList.add(new Double(colData));
					}
					else if (colType.indexOf("DATETIME") != -1 || colType.indexOf("TIMESTAMP") != -1)
					{
						// 09-08-2006 manoharan
						//if(colData.length() > 10)
						//{
						//	colData = colData.substring(0,10);
						//}
						if (this.genericUtility.getApplDateFormat().length() == 8)
						{
							colData = colData.substring(0,8);
						}
						else
						{
							colData = colData.substring(0,10);
						}

						// end 09-08-2006 manoharan
						String dbDate = this.genericUtility.getValidDateString(colData, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
						//System.out.println("dbDate :["+dbDate+"]");
						this.currRecordList.add(java.sql.Date.valueOf(dbDate));
					}
				}
				else
				{
					//this.currRecordList.add(null);
					if (colType.indexOf("NUMBER") != -1 || colType.indexOf("DECIMAL") != -1)
					{
						this.currRecordList.add(new Double("0.0"));
					}
					else
					{
						this.currRecordList.add("");
					}
				}
				dataStr = dataStr.substring(dataStr.indexOf("\t") +1);
			}
			//System.out.println("this.currRecordList["+this.currRecordList.size()+"] :\n"+this.currRecordList);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	private void populateMetadata(String metaDataStr)throws ITMException
	{
		//this should result into poulating 2 instance level arraylists
		//tokenize the input string based on "\t" all odd no. tokens add to colNameList and all even no. tokens add to colTypeList
		//colNameList
		//colTypeList
		try
		{
			for(int ctrMetadata = 1; metaDataStr.indexOf("\t") != -1; ctrMetadata++)
			{
				if (ctrMetadata%2 == 0)
				{
					this.colTypeList.add(metaDataStr.substring(0, metaDataStr.indexOf("\t")).trim().toUpperCase());
				}
				else
				{
					this.colNameList.add(metaDataStr.substring(0, metaDataStr.indexOf("\t")).trim().toUpperCase());
				}
				metaDataStr = metaDataStr.substring(metaDataStr.indexOf("\t") + 1);
			}
			//System.out.println("this.colNameList["+this.colNameList.size()+"] :\n"+this.colNameList);
			//System.out.println("this.colTypeList["+this.colTypeList.size()+"] :\n"+this.colTypeList);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	private void setMetaData(String winName)
	{


		Document dom = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String tagName = null;
		String tagValue = null;
		String colName = "";
		String colType = "";
		String childNodeName = "";
		String fldType="";
		String ObjName ="";
		String filename ="";
		//String winName = "w_tax_process";
		String objContext ="2";
		try
		{
				ObjName =winName.substring(2,winName.length())+"1"+objContext;
				//System.out.println("ObjName :: "+ObjName);
				filename = CommonConstants.JBOSSHOME + java.io.File.separator + "bin" + java.io.File.separator + "metadata" + java.io.File.separator + ObjName.trim() + ".xml";
				//System.out.println("filename :: "+filename);
				java.io.File file = new java.io.File(filename);
				DocumentBuilder parser1 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				dom = parser1.parse(file);
				NodeList columnsNodeList = dom.getElementsByTagName("table_column");
				int tableColLength = columnsNodeList.getLength();
				//System.out.println("tableColLength :: "+tableColLength);
				for(int i= 0  ;i < tableColLength;i++ )
				{
					NodeList columnNodeList  =  columnsNodeList.item(i).getChildNodes();
					int tableColChildLength = columnNodeList.getLength();
					for(int j= 0 ;j <  tableColChildLength;j++)
					{
						Node colNode = columnNodeList.item(j) ;
						tagName = colNode.getNodeName() ;


						if (tagName.equals("type") )
						{
							colType = colNode.getFirstChild().getNodeValue();
						}
						if (tagName.equals("name"))
						{
							colName = colNode.getFirstChild().getNodeValue();
						}
					}
					this.colTypeList.add(colType.trim().toUpperCase());
					this.colNameList.add(colName.trim().toUpperCase());
				}

				//System.out.println("this.colNameList["+this.colNameList.size()+"] :\n"+this.colNameList);
				//System.out.println("this.colTypeList["+this.colTypeList.size()+"] :\n"+this.colTypeList);
		}
		catch(java.io.FileNotFoundException fileNotFound)
		{
			System.out.println("Exception ::constructor :==>");
			fileNotFound.printStackTrace();
		}
		catch(Exception e )
		{
			e.printStackTrace();

		}

	}
//	**************************************** added on 07022007 ***************************************
	private void setDates(Connection conn)throws ITMException
	{
		//local variable
		java.sql.Timestamp frDateTs =null;
		java.sql.Timestamp toDateTs =null;
		PreparedStatement pstmt=null;
		ResultSet rs =null;
		Calendar cal = Calendar.getInstance();
		String dateStr =null;
		int date = 0;
		int month=0;
		int year=0;
		String prd=null;

		java.sql.Date tranDate = (java.sql.Date)this.currRecordList.get(this.colNameList.indexOf("PROC_DATE"));

		try
		{
			System.out.println("Inside setDates(Connection)");
			System.out.println("tranDate [" + tranDate+ "]");
			//System.out.println("Transaction Date ["+tranDate+"]");
			//System.out.println("Inside setDates(Connection conn)");
			//Calculaing Current Balance Period
			cal.setTime(tranDate);
			date=cal.get(Calendar.DATE);
			month=cal.get(Calendar.MONTH);
			year=cal.get(Calendar.YEAR);
			// 07/10/09 manoharan in jdk1.6 gives exception if format for timestamp is yyyy-mm-d hh:mm:ss.fff
			//dateStr= new Integer(year).toString()+"-"+new Integer(month+1).toString()+"-"+new Integer(date).toString();
			dateStr= new Integer(year).toString()+"-"+(new java.text.DecimalFormat( "00" )).format( month + 1)+"-"+(new java.text.DecimalFormat( "00" )).format( date );
			System.out.println("dateStr:::["+dateStr+"]");
			System.out.println("timestamp dateStr :::["+dateStr+" 00:00:00.0]");
		 	Timestamp currTranDate = java.sql.Timestamp.valueOf(dateStr+" 00:00:00.0");
			//System.out.println("currTranDate:::["+currTranDate+"]");
			prd = (currTranDate.toString()).substring(0,currTranDate.toString().indexOf(" "));
			String FltStr[] = prd.split("-");
			currBalprd = FltStr[0]+FltStr[1]+FltStr[2];
			System.out.println("currBalPeriod:::["+currBalprd+"]");

			//Calculating The Previous TranDate
			cal.add(cal.YEAR,-1);
			date=cal.get(Calendar.DATE);
			month=cal.get(Calendar.MONTH);
			year=cal.get(Calendar.YEAR);
			// 07/10/09 manoharan in jdk1.6 gives exception if format for timestamp is yyyy-mm-d hh:mm:ss.fff
			//dateStr= new Integer(year).toString()+"-"+new Integer(month+1).toString()+"-"+new Integer(date).toString();
			dateStr= new Integer(year).toString()+"-"+(new java.text.DecimalFormat( "00" )).format( month+1 )+"-"+(new java.text.DecimalFormat( "00" )).format( date );
		 	this.prevYearTranDate = java.sql.Timestamp.valueOf(dateStr+" 00:00:00.0");
			System.out.println("previousTranDate:::["+this.prevYearTranDate+"]");

			//Calculating The Next Capital Date
			String 	sql = "select FR_DATE  ,TO_DATE  from acctprd where fr_date <= ? and to_date >= ?";
			//System.out.println("Sql----->"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1,currTranDate);
			pstmt.setTimestamp(2,currTranDate);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				frDateTs = rs.getTimestamp(1);
				toDateTs = rs.getTimestamp(2);

			}
			else
			{
				System.out.println("Record Not Found in Account Period");
			}
			rs.close(); // 17/03/08 manoharan
			rs = null; // 17/03/08 manoharan
			pstmt.close(); // 18/03/08 manoharan
			pstmt = null; // 18/03/08 manoharan
			//System.out.println("frDateTs=["+frDateTs+"]");
			//System.out.println("toDateTs=["+toDateTs+"]");

			cal.setTime(toDateTs);
			cal.add(cal.DATE,1);
			date=cal.get(Calendar.DATE);
			month=cal.get(Calendar.MONTH);
			year=cal.get(Calendar.YEAR);
			// 21/01/2008 manoharan 1st april to be had-coded
			//dateStr= new Integer(year).toString()+"-"+new Integer(month+1).toString()+"-"+new Integer(date).toString();
			if(month >= 4)
			{
				year ++;
			}
			// 07/10/09 manoharan in jdk1.6 gives exception if format for timestamp is yyyy-mm-d hh:mm:ss.fff
			//dateStr= new Integer(year).toString()+"-"+new Integer(4).toString()+"-"+new Integer(1).toString();
			dateStr= new Integer(year).toString()+"-04-01";
		 	this.nextYearCapitalDate = java.sql.Timestamp.valueOf(dateStr+" 00:00:00.0");
		 	// 07/10/09 manoharan in jdk1.6 gives exception if format for timestamp is yyyy-mm-d hh:mm:ss.fff
			//dateStr= new Integer(year - 1).toString()+"-"+new Integer(4).toString()+"-"+new Integer(1).toString();
			dateStr= new Integer(year - 1).toString()+"-04-01";
		 	this.prevYearTranDate = java.sql.Timestamp.valueOf(dateStr+" 00:00:00.0");

			System.out.println("nextYearCapitalDate:::["+this.nextYearCapitalDate+"]");
			System.out.println("prevYearTranDate   :::["+this.prevYearTranDate+"]");

			//Calculating Next Balance Period
			prd = (this.nextYearCapitalDate.toString()).substring(0,this.nextYearCapitalDate.toString().indexOf(" "));
			String FltStr1[] = prd.split("-");
			nextBalprd = FltStr1[0]+FltStr1[1]+FltStr1[2];
			System.out.println("nextBalancePeriod:::["+nextBalprd+"]");
			//rs.close();
			//pstmt.close();

		}
		catch(Exception e){e.printStackTrace();}
	}


//	******************************************* end ******************************************************
	private void setDates()throws ITMException
	{
		int getVal = 0;
		try
		{
			System.out.println("Inside setDates()");
			//System.out.println("Set Dates :["+this.currRecordList.get(this.colNameList.indexOf("TRAN_DATE"))+"]");
			//**********added latter
			//java.sql.Date tranDate = (java.sql.Date)this.currRecordList.get(this.colNameList.indexOf("TRAN_DATE"));
			java.sql.Date tranDate = (java.sql.Date)this.currRecordList.get(this.colNameList.indexOf("PROC_DATE"));
			// 13-08-2007 manoharan deprecated method to be avoided
			//int currYear = tranDate.getYear() + 1900;
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(tranDate);
			//int currYear = tranDate.getYear() + 1900;
			int currYear = calendar.get(Calendar.YEAR);
			//this.nextYearCapitalDate = java.sql.Timestamp.valueOf((currYear + 1) +"-04-01 00:00:00");
			calendar.set(Calendar.YEAR, currYear + 1);
			calendar.set(Calendar.MONTH, 4);
			calendar.set(Calendar.DAY_OF_MONTH, 1);
			java.util.Date tempDate = calendar.getTime();
			SimpleDateFormat sdt=new SimpleDateFormat("yyyy-MM-dd");
			this.nextYearCapitalDate = java.sql.Timestamp.valueOf(sdt.format(tempDate) + " 00:00:00.000");
			//this.prevYearTranDate = java.sql.Timestamp.valueOf((currYear - 1) + "-" + (tranDate.getMonth() + 1) + "-" + tranDate.getDate() + " 00:00:00");
			calendar.setTime(tranDate);
			calendar.set(Calendar.YEAR, currYear - 1);
			tempDate = calendar.getTime();
			this.prevYearTranDate = java.sql.Timestamp.valueOf(sdt.format(tempDate) + " 00:00:00.000");
			currBalprd = Integer.toString(currYear);
			calendar.setTime(tranDate);
			getVal = calendar.get(Calendar.MONTH);//tranDate.getMonth();
			getVal = getVal + 1;
			if(getVal < 10)
			{
				currBalprd = currBalprd + "0";
			}
			currBalprd = currBalprd + Integer.toString(getVal);
			getVal = calendar.get(Calendar.DAY_OF_MONTH);//tranDate.getDate();
			if(getVal < 10)
			{
				currBalprd = currBalprd + "0";
			}
			currBalprd = currBalprd + Integer.toString(getVal);

			nextBalprd = Integer.toString(currYear + 1);
			calendar.setTime(this.nextYearCapitalDate);
			getVal = calendar.get(Calendar.MONTH); //this.nextYearCapitalDate.getMonth();
			getVal = getVal + 1;
			if(getVal < 10)
			{
				nextBalprd = nextBalprd + "0";
			}
			nextBalprd = nextBalprd + Integer.toString(getVal);
			getVal = calendar.get(Calendar.DAY_OF_MONTH);//this.nextYearCapitalDate.getDate();
			if(getVal < 10)
			{
				nextBalprd = nextBalprd + "0";
			}
			nextBalprd = nextBalprd + Integer.toString(getVal);
			//System.out.println("Trandate :"+tranDate+":");
			//System.out.println("nextYearCapitalDate :"+this.nextYearCapitalDate+":");
			//System.out.println("prevYearTranDate :"+this.prevYearTranDate+":");
			//System.out.println("currBalprd :"+currBalprd+":");
			//System.out.println("nextBalprd :"+nextBalprd+":");
			//System.out.println("currYear :"+ currYear+":");
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}

	private ITMDBAccessLocal getITMAccess()throws ITMException
	{
		ITMDBAccessLocal itmDBAccess = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			 itmDBAccess = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			//itmDBAccess = itmDBAccessHome.create();
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return itmDBAccess;
	}
	//Changed by Rohan on 10-02-12 to check capital item.start
	public boolean isCapitalItem(String balGroup,Connection conn) throws Exception
	{
		
		String capitalItem = "";
		String[] capItem;
	    String delimiter = ",";
	    boolean isCapitalItem = false;
		
		try
		{
			capitalItem  = discommon.getDisparams("999999","CAPITAL_GRP",conn);
		    capItem = capitalItem.split(delimiter);
		    
		    for(int i =0; i < capItem.length ; i++)
		    {	  
		        if(balGroup.equals(capItem[i]))
		        {
		        	isCapitalItem = true;
		        }
		    }
	    }
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			
		}
		
		return isCapitalItem;
	
	}
	//Changed by Rohan on 10-02-12 to check capital item.end

}
