

/********************************************************
	Title : StockAllocIc
	Date  : 02/12/2011
	Developer: Dipak Chattar

 ********************************************************/

package ibase.webitm.ejb.dis;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.text.SimpleDateFormat;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; // added for ejb3


@Stateless // added for ejb3

public class StockAllocIc extends ValidatorEJB implements StockAllocIcLocal, StockAllocIcRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();

	//method for validation
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	//method for validation
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String siteCode = "";
		String tranDate = "";
		String saleOrder = "";
		String itemCode = "";
		String lotNo = "";
		String lotSl = "";
		String locCode = "";
		String quantity = "";
		String lineNoSord = "";
		String expLev = "";
		//Changed By Rohan on 10/07/12 To add validation sale order.start
		String saleOrderHdr = "";
		String sqlSOrder = "";
		//Changed By Rohan on 10/07/12 To add validation sale order.end

		int ctr=0;
		int cnt = 0;
		int cnt1 = 0;
		double pendingQty = 0.0;
		int currentFormNo = 0;
		int childNodeListLength;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("tran_date"))
					{    
						tranDate = genericUtility.getColumnValue("tran_date", dom);
						if(tranDate == null || tranDate.trim().length() == 0)
						{
							errCode = "VTTRAN1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase()); 
						}

					}
					else if(childNodeName.equalsIgnoreCase("site_code"))
					{ 
						siteCode = genericUtility.getColumnValue("site_code", dom);
						if(siteCode == null || (siteCode.length() == 0))
						{
							errList.add("VMSITECOD");
							errFields.add(childNodeName.toLowerCase());
						}
						if(siteCode != null && (siteCode.trim().length() > 0))
						{
							sql = " select count(*) from site where site_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMSITE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("sale_order"))
					{    
						saleOrder = genericUtility.getColumnValue("sale_order", dom);
						if(saleOrder == null || saleOrder.trim().length() == 0)
						{
							errCode = "VMSORD2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else
						{
							sql = " select count(*) from sorder where sale_order = ?  and confirmed='Y'  and  status= (case when status is null then 'P' else status end) ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,saleOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMSORD1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}

					}
				}			

				break;

			case 2 : 
				parentNodeList = dom1.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				//Changed By Rohan on 10/17/12 to add validation on sale order
				saleOrderHdr = genericUtility.getColumnValue("sale_order", dom1 );
				System.out.println("saleOrderHdr==*****==>"+saleOrderHdr);
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("sale_order"))
					{    
						saleOrder = genericUtility.getColumnValue("sale_order", dom);
						if(saleOrder == null || saleOrder.trim().length() == 0)
						{
							errCode = "VMSORD2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else
						{
							sql = " select count(*) from sorder where sale_order = ?  and confirmed='Y'  and  status= (case when status is null then 'P' else status end) ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,saleOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMSORD1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							//Changed by Rohan on 10/07/12 To addvalidation on hdr & Detail.start
							
							if(!(saleOrder.equalsIgnoreCase(saleOrderHdr)))
							{
								errCode = "VMSORDER";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							//Changed by Rohan on 10/07/12 To addvalidation on hdr & Detail.end
						}

					}
					else if(childNodeName.equalsIgnoreCase("site_code"))
					{ 
						siteCode = genericUtility.getColumnValue("site_code", dom);
						if(siteCode == null || (siteCode.length() == 0))
						{
							errList.add("VMSITECOD");
							errFields.add(childNodeName.toLowerCase());
						}
						if(siteCode != null && (siteCode.trim().length() > 0))
						{
							sql = " select count(*) from site where site_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMSITE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("item_code"))
					{    
						itemCode = genericUtility.getColumnValue("item_code", dom);
						if(itemCode == null || itemCode.trim().length() == 0)
						{
							errCode = "VMITMC2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else
						{
							sql = " select count(*) from item where item_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,itemCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMITMC1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("loc_code"))
					{    
						locCode = genericUtility.getColumnValue("loc_code", dom);
						if(locCode == null || locCode.trim().length() == 0)
						{
							errCode = "VTLOCN2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else
						{
							sql = " select count(*) from location where loc_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,locCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VTLOCN1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}									
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
						}

					}
					else if(childNodeName.equalsIgnoreCase("line_no__sord"))
					{
						lineNoSord = genericUtility.getColumnValue("line_no__sord", dom);
						if(lineNoSord == null || lineNoSord.trim().length() == 0)
						{
							errCode = "VTSORDLINE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if(childNodeName.equalsIgnoreCase("exp_lev"))
					{
						expLev = genericUtility.getColumnValue("exp_lev", dom);
						saleOrder = genericUtility.getColumnValue("sale_order", dom);
						lineNoSord = genericUtility.getColumnValue("line_no__sord", dom);
						if(expLev == null || expLev.trim().length() == 0)
						{
							errCode = "VTEXPL2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else
						{
							if(lineNoSord != null && lineNoSord.trim().length() > 0)
							{
								lineNoSord = "   " + lineNoSord;
								lineNoSord = lineNoSord.substring( lineNoSord.length()-3 );

								sql = " select count(*) from sorditem where sale_order = ? and line_no = ? and exp_lev = ? and line_type = 'I' ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,saleOrder);
								pstmt.setString(2,lineNoSord);
								pstmt.setString(3,expLev);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										errCode = "VTEXPL1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());	
									}									
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("lot_no"))
					{    
						lotNo = genericUtility.getColumnValue("lot_no", dom);

						if(lotNo == null || lotNo.trim().length() == 0)
						{
							errCode = "VTLOTNO";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if(childNodeName.equalsIgnoreCase("lot_sl"))
					{    
						lotSl = genericUtility.getColumnValue("lot_sl", dom);

						if(lotSl == null || lotSl.trim().length() == 0)
						{
							errCode = "VTLOTSL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						//Change by Rohan on 10/07/12 To check.start
						
						itemCode = genericUtility.getColumnValue("item_code", dom);
						siteCode = genericUtility.getColumnValue("site_code", dom);
						locCode = genericUtility.getColumnValue("loc_code", dom);
						lotNo = genericUtility.getColumnValue("lot_no", dom);
						Map tempMap = new HashMap();
						Map currentDetailMap = new HashMap();
						ArrayList tempList = new ArrayList();
						
						tempMap.put("item_code", itemCode);
						tempMap.put("site_code", siteCode);
						tempMap.put("loc_code", locCode);
						tempMap.put("lot_no", lotNo);
						tempMap.put("lot_sl", lotSl);
						System.out.println(" temp  map "+tempMap);
						tempList.add(tempMap);
						currentDetailMap.put("Detail2", tempList);
						System.out.println(" current detail map "+currentDetailMap);
												
						
						
						/*
						if(rs != null)
						{
							rs.close(); 
							rs = null;
						}
						if(pstmt != null)
						{	
							pstmt.close();
							pstmt = null;
						}
						*/	
						System.out.println("itemCode"+itemCode+"siteCode"+siteCode+"locCode"+locCode+"lotNo"+lotNo+"lotSl"+lotSl);
						
						sql = " select count(*) as CN1 from stock where item_code = ? and site_code = ? and loc_code = ? "
							+" and lot_no = ? and lot_sl = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,itemCode);
						pstmt.setString(2,siteCode);
						pstmt.setString(3,locCode);
						pstmt.setString(4,lotNo);
						pstmt.setString(5,lotSl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt1 =  rs.getInt("CN1");
							if(cnt1 == 0) 
							{
								errCode = "VTNTFOUND";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
							//Changed by sumit on 21/08/12 checking for repeating detail start.
							else
							{								
								boolean isDupDetail = checkDetail(dom2, conn);								
								if(isDupDetail)
								 {									 
									errCode = "DUPDETAIL2";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								 }								
							}
							//Changed by sumit on 21/08/12 checking for repeating detail end.
						}
						
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						//Change by Rohan on 10/07/12 To check.end
					}
					else if(childNodeName.equalsIgnoreCase("quantity"))
					{
						String pendingQtyDom = "";
						String quantityDom = "";
						quantityDom = genericUtility.getColumnValue("quantity", dom);
						pendingQtyDom = genericUtility.getColumnValue("pending_qty", dom);
						
						if ( quantityDom == null || quantityDom.trim().length() == 0  )
						{
							quantityDom = "0";
						}
						if ( pendingQtyDom == null || pendingQtyDom.trim().length() == 0  )
						{
							pendingQtyDom = "0";
						}
						if( Double.parseDouble(quantityDom) == 0 )
						{
							errCode = "VTQUANTITY";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if(Double.parseDouble(quantityDom) > Double.parseDouble(pendingQtyDom) )
						{
							errCode = "VTSORDQTY";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
				}
				break;

			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	// method for item change
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("XML STRING======>----------------------------");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			System.out.println("XML STRING======>"+xmlString1);
			dom2 = parseString(xmlString2);
			System.out.println("XML STRING======555555555555555555555===>"+xmlString2);
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		System.out.println("valueXmlStringvalueXmlStrin ST"+valueXmlString);
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		String childNodeName = null;
		String siteCode = "";
		String itemCode = "";
		String itemDescr = "";
		String dateNow = "";
		String quantity = "";
		String saleOrder = "";
		String lineNoSord = "";
		String expLev = "";
		String custCode = "";
		String custDescr = "";
		String chgUser = "";
		String chgTerm = "";
		String sql = "";
		String siteDescr = "";
		String locCode = "";
		String locDescr = "";

		int ctr = 0;
		int currentFormNo = 0;
		double pendingQty = 0.0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		try
		{   
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));

			siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);

			chgUser =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			chgTerm =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
			
			dateNow = simpleDateFormat.format(currentDate.getTime());

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
						}
					}
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" +  siteDescr + "]]>").append("</site_descr>");

					valueXmlString.append("<tran_date>").append("<![CDATA[" + dateNow + "]]>").append("</tran_date>");
					valueXmlString.append("<add_date>").append("<![CDATA[" + dateNow + "]]>").append("</add_date>");
					valueXmlString.append("<add_user>").append("<![CDATA[" + chgUser + "]]>").append("</add_user>");
					valueXmlString.append("<add_term>").append("<![CDATA[" + chgTerm + "]]>").append("</add_term>");

				}//end of if
				else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					/*--Commented by gulzar
					siteCode = genericUtility.getColumnValue("site_code", dom);
					chgUser =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
					chgTerm =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
					dateNow = simpleDateFormat.format(currentDate.getTime());
					valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
					valueXmlString.append("<tran_date>").append("<![CDATA[" + dateNow + "]]>").append("</tran_date>");
					valueXmlString.append("<add_date protect = \"1\">").append("<![CDATA[" + dateNow + "]]>").append("</add_date>");
					valueXmlString.append("<add_user protect = \"1\">").append("<![CDATA[" + chgUser + "]]>").append("</add_user>");
					valueXmlString.append("<add_term protect = \"1\">").append("<![CDATA[" + chgTerm + "]]>").append("</add_term>");
					*/
				}
				else if(currentColumn.trim().equalsIgnoreCase("sale_order"))
				{
					saleOrder = genericUtility.getColumnValue("sale_order", dom);
					custCode = findValue(conn, "cust_code" ,"sorder", "sale_order", saleOrder);
					valueXmlString.append("<cust_code>").append("<![CDATA[" +  custCode + "]]>").append("</cust_code>");
					custDescr = findValue(conn, "cust_name" ,"customer", "cust_code", custCode);
					valueXmlString.append("<cust_name>").append("<![CDATA[" +  custDescr + "]]>").append("</cust_name>");
				}

				valueXmlString.append("</Detail1>");
				break;       

			case 2 : 
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
						}
					}
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));

				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					/*--commented and changes below by gulzar on 12/24/2011
					siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
					valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
					*/
					saleOrder = genericUtility.getColumnValue("sale_order", dom1, "1");
					siteCode = genericUtility.getColumnValue("site_code", dom1, "1");
					siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
					valueXmlString.append("<sale_order>").append("<![CDATA[" +  saleOrder + "]]>").append("</sale_order>");
					valueXmlString.append("<site_code protect = \"1\">").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" +  siteDescr + "]]>").append("</site_descr>");
					valueXmlString.append("<quantity>").append("<![CDATA[0]]>").append("</quantity>");

				}//end of if
				else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					/*--commented by gulzar on 12/24/2011
					siteCode = genericUtility.getColumnValue("site_code", dom);
					itemCode = genericUtility.getColumnValue("item_code", dom);
					valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
					itemDescr = findValue(conn, "descr" ,"item", "item_code", itemCode);
					valueXmlString.append("<item_descr>").append("<![CDATA[" +  itemDescr + "]]>").append("</item_descr>");
					*/

				}
				else if(currentColumn.trim().equalsIgnoreCase("item_code"))
				{
					itemCode = genericUtility.getColumnValue("item_code", dom);
					itemDescr = findValue(conn, "descr" ,"item", "item_code", itemCode);
					valueXmlString.append("<item_descr>").append("<![CDATA[" +  itemDescr + "]]>").append("</item_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					siteCode = genericUtility.getColumnValue("site_code", dom);
					siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
					valueXmlString.append("<site_descr>").append("<![CDATA[" +  siteDescr + "]]>").append("</site_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("loc_code"))
				{
					locCode = genericUtility.getColumnValue("loc_code", dom);
					locDescr = findValue(conn, "descr" ,"location", "loc_code", locCode);
					valueXmlString.append("<location_descr>").append("<![CDATA[" +  locDescr + "]]>").append("</location_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("sale_order") || currentColumn.trim().equalsIgnoreCase("line_no__sord") || currentColumn.trim().equalsIgnoreCase("exp_lev") )
				{
					saleOrder = checkNull(genericUtility.getColumnValue("sale_order", dom));
					lineNoSord = checkNull(genericUtility.getColumnValue("line_no__sord", dom));
					expLev = checkNull(genericUtility.getColumnValue("exp_lev", dom));
					lineNoSord = "   " + lineNoSord.trim();
					lineNoSord = lineNoSord.substring( lineNoSord.length()-3 );
					
					if (lineNoSord.trim().length() > 0 )
					{
						valueXmlString.append("<line_no__sord>").append("<![CDATA[" +  lineNoSord + "]]>").append("</line_no__sord>");
					}
					if (saleOrder.trim().length() > 0 && lineNoSord.trim().length() > 0 && expLev.trim().length() > 0 )
					{
						sql = "SELECT ITEM_CODE,(CASE WHEN quantity IS NULL THEN 0 ELSE quantity END - CASE WHEN qty_alloc IS NULL THEN 0 ELSE qty_alloc END - CASE WHEN qty_desp IS NULL THEN 0 ELSE qty_desp END )"
								+ " FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_NO = ? AND EXP_LEV = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,saleOrder);
						pstmt.setString(2,lineNoSord);
						pstmt.setString(3,expLev);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							itemCode = rs.getString("ITEM_CODE");
							pendingQty  =  rs.getDouble(2);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append("<pending_qty>").append("<![CDATA[" +  pendingQty + "]]>").append("</pending_qty>");
						valueXmlString.append("<item_code>").append("<![CDATA[" +  itemCode + "]]>").append("</item_code>");
						itemDescr = findValue(conn, "descr" ,"item", "item_code", itemCode);
						valueXmlString.append("<item_descr>").append("<![CDATA[" +  itemDescr + "]]>").append("</item_descr>");
					}
				}

				valueXmlString.append("</Detail2>");
				break;

			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}	 


	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	private String checkNull( String input )
	{
		if (input == null )
		{
			input = "";
		}
		return input;
	}
	
	//Changed by sumit on 21/08/12 checking duplicate deatil start
	private boolean checkDetail(Document allDom, Connection conn) throws ITMException
	{
		
		String itemCode = "", siteCode ="", locCode = "", lotSl = "", lotNo ="";
		NodeList parentNodeList = null, childNodeList  = null;
		Node parentNode = null, childNode = null;
	    int parentNodeListLength = 0;
	    String childNodeName = "";
		String domID = "";
		Map detailMap = new HashMap();		
		boolean isDupDetail = false;
		
		try {
			parentNodeList = allDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for (int row = 0; row < parentNodeList.getLength(); row++) 
			{
				parentNode = parentNodeList.item(row);
				childNodeList = parentNode.getChildNodes();
				
				System.out.println("************* first For loop *************["+ parentNode.getNodeName() + "]");
				for (int col = 0; col < childNodeList.getLength(); col++) {
					childNode = childNodeList.item(col);
					domID = parentNode.getAttributes().getNamedItem("domID").getNodeValue();					
					if (childNode.getNodeType() == childNode.ELEMENT_NODE) 
					{
						childNodeName = childNode.getNodeName();
						//domID = parentNode.getAttributes().getNamedItem("domID").getNodeValue();
						//System.out.println("=======--======== ["+domID+"]");
						//System.out.println("childNodeNamechildNodeName ** ["+childNodeName+"]");
						if ("item_code".equalsIgnoreCase(childNodeName)) 
						{
							itemCode = childNode.getFirstChild().getNodeValue().trim();							
							
						}
						else if ("site_code".equalsIgnoreCase(childNodeName)) 
						{
							siteCode = childNode.getFirstChild().getNodeValue().trim();							
						}
						else if ("loc_code".equalsIgnoreCase(childNodeName)) 
						{
							locCode = childNode.getFirstChild().getNodeValue().trim();							
						}
						else if ("lot_no".equalsIgnoreCase(childNodeName)) 
						{
							lotNo = childNode.getFirstChild().getNodeValue().trim();							
						}
						else if ("lot_sl".equalsIgnoreCase(childNodeName)) 
						{
							lotSl = childNode.getFirstChild().getNodeValue().trim();
							/*arryList.add(childNode.getFirstChild().getNodeValue().trim());
							tempMap.put("lot_sl", childNode.getFirstChild().getNodeValue().trim());*/
						}
					}							
					
				}
				/*tempList.add(tempMap);
				System.out.println(" detail arrayaList  "+arryList);*/
				if(detailMap.containsKey(itemCode+siteCode+locCode+lotNo+lotSl))
				{
					isDupDetail = true;
				}
				else
				{
					detailMap.put(itemCode+siteCode+locCode+lotNo+lotSl, "Detail2:"+domID);
				}
				System.out.println(" detailMap in checkdetail "+detailMap);	
				System.out.println(" isDupDetail "+isDupDetail);							
			}	
			
		} 
		catch (Exception e) 
		{
			System.out.println( "Exception : StockAllocIc:wfValData:checkDetail : " + e.getMessage() );
			throw new ITMException(e);
		}
		return isDupDetail;
	}
	//Changed by sumit on 21/08/12 checking duplicate deatil end.


}	
