package ibase.webitm.ejb.dis;
import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;

import java.text.SimpleDateFormat;
import javax.ejb.Stateless; // added for ejb3
import ibase.webitm.ejb.dis.adv.*;

@Stateless
public class InvHoldRelGen extends ProcessEJB implements InvHoldRelGenLocal, InvHoldRelGenRemote
{

	DistCommon distCommonObj = new DistCommon();
	GenericUtility genericUtility = GenericUtility.getInstance();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	
	@Override
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	//getData Method
	
	@Override
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;	
		
		try
		{
				
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			
			System.out.println("Exception :InvHoldRelGenEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
			throw new ITMException(e);
		
		}
		return rtrStr; 
	}//END OF GETDATA(1)
	
	public String blanknull(String s)
	{
		if( s==null )
			return " ";
		else
			return s;
	}
	
	
	@Override
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		String errCode = "";
		String errString = "";
		String getDataSql= "" ;

		String resultString = "";
		ResultSet rs1 = null;
		PreparedStatement pstmt = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		int cnt=0,count=0,i=5;
		String sql="";
		String tranIdFrom = "",tranIdTo="",refIdFrom="",refIdTo="",autoConfirmed="",schRelDateFromstr="",schRelDateTostr="";
		Timestamp schRelDateFrom=null,schRelDateTo=null;
				
				
				
		ConnDriver connDriver = new ConnDriver();
		Connection conn= null;
		try
		{
			if(conn==null)
			{
				conn = connDriver.getConnectDB("DriverITM");
				 
				conn.setAutoCommit(false);	
			}
			DatabaseMetaData dbmd = conn.getMetaData();
			System.out.println("DriverName["+dbmd.getDriverName() + "]");
			System.out.println("DriverURI["+dbmd.getURL()  + "]");
			System.out.println("DriverUSER["+dbmd.getUserName() +"]");
					
			System.out.println("InvHoldRelGen : getData() Method Called");
			
			tranIdFrom = genericUtility.getColumnValue("tran_id__from",headerDom);
			tranIdTo = genericUtility.getColumnValue("tran_id__to",headerDom);
			schRelDateFromstr = genericUtility.getColumnValue("sch_rel_date__from",headerDom);
			schRelDateTostr = genericUtility.getColumnValue("sch_rel_date__to",headerDom);
			refIdFrom = genericUtility.getColumnValue("ref_id__from",headerDom);
			refIdTo = genericUtility.getColumnValue("ref_id__to",headerDom);
			autoConfirmed = genericUtility.getColumnValue("auto_confirmed",headerDom);
			
			
			
			//SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("schRelDateFromstr : ["+schRelDateFromstr+"]:::schRelDateTostr:["+schRelDateTostr+"]");
			if(schRelDateFromstr != null)
			{
				System.out.println("schRelDateFromstr : ["+schRelDateFromstr);
				schRelDateFrom= Timestamp.valueOf(genericUtility.getValidDateString(schRelDateFromstr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			}
			if(schRelDateTostr != null)
			{
				System.out.println(" :::schRelDateTostr:["+schRelDateTostr+"]");
				schRelDateTo= Timestamp.valueOf(genericUtility.getValidDateString(schRelDateTostr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			}
			System.out.println("schRelDateFrom : ["+schRelDateFrom+"]:::schRelDateTo:["+schRelDateTo+"]");
			System.out.println("tranIdFrom=>"+tranIdFrom);
			System.out.println("tranIdTo=>"+tranIdTo);
			System.out.println("refIdFrom =>"+refIdFrom);
			System.out.println("refIdTo =>"+refIdTo);
			System.out.println("autoConfirmed =>"+autoConfirmed);
			
			if ( tranIdFrom == null || tranIdFrom.trim().length() == 0 )
			{
				System.out.println("tran id from is Null...");
				errString = itmDBAccessEJB.getErrorString("","VMTRIDFRNU","","",conn);
				return errString;
			}
			else
			{
			/*
				sql = "select count(1) from inv_hold_det where tran_id ='" + tranIdFrom + "'";
			    pstmt = conn.prepareStatement(sql);
			    rs1 = pstmt.executeQuery();
			    if (rs1.next())
			    {
				cnt = rs1.getInt(1);
			    }
			    pstmt.close();
			    rs1.close();
			    pstmt = null;
			    rs1 = null;
			    	if (cnt == 0)
			    	{
			    		errString = itmDBAccessEJB.getErrorString("","TRIDFRINV","","",conn);
			    		return errString;
			    	}
			 */   	
			}
			
			if ( tranIdTo == null || tranIdTo.trim().length() == 0 )
			{
				System.out.println("tran id to is Null...");
				errString = itmDBAccessEJB.getErrorString("","VMTRIDTONU","","",conn);
				return errString;
			}
			else
			{
			/*	
				sql = "select count(1) from inv_hold_det where tran_id ='" + tranIdTo + "'";
			    pstmt = conn.prepareStatement(sql);
			    rs1 = pstmt.executeQuery();
			    if (rs1.next())
			    {
				cnt = rs1.getInt(1);
			    }
			    pstmt.close();
			    rs1.close();
			    pstmt = null;
			    rs1 = null;
			    	if (cnt == 0)
			    	{
			    		errString = itmDBAccessEJB.getErrorString("","TRIDTOINV","","",conn);
			    		return errString;
			    	}
			  */  	
			}
			
			if ( schRelDateFrom == null )
			{
				System.out.println("schedule release date from is Null...");
				errString = itmDBAccessEJB.getErrorString("","VMSCDTFRNU","","",conn);
				return errString;
			}
			else
			{
				if(schRelDateTo != null)
				{
					if(schRelDateFrom.after(schRelDateTo))
					{
						errString = itmDBAccessEJB.getErrorString("","SCDTTOINV","","",conn);
			    		return errString;
					}
				}
			}
			
			
			if ( schRelDateTo == null )
			{
				System.out.println("schedule release date to is Null...");
				errString = itmDBAccessEJB.getErrorString("","VMSCDTTONU","","",conn);
				return errString;
			}
			else
			{
				if(schRelDateTo != null)
				{
					if(schRelDateTo.before(schRelDateFrom))
					{
						errString = itmDBAccessEJB.getErrorString("","SCDTTOINV","","",conn);
			    		return errString;
					}
				}
			}
			
			
			if ( refIdFrom == null )
			{
				//refIdFrom="0";
				//System.out.println("ref id from is Null...");
				//errString = itmDBAccessEJB.getErrorString("","VMRFIDFRNU","","",conn);
				//return errString;
			}
			else
			{
			/*
				sql = "select count(1) from inv_hold where ref_id ='" + refIdFrom + "'";
			    pstmt = conn.prepareStatement(sql);
			    rs1 = pstmt.executeQuery();
			    if (rs1.next())
			    {
				cnt = rs1.getInt(1);
			    }
			    pstmt.close();
			    rs1.close();
			    pstmt = null;
			    rs1 = null;
			    	if (cnt == 0)
			    	{
			    		errString = itmDBAccessEJB.getErrorString("","REFIDFRINV","","",conn);
			    		return errString;
			    	}
			*/   	
			}
			
			
			if ( refIdTo == null )
			{
				//refIdTo="ZZ";
				//System.out.println("ref id to is Null...");
				//errString = itmDBAccessEJB.getErrorString("","VMRFIDTONU","","",conn);
				//return errString;
			}
			else
			{
			/*	
				sql = "select count(1) from inv_hold where ref_id ='" + refIdTo + "'";
			    pstmt = conn.prepareStatement(sql);
			    rs1 = pstmt.executeQuery();
			    if (rs1.next())
			    {
				cnt = rs1.getInt(1);
			    }
			    pstmt.close();
			    rs1.close();
			    pstmt = null;
			    rs1 = null;
			    	if (cnt == 0)
			    	{
			    		errString = itmDBAccessEJB.getErrorString("","REFIDTOINV","","",conn);
			    		return errString;
			    	}
			*/    	
			}
		/*	
			if ( autoConfirmed == null )
			{
				System.out.println("auto Confirmed is Null...");
				errString = itmDBAccessEJB.getErrorString("","VMAUTCONNU","","",conn);
				return errString;
			}
		*/	
			System.out.println("refIdFrom["+refIdFrom+"]:::::::refIdTo["+refIdTo+"]");
			
			getDataSql= " select ihd.tran_id,ihd.line_no,ihd.line_no_sl," +
						" case when ihd.hold_status is null then 'H' else ihd.hold_status end as hold_status ," +
						" ihd.item_code,ihd.loc_code,ihd.site_code,ihd.status_date,ihd.reas_code,ihd.sch_rel_date," +
						" ih.ref_id,ih.confirmed from inv_hold_det ihd,inv_hold ih where ( ihd.tran_id = ih.tran_id )" +
						" and ( ihd.tran_id >= ? and ihd.tran_id <= ? ) and ( ihd.sch_rel_date between ? and ? )" +
						" and ihd.hold_status <> 'R' ";
			
			if(refIdFrom != null )	
			{	
				getDataSql = getDataSql + " and ( ih.ref_id >= ? or ih.ref_id is null ) ";
			}
			
			if(refIdTo != null )	
			{	
				getDataSql = getDataSql + " and ( ih.ref_id <= ?  or ih.ref_id is null ) ";
			}
			
			System.out.println("Sql Fired :::::"+getDataSql.trim().length());
			if (getDataSql.trim().length()>0)
			{
				System.out.println("Sql Fired :::::"+getDataSql);					
				pstmt = conn.prepareStatement(getDataSql);
				pstmt.setString(1,tranIdFrom);
				pstmt.setString(2,tranIdTo);
				pstmt.setTimestamp(3,schRelDateFrom); 
				pstmt.setTimestamp(4,schRelDateTo);					
				
				if(refIdFrom != null )	
				{
					pstmt.setString(i,refIdFrom);
					i++;
				}
				
				if( refIdTo != null)	
				{
					pstmt.setString(i,refIdTo);
				}
				
				System.out.println("QUERY IS IN PROCESS..........");
				rs1 = pstmt.executeQuery();
				System.out.println("QUERY  PROCESS FINISED.......");
				while(rs1.next()) 
				{
					//tran_id
					retTabSepStrBuff.append((rs1.getString(1)==null?" ":rs1.getString(1))).append("\t");
					//line_no
					retTabSepStrBuff.append((rs1.getString(2)==null?" ":rs1.getString(2))).append("\t");
					//line_no_sl
					retTabSepStrBuff.append((rs1.getString(3)==null?" ":rs1.getString(3))).append("\t");
					//hold_status
					if(rs1.getString(4)!=null)
					{
						retTabSepStrBuff.append((rs1.getString(4)==null?" ":rs1.getString(4))).append("\t");
					}
					else
					{
						retTabSepStrBuff.append("H").append("\t");
					}
					//item_code
					retTabSepStrBuff.append((rs1.getString(5)==null?" ":rs1.getString(5))).append("\t");
					//loc_code
					retTabSepStrBuff.append((rs1.getString(6)==null?" ":rs1.getString(6))).append("\t");
					//site_code
					retTabSepStrBuff.append((rs1.getString(7)==null?" ":rs1.getString(7))).append("\t");
					//status_date
					if(rs1.getTimestamp(8)!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp(8).toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					//reas_code
					retTabSepStrBuff.append((rs1.getString(9)==null?" ":rs1.getString(9))).append("\t");
					//sch_rel_date
					if(rs1.getTimestamp(10)!=null)
					{
						retTabSepStrBuff.append(this.genericUtility.getValidDateString(rs1.getTimestamp(10).toString(),this.genericUtility.getDBDateFormat(),this.genericUtility.getApplDateFormat())).append("\t");
					}
					else
					{
							retTabSepStrBuff.append(" ").append("\t");
					}
					//ref_id
					retTabSepStrBuff.append((rs1.getString(11)==null?" ":rs1.getString(11))).append("\t");
					//confirmed
					retTabSepStrBuff.append((rs1.getString(12)==null?" ":rs1.getString(12))).append("\t");
					
					retTabSepStrBuff.append("\n");				
					count++;
					System.out.println("#####Counter:["+count+"]");
				}//END WHILE
				rs1.close();
				pstmt.close();
				rs1=null;
				pstmt=null;
				if (count == 0 )
				{
					errString = itmDBAccessEJB.getErrorString("","VTNOREC1","","",conn);
				}
			}
			else
			{
				System.out.println("Sql:::::is Null ::::::::::::::");
				errString = itmDBAccessEJB.getErrorString("","VTNOREC1","","",conn);
			}
			
			System.out.println("retTabSepStrBuff:::["+retTabSepStrBuff.toString()+"]");
			
	
		
		}	//end of try	
		catch (SQLException e)
		{ 
			e.printStackTrace();
			System.out.println("SQLException :InvHoldRelGenEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :InvHoldRelGenEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{		
			try
			{		
				conn.close();
				conn = null;
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		if (getDataSql.trim().length()>0 && count > 0)
		{
			return retTabSepStrBuff.toString();	
		}
		else 
		{
			errString = itmDBAccessEJB.getErrorString("","VTNOREC1","","",conn);
			return errString;
		}
	}	
	
	
	@Override
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document detailDom = null;
		Document headerDom = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		String retStr = "";
		Connection conn=null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			//Connection conn= null;
				if(conn==null)
				{
					conn = connDriver.getConnectDB("DriverITM");
					 
					conn.setAutoCommit(false);	
				}
				//DatabaseMetaData dbmd = conn.getMetaData();
			
				System.out.println("xmlString[process]::::::::::;;;"+xmlString);
				System.out.println("xmlString2[process]::::::::::;;;"+xmlString2);
				System.out.println("windowName[process]::::::::::;;;"+windowName);
				System.out.println("xtraParams[process]:::::::::;;;"+xtraParams);
				
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
		}
	
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
			}
			
		    retStr = process(xmlString, xmlString2, windowName, xtraParams,conn);
		    
		}
		catch (Exception e)
		{
			
			System.out.println("Exception : InvHoldRelGenEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			retStr = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
}//END OF PROCESS (1)
	
public String process(String xmlString, String xmlString2, String windowName, String xtraParams,Connection conn) throws RemoteException,ITMException
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	String retStr = "",tranId="",sql="",errString="",lockCode="",holdStatus="";//xmlString="",
	ResultSet rs = null;
	PreparedStatement pstmt = null;
	ConnDriver connDriver = new ConnDriver();
	//Connection conn= null;
	int cnt=0,updCnt=0,ctr=0,count=0;
	String invHoldRelSql = "",invHoldRelDetSql;
	PreparedStatement pRelHdr = null;
	PreparedStatement pRelDet = null;
	java.sql.Timestamp chgDate = null,currDate = null;
	Date date = null;
	String chgTerm = "",autoConfirmed="";
	String userId = "",siteCode="",confirmed="",empCode="",tranIdGenerate="",lineNo="",remark="",tranIdRel="",lineNoRel="";
	Document dom = null,headerDom=null,detailDom=null;
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();

	int parentNodeListLength = 0;
	int childNodeListLength = 0;
	
	NodeList parentNodeList = null;
	NodeList childNodeList = null;
	Node parentNode = null;
	Node childNode = null;
	String childNodeName = "";
	
	try
	{	
		System.out.println("method : process(xmlString, xmlString2, windowName, xtraParams,conn) called");
		if(xmlString != null && xmlString.trim().length()!=0)
		{
			System.out.println("xmlString[process]::::::::::;;;"+xmlString);
			System.out.println("xmlString2[process]::::::::::;;;"+xmlString2);
			headerDom = genericUtility.parseString(xmlString); 
			detailDom= genericUtility.parseString(xmlString2);
			//System.out.println("::::::headerDom :::::[" + headerDom+"]");
			
			tranId = genericUtility.getColumnValue("tran_id",detailDom);
			autoConfirmed = genericUtility.getColumnValue("auto_confirmed",headerDom);
			if(autoConfirmed == null || autoConfirmed.trim().length() == 0 )
			{
				autoConfirmed = "Y";
			}
			System.out.println("tranId:["+tranId+"]:::::autoConfirmed:["+autoConfirmed+"]");
			//System.out.println("INV_HOLD_REL sql ");
			invHoldRelSql = "INSERT INTO INV_HOLD_REL(TRAN_ID, TRAN_DATE, SITE_CODE, REMARKS, CONFIRMED, EMP_CODE__APRV,CHG_USER ,CHG_DATE, CHG_TERM) VALUES(?,?,?,?,?,?,?,?,?)";
			pRelHdr = conn.prepareStatement(invHoldRelSql);
			
			//System.out.println("INV_HOLD_REL_DET sql ");
			invHoldRelDetSql = "INSERT INTO INV_HOLD_REL_DET(TRAN_ID, LINE_NO, TRAN_ID__HOLD, LINE_NO__HOLD, REMARKS) VALUES(?,?,?,?,?)";
			pRelDet = conn.prepareStatement(invHoldRelDetSql);

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "site_code" );
			
			confirmed = "N";
			empCode = "";

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			tranIdGenerate = generateTranId( "w_inv_hold_rel", siteCode, currDateStr, conn );

			pRelHdr.setString( 1, tranIdGenerate );
			pRelHdr.setTimestamp( 2, currDate );
			pRelHdr.setString( 3, siteCode );
			pRelHdr.setString( 4, " " );
			pRelHdr.setString( 5, confirmed );
			pRelHdr.setString( 6, empCode );
			pRelHdr.setString( 7, userId );
			pRelHdr.setTimestamp( 8, currDate );
			pRelHdr.setString( 9, chgTerm );

			updCnt = pRelHdr.executeUpdate();
			pRelHdr.clearParameters();
			if( updCnt > 0 )
			{					
				System.out.println( updCnt + "INV_HOLD_REL rows inserted successfully" );
			}
			// 09/09/12 manoharan commented and added new logical code
			/*lineNo = genericUtility.getColumnValue("line_no",detailDom);
			sql = "select count(*) from inv_hold_det where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				count = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;					

			if(count != 0)
			{
				ctr++;	
				sql = "select tran_id, line_no from inv_hold_det where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					tranIdRel = rs.getString("tran_id");
					lineNoRel = rs.getString("line_no");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;					

				pRelDet.setString( 1, tranIdGenerate );
				pRelDet.setString( 2,lineNo);
				pRelDet.setString( 3, tranIdRel );
				pRelDet.setString( 4, lineNoRel );
				pRelDet.setString( 5, remark );
				pRelDet.addBatch();
				//updCnt = pRelDet.executeUpdate();
				pRelDet.clearParameters();
				if( updCnt > 0 )
				{					
					System.out.println( updCnt + " INV_HOLD_REL_DET rows updated successfully" );
				}
			}
			*/
			// 09/09/12 manoharan commented upto here and added the following code
			/////////////////////////////////////////////////////////////////////////
			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 
			//System.out.println("parentNodeListLength------------------->"+parentNodeListLength);
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				parentNode = parentNodeList.item(selectedRow);
				
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength---->>> "+ childNodeListLength);
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
 					System.out.println("childNodeName---->>> "+ childNodeName);
					if (childNodeName.equals("tran_id"))
					{
						tranId = childNode.getFirstChild().getNodeValue();
					}
					if (childNodeName.equals("line_no"))
					{
						lineNo = childNode.getFirstChild().getNodeValue();
					}
				}
				ctr++;
				pRelDet.setString( 1, tranIdGenerate );
				pRelDet.setInt( 2,ctr);
				pRelDet.setString( 3, tranId );
				pRelDet.setString( 4, lineNo );
				pRelDet.setString( 5, remark );
				pRelDet.addBatch();
				//updCnt = pRelDet.executeUpdate();
				pRelDet.clearParameters();
			}
			/////////////////////////////////////////////////////////////////////////
			pRelDet.executeBatch();
			pRelDet.clearBatch();
			
			if("Y".equalsIgnoreCase(autoConfirmed))
			{
				InvHoldRelConf invHoldRelConf =  new InvHoldRelConf();
				errString = invHoldRelConf.confirm(tranIdGenerate,xtraParams, "N" , conn,false);
				invHoldRelConf = null;
				if (errString.indexOf("VTCNFSUCC") > -1)
				{
					errString = "";
				}
				//sql = " update inv_hold set confirmed = 'Y', conf_date = ? where tran_id = ?";
				/*sql = "update inv_hold_det set  hold_status = 'R', status_date = ? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,currDate);
				pstmt.setString(2,tranId);
				int rowcnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				*/

			}
			if (errString == null || errString.trim().length() == 0)
			{
				conn.commit();
				System.out.println("inv_hold_det transaction hold_status release succesfully........");
				errString = itmDBAccessLocal.getErrorString("","VTMCONF2","");
			}
			else
			{
				conn.rollback();
				System.out.println("Process failed........");
				errString = itmDBAccessLocal.getErrorString("","VTDESNCONF","");
			}
		}
		
	}
	catch (Exception e)
	{
		errString = e.getMessage();
		e.printStackTrace();
		try
		{
			conn.rollback();
		}
		catch(Exception e1)
		{
			e1.printStackTrace();
		}
		throw new ITMException(e);
	}
	finally
	{

		try
		{
			if(pRelHdr != null)
			{
				pRelHdr.close();
				pRelHdr = null;	
			}
			if(pRelDet != null)
			{
				pRelDet.close();
				pRelDet = null;
			}
			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	return errString;
}

private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException
{
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	String selSql = "";
	String tranId = "";
	String tranSer = "";
	String keyString = "";
	String keyCol = "";
	String xmlValues = "";
	String paySiteCode = "";
	String effectiveDate = "";
	java.sql.Date effDate = null;

	try
	{
		System.out.println("generateTranId() called");
		
		selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
		//System.out.println("selSql :"+selSql);
		pstmt = conn.prepareStatement(selSql);
		pstmt.setString( 1, windowName );
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			keyString = rs.getString("KEY_STRING");
			keyCol = rs.getString("TRAN_ID_COL");
			tranSer = rs.getString("REF_SER");
		}
		rs.close();rs = null;
		pstmt.close();pstmt = null;
		System.out.println("keyString :"+keyString);
		System.out.println("keyCol :"+keyCol);
		System.out.println("tranSer :"+tranSer);

		xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
		xmlValues = xmlValues + "<Header></Header>";
		xmlValues = xmlValues + "<Detail1>";
		xmlValues = xmlValues +		"<tran_id></tran_id>";
		xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
		xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
		xmlValues = xmlValues + "</Detail1></Root>";
		System.out.println("xmlValues  :["+xmlValues+"]");
		TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
		tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
		System.out.println("tranId :"+tranId);

	}
	catch (SQLException ex)
	{
		System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
		ex.printStackTrace();
		throw new ITMException(ex);
	}
	catch (Exception e)
	{
		System.out.println("Exception ::" + e.getMessage() + ":");
		e.printStackTrace();
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			//errString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	return tranId;
 }

}
