
/*
* PURPOSE : Validation & ItemChanged for CenvatCrCapital Module Map List
*/ 

package ibase.webitm.ejb.dis;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import javax.ejb.*;
import org.w3c.dom.*;
//import ibase.webitm.savex.utility.DateUtilities;
import java.text.SimpleDateFormat;
import java.util.Date;
//import javax.ejb.Stateless;

@Stateless

public class CenvatCrCapital extends ValidatorEJB implements CenvatCrCapitalLocal,CenvatCrCapitalRemote
{  
	/**
	* The method defined with no paramter and returns nothing
	*/
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
    /**
	 * The public method is used for validation of required fields which inturn called overloded method
	 * Returns validation string in XML format if exist otherwise returns null 
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr contains always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: CenvatDemoex: wfValData(): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from CenvatDemoex wfValData" );
		return ( errString ); 
	}//end of wfvalData() of xml string
  
    /**
	 * The public overloded method is used for validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data 
	 * @param hdrDom contains always header form data
	 * @param allDom contains all forms data 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String tranId="";
		String errString = "";
		String errCode="";
		ResultSet rSet = null;
		Connection connObject = null;
		PreparedStatement pstmt = null;
	
        GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try
		{
			System.out.println("*****************calling wfvaldata*******************");
			String columnValue = "";
			String sql = "";
			int currentFormNo = 0;			
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connObject = connDriver.getConnectDB("DriverValidator");
			 
			NodeList parentList = null;
			NodeList childList = null;
			int noOfChilds = 0;
			String childNodeName = "";
			Node childNode = null;
	
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			int count = 0;

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{	
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
				if ( "tran_date".equalsIgnoreCase( childNodeName ) )
				{
					tranId = columnValue;
					if (childNode.getFirstChild() == null)//checking for blanck tran id
					{  
					   errCode="NULLTRNDAT";
					   errString = itmDBAccessEJB.getErrorString("","NULLTRNDAT",userId);
					   break;
					}
					/*
					else //To check tran_id exist in cenvat_cr_capital master
					{	   
						sql =  "SELECT COUNT(*) COUNT FROM CENVAT_CR_CAPITAL WHERE TRAN_DATE = ? " ;	
						pstmt = connObject.prepareStatement(sql);
						pstmt.setString(1,columnValue);
						rSet = pstmt.executeQuery();
						if( rSet.next())
						{
							count = rSet.getInt("COUNT");
						}
						if( count == 0 )
						{
							errCode="TRNDTNTEXT";
						    errString = itmDBAccessEJB.getErrorString("","TRNDTNTEXT",userId);
							break;
						}
					} //End To check tran_id exist in cenvat_cr_capital master
					*/		
				}//end of if tran_id
		  }//end of for loop
						
		}//end of Try block
		catch(Exception e)
		{
			System.out.println("Exception in CenvatDemoex  == >");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :CenvatDemoex:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}//end of valData doc

	/**
	* The method defined with no paramter and returns nothing
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
    /**
	 * The public method is used for itemchange of required fields which inturn called overloded method
	 * Returns itemchange string in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr contains always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String itemChanged(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if (currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if (hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if (allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			errString = itemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :CenvatDemoex :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from CenvatDemoex itemChanged" );
		return errString;
	}
    /**
	 * The public overloded method is used for itemchange of required fields 
	 * Returns itemchange string in XML format
	 * @param currDom contains the current form data 
	 * @param hdrDom contains always header form data
	 * @param allDom contains all forms data 
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String itemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String sql = "";
		String columnValue = "";
		String balGroup = "";
		String docType="";
		String balType="";
		String balPrd="";
		String refSer="";
		String refId="";
		String refLine="";
		String drcrFlag="";
		String itemRef="";
		String pinPass="";
		String taxRef="";
		String partyRef="";
		String taxChap="";
		String itemCode="";
		String siteCode="";
		String suppCode="";
		String excRef="";
		String siteCodeSupp="";
		String siteCodeTran="";
		String tranTypeTransaction="";
		String processYn="";
		String chapHeading="";
		String lotNo="";
		String lotSl="";
		String invoiceNo="";
		String taxCode="";
		String refdocNo="";
		String materialCategory="";
		String tranType="";
		String bankCode="";
		String docDescr="";
		String srNo="";
		String chgUser="";
		String chgTerm="";
		String balgroupAdj="";
		String tranMode="";
		String batchNo="";
		String processYear="";
		String loginSite="";
		int netAmt=0;
		int drAmt=0;
		int crAmt=0;
		int taxAmt=0;
		int qtyRecd=0;
		int closingStock=0;
		int adjAmt=0;
		int addlExcise=0;
		GenericUtility genericUtility = GenericUtility.getInstance();
		String userId = "";
		StringBuffer valueXmlString = new StringBuffer();
        java.sql.Date tranDate=null;
        java.sql.Date refDate=null;
        java.sql.Date refdocDate=null;
        java.sql.Date chgDate=null;
             
		Connection connObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null;
        int currentFormNo = 0;
       
		try
		{
			SimpleDateFormat sdf =  new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connObject = connDriver.getConnectDB("DriverValidator");
			//loginSite = getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
			valueXmlString.append( "<Detail1>\r\n" );
			if((currentColumn.trim().equalsIgnoreCase("itm_default")))
			{
				loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				valueXmlString.append("<site_code>").append("<![CDATA["+loginSite+"]]>").append("</site_code>");	
				valueXmlString.append("<tran_date>").append("<![CDATA["+sdf.format(new Date())+"]]>").append("</tran_date>");
				
				
			}

			if( currentColumn.trim().equalsIgnoreCase( "tran_id" ) )
			{
				columnValue = genericUtility.getColumnValue("tran_id",currDom);
				
				sql = "SELECT TRAN_DATE, BAL_GROUP, DOC_TYPE, BAL_TYPE, BAL_PRD, REF_SER, REF_ID, REF_DATE,  "
					 +" REF_LINE, DRCR_FLAG, ITEM_REF, TAX_REF, PARTY_REF, NET_AMT, DR_AMT, CR_AMT, TAX_AMT, TAX_CHAP, "
					 +" ITEM_CODE, SITE_CODE, QTY_RECD, SUPP_CODE, EXC_REF, CLOSING_STOCK, SITE_CODE__SUPP, SITE_CODE__TRAN, "
					 +" TRAN_TYPE_TRANSACTION, PROCESS_YN, CHAP_HEADING, LOT_NO, LOT_SL, INVOICE_NO, TAX_CODE, REF_DOC_NO, "
					 +" REF_DOC_DATE, MATERIAL_CATEGORY, TRAN_TYPE, BANK_CODE, DOC_DESCR, SR_NO, CHG_DATE, CHG_USER, CHG_TERM, "
					 +" BAL_GROUP__ADJ, ADJ_AMT, TRAN_MODE, ADDL_EXCISE, BATCH_NO, PROCESS_YEAR " 
					 +" FROM CENVAT_CR_CAPITAL WHERE TRAN_ID= ?"; 
						
				pstmt = connObject.prepareStatement(sql);
				pstmt.setString(1, columnValue);
				rSet = pstmt.executeQuery();
				if( rSet.next() )
				{
		 //		    tranDate = rSet.getDate( "TRAN_DATE" );
					balGroup=rSet.getString( "BAL_GROUP" );
					docType=rSet.getString( "DOC_TYPE" );
					balType=rSet.getString("BAL_TYPE");
					balPrd=rSet.getString("BAL_PRD");
					refSer = rSet.getString( "REF_SER" );
					refId = rSet.getString( "REF_ID" );
					refDate = rSet.getDate( "REF_DATE" );
					refLine = rSet.getString( "REF_LINE" );
					drcrFlag = rSet.getString( "DRCR_FLAG" );
					itemRef = rSet.getString( "ITEM_REF" );
					taxRef=rSet.getString( "TAX_REF" );
					partyRef=rSet.getString( "PARTY_REF" );
					netAmt=rSet.getInt( "NET_AMT" );
					drAmt=rSet.getInt( "DR_AMT" );
					crAmt=rSet.getInt( "CR_AMT" );
					taxAmt=rSet.getInt( "TAX_AMT" );
					taxChap=rSet.getString( "TAX_CHAP" );
					itemCode=rSet.getString( "ITEM_CODE" );
		 //			siteCode=rSet.getString( "SITE_CODE" );
					qtyRecd=rSet.getInt( "QTY_RECD" );
					suppCode=rSet.getString( "SUPP_CODE" );
					excRef=rSet.getString( "EXC_REF" );
					closingStock=rSet.getInt( "CLOSING_STOCK" );
					siteCodeSupp=rSet.getString( "SITE_CODE__SUPP" );
					siteCodeTran=rSet.getString( "SITE_CODE__TRAN" );
					tranTypeTransaction=rSet.getString( "TRAN_TYPE_TRANSACTION" );
					processYn=rSet.getString( "PROCESS_YN" );
					chapHeading=rSet.getString( "CHAP_HEADING" );
					lotNo=rSet.getString( "LOT_NO" );
					lotSl=rSet.getString( "LOT_SL" );
					invoiceNo=rSet.getString( "INVOICE_NO" );
					taxCode=rSet.getString( "TAX_CODE" );
					refdocNo=rSet.getString( "REF_DOC_NO" );
					refdocDate = rSet.getDate( "REF_DOC_DATE" );
					materialCategory=rSet.getString( "MATERIAL_CATEGORY" );
					tranType=rSet.getString( "TRAN_TYPE" );
					bankCode=rSet.getString( "BANK_CODE" );
					docDescr=rSet.getString( "DOC_DESCR" );
					srNo=rSet.getString( "SR_NO" );
					chgDate = rSet.getDate( "CHG_DATE" );
					chgUser=rSet.getString( "CHG_USER" );
					chgTerm=rSet.getString( "CHG_TERM" );
					balgroupAdj=rSet.getString( "BAL_GROUP__ADJ" );
					adjAmt=rSet.getInt( "ADJ_AMT" );
					tranMode=rSet.getString( "TRAN_MODE" );
					addlExcise=rSet.getInt( "ADDL_EXCISE" );
					batchNo=rSet.getString( "BATCH_NO" );
					processYear=rSet.getString( "PROCESS_YEAR" );
					 }
		 //	    valueXmlString.append("<TRAN_DATE><![CDATA[" ).append(  sdf.format(tranDate)  ).append( "]]></TRAN_DATE>\r\n" );
				valueXmlString.append("<BAL_GROUP><![CDATA[" ).append( balGroup ).append( "]]></BAL_GROUP>\r\n" );
				valueXmlString.append("<DOC_TYPE><![CDATA[" ).append(  docType ).append( "]]></DOC_TYPE>\r\n" );
				valueXmlString.append("<BAL_TYPE><![CDATA[" ).append( balType ).append( "]]></BAL_TYPE>\r\n" );
				valueXmlString.append("<BAL_PRD><![CDATA[" ).append( balPrd ).append( "]]></BAL_PRD>\r\n" );
				valueXmlString.append("<REF_SER><![CDATA[" ).append( refSer ).append( "]]></REF_SER>\r\n" );
				valueXmlString.append("<REF_ID><![CDATA[" ).append( refId ).append( "]]></REF_ID>\r\n" );
				valueXmlString.append("<REF_DATE><![CDATA[" ).append(  sdf.format(refDate)  ).append( "]]></REF_DATE>\r\n" );
				valueXmlString.append("<REF_LINE><![CDATA[" ).append(  refLine  ).append( "]]></REF_LINE>\r\n" );
				valueXmlString.append("<DRCR_FLAG><![CDATA[" ).append(  drcrFlag  ).append( "]]></DRCR_FLAG>\r\n" );
				valueXmlString.append("<ITEM_REF><![CDATA[" ).append( itemRef ).append( "]]></ITEM_REF>\r\n" );
				valueXmlString.append("<TAX_REF><![CDATA[" ).append(  taxRef ).append( "]]></TAX_REF>\r\n" );
				valueXmlString.append("<PARTY_REF><![CDATA[" ).append(  partyRef ).append( "]]></PARTY_REF>\r\n" );
				valueXmlString.append("<NET_AMT><![CDATA[" ).append( netAmt ).append( "]]></NET_AMT>\r\n" );
				valueXmlString.append("<DR_AMT><![CDATA[" ).append(  drAmt  ).append( "]]></DR_AMT>\r\n" );
				valueXmlString.append("<CR_AMT><![CDATA[" ).append(  crAmt ).append( "]]></CR_AMT>\r\n" );
				valueXmlString.append("<TAX_AMT><![CDATA[" ).append( taxAmt  ).append( "]]></TAX_AMT>\r\n" );
				valueXmlString.append("<TAX_CHAP><![CDATA[" ).append( taxChap  ).append( "]]></TAX_CHAP>\r\n" );
				valueXmlString.append("<ITEM_CODE><![CDATA[" ).append( itemCode  ).append( "]]></ITEM_CODE>\r\n" );
		//		valueXmlString.append("<SITE_CODE><![CDATA[" ).append( siteCode  ).append( "]]></SITE_CODE>\r\n" );
				valueXmlString.append("<QTY_RECD><![CDATA[" ).append( qtyRecd  ).append( "]]></QTY_RECD>\r\n" );
				valueXmlString.append("<SUPP_CODE><![CDATA[" ).append( suppCode  ).append( "]]></SUPP_CODE>\r\n" );
				valueXmlString.append("<EXC_REF><![CDATA[" ).append( excRef  ).append( "]]></EXC_REF>\r\n" );
				valueXmlString.append("<CLOSING_STOCK><![CDATA[" ).append( closingStock  ).append( "]]></CLOSING_STOCK>\r\n" );
				valueXmlString.append("<SITE_CODE__SUPP><![CDATA[" ).append( siteCodeSupp  ).append( "]]></SITE_CODE__SUPP>\r\n" );
				valueXmlString.append("<SITE_CODE__TRAN><![CDATA[" ).append( siteCodeTran  ).append( "]]></SITE_CODE__TRAN>\r\n" );
				valueXmlString.append("<TRAN_TYPE_TRANSACTION><![CDATA[" ).append( tranTypeTransaction  ).append( "]]></TRAN_TYPE_TRANSACTION>\r\n" );
				valueXmlString.append("<PROCESS_YN><![CDATA[" ).append( processYn  ).append( "]]></PROCESS_YN>\r\n" );
				valueXmlString.append("<CHAP_HEADING><![CDATA[" ).append( chapHeading  ).append( "]]></CHAP_HEADING>\r\n" );
				valueXmlString.append("<LOT_NO><![CDATA[" ).append( lotNo  ).append( "]]></LOT_NO>\r\n" );
				valueXmlString.append("<LOT_SL><![CDATA[" ).append( lotSl  ).append( "]]></LOT_SL>\r\n" );
				valueXmlString.append("<INVOICE_NO><![CDATA[" ).append( invoiceNo  ).append( "]]></INVOICE_NO>\r\n" );
				valueXmlString.append("<TAX_CODE><![CDATA[" ).append( taxCode  ).append( "]]></TAX_CODE>\r\n" );
				valueXmlString.append("<REF_DOC_NO><![CDATA[" ).append( refdocNo  ).append( "]]></REF_DOC_NO>\r\n" );
				valueXmlString.append("<REF_DOC_DATE><![CDATA[" ).append(  sdf.format(refdocDate)  ).append( "]]></REF_DOC_DATE>\r\n" );
				valueXmlString.append("<MATERIAL_CATEGORY><![CDATA[" ).append( materialCategory  ).append( "]]></MATERIAL_CATEGORY>\r\n" );
				valueXmlString.append("<TRAN_TYPE><![CDATA[" ).append( tranType  ).append( "]]></TRAN_TYPE>\r\n" );
				valueXmlString.append("<BANK_CODE><![CDATA[" ).append( bankCode  ).append( "]]></BANK_CODE>\r\n" );
				valueXmlString.append("<DOC_DESCR><![CDATA[" ).append( docDescr  ).append( "]]></DOC_DESCR>\r\n" );
				valueXmlString.append("<SR_NO><![CDATA[" ).append( srNo  ).append( "]]></SR_NO>\r\n" );
				valueXmlString.append("<CHG_DATE><![CDATA[" ).append(  sdf.format(chgDate)  ).append( "]]></CHG_DATE>\r\n" );
				valueXmlString.append("<CHG_USER><![CDATA[" ).append( chgUser  ).append( "]]></CHG_USER>\r\n" );
				valueXmlString.append("<CHG_TERM><![CDATA[" ).append( chgTerm  ).append( "]]></CHG_TERM>\r\n" );
				valueXmlString.append("<BAL_GROUP__ADJ><![CDATA[" ).append( balgroupAdj  ).append( "]]></BAL_GROUP__ADJ>\r\n" );
				valueXmlString.append("<ADJ_AMT><![CDATA[" ).append( adjAmt  ).append( "]]></ADJ_AMT>\r\n" );
				valueXmlString.append("<TRAN_MODE><![CDATA[" ).append( tranMode  ).append( "]]></TRAN_MODE>\r\n" );
				valueXmlString.append("<ADDL_EXCISE><![CDATA[" ).append( addlExcise  ).append( "]]></ADDL_EXCISE>\r\n" );
				valueXmlString.append("<BATCH_NO><![CDATA[" ).append( batchNo  ).append( "]]></BATCH_NO>\r\n" );
				valueXmlString.append("<PROCESS_YEAR><![CDATA[" ).append( processYear  ).append( "]]></PROCESS_YEAR>\r\n" );	
			}//end of tran_id if
			valueXmlString.append( "</Detail1>\r\n" );
			//break;
		}//End of TRY itemChanged doc
		catch(Exception e)
		{
			System.out.println( "Exception :CenvatDemoex :itemChanged:" + e.getMessage() + ":" );
			throw new ITMException(e);
		}//End of Catch
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :CenvatDemoex:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}//End of Finally
		valueXmlString.append( "</Root>\r\n" );	
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}//End of Item changed
}//End of Class	
