/*
 * Author: Wasim Ansari
 * Date: 26-SEP-2016
 * Request: S16EBAS006 (Sale Order Wizard)
 */

package ibase.webitm.ejb.wms;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;

import javax.ejb.Stateless;
import javax.imageio.ImageIO;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SorderWizardEJB extends ValidatorEJB implements SorderWizardEJBLocal, SorderWizardEJBRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	DistCommon distCommon = new DistCommon();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public SorderWizardEJB() {
        // TODO Auto-generated constructor stub
    }
    
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("Inside wfvalData SorderWizardEJB");
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return(errString);
	}
	
	
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		boolean flag = false;
		
		String sql = "",columnValue = "";
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			conn = getConnection();
			
			//userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			//SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						
					    if (childNodeName.equalsIgnoreCase("cust_code")) 
						{
					    	int count = 0;
					    	
							if(columnValue == null || columnValue.length() == 0)
							{
								errList.add( "VTINVCUST" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								count = validateCustomer(columnValue,conn);
								if( count == 0 )
								{
									errList.add( "VTINVCUST" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					    if (childNodeName.equalsIgnoreCase("cust_code__dlv")) 
						{
					    	int count = 0;
					    	
							if(columnValue == null || columnValue.length() == 0)
							{
								errList.add( "VTCUSTDLV" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								count = validateCustomer(columnValue,conn);
								if( count == 0 )
								{
									errList.add( "VTCUSTDLV" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					    if (childNodeName.equalsIgnoreCase("cust_code__bil")) 
						{
					    	int count = 0;
					    	
							if(columnValue == null || columnValue.length() == 0)
							{
								errList.add( "VTCUSTBILL" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								count = validateCustomer(columnValue,conn);
								if( count == 0 )
								{
									errList.add( "VTCUSTBILL" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					    if (childNodeName.equalsIgnoreCase("order_date")) 
						{
					    	String statSal = "",prdCode = "";
					    	int count = 0;
					    	System.out.println("Order Date="+columnValue);
					    	
					    	String ordDate = genericUtility.getValidDateTimeString(
									checkNullAndTrim(columnValue), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
					    	
					    	String siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
					    	
					    	sql = " SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(ordDate));
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								prdCode = checkNullAndTrim(rs.getString("CODE"));
								count++;
							}
							if (rs != null) 
							{					
								rs.close();rs = null;
							}
							if (pstmt != null ) 
							{					
								pstmt.close();pstmt = null;
							}
							
							if(count == 0)
							{
								errList.add( "VTORDTINV" );
								errFields.add( childNodeName.toLowerCase() );
							}
							
							sql = " SELECT STAT_SAL FROM PERIOD_STAT WHERE PRD_CODE = ? AND SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prdCode);
							pstmt.setString(2, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								statSal = checkNullAndTrim(rs.getString("STAT_SAL"));
							}
							if (rs != null) 
							{					
								rs.close();rs = null;
							}
							if (pstmt != null ) 
							{					
								pstmt.close();pstmt = null;
							}
							
							System.out.println("Acct Sal["+statSal+"]");
							
							if("N".equalsIgnoreCase(statSal))
							{
								errList.add( "VTPRDSAL" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					    if (childNodeName.equalsIgnoreCase("due_date")) 
						{
					    	String appDateFormat = genericUtility.getApplDateFormat();
					    	String morderDateStr = checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
					    	String siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
					    	
					    	java.util.Date morderDate = getDateInForamt( morderDateStr, appDateFormat );
					    	java.util.Date mdueDate = getDateInForamt( columnValue, appDateFormat );
					    	
					    	System.out.println("mdueDate["+mdueDate+"]  and morderDate["+morderDate+"]");
							if( mdueDate.compareTo( morderDate ) < 0 )
							{
								errList.add( "VTDUEDT" );
								errFields.add( childNodeName.toLowerCase() );
							}
							/*else
							{
								String statSal = "",prdCode = "";
						    	int count = 0;
						    	System.out.println("Despatch Date="+columnValue);
						    	
						    	String despDate = genericUtility.getValidDateTimeString(
										checkNullAndTrim(columnValue), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
						    	
						    	sql = " SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(despDate));
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									prdCode = checkNullAndTrim(rs.getString("CODE"));
									count++;
								}
								if (rs != null) 
								{					
									rs.close();rs = null;
								}
								if (pstmt != null ) 
								{					
									pstmt.close();pstmt = null;
								}
								
								if(count == 0)
								{
									errList.add( "VTINVDUE" );
									errFields.add( "due_date".toLowerCase() );
								}
								
								sql = " SELECT STAT_SAL FROM PERIOD_STAT WHERE PRD_CODE = ? AND SITE_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, prdCode);
								pstmt.setString(2, siteCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									statSal = checkNullAndTrim(rs.getString("STAT_SAL"));
								}
								if (rs != null) 
								{					
									rs.close();rs = null;
								}
								if (pstmt != null ) 
								{					
									pstmt.close();pstmt = null;
								}
								
								if("N".equalsIgnoreCase(statSal))
								{
									errList.add( "VTPRDDSP" );
									errFields.add( "due_date".toLowerCase() );
								}
							}*/
						}
					    if (childNodeName.equalsIgnoreCase("cr_term")) 
						{
					    	int count = 0;
					    	String crTerm = checkNullAndTrim(genericUtility.getColumnValue("cr_term", dom1));
					    	
					    	if(crTerm.length() > 0)
					    	{	
						    	sql = " SELECT COUNT(*) FROM CRTERM WHERE CR_TERM = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, crTerm);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									count++;
								}
								if (rs != null) 
								{					
									rs.close();rs = null;
								}
								if (pstmt != null ) 
								{					
									pstmt.close();pstmt = null;
								}
								if(count == 0)
								{	
									errList.add( "VTCRTERM1" );
									errFields.add( childNodeName.toLowerCase() );
								}
					    	}
						}
					}
				break;
				
				case 3:
					String morderDateStr = checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
					String siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
					String appDateFormat = genericUtility.getApplDateFormat();
					
					String itemCode = "",dspDate = "";
					
					NodeList detail3NodeList =dom.getElementsByTagName("Detail3");
					int detail3NodeListlen = detail3NodeList.getLength();
					System.out.println("Detail3 Length wfVal"+detail3NodeListlen);
					for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
					{
						childNodeList = detail3NodeList.item(ctrH).getChildNodes();
						int childNodeListlen = childNodeList.getLength();

						for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
						{
							childNode = childNodeList.item(ctrD);
							
							if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
							{
								continue;
							}
						
							if(childNode != null && "item_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
							{
								itemCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							else if(childNode != null && "dsp_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
							{
								dspDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
						}
						
						System.out.println("Validation for itemCode["+itemCode+"] and DspDate["+dspDate+"]");
						
						if(dspDate.length() > 0)
						{
					    	java.util.Date morderDate = getDateInForamt( morderDateStr, appDateFormat );
					    	java.util.Date mdueDate = getDateInForamt( dspDate, appDateFormat );
					    	
					    	System.out.println("mdueDate["+mdueDate+"]  and morderDate["+morderDate+"]");
							if( mdueDate.compareTo( morderDate ) < 0 )
							{
								//errList.add( "VTDSPDT" );
								//errFields.add( "dsp_date".toLowerCase() );
								//String message = "Despatch date must be > =  Order date";
								return getError(itemCode, "VTDSPDT", conn);
							}
							/*else
							{
								String statSal = "",prdCode = "";
						    	int count = 0;
						    	System.out.println("Despatch Date="+columnValue);
						    	
						    	String despDate = genericUtility.getValidDateTimeString(
										checkNullAndTrim(dspDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
						    	
						    	sql = " SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(despDate));
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									prdCode = checkNullAndTrim(rs.getString("CODE"));
									count++;
								}
								if (rs != null) 
								{					
									rs.close();rs = null;
								}
								if (pstmt != null ) 
								{					
									pstmt.close();pstmt = null;
								}
								
								if(count == 0)
								{
									//errList.add( "VTORDTINV" );
									//errFields.add( "dsp_date".toLowerCase() );
									//String message = "Invalid Despatch Date,The Despatch Date not present in period status master";
									return getError(itemCode, "VTDSPINV", conn);
								}
								
								sql = " SELECT STAT_SAL FROM PERIOD_STAT WHERE PRD_CODE = ? AND SITE_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, prdCode);
								pstmt.setString(2, siteCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									statSal = checkNullAndTrim(rs.getString("STAT_SAL"));
								}
								if (rs != null) 
								{					
									rs.close();rs = null;
								}
								if (pstmt != null ) 
								{					
									pstmt.close();pstmt = null;
								}
								
								if("N".equalsIgnoreCase(statSal))
								{
									//errList.add( "VTPRDSAL" );
									//errFields.add( "dsp_date".toLowerCase() );
									//String message = "Please check the despatch date you have entered. Probably, the date falls under the period whose sales transactions are already closed.";
									return getError(itemCode, "VTPRDSAL", conn);
								}
							}*/
						}
					}    
				
				break;
			}
			
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	public  String getError(String itemCode, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + " for item code ["+itemCode+"]. " + endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
			
			/*String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Despatch Date"+"</message><description>";
			//mainStr= mainStr+"Despatch date must be > =  Order date for item code : ["+itemCode+"]."+endDesc;
			mainStr= mainStr+ message +" for item code ["+itemCode+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;*/
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			System.out.println("xmlString : ["+ xmlString+ "] \nxmlString1 : ["+ xmlString1 +"] \nxmlString2 : ["+ xmlString2 +"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			valueXmlString = genericUtility.createErrorString(e);
		}
		
		return (valueXmlString);
	}
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtShipper = null,pstmtSel = null;
		ResultSet rs = null, rsSel = null ;
		
		String sql = "",userId = "",loginSiteCode = "",empCode = "",chgTerm = "",siteCodeDescr = "",saleOrder = "",itemRefSer = "";
		int currentFormNo = 0;
		
		StringBuffer valueXmlString = new StringBuffer();
		String currDate = "";
		String sorderdefValueFlag = "";
		String remarks = "",udfStr2 = "",empCodeOrd = "",dlvAddr1 = "",dlvAddr2 = "",dlvAddr3 = "",dlvPin = "",
				dlvCity = "",stateCodeDlv = "",countCodeDlv = "",tele1 = "",tele2 = "",partQty = "",udfStr1 = "";

		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;*/
			conn = getConnection();
			
			String applDateFormat = genericUtility.getApplDateFormat();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			currDate = getCurrdateAppFormat();
			System.out.println("Xtra Params="+xtraParams);
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			empCode =  checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" ));
			
			sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,loginSiteCode);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeDescr = checkNullAndTrim(rs.getString("DESCR"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			/*sql = " SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,"w_item");			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemRefSer = checkNullAndTrim(rs.getString("REF_SER"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}*/
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");
			
			switch ( currentFormNo )
			{
				case 1:
				{   
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						
						String custCode = "",custName = "",crTerm = "",currCode = "",stanCode = "",tranCode = "",transMode = "",currCodeFrt = "",
								currCodeIns = "",custCodeBil = "",custNameBil = "",itemSer = "",itemSerDescr = "",custNameDlv = "",
										custCodeDlv = "",orderType = "",orderTypeDescr = "",dlvTerm = "",dlvTermDescr = "",taxClass = "",taxChap = "";	
						Timestamp ordDate = null,dueDate = null;
								
						sql = " SELECT * FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "A");
						pstmt.setString(2, empCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							orderType = checkNullAndTrim(rs.getString("ORDER_TYPE"));
							ordDate = rs.getTimestamp("ORDER_DATE");
							dueDate = rs.getTimestamp("DUE_DATE");
							custCode = checkNullAndTrim(rs.getString("CUST_CODE"));
							custCodeDlv = checkNullAndTrim(rs.getString("CUST_CODE__DLV"));
							custCodeBil = checkNullAndTrim(rs.getString("CUST_CODE__BIL"));
							itemSer = checkNullAndTrim(rs.getString("ITEM_SER"));
							tranCode = checkNullAndTrim(rs.getString("TRAN_CODE"));
							transMode = checkNullAndTrim(rs.getString("TRANS_MODE"));
							dlvTerm = checkNullAndTrim(rs.getString("DLV_TERM"));
							
							sql = " SELECT CUST_CODE,CUST_NAME,CR_TERM,CURR_CODE,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,TAX_CLASS,TAX_CHAP FROM CUSTOMER WHERE CUST_CODE = ? ";
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, custCode);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								custName = checkNullAndTrim(rsSel.getString("CUST_NAME"));
								crTerm = checkNullAndTrim(rsSel.getString("CR_TERM"));
								currCode = checkNullAndTrim(rsSel.getString("CURR_CODE"));
								/*stanCode = checkNullAndTrim(rsSel.getString("STAN_CODE"));*/
								/*tranCode = checkNullAndTrim(rsSel.getString("TRAN_CODE"));
								transMode = checkNullAndTrim(rsSel.getString("TRANS_MODE"));*/
								currCodeFrt = checkNullAndTrim(rsSel.getString("CURR_CODE__FRT"));
								currCodeIns = checkNullAndTrim(rsSel.getString("CURR_CODE__FRT"));
								
								taxClass = checkNullAndTrim(rsSel.getString("TAX_CLASS"));
								taxChap = checkNullAndTrim(rsSel.getString("TAX_CHAP"));
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							System.out.println("Trans Mode["+transMode+"]");
							
							sql = " SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE = ? ";//For customer name Bill
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, custCodeBil);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								custNameBil = checkNullAndTrim(rsSel.getString("CUST_NAME"));//For customer name Delivery
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							sql = " SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE = ? ";
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, custCodeDlv);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								custNameDlv = checkNullAndTrim(rsSel.getString("CUST_NAME"));
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							sql = " SELECT DESCR FROM ITEMSER WHERE ITEM_SER = ? ";
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, itemSer);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								itemSerDescr = checkNullAndTrim(rsSel.getString("DESCR"));
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							sql = " SELECT DESCR FROM SORDERTYPE WHERE ORDER_TYPE = ? ";
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, orderType);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								orderTypeDescr = checkNullAndTrim(rsSel.getString("DESCR"));
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							sql = " SELECT DESCR FROM DELIVERY_TERM WHERE DLV_TERM = ? ";
							pstmtSel = conn.prepareStatement(sql);
							pstmtSel.setString(1, dlvTerm);
							rsSel = pstmtSel.executeQuery();
							if(rsSel.next())
							{
								dlvTermDescr = checkNullAndTrim(rsSel.getString("DESCR"));
							}
							if(rsSel != null)
							{
								rsSel.close();rsSel = null;
							}	
							if(pstmtSel != null)
							{	
								pstmtSel.close();pstmtSel = null;
							}
							
							valueXmlString.append("<sale_order>").append("<![CDATA[]]>").append("</sale_order>\r\n");
							valueXmlString.append("<order_date>").append("<![CDATA["+sdf.format(ordDate)+"]]>").append("</order_date>\r\n");
							valueXmlString.append("<site_code>").append("<![CDATA["+checkNullAndTrim(rs.getString("SITE_CODE"))+"]]>").append("</site_code>\r\n");
							valueXmlString.append("<site_descr>").append("<![CDATA["+siteCodeDescr+"]]>").append("</site_descr>\r\n");
							valueXmlString.append("<item_ser>").append("<![CDATA["+checkNullAndTrim(rs.getString("ITEM_SER"))+"]]>").append("</item_ser>\r\n");
							valueXmlString.append("<itemser_descr>").append("<![CDATA["+itemSerDescr+"]]>").append("</itemser_descr>\r\n");
							valueXmlString.append("<order_type>").append("<![CDATA["+orderType+"]]>").append("</order_type>\r\n");
							valueXmlString.append("<sordertype_descr>").append("<![CDATA["+orderTypeDescr+"]]>").append("</sordertype_descr>\r\n"); //taken as temporary variable
							valueXmlString.append("<cust_code>").append("<![CDATA["+checkNullAndTrim(rs.getString("CUST_CODE"))+"]]>").append("</cust_code>\r\n");
							valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+custCodeDlv+"]]>").append("</cust_code__dlv>\r\n");
							valueXmlString.append("<cust_name>").append("<![CDATA["+custName+"]]>").append("</cust_name>\r\n");
							valueXmlString.append("<cust_code__bil>").append("<![CDATA["+checkNullAndTrim(rs.getString("CUST_CODE__BIL"))+"]]>").append("</cust_code__bil>\r\n");
							valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBil+"]]>").append("</cust_name__bil>\r\n");
							valueXmlString.append("<remarks>").append("<![CDATA["+checkNullAndTrim(rs.getString("REMARKS"))+"]]>").append("</remarks>\r\n");
							valueXmlString.append("<dlv_term>").append("<![CDATA["+dlvTerm+"]]>").append("</dlv_term>\r\n");
							valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
							valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
							valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
							valueXmlString.append("<stan_code>").append("<![CDATA["+checkNullAndTrim(rs.getString("STAN_CODE"))+"]]>").append("</stan_code>\r\n");
							valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
							valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
							valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
							valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
							valueXmlString.append("<udf__str2>").append("<![CDATA[A]]>").append("</udf__str2>\r\n");
							valueXmlString.append("<emp_code__ord>").append("<![CDATA["+checkNullAndTrim(rs.getString("EMP_CODE"))+"]]>").append("</emp_code__ord>\r\n");
							valueXmlString.append("<udf__num2>").append("<![CDATA["+checkNullAndTrim(rs.getString("UDF__NUM2"))+"]]>").append("</udf__num2>\r\n");
							valueXmlString.append("<dlv_add1>").append("<![CDATA["+checkNullAndTrim(rs.getString("DLV_ADD1"))+"]]>").append("</dlv_add1>\r\n");
							valueXmlString.append("<dlv_add2>").append("<![CDATA["+checkNullAndTrim(rs.getString("DLV_ADD2"))+"]]>").append("</dlv_add2>\r\n");
							valueXmlString.append("<dlv_city>").append("<![CDATA["+checkNullAndTrim(rs.getString("DLV_CITY"))+"]]>").append("</dlv_city>\r\n");
							valueXmlString.append("<dlv_pin>").append("<![CDATA["+checkNullAndTrim(rs.getString("DLV_PIN"))+"]]>").append("</dlv_pin>\r\n");
							valueXmlString.append("<state_code__dlv>").append("<![CDATA["+checkNullAndTrim(rs.getString("STATE_CODE__DLV"))+"]]>").append("</state_code__dlv>\r\n");
							valueXmlString.append("<count_code__dlv>").append("<![CDATA["+checkNullAndTrim(rs.getString("COUNT_CODE__DLV"))+"]]>").append("</count_code__dlv>\r\n");
							valueXmlString.append("<dlv_to>").append("<![CDATA["+custNameDlv+"]]>").append("</dlv_to>\r\n");
							valueXmlString.append("<dlv_add3>").append("<![CDATA["+checkNullAndTrim(rs.getString("DLV_ADD3"))+"]]>").append("</dlv_add3>\r\n");
							valueXmlString.append("<tel1__dlv>").append("<![CDATA["+checkNullAndTrim(rs.getString("TEL1__DLV"))+"]]>").append("</tel1__dlv>\r\n");
							valueXmlString.append("<tel2__dlv>").append("<![CDATA["+checkNullAndTrim(rs.getString("TEL2__DLV"))+"]]>").append("</tel2__dlv>\r\n");
							valueXmlString.append("<part_qty>").append("<![CDATA["+checkNullAndTrim(rs.getString("PART_QTY"))+"]]>").append("</part_qty>\r\n");
							valueXmlString.append("<due_date>").append("<![CDATA["+sdf.format(dueDate)+"]]>").append("</due_date>\r\n");
							valueXmlString.append("<udf__str1>").append("<![CDATA["+ checkNullAndTrim(applDateFormat) +"]]>").append("</udf__str1>\r\n");
							
							valueXmlString.append("<price_list>").append("<![CDATA["+checkNullAndTrim(rs.getString("PRICE_LIST"))+"]]>").append("</price_list>\r\n");
							valueXmlString.append("<price_list__clg>").append("<![CDATA["+checkNullAndTrim(rs.getString("PRICE_LIST__CLG"))+"]]>").append("</price_list__clg>\r\n");
							valueXmlString.append("<tax_class>").append("<![CDATA["+taxClass+"]]>").append("</tax_class>\r\n");
							valueXmlString.append("<tax_chap>").append("<![CDATA["+taxChap+"]]>").append("</tax_chap>\r\n");
						}
						else
						{
							valueXmlString.append("<sale_order>").append("<![CDATA[]]>").append("</sale_order>\r\n");
							valueXmlString.append("<order_date>").append("<![CDATA["+currDate+"]]>").append("</order_date>\r\n");
							valueXmlString.append("<site_code>").append("<![CDATA["+loginSiteCode+"]]>").append("</site_code>\r\n");
							valueXmlString.append("<site_descr>").append("<![CDATA["+siteCodeDescr+"]]>").append("</site_descr>\r\n");
							valueXmlString.append("<item_ser>").append("<![CDATA["+itemSer+"]]>").append("</item_ser>\r\n");
							valueXmlString.append("<itemser_descr>").append("<![CDATA["+itemSerDescr+"]]>").append("</itemser_descr>\r\n");
							valueXmlString.append("<order_type>").append("<![CDATA["+orderType+"]]>").append("</order_type>\r\n");
							valueXmlString.append("<sordertype_descr>").append("<![CDATA["+orderTypeDescr+"]]>").append("</sordertype_descr>\r\n");
							valueXmlString.append("<cust_code>").append("<![CDATA["+custCode+"]]>").append("</cust_code>\r\n");
							valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+custCodeDlv+"]]>").append("</cust_code__dlv>\r\n");
							valueXmlString.append("<cust_name>").append("<![CDATA["+custName+"]]>").append("</cust_name>\r\n");
							valueXmlString.append("<cust_code__bil>").append("<![CDATA["+custNameBil+"]]>").append("</cust_code__bil>\r\n");
							valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBil+"]]>").append("</cust_name__bil>\r\n");
							valueXmlString.append("<remarks>").append("<![CDATA["+remarks+"]]>").append("</remarks>\r\n");
							valueXmlString.append("<dlv_term>").append("<![CDATA["+dlvTerm+"]]>").append("</dlv_term>\r\n");
							valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
							valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
							valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
							valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
							valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
							valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
							valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
							valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
							valueXmlString.append("<udf__str2>").append("<![CDATA[A]]>").append("</udf__str2>\r\n");
							valueXmlString.append("<emp_code__ord>").append("<![CDATA["+empCode+"]]>").append("</emp_code__ord>\r\n");
							valueXmlString.append("<udf__num2>").append("<![CDATA["+GetRandomNumber()+"]]>").append("</udf__num2>\r\n");
							valueXmlString.append("<dlv_add1>").append("<![CDATA["+dlvAddr1+"]]>").append("</dlv_add1>\r\n");
							valueXmlString.append("<dlv_add2>").append("<![CDATA["+dlvAddr2+"]]>").append("</dlv_add2>\r\n");
							valueXmlString.append("<dlv_city>").append("<![CDATA["+dlvAddr3+"]]>").append("</dlv_city>\r\n");
							valueXmlString.append("<dlv_pin>").append("<![CDATA["+dlvPin+"]]>").append("</dlv_pin>\r\n");
							valueXmlString.append("<state_code__dlv>").append("<![CDATA["+stateCodeDlv+"]]>").append("</state_code__dlv>\r\n");
							valueXmlString.append("<count_code__dlv>").append("<![CDATA["+countCodeDlv+"]]>").append("</count_code__dlv>\r\n");
							valueXmlString.append("<dlv_to>").append("<![CDATA["+custNameDlv+"]]>").append("</dlv_to>\r\n");
							valueXmlString.append("<dlv_add3>").append("<![CDATA["+dlvAddr3+"]]>").append("</dlv_add3>\r\n");
							valueXmlString.append("<tel1__dlv>").append("<![CDATA["+tele1+"]]>").append("</tel1__dlv>\r\n");
							valueXmlString.append("<tel2__dlv>").append("<![CDATA["+tele2+"]]>").append("</tel2__dlv>\r\n");
							valueXmlString.append("<part_qty>").append("<![CDATA["+partQty+"]]>").append("</part_qty>\r\n");
							valueXmlString.append("<due_date>").append("<![CDATA["+currDate+"]]>").append("</due_date>\r\n");
							valueXmlString.append("<udf__str1>").append("<![CDATA["+ checkNullAndTrim(applDateFormat) +"]]>").append("</udf__str1>\r\n");
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}	
						if(pstmt != null)
						{	
							pstmt.close();pstmt = null;
						}
					}
					
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2 :
				{
					/*saleOrder 			= checkNullAndTrim(genericUtility.getColumnValue("sale_order", dom1));
					String orderDate 		= checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
					String siteCode 		= checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
					siteCodeDescr 			= checkNullAndTrim(genericUtility.getColumnValue("site_descr", dom1));
					String itemSer	 		= checkNullAndTrim(genericUtility.getColumnValue("item_ser", dom1));
					String itemSerDescr     = checkNullAndTrim(genericUtility.getColumnValue("itemser_descr", dom1));
					String orderType	 	= checkNullAndTrim(genericUtility.getColumnValue("order_type", dom1));
					String sordertype_descr		 	= checkNullAndTrim(genericUtility.getColumnValue("sordertype_descr", dom1));
					String custCode			= checkNullAndTrim(genericUtility.getColumnValue("cust_code", dom1));
					String custCodeDlv 	    = checkNullAndTrim(genericUtility.getColumnValue("cust_code__dlv", dom1));
					String custName	        = checkNullAndTrim(genericUtility.getColumnValue("cust_name", dom1));
					String custCodeBill 	= checkNullAndTrim(genericUtility.getColumnValue("cust_code__bil", dom1));
					String custNameBill 	= checkNullAndTrim(genericUtility.getColumnValue("cust_name__bil", dom1));
					String remarks		 	= checkNullAndTrim(genericUtility.getColumnValue("remarks", dom1));
					String dlvTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("dlv_term", dom1));
					String crTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("cr_term", dom1));
					String currCode		 	= checkNullAndTrim(genericUtility.getColumnValue("curr_code", dom1));
					String stanCode		 	= checkNullAndTrim(genericUtility.getColumnValue("stan_code", dom1));
					String tranCode		 	= checkNullAndTrim(genericUtility.getColumnValue("tran_code", dom1));
					String transMode		= checkNullAndTrim(genericUtility.getColumnValue("trans_mode", dom1));
					String currCodeFrt		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__frt", dom1));
					String currCodeIns		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__ins", dom1));
					String udfStr2			= checkNullAndTrim(genericUtility.getColumnValue("udf__str2", dom1));
					String empCodeOrd		= checkNullAndTrim(genericUtility.getColumnValue("emp_code__ord", dom1));
					String random    		= checkNullAndTrim(genericUtility.getColumnValue("udf__num2", dom1));
					
					String dlvAdd1    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add1", dom1));
					String dlvAdd2    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add2", dom1));
					String dlvCity    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_city", dom1));
					String dlvPin    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_pin", dom1));
					String stateCode    	= checkNullAndTrim(genericUtility.getColumnValue("state_code__dlv", dom1));
					String countCode    	= checkNullAndTrim(genericUtility.getColumnValue("count_code__dlv", dom1));*/
					
					//int domID = 0;
					
					valueXmlString = SaveSorderHeader(dom1,valueXmlString,conn);
					
					/*valueXmlString.append("<Detail2 domID = '"+domID+"' selected = 'N'>\r\n");
					valueXmlString.append("<sale_order>").append("<![CDATA["+ saleOrder +"]]>").append("</sale_order>\r\n");
					valueXmlString.append("<order_date>").append("<![CDATA["+ orderDate +"]]>").append("</order_date>\r\n");
					valueXmlString.append("<site_code>").append("<![CDATA["+ siteCode +"]]>").append("</site_code>\r\n");
					valueXmlString.append("<site_descr>").append("<![CDATA["+ siteCodeDescr +"]]>").append("</site_descr>\r\n");
					valueXmlString.append("<item_ser>").append("<![CDATA["+ itemSer +"]]>").append("</item_ser>\r\n");
					valueXmlString.append("<itemser_descr>").append("<![CDATA["+ itemSerDescr +"]]>").append("</itemser_descr>\r\n");
					valueXmlString.append("<order_type>").append("<![CDATA["+ orderType +"]]>").append("</order_type>\r\n");
					valueXmlString.append("<sordertype_descr>").append("<![CDATA["+ sordertype_descr +"]]>").append("</sordertype_descr>\r\n");
					valueXmlString.append("<cust_code>").append("<![CDATA["+ custCode +"]]>").append("</cust_code>\r\n");
					valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+ custCodeDlv +"]]>").append("</cust_code__dlv>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA["+ custName +"]]>").append("</cust_name>\r\n");
					valueXmlString.append("<cust_code__bil>").append("<![CDATA["+ custCodeBill +"]]>").append("</cust_code__bil>\r\n");
					valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBill+"]]>").append("</cust_name__bil>\r\n");
					valueXmlString.append("<remarks>").append("<![CDATA["+ remarks +"]]>").append("</remarks>\r\n");
					valueXmlString.append("<dlv_term>").append("<![CDATA["+ dlvTerm +"]]>").append("</dlv_term>\r\n");
					valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
					valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
					valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
					valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
					valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
					valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
					valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
					valueXmlString.append("<udf__str2>").append("<![CDATA["+udfStr2+"]]>").append("</udf__str2>\r\n");
					valueXmlString.append("<emp_code__ord>").append("<![CDATA["+empCodeOrd+"]]>").append("</emp_code__ord>\r\n");
					valueXmlString.append("<udf__num2>").append("<![CDATA["+random+"]]>").append("</udf__num2>\r\n");
					
					valueXmlString.append("<dlv_add1>").append("<![CDATA["+dlvAdd1+"]]>").append("</dlv_add1>\r\n");
					valueXmlString.append("<dlv_add2>").append("<![CDATA["+dlvAdd2+"]]>").append("</dlv_add2>\r\n");
					valueXmlString.append("<dlv_city>").append("<![CDATA["+dlvCity+"]]>").append("</dlv_city>\r\n");
					valueXmlString.append("<dlv_pin>").append("<![CDATA["+dlvPin+"]]>").append("</dlv_pin>\r\n");
					valueXmlString.append("<state_code__dlv>").append("<![CDATA["+stateCode+"]]>").append("</state_code__dlv>\r\n");
					valueXmlString.append("<count_code__dlv>").append("<![CDATA["+countCode+"]]>").append("</count_code__dlv>\r\n");
					
					valueXmlString.append("</Detail2>\r\n");*/
					
				}
				break;
				case 3 :
				{
					saleOrder 				= checkNullAndTrim(genericUtility.getColumnValue("sale_order", dom1));
					String ordDate 			= checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
					String siteCode 		= checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
					siteCodeDescr 			= checkNullAndTrim(genericUtility.getColumnValue("site_descr", dom1));
					String itemSer	 		= checkNullAndTrim(genericUtility.getColumnValue("item_ser", dom1));
					String itemSerDescr     = checkNullAndTrim(genericUtility.getColumnValue("itemser_descr", dom1));
					String orderType	 	= checkNullAndTrim(genericUtility.getColumnValue("order_type", dom1));
					String custCode			= checkNullAndTrim(genericUtility.getColumnValue("cust_code", dom1));
					String custCodeDlv 	    = checkNullAndTrim(genericUtility.getColumnValue("cust_code__dlv", dom1));
					String custName	        = checkNullAndTrim(genericUtility.getColumnValue("cust_name", dom1));
					String custCodeBill 	= checkNullAndTrim(genericUtility.getColumnValue("cust_code__bil", dom1));
					String custNameBill 	= checkNullAndTrim(genericUtility.getColumnValue("cust_name__bil", dom1));
					       remarks		 	= checkNullAndTrim(genericUtility.getColumnValue("remarks", dom1));
					String dlvTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("dlv_term", dom1));
					String crTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("cr_term", dom1));
					String currCode		 	= checkNullAndTrim(genericUtility.getColumnValue("curr_code", dom1));
					String stanCode		 	= checkNullAndTrim(genericUtility.getColumnValue("stan_code", dom1));
					String tranCode		 	= checkNullAndTrim(genericUtility.getColumnValue("tran_code", dom1));
					String transMode		= checkNullAndTrim(genericUtility.getColumnValue("trans_mode", dom1));
					String currCodeFrt		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__frt", dom1));
					String currCodeIns		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__ins", dom1));
					       udfStr2			= checkNullAndTrim(genericUtility.getColumnValue("udf__str2", dom1));
					       empCodeOrd		= checkNullAndTrim(genericUtility.getColumnValue("emp_code__ord", dom1));
					String random    		= checkNullAndTrim(genericUtility.getColumnValue("udf__num2", dom1));
					String dlvAdd1    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add1", dom1));
					String dlvAdd2    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add2", dom1));
					       dlvCity    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_city", dom1));
					       dlvPin    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_pin", dom1));
					String stateCode    	= checkNullAndTrim(genericUtility.getColumnValue("state_code__dlv", dom1));
					String countCode    	= checkNullAndTrim(genericUtility.getColumnValue("count_code__dlv", dom1));
					String custNameDlv    	= checkNullAndTrim(genericUtility.getColumnValue("dlv_to", dom1));
					String dlvAdd3    	    = checkNullAndTrim(genericUtility.getColumnValue("dlv_add3", dom1));
					String tel1Dlv       	= checkNullAndTrim(genericUtility.getColumnValue("tel1__dlv", dom1));
					String tel2Dlv       	= checkNullAndTrim(genericUtility.getColumnValue("tel2__dlv", dom1));
					       partQty      	= checkNullAndTrim(genericUtility.getColumnValue("part_qty", dom1));
					String dueDate      	= checkNullAndTrim(genericUtility.getColumnValue("due_date", dom1));
					
					String orderTypeDescr   = checkNullAndTrim(genericUtility.getColumnValue("sordertype_descr", dom1));
					String dlvTermDescr     = checkNullAndTrim(genericUtility.getColumnValue("delivery_term_descr", dom1));
					
					int domID = 0;
					String itemCode = "";
					
					valueXmlString.append("<Detail3 domID = '"+domID+"' selected = 'N'>\r\n");
					valueXmlString.append("<sale_order>").append("<![CDATA["+ saleOrder +"]]>").append("</sale_order>\r\n");
					valueXmlString.append("<order_date>").append("<![CDATA["+ ordDate +"]]>").append("</order_date>\r\n");
					valueXmlString.append("<site_code>").append("<![CDATA["+ siteCode +"]]>").append("</site_code>\r\n");
					valueXmlString.append("<site_descr>").append("<![CDATA["+ siteCodeDescr +"]]>").append("</site_descr>\r\n");
					valueXmlString.append("<item_ser>").append("<![CDATA["+ itemSer +"]]>").append("</item_ser>\r\n");
					valueXmlString.append("<itemser_descr>").append("<![CDATA["+ itemSerDescr +"]]>").append("</itemser_descr>\r\n");
					valueXmlString.append("<order_type>").append("<![CDATA["+ orderType +"]]>").append("</order_type>\r\n");
					valueXmlString.append("<sordertype_descr>").append("<![CDATA["+ orderTypeDescr +"]]>").append("</sordertype_descr>\r\n");
					valueXmlString.append("<cust_code>").append("<![CDATA["+ custCode +"]]>").append("</cust_code>\r\n");
					valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+ custCodeDlv +"]]>").append("</cust_code__dlv>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA["+ custName +"]]>").append("</cust_name>\r\n");
					valueXmlString.append("<cust_code__bil>").append("<![CDATA["+ custCodeBill +"]]>").append("</cust_code__bil>\r\n");
					valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBill+"]]>").append("</cust_name__bil>\r\n");
					valueXmlString.append("<remarks>").append("<![CDATA["+ remarks +"]]>").append("</remarks>\r\n");
					valueXmlString.append("<dlv_term>").append("<![CDATA["+ dlvTerm +"]]>").append("</dlv_term>\r\n");
					valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
					valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
					valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
					valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
					valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
					valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
					valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
					valueXmlString.append("<udf__str2>").append("<![CDATA["+udfStr2+"]]>").append("</udf__str2>\r\n");
					valueXmlString.append("<emp_code__ord>").append("<![CDATA["+empCodeOrd+"]]>").append("</emp_code__ord>\r\n");
					valueXmlString.append("<udf__num2>").append("<![CDATA["+random+"]]>").append("</udf__num2>\r\n");
					valueXmlString.append("<dlv_add1>").append("<![CDATA["+dlvAdd1+"]]>").append("</dlv_add1>\r\n");
					valueXmlString.append("<dlv_add2>").append("<![CDATA["+dlvAdd2+"]]>").append("</dlv_add2>\r\n");
					valueXmlString.append("<dlv_city>").append("<![CDATA["+dlvCity+"]]>").append("</dlv_city>\r\n");
					valueXmlString.append("<dlv_pin>").append("<![CDATA["+dlvPin+"]]>").append("</dlv_pin>\r\n");
					valueXmlString.append("<state_code__dlv>").append("<![CDATA["+stateCode+"]]>").append("</state_code__dlv>\r\n");
					valueXmlString.append("<count_code__dlv>").append("<![CDATA["+countCode+"]]>").append("</count_code__dlv>\r\n");
					valueXmlString.append("<dlv_to>").append("<![CDATA["+custNameDlv+"]]>").append("</dlv_to>\r\n");
					valueXmlString.append("<dlv_add3>").append("<![CDATA["+dlvAdd3+"]]>").append("</dlv_add3>\r\n");
					valueXmlString.append("<tel1__dlv>").append("<![CDATA["+tel1Dlv+"]]>").append("</tel1__dlv>\r\n");
					valueXmlString.append("<tel2__dlv>").append("<![CDATA["+tel2Dlv+"]]>").append("</tel2__dlv>\r\n");
					valueXmlString.append("<part_qty>").append("<![CDATA["+partQty+"]]>").append("</part_qty>\r\n");
					valueXmlString.append("<due_date>").append("<![CDATA["+dueDate+"]]>").append("</due_date>\r\n");
					valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
					valueXmlString.append("<udf__str1>").append("<![CDATA["+ checkNullAndTrim(applDateFormat) +"]]>").append("</udf__str1>\r\n");
					
					valueXmlString.append("</Detail3>\r\n");
					
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						NodeList detail2NodeList = dom2.getElementsByTagName("Detail2");
						int detail2NodeListlen = detail2NodeList.getLength();
						
						HashMap<String, ArrayList> tempMap = new HashMap<String, ArrayList>();
						ArrayList tempList = null;
						String itemParnt  = "",quantity = "",tabNo = "",discount = "",rate = "";
						
						for(int ctr = 0 ;ctr < detail2NodeListlen;ctr++)
						{
							Node childNode = detail2NodeList.item(ctr);
							
							if(childNode != null && childNode.getNodeType() != childNode.ELEMENT_NODE)
							{
								continue;
							}
							
							NodeList childList = childNode.getChildNodes();
							
							for(int ctrCh = 0; ctrCh < childList.getLength(); ctrCh++)
							{
								Node itmNode = childList.item(ctrCh);
						
								if(itmNode !=null && ("item_code").equalsIgnoreCase(itmNode.getNodeName()))
								{
									itemCode = itmNode.getFirstChild().getNodeValue();
									
									sql = " SELECT ITEM_PARNT, ITEM_SER FROM ITEM WHERE ITEM_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, itemCode);
									rs = pstmt.executeQuery();
									if ( rs.next() )
									{
										itemParnt = checkNullAndTrim(rs.getString("item_parnt"));
										itemSer = checkNullAndTrim(rs.getString("item_ser"));
										
									}
									rs.close();rs = null;
									pstmt.close();pstmt = null;
									
								}
								else if(itmNode !=null && ("quantity").equalsIgnoreCase(itmNode.getNodeName()))
								{
									quantity = itmNode.getFirstChild().getNodeValue();
								}
								else if(itmNode !=null && ("dsp_date").equalsIgnoreCase(itmNode.getNodeName()))
								{
									ordDate = itmNode.getFirstChild().getNodeValue();
								}
								else if(itmNode !=null && ("line_no__contr").equalsIgnoreCase(itmNode.getNodeName()))
								{
									tabNo = itmNode.getFirstChild().getNodeValue();
								}
								else if(itmNode !=null && ("discount").equalsIgnoreCase(itmNode.getNodeName()))
								{
									discount = itmNode.getFirstChild().getNodeValue();
								}
								else if(itmNode !=null && ("rate").equalsIgnoreCase(itmNode.getNodeName()))
								{
									rate = itmNode.getFirstChild().getNodeValue();
								}
							}

							System.out.println("itemParnt["+itemParnt+"]");
							if(itemCode != null && itemCode.length() > 0)
							{
								//String dataStr = itemCode + "~" + quantity + "~" + ordDate;
								//String dataStr = itemCode + "~" + quantity + "~" + ordDate + "~" + tabNo;
								  String dataStr = itemCode + "~" + quantity + "~" + ordDate + "~" + tabNo +"~"+ discount +"~"+ rate;
								
								System.out.println("Data String="+dataStr);
								
								if(tempMap.containsKey(itemParnt))
								{
									tempList = (ArrayList)tempMap.get(itemParnt);
								}
								else
								{
									tempList =  new ArrayList();
								}
								tempList.add(dataStr); 
								tempMap.put(itemParnt, tempList);
								itemParnt = "";
							}
							//System.out.println("ItemCode ["+itemCode+"]quantity["+quantity+"]dlv_date["+ordDate+"]");
						}
					
						ArrayList itemList = null;
						//Set keySet =  tempMap.keySet();
						//Iterator it = keySet.iterator();
						int count = 1;
						String itemParent = "",detail3Str = "";

						for (Entry<String, ArrayList> entry : tempMap.entrySet()) 
						{ 
							itemParnt = entry.getKey();
							ArrayList<String> value = entry.getValue(); 
							
							for(String aString : value)
							{ 
								//System.out.println("key : " + itemParnt + " value : " + aString); 
								
								/*String[] arr = aString.split("~");
								itemCode = arr[0];
								quantity = arr[1];
								ordDate = arr[2];
								tabNo = arr[3];*/
								//System.out.println("itemCode------"+arr[0]);
								//System.out.println("quantity------"+arr[1]);
								//System.out.println("dlvDate------"+arr[2]);
								
								domID++;
								
								//detail3Str = getSorderDetails(dom1, dom2,itemParnt,itemCode,quantity,ordDate,domID,conn);
								//detail3Str = getSorderDetails(dom1, dom2,itemParnt,itemCode,quantity,ordDate,tabNo,domID,conn);
								detail3Str = getSorderDetails(dom1, dom2,itemParnt,aString,domID,conn);
								
								//System.out.println("detail3Str["+detail3Str+"]");
								valueXmlString.append(detail3Str+"\r\n");
								
							} 
						}
						
						/*while(it.hasNext())
						{
							itemParent = (String) it.next();
							itemList = tempMap.get(itemParent);
							System.out.println(tempMap.get(itemParent));
							
							System.out.println("Group Item Parant["+itemParnt+"]");
							
							for(int i = 0; i< itemList.size(); i++)
							{
								String itemStr = (String) itemList.get(i);
								
								String[] arr = itemStr.split("~");
								itemCode = arr[0];
								quantity = arr[1];
								ordDate = arr[2];
								
								System.out.println("itemCode------"+arr[0]);
								System.out.println("quantity------"+arr[1]);
								System.out.println("dlvDate------"+arr[2]);
								
								domID++;
								
								detail3Str = getSorderDetails(dom1, dom2,itemParnt,itemCode,quantity,ordDate,domID,conn);
								System.out.println("detail3Str["+detail3Str+"]");
								valueXmlString.append(detail3Str+"\r\n");
								
							}
						}*/
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside Catch SorderWizardEJB"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				if(rsSel != null)
				{
					rsSel.close();rsSel = null;
				}	
				if(pstmtShipper != null)
				{	
					pstmtShipper.close();pstmtShipper = null;
				}
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		//System.out.println("valueXmlString ::"+valueXmlString.toString());

		return valueXmlString.toString();
	}
	
	/**
	 * select error description from MESSAGES
	 * @param conn
	 * @param errorCode
	 * @return
	 */
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
	@Override
	//public String getList(String param, String field, String[] values)	 throws RemoteException, ITMException
	public String getList(String param, String field, String[] values,String details)	 throws RemoteException, ITMException 
	{
		String sql = "";
		//StringBuffer valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding=\"iso-8859-1\" ?> \r\n <Root>\r\n");
		StringBuffer valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding=\"UTF-8\" ?> \r\n <Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null, pstmtTran = null;
		ResultSet rs = null;
		try 
		{
			System.out.println("Inside SorderWizardEJB getList---->Param["+param+"] Field["+field+"] Values["+values+"] Details["+details+"]");

			conn = getConnection();
			
			if ("sale_order".equalsIgnoreCase(field))
			{
				sql = " SELECT SALE_ORDER,CUST_CODE FROM SORDER WHERE CONFIRMED = 'N' ORDER BY ORDER_DATE DESC ";
			}
			else if ("site_code".equalsIgnoreCase(field))
			{
				sql = " SELECT SITE_CODE,DESCR FROM SITE ";
			}
			else if ("order_type".equalsIgnoreCase(field))
			{
				sql = " SELECT ORDER_TYPE,DESCR FROM SORDERTYPE ";
			}
			else if ("item_ser".equalsIgnoreCase(field))
			{
				sql = " SELECT ITEM_SER,DESCR FROM ITEMSER ";
			}
			else if ("order_type".equalsIgnoreCase(field))
			{
				sql = " SELECT ORDER_TYPE,DESCR FROM SORDERTYPE ";
			}
			else if ("cust_code".equalsIgnoreCase(field))	
			{
				if(param.length() > 0)
				{
					sql = " SELECT CUST_CODE,CUST_NAME,CR_TERM,CURR_CODE,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,"
						+ " ADDR1,ADDR2,CITY,PIN,STATE_CODE,COUNT_CODE,TELE1,TELE2,ADDR3 FROM CUSTOMER "
						+ " WHERE CUST_CODE = ?";
				}
				else
				{
					sql = " SELECT CUST_CODE,CUST_NAME,CR_TERM,CURR_CODE,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,"
							+ " ADDR1,ADDR2,CITY,PIN,STATE_CODE,COUNT_CODE,TELE1,TELE2,ADDR3 FROM CUSTOMER ORDER BY CUST_CODE ";
				}
			}
			else if ("cust_code__dlv".equalsIgnoreCase(field))
			{
				if(param.length() > 0)
				{
					sql = " SELECT CUST_CODE,CUST_NAME,CR_TERM,CURR_CODE,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,"
						+ " ADDR1,ADDR2,CITY,PIN,STATE_CODE,COUNT_CODE,TELE1,TELE2,ADDR3 FROM CUSTOMER "
						+ " WHERE CUST_CODE = ? ";
				}
				else
				{
						sql = " SELECT CUST_CODE,CUST_NAME,CR_TERM,CURR_CODE,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,"
								+ " ADDR1,ADDR2,CITY,PIN,STATE_CODE,COUNT_CODE,TELE1,TELE2,ADDR3 FROM CUSTOMER ORDER BY CUST_CODE ";
				}		
			}
			else if ("cust_code__bil".equalsIgnoreCase(field))
			{
				if(param.length() > 0)
				{
					sql = " SELECT CUST_CODE,CUST_NAME,TELE1 FROM CUSTOMER WHERE CUST_CODE = ?"; 
				}
				else
				{
					sql = " SELECT CUST_CODE,CUST_NAME,TELE1 FROM CUSTOMER ORDER BY CUST_CODE ";
				}
			}
			else if ("dlv_term".equalsIgnoreCase(field))
			{
				sql = " SELECT DLV_TERM,DESCR FROM DELIVERY_TERM ";
			}
			else if ("cr_term".equalsIgnoreCase(field))
			{
				sql = " SELECT CR_TERM,DESCR FROM CRTERM ";
			}
			else if ("item_code".equalsIgnoreCase(field))
			{
				//sql = " SELECT ITEM_CODE,DESCR FROM ITEM WHERE ITEM_PARNT IS NULL AND ITEM_SER = ? ";
				sql = " SELECT ITEM_CODE,DESCR FROM ITEM WHERE ITEM_PARNT IS NULL ";
			}
			else if ("state_code__dlv".equalsIgnoreCase(field))
			{
				sql = " SELECT STATE_CODE, DESCR FROM STATE ";
			}
			else if ("stan_code".equalsIgnoreCase(field))
			{
				sql = " SELECT STAN_CODE, DESCR FROM STATION ";
			}
			else if ("count_code__dlv".equalsIgnoreCase(field))
			{
				sql = " SELECT COUNT_CODE, DESCR FROM COUNTRY ";
			}
			else if ("tran_code".equalsIgnoreCase(field))
			{
				sql = " SELECT TRAN_CODE,TRAN_NAME,TRANSPORTER_TYPE FROM TRANSPORTER ";
			}
			
			System.out.println("Sql is="+sql);
			
			pstmt = conn.prepareStatement(sql);
			
			/*if ("item_code".equalsIgnoreCase(field))
			{
				pstmt.setString(1, values[1]);
			}
			else*/
			if ( param.length() > 0 && ("cust_code".equalsIgnoreCase(field) || "cust_code__dlv".equalsIgnoreCase(field) || "cust_code__bil".equalsIgnoreCase(field)))
			{
				pstmt.setString(1, param);
			}
			
			rs = pstmt.executeQuery();
			
			int num = 1;
			
			String fieldId = "",fieldValue = "",otherField = "";
			String crTerm = "",currCode = "",stanCode = "",tranCode = "",transMode = "",currCodeFrt = "",currCodeIns = "",
					city = "",pin = "",stateCode = "", country = "",dlvAdd1 = "",dlvAdd2 = "",tele1 = "",tele2 = "",dlvAdd3 = "";
			
			while (rs.next())
			{
				fieldId = "";
				fieldValue = "";
				otherField = "";
				
				fieldId = checkNullAndTrim(rs.getString(1));
				fieldValue = checkNullAndTrim(rs.getString(2));
				
				if ("tran_code".equalsIgnoreCase(field))
				{
					otherField = checkNullAndTrim(rs.getString(3));
				}
				else if ("cust_code".equalsIgnoreCase(field) || "cust_code__dlv".equalsIgnoreCase(field))
				{
					crTerm = "";currCode = "";stanCode = "";tranCode = "";transMode = "";currCodeFrt = "";currCodeIns = "";
					city = "";pin = "";stateCode = "";country = "";dlvAdd1 = "";dlvAdd2 = "";dlvAdd3 = "";tele1 = "";tele2 = "";
					
					crTerm   	= checkNullAndTrim(rs.getString(3));
					currCode 	= checkNullAndTrim(rs.getString(4));
					stanCode 	= checkNullAndTrim(rs.getString(5));
					tranCode 	= checkNullAndTrim(rs.getString(6));
					transMode 	= checkNullAndTrim(rs.getString(7));
					currCodeFrt = checkNullAndTrim(rs.getString(8));
					currCodeIns = checkNullAndTrim(rs.getString(9));
					
					dlvAdd1 = checkNullAndTrim(rs.getString("ADDR1"));
					dlvAdd2 = checkNullAndTrim(rs.getString("ADDR2"));
					city = checkNullAndTrim(rs.getString("CITY"));
					pin = checkNullAndTrim(rs.getString("PIN"));
					stateCode = checkNullAndTrim(rs.getString("STATE_CODE"));
					country = checkNullAndTrim(rs.getString("COUNT_CODE"));
					tele1 = checkNullAndTrim(rs.getString("TELE1"));
					tele2 = checkNullAndTrim(rs.getString("TELE2"));
					dlvAdd3 = checkNullAndTrim(rs.getString("ADDR3"));
					
					otherField  = crTerm +":"+ currCode +":"+ stanCode +":"+ tranCode +":"+ transMode +":"+ currCodeFrt +":"+ currCodeIns 
							      +":"+ dlvAdd1 +":"+ dlvAdd2 +":"+ city +":"+ pin +":"+ stateCode +":"+ country +":"+ tele1 +":"+ tele2 +":"+ 
							      dlvAdd3;
				}

					valueXmlString.append("<List domID='" + num + "' selected = '" + useLoop(values, fieldId) + "'>\r\n");
					valueXmlString.append("<fieldId><![CDATA[").append(fieldId).append("]]></fieldId>\r\n");
					valueXmlString.append("<fieldValue><![CDATA[").append(fieldValue).append("]]></fieldValue>\r\n");
					valueXmlString.append("<otherField><![CDATA[").append(otherField).append("]]></otherField>\r\n");
					
					if ("cust_code".equalsIgnoreCase(field) || "cust_code__bil".equalsIgnoreCase(field) || "cust_code__dlv".equalsIgnoreCase(field))
					{
						tele1 = checkNullAndTrim(rs.getString("TELE1"));
						valueXmlString.append("<tele1><![CDATA[").append(tele1).append("]]></tele1>\r\n");
					}
					
					valueXmlString.append("</List>\r\n");
				num++;
			}
			
			if(details.length() > 0)
			{
				Document dom = genericUtility.parseString(details); 
				Node currDetail = null;
				NodeList detail1List = null;
				NodeList currDetail1List = null;
				Node childNode = null;
				detail1List = dom.getElementsByTagName("Headers");
				for ( int ctr1 = 0; ctr1 < detail1List.getLength(); ctr1++ )
				{
					valueXmlString.append("<Headers domID='" + ctr1 + "' selected = 'N' >\r\n");
					currDetail = detail1List.item(ctr1);
					currDetail1List = currDetail.getChildNodes();
					for ( int i=0; i< currDetail1List.getLength(); i++ )
					{
						childNode = currDetail1List.item(i);
						String nodeName = childNode.getNodeName();	
						String nodeValue = "";
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							nodeValue =  checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("FieldName="+nodeName+" ****** Fieldvalue="+nodeValue);
						if (nodeName.equalsIgnoreCase("headName"))
						{
							valueXmlString.append("<headName><![CDATA[").append(nodeValue).append("]]></headName>\r\n");
						}
						if (nodeName.equalsIgnoreCase("headSize"))
						{
							valueXmlString.append("<headSize><![CDATA[").append(nodeValue).append("]]></headSize>\r\n");
						}
					}
					valueXmlString.append("</Headers>\r\n");
				}	
			}
		} 
		catch (Exception e) 
		{
			System.out.println("Exception inside SordergetList==>"+e.getMessage());
			e.printStackTrace();
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if( pstmtTran != null )
				{
					pstmtTran.close();pstmtTran = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				e.getMessage();
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		//System.out.println("\n****ValueXmlString Pop Help:" + valueXmlString.toString()	+ ":********");
		
		return valueXmlString.toString();
	}
	
	public String getAutoSearchData(String param, String field, String parameters) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding=\"UTF-8\" ?> \r\n <Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null, pstmtTran = null;
		ResultSet rs = null;
		try 
		{
			System.out.println("Inside getAutoSearchData getList---->Param["+param+"] Field["+field+"] Parameters ["+parameters+"]");
			
			conn = getConnection();
			
			String [] extras = parameters.split("~"); 
			
			valueXmlString.append("<DOCUMENTROOT><DESCRIPTION/><METADATA><DEFAULT_COL>1</DEFAULT_COL></METADATA><GROUP0><DESCRIPTION/><HEADER0>");
			
			if ("cust_code".equalsIgnoreCase(field))	
			{
				sql = " SELECT CUST_CODE,CUST_NAME,TELE1 FROM CUSTOMER "
					+ " WHERE UPPER(CUST_CODE) LIKE UPPER ('"+param+"%') OR UPPER(CUST_NAME) LIKE UPPER ('"+param+"%') OR UPPER(TELE1) LIKE UPPER('"+param+"%') OR UPPER(TELE2) LIKE UPPER('"+param+"%') OR UPPER(TELE3) LIKE UPPER('%"+param+"%') " 
					+ " ORDER BY CUST_CODE ";
			}
			else if ("cust_code__dlv".equalsIgnoreCase(field))
			{
				sql = " SELECT CUST_CODE,CUST_NAME,TELE1 FROM CUSTOMER "
					+ " WHERE UPPER(CUST_CODE) LIKE UPPER('"+param+"%') OR UPPER(CUST_NAME) LIKE UPPER('"+param+"%') OR UPPER(TELE1) LIKE UPPER('"+param+"%') OR UPPER(TELE2) LIKE UPPER('"+param+"%') OR UPPER(TELE3) LIKE UPPER('"+param+"%') " 
					+ " ORDER BY CUST_CODE ";
			}
			else if ("cust_code__bil".equalsIgnoreCase(field))
			{
				sql = " SELECT CUST_CODE,CUST_NAME,TELE1 FROM CUSTOMER WHERE UPPER(CUST_CODE) LIKE UPPER('"+param+"%') OR UPPER(CUST_NAME) LIKE UPPER('"+param+"%')"
				    + " OR UPPER(TELE1) LIKE UPPER('"+param+"%') OR UPPER(TELE2) LIKE UPPER('"+param+"%') OR UPPER(TELE3)"
				    + " LIKE UPPER('"+param+"%') "; 
			}
			else if ("item_code".equalsIgnoreCase(field))
			{
				if(parameters.length() > 0 )
				{
					if("T".equalsIgnoreCase(extras[1]))	
					{
				    	sql =" SELECT ITEM_CODE,DESCR,ITEM_SER FROM ITEM WHERE ITEM_CODE "
							+" IN (SELECT  DISTINCT ITEM_PARNT FROM ITEM WHERE ITEM_CODE IN " 
						    +" (SELECT ITEM_CODE FROM SUPPLIERITEM WHERE SUPP_CODE = ? )) AND ITEM_CODE LIKE UPPER ('"+param+"%') ";
					}
					else
					{
						sql =" SELECT I.ITEM_CODE,I.DESCR,I.ITEM_SER FROM ITEM I,ITEMSER S WHERE I.ITEM_CODE IN " +
							 " (SELECT ITEM_CODE FROM SUPPLIERITEM WHERE SUPP_CODE = ? ) " +
							 " AND I.ITEM_SER = S.ITEM_SER AND S.BUSINESS_TYPE  = ? AND I.ITEM_CODE LIKE UPPER ('"+param+"%') ";
					}
				}
				else
				{
					sql = " SELECT ITEM_CODE,DESCR,ITEM_SER FROM ITEM WHERE ITEM_PARNT IS NULL AND ITEM_CODE LIKE UPPER ('"+param+"%') ";
				}
				
			}
			
			System.out.println("Sql is="+sql);
			
			pstmt = conn.prepareStatement(sql);

			if("item_code".equalsIgnoreCase(field) && parameters.length() > 0)
			{
				if("T".equalsIgnoreCase(extras[1]))	
				{
					pstmt.setString(1,extras[0]);
				}
				else
				{
					pstmt.setString(1,extras[0]);
					pstmt.setString(2,extras[1]);
				}
			}
			
			rs = pstmt.executeQuery();
			
			int num = 1;
			
			String fieldId = "",fieldValue = "",otherField = "";
			
			while (rs.next())
			{
				fieldId = "";
				fieldValue = "";
				otherField = "";
				
				fieldId = checkNullAndTrim(rs.getString(1));
				fieldValue = checkNullAndTrim(rs.getString(2));
				otherField = checkNullAndTrim(rs.getString(3));
				
				valueXmlString.append("<DETAIL id='"+num+"'>"
										+ "<"+field+" dbType='VARCHAR2'><![CDATA["+fieldId+"]]></"+field+"> "
										+ "<Descr dbType='VARCHAR2'><![CDATA["+fieldValue+"]]></Descr>"
										+ "<otherField dbType='VARCHAR2'><![CDATA["+otherField+"]]></otherField>"
									+ "</DETAIL>");
				num++;
			}
			
			valueXmlString.append("<DESCRIPTION/></HEADER0></GROUP0></DOCUMENTROOT>");
		} 
		catch (Exception e) 
		{
			System.out.println("Exception inside getAutoSearchData==>"+e.getMessage());
			e.printStackTrace();
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if( pstmtTran != null )
				{
					pstmtTran.close();pstmtTran = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				e.getMessage();
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		//System.out.println("\n****ValueXmlString Pop Help:" + valueXmlString.toString()	+ ":********");
		
		return valueXmlString.toString();
	}
	
	//public String getSKUDetail(String itemParent,String itemDLVDate,String paraData) throws ITMException 
	public String getSKUDetail(String itemParentData,String itemDLVDate,String paraData,String otherDetails) throws ITMException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ inside getSKUDetail ]XXXXXXXXXXXXXXXXXXXX");
		String sql = "";
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String color,size,dimension,itemCode = "";
		
		String dColor,dSize,dDim = "",dColorDescr = "",dDimDescr = "";
		
		HashMap dataMap = new HashMap();
		ArrayList sizeList = new ArrayList();
		ArrayList colorList = new ArrayList();
		ArrayList dimensionList = new ArrayList();
		
		ArrayList tooltip = new ArrayList();
		
		HashMap colorData = new HashMap();
		HashMap dimensionData = new HashMap();
		
		StringBuffer valueXmlString = null;
		
		int cntColors = 0, cntDimension = 0, cntSizes = 0;
		try 
		{
			System.out.println("ItemParent["+itemParentData+"]  Date["+itemDLVDate+"]  Para Details["+paraData+"]");
			
			valueXmlString = new StringBuffer("<Root>\r\n");
			valueXmlString.append("<PRODUCT_SET selected = 'N'>\r\n");
		
			//String paraData = (request.getParameter("TRANTYPE")==null) ? "":request.getParameter("TRANTYPE").trim();
			//String itemDLVDate = (request.getParameter("DLVDate")==null) ? "":request.getParameter("DLVDate").trim();
			String itmDLVDate [] = itemDLVDate.split("~");
			String  DLVDate="";
			String paraDatas [] = paraData.split("~");
			//String tranType = paraDatas[0];
			//System.out.println("TRANTYPE = ["+tranType+"]");
			String dSizeDescr="";
			
			String itemData[] = itemParentData.split(":");
			String itemParent = itemData[0];
			String tabNum = itemData[1];
			
			conn = getConnection();
			
			//if(tranType.equals("T"))
			//{
				valueXmlString.append("<TH_SET selected = 'N'>\r\n");
				sql = " SELECT DISTINCT TRIM(V.ATTRIB_ID),SORT_ORDER AS PSIZE,V.DESCR FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I.PHY_ATTRIB_1 AND "
					+" I.ITEM_PARNT = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I.PHY_ATTRIB_22 "
					+ " AND I.ACTIVE = 'Y' "
					+" order by SORT_ORDER ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				pstmt.setString(2, itemParent);
				rs = pstmt.executeQuery();
				valueXmlString.append("<SET><![CDATA[").append("Color").append("]]></SET>\r\n");
				valueXmlString.append("<SET><![CDATA[").append("Dimension").append("]]></SET>\r\n");
				valueXmlString.append("<SET><![CDATA[").append("Quantity").append("]]></SET>\r\n");
				while (rs.next())
				{
					dSize = checkNullAndTrim(rs.getString(1));
					dSizeDescr = checkNullAndTrim(rs.getString(3));
					sizeList.add(dSize);
				
					valueXmlString.append("<SET><![CDATA[").append(dSizeDescr).append("]]></SET>\r\n");
					
					cntSizes++;
				}

				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}

				valueXmlString.append("</TH_SET>\r\n");
			
				sql = " SELECT DISTINCT I.PHY_ATTRIB_2,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V WHERE I.ITEM_PARNT = ? AND I.ITEM_CODE != ?"
					 +" AND I.PHY_ATTRIB_2 = V.ATTRIB_ID "
					 +" AND V.ATTRIB_CODE='COLOR' " 
					 +" AND I.ACTIVE = 'Y' "
					 +" ORDER BY I.PHY_ATTRIB_2";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				pstmt.setString(2, itemParent);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					dColor = checkNullAndTrim(rs.getString(1));
					dColorDescr = checkNullAndTrim(rs.getString(2));
					colorList.add(dColor);
					colorData.put(dColor, dColorDescr);
					
					cntColors++;
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}

				sql = " SELECT DISTINCT I.PHY_ATTRIB_3,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V "
					 +" WHERE I.ITEM_PARNT = ? AND I.ITEM_CODE != ? AND I.PHY_ATTRIB_3 = V.ATTRIB_ID"
					 +" AND V.ATTRIB_CODE='DIMENSION' " 
					 +" AND I.ACTIVE = 'Y' "
					 +" ORDER BY I.PHY_ATTRIB_3";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				pstmt.setString(2, itemParent);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					dDim = checkNullAndTrim(rs.getString(1));
					dDimDescr = checkNullAndTrim(rs.getString(2));
					dimensionList.add(dDim);
					dimensionData.put(dDim,dDimDescr);
					
					cntDimension++;
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT PHY_ATTRIB_2 COLOR, PHY_ATTRIB_3 ITEMDIMENSION,ITEM_CODE,PHY_ATTRIB_1 SIZE1"
					 +" FROM ITEM WHERE item_parnt = ? AND ITEM_CODE != ? and  decode(catalog_no,null,'N',catalog_no) ='N' "
					 +" AND ACTIVE = 'Y' "
					 +" GROUP BY ITEM_CODE,PHY_ATTRIB_2,PHY_ATTRIB_1,PHY_ATTRIB_3 " 		
					 +" ORDER BY PHY_ATTRIB_1 ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				pstmt.setString(2, itemParent);
				rs = pstmt.executeQuery();

				int num = 1;
				while (rs.next())
				{
					color = checkNullAndTrim(rs.getString("COLOR"));
					dimension = checkNullAndTrim(rs.getString("ITEMDIMENSION"));
					size = checkNullAndTrim(rs.getString("SIZE1"));
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));

					dataMap.put(color+":"+dimension+":"+size, itemCode);
				}

				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}

				valueXmlString.append("<RECORDS>\r\n");
				
				String qty ="0",discount = "0.0",rate = "0.0";
				String itmCode = "";
				int dimlistlen = dimensionList.size();
				int colorlen = colorList.size();
				int sizelen = sizeList.size();
				String key = "";
				StringBuffer temStrBuffer = null;
				boolean isItemExist = false;
				for(int i=0;i<dimlistlen;i++)
				{
					for(int j=0;j<colorlen;j++)
					{
						temStrBuffer = new StringBuffer("");
						isItemExist = false;
						temStrBuffer.append("<tr>\r\n");
						temStrBuffer.append("<td><![CDATA[").append(colorData.get(colorList.get(j))).append("]]></td>\r\n"); 
						temStrBuffer.append("<td><![CDATA[").append(dimensionData.get(dimensionList.get(i))).append("]]></td>\r\n");
						temStrBuffer.append("<td><![CDATA[").append(0).append("]]></td>\r\n");
						for(int k=0;k<sizelen;k++)
						{
							key = colorList.get(j) + ":"+ dimensionList.get(i) + ":"+ sizeList.get(k);

							//System.out.println("Current Key["+key+"]");

							temStrBuffer.append("<td>\r\n");
							if(dataMap.containsKey(key))
							{
								isItemExist =true;
								
								//String qty ="0",discount = "0";
								qty ="0";
								discount = "0.0";
								rate = "0.0";
								for (int x=1;x<paraDatas.length; x++)
								{
									String itmQty[] = paraDatas[x].split("::");

									if(itmQty[0].equals(dataMap.get(key)))
									{
										qty = itmQty[1];
										discount = itmQty[2];
										rate = itmQty[3];
										break;
									}
								}

								if(qty.equals("0"))
								{
									//temStrBuffer.append("<![CDATA[").append(dataMap.get(key)).append("]]>\r\n");
									temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty+"~"+discount+"~"+rate).append("]]>\r\n");
								}
								else
								{
									//temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty).append("]]>\r\n");
									temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty+"~"+discount+"~"+rate).append("]]>\r\n");
								}
								
								//Changed by wasim
								//key = key + ":"+ getItemRate(dataMap.get(key).toString(), otherDetails, conn);
								/*itmCode = dataMap.get(key).toString();
								rate = getItemRate(dataMap.get(key).toString(), otherDetails, conn);
								key = key + ":"+ rate;*/
								
								itmCode = dataMap.get(key).toString();
								if("0.0".equalsIgnoreCase(rate) || "0".equalsIgnoreCase(rate) || rate == null || rate == "" || rate.trim().length() == 0)
								{	
									rate = getItemRate(itmCode, otherDetails, conn);
								}
								key = key + ":"+ rate;
								String toolTipData = key + ":"+ "Item Code- "+itmCode+""+
															  "&#010;Color- "+colorList.get(j)+
												              "&#010;Dimension- "+dimensionList.get(i)+
												              "&#010;Size- "+sizeList.get(k)+""+
												              "&#010;Rate- "+rate+"";
								
								System.out.println("Your Key is="+key);
								
								//tooltip.add(key);
								 tooltip.add(toolTipData);
							}
							else
							{
								isItemExist =true;
								temStrBuffer.append("<![CDATA[").append("X").append("]]>\r\n");

							}
							temStrBuffer.append("</td>\r\n");

						}
						temStrBuffer.append("</tr>\r\n");

						if(isItemExist)
						{
							valueXmlString.append(temStrBuffer.toString());
						}
					}

				}

				for (int i = 0; i < tooltip.size(); i++) 
				{
					//System.out.println("Adding="+tooltip.get(i));

					valueXmlString.append("<tooltip>\r\n");
					valueXmlString.append("<![CDATA[").append(tooltip.get(i)).append("]]>\r\n");
					valueXmlString.append("</tooltip>\r\n");
				}

				sql = " SELECT ITEM_CODE,descr FROM ITEM I WHERE I.ITEM_CODE = ?  AND I.ACTIVE = 'Y' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					//valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></Descr>\r\n");
					//valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2) +"  (Available in "+cntColors+" colors and "+cntSizes+" sizes)  ")).append("]]></Descr>\r\n");
					valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2) +"  available in "+cntColors+" color(s) and "+cntSizes+" size(s)  ")).append("]]></Descr>\r\n");
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				if(itmDLVDate.length>1)
				{
					DLVDate = itmDLVDate[1];
					valueXmlString.append("<DLVDate><![CDATA[").append(checkNullAndTrim(DLVDate)).append("]]></DLVDate>\r\n");
				}
				else
				{
					String splitData[] = otherDetails.split(":");
					String dspDate = splitData[3];
					valueXmlString.append("<DLVDate><![CDATA[").append(dspDate).append("]]></DLVDate>\r\n");
				}
				
				String itemParentRate = getItemRate(itemParent, otherDetails, conn);
				valueXmlString.append("<item_parent_rate><![CDATA[").append(itemParentRate).append("]]></item_parent_rate>\r\n");

				valueXmlString.append("<tab_no><![CDATA[").append(tabNum).append("]]></tab_no>\r\n");
				
				valueXmlString.append("</RECORDS>\r\n");
				valueXmlString.append("</PRODUCT_SET>\r\n");
				valueXmlString.append("</Root>");
				
			//}//End if Tran Type T
	        //else
	        //{
	        	/*sql = " SELECT ITEM_CODE,descr,decode(catalog_no,null,'N',catalog_no) FROM ITEM I WHERE I.ITEM_CODE = ? AND I.ACTIVE = 'Y' AND I.ITEM_PARNT IS NULL ";
	        	pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemParent);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
				valueXmlString.append("<TH_SET selected = 'N'>\r\n");
				valueXmlString.append("<SET><![CDATA[").append("Item Description").append("]]></SET>\r\n");
				valueXmlString.append("<SET><![CDATA[").append("Total Quantity").append("]]></SET>\r\n");
				valueXmlString.append("<SET><![CDATA[").append("Quantity").append("]]></SET>\r\n");
				valueXmlString.append("</TH_SET>\r\n");
				valueXmlString.append("<RECORDS>\r\n");
				valueXmlString.append("<tr>\r\n");
				valueXmlString.append("<td><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></td>\r\n");
				valueXmlString.append("<td><![CDATA[").append("0.0").append("]]></td>\r\n");
				
				if(rs.getString(3).equals("Y"))
				{
					valueXmlString.append("<td><![CDATA[").append("X").append("]]></td>\r\n");
				}
				else
				{
					if(paraDatas.length>1)
					{
						valueXmlString.append("<td><![CDATA[").append(itemParent+"~"+paraDatas[1]).append("]]></td>\r\n");
					}
					else
					{
						valueXmlString.append("<td><![CDATA[").append(itemParent).append("]]></td>\r\n");
					}
				}
				valueXmlString.append("</tr>\r\n");
				valueXmlString.append("<tooltip><![CDATA[").append("Quantity").append("]]></tooltip>\r\n");
				valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></Descr>\r\n");
				
				DLVDate = itemDLVDate;
				valueXmlString.append("<DLVDate><![CDATA[").append(checkNullAndTrim(DLVDate)).append("]]></DLVDate>\r\n");
				valueXmlString.append("</RECORDS>\r\n");
				valueXmlString.append("</PRODUCT_SET>\r\n");
				valueXmlString.append("</Root>");
				}*/	
	       //}
			
		}//End try
		catch (Exception e)
		{
			System.out.println("Exception inside getSKUDetail Sorder==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception ex) 
			{
				ex.printStackTrace();
			}
		}
		
        System.out.println("return Product Set=["+valueXmlString.toString()+"]");
        return valueXmlString.toString();
	}
	
	
	//public String getSorderDetails(Document dom1,Document dom2,String itemParent,String itemCode,String quantity,String ordDate,String tabNo,int domID,Connection conn) throws RemoteException, ITMException
	public String getSorderDetails(Document dom1,Document dom2,String itemParent,String aString,int domID,Connection conn) throws RemoteException, ITMException 
	{
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		
		StringBuffer valueXmlString = new StringBuffer("");
		
		double rate = 0,netAmount = 0,lcStdrate = 0,rateClg = 0;
		String lineNo = "",itemDescr = "",unit = "",siteCode = "",itemSer = "",custCodeDlv = "",custCodeBil = "",orderType = "",priceList = "",priceListClg = "",
				taxChap = "",taxClass = "",taxEnv = "",stationFrom = "",stationTo = "",unitRate = "",itmStru = "",packInstr = "",
			    lsPriceList = "",orderDate = "",dueDate = "",custCode = "",custItemRef = "",saleOrder = "";
		try
		{		
				System.out.println("Inside getSorderDetails-->ItemParent["+itemParent+"] DetailString["+aString+"] DOMId["+domID+"]");
			    String itemCode  = "",quantity = "",ordDate = "",tabNo = "",discount = "",itemRate = "";
				String[] arr = aString.split("~");
				itemCode = arr[0];
				quantity = arr[1];
				ordDate = arr[2];
				tabNo = arr[3];
				discount = arr[4];
				itemRate = arr[5];
			
				valueXmlString.append("<Detail3 domID='"+domID+"' selected = 'Y'>\r\n");
				
				saleOrder   = checkNullAndTrim(genericUtility.getColumnValue("sale_order", dom1));
				siteCode 	= checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
				orderDate 	= checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
				custCodeDlv = checkNullAndTrim(genericUtility.getColumnValue("cust_code__dlv", dom1));
				custCodeBil = checkNullAndTrim(genericUtility.getColumnValue("cust_code__bil", dom1));
				orderType   = checkNullAndTrim(genericUtility.getColumnValue("order_type", dom1));
				custCode = checkNullAndTrim(genericUtility.getColumnValue("cust_code", dom1));
				//Commented temporary
				//custCodeDlv = custCode;//for temporary need to check
				
				dueDate 	= checkNullAndTrim(genericUtility.getColumnValue("due_date", dom1));
				
				
				sql = " SELECT DESCR,UNIT,ITEM_SER,UNIT__RATE,ITEM_STRU,PACK_INSTR,PHY_ATTRIB_4 FROM ITEM WHERE ITEM_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					System.out.println("@@Insdie1");
					itemDescr = checkNullAndTrim(rs.getString("DESCR"));
					unit  	  = checkNullAndTrim(rs.getString("UNIT"));
					itemSer   = checkNullAndTrim(rs.getString("ITEM_SER"));
					unitRate  = checkNullAndTrim(rs.getString("UNIT__RATE"));
					itmStru   = checkNullAndTrim(rs.getString("ITEM_STRU"));
					packInstr = checkNullAndTrim(rs.getString("PACK_INSTR"));
					custItemRef = checkNullAndTrim(rs.getString("PHY_ATTRIB_4"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				System.out.println("@@Insdie2");
				
				/*sql = " SELECT  PRICE_LIST,PRICE_LIST__CLG FROM CUST_PLIST WHERE CUST_CODE =? AND ORDER_TYPE =? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, custCodeDlv);
				pstmt.setString(2, orderType);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					priceList    = checkNullAndTrim(rs.getString("PRICE_LIST"));
					priceListClg = checkNullAndTrim(rs.getString("PRICE_LIST__CLG"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}*/
				priceList = checkNullAndTrim(genericUtility.getColumnValue("price_list", dom1));
				priceListClg =checkNullAndTrim(genericUtility.getColumnValue("price_list__clg", dom1));
				taxClass =checkNullAndTrim(genericUtility.getColumnValue("tax_class", dom1));
				taxChap =checkNullAndTrim(genericUtility.getColumnValue("tax_chap", dom1));
				stationTo =checkNullAndTrim(genericUtility.getColumnValue("stan_code", dom1));
				
				System.out.println("Inside Case3 \n priceList["+priceList+"] priceListClg["+priceListClg+"] taxClass["+taxClass+"] taxChap["+taxChap+"] stationTo["+stationTo+"]");
				
				/*sql = " SELECT	STAN_CODE,TAX_CLASS,TAX_CHAP FROM CUSTOMER WHERE CUST_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, custCodeBil);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stationTo = checkNullAndTrim(rs.getString("STAN_CODE"));
					taxClass  = checkNullAndTrim(rs.getString("TAX_CLASS"));
					taxChap   = checkNullAndTrim(rs.getString("TAX_CHAP"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}*/
				
				sql = " SELECT STAN_CODE FROM SITE WHERE  SITE_CODE =? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stationFrom = checkNullAndTrim(rs.getString("STAN_CODE"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				if(taxChap.length() == 0)
				{	
					taxChap  = checkNullAndTrim(distCommon.getTaxChap(itemCode, itemSer, "C", custCodeDlv, siteCode, conn));
				}
				if(taxClass.length() == 0)
				{
					taxClass = checkNullAndTrim(distCommon.getTaxClass("C", custCodeDlv, itemCode, siteCode, conn));
				}
				
				taxEnv   = checkNullAndTrim(distCommon.getTaxEnv(stationFrom, stationTo, taxChap, taxClass, siteCode, conn));
				
				lineNo = "   " + domID;
				lineNo = lineNo.substring( lineNo.length()-3 );
				
				valueXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
				valueXmlString.append("<unit><![CDATA[").append(unit).append("]]></unit>\r\n");
				if ("F".equalsIgnoreCase(itmStru))
				{
					valueXmlString.append("<item_flg>").append("<![CDATA[" + 'B' + "]]>").append("</item_flg>\r\n");
				}
				else
				{
					valueXmlString.append("<item_flg>").append("<![CDATA[" + 'I' + "]]>").append("</item_flg>\r\n");
				}
				valueXmlString.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>\r\n");
				valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>\r\n");
				valueXmlString.append("<item_parnt><![CDATA[").append(itemParent).append("]]></item_parnt>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
				//valueXmlString.append("<dsp_date><![CDATA[").append(dueDate).append("]]></dsp_date>\r\n");
				valueXmlString.append("<dsp_date><![CDATA[").append(ordDate).append("]]></dsp_date>\r\n");
				valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
				
				
				if(itemRate != null && itemRate.trim().length() > 0)
				{
					try
					{
						lcStdrate = Double.parseDouble(itemRate);
					}
					catch(Exception e)
					{
						System.out.println("Rate exception in Detail3 Sorder Details");
						lcStdrate = 0;
					}
				}
				
				System.out.println("Item Rate="+lcStdrate);
				int cntRate = 0;
				
				if(lcStdrate <= 0)
				{	
					if(saleOrder.length() > 0)
					{
						 sql = "SELECT RATE FROM SORDDET WHERE ITEM_CODE = ? AND SALE_ORDER = ? ";
						 pstmt = conn.prepareStatement(sql);
						 pstmt.setString(1, itemCode);
						 pstmt.setString(2, saleOrder);
						 rs = pstmt.executeQuery();
						 if ( rs.next() )
						 {
							 lcStdrate = rs.getDouble("RATE");
							 cntRate++;
						 }
						if( rs != null )
						{
							rs.close();rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();pstmt = null;
						}
					}
					//else
					if(cntRate == 0)
					{
						/*lsPriceList = checkNullAndTrim(distCommon.getDisparams("999999", "STD_SO_PL", conn));
						if (lsPriceList.length() > 0)
						{
							lcStdrate = distCommon.pickRate(lsPriceList, orderDate, itemCode,"","L", conn);
						}
						else
						{
							lcStdrate = distCommon.pickRate(priceList, orderDate, itemCode,"","L", conn);
						}*/
						lcStdrate = distCommon.pickRate(priceList, orderDate, itemCode,"","L", conn);
					}	
				}	
					if( priceListClg.length() > 0 )
					{
						rateClg = distCommon.pickRate( priceListClg, orderDate, itemCode, "", "L", conn );
					}
				
				
				System.out.println("Rate Clg="+rateClg);
				if ( rateClg == 0 )
				{
					rateClg = lcStdrate;
				}
				valueXmlString.append("<rate><![CDATA[").append(lcStdrate).append("]]></rate>\r\n");
				valueXmlString.append("<rate__std>").append("<![CDATA[" + lcStdrate + "]]>").append("</rate__std>\r\n");
				valueXmlString.append("<rate__clg>").append("<![CDATA[" + rateClg + "]]>").append("</rate__clg>\r\n");
				valueXmlString.append("<unit__rate><![CDATA[").append(unitRate).append("]]></unit__rate>\r\n");
				
				netAmount = Double.parseDouble(quantity) * lcStdrate;
				
				valueXmlString.append("<net_amt><![CDATA[").append(netAmount).append("]]></net_amt>\r\n");
				valueXmlString.append("<tax_chap><![CDATA[").append(taxChap).append("]]></tax_chap>\r\n");
				valueXmlString.append("<tax_class><![CDATA[").append(taxClass).append("]]></tax_class>\r\n");
				valueXmlString.append("<tax_env><![CDATA[").append(taxEnv).append("]]></tax_env>\r\n");
				valueXmlString.append("<pack_instr><![CDATA[").append(packInstr).append("]]></pack_instr>\r\n");
				valueXmlString.append("<line_no__contr><![CDATA[").append(tabNo).append("]]></line_no__contr>\r\n");
				valueXmlString.append("<phy_attrib_4><![CDATA[").append(custItemRef).append("]]></phy_attrib_4>\r\n");
				
				valueXmlString.append("<discount><![CDATA[").append(discount).append("]]></discount>\r\n");
				
			valueXmlString.append("</Detail3>\r\n");
		}
		catch(Exception ex)
		{
			System.out.println("Inside Catch getSorderDetails"+ex.getMessage());
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return valueXmlString.toString();
	}
	
	
	public String getSorderSummaryDetails(String objName,String random)throws RemoteException, ITMException 
	{
		System.out.println("******** Inside getSorderSummaryDetails ***********");
		
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		Connection conn = null;
		StringBuffer valueXmlString = new StringBuffer("<root>\r\n");
		
		String saleOrder = "",remarks = "",custCode = "",taxAmt = "",custName = "",itemDescr = "";
		try
		{
			conn = getConnection();
			
			sql = "SELECT SALE_ORDER,REMARKS,CUST_CODE,TAX_AMT FROM SORDER WHERE UDF__NUM2 = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,random);			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				saleOrder = checkNullAndTrim(rs.getString("SALE_ORDER"));
				remarks   = checkNullAndTrim(rs.getString("REMARKS"));
				custCode  = checkNullAndTrim(rs.getString("CUST_CODE"));
				taxAmt    = checkNullAndTrim(rs.getString("TAX_AMT"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			sql = "SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,custCode);			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				custName = checkNullAndTrim(rs.getString("CUST_NAME"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			valueXmlString.append("<Detail1>\r\n");
			
			valueXmlString.append("<sale_order><![CDATA[").append(saleOrder).append("]]></sale_order>\r\n");
			valueXmlString.append("<cust_code><![CDATA[").append(custCode).append("]]></cust_code>\r\n");
			valueXmlString.append("<cust_name><![CDATA[").append(custName).append("]]></cust_name>\r\n");
			valueXmlString.append("<tax_amt><![CDATA[").append(taxAmt).append("]]></tax_amt>\r\n");
			valueXmlString.append("<remarks><![CDATA[").append(remarks).append("]]></remarks>\r\n");
			
			valueXmlString.append("</Detail1>");
			
			
			String itemCode = "",netAmt = "",quantity = "",taxAmtDet = "",taxClass = "",taxChap = "",taxEnv = "";
			
			//sql = "SELECT ITEM_CODE,NET_AMT,QUANTITY,TAX_AMT,TAX_CLASS,TAX_CHAP,TAX_ENV FROM SORDDET WHERE SALE_ORDER = ? ";
			sql = " SELECT S.ITEM_CODE,S.NET_AMT,S.QUANTITY,S.TAX_AMT,S.TAX_CLASS,S.TAX_CHAP,S.TAX_ENV,I.DESCR FROM SORDDET S,ITEM I "
				+ " WHERE S.SALE_ORDER = ? AND I.ITEM_CODE = S.ITEM_CODE ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, saleOrder);
			rs = pstmt.executeQuery();
			int domID = 0;
			
			while(rs.next())
			{
				itemCode   = checkNullAndTrim(rs.getString("ITEM_CODE"));
				netAmt 	   = checkNullAndTrim(rs.getString("NET_AMT"));
				quantity   = checkNullAndTrim(rs.getString("QUANTITY"));
				taxAmtDet  = checkNullAndTrim(rs.getString("TAX_AMT"));
				taxClass   = checkNullAndTrim(rs.getString("TAX_CLASS"));
				taxChap    = checkNullAndTrim(rs.getString("TAX_CHAP"));
				taxEnv     = checkNullAndTrim(rs.getString("TAX_ENV"));
				
				itemDescr  = checkNullAndTrim(rs.getString("DESCR"));
				
				domID++;
				
				valueXmlString.append("<Detail2 domID = '"+domID+"' >");
				
					valueXmlString.append("<cust_name><![CDATA[").append(custName).append("]]></cust_name>\r\n");
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append("<net_amt><![CDATA[").append(netAmt).append("]]></net_amt>\r\n");
					valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
					valueXmlString.append("<tax_amt><![CDATA[").append(taxAmtDet).append("]]></tax_amt>\r\n");
					valueXmlString.append("<tax_class><![CDATA[").append(taxClass).append("]]></tax_class>\r\n");
					valueXmlString.append("<tax_chap><![CDATA[").append(taxChap).append("]]></tax_chap>\r\n");
					valueXmlString.append("<tax_env><![CDATA[").append(taxEnv).append("]]></tax_env>\r\n");
					
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					
				valueXmlString.append("</Detail2>");	
				
			}
			if( pstmt != null )
			{
				pstmt.close();pstmt = null;
			}
			if (rs != null)
			{
				rs.close();rs = null;
			}
			valueXmlString.append("</root>\r\n");
			
			
		}
		catch(Exception e)
		{
			System.out.println("Inside catch getSorderSummaryDetails"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				if (conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
					
		return valueXmlString.toString();
	}
	
	public String getSorderDetail2(String siteCode,String empCode,String saleOrder,String status)throws ITMException 
	{
		System.out.println("******** Inside getSorderDetail2 ***********");
		System.out.println("******** SiteCode["+siteCode+"] EmpCode["+empCode+"] SaleOrder["+saleOrder+"] Status["+status+"] ***********");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null,pstmtSel = null ; 
		ResultSet rs = null;
		Connection conn = null;
		
		String itemParent = "",itemCode = "",finalItmQtyStr = "",quantity = "",dspDateStr = "",saleOrderTemp = "",tabNum = "";
		
		HashMap<String, String> hm = new HashMap<String, String>();
		Date dspDate = null;
		double discount = 0;
		
		try
		{
			conn = getConnection();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			System.out.println("After");
			
			//Changed by wasim on 08-03-2017
			//if("A".equalsIgnoreCase(status) && saleOrder.length() <= 0)	// Add mode, Purchase order blank
			if("A".equalsIgnoreCase(status))
		    {
		    	sql = " SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ?   ";
				pstmtSel = conn.prepareStatement(sql);
				pstmtSel.setString(1, "A");
				pstmtSel.setString(2, empCode);
				pstmtSel.setString(3, siteCode);		
				rs = pstmtSel.executeQuery();
				
				if(rs.next())
				{
					saleOrderTemp = checkNullAndTrim(rs.getString("SALE_ORDER"));
					
					/*sql = " SELECT I.ITEM_PARNT, P.ITEM_CODE, P.QUANTITY FROM SORDDET_TEMP P, ITEM I WHERE SALE_ORDER = ? " 
						+ " AND I.ITEM_CODE = P.ITEM_CODE ORDER BY I.ITEM_PARNT,  P.ITEM_CODE ";*/
					sql = " SELECT I.ITEM_PARNT, P.ITEM_CODE, P.QUANTITY, P.TAB_NO,P.DSP_DATE,P.DISCOUNT FROM SORDDET_TEMP P, ITEM I WHERE SALE_ORDER = ? " 
							+ " AND I.ITEM_CODE = P.ITEM_CODE ORDER BY I.ITEM_PARNT,  P.ITEM_CODE ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, saleOrderTemp);
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmtSel != null)
				{
					pstmtSel.close();pstmtSel = null;
				}
		    }
			else if("E".equalsIgnoreCase(status) && saleOrder.length() > 0)	// Edit mode, Sales order found
		    {
				/*sql = "SELECT  I.ITEM_PARNT, P.ITEM_CODE, P.QUANTITY  FROM SORDDET P, ITEM I WHERE SALE_ORDER = ? AND " 
					+ "I.ITEM_CODE = P.ITEM_CODE AND P.ITEM_CODE NOT IN (SELECT  PT.ITEM_CODE FROM SORDDET_TEMP PT WHERE SALE_ORDER = ? ) " 
					+ "UNION  " 
					+ "SELECT  I.ITEM_PARNT, PT.ITEM_CODE, PT.QUANTITY FROM SORDDET_TEMP PT, ITEM I WHERE SALE_ORDER = ? " 
					+ "AND I.ITEM_CODE = PT.ITEM_CODE ORDER BY 1, 2 ";*/
				
				//Changed by wasim for adding discount column
				sql = "SELECT  I.ITEM_PARNT, P.ITEM_CODE, P.QUANTITY, P.CUST_SPEC__NO AS TAB_NO,P.DSP_DATE,P.DISCOUNT  FROM SORDDET P, ITEM I WHERE SALE_ORDER = ? AND " 
						+ "I.ITEM_CODE = P.ITEM_CODE AND P.ITEM_CODE NOT IN (SELECT  PT.ITEM_CODE FROM SORDDET_TEMP PT WHERE SALE_ORDER = ? ) " 
						+ "UNION  " 
						+ "SELECT  I.ITEM_PARNT, PT.ITEM_CODE, PT.QUANTITY, PT.TAB_NO, PT.DSP_DATE,PT.DISCOUNT FROM SORDDET_TEMP PT, ITEM I WHERE SALE_ORDER = ? " 
						+ "AND I.ITEM_CODE = PT.ITEM_CODE ORDER BY TAB_NO ";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);
				pstmt.setString(2, saleOrder);
				pstmt.setString(3, saleOrder);
		    }
			
			System.out.println("Sql="+sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemParent = checkNullAndTrim(rs.getString("ITEM_PARNT"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				dspDate = rs.getDate("DSP_DATE");
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				tabNum = checkNullAndTrim(rs.getString("TAB_NO"));
				discount = rs.getDouble("DISCOUNT");
						
				dspDateStr = sdf.format(dspDate).toString();
				
				System.out.println("Final Item Parent with Tab number="+itemParent+":"+tabNum);
				
				itemParent = itemParent+":"+tabNum;
				
				if(hm.containsKey(itemParent))
				{	
					String itemQtyStr = hm.get(itemParent); 
					//hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "~");
					//hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "::" + discount +"~");
					hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "::" + discount + "::" + 0 +"~");
				}
				else
				{
					/*String [] itemParentValue = itemParent.split(":");
					String itemParentMain = itemParentValue[0];
					String itemParentTabNum = itemParentValue[1];*/
					//hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dspDateStr + "****" +itemCode + "::" + quantity + "~"));
					//hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dspDateStr + "****" +itemCode + "::" + quantity + "::" + discount +"~"));
					hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dspDateStr + "****" +itemCode + "::" + quantity + "::" + discount + "::" + 0 + "~"));
				}
				itemParent = "";
				itemCode = "";
				dspDate = null;
				quantity = "";
			}
			if (rs != null) 
			{					
				rs.close();rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();pstmt = null;
			}
			
			 Set<String> setOfKeys = hm.keySet();
			 Iterator<String> iterator = setOfKeys.iterator();
			 finalItmQtyStr = "";
			 while (iterator.hasNext()) 
			 {
				 String key = (String) iterator.next();
				 String value = hm.get(key);
				 finalItmQtyStr = finalItmQtyStr+value.substring(0,value.length()-1)+"||||";
			 }
			 retStr = finalItmQtyStr;
			
		}
		catch(Exception e)
		{
			System.out.println("Inside catch getSorderDetail2"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				if (conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning getSorderDetail2"+retStr);			
		return retStr;
	}
	
	public String validateSorder(String saleOrder) throws RemoteException, ITMException 
	{
		System.out.println("******** Inside validateSorder ***********["+saleOrder+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		boolean isError = false;
		
		int count = 0;
		try
		{		
			conn = getConnection();
			
			sql = " SELECT COUNT(*) FROM SORDER WHERE SALE_ORDER = ? AND CONFIRMED = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, saleOrder);
			pstmt.setString(2, "N");
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				count = rs.getInt(1);
			}
			if (rs != null) 
			{					
				rs.close();rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();pstmt = null;
			}
			retStr = String.valueOf(count);
		}
		catch(Exception e)
		{
			System.out.println("Inside catch validateSorder"+e.getMessage());
			isError = true;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				if (conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning validateSorder"+retStr);			
		return retStr;
	}
	
	public int validateCustomer(String custCode,Connection conn) throws RemoteException, ITMException 
	{
		System.out.println("******** Inside validateCustomer ***********["+custCode+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Connection conn = null;
		
		int count = 0;
		try
		{		
			//conn = getConnection();
			
			sql = " SELECT COUNT(*) FROM CUSTOMER WHERE CUST_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				count = rs.getInt(1);
			}
			if (rs != null) 
			{					
				rs.close();rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();pstmt = null;
			}
			//retStr = String.valueOf(count);
		}
		catch(Exception e)
		{
			System.out.println("Inside catch validateCustomer"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning validateCustomer"+count);			
		return count;
	}
	
	public String getItemRate(String itemCode,String otherDetails,Connection conn) throws ITMException 
	{
		System.out.println("******** Inside getItemRate ***********["+itemCode+"] Other Details["+otherDetails+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Connection conn = null;
		boolean isError = false;
		
		String priceList = "",priceListClg = "",lsPriceList = "";
		double rateClg = 0,lcStdrate = 0;
		
		int count = 0;
		try
		{	
			
			System.out.println("Rate Details"+otherDetails);
			String rateDetails[] = otherDetails.split(":");
			String custCode = rateDetails[0];
			String orderType = rateDetails[1];
			String orderDate = rateDetails[2];
			
			sql = " SELECT  PRICE_LIST,PRICE_LIST__CLG FROM CUST_PLIST WHERE CUST_CODE =? AND ORDER_TYPE =? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			pstmt.setString(2, orderType);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				priceList    = checkNullAndTrim(rs.getString("PRICE_LIST"));
				priceListClg = checkNullAndTrim(rs.getString("PRICE_LIST__CLG"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			lsPriceList = checkNullAndTrim(distCommon.getDisparams("999999", "STD_SO_PL", conn));

			if (lsPriceList.length() > 0)
			{
				lcStdrate = distCommon.pickRate(lsPriceList, orderDate, itemCode,"","L", conn);
			}
			else
			{
				lcStdrate = distCommon.pickRate(priceList, orderDate, itemCode,"","L", conn);
			}
			if( priceListClg.length() > 0 )
			{
				rateClg = distCommon.pickRate( priceListClg, orderDate, itemCode, "", "L", conn );
			}
			System.out.println("Rate Clg="+rateClg);
			if ( rateClg == 0 )
			{
				rateClg = lcStdrate;
			}
			
			System.out.println("Final Item Rate ="+rateClg);
			
			retStr = String.valueOf(rateClg);
			
		}
		catch(Exception e)
		{
			System.out.println("Inside catch getItemRate"+e.getMessage());
			isError = true;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning getItemRate"+retStr);			
		return retStr;
	}
	
	public String ResetHeader(String data) throws ITMException 
	{
		System.out.println("******** Inside ResetHeader ***********["+data+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		boolean isError = false;
		try
		{		
			conn = getConnection();
			
			String[] detail = data.split("~");
			String status = detail[0];
			String empCode = detail[1];
			String siteCode = detail[2];
			
			sql = "UPDATE SORDER_TEMP SET STATUS = ? WHERE  STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "C");				
			pstmt.setString(2, status);		
			pstmt.setString(3, empCode);	
			pstmt.setString(4, siteCode);	
			pstmt.executeUpdate();
			
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside catch ResetHeader"+e.getMessage());
			isError = true;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				if (conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning ResetHeader"+retStr);			
		return retStr;
	}
	
	//public String SaveSorderHeader(String data) throws RemoteException, ITMException 
	public StringBuffer SaveSorderHeader(Document dom1,StringBuffer valueXmlString,Connection conn) throws RemoteException, ITMException 
	{
		System.out.println("******** Inside SaveSorderHeader ***********");
		//System.out.println("******** Data["+data+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null,pstmtSel = null ; 
		ResultSet rs = null,rsSel = null;
		//Connection conn = null;
		
		String dlvDate = "",currApplDate = "";
		java.sql.Timestamp currdate = new java.sql.Timestamp( System.currentTimeMillis() );
		boolean isError = false;
		try
		{		
			//conn = getConnection();
			
			currApplDate = getCurrdateAppFormat();

			//String[] detail = data.split("~");
			
			//~04/10/16~DDUK ~F~ACC~Accessory~0000000001~0000000001~0000000001~TEST~NA~TRAN000043~test~R~NA~GBP~BASE      ~A
			 //var str = saleOrder +"~"+ ordDate +"~"+ siteCode +"~"+ orderType +"~"+ itemSer +"~"+ itemSerDescr +"~"+ custCode +"~"+ custCodeDlv +"~"+
			 //   	 custCodeBil +"~"+ remarks +"~"+ dlvTerm +"~"+ tranCode +"~"+ tranName +"~"+ tranMode +"~"+ currCode +"~"+ empCode +"~"+ status;
			/*String saleOrder = detail[0];
			String orderDate = detail[1];
			String siteCode = detail[2];
			String orderType = detail[3];
			String itemSer = detail[4];
			String itemSerDescr = detail[5];
			String custCode = detail[6];
			String custCodeDlv = detail[7];
			String custCodeBil = detail[8];
			String remarks = detail[9];
			String dlvTerm = detail[10];
			String tranCode = detail[11];
			String tranName = detail[12];
			String tranMode = detail[13];
			String currCode = detail[14];
			String empCode = detail[15];
			String status = detail[16];
			String crTerm = detail[17];
			String random = detail[18];
			String saleOrderTemp = "";*/
			
			String saleOrder 		= checkNullAndTrim(genericUtility.getColumnValue("sale_order", dom1));
			String orderDate 		= checkNullAndTrim(genericUtility.getColumnValue("order_date", dom1));
			String siteCode 		= checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
			String siteCodeDescr 	= checkNullAndTrim(genericUtility.getColumnValue("site_descr", dom1));
			String itemSer	 		= checkNullAndTrim(genericUtility.getColumnValue("item_ser", dom1));
			String itemSerDescr     = checkNullAndTrim(genericUtility.getColumnValue("itemser_descr", dom1));
			String orderType	 	= checkNullAndTrim(genericUtility.getColumnValue("order_type", dom1));
			String custCode			= checkNullAndTrim(genericUtility.getColumnValue("cust_code", dom1));
			String custCodeDlv 	    = checkNullAndTrim(genericUtility.getColumnValue("cust_code__dlv", dom1));
			String custName	        = checkNullAndTrim(genericUtility.getColumnValue("cust_name", dom1));
			String custCodeBil 	    = checkNullAndTrim(genericUtility.getColumnValue("cust_code__bil", dom1));
			String custNameBil 	    = checkNullAndTrim(genericUtility.getColumnValue("cust_name__bil", dom1));
			String remarks		 	= checkNullAndTrim(genericUtility.getColumnValue("remarks", dom1));
			String dlvTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("dlv_term", dom1));
			String crTerm		 	= checkNullAndTrim(genericUtility.getColumnValue("cr_term", dom1));
			String currCode		 	= checkNullAndTrim(genericUtility.getColumnValue("curr_code", dom1));
			String stanCode		 	= checkNullAndTrim(genericUtility.getColumnValue("stan_code", dom1));
			String tranCode		 	= checkNullAndTrim(genericUtility.getColumnValue("tran_code", dom1));
			String transMode		= checkNullAndTrim(genericUtility.getColumnValue("trans_mode", dom1));
			String currCodeFrt		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__frt", dom1));
			String currCodeIns		= checkNullAndTrim(genericUtility.getColumnValue("curr_code__ins", dom1));
			String status			= checkNullAndTrim(genericUtility.getColumnValue("udf__str2", dom1));
			String empCode  		= checkNullAndTrim(genericUtility.getColumnValue("emp_code__ord", dom1));
			String random    		= checkNullAndTrim(genericUtility.getColumnValue("udf__num2", dom1));
			String dlvAdd1    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add1", dom1));
			String dlvAdd2    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_add2", dom1));
			String dlvCity    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_city", dom1));
			String dlvPin    		= checkNullAndTrim(genericUtility.getColumnValue("dlv_pin", dom1));
			String stateCode    	= checkNullAndTrim(genericUtility.getColumnValue("state_code__dlv", dom1));
			String countCode    	= checkNullAndTrim(genericUtility.getColumnValue("count_code__dlv", dom1));
			
			String custNameDlv    	= checkNullAndTrim(genericUtility.getColumnValue("dlv_to", dom1));
			String dlvAdd3    	    = checkNullAndTrim(genericUtility.getColumnValue("dlv_add3", dom1));
			String tel1Dlv       	= checkNullAndTrim(genericUtility.getColumnValue("tel1__dlv", dom1));
			String tel2Dlv       	= checkNullAndTrim(genericUtility.getColumnValue("tel2__dlv", dom1));
			String partQty      	= checkNullAndTrim(genericUtility.getColumnValue("part_qty", dom1));
			String dueDate      	= checkNullAndTrim(genericUtility.getColumnValue("due_date", dom1));
			
			String orderTypeDescr   = checkNullAndTrim(genericUtility.getColumnValue("sordertype_descr", dom1));
			String dlvTermDescr     = checkNullAndTrim(genericUtility.getColumnValue("delivery_term_descr", dom1));
			String applDateFormat   = checkNullAndTrim(genericUtility.getColumnValue("udf__str1", dom1));
			
			String priceList   = checkNullAndTrim(genericUtility.getColumnValue("price_list", dom1));
			String priceListClg   = checkNullAndTrim(genericUtility.getColumnValue("price_list__clg", dom1));
			String taxChap   = checkNullAndTrim(genericUtility.getColumnValue("tax_chap", dom1));
			String taxClass   = checkNullAndTrim(genericUtility.getColumnValue("tax_class", dom1));

			System.out.println("Due Date recived="+dueDate);
			
			String dueDate1 = genericUtility.getValidDateTimeString(
					checkNullAndTrim(dueDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			
			String saleOrderTemp = "";
			
			System.out.println("@@Status["+status+"]");
			
			if("A".equalsIgnoreCase(status))
			{
				sql = " SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
				pstmtSel = conn.prepareStatement(sql);
				pstmtSel.setString(1, status);
				pstmtSel.setString(2, empCode);
				pstmtSel.setString(3, siteCode);		
			}
			else if("E".equalsIgnoreCase(status))
			{
				//sql = " SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? AND SALE_ORDER = ? ";
				sql = " SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS in (?,?) AND EMP_CODE = ? AND SITE_CODE = ? AND SALE_ORDER = ? ";
				pstmtSel = conn.prepareStatement(sql);
				pstmtSel.setString(1, status);
				pstmtSel.setString(2, "O");
				pstmtSel.setString(3, empCode);
				pstmtSel.setString(4, siteCode);
				pstmtSel.setString(5, saleOrder);
			}
			
			System.out.println("Sql is="+sql);
			rsSel = pstmtSel.executeQuery();
			if( rsSel.next() )
			{	
				saleOrderTemp = checkNullAndTrim(rsSel.getString("SALE_ORDER"));
			}
			if(rsSel != null)
			{
				rsSel.close();rsSel = null;
			}
			if(pstmtSel != null)
			{
				pstmtSel.close();pstmtSel = null;
			}
			
			if(saleOrder.length() <= 0 && saleOrderTemp.length() > 0)	// Add mode old record
			{
				saleOrder = saleOrderTemp;
			}
			else if(saleOrder.length() <= 0 && saleOrderTemp.length() <= 0)	// Add mode new record
			{
				saleOrder = generateTranTd("w_sorderTemp",currApplDate,siteCode,conn);
			}
			System.out.println("-----Final Sale Order------" + saleOrder);
			
			if(saleOrderTemp.length() > 0)		// sale order found blank and Status = "A"  ADD 
			{
				System.out.println("UPDATE PORDER_TEMP ======>>"+saleOrder);

				sql = " UPDATE SORDER_TEMP SET TRAN_DATE = ?, ORDER_TYPE = ?, ITEM_SER = ?, CUST_CODE = ?,CUST_CODE__DLV = ? ,CUST_CODE__BIL = ?, " //6
				+ " REMARKS = ?, DLV_TERM = ?, CURR_CODE = ?, STATUS = ?,CR_TERM = ?,UDF__NUM2 = ?, " //12
				+ " DLV_ADD1 = ? , DLV_ADD2 = ?, DLV_CITY = ? , DLV_PIN = ? , STATE_CODE__DLV = ?, COUNT_CODE__DLV = ?,STAN_CODE = ?,SITE_CODE = ?," //20
				+ " DLV_ADD3 = ?, TEL1__DLV = ?,TEL2__DLV = ?, PART_QTY = ?,TRAN_CODE = ?, TRANS_MODE = ?, DUE_DATE = ?, " //24
				+ " PRICE_LIST = ?,PRICE_LIST__CLG = ? "
				+ " WHERE SALE_ORDER = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, currdate);	
				pstmt.setString(2, orderType);		
				pstmt.setString(3, itemSer);		
				pstmt.setString(4, custCode);
				pstmt.setString(5, custCodeDlv);	
				pstmt.setString(6, custCodeBil);	
				pstmt.setString(7, remarks);	
				pstmt.setString(8, dlvTerm);
				pstmt.setString(9, currCode);
				pstmt.setString(10, status);
				pstmt.setString(11, crTerm);
				pstmt.setString(12, random);
				pstmt.setString(13, dlvAdd1);
				pstmt.setString(14, dlvAdd2);
				pstmt.setString(15, dlvCity);
				pstmt.setString(16, dlvPin);
				pstmt.setString(17, stateCode);
				pstmt.setString(18, countCode);
				pstmt.setString(19, stanCode);
				pstmt.setString(20, siteCode);
				pstmt.setString(21, dlvAdd3);
				pstmt.setString(22, tel1Dlv);
				pstmt.setString(23, tel2Dlv);
				pstmt.setString(24, partQty);
				pstmt.setString(25, tranCode);
				pstmt.setString(26, transMode);
				pstmt.setTimestamp(27, java.sql.Timestamp.valueOf(dueDate1));
				pstmt.setString(28, priceList);
				pstmt.setString(29, priceListClg);
				pstmt.setString(30, saleOrder);
				pstmt.setString(31, empCode);
				pstmt.setString(32, siteCode);
				
				pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			else if(saleOrderTemp.length() <= 0)	
			{	
				String orddate = genericUtility.getValidDateTimeString(
					checkNullAndTrim(orderDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				
				System.out.println("@@Due Date["+dueDate1+"]");

				sql = " INSERT INTO SORDER_TEMP(SALE_ORDER, ORDER_DATE, TRAN_DATE, ORDER_TYPE, ITEM_SER, CUST_CODE, " //6
					+ " DLV_TERM, REMARKS, SITE_CODE, CURR_CODE, EMP_CODE, " //11
					+ " STATUS, CUST_CODE__DLV,CUST_CODE__BIL,CR_TERM,UDF__NUM2, " //16
					+ " DLV_ADD1, DLV_ADD2, DLV_CITY, DLV_PIN, STATE_CODE__DLV, COUNT_CODE__DLV,STAN_CODE," //23
					+ " DLV_ADD3, TEL1__DLV, TEL2__DLV, PART_QTY, TRAN_CODE, TRANS_MODE, DUE_DATE, " //29
					+ " PRICE_LIST, PRICE_LIST__CLG )" //29
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				
				pstmt.setString(1, saleOrder);		
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(orddate));		
				pstmt.setTimestamp(3, currdate);	
				pstmt.setString(4, orderType);		
				pstmt.setString(5, itemSer);		
				pstmt.setString(6, custCode);		
				pstmt.setString(7, dlvTerm);		
				pstmt.setString(8, remarks);		
				pstmt.setString(9, siteCode);		
				pstmt.setString(10, currCode);		
				pstmt.setString(11, empCode);	
				pstmt.setString(12, status);	
				pstmt.setString(13, custCodeDlv);	
				pstmt.setString(14, custCodeBil);	
				pstmt.setString(15, crTerm);
				pstmt.setString(16, random);
				pstmt.setString(17, dlvAdd1);
				pstmt.setString(18, dlvAdd2);
				pstmt.setString(19, dlvCity);
				pstmt.setString(20, dlvPin);
				pstmt.setString(21, stateCode);
				pstmt.setString(22, countCode);
				pstmt.setString(23, stanCode);
				pstmt.setString(24, dlvAdd3);
				pstmt.setString(25, tel1Dlv);
				pstmt.setString(26, tel2Dlv);
				pstmt.setString(27, partQty);
				pstmt.setString(28, tranCode);
				pstmt.setString(29, transMode);
				pstmt.setTimestamp(30, java.sql.Timestamp.valueOf(dueDate1));
				pstmt.setString(31, priceList);
				pstmt.setString(32, priceListClg);
				
				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			int domID = 0;
			
			valueXmlString.append("<Detail2 domID = '"+domID+"' selected = 'N'>\r\n");
			
			if("A".equalsIgnoreCase(status))
			{
				//valueXmlString.append("<sale_order>").append("<![CDATA[]]>").append("</sale_order>\r\n");
				valueXmlString.append("<sale_order>").append("<![CDATA["+saleOrder+"]]>").append("</sale_order>\r\n");
			}
			else
			{
				valueXmlString.append("<sale_order>").append("<![CDATA["+saleOrder+"]]>").append("</sale_order>\r\n");
			}
			valueXmlString.append("<order_date>").append("<![CDATA["+ orderDate +"]]>").append("</order_date>\r\n");
			valueXmlString.append("<site_code>").append("<![CDATA["+ siteCode +"]]>").append("</site_code>\r\n");
			valueXmlString.append("<site_descr>").append("<![CDATA["+ siteCodeDescr +"]]>").append("</site_descr>\r\n");
			valueXmlString.append("<item_ser>").append("<![CDATA["+ itemSer +"]]>").append("</item_ser>\r\n");
			valueXmlString.append("<itemser_descr>").append("<![CDATA["+ itemSerDescr +"]]>").append("</itemser_descr>\r\n");
			valueXmlString.append("<order_type>").append("<![CDATA["+ orderType +"]]>").append("</order_type>\r\n");
			valueXmlString.append("<cust_code>").append("<![CDATA["+ custCode +"]]>").append("</cust_code>\r\n");
			valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+ custCodeDlv +"]]>").append("</cust_code__dlv>\r\n");
			valueXmlString.append("<cust_name>").append("<![CDATA["+ custName +"]]>").append("</cust_name>\r\n");
			valueXmlString.append("<cust_code__bil>").append("<![CDATA["+ custCodeBil +"]]>").append("</cust_code__bil>\r\n");
			valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBil+"]]>").append("</cust_name__bil>\r\n");
			valueXmlString.append("<remarks>").append("<![CDATA["+ remarks +"]]>").append("</remarks>\r\n");
			valueXmlString.append("<dlv_term>").append("<![CDATA["+ dlvTerm +"]]>").append("</dlv_term>\r\n");
			valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
			valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
			valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
			valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
			valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
			valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
			valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
			valueXmlString.append("<udf__str2>").append("<![CDATA["+status+"]]>").append("</udf__str2>\r\n");
			valueXmlString.append("<emp_code__ord>").append("<![CDATA["+empCode+"]]>").append("</emp_code__ord>\r\n");
			valueXmlString.append("<udf__num2>").append("<![CDATA["+random+"]]>").append("</udf__num2>\r\n");
			valueXmlString.append("<dlv_add1>").append("<![CDATA["+dlvAdd1+"]]>").append("</dlv_add1>\r\n");
			valueXmlString.append("<dlv_add2>").append("<![CDATA["+dlvAdd2+"]]>").append("</dlv_add2>\r\n");
			valueXmlString.append("<dlv_city>").append("<![CDATA["+dlvCity+"]]>").append("</dlv_city>\r\n");
			valueXmlString.append("<dlv_pin>").append("<![CDATA["+dlvPin+"]]>").append("</dlv_pin>\r\n");
			valueXmlString.append("<state_code__dlv>").append("<![CDATA["+stateCode+"]]>").append("</state_code__dlv>\r\n");
			valueXmlString.append("<count_code__dlv>").append("<![CDATA["+countCode+"]]>").append("</count_code__dlv>\r\n");
			valueXmlString.append("<dlv_to>").append("<![CDATA["+custNameDlv+"]]>").append("</dlv_to>\r\n");
			valueXmlString.append("<dlv_add3>").append("<![CDATA["+dlvAdd3+"]]>").append("</dlv_add3>\r\n");
			valueXmlString.append("<tel1__dlv>").append("<![CDATA["+tel1Dlv+"]]>").append("</tel1__dlv>\r\n");
			valueXmlString.append("<tel2__dlv>").append("<![CDATA["+tel2Dlv+"]]>").append("</tel2__dlv>\r\n");
			valueXmlString.append("<part_qty>").append("<![CDATA["+partQty+"]]>").append("</part_qty>\r\n");
			valueXmlString.append("<due_date>").append("<![CDATA["+dueDate+"]]>").append("</due_date>\r\n");
			
			valueXmlString.append("<sordertype_descr>").append("<![CDATA["+orderTypeDescr+"]]>").append("</sordertype_descr>\r\n");
			valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
			valueXmlString.append("<udf__str1>").append("<![CDATA["+ checkNullAndTrim(applDateFormat) +"]]>").append("</udf__str1>\r\n");
			
			valueXmlString.append("<price_list>").append("<![CDATA["+ priceList +"]]>").append("</price_list>\r\n");
			valueXmlString.append("<price_list__clg>").append("<![CDATA["+ priceListClg +"]]>").append("</price_list__clg>\r\n");
			valueXmlString.append("<tax_chap>").append("<![CDATA["+ taxChap +"]]>").append("</tax_chap>\r\n");
			valueXmlString.append("<tax_class>").append("<![CDATA["+ taxClass +"]]>").append("</tax_class>\r\n");
			
			valueXmlString.append("</Detail2>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Inside catch SaveSorderHeader "+e.getMessage());
			isError = true;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				/*if (conn != null)
				{
					conn.close();conn = null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("Returning SaveSorderHeader"+retStr);			
		return valueXmlString;
	}
	
	public String SaveSorderDetail(String data) throws ITMException 
	{
		System.out.println("******** Inside SaveSorderDetail ********** ["+data+"]");
		
		String sql = "",retStr = "";
		PreparedStatement pstmt = null,pstmtSel = null ; 
		ResultSet rs = null,rsSel = null;
		Connection conn = null;
		
		String dlvDate = "";
		boolean isError = false;
		try
		{
			conn = getConnection();
			
			String[] detail = data.split("~");
			
			String status = checkNullAndTrim(detail[0]);
			String siteCode = checkNullAndTrim(detail[1]);
			String itemCode = checkNullAndTrim(detail[2]);
			String quantity = checkNullAndTrim(detail[3]);
			String empCode = checkNullAndTrim(detail[4]);
			String tabNum = checkNullAndTrim(detail[6]);
			
		
			String saleOrderHdr = "";
			
			System.out.println("Status["+status+"]");
			
			if("A".equalsIgnoreCase(status))		// Status
			{
				sql = " SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
				pstmtSel = conn.prepareStatement(sql);
				pstmtSel.setString(1, status);		 //Status
				pstmtSel.setString(2, empCode);		 // Emp_Code
				pstmtSel.setString(3, siteCode);		// order_site/SITE_CODE__ORD
				rsSel = pstmtSel.executeQuery();
				if(rsSel.next())
				{
					saleOrderHdr = rsSel.getString("SALE_ORDER");
				}
				if(rsSel != null)
				{
					rsSel.close();rsSel = null;
				}
				if(pstmtSel != null)
				{
					pstmtSel.close();pstmtSel = null;
				}
			}
			else
			{
				saleOrderHdr = checkNullAndTrim(detail[5]);
			}
			
			System.out.println("Sale Order from Temp ["+saleOrderHdr+"]");
			
			
			if("DELETE".equalsIgnoreCase(quantity)) //Deleting accordian
			{
				//sql = " DELETE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ?) ";
				sql = " DELETE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ?) AND TAB_NO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrderHdr);
				pstmt.setString(2, itemCode);
				pstmt.setString(3, tabNum);
				int upd = pstmt.executeUpdate();
				System.out.println("Deleted Items="+upd);
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				return "";
			}
			
			if("UPDATE_DSP_DATE".equalsIgnoreCase(quantity)) //updating dsp date
			{
				
				String prdCode = "",statSal = "";
				int count = 0;
				
				String dspDate = checkNullAndTrim(detail[7]);
				String ordDate = checkNullAndTrim(detail[8]);
				
				String dspDateStr = genericUtility.getValidDateTimeString(
				   checkNullAndTrim(dspDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				
				String appDateFormat = genericUtility.getApplDateFormat();
					    	
		    	java.util.Date morderDate = getDateInForamt( ordDate, appDateFormat );
		    	java.util.Date mdueDate = getDateInForamt( dspDate, appDateFormat );
		    	
		    	System.out.println("@@mdueDate["+mdueDate+"]  and morderDate["+morderDate+"]");
				if( mdueDate.compareTo( morderDate ) < 0 )
				{
					System.out.println("Inside");
					return "VTDUEDT";
				}					
				
				System.out.println("After");
				
				/*sql = " SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(dspDateStr));
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					prdCode = checkNullAndTrim(rs.getString("CODE"));
					count++;
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				if(count == 0)
				{
					return "VTORDTINV";
				}
				
				sql = " SELECT STAT_SAL FROM PERIOD_STAT WHERE PRD_CODE = ? AND SITE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, prdCode);
				pstmt.setString(2, siteCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					statSal = checkNullAndTrim(rs.getString("STAT_SAL"));
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				System.out.println("Acct Sal["+statSal+"]");
				
				if("N".equalsIgnoreCase(statSal))
				{
					return "VTPRDSAL";
				}*/
				
				
				//String dspDate = checkNullAndTrim(detail[7]);
				//String dspDateStr = genericUtility.getValidDateTimeString(
						//checkNullAndTrim(dspDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				
				sql = "UPDATE SORDDET_TEMP SET DSP_DATE = ? WHERE SALE_ORDER = ? AND TAB_NO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(dspDateStr));
				pstmt.setString(2, saleOrderHdr);
				pstmt.setString(3, tabNum);
				int upd = pstmt.executeUpdate();
				System.out.println("Deleted Items="+upd);
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
				return "";
			}
			
			//if(!("").equalsIgnoreCase(quantity) && Integer.parseInt(quantity) > 0)
			if(!("").equalsIgnoreCase(quantity) && Double.parseDouble(quantity) > 0)			
			{
				String discount = checkNullAndTrim(detail[8]);
				
				//sql = "SELECT ITEM_CODE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE = ? ";
				sql = "SELECT ITEM_CODE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ?";
				pstmtSel = conn.prepareStatement(sql);
				pstmtSel.setString(1, saleOrderHdr);			// SALE_ORDER
				pstmtSel.setString(2, itemCode);				// ITEM_CODE
				pstmtSel.setString(3, tabNum);	
				rsSel = pstmtSel.executeQuery();
				if( rsSel.next() )
				{
					//sql = "UPDATE SORDDET_TEMP SET QUANTITY = ? WHERE SALE_ORDER = ? AND ITEM_CODE = ? ";
					//sql = "UPDATE SORDDET_TEMP SET QUANTITY = ? WHERE SALE_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ?";
					sql = "UPDATE SORDDET_TEMP SET QUANTITY = ?,DISCOUNT = ? WHERE SALE_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, quantity);				// QUANTITY	
					pstmt.setDouble(2, Double.parseDouble(discount));    //DISCOUNT
					pstmt.setString(3, saleOrderHdr);		// PURC_ORDER
					pstmt.setString(4, itemCode);				// ITEM_CODE
					pstmt.setString(5, tabNum);				// ITEM_CODE
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
				}
				else
				{
					String dspDate = checkNullAndTrim(detail[7]);
					String dspDateStr = genericUtility.getValidDateTimeString(
							checkNullAndTrim(dspDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
					
					System.out.println("Desp Date="+dspDateStr);

					/*sql = "INSERT INTO SORDDET_TEMP (SALE_ORDER, SITE_CODE, ITEM_CODE, QUANTITY) " 
							+ " VALUES(?,?,?,?)";*/
					sql = "INSERT INTO SORDDET_TEMP (SALE_ORDER, SITE_CODE, ITEM_CODE, QUANTITY, TAB_NO, DSP_DATE, DISCOUNT) " 
							+ " VALUES(?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, saleOrderHdr);	// SALE_ORDER
					pstmt.setString(2, siteCode);			// SITE_CODE
					pstmt.setString(3, itemCode);			// ITEM_CODE
					pstmt.setString(4, quantity);			// QUANTITY	
					pstmt.setString(5, tabNum);
					pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(dspDateStr));
					pstmt.setDouble(7, Double.parseDouble(discount));
					pstmt.executeUpdate();
					
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
				}
				if(rsSel != null)
				{
					rsSel.close();rsSel = null;
				}
				if(pstmtSel != null)
				{
					pstmtSel.close();pstmtSel = null;
				}
			}
			//else if(("").equalsIgnoreCase(quantity) || Integer.parseInt(quantity) <= 0)	// if Quantity is zero
			else if(("").equalsIgnoreCase(quantity) || Double.parseDouble(quantity) <= 0)	// if Quantity is zero
			{
				//sql = " DELETE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE = ? ";
				sql = " DELETE FROM SORDDET_TEMP WHERE SALE_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrderHdr);		// PURC_ORDER
				pstmt.setString(2, itemCode);				// ITEM_CODE
				pstmt.setString(3, tabNum);
				pstmt.executeUpdate();
				
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Inside catch SaveSorderDetail"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if (rs != null)
				{
					rs.close();rs = null;
				}
				if (conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("Returning SaveSorderDetail"+retStr);			
		return retStr;
	}
	
	
	public String getSorderHeader(String saleOrder, String flag) throws ITMException 
	{
		System.out.println("--------- Inside getSorderHeader Sale Order["+saleOrder+"] Flag["+flag+"]----------");
		
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		Timestamp orderDate = null,dueDate = null;
		String sql = "",siteCode = "",orderType = "",custCode = "",custName = "",crTerm = "",currCode = "",stanCode = "",tranCode = "",transMode = "",currCodeFrt = "",
				custCodeDlv = "",custCodeBil = "",custNameBil = "",itemSer = "",itemSerDescr = "",remarks = "",dlvTerm = "",status = "",empCode = "",
				random = "",currCodeIns = "",siteCodeDescr = "",
				dlvAdd1 = "",dlvAdd2 = "",city = "",pin = "",stateCodeDlv = "",countCodeDlv = "",dlvAdd3 = "",tel1Dlv = "",tel2Dlv = "",partQty = "",
				custNameDlv = "",orderTypeDescr = "", dlvTermDescr = "",priceList = "",priceListClg = "",taxClass = "",taxChap = "";	
		
		int count = 0;
		
		String retString = "";
		
		try 
		{
			conn = getConnection();
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			//sql = " SELECT COUNT(*) FROM SORDER WHERE SALE_ORDER = ? AND CONFIRMED = ? ";
			String confirmed = "";
			sql = " SELECT CONFIRMED FROM SORDER WHERE SALE_ORDER = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, saleOrder);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
				count++;
			}
			if (rs != null) 
			{					
				rs.close();rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();pstmt = null;
			}
			
			if("Y".equalsIgnoreCase(confirmed))
			{
				return "1";
			}
			if(count == 0)
			{
				retString = String.valueOf(count);
				return retString;
			}
			else //else sale order is present
			{
				count = 0;
				sql = " SELECT COUNT(1) FROM SORDER_TEMP WHERE SALE_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					count = rs.getInt(1);
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				System.out.println("Count SorderTemp="+count);
				
				if(count > 0)	// Check in temporary table
				{
					sql = " SELECT * FROM SORDER_TEMP WHERE SALE_ORDER = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, saleOrder);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						 saleOrder  = checkNullAndTrim(rs.getString("SALE_ORDER"));
						 orderDate  = rs.getTimestamp("ORDER_DATE");
						 siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));
						 itemSer  = checkNullAndTrim(rs.getString("ITEM_SER"));
						 orderType  = checkNullAndTrim(rs.getString("ORDER_TYPE"));
						 custCode  = checkNullAndTrim(rs.getString("CUST_CODE"));
						 custCodeDlv  = checkNullAndTrim(rs.getString("CUST_CODE__DLV"));
						 custCodeBil  = checkNullAndTrim(rs.getString("CUST_CODE__BIL"));
						 remarks  = checkNullAndTrim(rs.getString("REMARKS"));
						 dlvTerm  = checkNullAndTrim(rs.getString("DLV_TERM"));
						 crTerm  = checkNullAndTrim(rs.getString("CR_TERM"));
						 currCode  = checkNullAndTrim(rs.getString("CURR_CODE"));
						 tranCode  = checkNullAndTrim(rs.getString("TRAN_CODE"));
						 transMode  = checkNullAndTrim(rs.getString("TRANS_MODE"));
						 status  = checkNullAndTrim(rs.getString("STATUS"));
						 empCode  = checkNullAndTrim(rs.getString("EMP_CODE"));
						 random  = checkNullAndTrim(rs.getString("UDF__NUM2"));
						 stanCode  = checkNullAndTrim(rs.getString("STAN_CODE"));
						 dlvAdd1  = checkNullAndTrim(rs.getString("DLV_ADD1"));
						 dlvAdd2  = checkNullAndTrim(rs.getString("DLV_ADD2"));
						 city  = checkNullAndTrim(rs.getString("DLV_CITY"));
						 pin  = checkNullAndTrim(rs.getString("DLV_PIN"));
						 stateCodeDlv  = checkNullAndTrim(rs.getString("STATE_CODE__DLV"));
						 countCodeDlv  = checkNullAndTrim(rs.getString("COUNT_CODE__DLV"));
						 dlvAdd3  = checkNullAndTrim(rs.getString("DLV_ADD3"));
						 tel1Dlv  = checkNullAndTrim(rs.getString("TEL1__DLV"));
						 tel2Dlv  = checkNullAndTrim(rs.getString("TEL2__DLV"));
						 partQty  = checkNullAndTrim(rs.getString("PART_QTY"));
						 dueDate  = rs.getTimestamp("DUE_DATE");
						 
						 priceList  = checkNullAndTrim(rs.getString("PRICE_LIST"));
						 priceListClg  = checkNullAndTrim(rs.getString("PRICE_LIST__CLG"));
					}
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
					
					sql = " SELECT CUST_NAME,STAN_CODE,TRAN_CODE,TRANS_MODE,CURR_CODE__FRT,CURR_CODE__INS,TAX_CLASS,TAX_CHAP FROM CUSTOMER WHERE CUST_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, custCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						custName = checkNullAndTrim(rs.getString("CUST_NAME"));
						/*stanCode = checkNullAndTrim(rs.getString("STAN_CODE"));*/
						/*tranCode = checkNullAndTrim(rs.getString("TRAN_CODE"));
						transMode = checkNullAndTrim(rs.getString("TRANS_MODE"));*/
						currCodeFrt = checkNullAndTrim(rs.getString("CURR_CODE__FRT"));
						currCodeIns = checkNullAndTrim(rs.getString("CURR_CODE__FRT"));
						
						taxClass = checkNullAndTrim(rs.getString("TAX_CLASS"));
						taxChap = checkNullAndTrim(rs.getString("TAX_CHAP"));
					}
					if(rs != null)
					{
						rs.close();rs = null;
					}	
					if(pstmt != null)
					{	
						pstmt.close();pstmt = null;
					}
				}
				else //Check in main table
				{
					sql = " SELECT S.SALE_ORDER, S.ORDER_DATE, S.SITE_CODE, S.ITEM_SER, S.ORDER_TYPE, S.CUST_CODE, S.CUST_CODE__DLV, S.CUST_CODE__BIL,S.REMARKS,S.DLV_TERM , " 
						+ " S.CR_TERM, S.CURR_CODE , S.STAN_CODE , S.TRAN_CODE , S.TRANS_MODE , S.UDF__STR2 , S.EMP_CODE__ORD ,"
						+ " S.UDF__NUM2, S.CURR_CODE__FRT, S.CURR_CODE__INS, C.CUST_NAME,"
						+ " S.DLV_ADD1,S.DLV_ADD2,S.DLV_CITY,S.DLV_PIN,S.STATE_CODE__DLV,S.COUNT_CODE__DLV, S.DUE_DATE,"
						+ " S.DLV_ADD3, S.TEL1__DLV,S.TEL2__DLV, S.PART_QTY "
						+ " FROM SORDER S, CUSTOMER C "
						+ " WHERE S.SALE_ORDER = ? AND S.CONFIRMED = ? AND S.CUST_CODE = C.CUST_CODE ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, saleOrder);
					pstmt.setString(2, "N");
					
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						 saleOrder  = checkNullAndTrim(rs.getString("SALE_ORDER"));
						 orderDate  = rs.getTimestamp("ORDER_DATE");
						 siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));
						 itemSer  = checkNullAndTrim(rs.getString("ITEM_SER"));
						 orderType  = checkNullAndTrim(rs.getString("ORDER_TYPE"));
						 custCode  = checkNullAndTrim(rs.getString("CUST_CODE"));
						 custCodeDlv  = checkNullAndTrim(rs.getString("CUST_CODE__DLV"));
						 custCodeBil  = checkNullAndTrim(rs.getString("CUST_CODE__BIL"));
						 remarks  = checkNullAndTrim(rs.getString("REMARKS"));
						 dlvTerm  = checkNullAndTrim(rs.getString("DLV_TERM"));
						 crTerm  = checkNullAndTrim(rs.getString("CR_TERM"));
						 currCode  = checkNullAndTrim(rs.getString("CURR_CODE"));
						 stanCode  = checkNullAndTrim(rs.getString("STAN_CODE"));
						 tranCode  = checkNullAndTrim(rs.getString("TRAN_CODE"));
						 transMode  = checkNullAndTrim(rs.getString("TRANS_MODE"));
						 status  = checkNullAndTrim(rs.getString("UDF__STR2"));
						 empCode  = checkNullAndTrim(rs.getString("EMP_CODE__ORD"));
						 random  = checkNullAndTrim(rs.getString("UDF__NUM2"));
						 currCodeFrt = checkNullAndTrim(rs.getString("CURR_CODE__FRT"));
						 currCodeIns = checkNullAndTrim(rs.getString("CURR_CODE__INS"));
						 custName = checkNullAndTrim(rs.getString("CUST_NAME"));
						 dlvAdd1  = checkNullAndTrim(rs.getString("DLV_ADD1"));
						 dlvAdd2  = checkNullAndTrim(rs.getString("DLV_ADD2"));
						 city  = checkNullAndTrim(rs.getString("DLV_CITY"));
						 pin  = checkNullAndTrim(rs.getString("DLV_PIN"));
						 stateCodeDlv  = checkNullAndTrim(rs.getString("STATE_CODE__DLV"));
						 countCodeDlv  = checkNullAndTrim(rs.getString("COUNT_CODE__DLV"));
						 dlvAdd3  = checkNullAndTrim(rs.getString("DLV_ADD3"));
						 tel1Dlv  = checkNullAndTrim(rs.getString("TEL1__DLV"));
						 tel2Dlv  = checkNullAndTrim(rs.getString("TEL2__DLV"));
						 partQty  = checkNullAndTrim(rs.getString("PART_QTY"));
						 dueDate  = rs.getTimestamp("DUE_DATE");
					}
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
				}
				
				sql = " SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					siteCodeDescr = checkNullAndTrim(rs.getString("DESCR"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE = ? "; //for customer name bill
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, custCodeBil);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					custNameBil = checkNullAndTrim(rs.getString("CUST_NAME"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE = ? "; //for customer name dlv
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, custCodeDlv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					custNameDlv = checkNullAndTrim(rs.getString("CUST_NAME"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT DESCR FROM ITEMSER WHERE ITEM_SER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemSer);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemSerDescr = checkNullAndTrim(rs.getString("DESCR"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT DESCR FROM SORDERTYPE WHERE ORDER_TYPE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, orderType);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					orderTypeDescr = checkNullAndTrim(rs.getString("DESCR"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " SELECT DESCR FROM DELIVERY_TERM WHERE DLV_TERM = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, dlvTerm);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					dlvTermDescr = checkNullAndTrim(rs.getString("DESCR"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				
				valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
					valueXmlString.append("<flag>").append("<![CDATA["+flag+"]]>").append("</flag>\r\n");
					valueXmlString.append("<sale_order>").append("<![CDATA["+saleOrder+"]]>").append("</sale_order>\r\n");
					valueXmlString.append("<order_date>").append("<![CDATA["+sdf.format(orderDate)+"]]>").append("</order_date>\r\n");
					valueXmlString.append("<site_code>").append("<![CDATA["+siteCode+"]]>").append("</site_code>\r\n");
					valueXmlString.append("<site_descr>").append("<![CDATA["+siteCodeDescr+"]]>").append("</site_descr>\r\n");
					valueXmlString.append("<item_ser>").append("<![CDATA["+itemSer+"]]>").append("</item_ser>\r\n");
					valueXmlString.append("<itemser_descr>").append("<![CDATA["+itemSerDescr+"]]>").append("</itemser_descr>\r\n");
					valueXmlString.append("<order_type>").append("<![CDATA["+orderType+"]]>").append("</order_type>\r\n");
					valueXmlString.append("<sordertype_descr>").append("<![CDATA["+orderTypeDescr+"]]>").append("</sordertype_descr>\r\n");
					valueXmlString.append("<cust_code>").append("<![CDATA["+custCode+"]]>").append("</cust_code>\r\n");
					valueXmlString.append("<cust_code__dlv>").append("<![CDATA["+custCodeDlv+"]]>").append("</cust_code__dlv>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA["+custName+"]]>").append("</cust_name>\r\n");
					valueXmlString.append("<cust_code__bil>").append("<![CDATA["+custCodeBil+"]]>").append("</cust_code__bil>\r\n");
					valueXmlString.append("<cust_name__bil>").append("<![CDATA["+custNameBil+"]]>").append("</cust_name__bil>\r\n");
					valueXmlString.append("<remarks>").append("<![CDATA["+remarks+"]]>").append("</remarks>\r\n");
					valueXmlString.append("<dlv_term>").append("<![CDATA["+dlvTerm+"]]>").append("</dlv_term>\r\n");
					valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
					valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");
					valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");
					valueXmlString.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
					valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");
					valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
					valueXmlString.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
					valueXmlString.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
					valueXmlString.append("<udf__str2>").append("<![CDATA["+status+"]]>").append("</udf__str2>\r\n");
					valueXmlString.append("<emp_code__ord>").append("<![CDATA["+empCode+"]]>").append("</emp_code__ord>\r\n");
					valueXmlString.append("<udf__num2>").append("<![CDATA["+random+"]]>").append("</udf__num2>\r\n");
					valueXmlString.append("<dlv_add1>").append("<![CDATA["+dlvAdd1+"]]>").append("</dlv_add1>\r\n");
					valueXmlString.append("<dlv_add2>").append("<![CDATA["+dlvAdd2+"]]>").append("</dlv_add2>\r\n");
					valueXmlString.append("<dlv_city>").append("<![CDATA["+city+"]]>").append("</dlv_city>\r\n");
					valueXmlString.append("<dlv_pin>").append("<![CDATA["+pin+"]]>").append("</dlv_pin>\r\n");
					valueXmlString.append("<state_code__dlv>").append("<![CDATA["+stateCodeDlv+"]]>").append("</state_code__dlv>\r\n");
					valueXmlString.append("<count_code__dlv>").append("<![CDATA["+countCodeDlv+"]]>").append("</count_code__dlv>\r\n");
					valueXmlString.append("<dlv_to>").append("<![CDATA["+custNameDlv+"]]>").append("</dlv_to>\r\n");
					valueXmlString.append("<dlv_add3>").append("<![CDATA["+dlvAdd3+"]]>").append("</dlv_add3>\r\n");
					valueXmlString.append("<tel1__dlv>").append("<![CDATA["+tel1Dlv+"]]>").append("</tel1__dlv>\r\n");
					valueXmlString.append("<tel2__dlv>").append("<![CDATA["+tel2Dlv+"]]>").append("</tel2__dlv>\r\n");
					valueXmlString.append("<part_qty>").append("<![CDATA["+partQty+"]]>").append("</part_qty>\r\n");
					
					if(dueDate == null)
					{	
						valueXmlString.append("<due_date>").append("<![CDATA["+sdf.format(orderDate)+"]]>").append("</due_date>\r\n");
					}
					else
					{
						valueXmlString.append("<due_date>").append("<![CDATA["+sdf.format(dueDate)+"]]>").append("</due_date>\r\n");
					}
					
					valueXmlString.append("<price_list>").append("<![CDATA["+priceList+"]]>").append("</price_list>\r\n");
					valueXmlString.append("<price_list__clg>").append("<![CDATA["+priceListClg+"]]>").append("</price_list__clg>\r\n");
					valueXmlString.append("<tax_class>").append("<![CDATA["+taxClass+"]]>").append("</tax_class>\r\n");
					valueXmlString.append("<tax_chap>").append("<![CDATA["+taxChap+"]]>").append("</tax_chap>\r\n");
					
				valueXmlString.append("</Detail1>\r\n");
			}
			valueXmlString.append("</Root>\r\n");
		} 
		catch (Exception e) 
		{
			System.out.println("Inside Catch getSorderHeader==="+e.getMessage());
			e.printStackTrace();
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}

		System.out.println("Final Returnig from getSorderHeader"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	
	public String getDocIDImages(String refSer,String refId,String imgStr)throws ITMException
	{		
		System.out.println("inside getDocIDImages");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",itemRefSer = "";
		Connection conn = null;
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		
		int cnt = 0;
		try
		{	
			conn = getConnection();
			
			sql = " SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,refSer);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemRefSer = checkNullAndTrim(rs.getString("REF_SER"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT DOC_CONTENTS.DOC_ID FROM DOC_CONTENTS, DOC_TRANSACTION_LINK, USERS "
				  +" WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND USERS.CODE = DOC_CONTENTS.ADD_USER "
				  +" AND REF_SER = ? AND REF_ID = ?  ORDER BY DOC_CONTENTS.DOC_ID ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemRefSer);
			pstmt.setString(2, refId);

			rs = pstmt.executeQuery();

			while (rs.next())
			{
				valueXmlString.append("<doc_id>").append("<![CDATA["+checkNullAndTrim(rs.getString("DOC_ID"))+"]]>").append("</doc_id>\r\n");
				cnt++;
			}
			if (rs != null) 
			{					
				rs.close();rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();pstmt = null;
			}
			
			if(cnt == 0)
			{
				valueXmlString.append("<img_path>").append("<![CDATA["+checkNullAndTrim(getCustomImagePath(imgStr,imgStr,"RA_Images"))+"]]>").append("</img_path>\r\n");
			}
			
			valueXmlString.append("</Root>\r\n");
		}
		catch (Exception ex)
		{			
			System.out.println("Inside catch getDocIDImages"+ex.getMessage());
			ex.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		System.out.println("Returning DOC ID's "+valueXmlString.toString());
		return valueXmlString.toString();
	}
	
	
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "",tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
	
	
	/**
	 * @param input String
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	/**
	 * 
	 * @param arr
	 * @param targetValue
	 * @return
	 */
	public static String useLoop(String[] arr, String targetValue)
	{
		for(String s: arr)
		{
			String str = checkNullAndTrim(s);
			if(str.equals(targetValue))
				return "Y";
		}
		
		return "N";
	}
	
	/**
	 * get current date in Timestap formate
	 */
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	/**
	 * get current date in Application Time format
	 */
	private String getCurrdateAppFormat() 
	{
		String s = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
	public int GetRandomNumber()
    {
        long timeSeed = System.nanoTime(); // to get the current date time value
        double randSeed = Math.random() * 1000; // random number generation
        long midSeed = (long) (timeSeed * randSeed); 
        String s = midSeed + "";
        String subStr = s.substring(0, 9);
        int finalSeed = Integer.parseInt(subStr);    // integer value
        return finalSeed;
    }

	@Override
	public String getSorderDetail(String saleOrder, String flag)
			throws ITMException {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	//to get Sample accordian image Path [START]
	public String getCustomImagePath(String value,String altColImg, String object)
	{
		String imagePath = "";
		try
		{
			File objDir = new File (CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object);
			if(!objDir.exists())
			{
				objDir.mkdir();
			}
			if( fileExist(value, object))
			{
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			else
			{
				File f = new File(CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png");
				BufferedImage bi = createLabelImage(altColImg);
				ImageIO.write(bi,"PNG",f);
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("PopUpDataAccessEJB.getCustomeImagePath()::getCustomImagePath");
			e.printStackTrace();
		}
		
		System.out.println("Returning Image Path="+imagePath);
		return imagePath;		
	}
	
	public boolean fileExist(String value, String object)
	{
		boolean flag = true;
		try
		{
			String path = CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png";
			File f = new File(path);
			if( !f.exists() )
			{
				flag = false;
			}
			else
			{
				flag = true;
			}
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.fileExist()"+e.getMessage());
		}
		return flag;
	}
	
	public BufferedImage createLabelImage(String value)
	{
		int width = 100, height = 100;
		BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		try 
		{
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			File fontFile = new File(CommonConstants.APPLICATION_CONTEXT+"webitm"+File.separator+"css"+File.separator+"fonts"+File.separator+"Museo300-Regular.ttf");
			ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, fontFile));
			Graphics2D g = bi.createGraphics();
			String text = checkNullAndTrim(dynamicMenuImage(value));
			int centerX = 50, centerY = 50;
			int ovalWidth = 100, ovalHeight = 100;
			Font font = new Font("Museo 300", Font.PLAIN, 50);
			g.setFont(font);
			Color c = Color.decode("#cfbebe");
			g.setColor(c);
			g.fillOval(centerX-ovalWidth/2, centerY-ovalHeight/2,ovalWidth, ovalHeight);
			FontMetrics fm = g.getFontMetrics();
			double textWidth = fm.getStringBounds(text,g).getWidth();
			g.setColor(Color.WHITE);
			g.drawString(text, (int) (centerX - textWidth/2), (int) ( (centerY + fm.getMaxAscent() / 2) ) - 2);
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.createLabelImage()"+e.getMessage());
		}
		return bi;
	}
	private String dynamicMenuImage(String objDescr)
	{
		StringBuffer mnIconBuffer = new StringBuffer();
		String[] refSr = null;
		
		objDescr = objDescr.toUpperCase();
		objDescr = checkNullAndTrim(objDescr);
		objDescr = objDescr.trim();
		if( objDescr != "" )
		{
			if( objDescr.indexOf(" ") != -1 )
			{
				refSr = objDescr.split(" ");
			}
			else if( objDescr.indexOf("-") != -1 )
			{
				refSr = objDescr.split("-");
			}
			else if( objDescr.indexOf("_") != -1 )
			{
				refSr = objDescr.split("_");
			}
			else if( objDescr.indexOf(":") != -1 )
			{
				refSr = objDescr.split(":");
			}
			String menuStr = "";
			
			if( refSr != null )
			{
				for( int i = 0; i <= refSr.length; i++ )
				{
					if( mnIconBuffer.length() < 2 && checkNullAndTrim( refSr[i] ) != "" )
					{
						menuStr = refSr[i];
						menuStr = menuStr.trim();
						if( menuStr != ":" && !"".equalsIgnoreCase(menuStr) )
						{
							mnIconBuffer.append( menuStr.charAt(0) );
						}
					}
				}
			}
			else
			{
				mnIconBuffer.append( objDescr.charAt(0) );
			}
		}
		
		String menuIconPath = mnIconBuffer.toString();
		
		return menuIconPath;
	}
	//to get sample accordian image path [END]
	
	
	private Timestamp getDateInForamt( String dateStr, String format ) throws Exception
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Timestamp timestamp = null;
		SimpleDateFormat sdf = new SimpleDateFormat( format );//new SimpleDateFormat(genericUtility.getApplDateFormat());
		System.out.println( "dateStr[" + dateStr + "]" );
		java.util.Date frDate = null;
		frDate = sdf.parse( dateStr );
		SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
		timestamp = Timestamp.valueOf(sdf1.format(frDate).toString() + " 00:00:00.0");
		return timestamp;
	}
	
	public String getDefaultValuesFlag(String varName) throws RemoteException,ITMException 
	{
		Connection conn = null;
		String val = "";
		
		try 
		{
			conn = getConnection();
			val = checkNullAndTrim(distCommon.getDisparams("999999",varName, conn));			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception : SORDERWIZ_DEFAULT_VALUES getDefaultValuesFlagVal():"	+ e.getMessage() + ":");
		}
		finally 
		{
			try 
			{
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :SORDERWIZ_DEFAULT_VALUES defaultValueFlag(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return Value for disparm for SORDERWIZ_DEFAULT_VALUES =========>>["+val+"]");
		return val;
	}
	
	public JSONObject getDefaultValuesfromJSON(String fileName) throws RemoteException, ITMException 
	{
		JSONArray jsonArray = new JSONArray();
		JSONObject jsonObject = new JSONObject();
		JSONParser jsonParser = new JSONParser();
        int count = 1;

		String jsonFileName = "";
        try 
        { 
        	System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
    		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
    		if(CommonConstants.APPLICATION_CONTEXT != null)
    		{
    			jsonFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + fileName;
    		}
    		else
    		{
    			jsonFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator + fileName;
    		}
    		System.out.print("jsonFileName path ========>>"+jsonFileName);
    		
        	jsonArray = (JSONArray) jsonParser.parse(new FileReader(jsonFileName));

            for (Object obj : jsonArray)
            {
                JSONObject tempJson = (JSONObject) obj;

                jsonObject.put(count, tempJson);
				count++;
           }
        } 
	    catch (FileNotFoundException e)
	    {
	    	e.printStackTrace();
	    }
        catch (IOException e) 
        {
        	e.printStackTrace();
        }
        catch (ParseException e) 
        {
        	e.printStackTrace();
        }
        catch (Exception e) 
        {
        	e.printStackTrace();
        	System.out.println("Exception : SorderWizDefault getDefaultValuesfromJSON():"	+ e.getMessage() + ":");
		}        
		System.out.println("Return Value for SorderWizDefault getDefaultValuesfromJSON =========>>"+jsonObject);
		return jsonObject;
	}
	
}
