/*
    Window Name : w_cctracct
	Button Name : Process
	Action		: It Select data from ACCOUNTS_CCTR or ACCOUNTS as per Conditions  and after that 
				  Insert into ACCOUNTS_CCTR. 	              
*/

package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;

import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3


public class CctrAcctPrc extends ProcessEJB implements CctrAcctPrcLocal,CctrAcctPrcRemote //SessionBean
{
  /*	public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("ProcessEJB ejbCreate called.........");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate() 
	{
	}
	public void ejbPassivate() 
	{
	}*/
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :cctrAcctEJB :process(xmlString) ::" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		return retStr;
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String cctrCodeSrc = "";
		String cctrCodeTgt = "";
		String acctCodeFrom = "";
		String acctCodeTo = "";
		String sql = "",sql1 = "";
		String acctCode = "";
		String errCode = "";
		String errString = "";
		String chgUser = "",chgTerm = "";
		Statement stmt = null,stmt1 = null;
		ResultSet rs = null,rs1 = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		int rows = 0,count = 0,insertCount = 0; 
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			cctrCodeSrc = genericUtility.getColumnValue("cctr_code__src",headerDom);
			cctrCodeTgt = genericUtility.getColumnValue("cctr_code__tgt",headerDom);
			acctCodeFrom = genericUtility.getColumnValue("acct_code__fr",headerDom);
			acctCodeTo = genericUtility.getColumnValue("acct_code__to",headerDom);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			
			if (cctrCodeSrc != null)
			{
				sql = "SELECT ACCOUNTS_CCTR.ACCT_CODE FROM ACCOUNTS_CCTR WHERE ACCOUNTS_CCTR.CCTR_CODE = '"+ cctrCodeSrc +"'";
			}
			else
			{
				sql = "SELECT ACCOUNTS.ACCT_CODE FROM ACCOUNTS WHERE ACCOUNTS.ACCT_CODE >= '"+ acctCodeFrom +"'"+" AND  ACCOUNTS.ACCT_CODE <= '"+ acctCodeTo +"'";
			}

			System.out.println("Executing SQL :: "+sql);
			stmt = conn.createStatement();
			stmt1 = conn.createStatement();

			rs = stmt.executeQuery(sql);
			if (cctrCodeTgt == null)
			{
				System.out.println("cctrCodeTgt not found ");
				errCode = "VMCCTR1";
			}
			else
			{
				sql = "INSERT INTO ACCOUNTS_CCTR(ACCT_CODE,CCTR_CODE ,CHG_DATE,CHG_TERM ,CHG_USER) VALUES (?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
						
				System.out.println("insertSql :"+sql);
				while(rs.next())
				{
					acctCode = rs.getString(1);
					System.out.println("acctCode :"+acctCode);
					sql1 = "SELECT COUNT(*) FROM ACCOUNTS_CCTR WHERE ACCT_CODE = '"+acctCode+"' AND CCTR_CODE = '"+cctrCodeTgt+"'";
					rs1 = stmt1.executeQuery(sql1);
					
					if (rs1.next())
					{
						count = rs1.getInt(1);
						if (count > 0)
						{
							continue;
						}
					}					
					
					pstmt.setString(1, acctCode);
					pstmt.setString(2, cctrCodeTgt);
					pstmt.setDate(3,new java.sql.Date(System.currentTimeMillis()) );
					pstmt.setString(4,chgTerm);
					pstmt.setString(5,chgUser);
					rows = pstmt.executeUpdate();
					if (rows > 0)
					{
						insertCount++;
					}					
					pstmt.clearParameters();			
				}				
			}
			if (insertCount > 0)
			{
				errCode = "VMSUCC";
			}
			else if (insertCount == 0)
			{
				errCode = "VTNCOPY";
			}
			System.out.println("No of Record Inserted   :: "+insertCount);
			if (errCode != null || errCode.trim().length() > 0)
			{
				errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
				System.out.println("errString: "+errString);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :cctrAcctEJB :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection......");
				conn.close();
				conn = null;
			}catch(SQLException se){}
		}
		return errString;
	} 
}