package ibase.webitm.ejb.dis;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.io.FileWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SecSalesGenPrc extends ProcessEJB implements SecSalesGenPrcLocal,SecSalesGenPrcRemote {
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	Connection conn = null;
	String loginCode = null;
	String errorString = null;
	static String jBossHome = CommonConstants.JBOSSHOME;
	
	public String process(String xmlString, String xmlString2,String windowName, String xtraParams) throws RemoteException,ITMException 
	{
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		System.out.println("windowName[process]::::::::::;;;" + windowName);
		System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);

		try 
		{
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e) 
		{
			System.out.println("Exception :SecSalesGenPrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):"+ e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
		}
		return retStr;
	}// END OF PROCESS (1)
	
	public String process(Document headerDom, Document detailDom,String windowName, String xtraParams) throws RemoteException,ITMException 
	{
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String errString="",sql="",tranId="",tranIdLast="",spCode="",loginPositionCode="",orderType="",custType="",logDate="";
		PreparedStatement pstmt=null,pstmt1=null; ResultSet rs=null,rs1=null;
		String itemSer="",prdCode="",posCodeL4="",custCode="",countryCode="",retString = "",sysDate="",xmlInEditMode="";
		Timestamp frDate=null,toDate=null;
		SimpleDateFormat sdf=null,sdflog=null;
		CustStockGWTIC custStockGWTIC =new CustStockGWTIC();
		StringBuffer xmlBuff=null;
		ArrayList<String> logList=null;
		String loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
		String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		//Set UserINfo
		UserInfoBean userInfo = new UserInfoBean();
		userInfo.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
		userInfo.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
		userInfo.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
		userInfo.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "entityCode"));
		userInfo.setProfileId(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "profileId"));
		userInfo.setUserType(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userType"));
		userInfo.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
		try {
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			sdflog = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
			sysDate = sdf.format(Calendar.getInstance().getTime());
			logDate= sdflog.format(Calendar.getInstance().getTime());
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
		} catch (Exception e) {
			System.out.println("Exception :SecSalesGenPrc :ejbCreate :==>" + e);
			e.printStackTrace();
		}
		try 
		{
			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("::::::parentNodeListLength["+parentNodeListLength+"]");
			for (int i = 0; i < parentNodeListLength; i++) {
				parentNode = parentNodeList.item(i);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();	
				System.out.println("childNodeListLength : "+childNodeListLength+" childNodeList : "+childNodeList);
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeList.item(childRow) : "+ childNode);
					System.out.println("childNode Name : "+childNode.getNodeName()+" value::"+childNode.getNodeValue());
					if("item_ser".equalsIgnoreCase(childNodeName) && childNode.getFirstChild()!=null)
					{
						itemSer=checkNull(childNode.getFirstChild().getNodeValue());
					}
					if("prd_code".equalsIgnoreCase(childNodeName) && childNode.getFirstChild()!=null)
					{
						prdCode=checkNull(childNode.getFirstChild().getNodeValue());
					}
			
				}
			}
			
			sql= "select count_code from state where " +
					"state_code in (select state_code from site where site_code=?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countryCode = checkNull(rs.getString("count_code")).trim();
				System.out.println("countryCode >>> :"+countryCode);
			}
			callPstRs(pstmt, rs);
			
			sql = "select b.FR_DATE as FR_DATE,b.TO_DATE as TO_DATE " +
					" from period_appl a,period_tbl b " +
					"where a.ref_code=a.prd_tblno and a.prd_tblno=b.prd_tblno " +
					" AND b.prd_code = ? " +
					"and b.prd_tblno=? " +
					"AND case when a.type is null then 'X' else a.type end='S' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,prdCode.trim());
			pstmt.setString(2,countryCode+"_"+itemSer.trim());	
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				frDate=rs.getTimestamp("FR_DATE");
				toDate=rs.getTimestamp("TO_DATE");
			}
			callPstRs(pstmt, rs);
			
			logList=new ArrayList<String>();
			xmlInEditMode = getHeaderXML(userInfo,"1");
			System.out.println("xmlInEditMode:::"+ xmlInEditMode);
			
			sql = " SELECT POS_CODE,CUST_CODE,EMP_CODE FROM " +
					" (SELECT C.POS_CODE,C.CUST_CODE,A.EMP_CODE FROM ORG_STRUCTURE A ,ORG_STRUCTURE_CUST C " +
					" WHERE A.VERSION_ID=C.VERSION_ID AND A.TABLE_NO=C.TABLE_NO AND A.POS_CODE=C.POS_CODE " +
					" AND C.VERSION_ID = (SELECT FN_GET_VERSION_ID FROM DUAL) AND C.TABLE_NO= ? " +
					" AND C.EFF_DATE < ?  AND C.VALID_UPTO > ? AND CASE WHEN C.SOURCE IS NULL THEN 'Y' ELSE C.SOURCE END <> 'A' " +
					" MINUS " +
					" SELECT POS_CODE,CUST_CODE,EMP_CODE FROM CUST_STOCK WHERE PRD_CODE = ? AND POS_CODE IS NOT NULL AND ITEM_SER = ? ) ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemSer);
					pstmt.setTimestamp(2, frDate);
					pstmt.setTimestamp(3, toDate);
					pstmt.setString(4, prdCode);
					pstmt.setString(5, itemSer);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						posCodeL4 = checkNull(rs.getString("POS_CODE"));
						custCode = checkNull(rs.getString("CUST_CODE"));
						spCode=rs.getString("EMP_CODE");
						System.out.println("posCodeL4>>>"+posCodeL4+">>custCode>>"+custCode+"Employee code>>"+spCode);
						loginPositionCode=posCodeL4;

						StringBuffer xmlDetail1 = new StringBuffer();
						//Set Custstock header details
						sql= " select order_type,cust_type from customer where cust_code=? ";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, custCode);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							orderType=checkNull(rs1.getString("order_type"));
							custType=checkNull(rs1.getString("cust_type"));
						}
						callPstRs(pstmt1, rs1);
						tranIdLast=getTranIdLast(prdCode, orderType, itemSer, custCode);
						System.out.println("tranIdLast>>>"+tranIdLast+">>orderType>>>"+orderType+"custType>>>"+custType);
						Document detailDom1 = genericUtility.parseString(xmlInEditMode);
						NodeList parentNodeList1 = detailDom1.getElementsByTagName("Detail1");
						Node parentNode1 = parentNodeList1.item(0);
						NodeList childNodeList1 = parentNode1.getChildNodes();
						int childNodeListLength1 = childNodeList1.getLength();
						for (int ctr = 0; ctr < childNodeListLength1; ctr++) 
						{
							Node childNode1 = childNodeList1.item(ctr);
							String childNodeName1 = childNode1.getNodeName().trim();
							
							if ("tran_id".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(tranId);
							} else if ("tran_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sysDate);
							} else if ("cust_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(custCode);
							} else if ("item_ser".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(itemSer);
							} else if ("order_type".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(orderType);
							} else if ("from_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sdf.format(frDate).toString());
							} else if ("to_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sdf.format(toDate).toString());
							} else if ("site_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(loginSiteCode);
							} else if ("tran_id__last".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(tranIdLast);
							} else if ("stmt_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sysDate);
							} else if ("confirmed".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent("N");
							} else if ("status".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent("O");
							} else if ("cust_type".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(custType);
							} else if ("prd_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(prdCode);
							} else if ("missing_inserted".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent("Y");
							} else if ("adm_chk".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent("N");
							} else if ("login_poscode".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(loginPositionCode);
							} else if ("pos_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(posCodeL4);
							} else if ("emp_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(spCode);
							} else if ("country_code".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(countryCode);
							}  else if ("edit_status".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent("A");
							} else if ("sale_per".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(spCode);
							} else if ("chg_user".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(chgUser);
							} else if ("chg_term".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(chgTerm);
							} else if ("chg_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sysDate);
							} else if ("add_user".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(chgUser);
							} else if ("add_date".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(sysDate);
							} else if ("add_term".equalsIgnoreCase(childNodeName1)) {
								childNode1.setTextContent(chgTerm);
							} 
						}//for loop end
						xmlDetail1 = xmlDetail1.append(genericUtility.serializeDom(detailDom1));							
						//header details end
						System.out.println("xmlDetail1 final>>>>"+xmlDetail1.toString());
						String custStockInvDetails=custStockGWTIC.itemChanged("", xmlDetail1.toString(), xmlDetail1.toString(), "2", "itm_default", "A", xtraParams);
						System.out.println("custStockInvDetails>>>>"+custStockInvDetails);
						if(custStockInvDetails.contains("Detail2"))
						{
							String xmlDetail2=custStockInvDetails.substring(custStockInvDetails.indexOf("<Detail2"), custStockInvDetails.lastIndexOf("</Detail2>")+10);
							System.out.println("xmlDetail2>>>"+xmlDetail2);
							
							xmlBuff = new StringBuffer();
							xmlBuff.append(xmlDetail1.substring(0,xmlDetail1.indexOf("</Header0>")));
							xmlBuff.append(xmlDetail2);
							xmlBuff.append(xmlDetail1.substring(xmlDetail1.indexOf("</Header0>")));

							String xmlParseStr = xmlBuff.toString();
							xmlBuff = null;
							System.out.println(":::xmlParseStr:::" + xmlParseStr);
							String custStockItemDetails=custStockGWTIC.itemChanged("", xmlParseStr, xmlParseStr, "3", "itm_default", "A", xtraParams);
							System.out.println("custStockItemDetails>>>>>"+custStockItemDetails);
							if(custStockItemDetails.contains("Detail3"))
							{
							String xmlDetail3=custStockItemDetails.substring(custStockItemDetails.indexOf("<Detail3"), custStockItemDetails.lastIndexOf("</Detail3>")+10);
							System.out.println("xmlDetail3>>>>"+xmlDetail3);
							
							xmlBuff = new StringBuffer();
							xmlBuff.append(xmlParseStr.substring(0,xmlParseStr.indexOf("<Header0>") + 9));
							xmlBuff.append("<objName><![CDATA[").append("secondory_sale_gwt_wiz_dummy").append("]]></objName>");
							xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
							xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
							xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
							xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
							xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
							xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
							xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
							xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
							xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
							xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
							xmlBuff.append("<taxInFocus><![CDATA[").append(true).append("]]></taxInFocus>");
							xmlBuff.append(xmlParseStr.substring(xmlParseStr.indexOf("<Header0>") + 9,xmlParseStr.indexOf("</Header0>")));
							xmlBuff.append(xmlDetail3);
							xmlBuff.append(xmlParseStr.substring(xmlParseStr.indexOf("</Header0>")));

							String xmlParseStrFinal = xmlBuff.toString();
							xmlBuff = null;
							System.out.println("xmlParseStrFinal>>>>"+xmlParseStrFinal);
							retString=saveData(xmlParseStrFinal, conn, userInfo);
							System.out.println("retString>>>>"+retString);
							
							if (retString.toUpperCase().indexOf("SUCCESS") > -1)
							{
								conn.commit();
								String[] arrayForTranId = retString.split("<TranID>");
								int endIndex = arrayForTranId[1].indexOf("</TranID>");
								String newTranIdGen = arrayForTranId[1].substring(0, endIndex);
							
								if(newTranIdGen!=null && newTranIdGen.trim().length()>0)
								{
									String sql1 = "update cust_stock set confirmed = 'Y',status='S' where tran_id = ?";
									pstmt1 = conn.prepareStatement(sql1);
									pstmt1.setString(1, newTranIdGen);
									int count = pstmt1.executeUpdate();
									System.out.println("Count:::" + count);
									if (count > 0) {
										conn.commit();
										errString = "Confirmed Transaction "+newTranIdGen+" Created for Customer code >>"+custCode+" of Position code >>"+posCodeL4+" and Employee code >>"+spCode;
										logList.add(errString);
										errString=null;
									}
									if (pstmt1 != null) {
										pstmt1.close();
										pstmt1 = null;
									}
								}
							}
							else 
							{
								String description = "";
								Document parseString = genericUtility.parseString(retString);
								NodeList nlErrorTag = null;
								nlErrorTag = parseString.getElementsByTagName("error");
								if (nlErrorTag.getLength() <= 0) 
								{
									nlErrorTag = parseString.getElementsByTagName("Error");
								}
								for (int err = 0; err < nlErrorTag.getLength(); err++)
								{
									Node itemNode = nlErrorTag.item(err);
									NamedNodeMap errorAttributes = itemNode.getAttributes();
									Node errorTypeNode = errorAttributes.getNamedItem("type");
									Node errorIdNode = errorAttributes.getNamedItem("type");
									String errorType = errorTypeNode.getTextContent();
									String errorId = errorIdNode.getTextContent();
									NodeList childNodeListErr = itemNode.getChildNodes();
									for (int k = 0; k < childNodeListErr.getLength(); k++) 
									{
										Node childNodeErr = childNodeListErr.item(k);
										if ("description".equalsIgnoreCase(childNodeErr.getNodeName())) 
										{
											description = childNodeErr.getFirstChild().getNodeValue();
										}
									}

									if ("W".equals(errorType)) {
										errString = "Warnings: " + errorId + " : " + description;
									}
									else 
									{
										errString = "Errors: " + errorId + " : " + description;
									}
									logList.add(errString);
								}
							}
							}
							else
							{
								errString="No items present for available invoices of Customer >>"+custCode+" of Position code >>"+posCodeL4+" and Employee code>>"+spCode;
								logList.add(errString);
								errString=null;
							}
						}
						else
						{
							errString="No invoices present for Customer >>"+custCode+" of Position code >>"+posCodeL4+" and Employee code>>"+spCode;
							logList.add(errString);
							errString=null;
						}
					}
					callPstRs(pstmt, rs);
					writeLog(this.getClass().getSimpleName()+"_"+itemSer+"_"+prdCode, logList,logDate);
					//end
		}// try end
		catch (Exception e) 
		{
			try 
			{
				System.out.println("inside");
				errString = itmDBAccessEJB.getErrorString("", "VTES3GENF","", "", conn);
				conn.rollback();
			}
			catch (Exception d) 
			{
				System.out.println("Exception : SecSalesGenPrc =>"+ d.toString());
				d.printStackTrace();
			}
			e.printStackTrace();
			
		}
		finally 
		{
			System.out.println("In finally....");
			try {
				if (errString == null || errString.trim().length()==0) {
					System.out.println("Connection Commited");
					errString = itmDBAccessEJB.getErrorString("", "VTES3GENS","", "", conn);
					conn.commit();
				}
				else
				{
					errString = itmDBAccessEJB.getErrorString("", "VTES3GENF","", "", conn);
				}
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				errString = e.getMessage();
				e.printStackTrace();
				return errString;
			}
		}
		System.out.println("Error Message=>" + errString);
		return errString;
	}// END OF PROCESS(2)

	private String getHeaderXML(UserInfoBean userInfo,String formNo) throws Exception {
		InitialContext ctx = null;
		String retString = "";
		MasterStatefulLocal masterStateful = null;
		AppConnectParm appConnect = new AppConnectParm();
		try{
		ctx = new InitialContext(appConnect.getProperty());
		masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
		masterStateful.setUserInfo(userInfo);
		retString = checkNull(masterStateful.getDetailXMLDomString("secondory_sale_gwt_wiz", formNo, "A","", "", true));
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		return retString;
	}
	
	private String saveData(String xmlString, Connection conn,UserInfoBean userInfo) throws Exception {
		String retString = "";
		InitialContext ctx = null;
		MasterStatefulLocal masterStateful = null;
		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
			String[] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString:::::" + xmlString);
			retString = masterStateful.processRequest(userInfo, xmlString,true, conn);
			System.out.println("ProcessRequest::::::" + retString);
		}
		catch (Exception e) 
		{
			System.out.println("Exception: EJBName ["+ getClass().getSimpleName() + "] -method [saveData]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private String getTranIdLast(String prdCode,String orderType, String itemSer,String custCode)
	{
		String sql="",tranIdLast="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		Timestamp toDateLast=null;
		try
		{
			//Added by saurabh 17/01/17 as per discussion with Manoj Sir.--Start
			sql = " SELECT max(to_date) as to_date FROM CUST_STOCK WHERE CUST_CODE = ?  " +
					" AND ITEM_SER = ? and order_type=? and pos_code is not null and confirmed='Y' and status='S' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			pstmt.setString(2, itemSer);
			pstmt.setString(3, orderType);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				toDateLast = rs.getTimestamp("to_date");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			sql = " SELECT max(tran_id) as oldTranId FROM CUST_STOCK WHERE CUST_CODE = ?  " +
					" AND ITEM_SER = ? and order_type=? and pos_code is not null and confirmed='Y' and status='S' and to_date=? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			pstmt.setString(2, itemSer);
			pstmt.setString(3, orderType);
			pstmt.setTimestamp(4, toDateLast);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tranIdLast = checkNull(rs.getString("oldTranId"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return tranIdLast;
	}

	public void callPstRs(PreparedStatement pstmt, ResultSet rs) 
	{
		try 
		{
			if (pstmt != null) 
			{
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}

	private String checkNull(String input)
	{
		return input == null ? "" : input.trim();
	}

	private void writeLog(String fileName, ArrayList<String> logList,String logDate) 
	{
		FileWriter localFileWriter = null;
		try {
			File logDir = new File(jBossHome + File.separator+ "log" + File.separator + "SecSalesGenProcLog");
			if (!logDir.exists()) {
				logDir.mkdirs();
			}
			localFileWriter = new FileWriter(new File(jBossHome + File.separator + "log" + File.separator + "SecSalesGenProcLog" + File.separator + fileName + ".log"), true);
			localFileWriter.write("Log for Seondary Sales Generation Process for date::"+logDate+" \n");
			for(int i=0;i<logList.size();i++)
			{
				localFileWriter.write((logList.get(i)).toString()+"\n");
			}
			localFileWriter.write("\n\n");
			localFileWriter.flush();
			localFileWriter.close();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}
	
}// END OF EJB