/*
Developed By Gulzar
*/
package ibase.webitm.ejb.adm;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.system.config.ConnDriver;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Date;
import java.util.StringTokenizer;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.SQLException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
//import javax.ejb.SessionBean;
import javax.ejb.CreateException;

import java.text.SimpleDateFormat;

import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class EmpITDeclMultiPrc extends ProcessEJB implements EmpITDeclMultiPrcLocal,EmpITDeclMultiPrcRemote //SessionBean
{
	String empCode = "";
	String acctPrd = "";
	String tranIdNew = "";
	Connection conn = null;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	CommonConstants commonConstants = new CommonConstants();
	GenericUtility genericUtility = GenericUtility.getInstance();
	AdmCommon admCommom = null;
	/*
	public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("EmpITDeclMultiPrcEJB ejbCreate called.........");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate() 
	{
	}
	public void ejbPassivate() 
	{
	}*/
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document headerDom = null;
		Document detailDom = null;
		System.out.println("windowName:::::::::::::;"+ windowName);
		String  rtrStr ="";
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EmpITDeclMultiPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr; 
	}//END OF GETDATA(1)
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String errorCode = "";
		String errString = "";
		String resultString = "";
		String selSql= "" ;
		String itDecl = "";
		String adCodeRes = "";
		String adCode = "";
		String adCodeDescr = "";
		String adCodeEmp = "";
		String adCodeEmpItDecl = "";
		String remarks = "";
		String status = "";
		String tranID = "";
		String tranIDG = "";
		String currDate = "";
		String chgUser = "";
		String chgTerm = "";
		double amount = 0d;
		double amountOld = 0d;
		double proofAmt = 0d;
		double proofAmtOld = 0d;
		int allwDednCnt = 0, count = 0, cnt = 0;
		java.sql.Date effDate = null, expDate = null, tranDate = null;

		ResultSet rs = null, rs1 = null;
		Statement stmt = null, stmt1 = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		AdmCommon admCommon = new AdmCommon();
		HashMap empAllDednMap = new HashMap();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
		}
		catch (Exception e)
		{
			System.out.println("Exception :EmpITDeclMultiPrcEJB :getData :Connection Creation Error :==>"+e);
		} 
		try
		{
			empCode = genericUtility.getColumnValue("emp_code",headerDom);
			acctPrd = genericUtility.getColumnValue("acct_prd",headerDom);
			chgUser	= genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			chgTerm	= genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			java.util.Date toDate= new java.util.Date();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = sdf.format(toDate);

			selSql = "SELECT EMPLOYEE.EMP_FNAME || ' ' || EMPLOYEE.EMP_MNAME || ' ' || EMPLOYEE.EMP_LNAME , " +
					 "(CASE WHEN IT_NO IS NULL THEN ' ' ELSE IT_NO END) PAN_NO  "+
					 "FROM EMPLOYEE WHERE EMPLOYEE.EMP_CODE ='"+empCode+"'" ;
			System.out.println("selSql1 :: "+selSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selSql);
			if (rs.next())
			{
				selSql = "SELECT COUNT (*) AS ACCT_PRD FROM ACCTPRD WHERE CODE ='"+acctPrd+"'";
				System.out.println("selSql2 :: "+selSql);
				rs1 = stmt.executeQuery(selSql);
				if (rs1.next())
				{
					count = rs1.getInt("ACCT_PRD");
					if (count == 0)
					{
						errorCode = "VTACCTPRD1";
					}
				}
				rs1.close();
				rs1 = null;
			}
			else
			{
				errorCode = "VMEMP1";
			}
			rs.close();
			rs = null;
			if (errorCode != null && errorCode.trim().length() > 0)
			{
				errString = itmDBAccessEJB.getErrorString("",errorCode,"");
				return errString;
			}
			admCommom = new AdmCommon();
			itDecl = admCommom.getEnv("999999", "IT_DECL", conn);
			System.out.println("itDecl :: "+itDecl);
			if (itDecl.equals("NULLFOUND"))
			{
				errorCode = "VSENVAR1";
				errString = itmDBAccessEJB.getErrorString("",errorCode,"");
				return errString;
			}
			else
			{
				StringTokenizer st = new StringTokenizer(itDecl,",");
				while (st.hasMoreTokens())
				{
					adCodeRes = adCodeRes + "'" + st.nextToken() + "',";
				}
				adCodeRes = adCodeRes.substring(0,adCodeRes.length()-1);
				System.out.println("adCodeRes ::" + adCodeRes);
				selSql = "SELECT MAX(TRAN_ID) FROM EMP_IT_DECLARATION WHERE EMP_CODE = '"+empCode+"' AND ACCT_PRD = '"+acctPrd+"'";
				System.out.println("selSql3 :: "+selSql);
				rs = stmt.executeQuery(selSql);
				if (rs.next())
				{
					tranID = rs.getString(1);
					tranIdNew = tranID;
				}
				rs.close();
				rs = null;
			}
			selSql = "SELECT EMP_IT_DECLARATION.TRAN_ID, "+
					 "EMP_IT_DECLARATION.TRAN_DATE, "+
					 "EMP_IT_DECLARATION.ACCT_PRD, "+
					 "EMP_IT_DECLARATION.EMP_CODE, "+
					 "EMP_IT_DECLARATION.AD_CODE, "+
					 "ALLWDEDN.DESCR, " +
					 "EMP_IT_DECLARATION.AMOUNT, "+
					 "EMP_IT_DECLARATION.AMOUNT_PROOF, "+
					 "EMP_IT_DECLARATION.AMOUNT_OLD, "+
					 "EMP_IT_DECLARATION.AMOUNT_PROOF_OLD, "+
					 "EMP_IT_DECLARATION.REMARK, "+
					 "EMP_IT_DECLARATION.CHG_DATE, "+  
					 "EMP_IT_DECLARATION.CHG_USER, "+
					 "EMP_IT_DECLARATION.CHG_TERM, "+
					 "EMP_IT_DECLARATION.STATUS "+
					 "FROM ALLWDEDN, EMP_IT_DECLARATION " +
					 "WHERE ( EMP_IT_DECLARATION.AD_CODE = ALLWDEDN.AD_CODE ) AND " +  
					 "( EMP_IT_DECLARATION.TRAN_ID = '"+tranID+"' ) AND "+
					 "( EMP_IT_DECLARATION.EMP_CODE = '"+empCode+"' ) AND "+
					 "( ALLWDEDN.AD_CODE IN ( "+adCodeRes+" ) ) AND "+ 
					 "( EMP_IT_DECLARATION.ACCT_PRD = '"+acctPrd+"' ) ORDER BY ALLWDEDN.AD_CODE";

			System.out.println("selSql4 :: "+selSql);
			rs = stmt.executeQuery(selSql);
			while (rs.next())
			{
				adCodeEmpItDecl = rs.getString(5);
				empAllDednMap.put(adCodeEmpItDecl, new Double(rs.getDouble(7)));
				retTabSepStrBuff.append(rs.getString(5)).append("\t");
				retTabSepStrBuff.append(rs.getString(6)).append("\t");
				retTabSepStrBuff.append(rs.getString(7)).append("\t");
				retTabSepStrBuff.append(rs.getString(8)).append("\t");
				retTabSepStrBuff.append((rs.getString(11)==null)? "" :rs.getString(11)).append("\t");
				retTabSepStrBuff.append(rs.getString(9)).append("\t");
				retTabSepStrBuff.append(rs.getString(10)).append("\t");
				retTabSepStrBuff.append(rs.getString(12)).append("\t");
				retTabSepStrBuff.append(rs.getString(13)).append("\t");
				retTabSepStrBuff.append(rs.getString(14)).append("\t");
				retTabSepStrBuff.append(rs.getString(1)).append("\t");
				retTabSepStrBuff.append(rs.getString(2)).append("\t");
				retTabSepStrBuff.append(rs.getString(4)).append("\t");
				retTabSepStrBuff.append(rs.getString(3)).append("\t");
				retTabSepStrBuff.append(rs.getString(15)).append("\t");
				retTabSepStrBuff.append("\n"); 
				cnt = cnt + 1;
			}
			rs.close();rs = null;
			stmt.close();stmt = null;
			System.out.println("cnt :: "+cnt);
			if (cnt < 1)
			{
				selSql = "SELECT FR_DATE, TO_DATE "+
						 "FROM PERIOD A WHERE A.CODE = (SELECT MAX(CODE) FROM PERIOD B WHERE B.ACCT_PRD = '"+acctPrd+"')";
				System.out.println("selSql5 :: "+selSql);
				stmt = conn.createStatement();
				rs = stmt.executeQuery(selSql);
				if (rs.next())
				{
					effDate = rs.getDate("FR_DATE");
					expDate = rs.getDate("TO_DATE");
				}
				else
				{
					errorCode = "DS000";
				}
				rs.close();rs = null;
				stmt.close();stmt = null;
				selSql = "SELECT AD_CODE, AMOUNT FROM EMPLOYEE_AD "+
						 "WHERE EMP_CODE = '"+empCode+"' AND EFF_DATE = ? AND EXP_DATE = ? AND REF_TYPE = 'I' ";
				System.out.println("selSql6 :: "+selSql);
				pstmt = conn.prepareStatement(selSql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(sdf.format(effDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(sdf.format(expDate), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					adCodeEmp = rs.getString("AD_CODE");
					amount = rs.getDouble("AMOUNT");
					if (empAllDednMap.containsKey("adCodeEmp"))
					{
						empAllDednMap.put(adCodeEmp, new Double(amount));
					}
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
			}
			System.out.println("empAllDednMap :: "+ empAllDednMap);
			selSql = "SELECT AD_CODE, DESCR FROM ALLWDEDN  WHERE AD_CODE IN ("+adCodeRes+") ORDER BY AD_CODE"; 
			System.out.println("selSql7 :: "+selSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selSql);
			while (rs.next())
			{
				adCode = rs.getString("AD_CODE");
				adCodeDescr = rs.getString("DESCR");
				if (adCode != null && adCode.trim().length() > 0)
				{
					if (!empAllDednMap.containsKey(adCode))
					{
						retTabSepStrBuff.append(adCode).append("\t");
						retTabSepStrBuff.append(adCodeDescr).append("\t");
						retTabSepStrBuff.append((empAllDednMap.get(adCode) == null)? "0.0" :empAllDednMap.get(adCode)).append("\t");
						retTabSepStrBuff.append(proofAmt).append("\t");
						retTabSepStrBuff.append(remarks).append("\t");
						retTabSepStrBuff.append(amountOld).append("\t");
						retTabSepStrBuff.append(proofAmtOld).append("\t");
						retTabSepStrBuff.append(currDate).append("\t");
						retTabSepStrBuff.append(chgUser).append("\t");
						retTabSepStrBuff.append(chgTerm).append("\t");
						retTabSepStrBuff.append("").append("\t");
						retTabSepStrBuff.append(tranDate).append("\t");
						retTabSepStrBuff.append(empCode).append("\t");
						retTabSepStrBuff.append(acctPrd).append("\t");
						retTabSepStrBuff.append(status).append("\t");
						retTabSepStrBuff.append("\n"); 
					}
				}
			}
			rs.close();rs = null;
			stmt.close();stmt = null;
			System.out.println("retTabSepStrBuff:::::::::::::"+retTabSepStrBuff);
			resultString = retTabSepStrBuff.toString();
		}
		catch (SQLException e)
		{
			System.out.println("SQLException :EmpITDeclMultiPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EmpITDeclMultiPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection..............");
				retTabSepStrBuff = null;
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(conn != null)
				{					
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return resultString;	
	}//END OF GETDATA(2)
	//PROCESS
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
			String retStr = "";
			Document detailDom = null;
			Document headerDom = null;
			try
			{	
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					headerDom = genericUtility.parseString(xmlString); 
					System.out.println("headerDom" + headerDom);
				}
				if(xmlString2 != null && xmlString2.trim().length()!=0)
				{
					detailDom = genericUtility.parseString(xmlString2); 
					System.out.println("detailDom" + detailDom);
				}
										
			    retStr = process(headerDom, detailDom, windowName, xtraParams);
			}
			catch (Exception e)
			{
				System.out.println("Exception :EmpITDeclMultiPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				retStr = e.getMessage();
			}
			return retStr;
		
	}//END OF PROCESS (1)
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String empAdAprv = "";
		String empAdStatus = "";
		String errorCode = "";
		String loginSiteCode = "";
		String paySiteCode = "";
		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		String adCode = "";
		String adCodeDescr = "";
		String remark = "";
		String status = "";
		String tranId = "";
		String tranDate = "";
		String panNo = "";
		String selSql = "";
		String insertSql = "";
		String updateSql = "";
		String allwdednDescr = "";

		int empCount = 0;
		int insertCnt = 0;
		int updateCnt = 0;
		double amountNew = 0d;
		double amountOld = 0d;
		double proofAmtNew = 0d;
		double proofAmtOld = 0d;
		double amountOrg = 0d;
		double proofAmtOrg = 0d;
		boolean isModified = true;
		java.sql.Date relieveDate = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		int parentNodeListLength =0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		PreparedStatement pstmt = null;
		Statement stmt = null; 
		String errString = "";
		//Added by Suraj [02-02-2016][Start]
		String profileId="";		
		//Added by Suraj [02-02-2016][End]
		
		while (true)
		{
			try
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);

				chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
				chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
				loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "profileId");//Added by Suraj [02-02-2016][To get profile Id]
				
				parentNodeList = detailDom.getElementsByTagName("Detail2");
				parentNodeListLength = parentNodeList.getLength(); 
				
				empCode = genericUtility.getColumnValue("emp_code",headerDom);
				acctPrd = genericUtility.getColumnValue("acct_prd",headerDom);
				panNo	= genericUtility.getColumnValue("pan_no",headerDom);

				admCommom = new AdmCommon();
				empAdAprv = admCommom.getEnv("999999", "EMP_AD_APRV", conn);
				if (empAdAprv.equals("NULLFOUND") || empAdAprv.equals("N"))
				{
					empAdStatus = "Y";
				}
				else
				{
					empAdStatus = "N";
				}
				selSql = "SELECT COUNT( EMP_CODE ) FROM IT_CALCHDR WHERE EMP_CODE = '"+empCode+"' AND ACCT_PRD = '"+acctPrd+"' AND CONFIRMED = 'Y' ";
				System.out.println("selSql1" + selSql);
				stmt = conn.createStatement();
				rs = stmt.executeQuery(selSql);
				if (rs.next())
				{
					empCount = rs.getInt(1);
					if (empCount > 0)
					{
						errorCode = "VTCONF2";
						break;
					}
				}
				else
				{
					errorCode = "DS000";
					break;
				}
				rs.close();
				rs = null;
				
					selSql = "SELECT RELIEVE_DATE, STATUS, PAY_SITE FROM EMPLOYEE WHERE EMP_CODE = '"+empCode+"'" ;
					System.out.println("selSql2" + selSql);
					stmt = conn.createStatement();
					rs1 = stmt.executeQuery(selSql);
					if (rs1.next())
					{
						relieveDate = rs1.getDate("RELIEVE_DATE");
						status		= rs1.getString("STATUS");
						paySiteCode = rs1.getString("PAY_SITE");
						//Modified by Suraj [02-02-2016][To add condition for the validation of login site][Start]
						/*if (usrLev != 0 && usrLev != 1) 
						{
							if (loginSiteCode != null && loginSiteCode.trim().length() > 0 && !paySiteCode.trim().equals(loginSiteCode.trim()))
							{
								errorCode = "VMSITE10";
								break;
							}
						}
						*/
						String sqlStr = "";
						String userRightsStr = "";
						int usrLev = 0;
						sqlStr = "SELECT USR_LEV FROM USERS WHERE CODE=?";
						pstmt = conn.prepareStatement(sqlStr);
						pstmt.setString(1,chgUser);
						rs=pstmt.executeQuery();
						while (rs.next())
						{
							usrLev = rs.getInt("USR_LEV");
						}
						pstmt.close();
						pstmt = null;
						rs.close();
						rs = null;
						if (usrLev == 0)
						{
							userRightsStr = "0";
						}
						else
						{
							sqlStr = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID=? AND OBJ_NAME='emp_itdecl_multi'";
							pstmt = conn.prepareStatement(sqlStr);
							pstmt.setString(1, profileId);
							rs=pstmt.executeQuery();
							if (rs.next())
							{
								userRightsStr = rs.getString("RIGHTS");
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
						}
						if (userRightsStr == null)
						{
							userRightsStr = "";
						}
						if (userRightsStr.indexOf("0") != -1)
						{
						}
						else if (userRightsStr.indexOf("1") != -1)
						{
							sqlStr ="SELECT COUNT(*) AS CNT FROM USER_SITE WHERE "
									+"USER_ID=? AND SITE_CODE= ?";
							pstmt = conn.prepareStatement(sqlStr);
							pstmt.setString(1, chgUser);
							pstmt.setString(2, paySiteCode);
							rs=pstmt.executeQuery();
							int cnt = 0;
							if (rs.next())
							{
								cnt = rs.getInt("CNT");
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
							if(cnt == 0)
							{
								errorCode = "VMSITE10";
								break;
							}
						}
						else
						{
							if (loginSiteCode != null && loginSiteCode.trim().length() > 0 && !paySiteCode.trim().equals(loginSiteCode.trim()))
							{
								errorCode = "VMSITE10";
								break;
							}
						}
					}
					//Modified by Suraj [02-02-2016][To add condition for the validation of login site][End]
					else
					{
						errorCode = "VMEMP1";
						break;
					}
					rs1.close(); rs1 = null;
					stmt.close(); stmt = null;
					
					
				

				for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				{
					parentNode = parentNodeList.item(selectedRow);
					System.out.println("parentNode:::::::::::::: "+ parentNode);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeListLength::: "+ childNodeListLength);
					tranId = "";
					for (int childRow = 0; childRow < childNodeListLength; childRow++)
					{
						childNode = childNodeList.item(childRow);
						childNodeName = childNode.getNodeName(); 
						System.out.println("childNodeName::::::::"+childNodeName);
						if (childNodeName.equals("ad_code"))
						{
							if(childNode.getFirstChild()!=null)
							{
								adCode = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("adCode ::"+adCode);
						}
						if (childNodeName.equals("allwdedn_descr"))
						{
							if (childNode.getFirstChild()!=null)
							{
								allwdednDescr = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("allwdednDescr ::"+allwdednDescr);
						}
						if (childNodeName.equals("amount")) 
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									amountNew = Double.parseDouble(childNode.getFirstChild().getNodeValue());
								}
							}
							System.out.println("amountNew ::"+amountNew);
						}
						if (childNodeName.equals("amount_proof"))
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									proofAmtNew =  Double.parseDouble(childNode.getFirstChild().getNodeValue());
								}
							}
							System.out.println("proofAmtNew ::"+proofAmtNew);
						}
						if (childNodeName.equals("remark"))
						{
							if (childNode.getFirstChild()!=null)
							{
								remark = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("remark ::"+remark);
						}
						if (childNodeName.equals("amount_old"))
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									amountOld =  Double.parseDouble(childNode.getFirstChild().getNodeValue());
								}
							}
							System.out.println("amountOld ::"+amountOld);
						}
						if (childNodeName.equals("amount_proof_old"))
						{
							if (childNode.getFirstChild()!=null)
							{
								if (childNode.getFirstChild().getNodeValue()!=null)
								{
									proofAmtOld =  Double.parseDouble(childNode.getFirstChild().getNodeValue());
								}
							}
							System.out.println("proofAmtOld ::"+proofAmtOld);
						}
						/*
						if (childNodeName.equals("chg_date"))
						{
							if (childNode.getFirstChild()!=null)
							{
								chgDate = childNode.getFirstChild().getNodeValue();
							}
						}
						if (childNodeName.equals("chg_user"))
						{
							if (childNode.getFirstChild()!=null)
							{
								chgUser = childNode.getFirstChild().getNodeValue();
							}
						}
						if (childNodeName.equals("chg_term"))
						{
							if (childNode.getFirstChild()!=null)
							{
								chgTerm = childNode.getFirstChild().getNodeValue();
							}
						}*/
						if (childNodeName.equals("tran_id"))
						{
							if (childNode.getFirstChild()!=null)
							{
								tranId = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("tranId ::"+tranId);
						}
						if (childNodeName.equals("tran_date"))
						{
							if (childNode.getFirstChild()!=null)
							{
								tranDate = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("tranDate ::"+tranDate);
						}
						if (childNodeName.equals("emp_code"))
						{
							if (childNode.getFirstChild()!=null)
							{
								empCode = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("empCode ::"+empCode);
						}
						if (childNodeName.equals("acct_prd"))
						{
							if (childNode.getFirstChild()!=null)
							{
								acctPrd = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("acctPrd ::"+acctPrd);
						}
						if (childNodeName.equals("status"))
						{
							if (childNode.getFirstChild()!=null)
							{
								status = childNode.getFirstChild().getNodeValue();
							}
							System.out.println("status ::"+status);
						}
					}
					selSql = "SELECT AMOUNT, AMOUNT_PROOF FROM EMP_IT_DECLARATION WHERE AD_CODE = '"+adCode+"' AND TRAN_ID = '"+tranId+"'";
					System.out.println("selSql3 :: "+selSql);
					stmt = conn.createStatement();
					rs = stmt.executeQuery(selSql);
					if (rs.next())
					{
						amountOrg	= rs.getDouble("AMOUNT");
						proofAmtOrg = rs.getDouble("AMOUNT_PROOF");
						System.out.println("amountOrg :: "+amountOrg);
						System.out.println("proofAmtOrg :: "+proofAmtOrg);
						if (amountNew != amountOrg || proofAmtNew != proofAmtOrg)
						{
							isModified = true;
							if (amountNew != amountOrg)
							{
								amountOld = amountOrg;
							}
							if (proofAmtNew != proofAmtOrg)
							{
								proofAmtOld = proofAmtOrg;
							}
						}
						else
						{
							isModified = false;
						}
					}
					else
					{
						if (amountNew == 0 && proofAmtNew == 0)
						{
							isModified = false;
						}
						else
						{
							isModified = true;
						}
						amountOld = 0d;
						amountOrg = 0d;
						proofAmtOld = 0d;
						proofAmtOrg = 0d;
					}
					rs.close();rs = null;
					stmt.close();stmt = null;
					if (isModified)
					{
						if (tranIdNew == null || tranIdNew.trim().length() == 0)
						{
							tranIdNew = generateTranId(windowName, conn);
							System.out.println("tranIdNew ::"+tranIdNew);
						}
						if (tranId == null || tranId.trim().length() == 0)
						{
							tranId = tranIdNew;
							System.out.println("tranId ::"+tranId);
							insertSql = "INSERT INTO EMP_IT_DECLARATION(TRAN_ID, TRAN_DATE, ACCT_PRD, "+
										"EMP_CODE, AD_CODE, AMOUNT, STATUS, CHG_DATE, CHG_USER, CHG_TERM, "+
										"AMOUNT_PROOF, AMOUNT_OLD, AMOUNT_PROOF_OLD, REMARK) "+
										"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							pstmt = conn.prepareStatement(insertSql);
							pstmt.setString(1,tranId);
							pstmt.setTimestamp(2,new java.sql.Timestamp(System.currentTimeMillis()));
							pstmt.setString(3,acctPrd);
							pstmt.setString(4,empCode);
							pstmt.setString(5,adCode);
							pstmt.setDouble(6,amountNew);
							pstmt.setString(7,empAdStatus);
							pstmt.setTimestamp(8,new java.sql.Timestamp(System.currentTimeMillis()));
							pstmt.setString(9,chgUser);
							pstmt.setString(10,chgTerm);
							pstmt.setDouble(11,proofAmtNew);
							pstmt.setDouble(12,amountOld);
							pstmt.setDouble(13,proofAmtOld);
							pstmt.setString(14,remark);
							insertCnt = pstmt.executeUpdate();
							if (insertCnt == 1)
							{
								System.out.println("Inserted Into EMP_IT_DECLARATION Successfully.....:: "+insertCnt);
							}
							pstmt.close();
							pstmt = null;
						}
						else
						{
							updateSql = "UPDATE EMP_IT_DECLARATION SET "+
										"TRAN_DATE = ?, AMOUNT = '"+amountNew+"', AMOUNT_PROOF = '"+proofAmtNew+"', "+
										"AMOUNT_OLD = '"+amountOld+"', AMOUNT_PROOF_OLD = '"+proofAmtOld+"', REMARK = '"+remark+"', "+
										"CHG_DATE = ?, CHG_USER = '"+chgUser+"', CHG_TERM = '"+chgTerm+"' "+
										"WHERE TRAN_ID = '"+tranId+"' AND EMP_CODE = '"+empCode+"' "+
										"AND ACCT_PRD = '"+acctPrd+"' AND AD_CODE = '"+adCode+"'";
							System.out.println("updateSql1 :: "+updateSql);
							pstmt = conn.prepareStatement(updateSql);
							pstmt.setTimestamp(1,new java.sql.Timestamp(System.currentTimeMillis()));
							pstmt.setTimestamp(2,new java.sql.Timestamp(System.currentTimeMillis()));
							updateCnt = pstmt.executeUpdate();
							System.out.println("updateCnt :: "+updateCnt);
							if (updateCnt >= 1)
							{
								System.out.println("Updated Into EMP_IT_DECLARATION Successfully.....:: "+updateCnt);
							}
							pstmt.close();
							pstmt = null;
						}
					}
				}
				if (errorCode == null || errorCode.trim().length() == 0)
				{
					selSql = "SELECT CASE WHEN IT_NO IS NULL THEN ' ' ELSE IT_NO END FROM EMPLOYEE WHERE EMP_CODE = '"+empCode+"'";
					System.out.println("selSql4 :: "+selSql);
					stmt = conn.createStatement();
					rs = stmt.executeQuery(selSql);
					if (rs.next())
					{
						if (rs.getString(1).toUpperCase() != panNo)
						{
							updateSql = "UPDATE EMPLOYEE SET IT_NO ='"+panNo+"', "+
										"CHG_DATE = ?, CHG_USER = '"+chgUser+"', CHG_TERM = '"+chgTerm+"' "+
										"WHERE EMP_CODE = '"+empCode+"'";
							System.out.println("updateSql2 :: "+updateSql);
							pstmt = conn.prepareStatement(updateSql);
							pstmt.setTimestamp(1,new java.sql.Timestamp(System.currentTimeMillis()));
							updateCnt = pstmt.executeUpdate();
							if (updateCnt == 1)
							{
								System.out.println("Updated Into EMPLOYEE Successfully.....:: "+updateCnt);
							}
							pstmt.close();
							pstmt = null;
						}
					}
				}
			}//try end	
			catch(Exception e)
			{
				System.out.println("Exception :EmpITDeclMultiPrcEJB :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			} 
			finally
			{
				System.out.println("Closing Connection....");
				try
				{
					if (errorCode != null && errorCode.trim().length() > 0)
					{
						conn.rollback();
						errString = itmDBAccessEJB.getErrorString("",errorCode,"");
					}
					else
					{
						conn.commit();
						errString = itmDBAccessEJB.getErrorString("","VTCOMPL","");
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(pstmt != null)
					{ 
						pstmt.close();
						pstmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{
					errString = e.getMessage();
					e.printStackTrace();
				}
			}
			break;
		}//End Of while loop
		System.out.println("errString...:: "+errString);
		return errString;
	}//END OF PROCESS(2)
	private String generateTranId(String windowName,Connection conn)throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String newKeystring = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Date effDate = null;

		 try
	     {
	    	selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = '"+windowName+"'";
			System.out.println("selSql :"+selSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selSql);
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");				
			}
			rs.close();
			rs = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			selSql = "SELECT PAY_SITE FROM EMPLOYEE WHERE EMP_CODE = '"+empCode+"'";
			System.out.println("selSql :"+selSql);
			rs = stmt.executeQuery(selSql);
			if (rs.next())
			{
				paySiteCode = rs.getString("PAY_SITE");
			}
			rs.close();
			rs = null;
			selSql = "SELECT FR_DATE FROM ACCTPRD WHERE CODE = '"+acctPrd+"'";
			System.out.println("selSql :"+selSql);
			rs = stmt.executeQuery(selSql);
			if (rs.next())
			{
				effDate = rs.getDate("FR_DATE");
			}
			rs.close();
			rs = null;
			effectiveDate = genericUtility.getValidDateString(effDate.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + paySiteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ effectiveDate + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
			}
			catch(Exception e){}
		}
		return tranId;
	}//generateTranTd()
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}
}//END OF EJB