package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.GSTR1;

public class GSTR1Serailizer extends JsonSerializer<GSTR1> {
    @Override
    public void serialize(GSTR1 gstr1, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
    {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("gstin", gstr1.gstin);
        jsonGenerator.writeStringField("fp", gstr1.financialPeriod);
        jsonGenerator.writeNumberField("gt", gstr1.grossTurnOver);
        jsonGenerator.writeNumberField("cur_gt", gstr1.currentGrossTurnOver);
        if(gstr1.b2b != null)
        {
        	jsonGenerator.writeObjectField("b2b", gstr1.b2b);
        } 
        if(gstr1.b2ba != null)
        {
        	jsonGenerator.writeObjectField("b2ba", gstr1.b2ba);
        }
        if(gstr1.b2cl != null)
        {
        	jsonGenerator.writeObjectField("b2cl", gstr1.b2cl);
        }
        if(gstr1.b2cla != null)
        {
        	jsonGenerator.writeObjectField("b2cla", gstr1.b2cla);
        }
        if(gstr1.b2cs != null)
        {
        	jsonGenerator.writeObjectField("b2cs", gstr1.b2cs);
        }
        if(gstr1.b2csa != null)
        {
        	jsonGenerator.writeObjectField("b2csa", gstr1.b2csa);
        }
        if(gstr1.cdnr != null)
        {
        	jsonGenerator.writeObjectField("cdnr", gstr1.cdnr);
        }
        if(gstr1.cdnra != null)
        {
        	jsonGenerator.writeObjectField("cdnra", gstr1.cdnra);
        }
        if(gstr1.at != null)
        {
        	jsonGenerator.writeObjectField("at", gstr1.at);
        }
        if(gstr1.ata != null)
        {
        	jsonGenerator.writeObjectField("ata", gstr1.ata);
        }
        if(gstr1.exp != null)
        {
        	jsonGenerator.writeObjectField("exp", gstr1.exp);
        }
        if(gstr1.expa != null)
        {
        	jsonGenerator.writeObjectField("expa", gstr1.expa);
        }
        if(gstr1.txpd != null)
        {
        	jsonGenerator.writeObjectField("txpd", gstr1.txpd);
        }
        if(gstr1.cdnur != null)
        {
        	jsonGenerator.writeObjectField("cdnur", gstr1.cdnur);
        }
        if(gstr1.nil != null)
        {
        	jsonGenerator.writeObjectField("nil", gstr1.nil);
        }
        if(gstr1.hsn != null)
        {
        	jsonGenerator.writeObjectField("hsn", gstr1.hsn);
        }
        if(gstr1.docIssued != null)
        {
        	jsonGenerator.writeObjectField("doc_issue", gstr1.docIssued);
        }
        jsonGenerator.writeEndObject();
    }
}
