/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.utility.ValidateXMLInput;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Date;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DocumentHandlerServlet
extends ITMAuthenticateServlet {
    ServletConfig servletConfig = null;
    protected InitialContext ctx = null;
    private static String dirName = null;
    private static int MAX_UPLOAD_SIZE = 0xA00000;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
        if (CommonConstants.J2EE_VERSION.equals("1")) {
            CommonConstants.setAPPLICATION_CONTEXT((String)this.servletConfig.getServletContext().getRealPath("/"));
            dirName = new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent() + File.separator + "dump";
        } else if (CommonConstants.J2EE_VERSION.equals("2")) {
            dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
        }
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    @Override
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        System.out.println("\n\n****** DocumentHandlerServlet called ******");
        HttpSession httpSession = null;
        try {
            if (Boolean.valueOf(this.authenticate(httpServletRequest)).booleanValue()) {
                httpSession = httpServletRequest.getSession();
                System.out.println("\nsess.getId()............... :" + httpSession.getId());
                if (this.ctx == null) {
                    this.ctx = this.getInitialContext();
                }
                this.handleDocument(httpServletRequest, httpServletResponse);
            }
        }
        catch (ITMException iTMException) {
            try {
                PrintWriter printWriter = httpServletResponse.getWriter();
                httpServletResponse.setContentType("text/html");
                String string = "ERR_MSG :INVALID_DOCUMENT\n" + iTMException.getMessage();
                httpServletResponse.setContentLength(string.length());
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :DocumentHandlerServlet :doPost :==>");
            exception.printStackTrace();
            try {
                PrintWriter printWriter = httpServletResponse.getWriter();
                httpServletResponse.setContentType("text/html");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                httpServletResponse.setContentLength(byteArrayOutputStream.toString().length());
                printWriter.println("ERR_MSG :INVALID_DOCUMENT\n" + byteArrayOutputStream.toString());
                printWriter.flush();
                printWriter.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private void handleDocument(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ITMException {
        ServletOutputStream servletOutputStream = null;
        String string = "";
        byte[] byArray = null;
        try {
            String[] stringArray;
            Object object;
            Object object2;
            String string2;
            String string3;
            String string4 = httpServletRequest.getParameter("ACTION");
            String string5 = httpServletRequest.getParameter("REF_ID");
            String string6 = this.getRefSer(httpServletRequest);
            String string7 = httpServletRequest.getParameter("CLIENT");
            System.out.println("action :[" + string4 + "]");
            DocumentHandlerRemote documentHandlerRemote = (DocumentHandlerRemote)this.ctx.lookup("ibase/DocumentHandlerEJB/remote");
            if (string4.equals("GET_DATA")) {
                string = documentHandlerRemote.getComment(string6, string5);
                byArray = string.getBytes();
            } else if (string4.equals("DOCUMENT_GET_DATA")) {
                string = documentHandlerRemote.getDocumentInfoList(string6, string5);
                byArray = string.getBytes();
                httpServletResponse.setContentType("text/xml");
            } else if (string4.equalsIgnoreCase("GET_DOCUMENT")) {
                string3 = httpServletRequest.getParameter("DOC_ID");
                string2 = httpServletRequest.getParameter("DOC_TYPE");
                byArray = documentHandlerRemote.getDocument(string3);
                System.out.println("docType [" + string2 + "]");
                object2 = documentHandlerRemote.getDocumentName(string3);
                System.out.println(" fileName of Downloaded document[" + (String)object2 + "]");
                httpServletResponse.setHeader("Content-disposition", "attachment;filename = \"" + (String)object2 + "\"");
                if (string2.equalsIgnoreCase("pdf")) {
                    httpServletResponse.setContentType("application/pdf");
                } else if (string2.equalsIgnoreCase("bmp")) {
                    httpServletResponse.setContentType("image/bmp");
                } else if (string2.equalsIgnoreCase("txt") || string2.equalsIgnoreCase("dtd") || string2.equalsIgnoreCase("java")) {
                    httpServletResponse.setContentType("text/plain");
                } else if (string2.equalsIgnoreCase("html") || string2.equalsIgnoreCase("htm")) {
                    httpServletResponse.setContentType("text/html");
                } else if (string2.equalsIgnoreCase("doc") || string2.equalsIgnoreCase("odt")) {
                    httpServletResponse.setContentType("application/msword");
                } else if (string2.equalsIgnoreCase("xls")) {
                    httpServletResponse.setContentType("application/msexcel");
                } else if (string2.equalsIgnoreCase("gif")) {
                    httpServletResponse.setContentType("image/gif");
                } else if (string2.equalsIgnoreCase("ai")) {
                    httpServletResponse.setContentType("application/postscript");
                } else if (string2.equalsIgnoreCase("abs")) {
                    httpServletResponse.setContentType("audio/x-mpeg");
                } else if (string2.equalsIgnoreCase("bin") || string2.equalsIgnoreCase("exe")) {
                    httpServletResponse.setContentType("application/octet-stream");
                } else if (string2.equalsIgnoreCase("class")) {
                    httpServletResponse.setContentType("application/java");
                } else if (string2.equalsIgnoreCase("jpe") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg")) {
                    httpServletResponse.setContentType("image/jpeg");
                } else if (string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("mpeg")) {
                    httpServletResponse.setContentType("video/mpeg");
                } else if (string2.equalsIgnoreCase("pic") || string2.equalsIgnoreCase("pict") || string2.equalsIgnoreCase("pict")) {
                    httpServletResponse.setContentType("image/pict");
                } else if (string2.equalsIgnoreCase("aif") || string2.equalsIgnoreCase("aifc") || string2.equalsIgnoreCase("aiff")) {
                    httpServletResponse.setContentType("audio/x-aiff");
                } else if (string2.equalsIgnoreCase("aim")) {
                    httpServletResponse.setContentType("application/x-aim");
                } else if (string2.equalsIgnoreCase("art")) {
                    httpServletResponse.setContentType("image/x-jg");
                } else if (string2.equalsIgnoreCase("asf") || string2.equalsIgnoreCase("asx")) {
                    httpServletResponse.setContentType("video/x-ms-asf");
                } else if (string2.equalsIgnoreCase("avi")) {
                    httpServletResponse.setContentType("video/x-msvideo");
                } else if (string2.equalsIgnoreCase("avx")) {
                    httpServletResponse.setContentType("video/x-rad-screenplay");
                } else if (string2.equalsIgnoreCase("body")) {
                    httpServletResponse.setContentType(" text/html");
                } else if (string2.equalsIgnoreCase("css")) {
                    httpServletResponse.setContentType("text/css");
                } else if (string2.equalsIgnoreCase("dib")) {
                    httpServletResponse.setContentType("image/bmp");
                } else if (string2.equalsIgnoreCase("gz")) {
                    httpServletResponse.setContentType("application/x-gzip");
                } else if (string2.equalsIgnoreCase("jar")) {
                    httpServletResponse.setContentType("application/java-archive");
                } else if (string2.equalsIgnoreCase("js")) {
                    httpServletResponse.setContentType("text/javascript");
                } else if (string2.equalsIgnoreCase("midi")) {
                    httpServletResponse.setContentType("audio/x-midi");
                } else if (string2.equalsIgnoreCase("rtf")) {
                    httpServletResponse.setContentType("application/rtf");
                } else if (string2.equalsIgnoreCase("rtx")) {
                    httpServletResponse.setContentType("text/richtext");
                } else if (string2.equalsIgnoreCase("tif") || string2.equalsIgnoreCase("tiff")) {
                    httpServletResponse.setContentType("image/tiff");
                } else if (string2.equalsIgnoreCase("xml") || string2.equalsIgnoreCase("xsl")) {
                    httpServletResponse.setContentType("text/xml");
                } else if (string2.equalsIgnoreCase("zip")) {
                    httpServletResponse.setContentType("application/zip");
                } else if (string2.equalsIgnoreCase("ppt")) {
                    httpServletResponse.setContentType("application/powerpoint");
                } else if (string2.equalsIgnoreCase("ppm")) {
                    httpServletResponse.setContentType("image/x-portable-pixmap");
                } else if (string2.equalsIgnoreCase("png")) {
                    httpServletResponse.setContentType("image/png");
                } else if (string2.equalsIgnoreCase("oda")) {
                    httpServletResponse.setContentType("application/oda");
                }
            } else if (string4.equals("REMOVE_ATTACHMENT")) {
                string3 = httpServletRequest.getParameter("DOC_ID");
                string = documentHandlerRemote.removeAttach(string3, string6, string5);
                byArray = string.getBytes();
            } else if (string4.equals("REMOVE_UNSAVE_ATTACHMENT")) {
                string3 = httpServletRequest.getParameter("DOC_NAME");
                string2 = httpServletRequest.getParameter("EDITOR_ID");
                object2 = dirName + File.separator + string2 + File.separator + string3;
                string = this.removeUnSaveAttachment((String)object2);
                byArray = string.getBytes();
            } else if (string4.equals("SAVE")) {
                string3 = this.getUser(httpServletRequest);
                string2 = httpServletRequest.getParameter("COMM_TEXT");
                string = documentHandlerRemote.saveComment(string6, string5, string2, string3);
                byArray = string.getBytes();
            } else if (string4.equals("UPLOAD_D0CMENT")) {
                string3 = this.loadFile(httpServletRequest, true);
                string2 = dirName + File.separator + string3;
                string = this.addDocument(httpServletRequest, string2, documentHandlerRemote);
                byArray = string.getBytes();
            } else if (string4.equals("UPLOAD_FOR_UNSAVED_TRANS")) {
                string3 = "";
                string2 = this.getUser(httpServletRequest);
                object2 = this.loadFile(httpServletRequest, false);
                object = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
                stringArray = new StringBuffer();
                stringArray.append("<Document>");
                stringArray.append("\n<ID Document_Id='" + string3 + "'>");
                stringArray.append("<Name><![CDATA[" + (String)object2 + "]]></Name>\n");
                stringArray.append("<Type><![CDATA[" + (String)object + "]]></Type>\n");
                stringArray.append("<Last_Modified><![CDATA[" + new Date(System.currentTimeMillis()) + "]]></Last_Modified>\n");
                stringArray.append("<Modified_By><![CDATA[" + string2 + "]]></Modified_By>\n");
                stringArray.append("<Created_Date><![CDATA[" + new Date(System.currentTimeMillis()) + "]]></Created_Date>\n");
                stringArray.append("<Created_By><![CDATA[" + string2 + "]]></Created_By>\n");
                stringArray.append("<CheckOut><![CDATA[" + string2 + "]]></CheckOut>\n");
                stringArray.append("</ID>");
                stringArray.append("\n</Document>");
                byArray = stringArray.toString().getBytes();
            } else if (string4.equals("SAVE_UNSAVED_ATTACHMENT")) {
                string3 = httpServletRequest.getParameter("RES_STR");
                string2 = httpServletRequest.getParameter("EDITOR_ID");
                object2 = dirName + File.separator + string2;
                System.out.println("*****dirPath in SAVE_UNSAVED_ATTACHMENT" + (String)object2);
                object = new File((String)object2);
                if (((File)object).exists()) {
                    stringArray = ((File)object).list();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string8 = (String)object2 + File.separator + stringArray[i];
                        System.out.println("filePath ******" + string8);
                        string = this.addDocument(httpServletRequest, string8, documentHandlerRemote);
                    }
                }
                byArray = string3.getBytes();
            } else if (string4.equals("UPDATE_D0CUMENT")) {
                string3 = this.loadFile(httpServletRequest, true);
                string = this.updateDocument(httpServletRequest, string3, documentHandlerRemote);
                byArray = string.getBytes();
            }
            if ("WEB".equalsIgnoreCase(string7)) {
                string3 = new ValidateXMLInput();
                string2 = string3.validate(CommonConstants.APPLICATION_CONTEXT + File.separator + "webitm" + File.separator + "xsl" + File.separator + "ITMAttachmentPage.xsl", string, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "attach", ".html");
                object2 = new FileInputStream(string2);
                object = new ByteArrayOutputStream();
                int n = -1;
                while ((n = ((FileInputStream)object2).read()) != -1) {
                    ((ByteArrayOutputStream)object).write(n);
                }
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            httpServletResponse.setBufferSize(byArray.length);
            servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception :DocumentHandlerServlet :handleDocument :==>");
            exception.printStackTrace();
            throw new ITMException(exception);
        }
    }

    private String removeUnSaveAttachment(String string) throws Exception {
        boolean bl = false;
        String string2 = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                bl = file.delete();
            }
            string2 = bl ? "<Root><Detail>Deleted Successfully</Detail></Root>" : "<Root><Detail>Deleted Failure</Detail></Root>";
        }
        catch (Exception exception) {
            System.out.println("Exception :DocumentHandlerServlet :removeUnSaveAttachment :==>");
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return string2;
    }

    private String addDocument(HttpServletRequest httpServletRequest, String string, DocumentHandlerRemote documentHandlerRemote) throws Exception {
        StringBuffer stringBuffer = null;
        String string2 = null;
        byte[] byArray = new byte[]{0};
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            String string3 = httpServletRequest.getParameter("REF_ID");
            System.out.println("***refId in DocumentHandler-----> " + string3);
            String string4 = this.getRefSer(httpServletRequest);
            System.out.println("***refSer -----> " + string4);
            String string5 = this.getUser(httpServletRequest);
            System.out.println("***User -----> " + string5);
            File file = new File(string);
            String string6 = string.substring(string.lastIndexOf(".") + 1);
            System.out.println("***extension -----> " + string6);
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = -1;
            while ((n = bufferedInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuffer.append("<DocumentRoot>");
            stringBuffer.append("<description>Datawindow Root</description>");
            stringBuffer.append("<group0>");
            stringBuffer.append("<description>Group0 description</description>");
            stringBuffer.append("<Header0>");
            stringBuffer.append("<description>Header0 members</description>");
            stringBuffer.append("<header>");
            stringBuffer.append("<ref_id><![CDATA[" + string3 + "]]></ref_id>");
            stringBuffer.append("<ref_ser><![CDATA[" + string4 + "]]></ref_ser>");
            stringBuffer.append("<doc_name><![CDATA[" + file.getName() + "]]></doc_name>");
            stringBuffer.append("<doc_type><![CDATA[" + string6 + "]]></doc_type>");
            stringBuffer.append("<created_by><![CDATA[" + string5 + "]]></created_by>");
            stringBuffer.append("</header>");
            stringBuffer.append("</Header0>");
            stringBuffer.append("</group0>");
            stringBuffer.append("</DocumentRoot>");
            string2 = documentHandlerRemote.addDocument(stringBuffer.toString(), byArray);
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in releasing file resource :");
                exception.printStackTrace();
            }
        }
        return string2;
    }

    private String updateDocument(HttpServletRequest httpServletRequest, String string, DocumentHandlerRemote documentHandlerRemote) throws Exception {
        StringBuffer stringBuffer = null;
        String string2 = null;
        byte[] byArray = new byte[]{0};
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            String string3 = httpServletRequest.getParameter("REF_ID");
            String string4 = this.getRefSer(httpServletRequest);
            String string5 = httpServletRequest.getParameter("DOC_TYPE");
            String string6 = httpServletRequest.getParameter("DOC_ID");
            String string7 = this.getUser(httpServletRequest);
            File file = new File(dirName + File.separator + string);
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = -1;
            while ((n = bufferedInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuffer.append("<DocumentRoot>");
            stringBuffer.append("<description>Datawindow Root</description>");
            stringBuffer.append("<group0>");
            stringBuffer.append("<description>Group0 description</description>");
            stringBuffer.append("<Header0>");
            stringBuffer.append("<description>Header0 members</description>");
            stringBuffer.append("<header>");
            stringBuffer.append("<doc_id><![CDATA[" + string6 + "]]></doc_id>");
            stringBuffer.append("<ref_id><![CDATA[" + string3 + "]]></ref_id>");
            stringBuffer.append("<ref_ser><![CDATA[" + string4 + "]]></ref_ser>");
            stringBuffer.append("<doc_name><![CDATA[" + string + "]]></doc_name>");
            stringBuffer.append("<doc_type><![CDATA[" + string5 + "]]></doc_type>");
            stringBuffer.append("<Modified_By><![CDATA[" + string7 + "]]></Modified_By>");
            stringBuffer.append("</header>");
            stringBuffer.append("</Header0>");
            stringBuffer.append("</group0>");
            stringBuffer.append("</DocumentRoot>");
            string2 = documentHandlerRemote.updateDocument(stringBuffer.toString(), byArray);
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in releasing file resource :[" + string + "]");
                exception.printStackTrace();
            }
        }
        return string2;
    }

    private String getRefSer(HttpServletRequest httpServletRequest) throws Exception {
        String string;
        String string2 = null;
        string2 = httpServletRequest.getParameter("REF_SER");
        if ((string2 == null || "null".equals(string2)) && (string = httpServletRequest.getParameter("OBJ_NAME")) != null && !"null".equals(string) && string.length() > 0) {
            DBAccessRemote dBAccessRemote = (DBAccessRemote)this.ctx.lookup("ibase/DBAccessEJB/remote");
            string2 = dBAccessRemote.getRefSer(null, string);
        }
        return string2;
    }

    private String getUser(HttpServletRequest httpServletRequest) throws Exception {
        String string = null;
        string = httpServletRequest.getParameter("USER");
        if (string == null || "null".equals(string)) {
            UserInfoBean userInfoBean = (UserInfoBean)httpServletRequest.getSession().getAttribute("USER_INFO");
            string = userInfoBean.getLoginCode();
        }
        return string;
    }

    private String loadFile(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        String string = null;
        File file = null;
        try {
            String string2;
            String string3;
            if (bl) {
                file = new File(dirName);
            } else {
                string3 = httpServletRequest.getParameter("EDITOR_ID");
                string2 = dirName + File.separator + string3;
                file = new File(string2);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            System.out.println("Document Upload");
            string3 = new MultipartParser(httpServletRequest, MAX_UPLOAD_SIZE);
            while ((string2 = string3.readNextPart()) != null) {
                String string4;
                ParamPart paramPart;
                String string5 = string2.getName();
                System.out.println("name**********" + string5);
                if (string2.isParam()) {
                    paramPart = (ParamPart)string2;
                    string4 = paramPart.getStringValue();
                    continue;
                }
                if (!string2.isFile()) continue;
                paramPart = (FilePart)string2;
                string = string4 = paramPart.getFileName();
                long l = paramPart.writeTo(file);
                File file2 = new File(file + File.separator + string4);
                if (!file2.exists()) continue;
                file2.renameTo(new File(file + File.separator + string));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception;
        }
        return string;
    }

    private void parseException(Exception exception, PrintWriter printWriter) {
        String string;
        String string2;
        String string3;
        String string4;
        block6: {
            string4 = "";
            string3 = "";
            string2 = "";
            string = "";
            String string5 = "";
            boolean bl = false;
            try {
                string5 = exception.getMessage();
                System.out.println("[DocumentUploadServlet]Exception Message :==>\n" + string5);
                if (string5.equals("")) break block6;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string5.getBytes());
                Document document = documentBuilder.parse(byteArrayInputStream);
                NodeList nodeList = document.getElementsByTagName("Error");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    string4 = nodeList2.item(0).getFirstChild().getNodeValue();
                    try {
                        FileWriter fileWriter = new FileWriter("four.prn");
                        fileWriter.write(string4);
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception exception2) {
                        System.out.println("Error in IMException-getMessage");
                    }
                    string3 = nodeList2.item(1).getFirstChild().getNodeValue();
                    string2 = nodeList2.item(2).getFirstChild().getNodeValue();
                    int n = 0;
                    while (string2.indexOf(10) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        int n2 = stringBuffer.toString().indexOf(10);
                        stringBuffer.replace(n2, n2 + 1, "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        string2 = stringBuffer.toString();
                        stringBuffer = null;
                        ++n;
                    }
                    string = nodeList2.item(3).getFirstChild().getNodeValue();
                }
            }
            catch (Exception exception3) {
                string3 = string5;
            }
        }
        printWriter.println("<HTML><BODY BGCOLOR='#EEEEEE'>");
        printWriter.println("<b>Message :</b>" + string4);
        printWriter.println("<br>");
        printWriter.println("<b>Description : </b>" + string3);
        printWriter.println("<br>");
        printWriter.println("<b>Trace : </b>" + string2);
        printWriter.println("<br>");
        printWriter.println("<b>Redirect : </b>" + string);
        printWriter.println("</BODY></HTML>");
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext initialContext = null;
        try {
            AppConnectParm appConnectParm = new AppConnectParm();
            initialContext = new InitialContext(appConnectParm.getProperty());
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception :DocumentHandlerServlet :getInitialContext :==>");
            throw new ITMException(exception);
        }
        return initialContext;
    }

    private void debug(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Parameter Name:" + string);
            System.out.println("Parameter Value:" + httpServletRequest.getParameter(string));
        }
    }
}

