package ibase.dashboard.mfg.servlet;

import ibase.dashboard.mfg.ejb.RecallDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class PlantWiseRecallServlet extends HttpServlet
{
	//private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		RecallDetailsRemote recallDetailsRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String lastMonth = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName    = request.getParameter("dataSourceName"); 
			lastMonth 		  = request.getParameter("lastMonth");
			System.out.println("in doPost lastMonth is ==:" + lastMonth  );
			
			context = new InitialContext(appConnectParm.getProperty());
			recallDetailsRemote = (RecallDetailsRemote) context.lookup("ibase/RecallDetails/remote");
			
			JSONObject jsonObjData      = (JSONObject)recallDetailsRemote.getPlantWiseRecallDetails(dataSourceName,lastMonth);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for PlantWiseRecallServlet build the Graph is===" + jsonObjData);	
			
			
		} catch (Exception e)
		{
			System.out.println("Exception : PlantWiseRecallServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}