/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "as" locale.
 */
public class LocalizedNamesImpl_as extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "AM",
        "AO",
        "AR",
        "AS",
        "AT",
        "AU",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BB",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BQ",
        "BS",
        "BT",
        "BW",
        "BY",
        "BZ",
        "CA",
        "CC",
        "CD",
        "CF",
        "CG",
        "CH",
        "CI",
        "CK",
        "CL",
        "CM",
        "CO",
        "CP",
        "CR",
        "CU",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DJ",
        "DK",
        "DM",
        "DO",
        "DZ",
        "EA",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ES",
        "ET",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GT",
        "GU",
        "GW",
        "GY",
        "HK",
        "HN",
        "HR",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IL",
        "IM",
        "IQ",
        "IR",
        "IS",
        "JE",
        "JM",
        "JO",
        "KE",
        "KG",
        "KH",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "IT",
        "AQ",
        "CN",
        "JP",
        "DE",
        "GS",
        "TF",
        "FR",
        "BV",
        "BR",
        "IO",
        "IN",
        "US",
        "GB",
        "HM",
        "RU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AQ", "এন্টাৰ্টিকা");
    namesMap.put("BR", "ব্ৰাজিল");
    namesMap.put("BV", "বভেট দ্বীপ");
    namesMap.put("CN", "চীন");
    namesMap.put("DE", "জাৰ্মানি");
    namesMap.put("FR", "ফ্ৰান্স");
    namesMap.put("GB", "সংযুক্ত ৰাজ্য");
    namesMap.put("GS", "দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ্‌ দ্বীপ");
    namesMap.put("HM", "হাৰ্ড দ্বীপ আৰু মেক্‌ডোনাল্ড দ্বীপ");
    namesMap.put("IN", "ভাৰত");
    namesMap.put("IO", "ব্ৰিটিশ্ব ইণ্ডিয়ান মহাসাগৰৰ অঞ্চল");
    namesMap.put("IT", "ইটালি");
    namesMap.put("JP", "জাপান");
    namesMap.put("RU", "ৰুচ");
    namesMap.put("TF", "দক্ষিণ ফ্ৰান্সৰ অঞ্চল");
    namesMap.put("US", "যুক্তৰাষ্ট্ৰ");
    namesMap.put("ZZ", "অজ্ঞাত বা অবৈধ অঞ্চল");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AQ": "এন্টাৰ্টিকা",
        "BR": "ব্ৰাজিল",
        "BV": "বভেট দ্বীপ",
        "CN": "চীন",
        "DE": "জাৰ্মানি",
        "FR": "ফ্ৰান্স",
        "GB": "সংযুক্ত ৰাজ্য",
        "GS": "দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ্‌ দ্বীপ",
        "HM": "হাৰ্ড দ্বীপ আৰু মেক্‌ডোনাল্ড দ্বীপ",
        "IN": "ভাৰত",
        "IO": "ব্ৰিটিশ্ব ইণ্ডিয়ান মহাসাগৰৰ অঞ্চল",
        "IT": "ইটালি",
        "JP": "জাপান",
        "RU": "ৰুচ",
        "TF": "দক্ষিণ ফ্ৰান্সৰ অঞ্চল",
        "US": "যুক্তৰাষ্ট্ৰ",
        "ZZ": "অজ্ঞাত বা অবৈধ অঞ্চল"
    };
  }-*/;
}
