/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Arrays;

public final class PhoneNumberMatch {
    private final int start;
    private final String match;
    private final Phonenumber.PhoneNumber number;

    PhoneNumberMatch(int start, String match, Phonenumber.PhoneNumber number) {
        if (start < 0) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (match == null || number == null) {
            throw new NullPointerException();
        }
        this.start = start;
        this.match = match;
        this.number = number;
    }

    public Phonenumber.PhoneNumber number() {
        return this.number;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.match.length();
    }

    public String rawString() {
        return this.match;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.start, this.match, this.number});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PhoneNumberMatch)) {
            return false;
        }
        PhoneNumberMatch other = (PhoneNumberMatch)obj;
        return this.match.equals(other.match) && this.start == other.start && this.number.equals(other.number);
    }

    public String toString() {
        return "PhoneNumberMatch [" + this.start() + "," + this.end() + ") " + this.match;
    }
}

