	/* Product Wizard : Screen-I */

	var calendertop = 100;
	var calenderleft = 200;
	var selectedObj = null;
	var global_date_format ="dd/MM/yy";
	var global_date_type= "date";
	
	function assignDate( date )
	{	
		document.getElementById( selectedObj ).value = date;
		document.getElementById( selectedObj ).focus();
	}
	
	function formatDate(d)
	{
	    var month = d.getMonth();
	    var day = d.getDate();
	    var year = d.getFullYear();
	    
	    year = year.toString().substr(2,2);
	    
	    month = month + 1;
	    month = month + "";

	    if (month.length == 1)
	    {
	        month = "0" + month;
	    }

	    day = day + "";

	    if (day.length == 1)
	    {
	        day = "0" + day;
	    }

	    return day +"/"+ month +"/"+ year;
	}
	
	function checkAll(element) 
	{
		var checkboxes = document.getElementsByTagName('input');
    
		if (element.checked) 
		{
			for (var i = 0; i < checkboxes.length; i++) 
			{
				if (checkboxes[i].type == 'checkbox') 
				{
					checkboxes[i].checked = true;
	            }
	        }
	    }
		else
		{
			for (var i = 0; i < checkboxes.length; i++) 
	        {
				if (checkboxes[i].type == 'checkbox') 
	            {
					checkboxes[i].checked = false;
	            }
	        }
		}
	}
	
	function setChecked(obj)
	{
		if( obj.value == 'false' )
		{
			obj.value ='true';
		}
		else 
		{
			obj.value = 'false';
		}
	}
	
	function setActionVal( value )
	{  
	   document.getElementById("action").value = value;
	}
	
	/* server response */
	
	var httpRequest; 
	var xmlHTTPResponse; 
	var isServerBusy = false;
	
	if (window.ActiveXObject)
	{ 
		httpRequest = new ActiveXObject("Microsoft.XMLHTTP"); 
	} 
	else if (window.XMLHttpRequest) 
	{ 
		httpRequest = new XMLHttpRequest(); 
	}
	
	function wizItemchange( sizeCode, objName)
	{
		objName = "wsfa_itemDetails";
		var url = "/ibase/ProdWizItemChangeServlet?SIZECODE="+sizeCode+"&OBJ_NAME="+objName;
		makeRequest( url, setColumnValues);
	}
	
	function makeRequest( url, setColumnValues )
	{
		var sURL = unescape(window.location);
	
		if( ! isServerBusy )
		{
	  		isServerBusy = true;
			httpRequest.open("POST", url, false);
			httpRequest.onreadystatechange = function()
			{
				receiveResponse( setColumnValues );
			};
		
			httpRequest.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded; charset=UTF-8" );
			httpRequest.send( null );
		}
	}

	function receiveResponse( setColumnValues )
	{
		if (httpRequest.readyState == 4)
		{
			if(httpRequest.status == 200) 
			{
		  		processResponse( setColumnValues );
			}
			else 
			{
				alert("Error loading page\n"+ httpRequest.status +":"+ httpRequest.statusText);
			}
		}
	}

	function processResponse( setColumnValues )
	{
	    var returnStr = null;
		isProcessOn = false;
		
		if ( window.ActiveXObject )
		{   
			xmldoc = httpRequest.responseText;
			xmlHTTPResponse = xmldoc;
		}
		else
		{   
			try
			{
		  		var parser = new DOMParser();
		  		xmldoc = httpRequest.responseText;
			}
			catch(e)
			{
		   		alert("inside catch:"+e.message);
			}
		}

		setColumnValues( xmldoc );
		isServerBusy = false;
	}
	
	function loadXMLString(txt)
	{
		if (window.DOMParser)
	  	{
	  		parser=new DOMParser();
	  		xmlDoc=parser.parseFromString(txt,"text/xml");
	  	}
		else /* code for IE*/
		{
	  		xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
	  		xmlDoc.async=false;
	  		xmlDoc.loadXML(txt);
	  	}
		
		return xmlDoc;
	}
	
	function setColumnValues( retVal )
	{
		var xmldoc = null;
		var isDotNotation = false;
		var count = 0;
		
		xmldoc = loadXMLString(retVal);
		
		if( xmldoc.nodeType != 9 )
		{
			return true;
		}
		
		var x = xmldoc.getElementsByTagName("Root")[0].childNodes;
		
		if (x.length > 0)
			appendSizesRow();
		
		for (var i = 0; i < x.length; i++) 
	    {
	    	if (x[i].nodeName != null)
	    	{
	    		var y = x[i].childNodes;
	    		
	    		var tr = tr + "<tr>";
	    		
	    		for (var j = 0; j < y.length; j++)
	    		{
	    			if (y[j].nodeName != null)
	    			{
						if (j == 0)
						{
							tr = tr + "<td><input type='checkbox' value="+ y[1].childNodes[0].nodeValue +" id=chkid"+count+" onClick='sizeValues()' /></td>";
							count++;
						}
						
						tr = tr + "<td>"+ y[j].childNodes[0].nodeValue +"</td>";
						
	    			}
	    		}
    			tr = tr + "</tr>";
	    	}
	    }
	    
	    $("#sizeDtl tbody").append(tr);
	}
	
	function callListJSP( dbID, loginId, field, fieldName, idNum )
	{
		var fieldValue = "";
		
		if (field == "item_parnt")
		{
			fieldValue = document.getElementById("Detail1.1.item_parnt").value;
		}
		else if (field == "item_type")
		{
			fieldValue = document.getElementById("Detail1.1.item_type").value;
		}
		else if (field == "item_ser") 
		{
			fieldValue = document.getElementById("Detail1.1.item_ser").value;
		}
		else if (field == "grp_code") 
		{
			fieldValue = document.getElementById("Detail1.1.grp_code").value;
		}
		else if (field == "site_codes") 
		{
			fieldValue = document.getElementById("Detail1.1.site_codes").value;
		}
		else if (field == "dimension_desc") 
		{
			fieldValue = document.getElementById("Detail1.1.dimension_desc").value;
		}
		else if (field == "color_codes") 
		{
			fieldValue = document.getElementById("Detail1.1.color_codes").value;
		}
		else if (field == "size_codes") 
		{
			fieldValue = document.getElementById("Detail1.1.size_codes").value;
		}
		else if (field == "item_category") 
		{
			fieldValue = document.getElementById("Detail1.1.item_category").value;
		}
		else if (field == "pricelist") 
		{
			idNum = idNum.substring(9, idNum.length);
			
			if (document.getElementById("prodsPriceList"+idNum) != null)
			{
				fieldValue = document.getElementById("prodsPriceList"+idNum).value;
			}
			else
			{
				if (document.getElementById("prodPriceList"+idNum) != null)
				{
					fieldValue = document.getElementById("prodPriceList"+idNum).value;
				}
			}
		}
		
		var url = "/ibase/webitm/jsp/ITMWizardItemTypeList.jsp?LOGIN_ID="+loginId+"&FIELDS="+field+"&DBID="+dbID+"&FIELDNAME="+fieldName+"&IDNUM="+idNum+"&FIELDVALUE="+fieldValue+",";
		var win = window.open( url, 'Product Details', 'toolbar=no,status=yes,resizable=no,scrollbars=yes,left=100,top=50,width=500,height=550' );
	}
	
	function displayValue(  fieldId, fieldValue, seldbID, field, idNum )
	{
		if (field == "item_parnt")
		{
			document.getElementById("Detail1.1.item_parnt").value = fieldId;
			document.getElementById("Detail1.1.item_parnt_desc").value = fieldValue;
		}
		else if (field == "item_type")
		{
			document.getElementById("Detail1.1.item_type").value = fieldId;
			document.getElementById("Detail1.1.item_type_desc").value = fieldValue;	
		}
		else if (field == "item_ser") 
		{
			document.getElementById("Detail1.1.item_ser").value = fieldId;
			document.getElementById("Detail1.1.itemser_descr").value = fieldValue;	
		}
		else if (field == "grp_code") 
		{
			document.getElementById("Detail1.1.grp_code").value = fieldId;
			document.getElementById("Detail1.1.grp_code_desc").value = fieldValue;	
		}
		else if (field == "site_codes") 
		{
			var site = fieldId.split(",");
			var siteDesc = fieldValue.split(",");
			var num = 0;
			var sites = "";
			
			if (fieldId != "")
			{
				document.getElementById("priceListTr").style.display = "";
				document.getElementById("priceListDtl").style.visibility = "visible";
				$("#priceListDtl tbody").empty();
			}
			
			for (var i = 0; i < site.length; i++)
			{
				var values = site[i].split(":");
				
				sites = sites + values[0] + ", ";
				
				createSitesTab(values[0], values[1], num, siteDesc[i]);
				num++;
			}
			
			sites = sites.substring(0, sites.length-2);
			
			document.getElementById("Detail1.1.site_codes").value = sites;
			document.getElementById("Detail1.1.site_desc").value = fieldValue;
			
			document.getElementById("site_codes").innerHTML = sites;
		}
		else if (field == "dimension_desc") 
		{
			document.getElementById("Detail1.1.dimension_desc").value = fieldId;
			
			document.getElementById("Detail1.1.dim_code_desc").value = fieldValue;
			
			document.getElementById("dimension_desc").innerHTML = fieldId;
		}
		else if (field == "color_codes") 
		{
			document.getElementById("Detail1.1.color_codes").value = fieldId;

			document.getElementById("Detail1.1.color_code_descr").value = fieldValue;
			
			document.getElementById("color_code_descr").innerHTML = fieldValue;
		}
		else if (field == "size_codes") 
		{
			document.getElementById("Detail1.1.size_codes").value = fieldId;
			
			wizItemchange(document.getElementById("Detail1.1.size_codes").value, "l");
		}
		else if (field == "item_category") 
		{
			document.getElementById("Detail1.1.item_category").value = fieldValue;
			
			document.getElementById("item_category").innerHTML = fieldValue;
		}
		else if (field == "pricelist") 
		{
			if (document.getElementById("prodsPriceList"+idNum) != null)
			{
				document.getElementById("prodsPriceList"+idNum).value = fieldId;
			}
			else
			{
				document.getElementById("prodPriceList"+idNum).value = fieldId;
			}
		}
	}
	
	function appendSizesRow() {
		
		$("#sizeDtl").remove();
		
		$("#sizeDtlDiv").append(
				
			"<table class='tableClass' id='sizeDtl' width='100%' style='text-align: left;'>" +
			
			"<thead><tr class='thClass'><th style='width:10%'><input type='checkbox' onclick='checkAllSizes(this)'></th><th>Sizes</th><th>Desc</th></tr></thead>" +
			
			"<tbody class='table-body fadeInDown'>" +
			
			"</tbody>" +
			
			"</table>"
		);
	}
	
	function checkAllSizes(element) 
	{
		checkAll(element);
		sizeValues();
	}
	
	function sizeValues()
	{
		var count = $('#sizeDtl tbody tr').length;

		var sizeDesc = "";
		
		/*alert("count "+count);*/
		
		for (var i = 0; i < count; i++)
		{
			if (document.getElementById("chkid"+i).checked == true)
			{
				sizeDesc = sizeDesc + document.getElementById("chkid"+i).value + ",";
			}
		}
		
		document.getElementById("Detail1.1.size_type").value = sizeDesc;
	}
	
	
	
	function checkNullvalidation()
	{
		/*if (document.getElementById("Detail1.1.item_parnt").value == "")
		{
			alert("Please Enter Parent Code.");
			return false;
		}
		else if (document.getElementById("Detail1.1.item_parnt_desc").value == "")
		{
			alert("Please Enter Parent Code Description.");
			document.getElementById("Detail1.1.item_parnt_desc").focus();
			return false;
		}*/
		if (document.getElementById("Detail1.1.item_type").value == "")
		{
			alert("Please Enter Product Type.");
			document.getElementById("Detail1.1.item_type").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.item_ser").value == "")
		{
			alert("Please Select Item Series.");
			document.getElementById("Detail1.1.item_ser").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.descr").value == "")
		{
			alert("Please Enter Item Description.");
			document.getElementById("Detail1.1.descr").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.grp_code").value == "")
		{
			alert("Please Select Group Code.");
			document.getElementById("Detail1.1.grp_code").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.site_codes").value == "")
		{
			alert("Please Select Site Availability.");
			document.getElementById("Detail1.1.site_codes").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.dimension_desc").value == "")
		{
			alert("Please Select Dimension.");
			document.getElementById("Detail1.1.dimension_desc").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.color_codes").value == "")
		{
			alert("Please Select Color Availability.");
			document.getElementById("Detail1.1.color_codes").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.size_codes").value == "")
		{
			alert("Please Select Size Availability.");
			document.getElementById("Detail1.1.size_codes").focus();
			return false;
		}
		else if (document.getElementById("Detail1.1.size_type").value == "")
		{
			alert("Please Select Size.");
			document.getElementById("Detail1.1.size_type").focus();
			return false;
		}
		else if (!setPriceListDetails())
		{
			return false;
		}
		
		document.getElementById("action").value = 'next';
		return true;
	}
	
	/* Product Wizard : Screen-II */
	
	function createSizeColorTab() {
		
		$("#sizeDtl").remove();
		
		$("#sizeDtlDiv").append(
				
			"<table class='tableClass' id='sizeDtl' width='99%' style='text-align: center;'>" +
			
			"</table>"
		);
		
		var size = sizes.split(",");
		var color = colors.split(",");
		
		var tr = "";
		
		tr = tr + "<thead><tr class='thClass'><th>Color/Size</th>";
		
		for (var i = 0; i < size.length-1; i++)
		{
			tr = tr + "<th>"+size[i]+"</th>";
		}
		
		tr = tr + "</thead></tr><tbody class='table-body'></tbody>";
		
		$("#sizeDtl").append(tr);
		
		var tr = "";
		
		for (var i = 0; i < color.length; i++)
		{
			tr = tr + "<tr><td>"+color[i]+"</td>";
			
			for (var j = 1; j < size.length; j++)
			{
				tr = tr + "<td>Y</td>";
			}
			
			tr = tr + "</tr>";
		}
			
		$("#sizeDtl tbody").append(tr);
	}
	
	function displaySKUItemDetails()
	{
		var size = sizes.split(",");
		var color = colors.split(",");
		var dimension = dimensions.split(",");
		
		var srno = 0;
		
		var code = "";
		
		for (var i = 0; i < dimension.length; i++)
		{
			for (var j = 0; j < color.length; j++)
			{
				for (var k = 0; k < size.length-1; k++)
				{
					srno++;

					code = itemDesc + " " + size[k] + " " + color[j] + " " + dimension[i];
					
					/*alert("value :"+ code);*/
					
					createProdTab(srno, code, size[k], color[j], dimension[i]);
				}
			}
		}
	}
	
	function createProdTab(srno, itemDesc, size, color, dimension)
	{
		/*itemDesc = itemDesc.replace("-"," "); itemDesc.replace(/-/g,' ')*/
		$("#SKUItemId tbody").append(
		
			"<tr>"+
			
				"<td width='5px;'><input type='checkbox' checked='checked' /></td>"+
				"<td width='50px;'><input type='hidden' id=srno"+srno+" name=srno"+srno+" />"+ srno +"</td>"+
				"<td width='450px;'><input type='hidden' id=prodDesc"+srno+" name=prodDesc"+srno+" />"+ itemDesc +"</td>"+
				"<td width='100px;'><input type='hidden' id=prodSize"+srno+" name=prodSize"+srno+" />"+ size +"</td>"+
				"<td width='200px'><input type='hidden' id=prodColor"+srno+" name=prodColor"+srno+" />"+ color +"</td>"+
				"<td width='200px'><input type='hidden' id=prodDim"+srno+" name=prodDim"+srno+" />"+ dimension +"</td>"+
				"<td width='70px'><input type='text' id=prodLength"+srno+" size='5' style='text-align: right;' onchange='return isNumeric(this)'/></td>"+
				"<td width='70px'><input type='text' id=prodWidth"+srno+" size='5' style='text-align: right;' onchange='return isNumeric(this)'/></td>"+
				"<td width='70px'><input type='text' id=prodHeight"+srno+" size='5' style='text-align: right;' onchange='return isNumeric(this)'/></td>"+
				"<td width='70px'><input type='text' id=prodWeight"+srno+" size='5' style='text-align: right;' onchange='return isNumeric(this)'/></td>"+
				"<td width='70px'><input type='hidden' id=prodPrice"+srno+" name=prodPrice"+srno+" /><a href='#' id=prodPriceLink"+srno+" onclick='MakePopup(event, this.id);'>Click for PriceList</a></td>"+
			
			"</tr>"
		);
		
		document.getElementById("prodDesc"+srno).value = itemDesc;
		document.getElementById("prodSize"+srno).value = size;
		document.getElementById("prodColor"+srno).value = color;
		document.getElementById("prodDim"+srno).value = dimension;
	}
	
	function isNumeric(element) 
	{
		if (isNaN(parseFloat(element.value)))
		{
			document.getElementById(""+element.id).value = "0.000";
        	setTimeout(function(){element.focus();}, 1);
        	return false;
		}
		
		if (element.value == "")
			element.value = 0;
		
		document.getElementById(""+element.id).value = (parseFloat(element.value)).toFixed(3);
		return true;
	}
	
	function isValidCosts(element) 
	{
		var idNum = (element.id).substring(9,(element.id).length);
		
		if (isNumeric(element))
		{
			if (document.getElementById("prodsRate"+idNum).value < document.getElementById("prodsCost"+idNum).value)
			{
				alert("Cost should be less than Unit Rate.");
				document.getElementById("prodsCost"+idNum).value = "0.000";
				setTimeout(function(){element.focus();}, 1);
				return false;
			}
		}

		return true;
	}
	
	function isValidCost(element) 
	{
		var idNum = (element.id).substring(8,(element.id).length);
		
		if (isNumeric(element))
		{
			if (document.getElementById("prodRate"+idNum).value < document.getElementById("prodCost"+idNum).value)
			{
				alert("Cost should be less than Unit Rate.");
				document.getElementById("prodCost"+idNum).value = "0.000";
				setTimeout(function(){element.focus();}, 1);
				return false;
			}
		}

		return true;
	}
	
	function expandDiv()
	{
		if (document.getElementById("showDiv").value == "1")
		{
			document.getElementById("headerDiv").style.visibility = 'hidden';
			document.getElementById("headerDiv").style.height = 0+"%";
			document.getElementById("detailDiv").style.height = 99+'%';
			document.getElementById("detail").style.height = 70+'%';
			document.getElementById("showDiv").value = "0";
			document.getElementById("showDiv").src = "/ibase/webitm/images/DD/collapse1.png";
			document.getElementById("showDiv").title = "Collapse";
		}
		else
		{
			document.getElementById("headerDiv").style.visibility = 'visible';
			document.getElementById("headerDiv").style.height = 40+"%";
			document.getElementById("detailDiv").style.height = 60+'%';
			document.getElementById("detail").style.height = 150+'px';
			document.getElementById("showDiv").value = "1";
			document.getElementById("showDiv").src = "/ibase/webitm/images/DD/expand1.png";
			document.getElementById("showDiv").title = "Expand";
		}
	}
	
	/* ****** Creating Div Start ********** */
	
    var popupWindow = null;
    var popupIsShown = false;
    
    function MakePopup (event, prodDescId) {
        if (window.createPopup) {        
            if (!popupWindow) {
                popupWindow = window.createPopup ();
                var popupBody = popupWindow.document.body;
                popupBody.style.backgroundColor = "lightblue";
                popupBody.style.border = "solid black 1px";
                popupBody.innerHTML = "";
            }
            popupWindow.show (100, 100, 150, 25, document.body);
        }
        else {
            if (!popupIsShown) {
                if (!popupWindow) {
                    popupWindow = document.createElement ("div");
                    popupWindow.id = "someID";
                    popupWindow.style.backgroundColor = "lightblue";
                    popupWindow.style.border = "solid black 1px";
                    popupWindow.style.position = "absolute";
                    /*popupWindow.style.width = "400px";*/
                    popupWindow.style.height = "300px";
                    popupWindow.style.top = "60px";
                    popupWindow.style.right = "100px";
                    popupWindow.className = "fadeInDown";
                    
                    /*document.getElementById("someID").appendChild(document.getElementById("sizeDtl"));*/
                    
                    /*popupWindow.innerHTML = document.getElementById("sizeDtl").innerHTML;*/
                }

                document.body.appendChild (popupWindow);
                
                displaySKUPriceDetails(prodDescId);
                
                $("#someID").append(document.getElementById("priceListDiv"));
                
                /*window.addEventListener ('click', RemovePopup, true);*/
                popupIsShown = true;

                event.stopPropagation ();
            }
        }
    }

    function RemovePopup (event) {
    	
        if (popupIsShown) {
            var relation = popupWindow.compareDocumentPosition (event.target);
            var clickInPopup = (event.target == popupWindow) || (relation & Node.DOCUMENT_POSITION_CONTAINED_BY);
            if (!clickInPopup) {
                document.body.removeChild (popupWindow);
                window.removeEventListener ('click', RemovePopup, true);
                popupIsShown = false;
            }
        } 
    }
    
    function closePopup()
    {
    	$('#someID').remove();
    	popupIsShown = false;
    }
    
    /* ****** Creating Div End ********** */
    
    /* ****** Screen - I PriceList Table ********** */
    
	function createPriceListTab(site, no, idNum, siteDesc)
	{
		$("#SKUPriceListId tbody").append(
		
			"<tr>"+
			
				"<td><input type='checkbox' checked='checked' id=chksite"+no+" /></td>"+
				"<td><input type='hidden' id=prodSite"+no+" value="+ site +" /><lable id=lblSites"+no+">"+ site +"</lable></td>"+
				"<td>" +
					"<input type='text' id=prodPriceList"+no+" class='editInputClass' size='8' />" +
					"<div style='float:right;position:relative; width: 12px;'>" +
						/*"<div class='pophelp-Btn' id=priceList"+no+" style='margin-top: -20px;'>?</div>" +*/
						"<img src='/ibase/webitm/images/DD/popup1.png' id=priceList"+no+" style='margin-left: -5px; margin-top: -20px;' />" +
					"</div>" +
				"</td>"+
				/*"<td><input type='text' id=prodPriceList"+no+" class='editInputClass' size='15' /></td>"+*/
				"<td>" +
					"<input type='text' id=prodRate"+no+" class='editInputClass' size='10' style='text-align: right;' onchange='return isNumeric(this)' />" +
				"</td>"+
				
				"<td>" +
					"<input type='text' id=prodCost"+no+" class='editInputClass' size='10' style='text-align: right;' onchange='return isValidCost(this)' />" +
				"</td>"+
				
				"<td>" +
					"<input type='text' id=dtFrom"+no+" class='editInputClass' size='8' style='text-align: right;' />" +
					/*"<div style='float:right;position:relative; width: 12px;'>" +
						"<div class='pophelp-Btn' id=fromDt"+no+" style='margin-top: -20px; margin-left: 10px;'>[]</div>" +
					"</div>" +*/
				"</td>"+
				
				"<td>" +
					"<input type='text' id=dtTo"+no+" class='editInputClass' size='8' style='text-align: right;' />" +
					/*"<div style='float:right;position:relative; width: 12px;'>" +
						"<div class='pophelp-Btn' id=toDt"+no+" style='margin-top: -20px; margin-left: 10px;'>[]</div>" +
					"</div>" +*/
				"</td>"+
			
			"</tr>"
		);
		
		$( "#dtFrom"+no ).datepicker(
			{ changeMonth: true, changeYear: true,
				onSelect: function( selectedDate ) {
				/*$( "#dtTo"+no ).datepicker( "option", "minDate", selectedDate );*/
				$( "#dtFrom"+no ).datepicker( "option", "dateFormat", "dd/mm/y" );
			}
		});
		
		$( "#dtTo"+no ).datepicker(
			{ changeMonth: true, changeYear: true,
				onSelect: function( selectedDate ) {
				$( "#dtFrom"+no ).datepicker( "option", "maxDate", selectedDate );
				$( "#dtTo"+no ).datepicker( "option", "dateFormat", "dd/mm/y" );
			}
		});
		
		document.getElementById("lblSites"+no).title = siteDesc;
		
		/*document.getElementById("fromDt"+no).setAttribute("onclick", "selectedObj = 'dtFrom"+no+"'; javascript:show_calendar('dtFrom"+no+"','','','DD/MM/YY');");
		document.getElementById("toDt"+no).setAttribute("onclick", "selectedObj = 'dtTo"+no+"'; javascript:show_calendar('dtTo"+no+"','','','DD/MM/YY');");*/
		document.getElementById("priceList"+no).setAttribute("onclick", "javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','pricelist', 'Price List', this.id);");
	}
	
	function displaySKUPriceDetails(prodDescId)
	{
		var site = sites.split(",");
		var siteDesc = sitedesc.split(",");
		
		var idNum = prodDescId.substring(8, prodDescId.length-14);
		
		document.getElementById("idNum").value = idNum;
		
		document.getElementById("SKUPriceListCaption").innerHTML = ""+document.getElementById("Detail2."+idNum+".item_descr").value;
		
		$("#SKUPriceListId tbody").empty();
		
		for (var i = 0; i < site.length; i++)
		{
			createPriceListTab(site[i], i, idNum, siteDesc[i]);
		}
		
		var prodPrices = document.getElementById("Detail2."+idNum+".price_list_dtl").value;
		
		if (prodPrices != "")
		{
			/*alert("in loop "+ prodPrices);*/
			
			var prodPrice = prodPrices.split("||");
			
			for (var i = 0; i < prodPrice.length; i++)
			{
				var prodPrice1 = prodPrice[i].split(":");
				
				if (prodPrice1[0] == 1)
				{
					document.getElementById("chksite"+i).checked = true;
				}
				else
				{
					document.getElementById("chksite"+i).checked = false;
				}
				document.getElementById("prodSite"+i).value = prodPrice1[1];
				document.getElementById("prodPriceList"+i).value = prodPrice1[2];
				document.getElementById("prodRate"+i).value = prodPrice1[3];
				document.getElementById("prodCost"+i).value = prodPrice1[4];
				document.getElementById("dtFrom"+i).value = prodPrice1[5];
				document.getElementById("dtTo"+i).value = prodPrice1[6];
			}
		}
	}
	
	function setPrice() {
		
		var idNum = document.getElementById("idNum").value;
    	
    	var count = $('#SKUPriceListId tbody tr').length;
    	var check = 0, price1 = "";
    	
    	for (var i = 0; i < count; i++)
    	{
    		var prodChk = 0;
    		
    		if (document.getElementById("chksite"+i).checked == true)
    		{
    			prodChk = 1; 
    		}
			
    		var prodSite = document.getElementById("prodSite"+i).value;
    		var prodPriceList = document.getElementById("prodPriceList"+i).value;
			var prodRate = document.getElementById("prodRate"+i).value;
			var prodCost = document.getElementById("prodCost"+i).value;
			var dtFrom = document.getElementById("dtFrom"+i).value;
			var dtTo = document.getElementById("dtTo"+i).value;
			
			if (document.getElementById("chksite"+i).checked == true)
    		{
				if (prodPriceList == "")
				{
					alert("Please Select Price List for Site '"+ prodSite +"'.")
					document.getElementById("prodPriceList"+i).focus();
					check = 1;
				}
				else if (prodRate == "")
				{
					alert("Please Enter Rate for Site '"+ prodSite +"'.")
					document.getElementById("prodRate"+i).focus();
					check = 1;
				}
				else if (prodCost == "")
				{
					alert("Please Enter Cost for Site '"+ prodSite +"'.")
					document.getElementById("prodCost"+i).focus();
					check = 1;
				}
				else if (dtFrom == "")
				{
					alert("Please Select From Date List for Site '"+ prodSite +"'.")
					document.getElementById("dtFrom"+i).focus();
					check = 1;
				}
				else if (dtFrom.length == 10)
				{
					alert("Please Select Valid From Date for Site '"+ prodSite +"'.")
					document.getElementById("dtFrom"+i).focus();
					check = 1;
				}
				else if (dtTo == "")
				{
					alert("Please Select To Date List for Site '"+ prodSite +"'.")
					document.getElementById("dtTo"+i).focus();
					check = 1;
				}
				else if (dtTo.length == 10)
				{
					alert("Please Select To Date List for Site '"+ prodSite +"'.")
					document.getElementById("dtTo"+i).focus();
					check = 1;
				}
    		}
			
			price1 = price1 + "||" + prodChk + ":" + prodSite + ":" + prodPriceList + ":" + prodRate + ":" + prodCost + ":" + dtFrom + ":" + dtTo;
    	}
    	
    	document.getElementById("Detail2."+idNum+".price_list_dtl").value = price1.substring(2,price1.length);
    	
    	if (check == 0)
    	{
    		$('#someID').remove();
    		popupIsShown = false;
    	}
	}

	/* ********** Screen - I PriceList Table ********** */
	
	function createSitesTab(site, price, num, siteDesc)
	{
		$("#priceListDtl tbody").append(
				
			"<tr >"+
			
				"<td width='80%'><input type='hidden' id=prodsSite"+num+" value="+ site +" /><lable id=lblSite"+num+">"+ site +"</lable></td>"+
				
				"<td width='5%'>" +
					"<input type='text' class='editInputClass' id=prodsPriceList"+num+" value='"+ price +"' size='8' />" +
					"<div style='float:right;position:relative; width: 12px;'>" +
						/*"<div class='pophelp-Btn' id=priceList"+num+" style='margin-top: -20px;'>?</div>" +*/
						"<img src='/ibase/webitm/images/DD/popup1.png' id=priceList"+num+" style='margin-left: -5px; margin-top: -20px;' />" +
					"</div>" +
				"</td>"+

				"<td width='5%'>" +
					"<input type='text' class='editInputClass' id=prodsRate"+num+" size='10' value='0.000' style='text-align: right;' onchange='return isNumeric(this)' />" +
				"</td>" +
				
				"<td width='5%'>" +
					"<input type='text' class='editInputClass' id=prodsCost"+num+" size='10' value='0.000' style='text-align: right;' onchange='return isValidCosts(this)' />" +
				"</td>" +
				
				"<td width='5%'>" +
					"<input type='text' class='editInputClass' id=dtsFrom"+num+" size='8'  style='text-align: right;' />" +
					/*"<div style='float:right;position:relative; width: 12px;'>" +
						"<div class='pophelp-Btn' id=fromDt"+num+" style='margin-top: -20px; margin-left: 8px;'>[]</div>" +
					"</div>" +*/
				"</td>"+
				
				"<td width='5%'>" +
					"<input type='text' class='editInputClass' id=dtsTo"+num+" size='8' style='text-align: right;' />" +
					/*"<div style='float:right;position:relative; width: 12px;'>" +
						"<div class='pophelp-Btn' id=toDt"+num+" style='margin-top: -20px; margin-left: 8px;'>[]</div>" +
					"</div>" +*/
				"</td>"+
			
			"</tr>"
		);
		
		var currDate = new Date();
		
		var tommorrowDate = new Date();
		
		tommorrowDate.setDate(currDate.getDate() + 1);
	    		
		document.getElementById("lblSite"+num).title = siteDesc;
		
		/*document.getElementById("dtsFrom"+num).value = formatDate(currDate);
		document.getElementById("dtsTo"+num).value = formatDate(tommorrowDate);*/
		
		/*minDate: -20, maxDate: "+1M +10D", changeMonth: true, changeYear: true,*/
		
		var selectedDate = formatDate(currDate);
		
		$( "#dtsFrom"+num ).datepicker(
			{ changeMonth: true, changeYear: true,
				onSelect: function( selectedDate ) {
					/*$( "#dtsTo"+num ).datepicker( "option", "minDate", selectedDate );*/
					$( "#dtsFrom"+num ).datepicker( "option", "dateFormat", "dd/mm/y" );
			}
		});
		
		$( "#dtsTo"+num ).datepicker(
			{ changeMonth: true, changeYear: true,
				onSelect: function( selectedDate ) {
					$( "#dtsFrom"+num ).datepicker( "option", "maxDate", selectedDate );
					$( "#dtsTo"+num ).datepicker( "option", "dateFormat", "dd/mm/y" );
			}
		});
		
		/*document.getElementById("fromDt"+num).setAttribute("onclick", "selectedObj = 'dtsFrom"+num+"'; javascript:show_calendar('dtsFrom"+num+"','','','DD/MM/YY');");
		document.getElementById("toDt"+num).setAttribute("onclick", "selectedObj = 'dtsTo"+num+"'; javascript:show_calendar('dtsTo"+num+"','','','DD/MM/YY');");*/
		document.getElementById("priceList"+num).setAttribute("onclick", "javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','pricelist', 'Price List', this.id);");
	}
	
	function setPriceListDetails()
	{
		var count = $('#priceListDtl tbody tr').length;
		
		var price = "";
    	
    	for (var i = 0; i < count; i++)
    	{
    		var prodSite = document.getElementById("prodsSite"+i).value;
    		var prodPriceList = document.getElementById("prodsPriceList"+i).value;
			var prodRate = document.getElementById("prodsRate"+i).value;
			var prodCost = document.getElementById("prodsCost"+i).value;
			var dtFrom = document.getElementById("dtsFrom"+i).value;
			var dtTo = document.getElementById("dtsTo"+i).value;
			
			if (prodPriceList == "")
			{
				alert("Please Select Price List for Site '"+ prodSite +"'.");
				document.getElementById("prodsPriceList"+i).focus();
				return false;
			}
			else if (prodRate == "")
			{
				alert("Please Enter Rate for Site '"+ prodSite +"'.");
				document.getElementById("prodsRate"+i).focus();
				return false;
			}
			else if (prodCost == "")
			{
				alert("Please Enter Cost for Site '"+ prodSite +"'.");
				document.getElementById("prodsCost"+i).focus();
				return false;
			}
			else if (dtFrom == "")
			{
				alert("Please Select From Date for Site '"+ prodSite +"'.");
				document.getElementById("dtsFrom"+i).focus();
				return false;
			}
			else if (dtFrom.length == 10)
			{
				alert("Please Select Valid From Date for Site '"+ prodSite +"'.");
				document.getElementById("dtsFrom"+i).focus();
				return false;
			}
			else if (dtTo == "")
			{
				alert("Please Select To Date for Site '"+ prodSite +"'.");
				document.getElementById("dtsTo"+i).focus();
				return false;
			}
			else if (dtTo.length == 10)
			{
				alert("Please Select Valid To Date for Site '"+ prodSite +"'.");
				document.getElementById("dtsTo"+i).focus();
				return false;
			}
			else
			{
				price = price + "||1:" + prodSite + ":" + prodPriceList + ":" + prodRate + ":" + prodCost + ":" + dtFrom + ":" + dtTo;
			}
			
    	}
    	
    	document.getElementById("Detail1.1.price_list_dtl").value = price.substring(2,price.length);
    	
    	return true;
    	
    	/*alert("price_list_dtl "+ price);*/
	}
	
	/**************** Popup Jsp ***********************/
	
	var maxId = 0;
	function gotBlur(obj) 
	 {
		if((oldVal != obj.value) || (obj.ISCHANGED == "true"))
		{
			obj.ISCHANGED = "true"; 
		}
	 }

	function gotFocus( column )
	{
		objCur=column.name; 
		oldVal=column.value; 
	}

	function selectValue()
	{
		var fieldId = "";
		var fieldValue = "";
		var seldbID ="";
		
		var field = document.getElementById("value").value;
		
		for( dbID = 1; dbID <= maxId; dbID++)
		{
			if( document.getElementById("DetailITCode."+dbID+".selectbox").value == 'true' )
			{
				seldbID = seldbID + dbID;
				if ( field == "site_codes")
				{
					fieldId = fieldId + document.getElementById("DetailITCode."+dbID+".fieldId").value + ":" + document.getElementById("DetailITCode."+dbID+".otherField").value + ", ";
				}
				else
				{
					fieldId = fieldId + document.getElementById("DetailITCode."+dbID+".fieldId").value + ", ";
				}
				fieldValue = fieldValue + document.getElementById("DetailITCode."+dbID+".fieldValue").value + ", ";
			}
		}
		
		fieldId = fieldId.substring(0, fieldId.length-2);
		fieldValue = fieldValue.substring(0, fieldValue.length-2);
		
		if( fieldId == "" )
		{
			alert("No Selection Made ! \nPlease Select the Code !");
		}
		else
		{
			var check = 0;
			var idNum = document.getElementById("idNum").value;
			
			if ( field == "pricelist")
			{
				var rows = 0;
				
				if (window.opener.document.getElementById('priceListDtl') != null)
				{
					rows = window.opener.document.getElementById('priceListDtl').getElementsByTagName('tbody')[0].getElementsByTagName('tr').length;
				}
				else
				{
					if (window.opener.document.getElementById('SKUPriceListId') != null)
					{
						rows = window.opener.document.getElementById('SKUPriceListId').getElementsByTagName('tbody')[0].getElementsByTagName('tr').length;
					}
				}
				
				/*alert("in if "+ rows);*/
				
				for (var i = 0; i < rows; i++)
				{
					if (window.opener.document.getElementById('prodsPriceList'+i) != null && i != idNum)
					{
						if (window.opener.document.getElementById('prodsPriceList'+i).value == fieldId)
						{
							check = 1;
							alert("Price List is already Selected. \nPlease Select Different Price List.");
						}
					}
					else
					{
						if (window.opener.document.getElementById('prodPriceList'+i) != null && i != idNum)
						{
							if (window.opener.document.getElementById('prodPriceList'+i).value == fieldId)
							{
								check = 1;
								alert("Price List is already Selected. \nPlease Select Different Price List.");
							}
						}
					}
				}
			}
			
			/*if (idNum != 0) 
				idNum = idNum.substring(9, idNum.length);*/
			if (check == 0)
			{
				window.opener.displayValue( fieldId, fieldValue, seldbID, field, idNum );
				window.close();
			}
		}
	}
	
	function checkAllPopup(element) 
	{
		var field = document.getElementById("value").value;
		
		if (field == "site_codes" || field == "color_codes" || field == "dimension_desc" || field == "item_category")
		{
			for( dbID = 1; dbID <= maxId; dbID++)
			{
				objCurr = document.getElementById("DetailITCode."+dbID+".selectbox");
				
				if (element.checked) 
				{
					objCurr.checked = true;
					objCurr.value = 'true';
				}
				else
				{
					objCurr.checked = false;
					objCurr.value = 'false';
				}
			}
		}
		else
		{
			return false;
		}
		
		return true;
	}

	function setCheckedPopup( obj )
	{
		var field = document.getElementById("value").value;
		
		if (field == "site_codes" || field == "color_codes" || field == "dimension_desc" || field == "item_category")
		{
			for( dbID = 1; dbID <= maxId; dbID++)
			{
				objCurr = document.getElementById("DetailITCode."+dbID+".selectbox");
				if( objCurr.checked == true )
				{
					objCurr.value = 'true';
				}
				else
				{
					objCurr.value = 'false';
				}
			}
		}
		else
		{
			for( dbID = 1; dbID <= maxId; dbID++)
			{
				objCurr = document.getElementById("DetailITCode."+dbID+".selectbox");
				if( objCurr.value == 'true' )
				{
					objCurr.value ='false';
					objCurr.checked = false;
				}
			}
			if( obj.value == 'false' )
			{
				obj.value = 'true';
				obj.checked = true;
			}
			else
			{
				obj.value = 'false';
				obj.checked = false;
			}
		}
	}
	
	function checkAllSKUItem(element)
	{
		var maxId = $('#SKUItemId tbody tr').length;;
		
		for( dbID = 1; dbID <= maxId; dbID++)
		{
			objCurr = document.getElementById("Detail2."+dbID+".selectbox");
			
			if (element.checked) 
			{
				objCurr.checked = true;
				objCurr.value = 'true';
			}
			else
			{
				objCurr.checked = false;
				objCurr.value = 'false';
			}
		}
	}
	
	function pageLoad()
	{
		var sites = document.getElementById("Detail1.1.site_codes").value;
		
		var sitesDescs = document.getElementById("Detail1.1.site_desc").value;
		
		if (sites != "")
		{
			var site = sites.split(",");
			var siteDesc = sitesDescs.split(",");
			var num = 0;
			
			document.getElementById("priceListTr").style.display = "";
			document.getElementById("priceListDtl").style.visibility = "visible";
			$("#priceListDtl tbody").empty();
			
			for (var i = 0; i < site.length; i++)
			{
				createSitesTab(site[i], "", num, siteDesc[i]);
				num++;
			}
			
			var priceListDtl = document.getElementById("Detail1.1.price_list_dtl").value;
			
			if (priceListDtl != "")
			{
				var prodPrice = priceListDtl.split("||");
				
				for (var i = 0; i < prodPrice.length; i++)
				{
					var prodPrice1 = prodPrice[i].split(":");
					
					document.getElementById("prodsSite"+i).value = prodPrice1[1];
					document.getElementById("prodsPriceList"+i).value = prodPrice1[2];
					document.getElementById("prodsRate"+i).value = prodPrice1[3];
					document.getElementById("prodsCost"+i).value = prodPrice1[4];
					document.getElementById("dtsFrom"+i).value = prodPrice1[5];
					document.getElementById("dtsTo"+i).value = prodPrice1[6];
				}
			}
		}
		
		var sizes = document.getElementById("Detail1.1.size_codes").value;
		
		if (sizes != "")
		{
			wizItemchange(sizes, "l");
			
			var sizeDesc = document.getElementById("Detail1.1.size_type").value;
			
			var size = sizeDesc.split(",");
			
			var count = $('#sizeDtl tbody tr').length;
			
			for (var i = 0; i < count; i++)
			{
				for (var j = 0; j < size.length; j++)
				{
					if (document.getElementById("chkid"+i).value == size[j])
					{
						document.getElementById("chkid"+i).checked = true;
					}
				}
			}
		}
	}