package ibase.dashboard.scm.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class SalesPerformance extends ValidatorEJB implements SalesPerformanceRemote, SalesPerformanceLocal
{
	/**
	 * Default constructor.
	 */
	private JSONObject jsonMetaData = null;
	private JSONObject jsonData = null;

	public SalesPerformance()
	{

	}
	//Method :1 for Grid
	public JSONObject getGridData(String dataSourceName,String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		List<String> dataList = new ArrayList<String>();
		String sql = "";
		sql = " SELECT a.divGRP,b.div_no||'. '||b.div_descr AS DIVISION, " 
			+ " ROUND(a.sale_mth_cy/100000,2) AS MTH_CY_SALES, " 
			+ " ROUND(a.sale_mth_ly/100000,2) AS MTH_LY_SALES,  "
			+ " (CASE WHEN a.sale_mth_ly<>0 THEN ROUND((a.sale_mth_cy - a.sale_mth_ly)/a.sale_mth_ly*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS MTH_GR, " 
			+ " ROUND(a.hotrgt_mth_cy/100000,2) AS MTH_HO_TRGT, " 
			+ " ROUND(a.trgt_mth_cy/100000,2) AS MTH_FLD_TRGT, "
			+ " (CASE WHEN a.hotrgt_mth_cy<>0 THEN ROUND(a.sale_mth_cy/a.hotrgt_mth_cy*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS MTH_HO_ACH, " 
			+ " (CASE WHEN a.trgt_mth_cy<>0 THEN ROUND(a.sale_mth_cy/a.trgt_mth_cy*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS MTH_FLD_ACH," 
			+ " ROUND(a.sale_ytd_cy/100000,2) AS YTD_CY_SALES, " 
			+ " ROUND(a.sale_ytd_ly/100000,2) AS YTD_LY_SALES,  " 
			+ " (CASE WHEN a.sale_ytd_ly<>0 THEN ROUND((a.sale_ytd_cy - a.sale_ytd_ly)/a.sale_ytd_ly*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS YTD_GR, " 
			+ " ROUND(a.hotrgt_ytd_cy/100000,2) AS YTD_HO_TRGT, " 
			+ " ROUND(a.trgt_ytd_cy/100000,2) AS YTD_FLD_TRGT, " 
			+ " (CASE WHEN a.hotrgt_ytd_cy<>0 THEN ROUND(a.sale_ytd_cy/a.hotrgt_ytd_cy*100,1)||'%'    " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS YTD_HO_ACH, " 
			+ " (CASE WHEN a.trgt_ytd_cy<>0 THEN ROUND(a.sale_ytd_cy/a.trgt_ytd_cy*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS YTD_FLD_ACH,  " 
			+ " ROUND(a.sale_Qrt1_cy/100000,2) AS Q1," 
			+ " ROUND(a.sale_Qrt2_cy/100000,2) AS Q2,  " 
			+ " ROUND(a.sale_Qrt3_cy/100000,2) AS Q3,  " 
			+ " ROUND(a.sale_Qrt4_cy/100000,2) AS Q4,  " 
			+ " ROUND(a.sale_ytd_cy/100000/    " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR( '"+month+"',5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) " 
			+ " ,2) AS PMPM,  " + " b.pmpm_ly AS PMPM_LY, " 
			+ " ROUND(a.sale_ytd_cy/100000/ " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) " + " ,2) - b.pmpm_ly  AS INC_PMPM, " 
			+ " ROUND((a.sale_ytd_cy-a.hotrgt_ytd_cy)/100000,2) AS YTD_ACH_EXTRA, " 
			+ " ROUND(a.sale_ytd_cy/ " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 " 
			+ " ELSE SUBSTR('"+month+"',5,2)-3 END) " 
			+ " /100000,2) AS AVG_MTHLY,  " 
			+ " ( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,2) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) <3 THEN ROUND((a.hotrgt_annual_cy-a.sale_ytd_cy)/ "
			+ " (12- SUBSTR('"+month+"' ,5,2)-9) /100000,2) " + " ELSE ROUND((a.hotrgt_annual_cy-a.sale_ytd_cy)/ " 
			+ " (12- SUBSTR('"+month+"' ,5,2)+3) /100000,2) " 
			+ " END ) AS REQD_MTHLY, " 
			+ " ROUND(a.hotrgt_annual_cy/100000,2) AS ANNUAL_TRGT, " 
			+ " ROUND(a.retu_ytd_cy/100000,2) AS RETU_YTD," 
			+ " (CASE WHEN a.sale_ytd_cy<>0 THEN ROUND(a.retu_ytd_cy/a.sale_ytd_cy*100,1)||'%' " 
			+ " ELSE ROUND(9.99*100,1)||'%' END) AS RETU_YTD_PRCT " 
			+ " from " 
			+ " ( SELECT brnd.div_code as divGRP,dwh.fin_year , dwh.item_ser, " 
			+ " SUM(sale_mth_cy) AS sale_mth_cy, " 
			+ " SUM(sale_mth_ly) AS sale_mth_ly, " 
			+ " SUM(trgt_mth_cy * (100+ nvl(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_mth_cy,  " 
			+ " SUM(trgt_mth_cy) AS trgt_mth_cy, " 
			+ " SUM(sale_YTD_cy) AS sale_YTD_cy, " 
			+ " SUM(sale_YTD_ly) AS sale_YTD_ly, " 
			+ " SUM(trgt_YTD_cy * (100+ nvl(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_ytd_cy, " 
			+ " SUM(trgt_YTD_cy) AS trgt_YTD_cy,  " 
			+ " SUM(sale_Qrt1_cy) AS sale_Qrt1_cy, " 
			+ " SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
			+ " SUM(sale_Qrt3_cy) AS sale_Qrt3_cy, " 
			+ " SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
			+ " SUM(trgt_annual_cy * (100+ nvl(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_annual_cy,  "
			+ " SUM(retu_ytd_cy) AS retu_ytd_cy " 
			+ "  from " 
			+ " (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,  " 
			+ " sales_item.item_sub_group AS sub_grp, " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_MTH_APR) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy,  " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP)" 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly, " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) AS trgt_mth_cy, " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " 
			+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " 
			+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy, " + " SUM(CY_SALE_YTD_JUN) AS sale_Qrt1_cy, " + " SUM(CY_SALE_YTD_SEP)-SUM(CY_SALE_YTD_JUN) AS sale_Qrt2_cy,  " + " SUM(CY_SALE_YTD_DEC)-SUM(CY_SALE_YTD_SEP) AS sale_Qrt3_cy, " + " SUM(CY_SALE_YTD_MAR)-SUM(CY_SALE_YTD_DEC) AS sale_Qrt4_cy,  " + " SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy,  " + " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) " + " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB)  " + " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) AS retu_ytd_cy  " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) " + " ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) " + " AND '"+month+"' =	'"+month+"'		  " + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " and sales_item.item_sub_group not IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group " + " ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " and BRND.FIN_YEAR(+) = DWH.FIN_YEAR    " + " GROUP BY dwh.fin_year, dwh.item_ser,brnd.div_code " + " ) a, " + " SM_SALES_DIV_MST b " + " WHERE trim(a.item_ser)=trim (b.div_code)  " + " and B.FIN_YEAR=a.FIN_YEAR "
		// +" and b.div_group=a.divGRP "
		// +" --and TRIM(a.ITEM_SER)=TRIM(C.TABLE_NO) "
		// +" --and C.FINYR = SUBSTR(a.FIN_YEAR,3,2)||SUBSTR(a.FIN_YEAR,6,2) "
		+ "  ORDER BY division ";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			int count1 = 0;
			while (rs.next())
			{
				count1++;
				rowData = new JSONObject();
				dataList = new ArrayList<String>();
				rowData.put("division_grp", checkNull(rs.getString("divGRP")));
				rowData.put("item_ser",    checkNull(rs.getString("DIVISION")));
				dataList.add(rs.getString("MTH_CY_SALES"));
				dataList.add(rs.getString("MTH_LY_SALES"));
				dataList.add(rs.getString("MTH_GR"));
				dataList.add(rs.getString("MTH_HO_TRGT"));
				dataList.add(rs.getString("MTH_FLD_TRGT"));
				dataList.add(rs.getString("MTH_HO_ACH"));
				dataList.add(rs.getString("MTH_FLD_ACH"));
				rowData.put("month", dataList);
				dataList = new ArrayList<String>();
				dataList.add(rs.getString("YTD_CY_SALES"));
				dataList.add(rs.getString("YTD_LY_SALES"));
				dataList.add(rs.getString("YTD_GR"));
				dataList.add(rs.getString("YTD_HO_TRGT"));
				dataList.add(rs.getString("YTD_FLD_TRGT"));
				dataList.add(rs.getString("YTD_HO_ACH"));
				dataList.add(rs.getString("YTD_FLD_ACH"));
				rowData.put("ytd1", dataList);
				dataList = new ArrayList<String>();
				dataList.add(rs.getString("Q1"));
				dataList.add(rs.getString("Q2"));
				dataList.add(rs.getString("Q3"));
				dataList.add(rs.getString("Q4"));
				rowData.put("sales", dataList);

				dataList = new ArrayList<String>();
				dataList.add(rs.getString("Q4"));
				dataList.add(rs.getString("PMPM"));
				dataList.add(rs.getString("PMPM_LY"));
				dataList.add(rs.getString("INC_PMPM"));
				dataList.add(rs.getString("YTD_ACH_EXTRA"));
				rowData.put("ytd2", dataList);
				rowData.put("avg_month_sal", rs.getString("AVG_MTHLY"));
				rowData.put("req_month_sal", rs.getString("REQD_MTHLY"));
				rowData.put("anu_ho_tar", rs.getString("ANNUAL_TRGT"));
				rowData.put("sal_ret_ytd", rs.getString("RETU_YTD"));
				rowData.put("sal_ret_ytd_per", rs.getString("RETU_YTD_PRCT"));

				rawDataJson.put(count, rowData);
				count++;
			}
			System.out.println("fetch Data for grid rawjson====" + rawDataJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getGridData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataJson;
	}

	/*** Method :2 - This method will contains final data for rendering Sales graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getSalesGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> salesList = new ArrayList<String>();
		ArrayList<String> hoList = new ArrayList<String>();
		ArrayList<String> grList = new ArrayList<String>();
		ArrayList<String> monthNameList = null;
		ArrayList<String> keyList = new ArrayList<String>();
		ArrayList<String> dataList = null;
		Map<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			if(month!=null && month.trim().length()>0)
			{
				System.out.println("month comming from GWT ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding  =="+month+"finYear =="+finYear);
				
				sql = " SELECT TRAN, APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC,JAN,FEB,MAR " + " FROM (SELECT '1.SALES' AS TRAN, ROUND(SUM(CY_SALE_MTH_APR)/10000000,1) AS APR, " + " ROUND(SUM(CY_SALE_MTH_MAY)/10000000,1) AS MAY,ROUND(SUM(CY_SALE_MTH_JUN)/10000000,1) AS JUN," + " ROUND(SUM(CY_SALE_MTH_JUL)/10000000,1) AS JUL,ROUND(SUM(CY_SALE_MTH_AUG)/10000000,1) AS AUG," + " ROUND(SUM(CY_SALE_MTH_SEP)/10000000,1) AS SEP,ROUND(SUM(CY_SALE_MTH_OCT)/10000000,1) AS OCT," + " ROUND(SUM(CY_SALE_MTH_NOV)/10000000,1) AS NOV,ROUND(SUM(CY_SALE_MTH_DEC)/10000000,1) AS DEC," + " ROUND(SUM(CY_SALE_MTH_JAN)/10000000,1) AS JAN,ROUND(SUM(CY_SALE_MTH_FEB)/10000000,1) AS FEB, " + " ROUND(SUM(CY_SALE_MTH_MAR)/10000000,1) AS MAR FROM SM_SALES_SUMM_WIDE, SALES_ITEM, " + " SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' " + " AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ')	UNION ALL " + " SELECT '2.HO ACH%' AS TRAN,(CASE WHEN SUM(FLD_TRGT_MTH_APR) <>0 THEN " + " ROUND( SUM(CY_SALE_MTH_APR)/ SUM(FLD_TRGT_MTH_APR * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100)* 100 ,1) " + " ELSE ROUND(0*100,1) END) AS APR,(CASE WHEN SUM(FLD_TRGT_MTH_MAY) <>0 THEN ROUND( SUM(CY_SALE_MTH_MAY) " + " / SUM(FLD_TRGT_MTH_MAY * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS MAY, " + " (CASE WHEN SUM(FLD_TRGT_MTH_JUN) <>0 THEN ROUND( SUM(CY_SALE_MTH_JUN)/ SUM(FLD_TRGT_MTH_JUN * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) " + " * 100 ,1) ELSE ROUND(0*100,1) END) AS JUN,(CASE WHEN SUM(FLD_TRGT_MTH_JUL) <>0 THEN ROUND( SUM(CY_SALE_MTH_JUL) " + " / SUM(FLD_TRGT_MTH_JUL * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS JUL, " + " (CASE WHEN SUM(FLD_TRGT_MTH_AUG) <>0 THEN ROUND( SUM(CY_SALE_MTH_AUG)/ SUM(FLD_TRGT_MTH_AUG * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS AUG,(CASE WHEN SUM(FLD_TRGT_MTH_SEP) <>0 THEN ROUND( SUM(CY_SALE_MTH_SEP) " + " / SUM(FLD_TRGT_MTH_SEP * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100)  * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS SEP,(CASE WHEN SUM(FLD_TRGT_MTH_OCT) <>0 THEN ROUND( SUM(CY_SALE_MTH_OCT) " + " / SUM(FLD_TRGT_MTH_OCT * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS OCT,(CASE WHEN SUM(FLD_TRGT_MTH_NOV) <>0 THEN ROUND( SUM(CY_SALE_MTH_NOV) " + " / SUM(FLD_TRGT_MTH_NOV * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS NOV, " + " (CASE WHEN SUM(FLD_TRGT_MTH_DEC) <>0 THEN ROUND( SUM(CY_SALE_MTH_DEC)/ SUM(FLD_TRGT_MTH_DEC * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) " + " * 100 ,1) ELSE ROUND(0*100,1) END) AS DEC,(CASE WHEN SUM(FLD_TRGT_MTH_JAN) <>0 THEN ROUND( SUM(CY_SALE_MTH_JAN) " + " / SUM(FLD_TRGT_MTH_JAN * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS JAN," + " (CASE WHEN SUM(FLD_TRGT_MTH_FEB) <>0 THEN ROUND( SUM(CY_SALE_MTH_FEB)/ SUM(FLD_TRGT_MTH_FEB * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS FEB,(CASE WHEN SUM(FLD_TRGT_MTH_MAR) <>0 THEN ROUND( SUM(CY_SALE_MTH_MAR) " + " / SUM(FLD_TRGT_MTH_MAR * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS MAR " + " FROM SM_SALES_SUMM_WIDE, SALES_ITEM, SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ') " + " UNION ALL SELECT '3.GR %' AS TRAN,(CASE WHEN SUM(LY_SALE_MTH_APR) <>0  AND SUM(CY_SALE_MTH_APR)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_APR) -SUM(LY_SALE_MTH_APR)) / SUM(LY_SALE_MTH_APR) *100 ,1) " + " ELSE ROUND(0*100,1) END) AS APR,(CASE WHEN SUM(LY_SALE_MTH_MAY) <>0 AND SUM(CY_SALE_MTH_MAY)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_MAY) -SUM(LY_SALE_MTH_MAY))/ SUM(LY_SALE_MTH_MAY) *100 ,1) ELSE ROUND(0*100,1) END) AS MAY, " + " (CASE WHEN SUM(LY_SALE_MTH_JUN) <>0 AND SUM(CY_SALE_MTH_JUN)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_JUN) -SUM(LY_SALE_MTH_JUN)) " + " / SUM(LY_SALE_MTH_JUN) *100 ,1) ELSE ROUND(0*100,1) END) AS JUN,(CASE WHEN SUM(LY_SALE_MTH_JUL) <>0 AND SUM(CY_SALE_MTH_JUL)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_JUL) -SUM(LY_SALE_MTH_JUL)) / SUM(LY_SALE_MTH_JUL) *100 ,1) ELSE ROUND(0*100,1) END) AS JUL, " + " (CASE WHEN SUM(LY_SALE_MTH_AUG) <>0 AND SUM(CY_SALE_MTH_AUG)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_AUG) -SUM(LY_SALE_MTH_AUG)) " + " / SUM(LY_SALE_MTH_AUG) *100 ,1) ELSE ROUND(0*100,1) END) AS AUG,(CASE WHEN SUM(LY_SALE_MTH_SEP) <>0 AND SUM(CY_SALE_MTH_SEP)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_SEP) -SUM(LY_SALE_MTH_SEP)) / SUM(LY_SALE_MTH_SEP) *100 ,1) ELSE ROUND(0*100,1) END) AS SEP, " + " (CASE WHEN SUM(LY_SALE_MTH_OCT) <>0 AND SUM(CY_SALE_MTH_OCT)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_OCT) -SUM(LY_SALE_MTH_OCT)) " + " / SUM(LY_SALE_MTH_OCT) *100 ,1)ELSE ROUND(0*100,1) END) AS OCT,(CASE WHEN SUM(LY_SALE_MTH_NOV) <>0 AND SUM(CY_SALE_MTH_NOV)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_NOV) -SUM(LY_SALE_MTH_NOV))/ SUM(LY_SALE_MTH_NOV) *100 ,1) ELSE ROUND(0*100,1) END) AS NOV, " + " (CASE WHEN SUM(LY_SALE_MTH_DEC) <>0 AND SUM(CY_SALE_MTH_DEC)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_DEC) -SUM(LY_SALE_MTH_DEC)) " + " / SUM(LY_SALE_MTH_DEC) *100 ,1) ELSE ROUND(0*100,1) END) AS DEC,(CASE WHEN SUM(LY_SALE_MTH_JAN) <>0 AND SUM(CY_SALE_MTH_JAN)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_JAN) -SUM(LY_SALE_MTH_JAN)) / SUM(LY_SALE_MTH_JAN) *100 ,1) ELSE ROUND(0*100,1) END) AS JAN, " + " (CASE WHEN SUM(LY_SALE_MTH_FEB) <>0 AND SUM(CY_SALE_MTH_FEB)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_FEB) -SUM(LY_SALE_MTH_FEB)) " + " / SUM(LY_SALE_MTH_FEB) *100 ,1) ELSE ROUND(0*100,1) END) AS FEB,(CASE WHEN SUM(LY_SALE_MTH_MAR) <>0 AND SUM(CY_SALE_MTH_MAR)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_MAR) -SUM(LY_SALE_MTH_MAR))/ SUM(LY_SALE_MTH_MAR) *100 ,1) ELSE ROUND(0*100,1) END) AS MAR " + " FROM SM_SALES_SUMM_WIDE, SALES_ITEM, SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ') " + " )WHERE '"+finYear+"' = '"+finYear+"'"; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				dataList = new ArrayList<String>();
				String tran =  checkNull(rs.getString("tran"));
				keyList.add(tran);
				dataList.add(checkNull(rs.getString("APR")));
				dataList.add(checkNull(rs.getString("MAY")));
				dataList.add(checkNull(rs.getString("JUN")));
				dataList.add(checkNull(rs.getString("JUL")));
				dataList.add(checkNull(rs.getString("AUG")));
				dataList.add(checkNull(rs.getString("SEP")));
				dataList.add(checkNull(rs.getString("OCT")));
				dataList.add(checkNull(rs.getString("NOV")));
				dataList.add(checkNull(rs.getString("DEC")));
				dataList.add(checkNull(rs.getString("JAN")));
				dataList.add(checkNull(rs.getString("FEB")));
				dataList.add(checkNull(rs.getString("MAR")));
				hashMap.put(tran, dataList);
				

			}
		}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getSalesGraphData():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		if (keyList.size()== 3)
		{
			System.out.println("keyList.toString() =" + keyList.toString());
			System.out.println("keyList.size() =" + keyList.size());
			salesList = hashMap.get(keyList.get(0));
			hoList = hashMap.get(keyList.get(1));
			grList = hashMap.get(keyList.get(2));

			int count = 0;
			monthNameList=		this.getMonthList();
			for (int i = 0; i < salesList.size(); i++)
			{
				rowData = new JSONObject();
				rowData.put("month", monthNameList.get(i));
				rowData.put("sales", salesList.get(i));
				rowData.put("ho_per", hoList.get(i));
				rowData.put("gr_per", grList.get(i));
				rawDataJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("rawDataJson is =" + rawDataJson);

		return rawDataJson;
	}

	/*** End of method getSalesGraphData() ***/

	/*** Method :3 - This method will contains raw data for rendering the Profit graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getProfitGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
        String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> profitList = new ArrayList<String>();
		ArrayList<String> toSalList = new ArrayList<String>();
		ArrayList<String> tranSalList = new ArrayList<String>();
		ArrayList<String> monthNameList = null;
		ArrayList<String> keyList = new ArrayList<String>();
		ArrayList<String> dataList = null;
		Map<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//add new code by Birendra Pandey on dated 23 july-2014
			if(month!=null && month.trim().length()>0)
			{
			    System.out.println("Comming  month inside getProfitGraphData ==="+month);	
				String selectedMonth  = month.substring(4, 6);
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
			System.out.println("updates month and year from dcoding in getProfitGraphData =="+month+"finYear =="+finYear);
	//		sql = "SELECT tran, apr,may,jun,jul,aug,sep,oct,nov,DEC,jan,feb,mar FROM (SELECT '1.PROFIT' AS tran,ROUND((SUM(CY_SALE_MTH_apr)/100000 - SUM(NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0)) )/100,1) AS apr,ROUND((SUM(CY_SALE_MTH_may)/100000 - SUM(NVL(COGS_MTH_may,0)+NVL(EXPENSE_MTH_may,0)) )/100,1) AS may, ROUND((SUM(CY_SALE_MTH_jun)/100000 - SUM(NVL(COGS_MTH_jun,0)+NVL(EXPENSE_MTH_jun,0)) )/100,1) AS jun,ROUND((SUM(CY_SALE_MTH_jul)/100000 - SUM(NVL(COGS_MTH_jul,0)+NVL(EXPENSE_MTH_jul,0)) )/100,1) AS jul,ROUND((SUM(CY_SALE_MTH_aug)/100000 - SUM(NVL(COGS_MTH_aug,0)+NVL(EXPENSE_MTH_aug,0)) )/100,1) AS aug,ROUND((SUM(CY_SALE_MTH_sep)/100000 - SUM(NVL(COGS_MTH_sep,0)+NVL(EXPENSE_MTH_sep,0)) )/100,1) AS sep,ROUND((SUM(CY_SALE_MTH_oct)/100000 - SUM(NVL(COGS_MTH_oct,0)+NVL(EXPENSE_MTH_oct,0)) )/100,1) AS oct,ROUND((SUM(CY_SALE_MTH_nov)/100000 - SUM(NVL(COGS_MTH_nov,0)+NVL(EXPENSE_MTH_nov,0)) )/100,1) AS nov, ROUND((SUM(CY_SALE_MTH_dec)/100000 - SUM(NVL(COGS_MTH_dec,0)+NVL(EXPENSE_MTH_dec,0)) )/100,1) AS DEC,ROUND((SUM(CY_SALE_MTH_jan)/100000 - SUM(NVL(COGS_MTH_jan,0)+NVL(EXPENSE_MTH_jan,0)) )/100,1) AS jan,ROUND((SUM(CY_SALE_MTH_feb)/100000 - SUM(NVL(COGS_MTH_feb,0)+NVL(EXPENSE_MTH_feb,0)) )/100,1) AS feb,ROUND((SUM(CY_SALE_MTH_mar)/100000 - SUM(NVL(COGS_MTH_mar,0)+NVL(EXPENSE_MTH_mar,0)) )/100,1) AS mar FROM SM_SALES_SUMM_WIDE, sales_item WHERE trim(SM_SALES_SUMM_WIDE.fin_year)='"+finYear+"' AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code AND sales_item.item_sub_group NOT IN ('CU','BJ') UNION ALL SELECT '2.% to SALE' AS tran,( CASE WHEN SUM(CY_SALE_MTH_apr)=0 THEN 0 ELSE  ROUND(  ( SUM(CY_SALE_MTH_apr) - (SUM( NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0) )*100000)  )/SUM(CY_SALE_MTH_apr)* 100, 2) END ) AS apr,( CASE WHEN SUM(CY_SALE_MTH_may) =0 THEN 0 ELSE  ROUND(  ( SUM(CY_SALE_MTH_may) - (SUM( NVL(COGS_MTH_may,0)+NVL(EXPENSE_MTH_may,0) )*100000)  )/SUM(CY_SALE_MTH_may)* 100, 2) END ) AS may,( CASE WHEN SUM(CY_SALE_MTH_jun) =0 THEN 0 ELSE  ROUND(  ( SUM(CY_SALE_MTH_jun) - (SUM( NVL(COGS_MTH_jun,0)+NVL(EXPENSE_MTH_jun,0) )*100000)  )/SUM(CY_SALE_MTH_jun)* 100, 2) END ) AS jun,( CASE WHEN SUM(CY_SALE_MTH_jul) =0 THEN 0 ELSE  ROUND(  ( SUM(CY_SALE_MTH_jul) - (SUM( NVL(COGS_MTH_jul,0)+NVL(EXPENSE_MTH_jul,0) )*100000)  )/SUM(CY_SALE_MTH_jul)* 100, 2) END ) AS jul,( CASE WHEN SUM(CY_SALE_MTH_aug) =0 THEN 0 ELSE  ROUND( ( SUM(CY_SALE_MTH_aug) - (SUM( NVL(COGS_MTH_aug,0)+NVL(EXPENSE_MTH_aug,0) )*100000)  )/SUM(CY_SALE_MTH_aug) * 100, 2) END ) AS aug," + "( CASE WHEN SUM(CY_SALE_MTH_sep) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_sep) -(SUM( NVL(COGS_MTH_sep,0)+NVL(EXPENSE_MTH_sep,0) )*100000))/SUM(CY_SALE_MTH_sep)* 100,2) END ) AS sep,( CASE WHEN SUM(CY_SALE_MTH_oct) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_oct) - (SUM( NVL(COGS_MTH_oct,0)+NVL(EXPENSE_MTH_oct,0) )*100000))/SUM(CY_SALE_MTH_oct)* 100, 2) END ) AS oct,( CASE WHEN SUM(CY_SALE_MTH_nov) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_nov) - (SUM( NVL(COGS_MTH_nov,0)+NVL(EXPENSE_MTH_nov,0) )*100000))/SUM(CY_SALE_MTH_nov) * 100, 2) END ) AS nov,( CASE WHEN SUM(CY_SALE_MTH_DEC) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_DEC) - (SUM( NVL(COGS_MTH_DEC,0)+NVL(EXPENSE_MTH_DEC,0) )*100000))/SUM(CY_SALE_MTH_dec) * 100, 2) END ) AS DEC,( CASE WHEN SUM(CY_SALE_MTH_jan) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_jan) - (SUM( NVL(COGS_MTH_jan,0)+NVL(EXPENSE_MTH_jan,0) )*100000)  )/SUM(CY_SALE_MTH_jan) * 100, 2) END ) AS jan,( CASE WHEN SUM(CY_SALE_MTH_feb) =0 THEN 0 ELSE  ROUND(  ( SUM(CY_SALE_MTH_feb) - (SUM( NVL(COGS_MTH_feb,0)+NVL(EXPENSE_MTH_feb,0) )*100000)  )/SUM(CY_SALE_MTH_feb) * 100, 2) END ) AS feb,( CASE WHEN SUM(CY_SALE_MTH_mar) =0 THEN 0 ELSE  ROUND(( SUM(CY_SALE_MTH_mar) - (SUM( NVL(COGS_MTH_mar,0)+NVL(EXPENSE_MTH_mar,0) )*100000)  )/SUM(CY_SALE_MTH_mar)* 100, 2) END ) AS mar  FROM SM_SALES_SUMM_WIDE, sales_item WHERE trim(SM_SALES_SUMM_WIDE.fin_year)='"+finYear+"' AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code AND sales_item.item_sub_group NOT IN ('CU','BJ'))WHERE '"+finYear+"' = '"+finYear+"'";
			sql = " SELECT tran, apr,may,jun,jul,aug,sep,oct,nov,DEC,jan,feb,mar"
					+" FROM"
					+" ("
					+" SELECT '1.PROFIT' AS tran,"
					       +" round((ROUND(SUM(CY_SALE_MTH_apr)/100000,2) - SUM(NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0)))/100,1) AS apr,"
						   +" round((ROUND(SUM(CY_SALE_MTH_may)/100000,2) - SUM(NVL(COGS_MTH_may,0)+NVL(EXPENSE_MTH_may,0)))/100,1) AS may,"
						   +" round((ROUND(SUM(CY_SALE_MTH_jun)/100000,2) - SUM(NVL(COGS_MTH_jun,0)+NVL(EXPENSE_MTH_jun,0)))/100,1) AS jun,"
						   +" round((ROUND(SUM(CY_SALE_MTH_jul)/100000,2) - SUM(NVL(COGS_MTH_jul,0)+NVL(EXPENSE_MTH_jul,0)))/100,1) AS jul,"
						   +" round((ROUND(SUM(CY_SALE_MTH_aug)/100000,2) - SUM(NVL(COGS_MTH_aug,0)+NVL(EXPENSE_MTH_aug,0)))/100,1) AS aug,"
						   +" round((ROUND(SUM(CY_SALE_MTH_sep)/100000,2) - SUM(NVL(COGS_MTH_sep,0)+NVL(EXPENSE_MTH_sep,0)))/100,1) AS sep,"
						   +" round((ROUND(SUM(CY_SALE_MTH_oct)/100000,2) - SUM(NVL(COGS_MTH_oct,0)+NVL(EXPENSE_MTH_oct,0)))/100,1) AS oct,"
						   +" round((ROUND(SUM(CY_SALE_MTH_nov)/100000,2) - SUM(NVL(COGS_MTH_nov,0)+NVL(EXPENSE_MTH_nov,0)))/100,1) AS nov,"
						   +" round((ROUND(SUM(CY_SALE_MTH_dec)/100000,2) - SUM(NVL(COGS_MTH_dec,0)+NVL(EXPENSE_MTH_dec,0)))/100,1) AS DEC,"
						   +" round((ROUND(SUM(CY_SALE_MTH_jan)/100000,2) - SUM(NVL(COGS_MTH_jan,0)+NVL(EXPENSE_MTH_jan,0)))/100,1) AS jan,"
						   +" round((ROUND(SUM(CY_SALE_MTH_feb)/100000,2) - SUM(NVL(COGS_MTH_feb,0)+NVL(EXPENSE_MTH_feb,0)))/100,1) AS feb,"
						   +" round((ROUND(SUM(CY_SALE_MTH_mar)/100000,2) - SUM(NVL(COGS_MTH_mar,0)+NVL(EXPENSE_MTH_mar,0)))/100,1) AS mar"
					+" FROM SM_SALES_SUMM_WIDE, sales_item"
					+" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
					+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
					 +" UNION ALL"
					 +" SELECT '2.% to SALE' AS tran,"
					      +" ( CASE WHEN SUM(CY_SALE_MTH_apr)=0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_apr) - (SUM( NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0) )*100000)  )/SUM(CY_SALE_MTH_apr)"
					 			  +" * 100, 2) END ) AS apr,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_may) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_may) - (SUM( NVL(COGS_MTH_may,0)+NVL(EXPENSE_MTH_may,0) )*100000)  )/SUM(CY_SALE_MTH_may)"
					 			  +" * 100, 2) END ) AS may,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_jun) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_jun) - (SUM( NVL(COGS_MTH_jun,0)+NVL(EXPENSE_MTH_jun,0) )*100000)  )/SUM(CY_SALE_MTH_jun)"
					 			  +" * 100, 2) END ) AS jun,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_jul) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_jul) - (SUM( NVL(COGS_MTH_jul,0)+NVL(EXPENSE_MTH_jul,0) )*100000)  )/SUM(CY_SALE_MTH_jul)"
					 			  +" * 100, 2) END ) AS jul,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_aug) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND( ( SUM(CY_SALE_MTH_aug) - (SUM( NVL(COGS_MTH_aug,0)+NVL(EXPENSE_MTH_aug,0) )*100000)  )/SUM(CY_SALE_MTH_aug)"
					 			  +" * 100, 2) END ) AS aug,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_sep) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_sep) - (SUM( NVL(COGS_MTH_sep,0)+NVL(EXPENSE_MTH_sep,0) )*100000)  )/SUM(CY_SALE_MTH_sep)"
					 			  +" * 100, 2) END ) AS sep,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_oct) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_oct) - (SUM( NVL(COGS_MTH_oct,0)+NVL(EXPENSE_MTH_oct,0) )*100000)  )/SUM(CY_SALE_MTH_oct)"
					 			  +" * 100, 2) END ) AS oct,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_nov) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_nov) - (SUM( NVL(COGS_MTH_nov,0)+NVL(EXPENSE_MTH_nov,0) )*100000)  )/SUM(CY_SALE_MTH_nov)"
					 			  +" * 100, 2) END ) AS nov,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_DEC) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_DEC) - (SUM( NVL(COGS_MTH_DEC,0)+NVL(EXPENSE_MTH_DEC,0) )*100000)  )/SUM(CY_SALE_MTH_dec)"
					 			  +" * 100, 2) END ) AS DEC,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_jan) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_jan) - (SUM( NVL(COGS_MTH_jan,0)+NVL(EXPENSE_MTH_jan,0) )*100000)  )/SUM(CY_SALE_MTH_jan)"
					 			  +" * 100, 2) END ) AS jan,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_feb) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_feb) - (SUM( NVL(COGS_MTH_feb,0)+NVL(EXPENSE_MTH_feb,0) )*100000)  )/SUM(CY_SALE_MTH_feb)"
					 			  +" * 100, 2) END ) AS feb,"
					 	   +" ( CASE WHEN SUM(CY_SALE_MTH_mar) =0 "
						          +" THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_mar) - (SUM( NVL(COGS_MTH_mar,0)+NVL(EXPENSE_MTH_mar,0) )*100000)  )/SUM(CY_SALE_MTH_mar)"
					 			  +" * 100, 2) END ) AS mar"
					 +" FROM SM_SALES_SUMM_WIDE, sales_item"
					 +" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
					 +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
					 +" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
					+"     UNION ALL"
					+" SELECT '3.Profit_Bud%' AS tran,"
					       +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_apr) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS apr,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_may) <>0 THEN"
					        +"          ROUND( SUM(NVL(mst.BUD_PFT_may,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS may,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jun) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jun,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_jun * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jun,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jul) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jul,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_jul * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jul,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jul) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_aug,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_aug * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS aug,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_sep) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_sep,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_sep * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS sep,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_oct) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_oct,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_oct * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS oct,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_nov) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_nov,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_nov * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS nov,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_dec) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_dec,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_dec * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS DEC,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jan) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jan,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_jan * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jan,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_feb) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_feb,0))*100 "
					                 +" / SUM(trn.FLD_TRGT_MTH_feb * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS feb,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_mar) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_mar,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_MTH_mar * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS mar"
					+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd"
					+" WHERE trim(trn.fin_year)= '"+finYear+"'"
					+" AND trn.fin_year=mst.fin_year"
					+" AND trn.item_ser=mst.div_code"
					+" AND trn.item_code= sales_item.item_code"
					    +" AND brnd.brand_code(+) = sales_item.item_sub_group"
					    +" AND brnd.div_code(+) = sales_item.item_ser"
					+"     AND brnd.fin_year(+) = '"+finYear+"'"
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
					+" )"
					+" WHERE '"+finYear+"' = '"+finYear+"'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				dataList = new ArrayList<String>();
				String tran = rs.getString("tran");
				keyList.add(tran);								
				dataList.add(checkNull(rs.getString("APR")));
				dataList.add(checkNull(rs.getString("MAY")));
				dataList.add(checkNull(rs.getString("JUN")));
				dataList.add(checkNull(rs.getString("JUL")));
				dataList.add(checkNull(rs.getString("AUG")));
				dataList.add(checkNull(rs.getString("SEP")));
				dataList.add(checkNull(rs.getString("OCT")));
				dataList.add(checkNull(rs.getString("NOV")));
				dataList.add(checkNull(rs.getString("DEC")));
				dataList.add(checkNull(rs.getString("JAN")));
				dataList.add(checkNull(rs.getString("FEB")));
				dataList.add(checkNull(rs.getString("MAR")));
				hashMap.put(tran, dataList);
				System.out.println("keyList ProfitGraph====" + keyList);

			}
		}
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getProfitGraph:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		if (keyList.size() == 3)
		{
			System.out.println("keyList.toString()ProfitGraph =" + keyList.toString());
			System.out.println("keyList.size()ProfitGraph =" + keyList.size());
			profitList = hashMap.get(keyList.get(0));
			toSalList = hashMap.get(keyList.get(1));
	        tranSalList = hashMap.get(keyList.get(2));

			int count = 0;
			monthNameList =this.getMonthList();
			for (int i = 0; i < profitList.size(); i++)
			{
				rowData = new JSONObject();
				rowData.put("month", monthNameList.get(i));
				rowData.put("profits", profitList.get(i));
				rowData.put("to_sal", toSalList.get(i));
				rowData.put("profits_bud", tranSalList.get(i));
				rawDataJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("rawDataJson ProfitGraph is =" + rawDataJson);

		return rawDataJson;
	}

	   //new method for profitYTD graph 19 Jan 2014 
	@SuppressWarnings("unchecked")
	public JSONObject getProfitYTDGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
        String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> profitList = new ArrayList<String>();
		ArrayList<String> toSalList = new ArrayList<String>();
		ArrayList<String>  tranSalList= new ArrayList<String>();
		ArrayList<String> monthNameList = null;
		ArrayList<String> keyList = new ArrayList<String>();
		ArrayList<String> dataList = null;
		Map<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//add new code by Birendra Pandey on dated 23 july-2014
			if(month!=null && month.trim().length()>0)
			{
			    System.out.println("Comming  month inside getProfitYTDGraphData ==="+month);	
				String selectedMonth  = month.substring(4, 6);
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
			System.out.println("updates month and year from dcoding in getProfit YTD GraphData =="+month+"finYear =="+finYear);
			sql = " SELECT tran, apr,may,jun,jul,aug,sep,oct,nov,DEC,jan,feb,mar"
					+" FROM"
					+" ("
					+" SELECT '1.PROFIT' AS tran,"
					       +" ROUND((ROUND(SUM(CY_SALE_YTD_apr)/100000,2) - SUM(NVL(COGS_YTD_APR,0)+NVL(EXPENSE_YTD_APR,0)))/100,1) AS apr,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_may)/100000,2) - SUM(NVL(COGS_YTD_may,0)+NVL(EXPENSE_YTD_may,0)))/100,1) AS may,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_jun)/100000,2) - SUM(NVL(COGS_YTD_jun,0)+NVL(EXPENSE_YTD_jun,0)))/100,1) AS jun,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_jul)/100000,2) - SUM(NVL(COGS_YTD_jul,0)+NVL(EXPENSE_YTD_jul,0)))/100,1) AS jul,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_aug)/100000,2) - SUM(NVL(COGS_YTD_aug,0)+NVL(EXPENSE_YTD_aug,0)))/100,1) AS aug,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_sep)/100000,2) - SUM(NVL(COGS_YTD_sep,0)+NVL(EXPENSE_YTD_sep,0)))/100,1) AS sep,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_oct)/100000,2) - SUM(NVL(COGS_YTD_oct,0)+NVL(EXPENSE_YTD_oct,0)))/100,1) AS oct,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_nov)/100000,2) - SUM(NVL(COGS_YTD_nov,0)+NVL(EXPENSE_YTD_nov,0)))/100,1) AS nov,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_dec)/100000,2) - SUM(NVL(COGS_YTD_dec,0)+NVL(EXPENSE_YTD_dec,0)))/100,1) AS DEC,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_jan)/100000,2) - SUM(NVL(COGS_YTD_jan,0)+NVL(EXPENSE_YTD_jan,0)))/100,1) AS jan,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_feb)/100000,2) - SUM(NVL(COGS_YTD_feb,0)+NVL(EXPENSE_YTD_feb,0)))/100,1) AS feb,"
						   +" ROUND((ROUND(SUM(CY_SALE_YTD_mar)/100000,2) - SUM(NVL(COGS_YTD_mar,0)+NVL(EXPENSE_YTD_mar,0)))/100,1) AS mar"
					+" FROM SM_SALES_SUMM_WIDE, sales_item"
					+" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
					+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
					 +" UNION ALL"
					 +" SELECT '2.% to SALE' AS tran,"
					      +" ( CASE WHEN SUM(CY_SALE_YTD_apr)=0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_apr) - (SUM( NVL(COGS_YTD_APR,0)+NVL(EXPENSE_YTD_APR,0) )*100000)  )/SUM(CY_SALE_YTD_apr)"
					 			  +" * 100, 2) END ) AS apr,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_may) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_may) - (SUM( NVL(COGS_YTD_may,0)+NVL(EXPENSE_YTD_may,0) )*100000)  )/SUM(CY_SALE_YTD_may)"
					 			  +" * 100, 2) END ) AS may,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_jun) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_jun) - (SUM( NVL(COGS_YTD_jun,0)+NVL(EXPENSE_YTD_jun,0) )*100000)  )/SUM(CY_SALE_YTD_jun)"
					 			  +" * 100, 2) END ) AS jun,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_jul) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_jul) - (SUM( NVL(COGS_YTD_jul,0)+NVL(EXPENSE_YTD_jul,0) )*100000)  )/SUM(CY_SALE_YTD_jul)"
					 			  +" * 100, 2) END ) AS jul,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_aug) =0 THEN 0  "
								  +" ELSE  ROUND( ( SUM(CY_SALE_YTD_aug) - (SUM( NVL(COGS_YTD_aug,0)+NVL(EXPENSE_YTD_aug,0) )*100000)  )/SUM(CY_SALE_YTD_aug)"
					 			  +" * 100, 2) END ) AS aug,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_sep) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_sep) - (SUM( NVL(COGS_YTD_sep,0)+NVL(EXPENSE_YTD_sep,0) )*100000)  )/SUM(CY_SALE_YTD_sep)"
					 			  +" * 100, 2) END ) AS sep,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_oct) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_oct) - (SUM( NVL(COGS_YTD_oct,0)+NVL(EXPENSE_YTD_oct,0) )*100000)  )/SUM(CY_SALE_YTD_oct)"
					 			  +" * 100, 2) END ) AS oct,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_nov) =0 THEN 0  "
							+" 	  ELSE  ROUND(  ( SUM(CY_SALE_YTD_nov) - (SUM( NVL(COGS_YTD_nov,0)+NVL(EXPENSE_YTD_nov,0) )*100000)  )/SUM(CY_SALE_YTD_nov)"
					 			  +" * 100, 2) END ) AS nov,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_DEC) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_DEC) - (SUM( NVL(COGS_YTD_DEC,0)+NVL(EXPENSE_YTD_DEC,0) )*100000)  )/SUM(CY_SALE_YTD_dec)"
					 			  +" * 100, 2) END ) AS DEC,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_jan) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_jan) - (SUM( NVL(COGS_YTD_jan,0)+NVL(EXPENSE_YTD_jan,0) )*100000)  )/SUM(CY_SALE_YTD_jan)"
					 			  +" * 100, 2) END ) AS jan,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_feb) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_feb) - (SUM( NVL(COGS_YTD_feb,0)+NVL(EXPENSE_YTD_feb,0) )*100000)  )/SUM(CY_SALE_YTD_feb)"
					 			  +" * 100, 2) END ) AS feb,"
					 	   +" ( CASE WHEN SUM(CY_SALE_YTD_mar) =0 THEN 0  "
								  +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_mar) - (SUM( NVL(COGS_YTD_mar,0)+NVL(EXPENSE_YTD_mar,0) )*100000)  )/SUM(CY_SALE_YTD_mar)"
					 			  +" * 100, 2) END ) AS mar"
					 +" FROM SM_SALES_SUMM_WIDE, sales_item"
					 +" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
					 +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
					 +" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
					+"     UNION ALL"
					+" SELECT '3.Profit_Bud%' AS tran,"
					       +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_apr) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS apr,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_may) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS may,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jun) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_jun * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jun,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jul) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_jul * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jul,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jul) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_aug * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS aug,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_sep) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_sep * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS sep,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_oct) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_oct * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS oct,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_nov) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_nov,0)+NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_nov * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS nov,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_dec) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_dec,0)+NVL(mst.BUD_PFT_nov,0)+NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_dec * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS DEC,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jan) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_jan,0)+NVL(mst.BUD_PFT_dec,0)+NVL(mst.BUD_PFT_nov,0)+NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_jan * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS jan,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_feb) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_feb,0)+NVL(mst.BUD_PFT_jan,0)+NVL(mst.BUD_PFT_dec,0)+NVL(mst.BUD_PFT_nov,0)+NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_feb * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS feb,"
							+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_mar) <>0 THEN"
					                 +" ROUND( SUM(NVL(mst.BUD_PFT_mar,0)+NVL(mst.BUD_PFT_feb,0)+NVL(mst.BUD_PFT_jan,0)+NVL(mst.BUD_PFT_dec,0)+NVL(mst.BUD_PFT_nov,0)+NVL(mst.BUD_PFT_oct,0)+NVL(mst.BUD_PFT_sep,0)+NVL(mst.BUD_PFT_aug,0)+NVL(mst.BUD_PFT_jul,0)+NVL(mst.BUD_PFT_jun,0)+NVL(mst.BUD_PFT_may,0)+NVL(mst.BUD_PFT_apr,0))*1000 "
					                 +" / SUM(trn.FLD_TRGT_YTD_mar * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
									 +" * 100 ,1) "
					  		+" ELSE ROUND(0*100,1) END) AS mar "
					+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd"
					+" WHERE trim(trn.fin_year)= '"+finYear+"'"
					+" AND trn.fin_year=mst.fin_year"
					+" AND trn.item_ser=mst.div_code"
					+" AND trn.item_code= sales_item.item_code"
					    +" AND brnd.brand_code(+) = sales_item.item_sub_group"
					    +" AND brnd.div_code(+) = sales_item.item_ser"
					    +" AND brnd.fin_year(+) = '"+finYear+"'"
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
					+" )"
					+" WHERE '"+finYear+"' = '"+finYear+"'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				dataList = new ArrayList<String>();
				String tran = rs.getString("tran");
				keyList.add(tran);								
				dataList.add(checkNull(rs.getString("APR")));
				dataList.add(checkNull(rs.getString("MAY")));
				dataList.add(checkNull(rs.getString("JUN")));
				dataList.add(checkNull(rs.getString("JUL")));
				dataList.add(checkNull(rs.getString("AUG")));
				dataList.add(checkNull(rs.getString("SEP")));
				dataList.add(checkNull(rs.getString("OCT")));
				dataList.add(checkNull(rs.getString("NOV")));
				dataList.add(checkNull(rs.getString("DEC")));
				dataList.add(checkNull(rs.getString("JAN")));
				dataList.add(checkNull(rs.getString("FEB")));
				dataList.add(checkNull(rs.getString("MAR")));
				hashMap.put(tran, dataList);
				System.out.println("keyList Profit YTD Graph====" + keyList);

			}
		}
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getProfitYTDGraph:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		if (keyList.size() == 3)
		{
			profitList = hashMap.get(keyList.get(0));
			toSalList = hashMap.get(keyList.get(1));
			 tranSalList = hashMap.get(keyList.get(2));
			int count = 0;
			monthNameList =this.getMonthList();
			for (int i = 0; i < profitList.size(); i++)
			{
				rowData = new JSONObject();
				rowData.put("month", monthNameList.get(i));
				rowData.put("profits", profitList.get(i));
				rowData.put("to_sal", toSalList.get(i));
				rowData.put("profits_bud", tranSalList.get(i));
				rawDataJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("rawDataJson ProfitYTDGraph is =" + rawDataJson);

		return rawDataJson;
	}
	
	  // end  method for profitYTD graph 19 Jan 2014 
	
	/*** End of method getProfitGraphData() ***/

	/*** Method :4 - This method will contains raw data for rendering Expense graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getExpenseGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> expenceList = new ArrayList<String>();
		ArrayList<String> toSalList = new ArrayList<String>();
		ArrayList<String>  tranSalList = new ArrayList<String>();
		ArrayList<String> monthNameList =null;
		ArrayList<String> keyList = new ArrayList<String>();
		ArrayList<String> dataList = null;
		Map<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
		try
		{
		 //add new code by Birendra Pandey on dated 23 july-2014
		if(month!=null && month.trim().length()>0)
			{
				conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;
				System.out.println("Comming  month inside getExpenseGraphData ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding in getExpenseGraphData =="+month+"finYear =="+finYear);
												
				sql = "SELECT tran, apr,may,jun,jul,aug,sep,oct,nov,DEC,jan,feb,mar"
						+" FROM"
						+" ("
						+" SELECT '1.EXPENSE' AS tran,"
						       +" round(SUM(NVL(EXPENSE_MTH_APR,0))/100,1) AS apr,"
							   +" round(SUM(NVL(EXPENSE_MTH_may,0))/100,1) AS may,"
							   +" round(SUM(NVL(EXPENSE_MTH_jun,0))/100,1) AS jun,"
							   +" round(SUM(NVL(EXPENSE_MTH_jul,0))/100,1) AS jul,"
							   +" round(SUM(NVL(EXPENSE_MTH_aug,0))/100,1) AS aug,"
							   +" round(SUM(NVL(EXPENSE_MTH_sep,0))/100,1) AS sep,"
							   +" round(SUM(NVL(EXPENSE_MTH_oct,0))/100,1) AS oct,"
							   +" round(SUM(NVL(EXPENSE_MTH_nov,0))/100,1) AS nov,"
							   +" round(SUM(NVL(EXPENSE_MTH_dec,0))/100,1) AS DEC,"
							   +" round(SUM(NVL(EXPENSE_MTH_jan,0))/100,1) AS jan,"
							   +" round(SUM(NVL(EXPENSE_MTH_feb,0))/100,1) AS feb,"
							   +" round(SUM(NVL(EXPENSE_MTH_mar,0))/100,1) AS mar"
						+" FROM SM_SALES_SUMM_WIDE"
						+" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
						+"  UNION ALL"
						 +" SELECT '2.% to SALE' AS tran,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_apr)=0 THEN 0  "
									 +"  ELSE  ROUND( SUM(NVL(EXPENSE_MTH_APR,0)) *100000 /SUM(CY_SALE_MTH_apr) * 100, 2) END ) AS apr,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_may)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_may,0)) *100000 /SUM(CY_SALE_MTH_may) * 100, 2) END ) AS may,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_jun)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_jun,0)) *100000 /SUM(CY_SALE_MTH_jun) * 100, 2) END ) AS jun,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_jul)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_jul,0)) *100000 /SUM(CY_SALE_MTH_jul) * 100, 2) END ) AS jul,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_aug)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_aug,0)) *100000 /SUM(CY_SALE_MTH_aug) * 100, 2) END ) AS aug,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_sep)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_sep,0)) *100000 /SUM(CY_SALE_MTH_sep) * 100, 2) END ) AS sep,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_oct)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_oct,0)) *100000 /SUM(CY_SALE_MTH_oct) * 100, 2) END ) AS oct,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_nov)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_nov,0)) *100000 /SUM(CY_SALE_MTH_nov) * 100, 2) END ) AS nov,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_dec)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_dec,0)) *100000 /SUM(CY_SALE_MTH_dec) * 100, 2) END ) AS DEC,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_jan)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_jan,0)) *100000 /SUM(CY_SALE_MTH_jan) * 100, 2) END ) AS jan,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_feb)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_feb,0)) *100000 /SUM(CY_SALE_MTH_feb) * 100, 2) END ) AS feb,"
						      +" ( CASE WHEN SUM(CY_SALE_MTH_mar)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_mar,0)) *100000 /SUM(CY_SALE_MTH_mar) * 100, 2) END ) AS mar"
						 +" FROM SM_SALES_SUMM_WIDE, sales_item"
						 +" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
						 +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
						 +" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
						    +" UNION ALL"
						+" SELECT '3.EXPNS_Bud%' AS tran,"
						       +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_apr) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS apr,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_may) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_may,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS may,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jun) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jun,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_jun * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jun,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jul) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jul,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_jul * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jul,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jul) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_aug,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_aug * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS aug,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_sep) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_sep,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_sep * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS sep,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_oct) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_oct,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_oct * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS oct,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_nov) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_nov,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_nov * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS nov,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_dec) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_dec,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_dec * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS DEC,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_jan) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jan,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_jan * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jan,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_feb) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_feb,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_feb * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS feb,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_mar) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_mar,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_MTH_mar * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS mar"
						+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd"
						+" WHERE trim(trn.fin_year)= '"+finYear+"'"
						+" AND trn.fin_year=mst.fin_year"
						+" AND trn.item_ser=mst.div_code"
						+" AND trn.item_code= sales_item.item_code"
						    +" AND brnd.brand_code(+) = sales_item.item_sub_group"
						    +" AND brnd.div_code(+) = sales_item.item_ser"
						    +" AND brnd.fin_year(+) = '"+finYear+"'"
						+" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
						+" )"
						+" WHERE '"+finYear+"'='"+finYear+"'";
				pstmt = conn.prepareStatement(sql);
				//year = "2014-15";
				rs = pstmt.executeQuery();
				while (rs.next())
				 {
					dataList = new ArrayList<String>();
					String tran = rs.getString("tran");
					keyList.add(tran);
					dataList.add(checkNull(rs.getString("APR")));
					dataList.add(checkNull(rs.getString("MAY")));
					dataList.add(checkNull(rs.getString("JUN")));
					dataList.add(checkNull(rs.getString("JUL")));
					dataList.add(checkNull(rs.getString("AUG")));
					dataList.add(checkNull(rs.getString("SEP")));
					dataList.add(checkNull(rs.getString("OCT")));
					dataList.add(checkNull(rs.getString("NOV")));
					dataList.add(checkNull(rs.getString("DEC")));
					dataList.add(checkNull(rs.getString("JAN")));
					dataList.add(checkNull(rs.getString("FEB")));
					dataList.add(checkNull(rs.getString("MAR")));
					hashMap.put(tran, dataList);
					System.out.println("keyList getExpenseGraphData====" + keyList);
			     }
			}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getExpenseGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}

		if (keyList.size() == 3)
		{
			System.out.println("keyList.toString()getExpenseGraphData =" + keyList.toString());
			System.out.println("keyList.size()getExpenseGraphData =" + keyList.size());
			expenceList = hashMap.get(keyList.get(0));
			toSalList = hashMap.get(keyList.get(1));
			System.out.println("hashMap.get(keyList.get(2) =" + hashMap.get(keyList.get(2)));
            tranSalList = hashMap.get(keyList.get(2));
			int count = 0;
			monthNameList  =this.getMonthList();
			for (int i = 0; i < expenceList.size(); i++)
			{
				rowData = new JSONObject();
				rowData.put("month", monthNameList.get(i));
				rowData.put("expense", expenceList.get(i));
				rowData.put("to_sal", toSalList.get(i));
				rowData.put("expense_bud", tranSalList.get(i));
				rawDataJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("rawDataJson ExpenseGraph is =" + rawDataJson);

		return rawDataJson;
	}

	
	
	//added nwe method for expense YTD sale graph
	
	@SuppressWarnings("unchecked")
	public JSONObject getExpenseYTDGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> expenceList = new ArrayList<String>();
		ArrayList<String> toSalList = new ArrayList<String>();
		ArrayList<String>  tranSalList = new ArrayList<String>();
		ArrayList<String> monthNameList =null;
		ArrayList<String> keyList = new ArrayList<String>();
		ArrayList<String> dataList = null;
		Map<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
		try
		{
		 //add new code by Birendra Pandey on dated 23 july-2014
		if(month!=null && month.trim().length()>0)
			{
				conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;
				System.out.println("Comming  month inside getExpenseYTDGraphData ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding in getExpenseYTDGraphData =="+month+"finYear =="+finYear);
												
				sql = " SELECT tran, apr,may,jun,jul,aug,sep,oct,nov,DEC,jan,feb,mar"
						+" FROM"
						+" ("
						+" SELECT '1.EXPENSE' AS tran,"
						       +" round(SUM(NVL(EXPENSE_ytd_APR,0))/100,1) AS apr,"
							   +" round(SUM(NVL(EXPENSE_ytd_may,0))/100,1) AS may,"
							   +" round(SUM(NVL(EXPENSE_ytd_jun,0))/100,1) AS jun,"
							   +" round(SUM(NVL(EXPENSE_ytd_jul,0))/100,1) AS jul,"
							   +" round(SUM(NVL(EXPENSE_ytd_aug,0))/100,1) AS aug,"
							   +" round(SUM(NVL(EXPENSE_ytd_sep,0))/100,1) AS sep,"
							   +" round(SUM(NVL(EXPENSE_ytd_oct,0))/100,1) AS oct,"
							   +" round(SUM(NVL(EXPENSE_ytd_nov,0))/100,1) AS nov,"
							   +" round(SUM(NVL(EXPENSE_ytd_dec,0))/100,1) AS DEC,"
							   +" round(SUM(NVL(EXPENSE_ytd_jan,0))/100,1) AS jan,"
							   +" round(SUM(NVL(EXPENSE_ytd_feb,0))/100,1) AS feb,"
							   +" round(SUM(NVL(EXPENSE_ytd_mar,0))/100,1) AS mar"
						+" FROM SM_SALES_SUMM_WIDE"
						+" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
						 +" UNION ALL"
						 +" SELECT '2.% to SALE' AS tran,"
						      +" ( CASE WHEN SUM(CY_SALE_ytd_apr)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_APR,0)) *100000 /SUM(CY_SALE_YTD_apr) * 100, 2) END ) AS apr,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_may)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_may,0)) *100000 /SUM(CY_SALE_YTD_may) * 100, 2) END ) AS may,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_jun)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_jun,0)) *100000 /SUM(CY_SALE_YTD_jun) * 100, 2) END ) AS jun,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_jul)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_jul,0)) *100000 /SUM(CY_SALE_YTD_jul) * 100, 2) END ) AS jul,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_aug)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_aug,0)) *100000 /SUM(CY_SALE_YTD_aug) * 100, 2) END ) AS aug,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_sep)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_sep,0)) *100000 /SUM(CY_SALE_YTD_sep) * 100, 2) END ) AS sep,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_oct)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_oct,0)) *100000 /SUM(CY_SALE_YTD_oct) * 100, 2) END ) AS oct,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_nov)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_nov,0)) *100000 /SUM(CY_SALE_YTD_nov) * 100, 2) END ) AS nov,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_dec)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_dec,0)) *100000 /SUM(CY_SALE_YTD_dec) * 100, 2) END ) AS DEC,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_jan)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_jan,0)) *100000 /SUM(CY_SALE_YTD_jan) * 100, 2) END ) AS jan,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_feb)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_feb,0)) *100000 /SUM(CY_SALE_YTD_feb) * 100, 2) END ) AS feb,"
						      +" ( CASE WHEN SUM(CY_SALE_YTD_mar)=0 THEN 0  "
									  +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_mar,0)) *100000 /SUM(CY_SALE_YTD_mar) * 100, 2) END ) AS mar"
						 +" FROM SM_SALES_SUMM_WIDE, sales_item"
						 +" WHERE trim(SM_SALES_SUMM_WIDE.fin_year)= '"+finYear+"'"
						 +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code"
						 +" AND sales_item.item_sub_group NOT IN ('CU','BJ')"
						+"     UNION ALL"
						+" SELECT '3.EXPNS_Bud%' AS tran,"
						       +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_apr) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS apr,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_may) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS may,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jun) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_jun * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jun,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jul) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_jul * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jul,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jul) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_aug * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS aug,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_sep) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_sep * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS sep,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_oct) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_oct * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS oct,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_nov) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_nov,0)+NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_nov * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS nov,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_dec) <>0 THEN"
						        +"          ROUND( SUM(NVL(mst.BUD_EXP_dec,0)+NVL(mst.BUD_EXP_nov,0)+NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_dec * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS DEC,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_jan) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_jan,0)+NVL(mst.BUD_EXP_dec,0)+NVL(mst.BUD_EXP_nov,0)+NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_jan * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS jan,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_feb) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_feb,0)+NVL(mst.BUD_EXP_jan,0)+NVL(mst.BUD_EXP_dec,0)+NVL(mst.BUD_EXP_nov,0)+NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_feb * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS feb,"
								+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_mar) <>0 THEN"
						                 +" ROUND( SUM(NVL(mst.BUD_EXP_mar,0)+NVL(mst.BUD_EXP_feb,0)+NVL(mst.BUD_EXP_jan,0)+NVL(mst.BUD_EXP_dec,0)+NVL(mst.BUD_EXP_nov,0)+NVL(mst.BUD_EXP_oct,0)+NVL(mst.BUD_EXP_sep,0)+NVL(mst.BUD_EXP_aug,0)+NVL(mst.BUD_EXP_jul,0)+NVL(mst.BUD_EXP_jun,0)+NVL(mst.BUD_EXP_may,0)+NVL(mst.BUD_EXP_apr,0))*1000 "
						                 +" / SUM(trn.FLD_TRGT_YTD_mar * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100)"
										 +" * 100 ,1) "
						  		+" ELSE ROUND(0*100,1) END) AS mar"
						+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd"
						+" WHERE trim(trn.fin_year)= '"+finYear+"'"
						+" AND trn.fin_year=mst.fin_year"
						+" AND trn.item_ser=mst.div_code"
						+" AND trn.item_code= sales_item.item_code"
						    +" AND brnd.brand_code(+) = sales_item.item_sub_group"
						    +" AND brnd.div_code(+) = sales_item.item_ser"
						    +" AND brnd.fin_year(+) = '"+finYear+"'"
						+" AND sales_item.item_sub_group NOT IN ('CU','BJ') )"
						+" WHERE '"+finYear+"'='"+finYear+"'";

				pstmt = conn.prepareStatement(sql);
				//year = "2014-15";
				rs = pstmt.executeQuery();
				while (rs.next())
				 {
					dataList = new ArrayList<String>();
					String tran = rs.getString("tran");
					keyList.add(tran);
					dataList.add(checkNull(rs.getString("APR")));
					dataList.add(checkNull(rs.getString("MAY")));
					dataList.add(checkNull(rs.getString("JUN")));
					dataList.add(checkNull(rs.getString("JUL")));
					dataList.add(checkNull(rs.getString("AUG")));
					dataList.add(checkNull(rs.getString("SEP")));
					dataList.add(checkNull(rs.getString("OCT")));
					dataList.add(checkNull(rs.getString("NOV")));
					dataList.add(checkNull(rs.getString("DEC")));
					dataList.add(checkNull(rs.getString("JAN")));
					dataList.add(checkNull(rs.getString("FEB")));
					dataList.add(checkNull(rs.getString("MAR")));
					hashMap.put(tran, dataList);
					System.out.println("keyList getExpenseYTDGraphData====" + keyList);
			     }
			}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getExpenseYTDGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}

		if (keyList.size() == 3)
		{
			System.out.println("keyList.toString()getExpenseYTDGraphData =" + keyList.toString());
			System.out.println("keyList.size()getExpenseYTDGraphData =" + keyList.size());
			expenceList = hashMap.get(keyList.get(0));
			toSalList = hashMap.get(keyList.get(1));
            tranSalList = hashMap.get(keyList.get(2));
			int count = 0;
			monthNameList  =this.getMonthList();
			for (int i = 0; i < expenceList.size(); i++)
			{
				rowData = new JSONObject();
				rowData.put("month", monthNameList.get(i));
				rowData.put("expense", expenceList.get(i));
				rowData.put("to_sal", toSalList.get(i));
				rowData.put("expense_bud", tranSalList.get(i));
				rawDataJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("rawDataJson Expense YTD Graph is =" + rawDataJson);

		return rawDataJson;
	}
	//ended nwe method for expense YTD sale graph
	
	
	
	/*** End of method getProfitGraphData() 
	 * @author base
	 * @param  metedata as xml file by client side
	 * @return JSONObject
	 * @throws RemoteException, ITMException
	 * @
	 * ***/	
	
	private ArrayList<String> getMonthList()
	{

		ArrayList<String> monthNameList = new ArrayList<String>();

		monthNameList.add("APR");
		monthNameList.add("MAY");
		monthNameList.add("JUN");
		monthNameList.add("JUL");
		monthNameList.add("AUG");
		monthNameList.add("SEP");
		monthNameList.add("OCT");
		monthNameList.add("NOV");
		monthNameList.add("DEC");
		monthNameList.add("JAN");
		monthNameList.add("FEB");
		monthNameList.add("MAR");
		return monthNameList;
	}

	//Add this code by swati on dated 5Jul
	
	
	
	  /*** Method:5 - This method will contains raw data for rendering Monthly Sales graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getMnthlySalesGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataMthlySalesJson = new JSONObject();
		JSONObject rowData = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		String finYear="";
		try
		{
		   if(month!=null && month.trim().length()>0)
			{
		    	conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;
				System.out.println("Comming  month inside getMnthlySalesGraphData ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding in getMnthlySalesGraphData =="+month+"finYear =="+finYear);
				sql =" SELECT b.group_no,b.div_group,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
			    		+" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
			    		+" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
			    		+" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
			    		+" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
			    		+" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
			    		+" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,ROUND(SUM (a.sale_mth_cy)/	SUM (a.hotrgt_mth_cy)* 100,2) AS MTH_ACH_PER,(CASE WHEN SUM(a.sale_mth_ly)<>0 "
			    		+" THEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) "
			    		+" ELSE ROUND(0*100,1)  END) AS MTH_GR,ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
			    		+" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
			    		+" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT,(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
			    		+" THEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) "
			    		+" ELSE ROUND(0*100,1)  END) AS YTD_GR,ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
			    		+" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
			    		+" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
			    		+" SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
			    		+" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,1) AS PMPM,SUM(b.pmpm_ly) AS PMPM_LY, "
			    		+" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
			    		+" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
			    		+" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
			    		+" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
			    		+" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
			    		+" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
			    		+" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
			    		+" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
			    		+" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
			    		+" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
			    		+" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
			    		+" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,"  
			    		+" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
			    		+" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) "	         
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
			    		+" AS trgt_mth_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
			    		+" AS sale_YTD_cy, " 
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
			    		+" AS sale_YTD_ly," 
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
			    		+" AS trgt_YTD_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
			    		+" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
			    		+" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
			    		+" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
			    		+" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
			    		+" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 	
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
			    		+" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
			    		+" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
			    		+" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
			    		+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) "	
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) "	
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
			    		+" AS retu_ytd_cy "
			    		+" FROM SM_SALES_SUMM_WIDE, sales_item " 
			    		+" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
			    		+" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "             
			    		+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
			    		+" AND '"+month+"' =	'"+month+"' "		
			    		+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
			    		+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
			    		+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "     
			    		+" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp "    
			    		+" AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
			    		+" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
			    		+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
			    		+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
			    		+" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
			    		+" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
			    		+" GROUP BY finyr, table_no ) c "
			    		+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
			    		+" AND trim(a.item_ser)=trim(c.table_no) "
			    		+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
			    		+" AND b.div_group <> 'OTHERS' GROUP BY b.group_no,b.div_group ORDER BY group_no,div_group ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;		
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("division_grp",  checkNull(rs.getString("div_group")));
				rowData.put("mth_sales_val", rs.getString("mth_cy_sales"));
				rowData.put("avg_month_sal", rs.getString("avg_mthly"));
				rowData.put("req_month_sal", rs.getString("reqd_mthly"));
				rowData.put("growt_perc",    rs.getString("mth_gr"));
				rowData.put("ho_ach", rs.getString("MTH_ACH_PER"));
				rawDataMthlySalesJson.put(count, rowData);
				count++;				
				
			}
		}
			System.out.println("fetch Data for Mnthly Sales Graph rawjson====" + rawDataMthlySalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getMnthlySalesGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMthlySalesJson;
	}
    
	/*** Method:6 - This method will contains Raw data for rendering YTD Sales graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getYTDSalesGraphData(String dataSourceName,String month) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear=""; 
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();		
		try
		{
		    if(month!=null && month.trim().length()>0)
				{
			    	conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					System.out.println("Comming  month inside getYTDSalesGraphData ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("updates month and year from dcoding in getYTDSalesGraphData =="+month+"finYear =="+finYear);
				
					sql  =" SELECT b.group_no,b.div_group,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
				    		+" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
				    		+" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
				    		+" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
				    		+" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
				    		+" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
				    		+" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,(CASE WHEN SUM(a.sale_mth_ly)<>0 "
				    		+" THEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) "
				    		+" ELSE ROUND(0*100,1)  END) AS MTH_GR,ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
				    		+" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
				    		+" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT, "
						   +" (CASE WHEN SUM (a.hotrgt_ytd_cy)= 0 THEN 0 ELSE ROUND(SUM (a.sale_ytd_cy)/SUM (a.hotrgt_ytd_cy)* 100,1) END)  AS YTD_ACH_PER, "
						   +" (CASE WHEN SUM(a.sale_ytd_ly)<>0 "
				    		+" THEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) "
				    		+" ELSE ROUND(0*100,1)  END) AS YTD_GR,ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
				    		+" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
				    		+" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
				    		+" SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
				    		+" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,2) AS PMPM,round(SUM(b.pmpm_ly),2) AS PMPM_LY, "
				    		+" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
				    		+" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
				    		+" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
				    		+" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
				    		+" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
				    		+" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
				    		+" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
				    		+" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
				    		+" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
				    		+" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
				    		+" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
				    		+" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,"  
				    		+" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
				    		+" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) "	         
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
				    		+" AS trgt_mth_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
				    		+" AS sale_YTD_cy, " 
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
				    		+" AS sale_YTD_ly," 
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
				    		+" AS trgt_YTD_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
				    		+" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
				    		+" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
				    		+" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
				    		+" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
				    		+" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 	
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
				    		+" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
				    		+" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
				    		+" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
				    		+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) "	
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) "	
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
				    		+" AS retu_ytd_cy "
				    		+" FROM SM_SALES_SUMM_WIDE, sales_item " 
				    		+" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
				    		+" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "             
				    		+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
				    		+" AND '"+month+"' ='"+month+"' "		
				    		+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
				    		+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
				    		+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "     
				    		+" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp "    
				    		+" AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
				    		+" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
				    		+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
				    		+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
				    		+" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
				    		+" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
				    		+" GROUP BY finyr, table_no ) c "
				    		+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
				    		+" AND trim(a.item_ser)=trim(c.table_no) "
				    		+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
				    		+" AND b.div_group <> 'OTHERS' GROUP BY b.group_no,b.div_group ORDER BY group_no,div_group ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("division_grp", checkNull(rs.getString("div_group")));
				rowData.put("sal", rs.getString("ytd_cy_sales"));
				rowData.put("gr", rs.getString("ytd_gr"));
				rowData.put("ho_ach", rs.getString("YTD_ACH_PER"));
				//check property in sql nowwwwwww--
				//add new property for YTD on 8/01/2015 by Birendra Pandey
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
                rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				//Add new new property on date 8-Jan-15 by Birendra Pandey for Month sales graph
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
               //add new property for  PMPM on 8/01/2015 by Birendra Pandey
                rowData.put("pmpm", rs.getString("PMPM"));
			    rowData.put("pmpm_ly", rs.getString("PMPM_LY"));			       
			   //end of code by Birendra   
			    
				rawDataYTDSalesJson.put(count, rowData);
				count++;
				
			}
		}
			System.out.println("fetch Data for YTD Sales Graph rawjson====" + rawDataYTDSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getYTDSalesGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataYTDSalesJson;
	}

//start new changes in sales dashboard on date 25-Dec-14 By Birendra Pandey
	
	@SuppressWarnings("unchecked")
	public JSONObject getDivisionWiseGraph(String dataSourceName,String month,String divGrp) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear=""; 
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();		
		try
		{
			
		    if(month!=null && month.trim().length()>0 && divGrp!=null)
				{
			    	conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					divGrp=divGrp.trim();
					System.out.println("Comming  month inside getDivisionWiseGraph ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("updates month and year from dcoding in getYTDSalesGraphData =="+month+"finYear =="+finYear);
					sql =" SELECT b.div_group,b.div_code,B.DIV_DESCR,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
                            +" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
                            +" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
                            +" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
                            +" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
                            +" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
                            +" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
                            +" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT, " 
			                +" CASE WHEN SUM (a.hotrgt_mth_cy) =0 THEN 0 ELSE ROUND(SUM (a.sale_mth_cy)/SUM (a.hotrgt_mth_cy)*100,2) END AS MTH_ACH_PER, "
		                	+" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
                            +" THEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) "
                            +" ELSE ROUND(0*100,1)  END) AS MTH_GR,ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
                            +" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
                            +" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT,(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
                            +" THEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) "
                            +" ELSE ROUND(0*100,1)  END) AS YTD_GR,ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
                            +" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
                            +" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
                            +" SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
                            +" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,1) AS PMPM,SUM(b.pmpm_ly) AS PMPM_LY, "
                            +" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
			                +" CASE WHEN SUM (a.hotrgt_YTD_cy) = 0 THEN 0 ELSE ROUND(SUM (a.sale_YTD_cy)/SUM (a.hotrgt_YTD_cy)*100,2) END AS YTD_ACH_PER, "
                            +" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
                            +" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
                            +" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
                            +" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
                            +" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
                            +" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
                            +" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
                            +" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
                            +" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
                            +" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
                            +" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser," 
                            +" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
                            +" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
                            +" AS trgt_mth_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
                            +" AS sale_YTD_cy, " 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
                            +" AS sale_YTD_ly," 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
                            +" AS trgt_YTD_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
                            +" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2)='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
                            +" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
                            +" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
                            +" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
                            +" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
                            +" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
                            +" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
                            +" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
                            +" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
                            +" AS retu_ytd_cy "
                            +" FROM SM_SALES_SUMM_WIDE, sales_item " 
                            +" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
                            +" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) " 
                            +" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
                            +" AND '"+month+"' =    '"+month+"' " 
                            +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
                            +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
                            +" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group " 
                            +" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp " 
                            +" AND brnd.div_code(+) = dwh.item_ser AND brnd.fin_year(+) = dwh.fin_year " 
                            +" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
                            +" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
                            +" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
                            +" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
                            +" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
                            +" GROUP BY finyr, table_no ) c "
                            +" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
                            +" AND trim(a.item_ser)=trim(c.table_no) "
                            +" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
                            +" AND b.div_group <> 'OTHERS' AND b.div_group ='"+ divGrp + "' GROUP BY b.div_group,b.div_code,B.DIV_DESCR ORDER BY div_group,b.div_code";
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								int count = 0;
								
								while (rs.next())
								{
									rowData = new JSONObject();
									//this part will used for YTD sale graph
									rowData.put("div_code", checkNull(rs.getString("div_code")));
									rowData.put("div_descr", checkNull(rs.getString("DIV_DESCR")));
									rowData.put("ytd_cy_sales", rs.getString("YTD_CY_SALES"));
									rowData.put("ytd_gr", rs.getString("YTD_GR"));
									rowData.put("ytd_ach_extra", rs.getString("YTD_ACH_EXTRA"));
									//add new property for YTD on 7/01/2015 by Birendra Pandey
                                    rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
									rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
                                    rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
									//Add new new property on date 7-Jan-15 by Birendra Pandey for Month sales graph
									rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
									rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
									rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
									rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
									rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
									rowData.put("mth_gr", rs.getString("MTH_GR"));
                                   //add new property for  PMPM on 7/01/2015 by Birendra Pandey
                                    rowData.put("pmpm", rs.getString("PMPM"));
								    rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
								    rowData.put("ytd_ach_per", rs.getString("YTD_ACH_PER")); 
								   //end of code by Birendra                                   
									rawDataYTDSalesJson.put(count, rowData);
									count++;
								}
							}
							System.out.println("fetch Data for YTD Sales Graph rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getYTDSalesGraphData:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	
//end of method for get Division wise graph on date 25-Dec-14
	
	
	//start of method for get Division wise graph on date 30-Dec-14
	
	@SuppressWarnings("unchecked")
	public JSONObject getTopBrandYTD(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear=""; 
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();		
		try
		{
		    if(month!=null && month.trim().length()>0 && divDescr!=null)
				{
			    	conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					divDescr=divDescr.trim();
					System.out.println("Comming  month inside getTopBrandYTD ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("select Sql for TopBrandWiseGraph =="+month+"finYear =="+finYear);
					//Note removed this section and build new sql swati
					sql ="SELECT sr_no, brand_name, divmst.div_descr, "
							+ "ROUND(trgt_ytd_cy/10000000,2) AS trgt_ytd,"
							+ "ROUND(hotrgt_ytd_cy/10000000,2) AS hotrgt_ytd_cy,"
							+ "ROUND(sale_YTD_cy/10000000,2) AS sale_YTD_cy, "
							+ "ROUND(sale_YTD_ly/10000000,2) AS sale_YTD_ly,"
							+ "(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0"
							+ "ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,"
							+ "(CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 0"
							+ "ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS 	gr_prcnt,"
							+ "c.psr AS NO_OF_SO,"
							+ "ROUND(DWH.sale_ytd_cy/10000000/c.psr/(CASE WHEN SUBSTR('"+month+"',5,2)<4 	THEN SUBSTR('"+month+"',5,2)+9 ELSE SUBSTR('"+month+"',5,2)-3 END) ,2) AS PMPM,"
							+ "ROUND(terr100/totterr*100,1) AS terr100prcnt"
							+ " FROM ("
							+ "SELECT row_number() OVER( ORDER BY sale_YTD_cy DESC ) AS sr_no,"
							+ "fin_year, item_ser, sub_grp AS brand_name,"
							+ "sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy,"
							+ "totterr, terr100"
							+ " FROM ("
							+ "SELECT fin_year, item_ser, sub_grp,"
							+ " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,"
							+ " SUM(trgt_YTD_cy) AS trgt_YTD_cy, SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy, SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100" 
							+ " FROM("
							+ " SELECT dwh.fin_year , dwh.item_ser, "
							+ " dwh.grp_nm AS sub_grp,dwh.terr_code, " 
							+ " SUM(sale_YTD_cy) AS sale_YTD_cy, "
							+ " SUM(sale_YTD_ly) AS sale_YTD_ly, "
							+ " SUM(trgt_YTD_cy) AS trgt_YTD_cy,"
							+ " ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, "
							+ " 1 AS terrcnt,"
							+ " (CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " 
							+ " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 "
							+ "  THEN 1 ELSE 0 END ) AS terr100cnt "
							+ " FROM (   "
							+ " SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "
							+ "  sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm,"
							+ "  SM_SALES_SUMM_WIDE.terr_code AS terr_code," 
							+ "  (CASE WHEN SUBSTR('"+month+"',5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, "
							+ "  (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, "
							+ "  (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy "
							+ "  FROM SM_SALES_SUMM_WIDE, sales_item "
							+ "  WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "
							+ "  ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
							+ " AND '"+month+"' =   '"+month+"'"
							+ " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " 
							+ " AND sales_item.item_sub_group NOT IN ('CU','BJ') "
							+ " AND sales_item.item_SER_DESCR = '"+ divDescr + "'"
							+ " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group," 
							+ " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code 	"
							+ " )dwh,SM_SALES_BRAND_MST brnd"
							+ "  WHERE brnd.brand_code(+) = dwh.sub_grp "
							+ "  AND brnd.div_code(+) = dwh.item_ser "
							+ "  AND brnd.fin_year(+) = dwh.fin_year "
							+ "  AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 "
							+ "  GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code  )"
							+ " GROUP BY fin_year, item_ser, sub_grp )  "
							+ " ) dwh, SM_SALES_DIV_MST divmst, "
							+ " ( "
							+  " SELECT finyr, table_no, SUM(psr) AS psr" 
							+ " FROM (" 
							+ " SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR "
							+ " FROM starclub.emp_sales "
							+ " WHERE  " 
							+ " LEVEL_NO = 4 " 
							+ " GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code )"
							+ " GROUP BY finyr, table_no "
							+ " ) c "
							+ " WHERE dwh.item_ser= divmst.div_code " 
							+ " AND trim(DWH.item_ser)=trim(c.table_no) "
							+ " AND TRIM(divmst.div_descr) =TRIM('"+ divDescr + "')"
							+ " AND c.finyr = SUBSTR(DWH.fin_year,3,2)||SUBSTR(DWH.fin_year,6,2) " 
							+ " AND dwh.fin_year= divmst.fin_year "
							+ " AND dwh.sr_no <=10  ORDER BY sr_no";
					

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;
								
					while (rs.next())
						{
							rowData = new JSONObject();	
							//add new proprety
							rowData.put("ytd_ho_trgt", rs.getString("hotrgt_ytd_cy"));								
							rowData.put("brand_name", checkNull(rs.getString("brand_name")));
							rowData.put("div_descr", checkNull(rs.getString("div_descr")));
							rowData.put("sale_ytd_cy", rs.getString("sale_YTD_cy"));
							rowData.put("gr_prcnt", rs.getString("gr_prcnt"));
							rowData.put("ho_ach_prcnt", rs.getString("ho_ach_prcnt"));
                            rowData.put("pmpm", rs.getString("PMPM"));						    
							rawDataYTDSalesJson.put(count, rowData);
							count++;
							
							
						}
				}
					System.out.println("fetch Data for getTopBrandYTD rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getTopBrandYTD:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	//start of method for get Division wise graph on date 30-Dec-14	
	// 
	@SuppressWarnings("unchecked")
	public JSONObject getTopBrandMTH(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear=""; 
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();		
		try
		{
		    if(month!=null && month.trim().length()>0 && divDescr!=null)
				{
			    	conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					divDescr=divDescr.trim();
					System.out.println("Comming  month inside getTopBrandMTH ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("select Sql for getTopBrandMTH =="+month+"finYear =="+finYear);
					//Note removed this section and build new sql swati
															
					sql  = " SELECT sr_no, brand_name, divmst.div_descr, "
							+ "	ROUND(trgt_MTH_cy/10000000,2) AS trgt_MTH, "
							+ "	ROUND(hotrgt_MTH_cy/10000000,2) AS hotrgt_MTH_cy, "
							+ " ROUND(sale_MTH_cy/10000000,2) AS sale_MTH_cy," 
							+ "	ROUND(sale_MTH_ly/10000000,2) AS sale_MTH_ly, "
							+ " (CASE WHEN NVL(hotrgt_MTH_cy,0) = 0 THEN 0 "
							+ "	ELSE ROUND(sale_MTH_cy/hotrgt_MTH_cy * 100,1) END ) AS ho_ach_prcnt, "
							+ " (CASE WHEN NVL(sale_MTH_ly,0) = 0 THEN 0 "
							+ "	ELSE ROUND((sale_MTH_cy -sale_MTH_ly)/ sale_MTH_ly* 100,1) END) AS gr_prcnt, "
							+ " c.psr AS NO_OF_SO, "
							+ " ROUND(DWH.sale_MTH_cy/10000000/c.psr/ "
							+ " (CASE WHEN SUBSTR('"+month+"',5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) "
							+ " ,2) AS PMPM, "
							+ "	ROUND(terr100/totterr*100,1) AS terr100prcnt "
							+ " FROM ( "
							+ " SELECT row_number() OVER( ORDER BY sale_MTH_cy DESC ) AS sr_no, "
							+ " fin_year, item_ser, sub_grp AS brand_name, "
							+ "	sale_MTH_cy, sale_MTH_ly, trgt_MTH_cy, hotrgt_MTH_cy, "
							+ " totterr, terr100 "
							+ " FROM ( "
							+ " SELECT fin_year, item_ser, sub_grp, "
							+ " SUM(sale_MTH_cy) AS sale_MTH_cy, SUM(sale_MTH_ly) AS sale_MTH_ly, "
							+ "	SUM(trgt_MTH_cy) AS trgt_MTH_cy, "
							+ "	SUM(hotrgt_MTH_cy) AS hotrgt_MTH_cy,  "
							+ " SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 "
							+ " FROM( "
							+ " SELECT dwh.fin_year , dwh.item_ser, "
							+ "	dwh.grp_nm AS sub_grp,dwh.terr_code, "
							+ " SUM(sale_MTH_cy) AS sale_MTH_cy,  "
							+ "	SUM(sale_MTH_ly) AS sale_MTH_ly,  "
							+ "	SUM(trgt_MTH_cy) AS trgt_MTH_cy, "
							+ " ROUND(SUM(trgt_MTH_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_MTH_cy,  "
							+ " 1 AS terrcnt, "
							+ " (CASE WHEN SUM(trgt_MTH_cy) =0 THEN 1 "
							+ " WHEN ROUND(SUM( sale_MTH_cy) / SUM(trgt_MTH_cy *  (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt "
							+ " FROM (   "
							+ " SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "
							+ " sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, "
							+ " SM_SALES_SUMM_WIDE.terr_code AS terr_code, "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_MTH_APR) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT)  "
							+ "	WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_MTH_cy,  "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_MTH_APR)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_MTH_MAY)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_MTH_JUN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_MTH_ly, "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) AS trgt_MTH_cy  "
							+ " FROM SM_SALES_SUMM_WIDE, sales_item "
							+ " WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) " 
							+ " ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
							+ " AND '"+month+"' =	'"+month+"' "
							+ " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
							+ " AND sales_item.item_sub_group NOT IN ('CU','BJ')"
							+ " AND SM_SALES_SUMM_WIDE.TERR_CODE NOT IN('COGS','EXPNS') "
							+ " AND sales_item.item_SER_DESCR = '"+ divDescr + "'"
							+ " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, "
							+ " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code "
							+ " ) 	 dwh,     SM_SALES_BRAND_MST brnd "
							+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
							+ " AND brnd.div_code(+) = dwh.item_ser "
							+ " AND brnd.fin_year(+) = dwh.fin_year "
							+ " AND dwh.sale_MTH_cy+ dwh.trgt_MTH_cy <>0  "
							+ " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code "
							+ " ) "
							+ " GROUP BY fin_year, item_ser, sub_grp"
							+ " ) "
							+ " ) dwh, "
							+ " SM_SALES_DIV_MST divmst,"
							+ " ( "
							+ " SELECT finyr, table_no, SUM(psr) AS psr "
							+ " FROM ("
							+ "SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR"
							+ " FROM starclub.emp_sales"
							+ " WHERE "
							+ " LEVEL_NO = 4 "
							+ " GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code)"
							+ " GROUP BY finyr, table_no"
							+ ") c "
							+ " WHERE dwh.item_ser= divmst.div_code "
							+ " AND trim(DWH.item_ser)=trim(c.table_no) "
							+ " AND TRIM(divmst.div_descr) =TRIM('"+ divDescr + "')"
							+ " AND c.finyr = SUBSTR(DWH.fin_year,3,2)||SUBSTR(DWH.fin_year,6,2) "
							+ " AND dwh.fin_year= divmst.fin_year "
							+ " AND dwh.sr_no <= 10 "
							+ " ORDER BY sr_no  ";


							//Note end removed this section and build new sql swati

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;
								
					while (rs.next())
						{
							rowData = new JSONObject();
							//Add new code												 
							rowData.put("mth_ho_trgt", rs.getString("hotrgt_MTH_cy"));	
							rowData.put("brand_name", checkNull(rs.getString("brand_name")));
							rowData.put("div_descr", rs.getString("div_descr"));
							rowData.put("trgt_mth", rs.getString("trgt_MTH"));
							rowData.put("sale_mth_cy", rs.getString("sale_MTH_cy"));
							rowData.put("sale_mth_ly", rs.getString("sale_MTH_ly"));
							rowData.put("ho_ach_prcnt", rs.getString("ho_ach_prcnt"));
							rowData.put("gr_prcnt", rs.getString("gr_prcnt"));
							rowData.put("no_of_so", rs.getString("NO_OF_SO"));
							rowData.put("pmpm", rs.getString("PMPM"));
							rowData.put("terr100prcnt", rs.getString("terr100prcnt"));
							rawDataYTDSalesJson.put(count, rowData);
							count++;
						}
				}
					System.out.println("fetch Data for getTopBrandMTH rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getTopBrandMTH:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	
	
	//Start  of method for get zone wise graph on date 30-Dec-14
	@SuppressWarnings({ "unchecked", "unchecked" })
	@Override
    public JSONObject getZoneWiseDetail(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
    {
		JSONObject rawDataZoneWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			System.out.println("Comming  month inside getZoneWiseDetail ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getZoneWiseDetail =="+month+"finYear =="+finYear);
						
			sql  =" SELECT   b.div_group, b.div_code,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ZONE_DESCR,"
					+ "  (CASE "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = 3    THEN ROUND (0, 1) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) < 3    THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ "  ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR('"+month+"', 5, 2) + 3)/ 10000000,1) END ) AS reqd_mthly, " 
					+ "  ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN	SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "  ELSE SUBSTR ('"+month+"', 5, 2) - 3 END)/ 10000000,1) AS avg_mthly, " 
					+ "  ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ "  ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, " 
					+ " (CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 2) END) AS mth_ach_per, " 
					+ " (CASE WHEN SUM (a.sale_mth_ly) <> 0 THEN ROUND (SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly) * 100,1) " 
					+ " ELSE ROUND (0 * 100, 1)          END         ) AS mth_gr, "
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt,"
					+ " (CASE WHEN SUM (a.sale_ytd_ly) <> 0 THEN ROUND (  SUM (a.sale_ytd_cy -	a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) "
					+ " ELSE ROUND (0 * 100, 1)  END  ) AS ytd_gr, "
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (  SUM (a.sale_ytd_cy) / 100000/ SUM (c.psr)/ (CASE "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR	('"+month+"', 5, 2) + 9 "
					+ " ELSE SUBSTR ('"+month+"', 5, 2) - 3 END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra,"
					+"  (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 2) END) AS YTD_ach_per, "
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "  ELSE ROUND (0 * 100, 1) END) AS retu_ytd_prct " 
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR, "
					+ " SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly, "
					+ " SUM (  trgt_mth_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, "
					+ " SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/100) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy, "
					+ " SUM (sale_qrt2_cy) AS sale_qrt2_cy, "
					+ " SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy, "
					+ " SUM (  trgt_annual_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt,0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ " FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group AS sub_grp, "
					+ " sm_sales_summ_wide.TERR_CODE,  "
					+ " SALES_TERRITORY.ZONE_DESCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END ) AS sale_mth_cy,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END ) AS sale_mth_ly,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ " END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END) AS sale_ytd_ly, " 
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ " END) AS trgt_ytd_cy, " 
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) " 
					+ " END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep)- SUM (cy_sale_ytd_jun) END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10'  THEN SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11'  THEN SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01'  THEN SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02'  THEN SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw, territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST  "
					+ " WHERE TRIM (fin_year) = (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN    SUBSTR ('"+month+"' - 100, 1, 4) || '-' || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1,4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2)   END) "
					+ " AND '"+month+"' = '"+month+"' "
					+ " AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code =  sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ " GROUP BY fin_year, sm_sales_summ_wide.item_ser,sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_DESCR	"
					+ " ) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4  "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS' "
					+ " AND trim(b.div_descr) =trim('"+divDescr +"')"
					+ " GROUP BY b.div_group, b.div_code,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END "
					+ " ORDER BY div_group, b.div_code,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ";


			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("zone_descr", checkNull(rs.getString("ZONE_DESCR")));
				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
				rowData.put("ytd_gr", rs.getString("ytd_gr"));
				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				
				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
				rawDataZoneWiseJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for  Zone Wise Detail====" + rawDataZoneWiseJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getZoneWiseDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataZoneWiseJson;
    }
	
	//end of method for get zone wise graph on date 30-Dec-14
	
	
	//start of method for get region wise graph on date 30-Dec-14
	

    @SuppressWarnings("unchecked")
	public JSONObject getZoneWiseMetroDetail(String dataSourceName, String month, String divGrp,String divDescr, String zoneDescr) throws RemoteException, ITMException
    {
		JSONObject rawDataResionWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			System.out.println("Comming  month inside getZoneWiseMetroDetail ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getZoneWiseMetroDetail =="+month+"finYear =="+finYear);
			
			sql  =" SELECT   b.div_group, b.div_code,B.DIV_DESCR,A.ZONE_code,A.ZONE_DESCR,"
					+ "	CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END METRO_DSCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = 3  THEN ROUND (0, 1) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) < 3  THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ "  ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) "
					+ "  END) AS reqd_mthly, "
					+ "  ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	 ELSE SUBSTR ('"+month+"', 5, 2) - 3 " 
					+ "	 END)/ 10000000,1) AS avg_mthly, "
					+ "  ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ "  ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, "
				    + "  (CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 2) END) AS mth_ach_per, " 
					+ "  (CASE WHEN SUM (a.sale_mth_ly) <> 0 THEN ROUND (  SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly)* 100,1) "
					+ "	 ELSE ROUND (0 * 100, 1) "
					+ "  END) AS mth_gr, "
					+ "  ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ "  ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ "  ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt, "
					+ "  (CASE WHEN SUM (a.sale_ytd_ly) <> 0 THEN ROUND (  SUM (a.sale_ytd_cy - a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) "
					+ "  ELSE ROUND (0 * 100, 1) "
					+ "	 END) AS ytd_gr, "
					+ "  ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ "  ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ "  ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ "  ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ "  ROUND (  SUM (a.sale_ytd_cy)/ 100000/ SUM (c.psr)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	 ELSE SUBSTR ('"+month+"', 5, 2) - 3  "
					+ "	 END),1) AS pmpm, "
					+ "  SUM (b.pmpm_ly) AS pmpm_ly, "
					+ "  ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra, "
					+ " (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 2) END) AS YTD_ach_per, " 
					+ "  (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "	 ELSE ROUND (0 * 100, 1) "
					+ "  END) AS retu_ytd_prct "
					+ "  FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR, "
					+ "	 DWH.TERR_DESCR,DWH.METRO_DSCR,SUM (sale_mth_cy) AS sale_mth_cy, "
					+ "  SUM (sale_mth_ly) AS sale_mth_ly,SUM (  trgt_mth_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ "  SUM (sale_ytd_cy) AS sale_ytd_cy, SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ "  SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100 ) AS hotrgt_ytd_cy, "
					+ "  SUM (sale_qrt1_cy) AS sale_qrt1_cy,SUM (sale_qrt2_cy) AS sale_qrt2_cy,SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ "  SUM (sale_qrt4_cy) AS sale_qrt4_cy,SUM (  trgt_annual_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ "  SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ "	 FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ "	 sales_item.item_sub_group AS sub_grp,sm_sales_summ_wide.TERR_CODE, "
					+ "	 SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	 SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR AS METRO_DSCR,"
					+ "	 (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ "  END) AS sale_mth_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ "  END) AS sale_mth_ly, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ "  END) AS trgt_mth_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ "  END) AS sale_ytd_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) " 
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ "  END ) AS sale_ytd_ly, "                             
					+ "	 (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ "	 END) AS trgt_ytd_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ "  ELSE SUM (cy_sale_ytd_jun) "
					+ "  END) AS sale_qrt1_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ "  ELSE   SUM (cy_sale_ytd_sep) - SUM (cy_sale_ytd_jun) "
					+ "  END) AS sale_qrt2_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ "  ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) "
					+ "  END) AS sale_qrt3_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ "  ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) "
					+ "  END ) AS sale_qrt4_cy, "
					+ "  SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ "  END) AS retu_ytd_cy "
					+ "  FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "   
					+ "  WHERE TRIM (fin_year) = "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN    SUBSTR ('"+month+"' - 100, 1, 4)  || '-'  || SUBSTR ('"+month+"', 3, 2) "
					+ "  ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ "  END) "
					+ "  AND '"+month+"' = '"+month+"' "
					+ "  AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ "  AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE "
					+ "  AND sm_sales_summ_wide.item_code = sales_item.item_code "
					+ "  AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ "  AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ "	 GROUP BY fin_year, sm_sales_summ_wide.item_ser, "
					+ "  sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	 SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR) dwh, sm_sales_brand_mst brnd "
					+ "  WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ "  AND brnd.div_code(+) = dwh.item_ser "
					+ "  AND brnd.fin_year(+) = dwh.fin_year "
					+ "  GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,DWH.TERR_DESCR,DWH.METRO_DSCR) a, "
					+ "  sm_sales_div_mst b, "
					+ "  (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ "  FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ "  pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ "  FROM starclub.emp_sales "
					+ "  WHERE level_no = 4 "
					+ "  GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ "  GROUP BY finyr, table_no) c "
					+ "  WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ "  AND b.fin_year = a.fin_year "
					+ "  AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ "  AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ "  AND b.div_group <> 'OTHERS'  "
					//+ "  AND b.div_group ='"+ divGrp + "'"
					+ "  AND TRIM(b.div_DESCR) =trim('"+ divDescr + "')"
					+ "  AND TRIM(A.ZONE_descr) = TRIM('" + zoneDescr + "')"
					+ " GROUP BY b.div_group, b.div_code,B.DIV_DESCR,A.ZONE_CODE,A.ZONE_DESCR,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END "
					+ " ORDER BY div_group, b.div_code,A.ZONE_CODE ,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END ";



			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();				
				rowData.put("metro_dscr", checkNull(rs.getString("METRO_DSCR")));
				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
				rowData.put("ytd_gr", rs.getString("ytd_gr"));
				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
				rawDataResionWiseJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for  zone Wise metra Detail====" + rawDataResionWiseJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getZoneWiseMetroDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataResionWiseJson;
    }
	
	//end of method for get region wise graph on date 30-Dec-14
	
  //Start  of method for get brand wise zone  graph on date 30-Dec-14
  	@SuppressWarnings({ "unchecked", "unchecked" })
  	@Override
      public JSONObject getBrandWiseZoneDetail(String dataSourceName,String month,String brandName) throws RemoteException, ITMException
      {
  		JSONObject rawDataZoneWiseJson = new JSONObject();
  		JSONObject rowData = null;
  		String sql = "";
  		String finYear="";
  		ResultSet rs = null;
  		PreparedStatement pstmt = null;
  		Connection conn = null;
  		ConnDriver connDriver = new ConnDriver();
  		try
  		{
  		if(month!=null && month.trim().length()>0)
  		{
  	    	conn = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;
  			System.out.println("Comming  month inside getBrandWiseZoneDetail ==="+month);					
  			String selectedMonth  = month.substring(4, 6);				
  			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
  			{
  		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
  	    	}
  			else
  			{
  				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
  			}
  			System.out.println("updates month and year from dcoding in getBrandWiseZoneDetail =="+month+"finYear =="+finYear);
  						
  			sql  ="SELECT   b.div_group, CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ZONE_DESCR,BRAND_NAME,BRAND_CODE,"
  					+ " (CASE "
  					+ " WHEN SUBSTR ('"+month+"', 5, 2) = 3    THEN ROUND (0, 1) "
  					+ " WHEN SUBSTR ('"+month+"', 5, 2) < 3    THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
  					+ " ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) END ) AS reqd_mthly, " 
  					+ " ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR ('"+month+"', 5, 2) + 9 "
  					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 END)/ 10000000,1) AS avg_mthly, " 
  					+ " ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
  					+ " ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, " 
					+ "(CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 2) END) AS mth_ach_per, " 
					+ " (CASE WHEN SUM (a.sale_mth_ly) <> 0 THEN ROUND (SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly) * 100,1) " 
					+ " ELSE ROUND (0 * 100, 1) END ) AS mth_gr, "
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt,"
					+ "(CASE WHEN   SUM (a.hotrgt_ytd_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 2) END) AS ytd_ach_per, "
					+ " (CASE WHEN SUM (a.sale_ytd_ly) <> 0 THEN ROUND (  SUM (a.sale_ytd_cy - a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) "
					+ " ELSE ROUND (0 * 100, 1) END ) AS ytd_gr, "
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (  SUM (a.sale_ytd_cy) / 100000/ SUM (c.psr)/ (CASE "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra,"
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ " ELSE ROUND (0 * 100, 1) END) AS retu_ytd_prct " 
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR, "
					+ " SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly, "
					+ " SUM (  trgt_mth_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, "
					+ " SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy, "
					+ " SUM (sale_qrt2_cy) AS sale_qrt2_cy, "
					+ " SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy, "
					+ " SUM (  trgt_annual_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy ,grp_nm AS BRAND_NAME,sub_grp BRAND_CODE"
					+ " FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group AS sub_grp, "
					+ "	sales_item.item_sub_group_descr AS grp_nm, "
					+ "	sm_sales_summ_wide.TERR_CODE,  "
					+ "	SALES_TERRITORY.ZONE_DESCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END ) AS sale_mth_cy,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END ) AS sale_mth_ly,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ "	END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END) AS sale_ytd_ly, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ " END) AS trgt_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) "
					+ "	END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep)- SUM (cy_sale_ytd_jun) END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10'  THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11'  THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01'  THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02'  THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY ,"
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "
					+ " WHERE TRIM (fin_year) = (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN    SUBSTR ('"+month+"' - 100, 1, 4) || '-' || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ "	END) "
					+ "	AND '"+month+"' = '"+month+"' "
					+ "	AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code =  sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ " GROUP BY fin_year, sm_sales_summ_wide.item_ser,sales_item.item_sub_group,sales_item.item_sub_group_descr ,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_DESCR "
					+ "	) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR,sub_grp ,grp_nm) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4  "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS' "
					+ " AND trim(a.brand_name) =TRIM('"+brandName + "')"
					+ " GROUP BY b.div_group,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END,BRAND_NAME,BRAND_CODE "
					+ " HAVING (ROUND (SUM (a.sale_mth_cy) / 10000000, 1) + ROUND (SUM (a.sale_ytd_cy) / 10000000, 1)) <>0 "
					+ " ORDER BY div_group, CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ,BRAND_NAME,BRAND_CODE ";


  			pstmt = conn.prepareStatement(sql);
  			rs = pstmt.executeQuery();
  			int count = 0;			
  			while (rs.next())
  			{
  				rowData = new JSONObject();
  				rowData.put("zone_descr", checkNull(rs.getString("ZONE_DESCR")));
  				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
  				rowData.put("ytd_gr", rs.getString("ytd_gr"));
  				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
  				rowData.put("ytd_ach_per", rs.getString("ytd_ach_per"));  				
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
  				rawDataZoneWiseJson.put(count, rowData);
  				count++;
  				

  			}
  		}
  			System.out.println("fetch Data for brand wise Zone  Detail====" + rawDataZoneWiseJson.toString());

  		} catch (Exception e)
  		{
  			e.printStackTrace();
  			throw new ITMException(e);
  		} finally
  		{
  			try
  			{
  				if (conn != null)
  				{
  					if (rs != null)
  					rs.close();
  					rs = null;
  					if (pstmt != null)
  					pstmt.close();
  					pstmt = null;
  					conn.close();
  					conn = null;
  				}
  				conn = null;
  			} catch (Exception d)
  			{
  				d.printStackTrace();
  				System.out.println("Exception in :SalesPersonSales:getBrandWiseZoneDetail:" + d.getMessage());
  				throw new ITMException(d);
  			}
  		}
  		return rawDataZoneWiseJson;
      }
  	
  	//end of method for get brand wise zone details graph on date 5-Jan-14
    
  //Start  of method for get brand-zone wise metro  graph on date 30-Dec-14
  	@SuppressWarnings({ "unchecked", "unchecked" })
  	@Override
      public JSONObject getBrandZoneWiseMetroDetail(String dataSourceName,String month,String brandName,String zoneDescr,String divDescr) throws RemoteException, ITMException
      {
  		JSONObject rawDataMetroWiseJson = new JSONObject();
  		JSONObject rowData = null;
  		String sql = "";
  		String finYear="";
  		ResultSet rs = null;
  		PreparedStatement pstmt = null;
  		Connection conn = null;
  		ConnDriver connDriver = new ConnDriver();
  		try
  		{
  		if(month!=null && month.trim().length()>0)
  		{
  	    	conn = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;
  			System.out.println("Comming  month inside getBrandZoneWiseMetroDetail ==="+month);					
  			String selectedMonth  = month.substring(4, 6);				
  			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
  			{
  		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
  	    	}
  			else
  			{
  				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
  			}
  			System.out.println("updates month and year from dcoding in getBrandWiseZoneDetail =="+month+"finYear =="+finYear);
  						
  			sql  =" SELECT   b.div_group, b.div_code,b.div_descr,A.ZONE_code,A.ZONE_DESCR,BRAND_NAME,BRAND_CODE, "
					+ "	CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END METRO_DSCR, "
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = 3  THEN ROUND (0, 1) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) < 3  THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ " ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) "
					+ " END) AS reqd_mthly, "
					+ " ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 " 
					+ "	END)/ 10000000,1) AS avg_mthly, "
					+ " ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ " ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, "
					+ "( CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 2) END) AS mth_ach_per, " 
					+ " (CASE WHEN SUM (a.sale_mth_ly) <> 0 THEN ROUND (  SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly)* 100,1) "
					+ "	ELSE ROUND (0 * 100, 1) "
					+ " END) AS mth_gr, "
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt, "
					+ " (CASE WHEN SUM (a.sale_ytd_ly) <> 0 THEN ROUND (  SUM (a.sale_ytd_cy - a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) "
					+ " ELSE ROUND (0 * 100, 1) "
					+ "	END) AS ytd_gr, "
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (SUM (a.sale_ytd_cy)/ 100000/ SUM (c.psr)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3  "
					+ "	END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra, "
					+ " (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 2) END) AS YTD_ach_per, " 
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "	ELSE ROUND (0 * 100, 1) "
					+ " END) AS retu_ytd_prct "
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,grp_nm AS BRAND_NAME,sub_grp BRAND_CODE, "
					+ "	DWH.TERR_DESCR,DWH.METRO_DSCR,SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly,SUM (  trgt_mth_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100 ) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy,SUM (sale_qrt2_cy) AS sale_qrt2_cy,SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy,SUM (  trgt_annual_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ "	FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ "	sales_item.item_sub_group AS sub_grp,sales_item.item_sub_group_descr AS grp_nm,sm_sales_summ_wide.TERR_CODE, "
					+ "	SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR AS METRO_DSCR,"
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END) AS sale_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END) AS sale_mth_ly, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ " END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END ) AS sale_ytd_ly, "                             
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ "	END) AS trgt_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) "
					+ " END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep) - SUM (cy_sale_ytd_jun) "
					+ " END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) "
					+ " END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) "
					+ " END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "
					+ " WHERE TRIM (fin_year) = "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN    SUBSTR ('"+month+"' - 100, 1, 4)  || '-'  || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ " END) "
					+ " AND '"+month+"' = '"+month+"' "
					+ " AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code = sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ "	GROUP BY fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	sales_item.item_sub_group_descr ,SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,DWH.TERR_DESCR,sub_grp ,grp_nm,DWH.METRO_DSCR) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4 "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS'  "
					+ " AND TRIM(a.brand_name) =TRIM('"+ brandName + "')"
					+ " AND TRIM(b.div_descr) =TRIM('"+ divDescr + "')"
					+ " AND TRIM(A.ZONE_descr) = TRIM('" +zoneDescr + "')"
					+ " GROUP BY b.div_group, b.div_code,b.div_descr,A.ZONE_CODE,A.ZONE_DESCR,BRAND_NAME,BRAND_CODE,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END "
					+ " ORDER BY div_group, b.div_code,b.div_descr,A.ZONE_CODE ,BRAND_NAME,BRAND_CODE,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END";


  			pstmt = conn.prepareStatement(sql);
  			rs = pstmt.executeQuery();
  			int count = 0;			
  			while (rs.next())
  			{
  				rowData = new JSONObject();
  				rowData.put("metro_descr", checkNull(rs.getString("METRO_DSCR")));
  				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
  				rowData.put("ytd_gr", rs.getString("ytd_gr"));
  				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
  				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
  				
				//Add new code for Monthly sales dashboard on date7-jan-15 by Dhanendra
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				//Add new new property on date 7-Jan-15 by Birendra Pandey for Month sales graph
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
			   //add new property for  PMPM on 7/01/2015 by Birendra Pandey
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				//End new code for Monthly sales dashboard on date7-jan-15 by Dhanendra
  				rawDataMetroWiseJson.put(count, rowData);
  				count++;
  			}
  		}
  			System.out.println("fetch Data for brand-zone wise Metro  Detail====" + rawDataMetroWiseJson.toString());

  		} catch (Exception e)
  		{
  			e.printStackTrace();
  			throw new ITMException(e);
  		} finally
  		{
  			try
  			{
  				if (conn != null)
  				{
  					if (rs != null)
  					rs.close();
  					rs = null;
  					if (pstmt != null)
  					pstmt.close();
  					pstmt = null;
  					conn.close();
  					conn = null;
  				}
  				conn = null;
  			} catch (Exception d)
  			{
  				d.printStackTrace();
  				System.out.println("Exception in :SalesPersonSales:getBrandZoneWiseMetroDetail:" + d.getMessage());
  				throw new ITMException(d);
  			}
  		}
  		return rawDataMetroWiseJson;
      }
  	
  	//end of method for get brand-zone wise metro details graph on date 5-Jan-14
    
    
    
    
	/***Method:7 - This method will contains Raw data for rendering YTD Sales graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getMnthSalesDivWiseGraphData(String dataSourceName,String month) throws RemoteException, ITMException
	{		
		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String finYear="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			System.out.println("Comming  month inside getMnthSalesDivWiseGraphData ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getMnthSalesDivWiseGraphData =="+month+"finYear =="+finYear);
						
			sql  =" SELECT  b.DIV_NO, b.DIV_DESCR,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) WHEN SUBSTR('"+month+"' ,5,2) <3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy)/(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1)       ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy)/(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY,ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES,ROUND(SUM(a.sale_mth_ly)/10000000,1) AS MTH_LY_SALES,ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,(CASE WHEN SUM(a.sale_mth_ly)<>0 THEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) ELSE ROUND(9.99*100,1)  END) AS MTH_GR,ROUND(SUM (a.sale_mth_cy)/	SUM (a.hotrgt_mth_cy)* 100,2) AS MTH_ACH_PER,ROUND(SUM(a.sale_ytd_cy)/10000000,1) AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES,ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT, (CASE WHEN SUM(a.sale_ytd_ly)<>0 THEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) ELSE ROUND(9.99*100,1)  END) AS YTD_GR, ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1,ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3,ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,2) AS PMPM,round(SUM(b.pmpm_ly),2) AS PMPM_LY,ROUND(SUM(a.sale_ytd_cy)/100000/SUM(c.psr)/(CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END),2) - round(SUM(b.pmpm_ly),2) AS INC_PMPM,ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA,(CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(9.99*100,1) END) AS RETU_YTD_PRCT,sum(b.bud_inc_pmpm) as bud_inc_pmpm FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy,SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy, "
			+" SUM(sale_Qrt2_cy) AS sale_Qrt2_cy,SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy,SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "  
			+" sales_item.item_sub_group AS sub_grp, (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN)WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN)  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) AS trgt_mth_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY)  ELSE  SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy, "  
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE  SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, "          
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) - SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE  SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy, "
			+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY)                          WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN)                          WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT)                          WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV)                          WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC)  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) AS retu_ytd_cy "
			+" FROM SM_SALES_SUMM_WIDE, sales_item WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "              
			+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) AND '"+month+"' ='"+month+"' "                
			+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code AND sales_item.item_sub_group NOT IN ('CU','BJ') "
			+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "    
			+" ) dwh,     SM_SALES_BRAND_MST brnd "  
			+" WHERE brnd.brand_code(+) = dwh.sub_grp    AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
			+" GROUP BY dwh.fin_year, dwh.item_ser ) a, "
			+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr "
			+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR "
			+" FROM starclub.emp_sales WHERE LEVEL_NO = 4 "
			+" GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) GROUP BY finyr, table_no ) c "
			+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year AND trim(a.item_ser)=trim(c.table_no) "
			+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) AND b.DIV_DESCR <> 'OTHERS' GROUP BY b.DIV_NO, b.DIV_DESCR ORDER BY  DIV_NO,DIV_DESCR ";


			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("div_descr", checkNull(rs.getString("DIV_DESCR")));
				rowData.put("mth_sales_val", rs.getString("MTH_CY_SALES"));
				rowData.put("ho_ach", rs.getString("MTH_ACH_PER"));
				rowData.put("gr_perc", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("inc_pmpm", rs.getString("INC_PMPM"));
				rowData.put("bud_inc_pmpm", rs.getString("BUD_INC_PMPM"));
				rowData.put("mth_ly_sales", rs.getString("MTH_LY_SALES"));
				rawDataMnthDivWiseSalesJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for Mnth Sales Div Wise Graph rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getMnthSalesDivWiseGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}
	//end code by swati on dated 5Jul-14	
	
	
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
		
}
