<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="fixedTableHdr('activityTable','','simpleTran')">
<script type="text/javascript" src="/ibase/webitm/js/WavegenWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>

<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>	
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/WavegenWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/FixedTableHeader.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="wavegenWizSummary" id="wavegenWizSummary" METHOD="post" ACTION="">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/wavegeneration.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;Wave Generation
	</div><br></br><br></br>
	<!-- Changed by Santosh on 31/03/2017 to remove horizontal scroll bar -->
	<!-- <div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:100%;position:absolute;z-index:1002;"> -->
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;z-index:1002;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="summaryContainer">
			<table id="activityTable" class="tableClass" border="0" cellSpacing="1" cellPadding="0" style="margin-bottom:25px;">
				<thead class="table-head">
					<tr>
						<th>Wave ID</th>
						<th>Line#</th>
						<th>Ref Series</th>
						<th>Description</th>
						<th>Reference ID</th>
						<th>Status</th>
						<th>PTCN</th>
						<th>Sales Order</th>
						<th>Task Status</th>
					</tr>
				</thead>
				<tbody class="table-body">
					<xsl:for-each select="//summaryData">
						<tr>
							<td nowrap="true"><xsl:value-of select="wave_id"/></td>
							<td nowrap="true" align="right"><xsl:value-of select="line_no"/></td>
							<td nowrap="true"><xsl:value-of select="ref_ser"/></td>
							<td nowrap="true"><xsl:value-of select="descr"/></td>
							<td nowrap="true"><xsl:value-of select="ref_id"/></td>
							<td nowrap="true"><xsl:value-of select="status"/></td>
							<td nowrap="true"><xsl:value-of select="ptcn"/></td>
							<td nowrap="true"><xsl:value-of select="sale_order"/></td>
							<td nowrap="true"><xsl:value-of select="wave_status"/></td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
			<xsl:for-each select="//description">
				<h6><xsl:value-of select="description"/></h6>
			</xsl:for-each>	
		</div>
		<div id="btnDiv" style="width:100%;">
			<input type="button" class="button" value="Home" style="margin-left:2px;" onClick="goToHomePage('wavegen_wiz')"/>
		</div>
	</div>
		<div id="buttonreplacement" style="margin-left:450px;display:none;">
			<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
				 Please wait......
			</img>	
		</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
 
