
create table pallet_hdr
(
tran_id 	char(10) 	not null,
tran_date 	date,
site_code 	char(5) 	not null,tran_type 	char(3),			
loc_code 	char(8),			-- Location Code to be scan i.e from location stock to be moved to AWMS pallet (Palletization). Optional
pallet_type 	char(3), 			-- C - Cage, N - Normal, S - System Cage
inv_stat 	char(1), 			-- A - Approved, E - Expired,  N - Near Expired, D  -  Damaged, H - Hold, R - Rejected
pallet_no  	varchar(30),			-- To pallet No i.e(destination pallet no) AWMS pallet no to transfer the stock
pallet_no__source varchar2(15),			-- It is uses for pallet merging, need to scan the source pallet no
remarks 	varchar2(60),			-- Input remarks
confirmed 	char(1),			-- Confirm to be updated after scanning all the items (Y/N)
conf_date 	date,				-- Confirm Date
emp_code__aprv 	char(10),			-- Employee Code approver
status 		char(1),			-- Current Status -P Pending [Scan status]/Held (H)[waiting for acknowledgment]/Verify (V)(Moved to AWMS)
add_user 	char(10) 	not null,
add_date 	date 		not null,
add_term 	varchar2(15) 	not null,
chg_user 	char(10) 	not null,
chg_date 	date 		not null,
chg_term 	varchar2(15) 	not null  
) TABLESPACE ITM_DIS_D2;

ALTER TABLE pallet_hdr ADD CONSTRAINT PALLET_HDR_X PRIMARY KEY (TRAN_ID) USING INDEX TABLESPACE ITM_DIS_I1;

ALTER TABLE pallet_hdr ADD CONSTRAINT FK_PALLET_HDR_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES SITE (SITE_CODE);
ALTER TABLE pallet_hdr ADD CONSTRAINT FK_PALLET_HDR_EMP_CODE__APRV FOREIGN KEY (emp_code__aprv) REFERENCES employee (emp_code);

create table pallet_det
(
tran_id 	char(10) 	not null,
line_no 	number(3) 	not null,
item_code 	char(10),			-- Item code to be palletized
site_code 	char(5),			-- Site Code
loc_code 	char(8),			-- Location Code
lot_no 		char(15),			-- Lot No
lot_sl 		char(15),			-- Lot serial No
pallet_no 	char(15),			-- To pallet No
quantity 	number(14,3),			-- quantity
no_art 		number(6)			-- No Of article.
) TABLESPACE ITM_DIS_D2;

ALTER TABLE pallet_det ADD CONSTRAINT PALLET_DET_X PRIMARY KEY (tran_id, line_no) USING INDEX TABLESPACE ITM_DIS_I1;

ALTER TABLE pallet_det ADD CONSTRAINT FK_PALLET_DET_ITEM_CODE FOREIGN KEY (item_code) REFERENCES ITEM (item_code);

alter table stock add pallet_no char(15);	-- To Store Pallet no in stock table

alter table siteitem add loc_zone__pref number(3);	-- To store location preference zone in Site table, during execution

alter table pallet_hdr modify (inv_stat char (5));


create table interface2		-- This table will be updated by AWMS
(
In_Out		char(1),	-- C
err_cod		number(2),	-- Error code, if any error in completion 
err_desc	varchar(256), 	-- Error Description (refer section 7) 
msg_stat	char(1),	-- N
trans_dt_ack 	date,		-- Transaction requested Date & Time from SWMS with formatDDMMMYY 
tran_id 	char (12),	-- Transaction ID, Unique no will be generated for each transaction inserted to AWMS.
item_code	char(10),	-- Item code 
descr		varchar2(130),	-- Description of Item 
unit		char(3),	-- Unit of Item 
item_type 	varchar2(10),	-- RM, PM, FG
family_grp	varchar(5),	-- LIQ/SOL/NOR 
ref_ser		char(10),	-- Uniqc ID of Reference Transaction
lot_no		char(6),	-- Lot No. of Item
ref_id		char(15),	-- Reference Transaction Series (PRCP,DRCP, SRET) 
ref_line_no  	number(3),	
lot_sl		char(15),	-- Lot SL of item. For AWMS  Container no will be stored in this column 
quantity	number(17,6),	-- Quantity per article 
no_art 		number(6)	-- No Of article.
exp_date	date,		-- Expiry Date of Item 
mfg_date	date,		-- Manufacturing Date of Item
pallet_no	varchar2(25),	-- Manual Racking Location Number 
pallet_Status	char(1),	-- Pallet is full or partial. Default 'F'ull. 
lock_stat 	char(10),	-- Expired, Near expiry, Damage, Hold, Avilable – Item status 
qc_type 	char(1),	-- Online or offline type (Online Sampling  'N', Offline Sampling 'F' , QC Not Required  'C') 
stro_pref	char(1),	-- S / F / M)
Pallet_Rej	char(1),	-- Y/N 
Pallet_Rej_Desc varchar2(130)	-- Description due to which the Pallet is rejected 
) TABLESPACE ITM_DIS_D2;

ALTER TABLE interface2 ADD CONSTRAINT INTERFACE2_X PRIMARY KEY (tran_id) USING INDEX TABLESPACE ITM_DIS_I1;

ALTER TABLE interface2 ADD CONSTRAINT FK_INTERFACE2_ITEM_CODE FOREIGN KEY (item_code) REFERENCES ITEM (item_code);



INSERT INTO TRANSETUP (TRAN_WINDOW, SAVE_FLAG, VAL_FLAG, KEY_FLAG, KEY_STRING, UDF_1, REPEATE_ADD, CHG_DATE, CHG_USER, CHG_TERM, EDI_OPTION, LEDG_POST_CONF, CHG_DATE_ON_CONF, TRAN_ID_COL, MAIL_OPTION, CONFIRM_MODE, GARBAGE_OPT, TABLE_NAME, APPLICATION, REF_SER, VIEW_MODE, CHILDDATA_ARGOPT, AUDIT_TRAIL_OPT, PERIOD_OPTION, HEADER_FORM_NO) VALUES ('w_palletization', 'A', '2', 'A', 'PZ,seq08', 'Y', 'N', sysdate, 'BASE', 'BASE', '0', 'Y', 'Y', 'TRAN_ID', '0', '0', 'N', 'pallet_hdr', 'WMS', 'PZ', 'F', '2', '0', 'M', '2');

INSERT INTO ITM2MENU (APPLICATION, LEVEL_1, LEVEL_2, LEVEL_3, LEVEL_4, LEVEL_5, WIN_NAME, DESCR, MENU_PATH, ICON_PATH, OBJ_TYPE, CHG_DATE, CHG_TERM, CHG_USER, MOB_DEPLOY) VALUES ('WMS', '1', '67', '0', '0', '0', 'w_palletization', 'Palletization', 'WMS.1.67.0.0.0', 'e12_logo.gif', 'W', sysdate, 'BASE', 'BASE', 'Y');

INSERT INTO OBJ_FORMS (WIN_NAME, TITLE, FORM_NO, SCR_FLAG, SCAN_METADATA, ASSISTED_MODE) VALUES ('w_palletization', 'Palletization', '1', 'F', '<SCAN_INFO><INPUT_SCAN ORDER=1><SCAN_LABEL>Location Code:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD ORDER=0 mandatory=N>loc_code</FIELD></FIELDS></INPUT_SCAN><INPUT_SCAN ORDER=2><SCAN_LABEL>Pallet No Source:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD mandatory=N>pallet_no__source</FIELD></FIELDS></INPUT_SCAN><INPUT_SCAN ORDER=3><SCAN_LABEL>Pallet No:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD>pallet_no</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>', 'A');

INSERT INTO OBJ_FORMS (WIN_NAME, TITLE, FORM_NO, SCR_FLAG, ASSISTED_MODE) VALUES ('w_palletization', 'Header', '2', 'F', 'A');
INSERT INTO OBJ_FORMS (WIN_NAME, TITLE, FORM_NO, SCR_FLAG, SCAN_METADATA, DISP_METADATA, ASSISTED_MODE, DEFAULT_VIEW) VALUES ('w_palletization', 'Detail', '3', 'T', '<SCAN_INFO><MAPPING_SCAN ORDER=1><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER=2><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER=3><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER=1><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR= DELIMITER=><FIELD ORDER=0 mandatory=N>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>', 'checkedImage@img<item_code>,<lot_no>,<lot_sl>,<quantity>', 'E', 'U');

Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',1,'Next','N','Next','1','U',sysdate,'BASE','BASE');
Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',2,'Prev','a','a','P','Prev','2','U',sysdate,'BASE','BASE');
Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',3,'Next','a','a','N','Next','2','U',sysdate,'BASE','BASE');
Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',4,'Prev','a','a','P','Prev','3','U',sysdate,'BASE','BASE');
Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',5,'Saving','S','Finish','3','U',sysdate,'BASE','BASE');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'default_data_wiz', '1', 'palletization_default_data', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'post_item_change', '1', 'poic_default_ejb', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'post_save', '1', 'pos_palletization_finish', '0', TO_DATE('12-OCT-15', 'DD-MON-RR'), 'BASE', 'BASE', '2', 'EJB', 'PalletizationPos');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'pre_navigate_finish', '1', 'pos_palletization_finish', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationPos');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'pre_navigate_next', '1', 'prv_palletization_iss', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'pre_validate', '1', 'prv_palletization_iss', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationIC');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', 'Default Data', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'itemChanged', 'String', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_URI, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_default_ejb', 'http://localhost:9090/axis/services/ValidatorService', 'itemChanged', 'String', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', 'post save ', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'postSave', 'String', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', 'Validation', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'wfValData', 'String', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('palletization_default_data', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('palletization_default_data', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationIC');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '3', 'XML_DATA', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '4', 'XML_DATA_1', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '5', 'XML_DATA_ALL', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '6', 'OBJ_CONTEXT', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '7', 'FOCUSED_COLUMN', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '8', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletization_default_data', '9', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '1', 'COMPONENT_TYPE', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '2', 'COMPONENT_NAME', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '3', 'XML_DATA', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '4', 'XML_DATA_1', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '5', 'XML_DATA_ALL', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '6', 'OBJ_CONTEXT', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '7', 'FOCUSED_COLUMN', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '8', 'EDIT_FLAG', 'I', 'S');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE) VALUES ('poic_default_ejb', '9', 'XTRA_PARAMS', 'I', 'S');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('pos_palletization_finish', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('pos_palletization_finish', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationPos');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', '3', 'XML_DATA_ALL', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', '4', '<tran_id>', 'I', 'B.String', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', '5', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', '6', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('pos_palletization_finish', '7', 'DB_CONN', 'I', 'S.Connection', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletization_iss', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletization_iss', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationIC');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '3', 'XML_DATA', 'l', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '4', 'XML_DATA_1', 'l', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '5', 'XML_DATA_ALL', 'l', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '6', 'OBJ_CONTEXT', 'l', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '7', 'EDIT_FLAG', 'l', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletization_iss', '8', 'XTRA_PARAMS', 'l', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVLPNo ', 'Invalid Loc code/Pallet source', 'Location code or Pallet no source  can not be null', 'E', sysdate, 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTLOCPLT  ', 'Loc/Pallet Scr found same', 'Location Code/Pallet No Source and Pallet No is cannot be same', 'E', 'Y', sysdate, 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('INVPALTSRC', 'Pallet No Src does not exist!', 'Pallet No Source entered does not exist, please enter valid Pallet No Source !', 'E', 'Y', sysdate, 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('INVPALTNO ', 'Pallet No does not exist!', 'Pallet No entered does not exist, please enter valid Pallet No !', 'E', 'Y', sysdate, 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTLOCPLT1 ', 'Loc/Pallet Scr contain value', 'Value should exist for Location Code or Pallet No Source', 'E', 'Y', sysdate, 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VMNULLTT  ', 'Tran type cannot be null', 'Tran type cannot be null', 'E', 'Y', TO_DATE('05-OCT-15', 'DD-MON-RR'), 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VMNULLPT  ', 'Pallet type cannot be null', 'Pallet Type cannot be null', 'E', 'Y', TO_DATE('27-APR-06', 'DD-MON-RR'), 'BASE', 'BASE')

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVAC   ', 'Invalid item for analysis ', 'Scanned item does not bgelong to same analysis class', 'E', TO_DATE('09-OCT-15', 'DD-MON-RR'), 'BASE', 'BASE')


INSERT INTO TRANSETUP (TRAN_WINDOW, SAVE_FLAG, VAL_FLAG, KEY_FLAG, KEY_STRING, UDF_1, REPEATE_ADD, CHG_DATE, CHG_USER, CHG_TERM, EDI_OPTION, LEDG_POST_CONF, CHG_DATE_ON_CONF, TRAN_ID_COL, MAIL_OPTION, CONFIRM_MODE, GARBAGE_OPT, TABLE_NAME, APPLICATION, REF_SER, VIEW_MODE, CHILDDATA_ARGOPT, AUDIT_TRAIL_OPT, PERIOD_OPTION, HEADER_FORM_NO) VALUES ('w_interface2', 'A', '2', 'A', 'seq10', 'Y', 'N', sysdate, 'BASE', 'BASE', '0', 'Y', 'Y', 'TRAN_ID', '0', '0', 'N', 'interface2', 'WMS', 'PZ', 'F', '2', '0', 'M', '1');


UPDATE OBJ_FORMS SET SCAN_METADATA = '<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD ORDER="0" mandatory="N">quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>' where win_name = 'w_palletization' and title = 'Detail';


INSERT INTO TRANSETUP (TRAN_WINDOW, SAVE_FLAG, VAL_FLAG, KEY_FLAG, KEY_STRING, UDF_1, REPEATE_ADD, CHG_DATE, CHG_USER, CHG_TERM, EDI_OPTION, LEDG_POST_CONF, CHG_DATE_ON_CONF, MAIL_OPTION, CONFIRM_MODE, GARBAGE_OPT, APPLICATION, VIEW_MODE, AUDIT_TRAIL_OPT, PERIOD_OPTION) VALUES ('w_palletizationconfirm', 'A', '2', 'M', 'seq10', 'Y', 'N', sysdate, 'BASE', 'BASE', '0', 'Y', 'Y', '0', '0', 'N', 'WMS', 'F', '0', 'M');

INSERT INTO ITM2MENU (APPLICATION, LEVEL_1, LEVEL_2, LEVEL_3, LEVEL_4, LEVEL_5, WIN_NAME, DESCR, MENU_PATH, ICON_PATH, OBJ_TYPE, CHG_DATE, CHG_TERM, CHG_USER, MOB_DEPLOY) VALUES ('WMS', '1', '68', '0', '0', '0', 'w_palletizationconfirm', 'Palletization Confirm', 'WMS.1.68.0.0.0', 'e12_logo.gif', 'W', sysdate, 'BASE', 'BASE', 'Y');

INSERT INTO OBJ_FORMS (WIN_NAME, TITLE, FORM_NO, SCR_FLAG, ASSISTED_MODE) VALUES ('w_palletizationconfirm', 'Submit', '1', 'F', 'A');

Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletizationconfirm',1,'Saving','S','Finish','1','U',sysdate,'BASE','BASE');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletizationconfirm', 'default_data_wiz', '1', 'palletizationconf_default_data', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationConfIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletizationconfirm', 'post_item_change', '1', 'poic_palletizationconf', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationConfIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletizationconfirm', 'pre_navigate_finish', '1', 'prv_palletizationconf', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationConf');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletizationconfirm', 'pre_validate', '1', 'prv_palletizationconf', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationConfIC');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'itemChanged', 'String', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'itemChanged', 'String', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', 'Validation', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'postSave', 'String', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '3', 'XML_DATA', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '4', 'XML_DATA_1', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '5', 'XML_DATA_ALL', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '6', 'OBJ_CONTEXT', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '7', 'FOCUSED_COLUMN', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '8', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('palletizationconf_default_data', '9', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('poic_palletizationconf', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('poic_palletizationconf', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationConfIC');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '3', 'XML_DATA', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '4', 'XML_DATA_1', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '5', 'XML_DATA_2', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '6', 'OBJ_CONTEXT', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '7', 'FOCUSED_COLUMN', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '8', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('poic_palletizationconf', '9', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletizationconf', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletizationconf', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationConf');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', '3', 'XML_DATA_ALL', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', '4', '<tran_id>', 'I', 'B.String', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', '5', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', '6', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconf', '7', 'DB_CONN', 'I', 'S.Connection', sysdate, 'BASE', 'BASE');

INSERT INTO POPHELP (FIELD_NAME, MOD_NAME, SQL_STR, MSG_TITLE, WIDTH, HEIGHT, CHG_DATE, CHG_USER, CHG_TERM, DIST_OPT, SQL_INPUT, HELP_OPTION) VALUES ('TRAN_ID', 'W_PALLETIZATIONCONFIRM', 'SELECT TRAN_ID FROM PALLET_HDR WHERE CONFIRMED = ''N'' AND SITE_CODE = ''?''', 'User-defined Type', '0', '0', sysdate, 'BASE', 'BASE ', '0', ':site_code', '0');

-------------- 26-10-2015 -------------------

update messages set msg_no = 'VTINVLPNO' where msg_no = 'VTINVLPNo';

update messages set msg_no = 'VTNULLTT' where msg_no = 'VMNULLTT';

update messages set msg_no = 'VTNULLPT' where msg_no = 'VMNULLPT';

delete from system_events  where obj_name = 'palletization' and event_code = 'pre_navigate_finish';

drop table interface2;



CREATE TABLE INTERFACE2 
(tran_id char (12), 
item_code char(10), 
descr varchar2(130), 
unit char(3), 
item_type varchar2(10), 
family_grp varchar(5),
In_Out char(1), 
ref_ser char(6), 
ref_id char(10), 
tran_date date,
lot_no char(15),
lot_sl char(15),
quantity number(17,6),
qty_per_art number(14,3),
total_qty number(17,6), 
exp_date date, 
mfg_date date, 
pallet_no varchar2(25),
pallet_status char(1),
msg_stat char(1), 
lock_stat char(10), 
err_cod number(2),
err_desc varchar(256),
qc_type char(1), 
trans_dt_ack date,
stro_pref char(1),
line_no char(3)
);

ALTER TABLE INTERFACE2 ADD ( CONSTRAINT INTERFACE2_X PRIMARY KEY ( TRAN_ID )) ;

CREATE UNIQUE INDEX INTERFACE2_X ON INTERFACE2 (tran_id ) ;

-------------- 27-10-2015 -------------------

update messages set  msg_no = 'VMNULLTT' where msg_no = 'VTNULLTT';

delete from obj_actions where  obj_name = 'palletization' and line_no = '2';


-------------- 29-10-2015 -------------------

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VMTTYPELEN', 'Tran type Length exceeds', 'Transcation type length exceeds the limit', 'E', 'Y', sysdate, 'BASE', 'BASE');

UPDATE MESSAGES SET MSG_STR = 'Blank Pallet No.', MSG_DESCR = 'Pallet Number is blank. Please enter valid Pallet Number' WHERE msg_no = 'VTNLPALLET';

UPDATE MESSAGES SET MSG_DESCR = 'Location code or Pallet no source  can not be blank.' WHERE msg_no = 'VTINVLPNO';

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTPNOLOC', 'PalletSource/LocCode same', 'Location code and Pallet no source  can not be same. Please enter any one.', 'E', sysdate, 'BASE', 'BASE');

UPDATE obj_forms SET SCAN_METADATA = '<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN></SCAN_INFO>' WHERE win_name  = 'w_palletization' and form_no = '3';

UPDATE obj_forms SET SCAN_METADATA = '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Scan Pallet Number:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>pallet_no</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>'  WHERE win_name  = 'w_palletization' and form_no = '1';


UPDATE messages SET MSG_STR = 'Blank Location Code', MSG_DESCR = 'Location code can not be blank.' where msg_no = 'VTINVLPNO';

UPDATE messages SET MSG_STR = 'LocCode, PalletNo found same', MSG_DESCR = 'Location Code and Pallet No is cannot be same' WHERE msg_no = 'VTLOCPLT';

INSERT INTO POPHELP (FIELD_NAME, MOD_NAME, SQL_STR, MSG_TITLE, WIDTH, HEIGHT, CHG_DATE, CHG_USER, CHG_TERM, DIST_OPT, SQL_INPUT, HELP_OPTION) VALUES ('LOC_CODE', 'W_PALLETIZATION', 'select distinct(loc_code) as loc_code from stock where (quantity - (alloc_qty +  hold_qty)) > 0 and site_code = ''?'' ', 'User-defined Type', '0', '0', sysdate, 'BASE', 'BASE', '0', ':site_code', '0');

insert into obj_actions (obj_name, line_no, description, rights_char, title, form_no, action_type, chg_date, chg_term, chg_user ) values ('palletization', '6', 'Deselect Item', 'Q', 'DESELECT', '3', 'U', sysdate, 'BASE', 'BASE');

UPDATE obj_forms SET SCAN_METADATA = '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Enter Location Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></INPUT_SCAN><INPUT_SCAN ORDER="2"><SCAN_LABEL>Scan Pallet Number:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>pallet_no</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>' WHERE win_name  = 'w_palletization' and form_no = '1';

delete from POPHELP where FIELD_NAME = 'LOC_CODE' and MOD_NAME = 'W_PALLETIZATION';

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINOUTPL', 'In/Out request pending', 'In/Out request is pending for this pallet.', 'W', 'Y', sysdate, 'BASE', 'BASE');


------------------- 30-10-2015 -----------------
INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVTID', 'Invalid Tran ID !!', 'Transcation details not present.', 'E', 'Y', sysdate, 'BASE', 'BASE');

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('INVLOCCODE', 'Location code does not exist!', 'Location code entered does not exist, please enter valid location code !', 'E', 'Y', sysdate, 'BASE', 'BASE');

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTNLPALLET', 'Blank Pallet No.', 'Pallet Number is blank.Please enter valid Pallet Number', 'E', 'Y', sysdate, 'BASE', 'BASE');

delete from obj_actions where obj_name = 'palletization' and line_no = '4';


----------------------------- Change on 06-11-2015 (Changes in the requirement) ----------------------------------------

UPDATE OBJ_FORMS SET SCAN_METADATA = '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Scan Pallet Number:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>pallet_no</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>' WHERE win_name = 'w_palletization' and form_no = 1;

INSERT INTO DISPARM (PRD_CODE, VAR_NAME, VAR_TYPE, VAR_VALUE, DESCR, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('999999', 'INVSTAT_FOR_QSTK', 'S', 'GRL,SALE ', 'INV_STAT should be comma (,) seperated and in upper case', sysdate, 'BASE', 'BASE');

update obj_forms set title = 'PZ Header' where win_name = 'w_palletization' and form_no = 2;
update obj_forms set title = 'PZ Detail' where win_name = 'w_palletization' and form_no = 3;
update obj_forms set title = 'PZ Confirm' where win_name = 'w_palletizationconfirm' and form_no = 1;

update messages set msg_descr = 'Scanned item does not belong to same analysis class' where msg_no = 'VTINVAC';

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VMPALLETNO', 'Empty Pallet No.', 'For Palletization, empty pallet is required.', 'E', 'Y', sysdate, 'BASE', 'BASE');
 
UPDATE POPHELP SET SQL_STR='SELECT L.LOC_CODE AS PALLET_NO ,L.DESCR FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND L.SITE_CODE=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY > 0' where MOD_NAME = 'W_PALLET_REQ' and FIELD_NAME = 'PALLET_NO';

update obj_forms set disp_metadata = 'checkedImage@img<item_code>,<item_descr>,<lot_no>,<lot_sl>,<quantity>,<item_unit>' where  win_name = 'w_palletization' and form_no = 3;

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VMNLPALLET', 'Blank Pallet No.', 'Pallet Number is blank.Please enter valid Pallet Number', 'E', 'Y', sysdate, 'BASE', 'BASE');

----------------------------- Change on 26-11-2015 (Configuration changes) ----------------------------------------

update  obj_forms set scan_metadata = '<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Scan Label :</SCAN_LABEL><FIELDS SEPARATOR="D" DELIMITER="-"><FIELD ORDER="1">lot_no</FIELD><FIELD ORDER="2">lot_sl</FIELD></FIELDS></MAPPING_SCAN></SCAN_INFO>' where win_name = 'w_palletization' and form_no = 3;


----------------------------- Change on 27-11-2015 (Changes in the requirement) ----------------------------------------

update obj_forms set scan_metadata = '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Scan Label :</SCAN_LABEL><FIELDS SEPARATOR="D" DELIMITER="-"><FIELD ORDER="1">lot_no</FIELD><FIELD ORDER="2">lot_sl</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>' where win_name = 'w_palletization' and form_no = 3;

update obj_forms set assisted_mode = 'A' where win_name = 'w_palletization' and form_no = 3;

Insert into obj_actions (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) values ('palletization',4,'Add Record','A','Add','3','U',sysdate,'BASE','BASE');

Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME) values ('palletization','3','itm_default_add');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME) values ('palletization','3','lot_sl');
  
INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTLOTBLNK', 'Blank Lot No.', 'Lot No. is blank.Please enter valid Lot Number', 'E', 'Y', sysdate, 'BASE', 'BASE');
INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTLSLBLNK', 'Blank Lot Sl.', 'Lot Sl. is blank.Please enter valid Lot Sl', 'E', 'Y', sysdate, 'BASE', 'BASE');
INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTSMRCD', 'Record exists in Pallet det', 'Same record is scanned already. Same record exists in pallet det table', 'E', 'Y', sysdate, 'BASE', 'BASE');
INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVREC', 'Invalid record.', 'Record not exists in the inventory.', 'E', 'Y', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME) VALUES ('palletization', 'pre_navigate_finish', '1', 'prv_palletizationconfirm', '0', sysdate, 'BASE', 'BASE', '2', 'EJB', 'PalletizationConf');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', 'Validation', 'http://localhost:9090/axis/services/ValidatorService', 'BASE', 'postSave', 'String', 'S', sysdate, 'BASE', 'BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletizationconfirm', '1', 'COMPONENT_TYPE', 'I', 'S', sysdate, 'BASE', 'BASE', 'EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE) VALUES ('prv_palletizationconfirm', '2', 'COMPONENT_NAME', 'I', 'S', sysdate, 'BASE', 'BASE', 'PalletizationConf');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', '3', 'XML_DATA_ALL', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', '4', '<tran_id>', 'I', 'B.String', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', '5', 'EDIT_FLAG', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', '6', 'XTRA_PARAMS', 'I', 'S', sysdate, 'BASE', 'BASE');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, ARG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('prv_palletizationconfirm', '7', 'DB_CONN', 'I', 'S.Connection', sysdate, 'BASE', 'BASE');

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTTRANCONF', 'Transaction Confirm', 'Transaction Confirm', 'P', 'Y', sysdate, 'BASE', 'BASE');

update pophelp set sql_str = 'SELECT TRAN_ID,PALLET_NO FROM PALLET_HDR WHERE CONFIRMED = ''N'' AND SITE_CODE = ''?''' where mod_name = 'W_PALLETIZATIONCONFIRM';

----------------------------- Change on 01-12-2015  ----------------------------------------

CREATE INDEX STOCK_LOC_SITE ON STOCK ( LOC_CODE, SITE_CODE,INV_STAT );

CREATE INDEX LOCATION_LOC_SITE ON LOCATION ( LOC_CODE, SITE_CODE,INV_STAT );

UPDATE OBJ_FORMS SET DISP_METADATA = 'checkedImage@img<item_code>,(<item_descr>),<lot_no>,<lot_sl>,<quantity>,<item_unit>' WHERE win_name = 'w_palletization' and form_no = 3;

----------------------------- Change on 02-12-2015 (Changes in the requirement) ----------------------------------------

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVQCS', 'Invalid QC order status', 'Scanned item doesnot belong to same QC order pending status', 'E', sysdate, 'BASE', 'BASE');

----------------------------- Change on 03-12-2015 (Changes in the requirement) ----------------------------------------

alter table pallet_det add ALLOC_QTY  NUMBER(17,6);

UPDATE MESSAGES SET MSG_STR = 'No records scan found!', MSG_DESCR = 'No records scanned for this transcation.' WHERE msg_no = 'VTINVTID';

UPDATE MESSAGES SET MSG_DESCR = 'Transaction Id cannot be empty' WHERE msg_no = 'VTTRANIDNL';

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVTRID', 'Transaction ID invalid', 'Transaction Id not found!', 'E', 'Y', sysdate, 'BASE', 'BASE');

CREATE UNIQUE INDEX PALLET_DET_IDX ON PALLET_DET (TRAN_ID , ITEM_CODE , LOT_NO , LOT_SL, PALLET_NO);


----------------------------- Change on 08-12-2015 ----------------------------------------

UPDATE OBJ_FORMS SET SCAN_METADATA = '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Scan Label :</SCAN_LABEL><FIELDS SEPARATOR="D" DELIMITER="-"><FIELD ORDER="1">lot_no</FIELD><FIELD ORDER="2">lot_sl</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="lot_no">lot_no =="null" || lot_no == ""</SCAN_CONDITION><SCAN_CONDITION field="lot_sl">lot_sl =="null" || lot_sl == ""</SCAN_CONDITION></SCAN_INFO>' WHERE win_name = 'w_palletization' and form_no = 3;

----------------------------- Change on 24-12-2015  (new requirement) ----------------------------------------

alter table siteitem add qc_sample_type char(1);  -- 1 - On-line, 2 - Off-line
alter table pallet_hdr add pallet_status char(1); --  F  - Full, P - Partial
alter table pallet_det add qc_sample_type char(1); --  -- 1 - On-line, 2 - Off-line

INSERT INTO MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('VTINVQST', 'Invalid QC Sample Type', 'Scanned item doesnot belong to same QC sample type', 'E', sysdate, 'BASE', 'BASE');


----------------------------- Change on 04-01-2016 ----------------------------------------

update obj_forms set assisted_mode = 'E' where win_name = 'w_palletization' and form_no = 1;
  


